const Joi =require('joi')
// const globalNomenclature =require('../../global/globalNomenclature')

class serialPortSchema {

    static openPort() {
        return Joi.object().unknown(true).keys({
            idsNo: Joi.string().trim().required().not('', null, 'undefined'),
            configSetting: Joi.array().required().items(
                Joi.object().required().unknown(true).keys({
                    type: Joi.string().trim().required().not('', null, 'undefined'),
                    portNo: Joi.number().integer().required(),
                    Auto_Tare: Joi.boolean().optional(),
                    Baud_Rate: Joi.number().integer().positive().required(),
                    Bulk_Mode: Joi.number().integer().positive().required(),
                    Data_Bit: Joi.number().integer().positive().required(),
                    Parity: Joi.string().trim().required().valid("None","Even","Odd","Mark","Space").insensitive(),
                    Stop_Bit: Joi.number().integer().min(0).required(),
                    Min_Threshold: Joi.number().optional(),
                    Stability_Threshold: Joi.number().integer().min(0).required(),
                    instrumentId: Joi.string().trim().optional().not('', null, 'undefined'),
                    Tare_Command: Joi.string().trim().optional().not('', null, 'undefined'),
                    Balance_Pattern: Joi.string().trim().optional().not('', null, 'undefined'),
                    Disable: Joi.boolean().optional(),
                    Receive_Timeout: Joi.number().optional(),
                    Zero_Timeout: Joi.number().optional(),
                    Bulk_Data_Sent_Mode: Joi.string().trim().optional().valid("Manual", "Auto"),
                    Bulk_Instrument_Config: Joi.when('Bulk_Data_Sent_Mode', {
                        is: "Manual",
                        then: Joi.object().keys({
                            Data_Count: Joi.number().integer().positive().not('', null, 'undefined'),
                            Instrument_Model: Joi.string().trim().required().not('', null, 'undefined'),
                        })
                    }),
                }))
        })
    }

    static closePort() {
        return Joi.object().unknown(true).keys({
            portNo: Joi.number().positive().required().not('', null, 'undefined'),
            instrumentType: Joi.string().trim().required().not('', null, 'undefined'),
            configSetting: Joi.array().required().items(
                Joi.object().required().unknown(true).keys({
                    type: Joi.string().trim().required().not('', null, 'undefined'),
                    portNo: Joi.number().integer().required(),
                    Auto_Tare: Joi.boolean().optional(),
                    Baud_Rate: Joi.number().integer().positive().required(),
                    Bulk_Mode: Joi.number().integer().positive().required(),
                    Data_Bit: Joi.number().integer().positive().required(),
                    Parity: Joi.string().trim().required().valid("None","Even","Odd","Mark","Space").insensitive(),
                    Stop_Bit: Joi.number().integer().min(0).required(),
                    Min_Threshold: Joi.number().min(0).optional(),
                    Stability_Threshold: Joi.number().integer().min(0).required(),
                    instrumentId: Joi.string().trim().optional().not('', null, 'undefined'),
                    Tare_Command: Joi.string().trim().optional().not('', null, 'undefined'),
                    Disable: Joi.boolean().optional(),
                    Receive_Timeout: Joi.number().integer().optional(),
                    Zero_Timeout: Joi.number().integer().optional(),
                    Bulk_Data_Sent_Mode: Joi.string().trim().optional().valid("Manual", "Auto"),
                    Bulk_Instrument_Config: Joi.when('Bulk_Data_Sent_Mode', {
                        is: "Manual",
                        then: Joi.object().keys({
                            Data_Count: Joi.number().integer().positive().not('', null, 'undefined'),
                            Instrument_Model: Joi.string().trim().required().not('', null, 'undefined'),
                        })
                    }),
                }))
        })
    }

    static balanceCheck() {
        return Joi.object().unknown(true).keys({
            portNo: Joi.number().required().not('', null, 'undefined'),
            configSetting: Joi.array().items(
                Joi.object().unknown(true).keys({
                    type: Joi.string().trim().required().not('', null, 'undefined'),
                    portNo: Joi.number().integer().required(),
                    Auto_Tare: Joi.boolean().optional(),
                    Baud_Rate: Joi.number().integer().positive().required(),
                    Bulk_Mode: Joi.number().integer().positive().required(),
                    Data_Bit: Joi.number().integer().positive().required(),
                    Parity: Joi.string().trim().required().valid("None","Even","Odd","Mark","Space").insensitive(),
                    Stop_Bit: Joi.number().integer().min(0).required(),
                    Min_Threshold: Joi.number().min(0).optional(),
                    Stability_Threshold: Joi.number().integer().min(0).required(),
                    instrumentId: Joi.string().trim().optional().not('', null, 'undefined'),
                    Tare_Command: Joi.string().trim().optional().not('', null, 'undefined'),
                    Disable: Joi.boolean().optional(),
                    Receive_Timeout: Joi.number().integer().optional(),
                    Zero_Timeout: Joi.number().integer().optional(),
                    Bulk_Data_Sent_Mode: Joi.string().trim().optional().valid("Manual", "Auto"),
                    Bulk_Instrument_Config: Joi.when('Bulk_Data_Sent_Mode', {
                        is: "Manual",
                        then: Joi.object().keys({
                            Data_Count: Joi.number().integer().positive().not('', null, 'undefined'),
                            Instrument_Model: Joi.string().trim().required().not('', null, 'undefined'),
                        })
                    }),
                }))
        })
    }

    static sendTareCommand() {
        return Joi.object().unknown(true).keys({
            portNo: Joi.number().required(),
            Tare_Command: Joi.string().trim().optional().not('', null, 'undefined'),
        })
    }

    static dataReceived() {
        return Joi.object().unknown(true).keys({
            portNo: Joi.number().positive().required(),
        })
    }

}

module.exports = serialPortSchema