const joi = require('joi')
const clsSerialPort = require('../model/serialport.model')
const SerialSchema = require("../validation/serialport/serialport.schema")

const serialport = new clsSerialPort()


exports.openPort = (req, res) => {

    const {error, value} = SerialSchema.openPort().validate(req.body)

    if(!error){
        serialport.openPort(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        }).catch(err => {
            console.log(err)
            res.statusCode = 500
            res.send({
                status: "fail",
                message: "Internal Server Error"
            })
        })
    }else{
        res.statusCode = 400;
        let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
        res.send(responseObj);
    }
}

exports.resumePort = (req, res) => {

    // const {error, value} = SerialSchema.resumePort().validate(req.body)

    // if(!error){
        serialport.resumePort(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        }).catch(err => {
            console.log(err)
            res.statusCode = 500
            res.send({
                status: "fail",
                message: "Internal Server Error"
            })
        })
    // }else{
    //     res.statusCode = 400;
    //     let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
    //     res.send(responseObj);
    // }
   
}

exports.pausePort = (req, res) => {

    // const {error, value} = SerialSchema.validate()

    // if(!error){
    serialport.pausePort(req.body)
    .then(result => {
        res.statusCode = 200
        res.send(result)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500
        res.send({
            status: "fail",
            message: "Internal Server Error"
        })
    })
// }else{
//     res.statusCode = 400;
//     let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
//     res.send(responseObj);
// }

}

exports.closePort = (req, res) => {

    const {error, value} = SerialSchema.closePort().validate(req.body)

    if(!error){
        serialport.closePort(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
                console.log(err)
                res.statusCode = 500
                res.send({
                    status: "fail",
                    message: "Internal Server Error"
                })
            })
    }else{
        res.statusCode = 400;
        let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
        res.send(responseObj);
    }
}

exports.balanceCheck = (req, res) => {
    
    const {error, value} = SerialSchema.balanceCheck().validate(req.body)

    if(!error){
        serialport.balanceCheck(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
                console.log(err)
                res.statusCode = 500
                res.send({
                    status: "fail",
                    message: "Internal Server Error"
                })
            })
        }else{
            res.statusCode = 400;
            let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
            res.send(responseObj);
        }
}

exports.dataReceived = (req, res) => {

    const {error, value} = SerialSchema.dataReceived().validate(req.body)

    if(!error){
        serialport.dataReceived(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
                console.log(err)
                res.statusCode = 500
                res.send({
                    status: "fail",
                    message: "Internal Server Error"
                })
})
}else{
    res.statusCode = 400;
    let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
    res.send(responseObj);
}
}

