/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterContainer;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.ExporterFilterFactoryUtil;
import net.sf.jasperreports.engine.export.JRExporterContext;

public class DefaultExporterFilterFactory
implements ExporterFilterFactory {
    public static final String PROPERTY_EXPORTER_FILTER_FACTORY_PREFIX = "net.sf.jasperreports.export.filter.factory.";

    @Override
    public ExporterFilter getFilter(JRExporterContext exporterContext) throws JRException {
        List<ExporterFilterFactory> factories = this.getAllFilterFactories(exporterContext.getJasperReportsContext(), exporterContext.getExportedReport());
        ArrayList<ExporterFilter> filters = new ArrayList<ExporterFilter>(factories.size());
        for (ExporterFilterFactory factory : factories) {
            ExporterFilter filter = factory.getFilter(exporterContext);
            if (filter == null) continue;
            filters.add(filter);
        }
        ExporterFilter filter = filters.isEmpty() ? null : (filters.size() == 1 ? (ExporterFilter)filters.get(0) : new ExporterFilterContainer(filters));
        return filter;
    }

    protected List<ExporterFilterFactory> getAllFilterFactories(JasperReportsContext jasperReportsContext, JasperPrint report) throws JRException {
        List<JRPropertiesUtil.PropertySuffix> factoryProps = JRPropertiesUtil.getInstance(jasperReportsContext).getAllProperties(report, PROPERTY_EXPORTER_FILTER_FACTORY_PREFIX);
        ArrayList<ExporterFilterFactory> factories = new ArrayList<ExporterFilterFactory>(factoryProps.size());
        for (JRPropertiesUtil.PropertySuffix prop : factoryProps) {
            ExporterFilterFactory factory = this.getFilterFactory(prop.getValue());
            factories.add(factory);
        }
        return factories;
    }

    protected List<ExporterFilterFactory> getAllFilterFactories(JasperPrint report) throws JRException {
        return this.getAllFilterFactories(DefaultJasperReportsContext.getInstance(), report);
    }

    protected ExporterFilterFactory getFilterFactory(String factoryClassName) throws JRException {
        return ExporterFilterFactoryUtil.getFilterFactory(factoryClassName);
    }
}

