<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function equalText

Check equality of two strings. Comparison is case sensitive.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.equalText(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | string &#124; Array &#124; DenseMatrix | First string to compare
`y` | string &#124; Array &#124; DenseMatrix | Second string to compare

### Returns

Type | Description
---- | -----------
number &#124; Array &#124; DenseMatrix | Returns true if the values are equal, and false if not.


## Examples

```js
math.equalText('Hello', 'Hello')     // returns true
math.equalText('a', 'A')             // returns false
math.equal('2e3', '2000')            // returns true
math.equalText('2e3', '2000')        // returns false

math.equalText('B', ['A', 'B', 'C']) // returns [false, true, false]
```


## See also

[equal](equal.md),
[compareText](compareText.md),
[compare](compare.md),
[compareNatural](compareNatural.md)
