/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.export.MatcherExportFilterMapping;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.ListExtensionRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatcherExportFilterMappingExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final Log log = LogFactory.getLog(MatcherExportFilterMappingExtensionsRegistryFactory.class);
    public static final String MATCHER_EXPORT_FILTER_MAPPING_PROPERTY_PREFIX = "net.sf.jasperreports.extension.matcher.export.filter.";
    public static final String MATCHER_EXPORT_FILTER_MAPPING_INCLUDES_PROPERTY_SUFFIX = ".includes";
    public static final String MATCHER_EXPORT_FILTER_MAPPING_EXCLUDES_PROPERTY_SUFFIX = ".excludes";

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        List<JRPropertiesUtil.PropertySuffix> exportFilterMappingProperties = JRPropertiesUtil.getProperties(properties, MATCHER_EXPORT_FILTER_MAPPING_PROPERTY_PREFIX);
        ArrayList<MatcherExportFilterMapping> exportFilterMappings = new ArrayList<MatcherExportFilterMapping>();
        for (JRPropertiesUtil.PropertySuffix exportFilterMappingProp : exportFilterMappingProperties) {
            String exporterKey = null;
            boolean isIncludes = true;
            String propSuffix = exportFilterMappingProp.getSuffix();
            if (propSuffix.endsWith(MATCHER_EXPORT_FILTER_MAPPING_INCLUDES_PROPERTY_SUFFIX)) {
                exporterKey = propSuffix.substring(0, propSuffix.length() - MATCHER_EXPORT_FILTER_MAPPING_INCLUDES_PROPERTY_SUFFIX.length());
                isIncludes = true;
            } else if (propSuffix.endsWith(MATCHER_EXPORT_FILTER_MAPPING_EXCLUDES_PROPERTY_SUFFIX)) {
                exporterKey = propSuffix.substring(0, propSuffix.length() - MATCHER_EXPORT_FILTER_MAPPING_EXCLUDES_PROPERTY_SUFFIX.length());
                isIncludes = false;
            }
            if (exporterKey == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Matcher mapping property suffix is invalid : " + propSuffix));
                continue;
            }
            exportFilterMappings.add(new MatcherExportFilterMapping(exporterKey, exportFilterMappingProp.getValue(), isIncludes));
        }
        return new ListExtensionRegistry(MatcherExportFilterMapping.class, exportFilterMappings);
    }
}

