/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ExceptionHandler;
import oracle.toplink.essentials.exceptions.IntegrityChecker;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.databaseaccess.Platform;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.helper.QueryCounter;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapManager;
import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.CommitManager;
import oracle.toplink.essentials.internal.sessions.IdentityMapAccessor;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.DefaultSessionLog;
import oracle.toplink.essentials.logging.SessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.DoesExistQuery;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.queryframework.UpdateObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.ExternalTransactionController;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.SessionEventManager;
import oracle.toplink.essentials.sessions.SessionProfiler;
import oracle.toplink.essentials.sessions.UnitOfWork;
import oracle.toplink.essentials.threetier.ClientSession;

public abstract class AbstractSession
implements Session,
Serializable,
Cloneable {
    protected transient ExceptionHandler exceptionHandler;
    protected transient IntegrityChecker integrityChecker;
    protected transient Project project;
    protected transient ConcurrencyManager transactionMutex;
    protected IdentityMapAccessor identityMapAccessor;
    protected boolean wasJTSTransactionInternallyStarted;
    protected transient Accessor accessor;
    protected transient Platform platform;
    protected transient Map queries;
    protected transient List ejbqlPlaceHolderQueries;
    protected transient CommitManager commitManager;
    protected transient SessionProfiler profiler;
    protected transient AbstractSession broker;
    protected String name;
    protected transient int numberOfActiveUnitsOfWork;
    protected transient SessionLog sessionLog;
    protected transient String logSessionString;
    protected transient SessionEventManager eventManager;
    protected Map properties;
    protected transient ExternalTransactionController externalTransactionController;
    protected transient ClassDescriptor lastDescriptorAccessed;
    public boolean isInProfile;

    protected AbstractSession() {
        this.name = "";
        this.initializeIdentityMapAccessor();
        this.numberOfActiveUnitsOfWork = 0;
    }

    protected AbstractSession(int nothing) {
    }

    public AbstractSession(Login login) {
        this(new Project(login));
    }

    public AbstractSession(Project project) {
        this();
        this.project = project;
        if (project.getDatasourceLogin() == null) {
            throw ValidationException.projectLoginIsNull(this);
        }
    }

    public long getNextQueryId() {
        return QueryCounter.getCount();
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork() {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        UnitOfWorkImpl unitOfWork = new UnitOfWorkImpl(this);
        if (this.shouldLog(2, "transaction")) {
            this.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(unitOfWork)));
        }
        return unitOfWork;
    }

    public UnitOfWork acquireUnitOfWork() {
        UnitOfWorkImpl unitOfWork = this.acquireNonSynchronizedUnitOfWork();
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        this.project.addAlias(alias, descriptor);
    }

    public void addQuery(String name, DatabaseQuery query) {
        query.setName(name);
        this.addQuery(query);
    }

    public void addEjbqlPlaceHolderQuery(DatabaseQuery query) {
        this.getEjbqlPlaceHolderQueries().add(query);
    }

    protected void addQuery(DatabaseQuery query) {
        Vector queriesByName = (Vector)this.getQueries().get(query.getName());
        if (queriesByName == null) {
            queriesByName = NonSynchronizedVector.newInstance();
            this.getQueries().put(query.getName(), queriesByName);
        }
        Enumeration enumtr = queriesByName.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseQuery existingQuery = (DatabaseQuery)enumtr.nextElement();
            if (!Helper.areTypesAssignable(query.getArgumentTypes(), existingQuery.getArgumentTypes())) continue;
            throw ValidationException.existingQueryTypeConflict(query, existingQuery);
        }
        queriesByName.add(query);
    }

    protected void basicBeginTransaction() throws DatabaseException {
        try {
            this.getAccessor().beginTransaction(this);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public void afterTransaction(boolean committed, boolean isExternalTransaction) {
    }

    protected void basicCommitTransaction() throws DatabaseException {
        try {
            this.getAccessor().commitTransaction(this);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        try {
            this.getAccessor().rollbackTransaction(this);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public boolean beginExternalTransaction() {
        boolean externalTransactionHasBegun = false;
        if (this.hasExternalTransactionController() && !this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().beginTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasBegun = true;
                this.log(2, "transaction", "external_transaction_has_begun_internally");
            }
        }
        return externalTransactionHasBegun;
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.isInTransaction()) {
            this.beginExternalTransaction();
        }
        if (this.isUnitOfWork() || this.isClientSession()) {
            this.getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        this.getTransactionMutex().acquire();
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preBeginTransaction();
            this.basicBeginTransaction();
            this.getEventManager().postBeginTransaction();
        }
    }

    public void clearIntegrityChecker() {
        this.setIntegrityChecker(null);
    }

    public void clearLastDescriptorAccessed() {
        this.lastDescriptorAccessed = null;
    }

    public void clearProfile() {
        this.setProfiler(null);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean commitExternalTransaction() {
        boolean externalTransactionHasCommitted = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().commitTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasCommitted = true;
                this.log(2, "transaction", "external_transaction_has_committed_internally");
            }
        }
        return externalTransactionHasCommitted;
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preCommitTransaction();
            this.basicCommitTransaction();
            this.getEventManager().postCommitTransaction();
        }
        this.getTransactionMutex().release();
        if (!this.isInTransaction()) {
            this.commitExternalTransaction();
        }
    }

    public boolean compareObjects(Object firstObject, Object secondObject) {
        if (firstObject == null && secondObject == null) {
            return true;
        }
        if (firstObject == null || secondObject == null) {
            return false;
        }
        if (!firstObject.getClass().equals(secondObject.getClass())) {
            return false;
        }
        ObjectBuilder builder = this.getDescriptor(firstObject.getClass()).getObjectBuilder();
        return builder.compareObjects(builder.unwrapObject(firstObject, this), builder.unwrapObject(secondObject, this), this);
    }

    public boolean compareObjectsDontMatch(Object firstObject, Object secondObject) {
        return !this.compareObjects(firstObject, secondObject);
    }

    public boolean containsQuery(String queryName) {
        return this.getQueries().containsKey(queryName);
    }

    public Object copyObject(Object original) {
        return this.copyObject(original, new ObjectCopyingPolicy());
    }

    public Object copyObject(Object original, ObjectCopyingPolicy policy) {
        if (original == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(original);
        if (descriptor == null) {
            return original;
        }
        policy.setSession(this);
        return descriptor.getObjectBuilder().copyObject(original, policy);
    }

    public Vector copyReadOnlyClasses() {
        return this.getDefaultReadOnlyClasses();
    }

    public void deleteAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.deleteObject(objectsEnum.next());
        }
    }

    public void deleteAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    public Object deleteObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setObject(domainObject);
        return this.executeQuery(query);
    }

    public boolean doesObjectExist(Object object) throws DatabaseException {
        DoesExistQuery query = new DoesExistQuery();
        query.setObject(object);
        query.checkDatabaseForDoesExist();
        return (Boolean)this.executeQuery(query);
    }

    public void dontLogMessages() {
        this.setLogLevel(8);
    }

    public void endOperationProfile(String operationName) {
        if (this.isInProfile()) {
            this.getProfiler().endOperationProfile(operationName);
        }
    }

    public void updateProfile(String operationName, Object value) {
        if (this.isInProfile()) {
            this.getProfiler().update(operationName, value);
        }
    }

    public void incrementProfile(String operationName) {
        if (this.isInProfile()) {
            this.getProfiler().occurred(operationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (query.getAccessor() == null) {
            query.setAccessor(this.getAccessor());
        }
        try {
            Object object = query.getAccessor().executeCall(call, translationRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
            }
        }
    }

    public int executeNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        Integer value = (Integer)this.executeQuery(query);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void executeNonSelectingSQL(String sqlString) throws DatabaseException {
        this.executeNonSelectingCall(new SQLCall(sqlString));
    }

    public Object executeQuery(String queryName) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query);
    }

    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query);
    }

    public Object executeQuery(String queryName, Class domainClass, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query, argumentValues);
    }

    public Object executeQuery(String queryName, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, argumentValues);
    }

    public Object executeQuery(String queryName, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, argumentValues);
    }

    public Object executeQuery(String queryName, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, argumentValues);
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query, argumentValues);
    }

    public Object executeQuery(DatabaseQuery query) throws DatabaseException {
        return this.executeQuery(query, new DatabaseRecord(1));
    }

    public Object executeQuery(DatabaseQuery query, Vector argumentValues) throws DatabaseException {
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        AbstractRecord row = query.rowFromArguments(argumentValues);
        return this.executeQuery(query, row);
    }

    public Object executeQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException {
        if (this.hasBroker() && (!query.isDataModifyQuery() && !query.isDataReadQuery() || query.getSessionName() != null)) {
            return this.getBroker().executeQuery(query, row);
        }
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        this.log(1, "query", "execute_query", query);
        try {
            this.getEventManager().preExecuteQuery(query);
            Object result = this.isInProfile() ? this.getProfiler().profileExecutionOfQuery(query, row, this) : this.internalExecuteQuery(query, row);
            this.getEventManager().postExecuteQuery(query, result);
            return result;
        }
        catch (RuntimeException exception) {
            if (exception instanceof QueryException) {
                QueryException queryException = (QueryException)exception;
                if (queryException.getQuery() == null) {
                    queryException.setQuery(query);
                }
                if (queryException.getQueryArgumentsRecord() == null) {
                    queryException.setQueryArguments(row);
                }
                if (queryException.getSession() == null) {
                    queryException.setSession(this);
                }
            } else if (exception instanceof DatabaseException) {
                DatabaseException databaseException = (DatabaseException)exception;
                if (databaseException.getQuery() == null) {
                    databaseException.setQuery(query);
                }
                if (databaseException.getQueryArgumentsRecord() == null) {
                    databaseException.setQueryArguments(row);
                }
                if (databaseException.getSession() == null) {
                    databaseException.setSession(this);
                }
            }
            return this.handleException(exception);
        }
    }

    public Vector executeSelectingCall(Call call) throws DatabaseException {
        DataReadQuery query = new DataReadQuery();
        query.setCall(call);
        return (Vector)this.executeQuery(query);
    }

    public Vector executeSQL(String sqlString) throws DatabaseException {
        return this.executeSelectingCall(new SQLCall(sqlString));
    }

    public synchronized Accessor getAccessor() {
        if (this.accessor == null && this.project != null && this.project.getDatasourceLogin() != null) {
            this.accessor = this.project.getDatasourceLogin().buildAccessor();
        }
        return this.accessor;
    }

    public Accessor getAccessor(Class domainClass) {
        return this.getAccessor();
    }

    public Accessor getAccessor(String sessionName) {
        return this.getAccessor();
    }

    public Session getActiveSession() {
        Session activeSession = this.getActiveUnitOfWork();
        if (activeSession == null) {
            activeSession = this;
        }
        return activeSession;
    }

    public UnitOfWork getActiveUnitOfWork() {
        if (this.hasExternalTransactionController()) {
            return this.getExternalTransactionController().getActiveUnitOfWork();
        }
        if (this.isClientSession()) {
            return ((ClientSession)this).getParent().getActiveUnitOfWork();
        }
        return null;
    }

    public Map getAliasDescriptors() {
        return this.project.getAliasDescriptors();
    }

    public AbstractSession getBroker() {
        return this.broker;
    }

    public AbstractSession getRootSession(DatabaseQuery query) {
        return this.getParentIdentityMapSession(query, false, true);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query) {
        return this.getParentIdentityMapSession(query, false, false);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        return this;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this;
    }

    public CommitManager getCommitManager() {
        if (this.hasBroker()) {
            return this.getBroker().getCommitManager();
        }
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
        }
        return this.commitManager;
    }

    public Vector getDefaultReadOnlyClasses() {
        if (this.hasBroker()) {
            return this.getBroker().getDefaultReadOnlyClasses();
        }
        return this.getProject().getDefaultReadOnlyClasses();
    }

    public ClassDescriptor getClassDescriptor(Class theClass) {
        ClassDescriptor desc = this.getDescriptor(theClass);
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public ClassDescriptor getClassDescriptor(Object domainObject) {
        ClassDescriptor desc = this.getDescriptor(domainObject);
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public ClassDescriptor getClassDescriptorForAlias(String alias) {
        ClassDescriptor desc = this.getDescriptorForAlias(alias);
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public ClassDescriptor getDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        ClassDescriptor lastDescriptor = this.lastDescriptorAccessed;
        if (lastDescriptor != null && lastDescriptor.getJavaClass().equals(theClass)) {
            return lastDescriptor;
        }
        ClassDescriptor descriptor = (ClassDescriptor)this.getDescriptors().get(theClass);
        if (descriptor == null && this.hasBroker()) {
            descriptor = this.getBroker().getDescriptor(theClass);
        }
        if (descriptor == null) {
            this.getEventManager().missingDescriptor(theClass);
            descriptor = (ClassDescriptor)this.getDescriptors().get(theClass);
        }
        if (descriptor == null && !theClass.isInterface()) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int index = 0; index < interfaces.length; ++index) {
                Class<?> interfaceClass = interfaces[index];
                descriptor = this.getDescriptor(interfaceClass);
                if (descriptor == null) continue;
                this.getDescriptors().put(interfaceClass, descriptor);
                break;
            }
            if (descriptor == null) {
                descriptor = this.getDescriptor(theClass.getSuperclass());
            }
        }
        this.lastDescriptorAccessed = descriptor;
        return descriptor;
    }

    public ClassDescriptor getDescriptor(Object domainObject) {
        return this.getDescriptor(domainObject.getClass());
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        return this.project.getDescriptorForAlias(alias);
    }

    public Map getDescriptors() {
        return this.getProject().getDescriptors();
    }

    public List getEjbqlPlaceHolderQueries() {
        if (this.ejbqlPlaceHolderQueries == null) {
            this.ejbqlPlaceHolderQueries = new Vector();
        }
        return this.ejbqlPlaceHolderQueries;
    }

    public synchronized SessionEventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new SessionEventManager(this);
        }
        return this.eventManager;
    }

    public String getExceptionHandlerClass() {
        String className = null;
        try {
            className = this.getExceptionHandler().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
        return className;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ExternalTransactionController getExternalTransactionController() {
        return this.externalTransactionController;
    }

    public oracle.toplink.essentials.sessions.IdentityMapAccessor getIdentityMapAccessor() {
        return this.identityMapAccessor;
    }

    public IdentityMapAccessor getIdentityMapAccessorInstance() {
        return this.identityMapAccessor;
    }

    public IntegrityChecker getIntegrityChecker() {
        if (this.integrityChecker == null) {
            this.integrityChecker = new IntegrityChecker();
        }
        return this.integrityChecker;
    }

    public Writer getLog() {
        return this.getSessionLog().getWriter();
    }

    public String getLogSessionString() {
        if (this.logSessionString == null) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSessionTypeString());
            writer.write("(");
            writer.write(String.valueOf(System.identityHashCode(this)));
            writer.write(")");
            this.logSessionString = writer.toString();
        }
        return this.logSessionString;
    }

    public String getSessionTypeString() {
        return Helper.getShortClassName(this.getClass());
    }

    public DatabaseLogin getLogin() {
        try {
            return (DatabaseLogin)this.getDatasourceLogin();
        }
        catch (ClassCastException wrongType) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    public Login getDatasourceLogin() {
        return this.getProject().getDatasourceLogin();
    }

    public String getName() {
        return this.name;
    }

    public Number getNextSequenceNumberValue(Class domainClass) {
        return (Number)this.getSequencing().getNextValue(domainClass);
    }

    public int getNumberOfActiveUnitsOfWork() {
        return this.numberOfActiveUnitsOfWork;
    }

    public DatabasePlatform getPlatform() {
        return this.getDatasourceLogin().getPlatform();
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getDatasourcePlatform();
        }
        return this.platform;
    }

    public ServerPlatform getServerPlatform() {
        return null;
    }

    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            this.platform = this.getDatasourcePlatform();
        }
        return this.platform;
    }

    public SessionProfiler getProfiler() {
        return this.profiler;
    }

    public Project getProject() {
        return this.project;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public Map getQueries() {
        if (this.queries == null) {
            this.queries = new HashMap(5);
        }
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector allQueries = new Vector();
        Iterator vectors = this.getQueries().values().iterator();
        while (vectors.hasNext()) {
            allQueries.addAll((Vector)vectors.next());
        }
        return allQueries;
    }

    public DatabaseQuery getQuery(String name) {
        return this.getQuery(name, null);
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        Vector queries = (Vector)this.getQueries().get(name);
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        if (queries.size() == 1) {
            return (DatabaseQuery)queries.firstElement();
        }
        int argumentTypesSize = 0;
        if (arguments != null) {
            argumentTypesSize = arguments.size();
        }
        Vector argumentTypes = new Vector(argumentTypesSize);
        for (int i = 0; i < argumentTypesSize; ++i) {
            argumentTypes.addElement(arguments.elementAt(i).getClass());
        }
        Enumeration queriesEnum = queries.elements();
        while (queriesEnum.hasMoreElements()) {
            DatabaseQuery query = (DatabaseQuery)queriesEnum.nextElement();
            if (!Helper.areTypesAssignable(argumentTypes, query.getArgumentTypes())) continue;
            return query;
        }
        return null;
    }

    public Sequencing getSequencing() {
        return null;
    }

    public AbstractSession getSessionForClass(Class domainClass) {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForClass(domainClass);
        }
        return this;
    }

    public SessionLog getSessionLog() {
        if (this.sessionLog == null) {
            this.setSessionLog(new DefaultSessionLog());
        }
        return this.sessionLog;
    }

    public synchronized ConcurrencyManager getTransactionMutex() {
        if (this.transactionMutex == null) {
            this.transactionMutex = new ConcurrencyManager();
        }
        return this.transactionMutex;
    }

    public Object handleException(RuntimeException exception) throws RuntimeException {
        if (exception instanceof TopLinkException) {
            TopLinkException topLinkException = (TopLinkException)exception;
            if (topLinkException.getSession() == null) {
                topLinkException.setSession(this);
            }
            if (!topLinkException.hasBeenLogged()) {
                this.logThrowable(6, null, exception);
                topLinkException.setHasBeenLogged(true);
            }
        } else {
            this.logThrowable(6, null, exception);
        }
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    public boolean hasDescriptor(Class theClass) {
        if (theClass == null) {
            return false;
        }
        return this.getDescriptors().get(theClass) != null;
    }

    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    public boolean hasExternalTransactionController() {
        return this.externalTransactionController != null;
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object insertObject(Object domainObject) throws DatabaseException {
        InsertObjectQuery query = new InsertObjectQuery();
        query.setObject(domainObject);
        return this.executeQuery(query);
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException {
        return query.execute(this, databaseRow);
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isInBroker() {
        return false;
    }

    public boolean isClassReadOnly(Class theClass) {
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        return this.isClassReadOnly(theClass, descriptor);
    }

    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        if (theClass != null) {
            return this.getDefaultReadOnlyClasses().contains(theClass);
        }
        return false;
    }

    public boolean isClientSession() {
        return false;
    }

    public boolean isConnected() {
        if (this.getAccessor() == null) {
            return false;
        }
        return this.getAccessor().isConnected();
    }

    public boolean isDatabaseSession() {
        return false;
    }

    public boolean isDistributedSession() {
        return false;
    }

    public boolean isInProfile() {
        return this.isInProfile;
    }

    public void setIsInProfile(boolean inProfile) {
        this.isInProfile = inProfile;
    }

    public boolean isInTransaction() {
        return this.getTransactionMutex().isAcquired();
    }

    public boolean isRemoteSession() {
        return false;
    }

    public boolean isRemoteUnitOfWork() {
        return false;
    }

    public boolean isServerSession() {
        return false;
    }

    public boolean isSessionBroker() {
        return false;
    }

    public boolean isUnitOfWork() {
        return false;
    }

    public Vector keyFromObject(Object domainObject) throws ValidationException {
        ClassDescriptor descriptor = this.getDescriptor(domainObject);
        return this.keyFromObject(domainObject, descriptor);
    }

    public Vector keyFromObject(Object domainObject, ClassDescriptor descriptor) throws ValidationException {
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(domainObject.getClass().getName());
        }
        Object implemention = descriptor.getObjectBuilder().unwrapObject(domainObject, this);
        if (implemention == null) {
            return null;
        }
        return descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implemention, this);
    }

    public void log(SessionLogEntry entry) {
        if (this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            if (entry.getSession() == null) {
                entry.setSession(this);
            }
            this.getSessionLog().log(entry);
        }
    }

    public void logMessage(String message) {
        this.log(2, message, (Object[])null, null, false);
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery query) {
        if (!this.isUnitOfWork() && query.isObjectLevelReadQuery()) {
            return ((ObjectLevelReadQuery)query).prepareOutsideUnitOfWork(this);
        }
        return query;
    }

    public void processEJBQLQueries() {
        List queries = this.getEjbqlPlaceHolderQueries();
        this.processEJBQLQueries(queries);
        queries.clear();
    }

    public void processEJBQLQueries(List queries) {
        for (EJBQLPlaceHolderQuery existingQuery : queries) {
            this.addQuery(existingQuery.processEjbQLQuery(this));
        }
    }

    public Vector readAllObjects(Class domainClass) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        return (Vector)this.executeQuery(query);
    }

    public Vector readAllObjects(Class domainClass, String sqlString) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        return (Vector)this.executeQuery(query);
    }

    public Vector readAllObjects(Class referenceClass, Call aCall) throws DatabaseException {
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(referenceClass);
        raq.setCall(aCall);
        return (Vector)this.executeQuery(raq);
    }

    public Vector readAllObjects(Class domainClass, Expression expression) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        return (Vector)this.executeQuery(query);
    }

    public Object readObject(Class domainClass) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        return this.executeQuery(query);
    }

    public Object readObject(Class domainClass, String sqlString) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        return this.executeQuery(query);
    }

    public Object readObject(Class domainClass, Call aCall) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setCall(aCall);
        return this.executeQuery(query);
    }

    public Object readObject(Class domainClass, Expression expression) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        return this.executeQuery(query);
    }

    public Object readObject(Object object) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        return this.executeQuery(query);
    }

    public Object refreshAndLockObject(Object object) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.refreshIdentityMapResult();
        query.cascadePrivateParts();
        query.setLockMode((short)1);
        return this.executeQuery(query);
    }

    public Object refreshAndLockObject(Object object, short lockMode) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.refreshIdentityMapResult();
        query.cascadePrivateParts();
        query.setLockMode(lockMode);
        return this.executeQuery(query);
    }

    public Object refreshObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)0);
    }

    public void release() {
    }

    public void releaseUnitOfWork(UnitOfWorkImpl unitOfWork) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() - 1);
    }

    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    public void removeQuery(String queryName) {
        this.getQueries().remove(queryName);
    }

    public void removeQuery(String queryName, Vector argumentTypes) {
        Vector queries = (Vector)this.getQueries().get(queryName);
        if (queries == null) {
            return;
        }
        DatabaseQuery query = null;
        Enumeration enumtr = queries.elements();
        while (enumtr.hasMoreElements() && !Helper.areTypesAssignable(argumentTypes, (query = (DatabaseQuery)enumtr.nextElement()).getArgumentTypes())) {
        }
        if (query != null) {
            queries.remove(query);
        }
    }

    protected boolean rollbackExternalTransaction() {
        boolean externalTransactionHasRolledBack = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().rollbackTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasRolledBack = true;
                this.log(2, "transaction", "external_transaction_has_rolled_back_internally");
            }
        }
        return externalTransactionHasRolledBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        try {
            if (!this.getTransactionMutex().isNested()) {
                this.getEventManager().preRollbackTransaction();
                this.basicRollbackTransaction();
                this.getEventManager().postRollbackTransaction();
            }
        }
        finally {
            this.getTransactionMutex().release();
            if (!this.isInTransaction()) {
                this.rollbackExternalTransaction();
            }
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setBroker(AbstractSession broker) {
        this.broker = broker;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public void setEventManager(SessionEventManager eventManager) {
        this.eventManager = eventManager != null ? eventManager : new SessionEventManager();
        this.eventManager.setSession(this);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        this.externalTransactionController = externalTransactionController;
        if (externalTransactionController == null) {
            return;
        }
        externalTransactionController.setSession(this);
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public void setLog(Writer log) {
        this.getSessionLog().setWriter(log);
    }

    public void setLogin(DatabaseLogin login) {
        this.setDatasourceLogin(login);
    }

    public void setLogin(Login login) {
        this.setDatasourceLogin(login);
    }

    public void setDatasourceLogin(Login login) {
        this.getProject().setDatasourceLogin(login);
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setNumberOfActiveUnitsOfWork(int numberOfActiveUnitsOfWork) {
        this.numberOfActiveUnitsOfWork = numberOfActiveUnitsOfWork;
    }

    public void setProfiler(SessionProfiler profiler) {
        this.profiler = profiler;
        if (profiler != null) {
            profiler.setSession(this);
            this.setIsInProfile(this.getProfiler().getProfileWeight() != 0);
            this.getIdentityMapAccessorInstance().getIdentityMapManager().clearCacheAccessPreCheck();
        } else {
            this.setIsInProfile(false);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.getProperties().put(propertyName, propertyValue);
    }

    protected void setQueries(Hashtable queries) {
        this.queries = queries;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = (SessionLog)((AbstractSessionLog)sessionLog).clone();
        if (this.sessionLog != null) {
            this.sessionLog.setSession(this);
        }
    }

    protected void setTransactionMutex(ConcurrencyManager transactionMutex) {
        this.transactionMutex = transactionMutex;
    }

    public void setWasJTSTransactionInternallyStarted(boolean wasJTSTransactionInternallyStarted) {
        this.wasJTSTransactionInternallyStarted = wasJTSTransactionInternallyStarted;
    }

    public boolean shouldLogMessages() {
        return this.getLogLevel(null) != 8;
    }

    public void startOperationProfile(String operationName) {
        if (this.isInProfile()) {
            this.getProfiler().startOperationProfile(operationName);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString() + "(" + Helper.cr() + "\t" + this.getAccessor() + Helper.cr() + "\t" + this.getDatasourcePlatform() + ")");
        return writer.toString();
    }

    public Object unwrapObject(Object proxy) {
        return this.getDescriptor(proxy).getObjectBuilder().unwrapObject(proxy, this);
    }

    public Object updateObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject(domainObject);
        return this.executeQuery(query);
    }

    public void validateQuery(DatabaseQuery query) {
    }

    public boolean verifyDelete(Object domainObject) {
        ObjectBuilder builder = this.getDescriptor(domainObject).getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this);
        return builder.verifyDelete(implementation, this);
    }

    public boolean wasJTSTransactionInternallyStarted() {
        return this.wasJTSTransactionInternallyStarted;
    }

    public Object wrapObject(Object implementation) {
        return this.getDescriptor(implementation).getObjectBuilder().wrapObject(implementation, this);
    }

    protected void writeAllObjects(IdentityHashtable domainObjects) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjects(domainObjects);
    }

    protected void writeAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjectsWithChangeSet(uowChangeSet);
    }

    public Object writeObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        WriteObjectQuery query = new WriteObjectQuery();
        query.setObject(domainObject);
        return this.executeQuery(query);
    }

    public void writesCompleted() {
        this.getAccessor().writesCompleted(this);
    }

    public int getLogLevel(String category) {
        return this.getSessionLog().getLevel(category);
    }

    public int getLogLevel() {
        return this.getSessionLog().getLevel();
    }

    public void setLogLevel(int level) {
        this.getSessionLog().setLevel(level);
    }

    public boolean shouldLog(int Level2, String category) {
        return this.getSessionLog().shouldLog(Level2, category);
    }

    public void log(int level, String category, String message) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, (Object[])null);
    }

    public void log(int level, String category, String message, Object param) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param});
    }

    public void log(int level, String category, String message, Object param1, Object param2) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2});
    }

    public void log(int level, String category, String message, Object param1, Object param2, Object param3) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2, param3});
    }

    public void log(int level, String category, String message, Object[] params) {
        this.log(level, category, message, params, null);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor) {
        this.log(level, category, message, params, accessor, true);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(level, category, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("logging");
        }
    }

    public void log(int level, String message, Object[] params, Accessor accessor) {
        this.log(level, message, params, accessor, true);
    }

    public void log(int level, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.shouldLog(level, null)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(level, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("logging");
        }
    }

    public void logThrowable(int level, String category, Throwable throwable) {
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(this, level, category, throwable));
            this.endOperationProfile("logging");
        }
    }

    public void severe(String message, String category) {
        this.log(7, category, message);
    }

    public void warning(String message, String category) {
        this.log(6, category, message);
    }

    public void info(String message, String category) {
        this.log(5, category, message);
    }

    public void config(String message, String category) {
        this.log(4, category, message);
    }

    public void fine(String message, String category) {
        this.log(3, category, message);
    }

    public void finer(String message, String category) {
        this.log(2, category, message);
    }

    public void finest(String message, String category) {
        this.log(1, category, message);
    }

    public Object handleSevere(RuntimeException exception) throws RuntimeException {
        this.logThrowable(7, null, exception);
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }
}

