/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;

public abstract class MetadataAccessor {
    protected Class m_rawClass;
    protected Class m_referenceClass;
    protected String m_attributeName;
    protected Boolean m_isRelationship;
    protected boolean m_needsProcessing;
    protected MetadataProcessor m_metadataProcessor;
    protected MetadataDescriptor m_metadataDescriptor;

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public abstract Object getAnnotatedElement();

    public abstract MetadataDescriptor getMetadataDescriptor();

    public Class getJavaClass() {
        return this.m_metadataDescriptor.getJavaClass();
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public abstract String getName();

    public abstract Class getRawClass();

    public abstract Class getReferenceClass();

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceMetadataDescriptor() {
        return this.m_metadataProcessor.getMetadataDescriptor(this.getReferenceClass());
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public abstract boolean hasColumn();

    public abstract boolean hasEnumerated();

    public abstract boolean hasJoinColumn();

    public abstract boolean hasJoinColumns();

    public abstract boolean hasPrimaryKeyJoinColumn();

    public abstract boolean hasPrimaryKeyJoinColumns();

    public abstract boolean hasSqlResultSetMapping();

    public abstract boolean hasTemporal();

    public abstract boolean isEmbedded();

    public abstract boolean isEmbeddedId();

    public boolean isEnumerated() {
        return this.hasEnumerated() || MetadataHelper.isValidEnumeratedType(this.getReferenceClass());
    }

    public abstract boolean isLob();

    public abstract boolean isManyToMany();

    public abstract boolean isManyToOne();

    public abstract boolean isOneToMany();

    public abstract boolean isOneToOne();

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && (this.hasPrimaryKeyJoinColumns() || this.hasPrimaryKeyJoinColumn());
    }

    public boolean isRelationship() {
        if (this.m_isRelationship == null) {
            this.m_isRelationship = new Boolean(this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne());
        }
        return this.m_isRelationship;
    }

    public boolean isSerialized() {
        return MetadataHelper.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        return this.hasTemporal() || MetadataHelper.isValidTemporalType(this.getReferenceClass());
    }

    public abstract boolean isVersion();

    public boolean needsProcessing() {
        return this.m_needsProcessing;
    }

    public void process() {
        this.m_metadataProcessor.processRelationshipAccessor(this);
    }

    public void setNeedsProcessing(boolean value) {
        this.m_needsProcessing = value;
    }

    public abstract void setReferenceClass(Class var1, String var2);

    public abstract void store();
}

