/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Temporal;
import javax.persistence.Version;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.EJBAnnotationsProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsAccessor
extends MetadataAccessor {
    private String m_name;
    private Type m_relationType;
    private AnnotatedElement m_annotatedElement;

    private AnnotationsAccessor(EJBAnnotationsProcessor processor, AnnotatedElement annotatedElement, AnnotationsDescriptor descriptor) {
        this.setNeedsProcessing(true);
        this.m_isRelationship = null;
        this.m_metadataProcessor = processor;
        this.m_metadataDescriptor = descriptor;
        this.m_annotatedElement = annotatedElement;
    }

    public AnnotationsAccessor(Field field, EJBAnnotationsProcessor processor, AnnotationsDescriptor descriptor) {
        this(processor, field, descriptor);
        this.m_attributeName = this.m_name = field.getName();
        this.m_relationType = MetadataHelper.getGenericType(field);
    }

    public AnnotationsAccessor(Method method, EJBAnnotationsProcessor processor, AnnotationsDescriptor descriptor) {
        this(processor, method, descriptor);
        this.m_name = method.getName();
        this.m_attributeName = MetadataHelper.getAttributeNameFromMethodName(this.m_name);
        this.m_relationType = MetadataHelper.getGenericReturnType(method);
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    @Override
    public AnnotationsDescriptor getMetadataDescriptor() {
        return (AnnotationsDescriptor)this.m_metadataDescriptor;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Class getRawClass() {
        if (this.m_rawClass == null) {
            this.m_rawClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getRawClassFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_rawClass;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getReturnTypeFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_referenceClass;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    @Override
    public boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    @Override
    public boolean hasEnumerated() {
        return this.isAnnotationPresent(Enumerated.class);
    }

    @Override
    public boolean hasJoinColumn() {
        return this.isAnnotationPresent(JoinColumn.class);
    }

    @Override
    public boolean hasJoinColumns() {
        return this.isAnnotationPresent(JoinColumns.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumn() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumn.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }

    @Override
    public boolean hasSqlResultSetMapping() {
        return this.isAnnotationPresent(SqlResultSetMapping.class);
    }

    @Override
    public boolean hasTemporal() {
        return this.isAnnotationPresent(Temporal.class);
    }

    public boolean isAnnotationNotPresent(Class<? extends Annotation> annotation) {
        return AnnotationsHelper.isAnnotationNotPresent(annotation, this.m_annotatedElement);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return AnnotationsHelper.isAnnotationPresent(annotation, this.m_annotatedElement, this.getMetadataDescriptor());
    }

    @Override
    public boolean isEmbedded() {
        if (this.isAnnotationNotPresent(Embedded.class) && this.isAnnotationNotPresent(EmbeddedId.class)) {
            return AnnotationsHelper.isAnnotationPresent(Embeddable.class, this.getReferenceClass());
        }
        return this.isAnnotationPresent(Embedded.class);
    }

    @Override
    public boolean isEmbeddedId() {
        return this.isAnnotationPresent(EmbeddedId.class);
    }

    @Override
    public boolean isLob() {
        return this.isAnnotationPresent(Lob.class);
    }

    @Override
    public boolean isManyToMany() {
        if (this.isAnnotationPresent(ManyToMany.class)) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_annotatedElement);
        }
        return false;
    }

    @Override
    public boolean isManyToOne() {
        return this.isAnnotationPresent(ManyToOne.class);
    }

    @Override
    public boolean isOneToMany() {
        if (this.isAnnotationNotPresent(OneToMany.class)) {
            if (MetadataHelper.isGenericCollectionType(this.m_relationType) && MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                this.m_metadataProcessor.getLogger().logConfigMessage("metadata_default_one_to_many_mapping", this.m_annotatedElement);
                return true;
            }
        } else if (this.isAnnotationPresent(OneToMany.class)) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_annotatedElement);
        }
        return false;
    }

    @Override
    public boolean isOneToOne() {
        if (this.isAnnotationNotPresent(OneToOne.class)) {
            if (((EJBAnnotationsProcessor)this.m_metadataProcessor).getClasses().contains(this.m_referenceClass)) {
                this.m_metadataProcessor.getLogger().logConfigMessage("metadata_default_one_to_one_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToOne.class);
    }

    @Override
    public boolean isVersion() {
        return this.isAnnotationPresent(Version.class);
    }

    @Override
    public void setReferenceClass(Class potentialReferenceClass, String context) {
        if (potentialReferenceClass == Void.TYPE) {
            this.m_metadataProcessor.getLogger().logConfigMessage(context, this.m_annotatedElement, (Object)this.m_referenceClass);
        } else {
            this.m_referenceClass = potentialReferenceClass;
        }
    }

    @Override
    public void store() {
        this.getMetadataDescriptor().addAccessor(this);
    }
}

