/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName;
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeMethod(this.getGetMethod(), anObject, null);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
    }

    protected Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class getGetMethodReturnType() {
        return PrivilegedAccessController.getMethodReturnType(this.getGetMethod());
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class getSetMethodParameterType() {
        return PrivilegedAccessController.getMethodParameterTypes(this.getSetMethod())[0];
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(theJavaClass, this.getGetMethodName(), null));
            Class[] parameterTypes = new Class[]{this.getGetMethodReturnType()};
            this.setSetMethod(Helper.getDeclaredMethod(theJavaClass, this.getSetMethodName(), parameterTypes));
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(ex);
            throw descriptorException;
        }
        catch (SecurityException exception) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(exception);
            throw descriptorException;
        }
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        Object[] parameters = new Object[]{attributeValue};
        try {
            PrivilegedAccessController.invokeMethod(this.getSetMethod(), domainObject, parameters);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (IllegalArgumentException exception) {
            try {
                if (attributeValue instanceof String) {
                    Object newValue = ConversionManager.getDefaultManager().convertObject(attributeValue, this.getAttributeClass());
                    Object[] newParameters = new Object[]{newValue};
                    PrivilegedAccessController.invokeMethod(this.getSetMethod(), domainObject, newParameters);
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (NullPointerException exception) {
            try {
                Class fieldClass = this.getSetMethodParameterType();
                if (!fieldClass.isPrimitive() || attributeValue != null) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
                parameters[0] = ConversionManager.getDefaultManager().convertObject(new Integer(0), fieldClass);
                PrivilegedAccessController.invokeMethod(this.getSetMethod(), domainObject, parameters);
            }
            catch (IllegalAccessException accessException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
            }
            catch (InvocationTargetException invocationException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
            }
        }
    }

    protected void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    protected void setSetMethod(Method setMethod) {
        this.setMethod = setMethod;
    }

    public void setSetMethodName(String setMethodName) {
        this.setMethodName = setMethodName;
    }
}

