/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;

public class JRStyledTextUtil {
    private final JRStyledTextAttributeSelector allSelector;

    private JRStyledTextUtil(JasperReportsContext jasperReportsContext) {
        this.allSelector = JRStyledTextAttributeSelector.getAllSelector(jasperReportsContext);
    }

    public static JRStyledTextUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JRStyledTextUtil(jasperReportsContext);
    }

    public String getTruncatedText(JRPrintText printText) {
        String truncatedText = null;
        String originalText = printText.getOriginalText();
        if (originalText != null) {
            truncatedText = printText.getTextTruncateIndex() == null ? originalText : (!"none".equals(printText.getMarkup()) ? JRStyledTextParser.getInstance().write(printText.getFullStyledText(this.allSelector), 0, printText.getTextTruncateIndex()) : originalText.substring(0, printText.getTextTruncateIndex()));
            String textTruncateSuffix = printText.getTextTruncateSuffix();
            if (textTruncateSuffix != null) {
                truncatedText = truncatedText + textTruncateSuffix;
            }
        }
        return truncatedText;
    }

    public JRStyledText getStyledText(JRPrintText printText, JRStyledTextAttributeSelector attributeSelector) {
        String truncatedText = this.getTruncatedText(printText);
        if (truncatedText == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(printText), truncatedText, !"none".equals(printText.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(printText));
    }
}

