const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tab_master17_incomplete', {
    RepSerNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BMRNo: {
      type: DataTypes.STRING(150),
      allowNull: true
    },
    GraphType: {
      type: DataTypes.STRING(15),
      allowNull: true
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    GrpQty: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    GrpFreq: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    BalanceId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    VernierId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    FriabilityID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    HardnessID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    SideNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Nom: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    NomEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    NomNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T2PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    ReportType: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NoOfAbove1: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    NoOfBelow1: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    NoOfAbove2: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    NoOfBelow2: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MinPer: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxPer: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    GroupWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    StdDev: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    FailedRemarkTSH: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Nom_stdtarget: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TotalWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    Deviation: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    SieveID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Sys_Validation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:unchecked,1:checked"
    }
  }, {
    sequelize,
    tableName: 'tbl_tab_master17_incomplete',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_tab___647BBB29058011B6",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
