const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tab_initialmaster_print', {
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Reason: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: 'NULL'
    },
    Title: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 'NULL'
    },
    UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 'NULL'
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: 'NULL'
    },
    Print_Dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Print_Tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    IsIncomplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RepSrNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    }
  }, {
    sequelize,
    tableName: 'tbl_tab_initialmaster_print',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK_tbl_tab_initialmaster_print_Recno",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
