const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tab_initialdetailhtd', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DataValueHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    DataValueThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    DataValueDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    DataValueBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    Side:{
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
   BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL",
    },
  Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
  SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL",
    }

  }, {
    sequelize,
    tableName: 'tbl_tab_initialdetailhtd',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_tab_initialdetailhtd_RecNo",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
