const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tab_detail1_incomplete', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DataValue: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    DataValue1: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    DataValueUnit: {
      type: DataTypes.STRING(10),
      allowNull: true,
	    defaultValue:'NULL'
    },
    NetValue: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    AvgWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Deviation: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    UserId: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    BFGCode: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    isException:{
      type: DataTypes.INTEGER,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_tab_detail1_incomplete',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_tab___36047C741DEB0A37",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
