const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
    return sequelize.define('tbl_lodmaster', {
        RepSerNo: {
            autoIncrement: true,
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true
        },
        MstSerNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        Area: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        Dept: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        CubicalNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        CubicleName: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        CubicleType: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        ReportType: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        MachineId: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        RotaryType: {
            type: DataTypes.STRING(10),
            allowNull: true,
            defaultValue: "NULL"
        },
        ProductType: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        BFGCode: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        ProductName: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        PVersion: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        Version: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        IdsNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        BatchNo: {
            type: DataTypes.STRING(25),
            allowNull: true,
            defaultValue: "NULL"
        },
        BatchSize: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        BMRNo: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        LODID: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        Layer: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        Side: {
            type: DataTypes.STRING(20),
            allowNull: true,
            defaultValue: "NULL"
        },
        Stage: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        UserId: {
            type: DataTypes.STRING(20),
            allowNull: true,
            defaultValue: "NULL"
        },
        UserName: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        IsArchived: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        PrDate: {
            type: DataTypes.DATEONLY,
            allowNull: true
        },
        PrTime: {
            type: DataTypes.TIME,
            allowNull: true
        },
        PrEndDate: {
            type: DataTypes.DATEONLY,
            allowNull: true
        },
        PrEndTime: {
            type: DataTypes.TIME,
            allowNull: true
        },
        MinLimit: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        MaxLimit: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        Lot: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        Temp: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        InitalWt: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        FinalWt: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        NetWt: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        PrintNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        Remark: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        Lot: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        Unit: {
            type: DataTypes.STRING(5),
            allowNull: true,
            defaultValue: "NULL"
        },
        DecimalPoint: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        BatchComplete: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        CheckedByID: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        CheckedByName: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        CheckedByDate: {
            type: DataTypes.DATEONLY,
            allowNull: true
        },
        Inprocess: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
        },
        Duration: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        LayerName: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        WgmtModeNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: "0"
        },
        FailedRemark: {
            type: DataTypes.STRING(200),
            allowNull: true,
            defaultValue: "NULL"
        },
        LayerName: {
            type: DataTypes.STRING(50),
            allowNull: true
        },
        Layer: {
            type: DataTypes.STRING(50),
            allowNull: true
        },
        CheckedByTime: {
            type: DataTypes.TIME,
            allowNull: true,
            defaultValue: "00:00:00"
        },
        ModeOfWgmt: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "NULL"
        },
        SFOID: {
            type: DataTypes.STRING(500),
            allowNull: true,
            defaultValue: "NA"
        },
        IsPosted: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
        },
        Test_Seq: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
        },
        Repetition: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
        },
        MPN_Code: {
            type: DataTypes.STRING(300),
            allowNull: true,
            defaultValue: "NULL"
        },
        DsNo: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: null
        },
        TabIp: {
            type: DataTypes.STRING(20),
            allowNull: true,
            defaultValue: null
        },
        DryingProgram: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: 'NA'
        },
        SwitchOff: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: 'NA'
        },
        Make: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        Model: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        SerialNo: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "NULL"
        },
        ismid: {
            type: DataTypes.STRING(1000),
            allowNull: true,
            defaultValue: "NULL"
          },
          ackMode: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
          },
          ackReceive: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 0
          },
    }, {
        sequelize,
        tableName: 'tbl_lodmaster',
        schema: 'dbo',
        timestamps: false,
        indexes: [
            {
                name: "PK__tbl_tab___647BBB29CF10CD57",
                unique: true,
                fields: [
                    { name: "RepSerNo" },
                ]
            },
        ]
    });
};
