const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_leakedtest_master', {
    RepSerNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Test_Seq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Dept: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue : 'NULL'
    },
    BFGCode: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    ProductName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue : 'NULL'
    },
    PVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue : 'NULL'
    },
    IdsNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue : 'NULL'
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    BMRNo: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Layer: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    UserId: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue : 'NULL'
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue : 'NULL'
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LeakTestID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    MinLimit: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    MaxLimit: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Make: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Model: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    SerialNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    TestID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    EORTVacLevel: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacBuildTm: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacReleaseTm: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    NoOfPackages: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacRetentionTm: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    MtdName: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacLevel: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacPenetrationTm: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    DesicatorSize: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    PackageType: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    DosageUnit: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    DosageForm: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Remark: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue : 'NULL'
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    CheckedByName: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    FailedRemark: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue : 'NULL'
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    ModeOfWgmt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    EORTVacLevelUnit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue : 'NULL'
    },
    VacLevelUnit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue : 'NULL'
    },
    StartDate: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    StartTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    Limit: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LimitUnit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue : 'NULL'
    },
    TestStatus: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    BatchStatus: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    GroupName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue : 'NULL'
    },
    ProductDescription: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue : 'NULL'
    },
    IsPosted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DsNo: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue : 'NULL'
    },
    TabIp: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue : 'NULL'
    },
    isTestCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
      // 1: completed
      // 0: Incomplete
    },
    ismid: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    ackMode: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ackReceive: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_leakedtest_master',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_leakedtest_master_rep",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
