const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_exception_sample_failed', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    IDSNo: {
      type: DataTypes.STRING(10),
      allowNull: true,
        defaultValue:'NULL'
    },
    Remark: {
      type: DataTypes.STRING(1000),
      allowNull: true,
        defaultValue:'NULL'
    },
    DataValue: {
      type: DataTypes.STRING(100),
      allowNull: true,
        defaultValue:'NULL'
    },
    DataValueUnit: {
      type: DataTypes.STRING(10),
      allowNull: true,
        defaultValue:'NULL'
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
        defaultValue: 0
    },
    TestDate: {
      type: DataTypes.DATE,
      allowNull: true,
        // defaultValue: '1992-12-08'
    },
    MenuName: {
      type: DataTypes.STRING(50),
      allowNull: true,
        defaultValue: 'NULL'
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    TypeValue: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:'NULL'
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue:'NULL'
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue:'NULL'
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue:'NULL'
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue:'NULL'
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:'NULL'
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      // defaultValue: "1992-12-08"
    },
    prTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue:'NULL'
    },
    InstrumentId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:'NULL'
    },
    T1NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "99999.00000"
    },
    T1PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "99999.00000"
    },
    SampleNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    CheckByName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue:'NULL'
    },
    CheckById: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:'NULL'
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue:'NULL'
    },
    UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:'NULL'
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue:'NULL'
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    IsPosted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue:0
    },
    FriabRange: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    DTRange: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    isTerminated: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Nominal: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    InstrumentType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: 'NULL'
    },
    CubicalName: {
      type:  DataTypes.STRING(300),
      allowNull: true,
      defaultValue: 'NULL'
    }
  }, {
    sequelize,
    tableName: 'tbl_exception_sample_failed',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_exce__3213E83F7729DF1B",
        unique: true,
        fields: [
          { name: "id" },
        ]
      },
    ]
  });
};
