const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_bin_summary_temp', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Bin_Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CubicName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CubicleNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_IDSNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_cubType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_prdType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_ProductID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_ProductVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_TotalBin: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Lot: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_MfgDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_ExpDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_DateNA: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:Not NA 1:NA"
    },
    Bin_Initial: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_Next: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_Printer: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_SrNoCubicle: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_SrNoWeighment: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_BinID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Bin_WeighingBalID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_TareWt: {
      type: DataTypes.STRING(15),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_GrossWt: {
      type: DataTypes.STRING(15),
      allowNull: true,
      defaultValue: "0"
    },
    bin_NetWeight: {
      type: DataTypes.STRING(15),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Status: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:gross wt not done 1:done"
    },
    Bin_DoneUserID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_DoneUserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CleanerID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CleanerName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CheckedByID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_PreviousUsedPrdID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_PreviousUsedPrdName: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_PreviousUsedPrdVer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_PreviousUsedVer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_PreviousUsedBatch: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_PrintNoSummary: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HMIID: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL"
    },
    Bin_TotalNetWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_Layer: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_summary_temp',
    timestamps: false
  });
  seq.removeAttribute('id');
  return seq
};
