const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_bin_summary_printrecord', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    Print_Dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Print_Tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(250),
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrdName: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    PrdVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    CubType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(150),
      allowNull: true
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Reason: {
      type: DataTypes.STRING(800),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_summary_printrecord',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_bin___36047C745F2B707A",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
