const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_bin_master_cap', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    Bin_Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_CubicName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_CubicleNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_IDSNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_IDSNoWeighment: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_ProductID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Bin_ProductVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_TotalBin: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_TotalSelected: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Lot: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_MfgDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_ExpDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_Initial: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_Next: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_Header: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_Printer: {
      type: DataTypes.STRING(1000),
      allowNull: true
    },
    Bin_SrNoP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_SrNoTSH: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_BinID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Bin_InstrumentID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_TareWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_GrossWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    bin_NetWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Status: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_UserID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_CleanerID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_CleanerName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_CheckedByID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_PreviousUsedPrdID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_PreviousUsedPrdName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Bin_PreviousUsedPrdVer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_PreviousUsedVer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_PreviousUsedBatch: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_PrintNoSummary: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_useBefore: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Released: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Bin_LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Bin_ShiftCubic: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_master_cap',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_bin___36047C745A10953D",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
