const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_bin_label_temp', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Bin_ProductID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Bin_ProductVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NA"
    },
    Bin_BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_TotalBin: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_TotalSelected: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_Lot: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_MfgDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_ExpDt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_DateNA: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_InitialStage: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_NextStage: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_LabelHeader: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_Printer: {
      type: DataTypes.STRING(1000),
      allowNull: true
    },
    Bin_SrNoCubicle: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_SrNoWeighment: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Bin_BinID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Bin_WeighingBalID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_TareWt: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_GrossWt: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    bin_NetWeight: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    Bin_DoneUserID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Bin_DoneUserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Bin_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HMIID: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: 'NULL'
    },
    Bin_useBeforeDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_useBefore: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_label_temp',
    schema: 'dbo',
    timestamps: false
  });
  seq.removeAttribute('id');
  return seq
};
