const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_bin_batches', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    Batch: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    CubicNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Status: {
      type: DataTypes.STRING(1),
      allowNull: true,
      defaultValue: "N"
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_batches',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_bin___36047C74BF77BDA8",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
