const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_cap_printlod', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true
    },
    RepSrNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Reason: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Title: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Print_Dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Print_Tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    IsIncomplete: {
      type: DataTypes.INTEGER,
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_cap_printlod',
    schema: 'dbo',
    timestamps: false
  });
};
