const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_cap_print5', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    RepSrNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Reason: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    Title: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Print_Dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Print_Tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    IsIncomplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_cap_print5',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_cap___36047C74EF05E93F",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
