const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  return sequelize.define('tbl_cap_initialdetail1_incomplete', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DataValue: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    DataValue1: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    NetValue: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    AvgWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Deviation: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    UserId: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL",
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL",
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: '1992-12-08'
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: '00:00:00'
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: '1992-12-08'
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: '00:00:00'
    },
    BFGCode: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL",
    },
    Version: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    PVersion: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL",
    },
    BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    InstrumentID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Remark: {
      type: DataTypes.STRING(1000),
      allowNull: true
    },
    DataValueUnit: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL",
    },
    isException: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    isCompleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL",
    },
  }, {
    sequelize,
    tableName: 'tbl_cap_initialdetail1_incomplete',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_cap_initialdetail1_incomplete_RecNo",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
