const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_temp_daily_wtidvaliddate', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    SrNo: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: 0
    },
    WtID: {
        type: DataTypes.STRING(1500),
        allowNull: false,
        defaultValue: "NULL"
    },
    ValidDate: { 
        type: DataTypes.STRING(1500),
        allowNull: false,
        defaultValue: "NULL"
    },
    HMI_ID: {
      type:DataTypes.STRING(25),
      allowNull: false,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_temp_daily_wtidvaliddate',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};