const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_repetability_master_failed', {
    SRNO: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    Repet_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Repet_CalbDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    Repet_DueDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Repet_CalbTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Repet_CubicalNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Repet_CubicalName:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Repet_Area:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Repet_IDSNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Repet_BalID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Serial: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Make: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Model: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Dept: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_MassWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_LeastCnt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_MaxCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_MinCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Bal_MinOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "NULL"
    },
    Repet_Bal_MaxOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "NULL"
    },
    Repet_ZeroError: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repet_SpritLevel: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repet_GeneralCare: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repet_UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_UserName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_VerifyID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_VerifyName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_VerifyDate: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "1992-12-08 00:00:00"
    },
    Repet_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repet_IsRecalib:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Repet_DP:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Repet_StdWeight: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_NegTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_PosTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Remark:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Repet_AllWeightboxID: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_AllWeightboxCert: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_AllWeightboxValidUpto: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_IsBinBalance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repet_Per:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "0"
    },
    Repet_Deviation:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "0"
    },
    Repet_Mean:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "0"
    },
    Repet_Location: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_RoomNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_CalbReason: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Pattern: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Frequency: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_calibStatus: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Tolerance: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repet_Bal_Cert_No: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_repetability_master_failed',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
