const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_eccentricity_master_failed', {
    SRNO: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    Eccent_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Eccent_CalbDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Eccent_DueDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Eccent_CalbTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Eccent_CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Eccent_CubicalName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Area:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Eccent_IDSNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Eccent_BalID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Serial: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Make: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Model: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_Dept: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_MassWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_LeastCnt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Eccent_MaxCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Eccent_MinCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Eccent_Bal_MinOR:{
      type:DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Eccent_Bal_MaxOR:{
      type:DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Eccent_ZeroError: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Eccent_SpritLevel: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Eccent_GeneralCare: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Eccent_UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_UserName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_VerifyID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_VerifyName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_VerifyDate: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "1992-12-08 00:00:00"
    },
    Eccent_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Eccent_IsRecalib:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Eccent_DP:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Eccent_StdWeight: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Eccent_NegTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Eccent_PosTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Eccent_Remark:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Eccent_AllWeightboxID: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_AllWeightboxCert: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_AllWeightboxValidUpto: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Eccent_IsBinBalance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
   
    Eccent_PerDeviation:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_eccentricity_master_failed',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
