const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_bin_release', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    bin_BinID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    bin_CubType: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    bin_PreviousPrdName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    bin_PrdName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    bin_CleanerID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    bin_CleanerName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    bin_CheckedByID: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    bin_CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_release',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_bin___36047C74C28CCEAB",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
