const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_calibration_status_bin', {
    Cubicle: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    BalID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    D: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Daily"
    },
    P: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Periodic"
    },
    E: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Eccentricity"
    },
    R: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Repeatability"
    },
    U: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Uncertainty"
    },
    L: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Linearity "
    },
    V: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: false,
      comment: "Positional Variation"
    },
    Sequence: {
      type: DataTypes.STRING(20),
      allowNull: false,
      defaultValue: "P,U,R,E"
    },
    RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "Periodic_RepNo"
    },
    Sys_Area: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Sys_CubicName: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_status_bin',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "Cubicle" },
        ]
      },
    ]
  });
};
