"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _datetimen = _interopRequireDefault(require("./datetimen"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = new Date(1900, 0, 1);
const UTC_EPOCH_DATE = new Date(Date.UTC(1900, 0, 1));
const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallDateTime = {
  id: 0x3A,
  type: 'DATETIM4',
  name: 'SmallDateTime',
  declaration: function () {
    return 'smalldatetime';
  },

  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    let days, dstDiff, minutes;

    if (options.useUTC) {
      days = Math.floor((parameter.value.getTime() - UTC_EPOCH_DATE.getTime()) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getUTCHours() * 60 + parameter.value.getUTCMinutes();
    } else {
      dstDiff = -(parameter.value.getTimezoneOffset() - EPOCH_DATE.getTimezoneOffset()) * 60 * 1000;
      days = Math.floor((parameter.value.getTime() - EPOCH_DATE.getTime() + dstDiff) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getHours() * 60 + parameter.value.getMinutes();
    }

    buffer.writeUInt16LE(days, 0);
    buffer.writeUInt16LE(minutes, 2);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = SmallDateTime;
exports.default = _default;
module.exports = SmallDateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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