const fs = require("fs")
var convert = require('xml-js');
const ClsSHardnessModel = require('./Test/clsHardness.model')
const globalData = require('../global/globalData');
const { i } = require("mathjs");
const moment = require("moment")
const hardnessModel = new ClsSHardnessModel()

exports.extractDataFromXml = async (fileName, data) => {
    try {
        let batchId = null;
        let actualFileDate = null;
        let actualFileTime = null;

        if (fileName.includes("-")) {
            const fileNameArr = fileName.split("-");
            batchId = fileNameArr[0];

            // Extracting and formatting, Date and Time in specific format for future use
            const dateTime = moment(fileNameArr[1].split(".")[0], 'DDMMYYYYHHmmss');
            actualFileDate = dateTime.format('DD-MM-YYYY');
            actualFileTime = dateTime.format('HH:mm:ss');
        }

        async function RemoveJsonTextAttribute(value, parentElement) {
            try {
                var keyNo = Object.keys(parentElement._parent).length;
                var keyName = Object.keys(parentElement._parent)[keyNo - 1];
                parentElement._parent[keyName] = value;
            }
            catch (e) {
                console.log(e)
            }
        }

        var jsonData = convert.xml2json(data, {
            compact: true,
            trim: true,
            // nativeType: true,
            ignoreDeclaration: true,
            ignoreInstruction: true,
            ignoreAttributes: true,
            ignoreComment: true,
            ignoreCdata: true,
            ignoreDoctype: true,
            textFn: RemoveJsonTextAttribute,
        })

        // console.log(jsonData)

        var dataObj = JSON.parse(jsonData)
        var HardnessArr = [],
            ThicknessArr = [],
            DiameterArr = [],
            WeightsArr = [],
            dataArr = []


        for (let obj of dataObj.REPORT.VALUES) {
            if (obj.TYPE === "HRD") {
                HardnessArr.push(obj.VALUE)
            } else if (obj.TYPE === "HGT") {
                ThicknessArr.push(obj.VALUE)
            } else if (obj.TYPE === "WGT") {
                WeightsArr.push(obj.VALUE)
            } else if (obj.TYPE === "LEN") {
                DiameterArr.push(obj.VALUE)
            }
        }

        // const hardnessObj = {
        //     value: 0,
        //     isChecked: false
        // }

        // const thicknessObj = {
        //     value: 0,
        //     isChecked: false
        // }

        // const weightObj = {
        //     value: 0,
        //     isChecked: false
        // }

        // const diameterObj = {
        //     value: 0,
        //     isChecked: false
        // }

        for (let ele in HardnessArr) {
            let hardnessObj = { value: HardnessArr[ele] ? HardnessArr[ele] : 0, isChecked: false }
            let thicknessObj = { value: ThicknessArr[ele] ? ThicknessArr[ele] : 0, isChecked: false }
            let weightObj = { value: WeightsArr[ele] ? WeightsArr[ele] : 0, isChecked: false }
            let diameterObj = { value: DiameterArr[ele] ? DiameterArr[ele] : 0, isChecked: false }
            let calcualtionObj = { value: dataObj.REPORT.STA[ele] ? dataObj.REPORT.STA[ele] : 0, isChecked: false }

            dataArr.push({ NUM: ele, H: hardnessObj, T: thicknessObj, W: weightObj, BL: diameterObj, cl: calcualtionObj })
        }
        var isHardnessAvailable = globalData.hardnessClient[0].IsIndividual;
        if(isHardnessAvailable){
            for (let ele in WeightsArr) {
                let hardnessObj = { value: HardnessArr[ele] ? HardnessArr[ele] : 0, isChecked: false }
                let thicknessObj = { value: ThicknessArr[ele] ? ThicknessArr[ele] : 0, isChecked: false }
                let weightObj = { value: WeightsArr[ele] ? WeightsArr[ele] : 0, isChecked: false }
                let diameterObj = { value: DiameterArr[ele] ? DiameterArr[ele] : 0, isChecked: false }
                let calcualtionObj = { value: dataObj.REPORT.STA[ele] ? dataObj.REPORT.STA[ele] : 0, isChecked: false }
    
                dataArr.push({ NUM: ele, H: hardnessObj, T: thicknessObj, W: weightObj, BL: diameterObj, cl: calcualtionObj })
            } 
        }
        // for (let ele in HardnessArr) {
        //     dataArr.push({ NUM: ele, tempHardVal: HardnessArr[ele] ? HardnessArr[ele] : 0, tempThickVal: ThicknessArr[ele] ? ThicknessArr[ele] : 0, tempWeightVal: WeightsArr[ele] ? WeightsArr[ele] : 0, tempDiamVal: DiameterArr[ele] ? DiameterArr[ele] : 0 })
        // }

        var objData = {
            HardnessArr,
            ThicknessArr,
            DiameterArr,
            WeightsArr
        }

        console.log(JSON.stringify(dataArr))
        const cal_Result = dataObj.REPORT.STA.reduce((acc, item) => {
            acc[item.TYPE] = item.VALUE;
            return acc;
        }, {});

        // data = dataObj.REPORT.STA.forEach((v)=>{(`Type: ${dataObj.REPORT.STA.TYPE}, Value: ${dataObj.REPORT.STA.VALUE}, Unit: ${dataObj.REPORT.STA.UNIT || 'N/A'}`);})
        const FTPHardnessData = {
            data: dataArr,
            cal_data: cal_Result,
            batchId: batchId,
            DsNo: globalData.hardnessClient[0].DsNo,
            TabIp: globalData.hardnessClient[0].TabIp,
            protocolPort: globalData.hardnessClient[0].protocolPort,
        }
      
        if(isHardnessAvailable){
        hardnessModel.processIndividualDataFTP(FTPHardnessData)
        }else{
            hardnessModel.processHardnessDataFTP(FTPHardnessData)
     
        }
    } catch (err) {
        console.log('err: ', err);
    }


}
