// var Client = require('ftp');
// const { extractDataFromXml } = require("./processHardnessparse")
// const globalData = require("../global/globalData")
// var hardnessClient = new Client();

// hardnessClient.connect(ftpClientInfo);

// hardnessClient.on("close", () => {
//     setTimeout(() => hardnessClient.connect(), 5000)
// })

// hardnessClient.on("error", () => { })

// async function processData(file) {
//     // var isHardnessAvailable = globalData.hardnessClient[0]?.info?.isAvailable
//     var isHardnessAvailable = globalData.hardnessClient[0].isAvailable
//     console.log("isFTPInProcess: ",globalData.isFTPInProcess)
//     console.log("isHardnessAvailable: ",isHardnessAvailable)
//     if (isHardnessAvailable === true && globalData.isFTPInProcess == false) {
//         globalData.isFTPInProcess = true
//         if (file !== undefined) {
//             await hardnessClient.get("/" + file.name, async (err, str) => {
//                 if (err) return
//                 console.log("file found")
//                 await str.on('data', async (data) => {
//                     console.log(data.toString())
//                     path = "/processed/" + file.name
//                     console.log("fileName is ", file.name)
//                     hardnessClient.put(data, path, async () => {
//                         hardnessClient.delete("/" + file.name, async () => {
//                             console.log("File processed")
//                             const rs = await extractDataFromXml(file.name, data.toString())
//                             console.log("Response is: ", rs)
//                             globalData.hardnessClient[0].isInprocess === false
//                         })
//                     })
//                 })
//             })
//         }
//     }
// }

// hardnessClient.on('ready', function () {
//     globalData.instrumentClient = setInterval(async () => {
//         // var timeout = 10000;
//         hardnessClient.list(async function (err, list) {
//             var file = list.find(k => k.type.toLowerCase() === "-" && k.name.toLowerCase().endsWith("xml"))
//             var processedExist = list.find(k => k.name === "processed" && k.type === "d")
//             if (file) {
//                 if (globalData.hardnessClient[0].isInprocess === false && globalData.hardnessClient[0].isAvailable == true) {
//                     globalData.hardnessClient[0].isInprocess = true
//                     if (processedExist === undefined) {
//                         hardnessClient.mkdir("processed", async () => {
//                             // setTimeout(() => processData(file), timeout)
//                             await processData(file)
//                         })
//                         return;
//                     }
//                     // setTimeout(() => processData(file), timeout)
//                     await processData(file)
//                 }
//             }
//         })
//     }, 1500)
// });

var Client = require('ftp');
const { extractDataFromXml } = require("./processHardnessparse");
const globalData = require("../global/globalData");
var hardnessClient = new Client();

hardnessClient.connect(ftpClientInfo);

hardnessClient.on("close", () => {
    console.log("OnClose, Connection is closed");
    setTimeout(() => hardnessClient.connect(ftpClientInfo), 5000);
});

hardnessClient.on("error", (err) => {
    console.error("error, Connection is errored", err);
});

async function processData(file) {
    try {
        // Locking the process with the flag
        var isHardnessAvailable = globalData.hardnessClient[0].isAvailable;
        if (isHardnessAvailable) {
            if (file !== undefined) {
                hardnessClient.get("/" + file.name, (err, stream) => {
                    if (err) {
                        console.error("Error getting file:", err);
                        globalData.hardnessClient[0].isInprocess = false; // Reset flag on error
                        return;
                    }

                    console.log("file found");
                    let dataBuffer = [];

                    stream.on('data', (data) => {
                        dataBuffer.push(data);
                    });

                    stream.on('end', async () => {
                        const fileData = Buffer.concat(dataBuffer).toString();
                        console.log("File content received. Length:", fileData.length);

                        const processedPath = "/processed/" + file.name;
                        console.log("Processing file:", file.name);

                        hardnessClient.put(fileData, processedPath, async (err) => {
                            if (err) {
                                console.error("Error uploading processed file:", err);
                                globalData.hardnessClient[0].isInprocess = false; // Reset flag on error
                                return;
                            }

                            // Once uploaded, delete the original
                            hardnessClient.delete("/" + file.name, async (err) => {
                                if (err) {
                                    console.error("Error deleting original file:", err);
                                } else {
                                    console.log("File processed and deleted.");
                                    await extractDataFromXml(file.name, fileData);
                                }
                                globalData.hardnessClient[0].isInprocess = false; // Reset flag after processing
                            });
                        });
                    });

                    stream.on('error', (err) => {
                        console.error("Error reading file stream:", err);
                        globalData.hardnessClient[0].isInprocess = false; // Reset flag on error
                    });
                });
            }
        }
    } catch (err) {
        console.error("Error in processData:", err);
        globalData.hardnessClient[0].isInprocess = false; // Reset flag on error
    }
}

hardnessClient.on('ready', function () {
    globalData.instrumentClient = setInterval(async () => {
        try {
            hardnessClient.list(async function (err, list) {
                if (err) {
                    console.error("Error listing files:", err);
                    return;
                }

                // console.log('list: ', list);

                var file = list?.find(k => k.type.toLowerCase() === "-" && k.name.toLowerCase().endsWith("xml"));
                var processedExist = list?.find(k => k.name === "processed" && k.type === "d");

                if (file) {
                    if (!globalData.hardnessClient[0].isInprocess && globalData.hardnessClient[0].isAvailable && !globalData.hardnessClient[0].IsIndividual) {
                        globalData.hardnessClient[0].isInprocess = true; // Set the flag immediately

                        if (!processedExist) {
                            hardnessClient.mkdir("processed", async () => {
                                await processData(file);
                            });
                        } else {
                            await processData(file);
                        }
                    }
                    if (!globalData.hardnessClient[0].isInprocess && globalData.hardnessClient[0].IsIndividual){
                        globalData.hardnessClient[0].isInprocess = true; // Set the flag immediately

                        if (!processedExist) {
                            hardnessClient.mkdir("processed", async () => {
                                await processData(file);
                            });
                        } else {
                            await processData(file);
                        }  
                    }
                }
            });
        } catch (err) {
            console.error("Error in interval function:", err);
        }
    }, 1500);
});
