const globalData = require("../global/globalData")
const momentObj = require("moment")
const cls_CommonWeightment = require("./Product/clsCommonWeightment");
const clsWeighmentDataTransfer = require("./Product/clsWeighmentDataTransfer");
const clsLogin = require('./Login/login.model')
const models = require("../../config/dbConnection").models;
const sequelize = require("../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const { object } = require("joi");
const objCommonWeightment = new cls_CommonWeightment();
const objWeighmentDataTransfer = new clsWeighmentDataTransfer()
const objLogin = new clsLogin()

class mesApiModel {

  async batchEnd(data) {

    try {

      const { dsNo, userId } = data
      let MenusequenceRepSerNo;
      let tabIp;

      let cubicalObj = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: dsNo
        }
      })

      var menuSequenceTable = await models.tbl_menu_sequence.findOne({
        attributes: { exclude: ['DS_Number', 'UserId', 'RecNo'] },
        where: {
          DS_Number: dsNo,
          // TabIp: tabIp
        }
      })
      if (menuSequenceTable && Object.keys(menuSequenceTable).length != 0) {

        MenusequenceRepSerNo = menuSequenceTable.RepSerNo;
        tabIp = menuSequenceTable.TabIp
        delete menuSequenceTable.RepSerNo
        delete menuSequenceTable.TabIp

        let tableNames = objCommonWeightment.getTableName(cubicalObj, 'Group', dsNo, tabIp)


        let incompleteMasterData = await models[tableNames.masterTableIncomplete].findAll({
          where: {
            RepSerNo: MenusequenceRepSerNo
          }
        })

        if (incompleteMasterData.length > 0) {
          let masterObjectIncomplete = objLogin.convertDateTimeIntoString(incompleteMasterData[0],{},0)
          delete masterObjectIncomplete.RepSerNo
          masterObjectIncomplete.IntervalStopTm = momentObj().format('YYYY-MM-DD HH:mm:ss'),
            masterObjectIncomplete.PrEndDate = momentObj().format("YYYY-MM-DD"),
            masterObjectIncomplete.PrEndTime = momentObj().format("HH:mm:ss")
            masterObjectIncomplete.Inprocess = 0

          let failedMasterData = await models[tableNames.masterTableFailed].create(masterObjectIncomplete)
          let failedMasterRepSerNo = failedMasterData._previousDataValues.RepSerNo
          for (let ele in menuSequenceTable) {
            if (menuSequenceTable[`${ele}`] != null) {
              let menuName = objCommonWeightment.getMenuNmFromMenuSeq(ele)
              let getTableName = objCommonWeightment.getTableName(cubicalObj, menuName, dsNo, tabIp)

              let detailIncompleteExceptionData = await models[getTableName.detailTableIncomplete].findAll({
                where: {
                  RepSerNo: MenusequenceRepSerNo,
                  isException: 1
                }
              })


              if (detailIncompleteExceptionData.length > 0) {
                objWeighmentDataTransfer.moveToTerminatedExceptionTable(failedMasterRepSerNo, menuName, failedMasterData, detailIncompleteExceptionData, cubicalObj.Sys_RptType, 1)
              }

              let tableParameters = await models[getTableName.detailTableFailed].rawAttributes
              for (const key in tableParameters) {
                if (['RepSerNo', 'RecNo'].includes(key)) {
                  delete tableParameters[key]
                }

              }

              tableParameters = Object.keys(tableParameters)
              var str_Query = `INSERT INTO ${getTableName.detailTableFailed}(${tableParameters},RepSerNo) SELECT ${tableParameters},${failedMasterRepSerNo} as RepSerNo FROM ${getTableName.detailTableIncomplete} where RepSerNo = ${MenusequenceRepSerNo}`
              await sequelize.query(str_Query, { type: QueryTypes.INSERT })

              await models[getTableName.detailTableIncomplete].destroy({ where: { RepSerNo: MenusequenceRepSerNo } })

            }

          }

          await models[tableNames.masterTableIncomplete].destroy({
            where: {
              RepSerNo: MenusequenceRepSerNo
            }
          })

        }

      }


      return {
        status: "success",
        message: "batch ended"
      }

    } catch (error) {
      console.log(error)
    }


  }

}
module.exports = mesApiModel;
