const globalData = require("../global/globalData");
const date = require("date-and-time");
const clsCommonWeightment = require('../model/Product/clsCommonWeightment');
const GLOBAL_NOMENCLATURE = require("../global/GLOBAL_NOMENCLATURE");
const objCommonWeightment = new clsCommonWeightment();
const maths = require('mathjs');
const { Op } = require("sequelize");
// const { tbl_cubical } = require('sequelize');
const models = require('../../config/dbConnection').models;
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
const moment = require("moment");

class calculation_operation {

  async calculation_operation_new(repSerNo, masterTable, detailTable, actualWt, unitObj, menuName, typeValue, rptType, unit, isPreStart) {
    try {
      let detailData
      let avgStr, minWeight, maxWeight, stdDev, rsd, prEndDate, prEndTime, aboveLimit1, aboveLimit2, belowLimit1, belowLimit2, totalWeight, diff, finalRemark, dbUnit;
      let whereCondition = { RepSerNo: repSerNo }
      if (!isPreStart) {
        whereCondition.isException = 0
      }
      switch (menuName) {
        case GLOBAL_NOMENCLATURE.GroupMenu:

          detailData = await models[detailTable].findAll({ where: whereCondition });
          // avgStr = 'AvgGrpWeight';
          // MinWeight = 'MinGrpWeight';
          // MaxWeight = 'MaxGrpWeight';
          break;
        case GLOBAL_NOMENCLATURE.IndividualMenu:
          detailData = await models[detailTable].findAll({ where: { ...whereCondition, isCompleted: 0 } });
          break;
        default:
          detailData = await models[detailTable].findAll({ where: whereCondition });
          // avgStr = 'AvgWeight';
          // MinWeight = 'MinWeight';
          // MaxWeight = 'MaxWeight';
          break;
      }

      let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, rptType);
      avgStr = getLimitsObj.AvgWeight;
      minWeight = getLimitsObj.MinWeight;
      maxWeight = getLimitsObj.MaxWeight;
      stdDev = getLimitsObj.StdDev;
      rsd = getLimitsObj.RStdDev;
      prEndDate = getLimitsObj.PrEndDate;
      prEndTime = getLimitsObj.PrEndTime;
      totalWeight = getLimitsObj.TotalWeight;
      aboveLimit1 = getLimitsObj.NoOfAbove1;
      aboveLimit2 = getLimitsObj.NoOfAbove2;
      belowLimit1 = getLimitsObj.NoOfBelow1;
      belowLimit2 = getLimitsObj.NoOfBelow2;
      diff = getLimitsObj.Diff;
      dbUnit = getLimitsObj.Unit
      // finalRemark = getLimitsObj.Remark


      var masterData = await models[masterTable].findAll({ where: { RepSerNo: repSerNo } });
      let result = this.calculation(detailData, unitObj);

      var T1Pos_Tol, T1Neg_Tol, T2Pos_Tol, T2Neg_Tol;
      T1Pos_Tol = masterData[0].T1PosTol;
      T1Neg_Tol = masterData[0].T1NegTol;
      T2Pos_Tol = masterData[0].T2PosTol;
      T2Neg_Tol = masterData[0].T2NegTol;

      if (actualWt) {
        if (Number(actualWt) < Number(T2Neg_Tol) || Number(actualWt) > Number(T2Pos_Tol)) {
          masterData[0].NoOfBelowT2 = Number(masterData[0].NoOfBelowT2) + 1;
        }

        if (T1Pos_Tol != 0 && T1Neg_Tol != 0) {
          if ((Number(actualWt) < Number(T1Neg_Tol) && Number(actualWt) >= Number(T2Neg_Tol)) ||
            (Number(actualWt) > Number(T1Pos_Tol) && Number(actualWt) <= Number(T2Pos_Tol))) {
            masterData[0].NoOfBelowT1 = Number(masterData[0].NoOfBelowT1) + 1;
          }
        }
      }

      // let remark = detailData.map(e => e.Remark);
      // let str = 'Out Of Limit';
      // let finalResult = 'Within Limit'
      // if(remark.includes(str)) { finalResult = str }

      await models[masterTable].update(
        {
          [avgStr]: result.avg,
          [minWeight]: result.min_value,
          [maxWeight]: result.max_value,
          [stdDev]: result.std_value,
          [rsd]: result.rsd_value,
          [totalWeight]: result.finalSum,
          [diff]: result.diff,
          [prEndDate]: moment(masterData[0][prEndDate]).format("YYYY-MM-DD") || moment().format("YYYY-MM-DD"),
          [prEndTime]: moment(masterData[0][prEndTime]).format("HH:mm:ss") || moment().format("HH:mm:ss"),
          // PrEndDate: moment().format("YYYY-MM-DD"),
          // PrEndTime: moment().format("HH:mm:ss"),
          // MinPer: minPer_value,
          // MaxPer: maxPer_value,
          [aboveLimit1]: masterData[0][aboveLimit1],
          [aboveLimit2]: masterData[0][aboveLimit2],
          [belowLimit1]: masterData[0][belowLimit1],
          [belowLimit2]: masterData[0][belowLimit2],
          [dbUnit]: unit
          // [finalRemark]: finalResult
        },
        { where: { RepSerNo: repSerNo } }
      );
      let jsonDates = {
        [prEndDate] : moment().format("YYYY-MM-DD"),
        [prEndTime] : moment().format("HH:mm:ss")
      }
      return {result, jsonDates};

    } catch (error) {
      throw new Error(error)
    }
  }


  calculation(detailData, unitObj) {
    try {
      let { avgDp, stdDevDp, decPoint, minMaxDp } = unitObj
      let avg, std_value, max_value, min_value, total, diff;

      if (detailData.length > 0) {
        var arr = detailData.map(e => e.DataValue);
        max_value = Number(maths.round(maths.max(arr), minMaxDp)).toFixed(minMaxDp);
        min_value = Number(maths.round(maths.min(arr), minMaxDp)).toFixed(minMaxDp);
        avg = this.avgCalc(arr, avgDp)
        std_value = Number(maths.round(maths.std(arr), stdDevDp)).toFixed(stdDevDp);
        var rsd_value = Number(std_value) / Number(avg) * 100;
        rsd_value = Number(maths.round(rsd_value, stdDevDp)).toFixed(stdDevDp)
        total = arr.reduce((acc, total) => {
          return Number(total) + Number(acc);
        }, 0);
        diff = max_value - min_value;
        // var minPer_value = ((Number(min_value) - Number(Nominal)) / Number(Nominal)) * 100;
        // minPer_value = Number(maths.round(minPer_value, minMaxPerDp)).toFixed(minMaxPerDp)

        // var maxPer_value = ((Number(max_value) - Number(Nominal)) / Number(Nominal)) * 100;
        // maxPer_value = Number(maths.round(maxPer_value, minMaxPerDp)).toFixed(minMaxPerDp)
      }

      let obj = {
        max_value: max_value,
        min_value: min_value,
        avg: avg,
        // std_value: std_value == '0.0000' ? 'NULL' : std_value,
        // rsd_value: rsd_value == '0.0000' ? 'NULL' : rsd_value,
        std_value: std_value,
        rsd_value: rsd_value,
        finalSum: Number(maths.round(total, decPoint)).toFixed(decPoint),
        diff: Number(maths.round(diff, decPoint)).toFixed(decPoint) == 0 ? '0.000' : Number(maths.round(diff, decPoint)).toFixed(decPoint)

      }

      return obj;

    } catch (err) {
      throw new Error(err)
    }
  }

  avgCalc(arr, avgDp) {
    try {
      let total = arr.reduce((acc, total) => {
        return Number(total) + Number(acc);
      }, 0);
      let avg = total / arr.length;
      avg = Number(maths.round(maths.abs(avg), avgDp)).toFixed(avgDp);

      return avg

    } catch (err) {
      throw new Error(err);
    }
  }


  async calculation_operation(Dataobj, repSerNo) {
    try {
      var ProdData = Dataobj.objProductDetails;
      var strHmi = ProdData.Hmi;
      var actualWt = Dataobj.ProtocolData
      var DataValue_arr = [];
      var detail_tableName = Dataobj.strDetailTbl.concat("_incomplete");
      var master_tableName = Dataobj.strTableName.concat("_incomplete");
      var Nominal = Dataobj.objProductDetails.Nominal.split(' ')[0];
      //For balanceDp = 3 and vernierDP 2 and Avg(balance)DP=4 and Avg(vernier)DP=3

      var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
      var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

      var DP = get_Datavalue1[0].DecimalPoint;
      let StdDevDp = Dataobj.StdDevDp;
      let avgDp = Dataobj.avgDp;
      let minMaxDp = get_Datavalue1[0].DecimalPoint;
      let minMaxPerDp = (Dataobj.minMaxPerDp) ? Dataobj.minMaxPerDp : minMaxDp;

      Nominal = Number(Nominal).toFixed(DP);
      get_Datavalue1[0].DecimalPoint
      DataValue_arr.push(get_Datavalue);
      var arr = [];
      var total_weight = 0
      for (var i = 0; i < get_Datavalue.length; i++) {
        var a = get_Datavalue[i].DataValue;
        arr.push(Number(a));
        console.log(arr);
        total_weight = Number(total_weight) + Number(get_Datavalue[i].DataValue)
      }

      var max_value = maths.max(arr);
      var min_value = maths.min(arr);
      var std_value = maths.std(arr);
      var total = arr.reduce((acc, total) => {
        return Number(total) + Number(acc);
      }, 0)
      var avg = total / arr.length

      max_value = Number(mathj.round(max_value, minMaxDp)).toFixed(minMaxDp);
      min_value = Number(mathj.round(min_value, minMaxDp)).toFixed(minMaxDp);
      std_value = Number(mathj.round(std_value, StdDevDp)).toFixed(StdDevDp);
      avg = Number(mathj.round(maths.abs(avg), avgDp)).toFixed(avgDp);//maths.abs(avg).toFixed(dp_Ver_bal);
      var minPer_value = ((Number(min_value) - Number(Nominal)) / Number(Nominal)) * 100;

      minPer_value = Number(mathj.round(minPer_value, minMaxPerDp)).toFixed(minMaxPerDp)
      if (!minPer_value.startsWith('-')) {
        minPer_value = '+' + " " + minPer_value
      } else {
        minPer_value = Number(mathj.round(maths.abs(minPer_value), minMaxPerDp)).toFixed(minMaxPerDp)
        minPer_value = '-' + " " + minPer_value
      }
      var maxPer_value = ((Number(max_value) - Number(Nominal)) / Number(Nominal)) * 100;
      maxPer_value = Number(mathj.round(maxPer_value, minMaxPerDp)).toFixed(minMaxPerDp)
      if (!maxPer_value.startsWith('-')) {
        maxPer_value = '+' + " " + maxPer_value
      } else {
        maxPer_value = Number(mathj.round(maths.abs(maxPer_value), minMaxPerDp)).toFixed(minMaxPerDp)
        maxPer_value = '-' + " " + maxPer_value

      }

      // console.log();
      console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
      // return arr;
      // }
      //No.of Tablets Above and Below limit
      var T1Pos_Tol, T1Neg_Tol, T2Pos_Tol, T2Neg_Tol;
      T1Pos_Tol = get_Datavalue1[0].T1PosTol;
      T1Neg_Tol = get_Datavalue1[0].T1NegTol;
      T2Pos_Tol = get_Datavalue1[0].T2PosTol;
      T2Neg_Tol = get_Datavalue1[0].T2NegTol;

      var nob1 = 0;
      var noa1 = 0;
      var nob2 = 0;
      var noa2 = 0;
      if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
        for (var i = 0; i < get_Datavalue.length; i++) {
          if (Number(get_Datavalue[i].DataValue) < Number(T2Neg_Tol)) { //No of below limit 2
            nob2 = nob2 + 1;
          } else if (Number(get_Datavalue[i].DataValue) > Number(T2Pos_Tol)) { //No of Above limit 2
            noa2 = noa2 + 1;
          }
          if (T1Neg_Tol != 0 && T1Pos_Tol != 0) {
            if (Number(get_Datavalue[i].DataValue) < Number(T1Neg_Tol) && Number(get_Datavalue[i].DataValue) >= Number(T2Neg_Tol)) { //No of below limit 1
              nob1 = nob1 + 1;
            } else if (Number(get_Datavalue[i].DataValue) > Number(T1Pos_Tol) && Number(get_Datavalue[i].DataValue) <= Number(T2Pos_Tol)) { //No of Above limit 1
              noa1 = noa1 + 1;
            }
          }
        }
      } else {
        for (var i = 0; i < get_Datavalue.length; i++) {
          if (Number(get_Datavalue[i].DataValue) < Number(T2Neg_Tol)) { //No of below limit 2
            nob2 = nob2 + 1;
          } else if (Number(get_Datavalue[i].DataValue) > Number(T2Pos_Tol)) { //No of Above limit 2
            noa2 = noa2 + 1;
          }
        }
      }
      // if ((Number(actualWt) < Number(T2Neg_Tol))) {
      //   get_Datavalue1[0].NoOfBelow2 = Number(get_Datavalue1[0].NoOfBelow2) + 1;
      // } else if ((Number(actualWt) > Number(T2Pos_Tol))) {
      //   get_Datavalue1[0].NoOfAbove2 = Number(get_Datavalue1[0].NoOfAbove2) + 1;
      // }
      // if (T1Pos_Tol != 0 && T1Neg_Tol != 0) {
      //   if ((Number(actualWt) < Number(T1Neg_Tol) && Number(actualWt) >= Number(T2Neg_Tol))) {
      //     get_Datavalue1[0].NoOfBelow1 = Number(get_Datavalue1[0].NoOfBelow1) + 1;
      //   } else if ((Number(actualWt) > Number(T1Pos_Tol) && Number(actualWt) <= Number(T2Pos_Tol))) {
      //     get_Datavalue1[0].NoOfAbove1 = Number(get_Datavalue1[0].NoOfAbove1) + 1;
      //   }
      // }
      //update Min and Max value in Master and also Std,minPer,maxPer,%Dev
      var get_Datavalue11 = await models[master_tableName].update({
        AvgWeight: Number(avg).toFixed(avgDp),
        MinWeight: Number(min_value).toFixed(minMaxDp),
        MaxWeight: Number(max_value).toFixed(minMaxDp),
        StdDev: Number(std_value).toFixed(StdDevDp),
        MinPer: minPer_value,
        MaxPer: maxPer_value,
        TotalWeight: Number(total_weight).toFixed(DP),
        // Deviation: Per_Dev,
        NoOfAbove1: noa1,
        NoOfAbove2: noa2,
        NoOfBelow1: nob1,
        NoOfBelow2: nob2
      }, { where: { RepSerNo: repSerNo } });
      //19/05/23 END
      var remark;
      var SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
      var objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
      get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
      get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

      if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
        if (((Number(get_Datavalue1[0].NoOfAbove1) + Number(get_Datavalue1[0].NoOfBelow1)) > Number(get_Datavalue1[0].NMT) || (Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0)) {
          remark = 'Not Complies';
          SampleRemark.OutOfRemark = true
        } else {
          remark = 'Complies';
          SampleRemark.OutOfRemark = false
        }
      } else {
        if ((Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0) {
          remark = 'Not Complies';
          SampleRemark.OutOfRemark = true
        } else {
          remark = 'Complies';
          SampleRemark.OutOfRemark = false
        }
      }
      if (Number(Dataobj.objProductDetails.noOfSample) == Dataobj.seqNoOfWt) {
        if (objSelMenu.selectedProductDetail.isonstd == 1) {
          var get_Datavalue_final = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
          var get_Datavalue1_final = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

          objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgWeight;

          var Nominal_final = objSelMenu.selectedProductDetail.nominal;
          Nominal_final = Number(Nominal_final).toFixed(DP);

          var maxLimitT1_avg = 0, minLimitT1_avg = 0;
          var maxLimitT2_avg = objSelMenu.selectedProductDetail.T2Pos;
          var minLimitT2_avg = objSelMenu.selectedProductDetail.T2Neg;

          var DataValue_arr = [];

          get_Datavalue1_final[0].NoOfBelow1 = 0;
          get_Datavalue1_final[0].NoOfAbove1 = 0;
          get_Datavalue1_final[0].NoOfBelow2 = 0;
          get_Datavalue1_final[0].NoOfAbove2 = 0;

          DataValue_arr.push(get_Datavalue_final);
          var arr_final = [];
          for (var j = 0; j < get_Datavalue_final.length; j++) {
            var AB = get_Datavalue_final[j].DataValue;
            arr_final.push(Number(AB));
            console.log(arr_final);
            // }
            if (Number(AB) < Number(minLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfBelow2 = Number(get_Datavalue1_final[0].NoOfBelow2) + 1;
            } else if (Number(AB) > Number(maxLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfAbove2 = Number(get_Datavalue1_final[0].NoOfAbove2) + 1;
            }
            if (maxLimitT1_avg != 0 && minLimitT1_avg != 0) {
              if (Number(AB) < Number(minLimitT1_avg) && Number(AB) >= Number(minLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfBelow1 = Number(get_Datavalue1_final[0].NoOfBelow1) + 1;
              } else if (Number(AB) > Number(maxLimitT1_avg) && Number(AB) <= Number(maxLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfAbove1 = Number(get_Datavalue1_final[0].NoOfAbove1) + 1;
              }
            }
          }
          // arr_final.push(Number(AB));
          // console.log(arr_final);
          var max_value_final = maths.max(arr_final);
          var min_value_final = maths.min(arr_final);
          var std_value_final = maths.std(arr_final);
          var total_final = arr_final.reduce((acc, total_final) => {
            return Number(total_final) + Number(acc);
          }, 0)
          var avg_final = total_final / arr_final.length

          max_value_final = Number(mathj.round(max_value_final), minMaxDp).toFixed(minMaxDp);
          min_value_final = Number(mathj.round(min_value_final), minMaxDp).toFixed(minMaxDp);
          std_value_final = Number(mathj.round(std_value_final), StdDevDp).toFixed(StdDevDp);
          avg_final = Number(mathj.round(maths.abs(avg_final), avgDp)).toFixed(avgDp);
          // var minPer_value_final = ((Nominal_final - min_value_final) / Nominal_final) * 100;
          var minPer_value_final = ((Number(min_value_final) - Number(avg_final)) / Number(avg_final)) * 100;
          minPer_value_final = Number(mathj.round(minPer_value_final, minMaxPerDp)).toFixed(minMaxPerDp);
          if (!minPer_value_final.startsWith('-')) {
            minPer_value_final = '+' + " " + minPer_value_final
          }
          // var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
          var maxPer_value_final = ((Number(max_value_final) - Number(avg_final)) / Number(avg_final)) * 100;
          maxPer_value_final = Number(mathj.round(maxPer_value_final, minMaxPerDp)).toFixed(minMaxPerDp);
          if (!maxPer_value_final.startsWith('-')) {
            maxPer_value_final = '+' + " " + maxPer_value_final
          }

          // console.log();
          console.log(max_value_final, min_value_final, std_value_final, avg_final, minPer_value_final, maxPer_value_final);
          // return arr;

          var master_update = await models[master_tableName].update({
            AvgWeight: avg_final,
            StdDev: std_value_final,
            MinWeight: min_value_final,
            MaxWeight: max_value_final,
            MinPer: minPer_value_final,
            MaxPer: maxPer_value_final,
            NoOfAbove1: noa1,
            NoOfAbove2: noa2,
            NoOfBelow1: nob1,
            NoOfBelow2: nob2,
            TotalWeight: Number(total_weight).toFixed(DP),
            T1NegTol: Number(minLimitT1_avg).toFixed(DP),
            T1PosTol: Number(maxLimitT1_avg).toFixed(DP),
            T2NegTol: Number(minLimitT2_avg).toFixed(DP),
            T2PosTol: Number(maxLimitT2_avg).toFixed(DP),
          }, { where: { RepSerNo: repSerNo } });
          // }
          // if (((Number(get_Datavalue1_final[0].NoOfAbove1) + Number(get_Datavalue1_final[0].NoOfBelow1)) > Number(get_Datavalue1_final[0].NMT) || (Number(get_Datavalue1_final[0].NoOfAbove2) != 0) || Number(get_Datavalue1_final[0].NoOfBelow2) != 0)) {
          //   remark = 'Not Complies';
          //   SampleRemark.OutOfRemark = true
          // } else {
          //   remark = 'Complies';
          //   SampleRemark.OutOfRemark = false
          // }
          if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
            if (((Number(get_Datavalue1[0].NoOfAbove1) + Number(get_Datavalue1[0].NoOfBelow1)) > Number(get_Datavalue1[0].NMT) || (Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0)) {
              remark = 'Not Complies';
              SampleRemark.OutOfRemark = true
            } else {
              remark = 'Complies';
              SampleRemark.OutOfRemark = false
            }
          } else {
            if ((Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0) {
              remark = 'Not Complies';
              SampleRemark.OutOfRemark = true
            } else {
              remark = 'Complies';
              SampleRemark.OutOfRemark = false
            }
          }
        }
        await models[master_tableName].update({
          Remark: remark
        }, { where: { RepSerNo: repSerNo } });
      } else {
        await models[master_tableName].update({
          Remark: 'NA'
        }, { where: { RepSerNo: repSerNo } });
      }
      return remark;
    } catch (error) {
      console.log(error);
    }
  }

}
module.exports = calculation_operation