const globalData = require("../../global/globalData");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const GLOBAL_NOMENCLATURE = require("../../global/Global_Nomenclature");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
const Database = require("../../database/clsQueryProcess");
const utillDb = require("../../Utills/db");
const clsProObj = require("../Product/clsProductDetailModel");
const date = require("date-and-time");
const clsBatchSummary = require("../Product/clsBatchSummaryOperation");
const { models } = require("../../../config/dbConnection");
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const momentObj = require("moment");
const { Json } = require("sequelize/lib/utils");
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const clsCalculation = require('../clsCalculationOperation');
const { create, all } = require("mathjs");
const objMonit = new clsMonit();
const config = {};
const maths = create(all, config);

const database = new Database();
const objIncompleteReport = new clsIncompleteReport();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const proObj = new clsProObj();
const objBatchSummary = new clsBatchSummary();
const objcalc = new clsCalculation();
// const OPCops = require("../OPC/opcOps");
// const objOPCops = new OPCops();

class LOD {
  /**
   * sample is not their in LOD
   * @description LOD Data Come here
   * @param {*} IdsNo
   * @param {*} protocol
   */


  async insertBulkWeighmentLOD(dataObj) {
    try {
      // let dsNo = dataObj.DsNo;
      let cubicObj = dataObj.cubicObjData.cubicalData;
      // const tempUserObject = globalData.arrUsers.find(k => k.DsNo == dsNo);
      let getProductType = await models.tbl_product_master.findOne({ where: { ProductId: cubicObj.Sys_BFGCode, ProductName: cubicObj.Sys_ProductName } })
      if (getProductType) { cubicObj.ProductType = getProductType.ProductType };
      // dataObj.UserData = tempUserObject;
      // dataObj.cubicObj = cubicObj;
      // dataObj.cubicObjData = cubicObjData
      await this.saveLodData(dataObj);

    } catch (err) {
      throw new Error(err)
    }
  }


  async saveLodData(dataObj) {
    try {
      let dsNo = dataObj.DsNo;
      let tabIp = dataObj.TabIp;
      // let selectedMenuDetails = dataObj.SelectedMenuDetails
      let { actualWt, UserData, cubicObjData, menuName, ProtocolPortNo, SelectedMenuDetails } = dataObj
      // let productType = cubicObj.ProductType;
      let cubicObj = cubicObjData.cubicalData;

      UserData = globalData.arrUsers.find(k => k.DsNo == dsNo)

      let layer = 'NA';
      let layerName = 'NA';
      let lodPerDp = 3
      let tempDp = 3
      // let lodData = globalData.arrProtocolData.find(k => k.DsNo == dsNo);

      const batchResult = await models.tbl_lodmaster.findAll({
        attributes: [
          [sequelize.fn('max', sequelize.col('MstSerNo')), 'MstSerNo'],
        ],
        where: {
          BFGCode: cubicObj.Sys_BFGCode,
          ProductName: cubicObj.Sys_ProductName,
          BatchNo: cubicObj.Sys_Batch,
          ReportType: cubicObj.Sys_RptType,
          DsNo: dsNo,
          // IPQCType: cubicObj.Sys_IPQCType,
        }
      })

      let mstSerNo = 1;
      if (batchResult[0]) {
        mstSerNo = (batchResult[0].MstSerNo == null) ? 1 : batchResult[0].MstSerNo + 1
      }

      let decimalPoint = actualWt['Start Weight'].split(" ")[0].split(".")[1].length
      let startWeight = Number(actualWt['Start Weight'].split(" ")[0]).toFixed(decimalPoint)
      let endWeight = Number(actualWt['Dry Weight'].split(" ")[0]).toFixed(3)
      let unit = actualWt['Start Weight'].split(" ")[1]
      // var LOD = (((startWeight - endWeight) / startWeight) * 100).toFixed(decimalPoint)
      var LOD = Number(actualWt['End Result'].split(" ")[0])

      var LODInfo = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: SelectedMenuDetails.instrumentId,
          Eqp_Type: GLOBAL_NOMENCLATURE.MoistureAnalyzer
        }
      })
      LODInfo = LODInfo[0]

      var limit = SelectedMenuDetails.selectedProductDetail.T2Neg

      var lowerLimit = 'NA'
      var upperLimit = 'NA'
      var target = 'NA'

      if (SelectedMenuDetails.selectedProductDetail.T2Neg.includes('NMT')) {
        upperLimit = SelectedMenuDetails.selectedProductDetail.T2Neg.match(/(\d+(\.\d+)?)/g)[0]
        if (SelectedMenuDetails.selectedProductDetail.T2Neg.includes('Target of')) {
          target = SelectedMenuDetails.selectedProductDetail.T2Neg.match(/(\d+(\.\d+)?)/g)[1]
        }
      } else if (SelectedMenuDetails.selectedProductDetail.T2Neg.split(' ')[0].includes('(')) {
        lowerLimit = SelectedMenuDetails.selectedProductDetail.T2Neg.match(/(\d+(\.\d+)?)/g)[0]
        upperLimit = SelectedMenuDetails.selectedProductDetail.T2Neg.match(/(\d+(\.\d+)?)/g)[1]
        if (SelectedMenuDetails.selectedProductDetail.T2Neg.includes('Target of')) {
          target = SelectedMenuDetails.selectedProductDetail.T2Neg.match(/(\d+(\.\d+)?)/g)[2]
        }
      }

      var callimit = SelectedMenuDetails.selectedProductDetail.T2Neg.split(' ')[1]

      var remark;

      if (lowerLimit != 'NA') {
        if (LOD <= upperLimit && LOD >= lowerLimit) {
          remark = 'Pass'
        } else {
          remark = 'Fail'
        }
      }
      else {
        if (LOD > upperLimit) {
          remark = 'Fail'
        } else {
          remark = 'Pass'
        }
      }

      if(LOD.toString().includes('-')) {remark = 'Fail'}
      var ProductCode = await models.tbl_product_master.findAll({
        where: {
          MPN_Code: cubicObj.Sys_MPNCode
        }
      })

      var Pcode = 'NA'
      if (ProductCode[0] == undefined) {
        Pcode = 'NA'
      } else {
        Pcode = ProductCode[0].ProductId,
          actualWt["Product Name"] = ProductCode[0].ProductName;
      }

      var saveLodData = await models.tbl_lodmaster.create({
        MstSerNo: mstSerNo,
        // RepSerNo: mstSerNo,
        BFGCode: cubicObj.Sys_BFGCode,
        SFOID: cubicObj.Sys_SFOID,
        MPN_Code: cubicObj.Sys_MPNCode,
        Repetition: cubicObj.Sys_Repetition,
        // ProductName: actualWt['Product Name'],
        ProductName: cubicObj.Sys_ProductName,
        ProductType: cubicObj?.ProductType ? 1 : 1,
        DsNo: dsNo,
        TabIp: tabIp,
        BatchNo: cubicObj.Sys_Batch,
        StartTm: momentObj().format('HH:mm:ss'),
        CubicleName: cubicObj.Sys_CubicName,
        CubicleType: cubicObj.Sys_CubType,
        CubicalNo: cubicObj.Sys_CubicNo,
        CubicleLocation: cubicObj.Sys_dept,
        Dept: cubicObj.Sys_dept,
        InstruId: 0,
        Side: cubicObj.Sys_RotaryType,
        DryingTemp: Number(actualWt["Drying Temp"].split(" ")[0]),
        SampleWt: 0,
        //LossOnWt: 0 },
        UserId: UserData.UserId,
        UserName: UserData.UserName,
        IsArchived: 0,
        // PrDate: (actualWt.PrDate) ? actualWt.PrDate : actualWt.strtWt.PrDate,
        // PrTime: (actualWt.PrTime) ? actualWt.PrTime : actualWt.strtWt.PrTime,
        PrDate: momentObj().format('YYYY-MM-DD'),
        PrTime: momentObj().format('HH:mm:ss'),
        PrintNo: 0,
        MinLimit: 'NA',
        MaxLimit: limit,
        Remark: remark,
        ReportType: cubicObj.Sys_RptType,
        Lot: cubicObj.Sys_LotNo,
        MachineId: SelectedMenuDetails.EquipmentCode,
        LODID: SelectedMenuDetails.instrumentId,
        Stage: cubicObj.Sys_Stage,
        // PrEndDate: (actualWt.PrEndDate) ? actualWt.PrEndDate : momentObj().format('YYYY-MM-DD'),
        // PrEndDate: (actualWt['Measurement end'].split(' ')[0]) ? momentObj(actualWt['Measurement end'].split(' ')[0], 'DD-MM-YYYY').format('YYYY-MM-DD') : momentObj().format('YYYY-MM-DD'),
        // PrEndTime: (actualWt['Measurement end'].split(' ')[1]) ? actualWt['Measurement end'].split(' ')[1] : momentObj().format('hh:mm:ss'),
        PrEndDate: momentObj().format('YYYY-MM-DD'),
        PrEndTime: momentObj().format('HH:mm:ss'),
        Unit: 0,
        DecimalPoint: decimalPoint,
        WgmtModeNo: "16",
        BatchComplete: 0,
        PVersion: cubicObj.Sys_PVersion,
        Version: cubicObj.Sys_Version,
        InitalWt: startWeight,
        FinalWt: endWeight,
        NetWt: Number(LOD).toFixed(lodPerDp),
        Duration: actualWt["Total time"] ? actualWt["Total time"] : 'NA', //.totaltime,,
        DryingProgram: actualWt["Drying Prog"] ? actualWt["Drying Prog"] : 'NA',
        SwitchOff: actualWt["Switch Off"] ? actualWt["Switch Off"] : 'NA',
        MoistCont: 0,
        RotaryType: 0,
        IPQCType: cubicObj.Sys_IPQCType,
        BatchSize: `${cubicObj.Sys_BatchSize} ${cubicObj.Sys_BatchSizeUnit}`,
        Layer: layer,
        LayerName: layerName,
        // SetTemp: Number(actualWt.temp.temp),
        // GranuRepoHeading: GranuRepoHeading,
        RepoLabel11: cubicObj.Sys_Validation,
        Area: cubicObj.Sys_Area,
        AppearanceDesc: cubicObj.Sys_Appearance,
        MachineSpeed_Min: cubicObj.Sys_MachineSpeed_Min,
        MachineSpeed_Max: cubicObj.Sys_MachineSpeed_Max,
        GenericName: cubicObj.Sys_GenericName,
        BMRNo: cubicObj.Sys_BMRNo,
        Temp: Number(actualWt["Drying Temp"].split(" ")[0]),
        CubicleID: cubicObj.Sys_CubicNo,
        Test_Seq: mstSerNo,
        Make: LODInfo.Eqp_Make,
        Model: LODInfo.Eqp_Model,
        SerialNo: actualWt["SNR"] ? actualWt["SNR"] : 'NA'
      })


      // let mahcineDetails = await models.tbl_machine.findAll({
      //   where: {
      //     Machine_ID: cubicObj.Sys_MachineCode
      //   }
      // })

      let previousBatchEntry = await models.tbl_batchsummary_masterLOD.findAll({
        where: {
          BatchNo: cubicObj.Sys_Batch,
          Area: cubicObj.Sys_Area,
          CubicName: cubicObj.Sys_CubicName
          // Side: machineRotary
        }
      })
      let masterRepSerNo;
      if (previousBatchEntry.length > 0) {
        masterRepSerNo = previousBatchEntry[0].RepSerNo;
      } else {
        let batchtime = await models.tbl_batches.findOne({
          where: {
            Batch: cubicObj.Sys_Batch,
            Status: 'S'
          }
        })

        // let machineRotary = mahcineDetails[0]?.Machine_Rotary == 'Double' ? mahcineDetails[0]?.Machine_Rotary : 'NA';

        let masterEntry = await models.tbl_batchsummary_masterLOD.create({
          MPN_Code: saveLodData._previousDataValues.MPN_Code,
          BFGCode: saveLodData._previousDataValues.BFGCode,
          ProductName: saveLodData._previousDataValues.ProductName,
          // PVersion: saveLodData._previousDataValues.PVersion,
          VersiNo: saveLodData._previousDataValues.Version,
          BatchNo: saveLodData._previousDataValues.BatchNo,
          CubicleType: saveLodData._previousDataValues.CubicleType,
          // Stage: cubicObj.Sys_Stage,
          Unit: '%w/w',
          // Side: cubicObj.Sys_RotaryType,
          Side: 'NA',
          // IsArchived: masterEntry[0].IsArchived,
          // LimitOn: masterEntry[0].LimitOn,
          Area: cubicObj.Sys_Area,
          BatchSize: `${cubicObj.Sys_BatchSize} ${cubicObj.Sys_BatchSizeUnit}`,
          MachineCode: saveLodData._previousDataValues.MachineId,
          StartDate: `${momentObj(batchtime.dt).format("YYYY-MM-DD")} ${momentObj(batchtime.tm).format('HH:mm:ss')}`,
          ReportType: saveLodData._previousDataValues.ReportType,
          PrdType: saveLodData._previousDataValues.ProductType,
          CubicalNo: cubicObj.Sys_CubicNo,
          BatchCompleted: 0,
          NoOfStations: 1,
          Repetition: saveLodData._previousDataValues.Repetition,
          SFOID: saveLodData._previousDataValues.SFOID,
          UserName: UserData.UserName,
          InstrumentID: cubicObj.Sys_MoistID,
          CubicName: cubicObj.Sys_CubicName,
          Date: momentObj().format('YYYY.DD.MM'),
          LotNo:cubicObj.Sys_LotNo
        })

        masterRepSerNo = masterEntry._previousDataValues.RepSerNo
      }

      let date = saveLodData._previousDataValues.PrDate
      let endDate = saveLodData._previousDataValues.PrEndDate
      let time = saveLodData._previousDataValues.PrTime
      let endTime = saveLodData._previousDataValues.PrEndTime

      // let masterRepSerNo = await this.checkMasterEntryOfPerticularBatch(data.cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, masterEntry[0].HardnessID, userInfo)
      let recSequenceNo = await objCommonInsertOpt.findRecSequenceNumber(masterRepSerNo, "LOD", [saveLodData._previousDataValues]);


      await models.tbl_batchsummary_detailLOD.create({
        RepSerNo: masterRepSerNo,
        Side: saveLodData._previousDataValues.Side,
        Min: saveLodData._previousDataValues.NetWt,
        Max: saveLodData._previousDataValues.NetWt,
        Avg: saveLodData._previousDataValues.NetWt,
        LODValue: saveLodData._previousDataValues.NetWt,
        TestResult: saveLodData._previousDataValues.Remark,
        RecSeqNo: recSequenceNo,
        LSL: lowerLimit,
        USL: upperLimit,
        Target: target,
        UserID: UserData.UserId,
        UserName: UserData.UserName,
        LHSContainerNo: 'NA',
        RHSContainerNo: 'NA',
        Repetition: saveLodData._previousDataValues.Repetition,
        StartTime: `${momentObj(date).format('DD.MM.YYYY')} ${momentObj(time).format("HH:mm:ss")}`,
        EndTime: `${momentObj(endDate).format('DD.MM.YYYY')} ${momentObj(endTime).format("HH:mm:ss")}`,
        InstrumentID: saveLodData._previousDataValues.LODID,
        SFOID: saveLodData._previousDataValues.SFOID,
        Side: 'NA',
        Lot: cubicObj.Sys_LotNo
      })


      let batchsummaryDetailEntries = await models.tbl_batchsummary_detailLOD.findAll({
        where: {
          RepSerNo: masterRepSerNo
        }
      })

      let IndAvg, IndMin, IndMax
      if (batchsummaryDetailEntries.length > 0) {
        let dataValueMax = [];
        let dataValueMin = [];
        let avg = batchsummaryDetailEntries.map((e) => {
          dataValueMax.push(e.Max)
          dataValueMin.push(e.Min)
          return e.Avg
        }
        );
        IndAvg = objcalc.avgCalc(avg, 3)
        IndMin = maths.min(...dataValueMin);
        IndMax = maths.max(...dataValueMax);

      }

      await models[`tbl_batchsummary_masterLOD`].update({
        AvgValue: IndAvg,
        MinValue: IndMin,
        MaxValue: IndMax
      },
        {
          where: {
            RepSerNo: masterRepSerNo
          }
        }
      )

    const lodObj = await models.tbl_lodmaster.findAll({
       where : {
        MstSerNo: mstSerNo,
        BatchNo: cubicObj.Sys_Batch,
        Repetition: cubicObj.Sys_Repetition
       }
    })

      let mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.DsNo == dsNo && e.TabIp == tabIp && e.portNo == ProtocolPortNo && e.isPosted == false)
      if (mesData.length == 0 && cubicObj.isManual == 0) {
        let selectedDSNo = dsNo;
        let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == dsNo && k.tabIp == tabIp);
        if (arrIPQC != undefined) {
          selectedDSNo = arrIPQC.selectedDs.dsNo
        }

        let data = {
          menuName: menuName,
          payload: [],
          DsNo: dsNo,
          TabIp: tabIp,
          selectedDSNo: selectedDSNo,
          portNo: ProtocolPortNo,
          isCompleted: false,
          isPosted: false,
          RptType: cubicObj.Sys_RptType,
          batchId: cubicObj.Sys_Batch,
          sfoId: cubicObj.Sys_SFOID,
          instrumentId: SelectedMenuDetails.instrumentId,
          Mpn: cubicObj.Sys_MPNCode,
          Repetition: cubicObj.Sys_Repetition,
          Area: cubicObj.Sys_Area,
          RepSerNo: lodObj[0].RepSerNo
        }
        globalData.MESArray.push(data)
        mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.DsNo == dsNo && e.TabIp == tabIp && e.portNo == ProtocolPortNo && e.isPosted == false)
      }

      mqttSender.sendData(
        dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${JSON.stringify([actualWt])}`
      );

      await objMonit.monit({
        case: 'TestWeight',
        Hmi: dsNo,
        data: {
          Weight: `${JSON.stringify([actualWt])}`,
          srNo: 1,
          message: `${menuName} Test Completed`
        }
      });
      let activity_msg = `${menuName} Test Completed on DS ${dsNo}`
      let __activityObj = {
        strUserId: UserData.UserId,
        strUserName: UserData.UserName,
        activity: activity_msg,
        batch: cubicObj.Sys_Batch
      };

      await objActivityLog.ActivityLogEntry(__activityObj);
      await objInstrumentUsage.InstrumentUsage(
        'LOD',
        dsNo,
        `tbl_instrumentlog_lod`,
        menuName,
        "started",
        tabIp,
        UserData,
        cubicObjData,
        // actualWt['Product Name'],
        cubicObj.Sys_ProductName
      );

      if (cubicObj.isManual == 0) {
        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted} Test Completed:OkBtn false`
        );
        mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
        mesData[0].payload.push({ data: { value: actualWt, isMesChecked: false } })
        mesData[0].isCompleted = true
        // return globalData.MESArray
      } else {
        await models.tbl_mes_data.destroy({ where: { DS_Number: dsNo } });
        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted} Test Completed:OkBtn true`
        );
      }
      await objMonit.monit({
        case: 'ReportStatus', Hmi: dsNo, data: {
          message: `${menuName} Test Completed`
        }
      });
      (globalData.arrProtocolData.findIndex((element) => element.DsNo === dsNo)) == -1 ?
        globalData.arrProtocolData :
        globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.DsNo === dsNo), 1);

      globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
        ? globalData.arrSelectedMenu
        : globalData.arrSelectedMenu.splice(
          globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
          1
        );

      globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
        ? globalData.arrCurrentOperationStatus
        : globalData.arrCurrentOperationStatus.splice(
          globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
          1
        );
        
        globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.Ip == tabIp) == -1
        ? globalData.dataMoist
        : globalData.dataMoist.splice(
          globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.Ip == tabIp),
          1
        );
    } catch (err) {
      throw new Error(err)
    }
  }

  // async insertBulkWeighmentLOD(dataObj) {
  //   let dsNo = dataObj.DsNo;
  //   let tabIp = dataObj.TabIp;
  //   var menu = dataObj.menuName
  //   const tempUserObject = globalData.arrUsers.find(k => k.DsNo == dsNo);
  //   let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
  //   let getProductType = await models.tbl_product_master.findOne({ where: { ProductId: cubicObj.Sys_BFGCode, ProductName: cubicObj.Sys_ProductName } })
  //   if (getProductType) { cubicObj.ProductType = getProductType.ProductType };
  //   dataObj.UserData = tempUserObject;
  //   dataObj.cubicObj = cubicObj;
  //   // let selectedIdsNo;
  //   // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == dsNo);
  //   // if (IPQCObject != undefined) {
  //   //   selectedIdsNo = IPQCObject.selectedIds;
  //   // } else {
  //   //   selectedIdsNo = dsNo;
  //   // }
  //   let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
  //   if (tempCounterObj === undefined) {
  //     globalData.arrWeighmentCounter.push({ 'DsNo': dsNo, TabIp: tabIp, 'counter': 0 })
  //   }
  //   tempCounterObj = globalData.arrWeighmentCounter.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
  //   // await objInstrumentUsage.InstrumentUsage('LOD', dsNo, 'tbl_instrumentlog_lod', menu, 'started');

  //   // var objActivity = {};
  //   // Object.assign(objActivity,
  //   //     { strUserId: tempUserObject.UserId },
  //   //     { strUserName: tempUserObject.UserName },
  //   //     { activity: `${menu} Weighment Started on TSH ` + strHmi });
  //   // await objActivityLog.ActivityLogEntry(objActivity);
  //   if (tempCounterObj.counter == 0) {
  //     //insert initial and temp

  //     // Instrument usage for LOD started
  //     // await objInstrumentUsage.InstrumentUsage('LOD', dsNo, 'tbl_instrumentlog_lod', menu, 'started');
  //     await this.saveLodData(dataObj, tempCounterObj.counter);
  //     tempCounterObj.counter += 1;
  //   } else {
  //     await this.saveLodData(dataObj, tempCounterObj.counter);
  //   }
  // }

  // async saveLodData(dataObj, counter) {
  //   try {
  //     var department = "";
  //     let responseObj = {};

  //     let cubicObj = dataObj.cubicObj;
  //     var tempMenuLOD = dataObj.SelectedMenuDetails;

  //     var cubicType = 0, GranuRepoHeading = 0, decimalPoint;
  //     var lodData = globalData.arrProtocolData.find(k => k.DsNo == dsNo);
  //     // let LOTDetails = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
  //     // let selectedIdsNo;
  //     // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
  //     // if (IPQCObject != undefined) {
  //     //   selectedIdsNo = IPQCObject.selectedIds;
  //     // } else {
  //     //   selectedIdsNo = IdsNo;
  //     // }


  //     // var ProductType = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIdsNo).productType; //ProductType
  //     // if (cubicObj.Sys_CubType == 'IPQC' && (cubicObj.Sys_Area == 'Granulation' || cubicObj.Sys_Area == 'Granulation IPQC'
  //     //   || cubicObj.Sys_Area == 'IPQC-II' || cubicObj.Sys_Area == 'IPQC-I' || cubicObj.Sys_Area == 'Pallet Coating')) {

  //     //   var selectedCubicle = productObj;
  //     //   cubicType = 1;
  //     //   // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
  //     //   switch (dataObj.menuName) {
  //     //     case GLOBAL_NOMENCLATURE.granulationDry: // COMPRESSED DRY
  //     //     case GLOBAL_NOMENCLATURE.LODMenu:
  //     //       GranuRepoHeading = 1;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.granulationLub: //COMPRESSED LUB
  //     //       GranuRepoHeading = 43;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.lay1Dry:
  //     //       GranuRepoHeading = 4;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.lay1Lub:
  //     //     case GLOBAL_NOMENCLATURE.LODLayer1Menu:
  //     //       GranuRepoHeading = 44;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.lay2Dry:
  //     //       GranuRepoHeading = 5;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.lay2Lub:
  //     //       GranuRepoHeading = 6;
  //     //       break;
  //     //     case GLOBAL_NOMENCLATURE.LODLayer2Menu:
  //     //       GranuRepoHeading = 7;
  //     //       break;
  //     //     default:
  //     //       // for coating and compression
  //     //       // Finding Out the department of selected for coating and compression
  //     //       var objGranuInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
  //     //       let objCompCoatInfo = globalData.arrIdsInfo.find(k => k.Sys_ProductName == objGranuInfo.cubicalData.Sys_ProductName
  //     //         && k.Sys_BFGCode == objGranuInfo.cubicalData.Sys_BFGCode && k.Sys_PVersion == objGranuInfo.cubicalData.Sys_PVersion
  //     //         && k.Sys_Version == objGranuInfo.cubicalData.Sys_Version && (k.Sys_Area != 'Granulation' || k.Sys_Area != 'Effervescent Granulation'));

  //     //       // department = objCompCoatInfo.Sys_dept;
  //     //       selectedCubicle = objCompCoatInfo;
  //     //       GranuRepoHeading = 0;
  //     //       cubicType = 0;
  //     //   }
  //     // } else {
  //     //   // For Compression and coating
  //     //   cubicType = 0;
  //     //   GranuRepoHeading = 0;
  //     // }
  //     // let now = new Date();
  //     let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
  //     lodData = globalData.arrProtocolData.find(k => k.DsNo == dsNo);
  //     lodData.Parsedata = arrLodData
  //     if ((lodData != undefined)) {

  //       if ((lodData.Modal == 'MA160-1' && lodData == undefined) || (lodData.Modal == 'MA150' && lodData == undefined)) {
  //         var objLodData = globalData.arrLodData.find(LD => LD.DsNo == dsNo && LD.TabIp == tabIp);
  //         if (objLodData == undefined) {
  //           globalData.arrLodData.push({ DsNo: dsNo, TabIp: tabIp, arr: [], counter: 0 })
  //         }
  //         else {
  //           objLodData.arr = [];
  //         }
  //         console.log('InValid LOD data string');
  //         return 'Invalid data string';
  //       }
  //       if (lodData.setTemp.flag == true) {
  //         var productTableName = "";
  //         if (cubicObj.ProductType == 1) {
  //           if (cubicObj.Sys_Area == "Scaleup Area") {
  //             if (cubicObj.Sys_IPQCType == "Coating") {
  //               productTableName = 'tbl_product_tablet_coated';
  //             } else if (cubicObj.Sys_IPQCType == "Compression") {
  //               productTableName = 'tbl_product_tablet';
  //             }

  //           } else if (cubicObj.Sys_Area == "Tablet Office") {
  //             productTableName = "tbl_product_tablet"
  //           }
  //         } else {
  //           if (cubicObj.Sys_Area == "Scaleup Area") {
  //             productTableName = 'tbl_product_capsule';
  //           }
  //         }
  //         if (cubicObj.Sys_Area == 'Compression' || cubicObj.Sys_Area == 'Granulation IPQC' || cubicObj.Sys_Area == 'Tablet Office') {
  //           productTableName = "tbl_product_tablet";
  //         } else if (cubicObj.Sys_Area == 'Coating') {
  //           productTableName = "tbl_product_tablet_coated";
  //         }

  //         if (cubicObj.Sys_Area == 'Pellets-II' || cubicObj.Sys_Area == 'Granulation' || cubicObj.Sys_Area == 'IPQC-II' || cubicObj.Sys_Area == 'IPQC-I') {
  //           productTableName = "tbl_product_gran";
  //         }
  //         var res = await proObj.productData(currentCubicle, productTableName);


  //         var layer = 'NA';
  //         var layerName = 'NA';

  //         // if (GranuRepoHeading == 4 || GranuRepoHeading == 44) {
  //         //   layer = 'Layer 1';
  //         //   layerName = res[0].IsBilayerLbl;
  //         // } else if (GranuRepoHeading == 7) {
  //         //   layer = 'Layer 2';
  //         //   layerName = res[0].IsTrilayerLbl;
  //         // }

  //         // if (GranuRepoHeading != 0) {
  //         //   var paramNom = `Param${GranuRepoHeading}_Nom`;
  //         //   var paramLow = `Param${GranuRepoHeading}_Low`;
  //         //   var paramUpp = `Param${GranuRepoHeading}_Upp`;
  //         //   var paramDp = `Param${GranuRepoHeading}_DP`;
  //         //   var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
  //         // } else {
  //         //   var paramNom = `Param16_Nom`;
  //         //   var paramLow = `Param16_T1Neg`;
  //         //   var paramUpp = `Param16_T1Pos`;
  //         //   var paramDp = `Param16_DP`;
  //         //   var paramIsOnStd = `Param16_LimitOn`;
  //         // }


  //         const checkData = await models.tbl_lodmaster.findAll({
  //           attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'RepSerNo']],
  //           where: {
  //             BFGCode: currentCubicle.Sys_BFGCode,
  //             ProductName: currentCubicle.Sys_ProductName,
  //             BatchNo: currentCubicle.Sys_Batch,
  //             DsNo: dsNo,
  //             IPQCType: cubicObj.Sys_IPQCType,
  //           }
  //         })
  //         let result = checkData;
  //         var intMstSerNo;
  //         if (result[0].RepSerNo == null) {
  //           intMstSerNo = 1;
  //         } else {
  //           var newMstSerNo = result[0].RepSerNo + 1;
  //           intMstSerNo = newMstSerNo;
  //         }
  //         const checkBRepSer = await models.tbl_lodmaster.findAll({
  //           attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'BRepSerNo']],
  //           where: {
  //             BFGCode: cubicObj.Sys_BFGCode,
  //             ProductName: cubicObj.Sys_ProductName,
  //             BatchNo: cubicObj.Sys_Batch,
  //             ReportType: cubicObj.Sys_RptType,
  //             Side: cubicObj.Sys_RotaryType,
  //             IPQCType: cubicObj.Sys_IPQCType
  //           }
  //         })

  //         let batchResult = checkBRepSer;
  //         if (batchResult[0] != undefined) {
  //           var intBRepSerNo;
  //           if (batchResult[0].BRepSerNo == null) {
  //             intBRepSerNo = 1;
  //           } else {
  //             var newBRepSerNo = batchResult[0].BRepSerNo + 1;
  //             intBRepSerNo = newBRepSerNo;
  //           }
  //         } else {
  //           intBRepSerNo = 1;
  //         }

  //         decimalPoint = lodData.iniWt.iniWt.split(".")[1].length
  //         // lodData.iniWt.iniWt = this.math.round(lodData.iniWt.iniWt, 3).toFixed(3);
  //         // lodData.finalWt.finalWt = this.math.round(lodData.finalWt.finalWt, 3).toFixed(3);
  //         var saveLodData = await models.tbl_lodmaster.create({
  //           MstSerNo: intMstSerNo,
  //           BRepSerNo: intBRepSerNo,
  //           BFGCode: currentCubicle.Sys_BFGCode,
  //           ProductName: currentCubicle.Sys_ProductName,
  //           ProductType: ProductType.ProductType,
  //           DsNo: dsNo,
  //           TabIp: tabIp,
  //           BatchNo: currentCubicle.Sys_Batch,
  //           StartTm: momentObj().format('HH:mm:ss'),
  //           CubicleName: currentCubicle.Sys_CubicName,
  //           CubicleType: currentCubicle.Sys_CubType,
  //           CubicalNo: currentCubicle.Sys_CubicNo,
  //           CubicleLocation: currentCubicle.Sys_dept,
  //           Dept: currentCubicle.Sys_dept,
  //           InstruId: 0,
  //           Side: currentCubicle.Sys_RotaryType,
  //           DryingTemp: 0,
  //           SampleWt: 0,
  //           //LossOnWt: 0 },
  //           UserId: tempUserObject.UserId,
  //           UserName: tempUserObject.UserName,
  //           IsArchived: 0,
  //           PrDate: (lodData.PrDate) ? lodData.PrDate : lodData.iniWt.PrDate,
  //           PrTime: (lodData.PrTime) ? lodData.PrTime : lodData.iniWt.PrTime,
  //           PrintNo: 0,
  //           Remark: 0,
  //           ReportType: currentCubicle.Sys_RptType,
  //           MachineId: currentCubicle.Sys_MachineCode,
  //           // MinLimit: res[1][paramLow].toFixed(2),
  //           // MaxLimit: res[1][paramUpp].toFixed(2),
  //           // MinLimit:tempMenuLOD.selectedProductDetail.T1Neg.toFixed(2),
  //           // MaxLimit: tempMenuLOD.selectedProductDetail.T1Pos.toFixed(2),
  //           MinLimit: tempMenuLOD.selectedProductDetail.T1Neg != 'NA' ? Number(mathj.round(tempMenuLOD.selectedProductDetail.T1Neg, 2)).toFixed(2) : 'NA',
  //           MaxLimit: tempMenuLOD.selectedProductDetail.T1Pos != 'NA' ? Number(mathj.round(tempMenuLOD.selectedProductDetail.T1Pos, 2)).toFixed(2) : 'NA',
  //           Stage: currentCubicle.Sys_Stage,
  //           PrEndDate: (lodData.PrEndDate) ? lodData.PrEndDate : lodData.finalWt.PrEndDate,
  //           PrEndTime: (lodData.PrEndTime) ? lodData.PrEndTime : lodData.finalWt.PrEndTime,
  //           Unit: 0,
  //           DecimalPoint: decimalPoint,
  //           WgmtModeNo: "16",
  //           BatchComplete: 0,
  //           LODID: cubicObj.Sys_MoistID,
  //           PVersion: currentCubicle.Sys_PVersion,
  //           Version: currentCubicle.Sys_Version,
  //           //  CheckedByID', value: nwtAfterTest },
  //           //  CheckedByName', value: lwtBeforeTest },
  //           //  CheckedByDate', value: lwtAfterTest },
  //           // Lot: LOTDetails.data.lotno,
  //           // RunTime: rwtBeforeTest },
  //           // DryWt: isModalExist ? arrLodData[2].iniWt.iniWt.split(' ')[0] : arrLodData[1].iniWt,
  //           InitalWt: parseFloat(lodData.iniWt.iniWt).toFixed(3),
  //           FinalWt: parseFloat(lodData.finalWt.finalWt).toFixed(3),
  //           Duration: lodData.totaltime ? lodData.totaltime : 'NA', //.totaltime,,
  //           MoistCont: 0,
  //           RotaryType: 0,
  //           IPQCType: currentCubicle.Sys_IPQCType,
  //           //SerialNo: date.format(now, 'HH:mm:ss') },
  //           BatchSize: `${currentCubicle.Sys_BatchSize} ${currentCubicle.Sys_BatchSizeUnit}`,
  //           Layer: layer,
  //           LayerName: layerName,
  //           // SetTemp: parseFloat(lodData.setTemp.setTempp),
  //           // IsRepoComp: cubicType,
  //           GranuRepoHeading: GranuRepoHeading,
  //           RepoLabel11: currentCubicle.Sys_Validation,
  //           // Lot: hmiDetails.LotNo,
  //           Area: currentCubicle.Sys_Area,
  //           AppearanceDesc: currentCubicle.Sys_Appearance,
  //           MachineSpeed_Min: currentCubicle.Sys_MachineSpeed_Min,
  //           MachineSpeed_Max: currentCubicle.Sys_MachineSpeed_Max,
  //           GenericName: currentCubicle.Sys_GenericName,
  //           BMRNo: currentCubicle.Sys_BMRNo,
  //           Temp: lodData.setTemp.setTemp,
  //           CubicleID: currentCubicle.CubicleID
  //         })
  //         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(lodData)}`)



  //         // await database.save(saveLodData);
  //         Object.assign(responseObj, { status: 'success' });
  //         // If Initial weight completes then set initWt flag to false
  //         // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
  //         lodData.setTemp.flag = false;
  //         //clear
  //       }
  //       //resolve(responseObj);

  //       let result = await this.SaveLodLastPortion(productObj, tempUserObject, IdsNo, lodData, cubicType, responseObj);

  //       globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrSelectedMenu
  //         : globalData.arrSelectedMenu.splice(
  //           globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arrLODTypeSelectedMenu.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrLODTypeSelectedMenu
  //         : globalData.arrLODTypeSelectedMenu.splice(
  //           globalData.arrLODTypeSelectedMenu.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arr_IPQCRelIds.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arr_IPQCRelIds
  //         : globalData.arr_IPQCRelIds.splice(
  //           globalData.arr_IPQCRelIds.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arrLodData.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrLodData
  //         : globalData.arrLodData.splice(
  //           globalData.arrLodData.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.DsNo == dsNo && element.TabIp == tabIp), 1);
  //       return result;
  //       // else {

  //       //     return `${protocolIncomingType}R0,,,,,`;
  //       // }

  //     }
  //     else {
  //       const objMasterData = await models.tbl_lodmaster.findAll({
  //         // data: 'max(RepSerNo) as RepSerNo',
  //         attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //         where: {
  //           BFGCode: currentCubicle.Sys_BFGCode,
  //           ProductName: currentCubicle.Sys_ProductName,
  //           PVersion: currentCubicle.Sys_PVersion,
  //           Version: currentCubicle.Sys_Version,
  //           BatchNo: currentCubicle.Sys_Batch,
  //           DsNo: dsNo,
  //           // IsRepoComp: cubicType,
  //         }
  //       })

  //       // let res = await database.select(objMasterData);
  //       var maxRepNo = objMasterData[0].RepSerNo;
  //       const updateData = await models.tbl_lodmaster.update({
  //         LossOnWt: tempLODdata.arr[2].finalWt,
  //       }, {
  //         where: {
  //           RepSerNo: maxRepNo,
  //         }

  //       });
  //       // await database.update(updateData);
  //       let result = await this.SaveLodLastPortion(productObj, tempUserObject, IdsNo, protocolIncomingType, tempLODdata, cubicType, responseObj);
  //       //clear Array

  //       globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrSelectedMenu
  //         : globalData.arrSelectedMenu.splice(
  //           globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arrLODTypeSelectedMenu.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrLODTypeSelectedMenu
  //         : globalData.arrLODTypeSelectedMenu.splice(
  //           globalData.arrLODTypeSelectedMenu.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arr_IPQCRelIds.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arr_IPQCRelIds
  //         : globalData.arr_IPQCRelIds.splice(
  //           globalData.arr_IPQCRelIds.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );

  //       globalData.arrLodData.findIndex((k) => k.DsNo == dsNo) == -1
  //         ? globalData.arrLodData
  //         : globalData.arrLodData.splice(
  //           globalData.arrLodData.findIndex((k) => k.DsNo == dsNo),
  //           1
  //         );
  //       globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.DsNo === dsNo), 1);
  //       return result;
  //     }
  //   }
  //   catch (err) {
  //     // var objLodData = globalData.arrLodData.find(LD => LD.DsNo == dsNo && LD.TabIp == tabIp);
  //     // if (objLodData == undefined) {
  //     //   globalData.arrLodData.push({ DsNo: dsNo, tabIp: tabIp, arr: [], counter: 0 })
  //     // }
  //     // else {
  //     //   objLodData.arr = [];
  //     // }
  //     // Error loging in Error file
  //     // var logError = momentObj().format('DD-MM-YYYY HH:mm:ss');
  //     // console.log(err.stack)
  //     throw new Error(err);
  //   }
  // }

  // async SaveLodLastPortion(dataObj, tempLODdata, cubicType, responseObj) {
  //   var currentCubicle = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo)
  //   var strHmi = currentCubicle.Hmi
  //   currentCubicle = currentCubicle.cubicalData
  //   var menuName = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
  //   const objMasterData = await models.tbl_lodmaster.findAll({
  //     attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //     where: {
  //       BFGCode: currentCubicle.Sys_BFGCode,
  //       ProductName: currentCubicle.Sys_ProductName,
  //       PVersion: currentCubicle.Sys_PVersion,
  //       Version: currentCubicle.Sys_Version,
  //       BatchNo: currentCubicle.Sys_Batch,
  //       IdsNo: strHmi,
  //       // IsRepoComp: cubicType,
  //     }
  //   })

  //   let res = objMasterData;
  //   var maxRepNo = res.pop();
  //   var RepSerNo = maxRepNo.RepSerNo

  //   var menu = menuName.menuName
  //   await objInstrumentUsage.InstrumentUsage('LOD', IdsNo, 'tbl_instrumentlog_lod', menu, 'completed');
  //   var objActivity = {};
  //   Object.assign(objActivity,
  //     { strUserId: tempUserObject.UserId },
  //     { strUserName: tempUserObject.UserName },
  //     { activity: `${menu} Weighment Completed on TSH ` + strHmi });

  //   await objActivityLog.ActivityLogEntry(objActivity);
  //   mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
  //   var currentCubicle = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
  //   var cubicalData = currentCubicle.cubicalData;
  //   // if (!(cubicalData.Sys_IPQCType == 'Compression' && cubicalData.Sys_Area == "Coating")) {
  //   //     await objBatchSummary.saveBatchSummaryLOD(productObj, strHmi, tempLODdata, tempUserObject);
  //   // }
  //   // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
  //   // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitalWt-FinalWt)/InitalWt)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(MinLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(MaxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${RepSerNo}`);
  //   var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100).toFixed(2)
  //   Object.assign(responseObj, { status: 'success' })
  //   var remark;
  //   if (maxRepNo.MinLimit.includes(99999)) {
  //     maxRepNo.MinLimit = 0
  //   }
  //   if (parseFloat(LOD) < parseFloat(maxRepNo.MinLimit) ||
  //     parseFloat(LOD) > parseFloat(maxRepNo.MaxLimit)) {
  //     remark = "Not Complies";
  //     // remark = "Out of Limit";
  //   } else {
  //     remark = "Complies";
  //     // remark = "Within Limit";
  //   }

  //   const updatelodmaster = await models.tbl_lodmaster.update(
  //     {
  //       NetWt: Number(LOD).toFixed(2),
  //       Remark: remark
  //     },
  //     {
  //       where: {
  //         RepSerNo: RepSerNo
  //         // Idsno: strHmi,
  //       },
  //     }
  //   );
  //   //   return updatelodmaster;



  //   //OPC post tagss

  //   let lodMasterData = await models.tbl_lodmaster.findAll({
  //     where: {
  //       RepSerNo: RepSerNo
  //     }
  //   })

  //   var lodObj = {
  //     BatchNo: lodMasterData[0].BatchNo,
  //     SetDryingTemp: lodMasterData[0].Temp,
  //     FinalWeight: lodMasterData[0].FinalWt,
  //     Layer: lodMasterData[0].Layer,
  //     ActLossOnDrying: lodMasterData[0].NetWt,
  //     Lot: lodMasterData[0].Lot,
  //     TestType: cubicalData.Sys_RptType == 0 ? "Regular" : "Initial",
  //     ProdName: lodMasterData[0].ProductName,
  //     TestResult: lodMasterData[0].Remark == "Complies" ? 1 : 0,
  //     Stage: lodMasterData[0].Stage,
  //     StartWeight: lodMasterData[0].InitalWt,
  //     TestName: "L.O.D. Test",
  //     LODID: lodMasterData[0].LODID,
  //     PrEndDate: lodMasterData[0].PrEndDate,
  //     PrEndTime: momentObj(lodMasterData[0].PrEndTime).format("HH:mm:ss"),
  //     PrDate: lodMasterData[0].PrDate,
  //     PrTime: momentObj(lodMasterData[0].PrTime).format("HH:mm:ss")
  //   }

  //   await objopcOps.MoistAnalizer(lodObj, strHmi);
  //   //
  //   if (cubicalData.Sys_RptType == 0) {
  //     var objOnlineReport = {
  //       SelectedAction: maxRepNo,
  //       UserId: tempUserObject.UserId,
  //       UserName: tempUserObject.UserName,
  //       waterMark: true,
  //       SelectedValue: LOD,
  //     }
  //     const objPrinterName = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);

  //     var objReport = {
  //       reportOption: 'Moisture Analyzer',
  //       RepSerNo: maxRepNo
  //     }
  //     // await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.cubicalData.Sys_PrinterName);
  //   } else {
  //     // console.log('Initial report')
  //   }

  //   if (remark == "Complies") {
  //     var repop = 'LOD';
  //     var intProductType = 1;

  //     // if (menu == GLOBAL_NOMENCLATURE.LODMenu) {
  //     //     repop = 'LOD';
  //     // } else if (menu == GLOBAL_NOMENCLATURE.LODLayer1Menu) {
  //     //     repop = 'LOD Layer 1';
  //     // } else if (menu == GLOBAL_NOMENCLATURE.LODLayer2Menu) {
  //     //     repop = 'LOD Layer 2';
  //     // }

  //     if (menu == GLOBAL_NOMENCLATURE.LODMenu) {
  //       repop = 'LOD';
  //     } else if (menu == GLOBAL_NOMENCLATURE.granulationDry) {
  //       repop = 'Granulation Dry';
  //     } else if (menu == GLOBAL_NOMENCLATURE.granulationLub) {
  //       repop = 'Granulation Lubricant';
  //     } else if (menu == GLOBAL_NOMENCLATURE.lay1Dry) {
  //       repop = 'Layer 1 Granulation Dry';
  //     } else if (menu == GLOBAL_NOMENCLATURE.lay1Lub) {
  //       repop = 'Layer 1 Granulation Lubricant';
  //     } else if (menu == GLOBAL_NOMENCLATURE.LODLayer1Menu) {
  //       repop = 'LOD LAYER 1';
  //     } else if (menu == GLOBAL_NOMENCLATURE.LODLayer2Menu) {
  //       repop = 'LOD LAYER 2';
  //     }

  //     var printObj = {
  //       recordFrom: "Current",
  //       Side: "Single",
  //       reportOption: repop,
  //       reportType: "Complete",
  //       testType: "Regular",
  //       RepSerNo: RepSerNo,
  //       batchNo: cubicalData.Sys_Batch,
  //       cubicleType: cubicalData.Sys_CubType,
  //       userId: tempUserObject.UserId,
  //       username: tempUserObject.UserName,
  //       int_ReportFormat: 1,
  //       printNo: 0,
  //       str_url: intProductType === 1 ? "Tablet" : "Capsule"
  //     }

  //     await printOperations.callViewTabReport(printObj, intProductType, strHmi);
  //   }


  //   //clearing and reiniting LOD DATA
  //   var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //   if (objLodData == undefined) {
  //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [], counter: 0 })
  //   }
  //   else {
  //     objLodData.arr = [];
  //   }
  //   return 'LOD Weighment Completed on TSH';
  // }




  // async insertBulkWeighmentLOD(dataObj) {
  //   var actualProtocol = dataObj.actualWt;
  //   let now = new Date();
  //   let dsNo = dataObj.DsNo;
  //   let tabIp = dataObj.TabIp;
  //   var dsIp = dataObj.DsIp;
  //   // var tdValue = actualProtocol.substring(0, 5);//starting
  //   let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
  //   const tempUserObject = globalData.arrUsers.find((k) => k.DsNo == dsNo);
  //   dataObj.cubicObj = cubicObj
  //   // var protocolIncomingType = tdValue.substring(0, 1);//here incoming protocol is check T Or H
  //   // let selectedIdsNo;
  //   // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
  //   // if (IPQCObject != undefined) {
  //   //   selectedIdsNo = IPQCObject.selectedIds;
  //   // } else {
  //   //   selectedIdsNo = strIdsNo;
  //   // }

  //   const obj = await models.tbl_otherequipment.findOne({ where: { Eqp_ID: cubicObj.Sys_MoistID } });
  //   let tempCounterObj = globalData.arrWeighmentCounter.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
  //   if (tempCounterObj === undefined) {
  //     globalData.arrWeighmentCounter.push({ DsNo: dsNo, TapIp: tabIp, counter: 0 });
  //   }
  //   tempCounterObj = globalData.arrWeighmentCounter.find((k) => k.DsNo == dsNo && k.TapIp == tabIp);
  //   var dataMoist = globalData.dataMoist.find((k) => k.DsNo == dsNo && k.TapIp == tabIp);
  //   actualProtocol = dataMoist;

  //   if (tempCounterObj.counter == 0) {
  //     //insert initial and temp
  //     var objActivity = {};
  //     Object.assign(
  //       objActivity,
  //       { strUserId: tempUserObject.UserId },
  //       { strUserName: tempUserObject.UserName },
  //       { activity: "LOD Weighment Started on TSH" + " " + dsIp }
  //     );
  //     await objActivityLog.ActivityLogEntry(objActivity);
  //     // Instrument usage for LOD started
  //     await objInstrumentUsage.InstrumentUsage(
  //       "LOD",
  //       dsNo,
  //       "tbl_instrumentlog_lod",
  //       "LOD",
  //       "started",
  //       dsIp
  //     );
  //     if (obj.Eqp_Model == "MA150" || obj.Eqp_Model == "MA160-1") {
  //       await this.saveLodData1(actualProtocol, tempUserObject, 0, dataObj, instrumentData, obj);
  //     }
  //     tempCounterObj.counter += 1;
  //   } else {
  //     if (obj.Eqp_Model == "MA150" || obj.Eqp_Model == "MA160-1") {
  //       await this.saveLodData1(actualProtocol, tempUserObject, tempCounterObj.counter, dataObj, instrumentData, obj);
  //     }
  //     // await this.saveLodData(cubicObj, actualProtocol, tempUserObject, dsNo, tempCounterObj.counter, tabIp, dsIp);
  //   }
  // }

  // async saveLodData1(arrLodData, tempUserObject, counter, dataObj, instrumentData, obj) {
  //   try {
  //     let dsNo = dataObj.DsNo;
  //     let tabIp = dataObj.TabIp;
  //     let dsIp = dataObj.DsIp;
  //     let cubicObj = dataObj.cubicObj;
  //     let ProtocolPortNo = dataObj.ProtocolPortNo;
  //     var department = "";
  //     var selectedCubicle;
  //     var cubicType, GranuRepoHeading = 0, decimalPoint;
  //     department = cubicObj.Sys_dept;
  //     let lodData = globalData.arrProtocolData.find((k) => k.DsNo == dsNo);
  //     let limits = globalData.arr_limits.find((k) => k.DsNo == dsNo);
  //     limits = limits.Menus.filter((k) => k.LOD != undefined)[0];
  //     var arrUsers = globalData.arrUsers.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
  //     var lodData1_value = Object.assign(arrLodData, { DsNo: dsNo });
  //     if (lodData == undefined) {
  //       globalData.arrProtocolData.push(lodData1_value);
  //       // globalData.arrProtocolData.push({'strHmi':strHmi})
  //     }
  //     lodData = globalData.arrProtocolData.find((k) => k.DsNo == dsNo);

  //     globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
  //       ? globalData.dataMoist
  //       : globalData.dataMoist.splice(
  //         globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
  //         1
  //       );
  //     // let selectedIdsNo;
  //     // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
  //     // if (IPQCObject != undefined) {
  //     //   selectedIdsNo = IPQCObject.selectedIds;
  //     // } else {
  //     //   selectedIdsNo = IdsNo;
  //     // }

  //     var ProductType = globalData.arrProductTypeArray.find((k) => k.DsNo == dsNo).productType; //ProductType
  //     if (cubicObj.Sys_CubType == "IPQC" && (cubicObj.Sys_Area == "Granulation" || cubicObj.Sys_Area == "Effervescent Granulation" ||
  //       cubicObj.Sys_Area == "Pallet Coating")) {
  //       selectedCubicle = cubicObj;
  //       cubicType = 1;
  //       // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
  //       let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.DsNo == dsNo);
  //       switch (tempMenuLOD.menuName) {
  //         case "LOD": // COMPRESSED DRY
  //           GranuRepoHeading = 1;
  //           break;
  //         case "GRANULES LUB": //COMPRESSED LUB
  //           GranuRepoHeading = 2;
  //           break;
  //         case "LAYER1 DRY":
  //           GranuRepoHeading = 3;
  //           break;
  //         case "LAYER1 LUB":
  //           GranuRepoHeading = 4;
  //           break;
  //         case "LAYER2 DRY":
  //           GranuRepoHeading = 5;
  //           break;
  //         case "LAYER2 LUB":
  //           GranuRepoHeading = 6;
  //           break;
  //         default:
  //           // for coating and compression
  //           // Finding Out the department of selected for coating and compression
  //           var objGranuInfo = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo);
  //           let objCompCoatInfo = globalData.arrIdsInfo.find(
  //             (k) =>
  //               k.Sys_ProductName == objGranuInfo.Sys_ProductName &&
  //               k.Sys_BFGCode == objGranuInfo.Sys_BFGCode &&
  //               k.Sys_PVersion == objGranuInfo.Sys_PVersion &&
  //               k.Sys_Version == objGranuInfo.Sys_Version &&
  //               (k.Sys_Area != "Granulation" ||
  //                 k.Sys_Area != "Effervescent Granulation")
  //           );
  //           department = objCompCoatInfo.Sys_dept;
  //           selectedCubicle = objCompCoatInfo;
  //           GranuRepoHeading = 0;
  //           cubicType = 0;
  //       }
  //     } else {
  //       // For Compression and coating
  //       cubicType = 0;
  //       GranuRepoHeading = 0;
  //     }
  //     let now = new Date();
  //     // let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
  //     lodData = globalData.arrProtocolData.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
  //     // if (counter == 0) {
  //     if (lodData != undefined) {
  //       // here check product is from granulation or COMP & COAT
  //       let objSelectedLOD = globalData.arrLODTypeSelectedMenu.find((k) => k.DsNo == dsNo);
  //       var productTableName = "";
  //       if (objSelectedLOD != undefined) {
  //         if (objSelectedLOD.selectedLOD == "LOD COATING") {
  //           productTableName = "tbl_product_tablet_coated";
  //         } else if (objSelectedLOD.selectedLOD == "LOD COMPRESSION") {
  //           productTableName = "tbl_product_tablet";
  //         }
  //       } else if (cubicObj.Sys_Area == "Compression" || cubicObj.Sys_Area == "Effervescent Compression") {
  //         productTableName = "tbl_product_tablet";
  //       } else if (cubicObj.Sys_Area == "Coating") {
  //         productTableName = "tbl_product_tablet_coated";
  //       }
  //       // var res = await proObj.productData(cubicObj, productTableName);

  //       // if (GranuRepoHeading != 0) {
  //       //   var paramNom = `Param${GranuRepoHeading}_Nom`;
  //       //   var paramLow = `Param${GranuRepoHeading}_Low`;
  //       //   var paramUpp = `Param${GranuRepoHeading}_Upp`;
  //       //   var paramDp = `Param${GranuRepoHeading}_DP`;
  //       //   var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
  //       // } else {
  //       //   var paramNom = `Param16_Nom`;
  //       //   var paramLow = `Param16_T1Neg`;
  //       //   var paramUpp = `Param16_T1Pos`;
  //       //   var paramDp = `Param16_DP`;
  //       //   var paramIsOnStd = `Param16_LimitOn`;
  //       // }

  //       const checkData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"],
  //         ],
  //         where: {
  //           BFGCode: cubicObj.Sys_BFGCode,
  //           ProductName: cubicObj.Sys_ProductName,
  //           PVersion: cubicObj.Sys_PVersion,
  //           Version: cubicObj.Sys_Version,
  //           BatchNo: cubicObj.Sys_Batch,
  //           DsNo: dsNo,
  //         },
  //       });

  //       let result = [[checkData]];
  //       var intMstSerNo;
  //       if (result[0][0].MstSerNo == null) {
  //         intMstSerNo = 1;
  //       } else {
  //         var newMstSerNo = result[0][0].MstSerNo + 1;
  //         intMstSerNo = newMstSerNo;
  //       }
  //       const checkBRepSer = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: cubicObj.Sys_BFGCode,
  //           ProductName: cubicObj.Sys_ProductName,
  //           PVersion: cubicObj.Sys_PVersion,
  //           Version: cubicObj.Sys_Version,
  //           BatchNo: cubicObj.Sys_Batch,
  //           ReportType: cubicObj.Sys_RptType,
  //           Side: cubicObj.Sys_RotaryType,
  //         },
  //       });

  //       let batchResult = [checkBRepSer];
  //       var intBRepSerNo;
  //       if (batchResult[0][0].RepSerNo == null) {
  //         intBRepSerNo = 1;
  //       } else {
  //         var newBRepSerNo = batchResult[0][0].RepSerNo + 1;
  //         intBRepSerNo = newBRepSerNo;
  //       }
  //       var arrTempSplit = arrLodData["IniWt"].split(" ");
  //       decimalPoint = this.precision(Number(arrTempSplit[0]));
  //       var finwt = arrLodData["FinWt"].split(" ");
  //       var finwt = finwt[0];
  //       var lodcal = (((Number(arrTempSplit[0]) - Number(finwt)) / arrTempSplit[0]) * 100).toFixed(5);
  //       var saveLodData = await models.tbl_lodmaster.create({
  //         MstSerNo: intMstSerNo,
  //         BRepSerNo: intBRepSerNo,
  //         BFGCode: cubicObj.Sys_BFGCode,
  //         ProductName: cubicObj.Sys_ProductName,
  //         ProductType: ProductType.ProductType,
  //         DsNo: dsNo,
  //         BatchNo: cubicObj.Sys_Batch,
  //         StartTm: arrUsers.TotalTime,
  //         CubicleName: cubicObj.Sys_CubicName,
  //         CubicalNo: cubicObj.Sys_CubicNo,
  //         CubicleLocation: department,
  //         InstruId: 0,
  //         Side: cubicObj.Sys_RotaryType,
  //         DryingTemp: 0,
  //         SampleWt: 0,
  //         FinalWeight: finwt,
  //         UserId: tempUserObject.UserId,
  //         UserName: tempUserObject.UserName,
  //         IsArchived: 0,
  //         PrDate: momentObj().format("YYYY-MM-DD"),
  //         PrTime: arrUsers.TotalTime,
  //         PrintNo: 0,
  //         Remark: 0,
  //         ReportType: cubicObj.Sys_RptType,
  //         MachineId: cubicObj.Sys_MachineCode,
  //         MinLimit: limits.LOD.T1Neg,
  //         MaxLimit: limits.LOD.T1Pos,
  //         Stage: cubicObj.Sys_Stage,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Unit: 0,
  //         DecimalPoint: decimalPoint,
  //         WgmtModeNo: 0,
  //         BatchComplete: 0,
  //         LODID: cubicObj.Sys_MoistID,
  //         PVersion: cubicObj.Sys_PVersion,
  //         VERSION: cubicObj.Sys_Version,
  //         LotNumber: cubicObj.Sys_LotNo,
  //         InitialWeight: arrTempSplit[0],
  //         MoistCont: 0,
  //         RotaryType: 0,
  //         BatchSize: `${cubicObj.Sys_BatchSize} ${cubicObj.Sys_BatchSizeUnit}`,
  //         Layer: "0",
  //         // SetTemp: arrLodData["Fin. temp."].split(' ')[0],
  //         SetTemp: arrLodData["Fin"].split(" ")[0],
  //         // InitalWt: arrLodData["Start Weight"].split(' ')[0],
  //         // FinalWt: arrLodData["End Result"].split(' ')[0],
  //         IsRepoComp: cubicType,
  //         GranuRepoHeading: GranuRepoHeading,
  //         RepoLabel11: cubicObj.Sys_Validation,
  //         Lot: "NA",
  //         AREA: cubicObj.Sys_Area,
  //         AppearanceDesc: cubicObj.Sys_Appearance,
  //         MachineSpeed_Min: lodcal,
  //         MachineSpeed_Max: cubicObj.Sys_MachineSpeed_Max,
  //         GenericName: cubicObj.Sys_GenericName,
  //         BMRNo: cubicObj.Sys_BMRNo,
  //       });
  //       var maxRepSr = saveLodData.dataValues.RepSerNo;

  //       if (lodData == undefined) {
  //         globalData.arrProtocolData.push({ TabIp: tabIp, DsNo: dsNo, IniWt: arrTempSplit[0] });
  //       }
  //       // await database.save(saveLodData);
  //       mqttSender.sendData(
  //         dsNo,
  //         `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult} initialWt : ${arrTempSplit[0]} ${arrTempSplit[1]
  //         } ; 
  //               finalWt : ${arrLodData["FinWt"].split(" ")[0]} ${arrLodData["FinWt"].split(" ")[1]
  //         }; endResult: ${lodcal} ${"(%W/W)"}`
  //       );
  //       // Object.assign(responseObj, { status: 'success' });
  //       // If Initial weight completes then set initWt flag to false
  //       // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
  //       // tempLODdata.arr[0].flag = false;
  //       //resolve(responseObj);
  //       // return `${protocolIncomingType}R0,,,,,`;
  //     } else {
  //       const objMasterData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: cubicObj.Sys_BFGCode,
  //           ProductName: cubicObj.Sys_ProductName,
  //           PVersion: cubicObj.Sys_PVersion,
  //           Version: cubicObj.Sys_Version,
  //           BatchNo: cubicObj.Sys_Batch,
  //           DsNo: dsNo,
  //           IsRepoComp: cubicType,
  //         },
  //       });

  //       let res = [[objMasterData]];
  //       var maxRepNo = res[0][0].RepSerNo;

  //       const updateData = await models.tbl_lodmaster.update(
  //         {
  //           FinalWeight: arrLodData["IniWt"].split(" ")[0],
  //         },
  //         {
  //           where: {
  //             RepSerNo: maxRepNo,
  //           },
  //         }
  //       );

  //       if (lodData != undefined) {
  //         lodData.DsNo = dsNo;
  //         lodData.finalWt = arrLodData["IniWt"].split(" ")[0];
  //       }
  //     }

  //     // objProtocolData.IniWt = ;
  //     // objProtocolData.finalWt = arrLodData.finalWt.split(' ')[0];
  //     // await database.update(updateData);
  //     //extra part added 16/06/23
  //     const objMasterData = await models.tbl_lodmaster.findAll({
  //       attributes: [
  //         [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //       ],
  //       where: {
  //         BFGCode: cubicObj.Sys_BFGCode,
  //         ProductName: cubicObj.Sys_ProductName,
  //         PVersion: cubicObj.Sys_PVersion,
  //         Version: cubicObj.Sys_Version,
  //         BatchNo: cubicObj.Sys_Batch,
  //         DsNo: dsNo
  //         // IsRepoComp: cubicType,
  //       },
  //     });

  //     let res = [objMasterData];
  //     var lastInsertedId = res[0][0].RepSerNo;
  //     // var maxRepNo = res.pop();
  //     var remark;
  //     var lodmaster = await models.tbl_lodmaster.findAll({
  //       where: {
  //         RepSerNo: lastInsertedId,
  //       },
  //     });
  //     if (
  //       parseFloat(lodmaster[0].MinLimit) <= parseFloat(lodcal) &&
  //       parseFloat(lodcal) <= parseFloat(lodmaster[0].MaxLimit)
  //     ) {
  //       remark = "Complies";
  //     } else {
  //       remark = "Not Complies";
  //     }

  //     var Result_remrk;
  //     if (remark == "Complies") {
  //       Result_remrk = "Report Within Limit";
  //     } else {
  //       Result_remrk = "Report Out Of Limit";
  //     }

  //     var remarkupdate = await models.tbl_lodmaster.update(
  //       {
  //         DsNo: dsNo,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Remark: remark,
  //       },
  //       {
  //         where: {
  //           RepSerNo: maxRepSr,
  //         },
  //       }
  //     );

  //     var objActivity = {};
  //     Object.assign(
  //       objActivity,
  //       { strUserId: tempUserObject.UserId },
  //       { strUserName: tempUserObject.UserName },
  //       { activity: "LOD Weighment Completed on TSH" + dsIp }
  //     );
  //     await objActivityLog.ActivityLogEntry(objActivity);

  //     // *********************OPC CODE***************
  //     let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.DsNo == dsNo);
  //     var menuName = tempMenuLOD.InstrumentType;
  //     if (menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
  //       var loddetail = await models.tbl_lodmaster.findAll({
  //         where: {
  //           RepSerNo: lastInsertedId,
  //         },
  //       });

  //       var lodDataOPC = {
  //         BatchNo: loddetail[0].BatchNo,
  //         TestStart: loddetail[0].PrDate,
  //         SetDryingTemp: loddetail[0].SetTemp,
  //         TestEnd: momentObj().format("HH:mm:ss"),
  //         FinalWeight: loddetail[0].FinalWeight,
  //         Layer: loddetail[0].Layer,
  //         ActLossOnDrying: 0,
  //         Lot: 0,
  //         ProdName: loddetail[0].ProductName,
  //         TestResult: remark,
  //         Stage: "",
  //         StartWeight: loddetail[0].InitialWeight,
  //         TestName: tempMenuLOD.menuName,
  //       };
  //       // await objOPCops.MoistAnalizer(lodDataOPC, loddetail, strHmi, Ip)
  //     }
  //     // await objBatchSummary.saveBatchSummaryLOD(cubicObj, cubicObj.Sys_IDSNo, lodData, tempUserObject);
  //     // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
  //     // var resultRemark = `R3,,,,,`;
  //     // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitialWeight-FinalWeight)/InitialWeight)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(minLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(maxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${maxRepNo}`);
  //     // var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100)
  //     // // Object.assign(responseObj, { status: 'success' })
  //     // if (parseFloat(LOD[0][0].MINWT) < parseFloat(LOD[0][0].lodPer) &&
  //     //     parseFloat(LOD[0][0].lodPer) <= parseFloat(LOD[0][0].MAXWT)) {
  //     //     resultRemark = `R1,,,,,`;
  //     // } else {
  //     //     resultRemark = `R2,,,,,`;
  //     // }
  //     // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} finalWt : ${arrLodData["Start Weight"].split(' ')[0]} ${arrLodData["Start Weight"].split(' ')[1]}; FinalWeight : ${arrLodData["End Result"].split(' ')[0]}`);
  //     //  mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} ${remark}`);
  //     mqttSender.sendData(
  //       dsNo,
  //       `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage}${Result_remrk}`
  //     );
  //     //mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} LOD Test Completed`);

  //     // return resultRemark;
  //     // var objUpdateValidation = {
  //     //     str_tableName: "tbl_cubical",
  //     //     data: [
  //     //         { str_colName: 'Sys_Validation', value: 0 },
  //     //     ],
  //     //     condition: [
  //     //         { str_colName: 'Sys_IDSNo', value: IdsNo },
  //     //     ]
  //     // }
  //     // await database.update(objUpdateValidation);

  //     // For LOD We have to sent direct request to generate report
  //     // Online report for LOD
  //     // if (cubicObj.Sys_RptType == 0) {
  //     //     var objOnlineReport = {
  //     //         SelectedAction: maxRepNo,
  //     //         UserId: tempUserObject.UserId,
  //     //         UserName: tempUserObject.UserName,
  //     //         waterMark: true,
  //     //         SelectedValue: LOD[0][0].lodPer,
  //     //     }
  //     //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);

  //     //     var objReport = {
  //     //         reportOption: 'Moisture Analyzer',
  //     //         RepSerNo: maxRepNo
  //     //     }
  //     //     await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.Sys_PrinterName);
  //     // } else {
  //     //     // console.log('Initial report')
  //     // }
  //     //clearing and reiniting LOD DATA
  //     // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //     // if (objLodData == undefined) {
  //     //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //     // }
  //     // else {
  //     //     objLodData.arr = [];
  //     // }
  //   } catch (err) {
  //     console.log(err);
  //     throw new Error(err);
  //   }
  // }

  // async saveLodData(
  //   productObj,
  //   arrLodData,
  //   tempUserObject,
  //   IdsNo,
  //   counter,
  //   strHmi,
  //   Ip,
  //   instrumentData,
  //   obj
  // ) {
  //   try {
  //     var department = "";
  //     let responseObj = {};
  //     var selectedCubicle;
  //     var Ip = Ip;
  //     var currentCubicle = globalData.arrIdsInfo.find(
  //       (k) => k.Ip == Ip
  //     ).cubicalData;
  //     var cubicType,
  //       GranuRepoHeading = 0,
  //       decimalPoint;
  //     department = productObj.Sys_dept;
  //     let lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);
  //     let limits = globalData.arr_limits.find((k) => k.Ip == Ip);
  //     limits = limits.Menus.filter((k) => k.LOD != undefined)[0];
  //     // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
  //     //added 16/06/23
  //     let hmiDetails = globalData.arrWeighmentProductData.find(
  //       (k) => k.Ip == Ip
  //     ).data;
  //     var arrUsers = globalData.arrUsers.find((k) => k.Ip == Ip);
  //     var lodData1_value = Object.assign(arrLodData, { Ip: Ip });
  //     if (lodData == undefined) {
  //       globalData.arrProtocolData.push(lodData1_value);
  //       // globalData.arrProtocolData.push({'strHmi':strHmi})
  //     }
  //     lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);

  //     globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
  //       ? globalData.dataMoist
  //       : globalData.dataMoist.splice(
  //         globalData.dataMoist.findIndex((k) => k.Ip == Ip),
  //         1
  //       );
  //     let selectedIdsNo;
  //     var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
  //     if (IPQCObject != undefined) {
  //       selectedIdsNo = IPQCObject.selectedIds;
  //     } else {
  //       selectedIdsNo = IdsNo;
  //     }

  //     var ProductType = globalData.arrProductTypeArray.find(
  //       (k) => k.Ip == Ip
  //     ).productType; //ProductType
  //     if (
  //       productObj.Sys_CubType == "IPQC" &&
  //       (productObj.Sys_Area == "Granulation" ||
  //         productObj.Sys_Area == "Effervescent Granulation" ||
  //         productObj.Sys_Area == "Pallet Coating")
  //     ) {
  //       selectedCubicle = productObj;
  //       cubicType = 1;
  //       // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
  //       let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
  //       switch (tempMenuLOD.menuName) {
  //         case "LOD": // COMPRESSED DRY
  //           GranuRepoHeading = 1;
  //           break;
  //         case "GRANULES LUB": //COMPRESSED LUB
  //           GranuRepoHeading = 2;
  //           break;
  //         case "LAYER1 DRY":
  //           GranuRepoHeading = 3;
  //           break;
  //         case "LAYER1 LUB":
  //           GranuRepoHeading = 4;
  //           break;
  //         case "LAYER2 DRY":
  //           GranuRepoHeading = 5;
  //           break;
  //         case "LAYER2 LUB":
  //           GranuRepoHeading = 6;
  //           break;
  //         default:
  //           // for coating and compression
  //           // Finding Out the department of selected for coating and compression
  //           var objGranuInfo = globalData.arrIdsInfo.find((k) => k.Ip == Ip);
  //           let objCompCoatInfo = globalData.arrIdsInfo.find(
  //             (k) =>
  //               k.Sys_ProductName == objGranuInfo.Sys_ProductName &&
  //               k.Sys_BFGCode == objGranuInfo.Sys_BFGCode &&
  //               k.Sys_PVersion == objGranuInfo.Sys_PVersion &&
  //               k.Sys_Version == objGranuInfo.Sys_Version &&
  //               (k.Sys_Area != "Granulation" ||
  //                 k.Sys_Area != "Effervescent Granulation")
  //           );

  //           department = objCompCoatInfo.Sys_dept;
  //           selectedCubicle = objCompCoatInfo;
  //           GranuRepoHeading = 0;
  //           cubicType = 0;
  //       }
  //     } else {
  //       // For Compression and coating
  //       cubicType = 0;
  //       GranuRepoHeading = 0;
  //     }
  //     let now = new Date();
  //     // let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
  //     lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);
  //     // if (counter == 0) {
  //     if (lodData != undefined) {
  //       // here check product is from granulation or COMP & COAT
  //       let objSelectedLOD = globalData.arrLODTypeSelectedMenu.find(
  //         (k) => k.Ip == Ip
  //       );
  //       var productTableName = "";
  //       if (objSelectedLOD != undefined) {
  //         if (objSelectedLOD.selectedLOD == "LOD COATING") {
  //           productTableName = "tbl_product_tablet_coated";
  //         } else if (objSelectedLOD.selectedLOD == "LOD COMPRESSION") {
  //           productTableName = "tbl_product_tablet";
  //         }
  //       } else if (
  //         productObj.Sys_Area == "Compression" ||
  //         productObj.Sys_Area == "Effervescent Compression"
  //       ) {
  //         productTableName = "tbl_product_tablet";
  //       } else if (productObj.Sys_Area == "Coating") {
  //         productTableName = "tbl_product_tablet_coated";
  //       }
  //       // var res = await proObj.productData(productObj, productTableName);

  //       if (GranuRepoHeading != 0) {
  //         var paramNom = `Param${GranuRepoHeading}_Nom`;
  //         var paramLow = `Param${GranuRepoHeading}_Low`;
  //         var paramUpp = `Param${GranuRepoHeading}_Upp`;
  //         var paramDp = `Param${GranuRepoHeading}_DP`;
  //         var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
  //       } else {
  //         var paramNom = `Param16_Nom`;
  //         var paramLow = `Param16_T1Neg`;
  //         var paramUpp = `Param16_T1Pos`;
  //         var paramDp = `Param16_DP`;
  //         var paramIsOnStd = `Param16_LimitOn`;
  //       }

  //       const checkData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           IdsNo: IdsNo,
  //         },
  //       });

  //       let result = [[checkData]];
  //       var intMstSerNo;
  //       if (result[0][0].MstSerNo == null) {
  //         intMstSerNo = 1;
  //       } else {
  //         var newMstSerNo = result[0][0].MstSerNo + 1;
  //         intMstSerNo = newMstSerNo;
  //       }
  //       const checkBRepSer = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           ReportType: productObj.Sys_RptType,
  //           Side: productObj.Sys_RotaryType,
  //         },
  //       });

  //       let batchResult = [checkBRepSer];
  //       var intBRepSerNo;
  //       if (batchResult[0][0].RepSerNo == null) {
  //         intBRepSerNo = 1;
  //       } else {
  //         var newBRepSerNo = batchResult[0][0].RepSerNo + 1;
  //         intBRepSerNo = newBRepSerNo;
  //       }
  //       var arrTempSplit = arrLodData["IniWt"].split(" ");
  //       decimalPoint = this.precision(Number(arrTempSplit[0]));
  //       var finwt = arrLodData["FinWt"].split(" ");
  //       var finwt = finwt[0];
  //       var lodcal = (
  //         ((Number(arrTempSplit[0]) - Number(finwt)) / arrTempSplit[0]) *
  //         100
  //       ).toFixed(5);
  //       var saveLodData = await models.tbl_lodmaster.create({
  //         MstSerNo: intMstSerNo,
  //         BRepSerNo: intBRepSerNo,
  //         BFGCode: productObj.Sys_BFGCode,
  //         ProductName: productObj.Sys_ProductName,
  //         ProductType: ProductType.ProductType,
  //         IdsNo: IdsNo,
  //         BatchNo: productObj.Sys_Batch,
  //         StartTm: arrUsers.TotalTime,
  //         CubicleName: productObj.Sys_CubicName,
  //         CubicalNo: productObj.Sys_CubicNo,
  //         CubicleLocation: department,
  //         InstruId: 0,
  //         Side: productObj.Sys_RotaryType,
  //         DryingTemp: 0,
  //         SampleWt: 0,
  //         FinalWeight: finwt,
  //         UserId: tempUserObject.UserId,
  //         UserName: tempUserObject.UserName,
  //         IsArchived: 0,
  //         PrDate: momentObj().format("YYYY-MM-DD"),
  //         PrTime: arrUsers.TotalTime,
  //         PrintNo: 0,
  //         Remark: 0,
  //         ReportType: productObj.Sys_RptType,
  //         MachineId: productObj.Sys_MachineCode,
  //         MinLimit: limits.LOD.T1Neg,
  //         MaxLimit: limits.LOD.T1Pos,
  //         Stage: productObj.Sys_Stage,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Unit: 0,
  //         DecimalPoint: decimalPoint,
  //         WgmtModeNo: 0,
  //         BatchComplete: 0,
  //         LODID: currentCubicle.Sys_MoistID,
  //         PVersion: productObj.Sys_PVersion,
  //         VERSION: productObj.Sys_Version,
  //         LotNumber: productObj.Sys_LotNo,
  //         InitialWeight: arrTempSplit[0],
  //         MoistCont: 0,
  //         RotaryType: 0,
  //         BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
  //         Layer: "0",
  //         // SetTemp: arrLodData["Fin. temp."].split(' ')[0],
  //         SetTemp: arrLodData["Fin"].split(" ")[0],
  //         // InitalWt: arrLodData["Start Weight"].split(' ')[0],
  //         // FinalWt: arrLodData["End Result"].split(' ')[0],
  //         IsRepoComp: cubicType,
  //         GranuRepoHeading: GranuRepoHeading,
  //         RepoLabel11: currentCubicle.Sys_Validation,
  //         Lot: "NA",
  //         AREA: productObj.Sys_Area,
  //         AppearanceDesc: productObj.Sys_Appearance,
  //         MachineSpeed_Min: lodcal,
  //         MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
  //         GenericName: productObj.Sys_GenericName,
  //         BMRNo: productObj.Sys_BMRNo,
  //       });
  //       var maxRepSr = saveLodData.dataValues.RepSerNo;

  //       if (lodData == undefined) {
  //         globalData.arrProtocolData.push({
  //           Hmi: strHmi,
  //           idsNo: IdsNo,
  //           IniWt: arrTempSplit[0],
  //         });
  //       }
  //       // await database.save(saveLodData);
  //       mqttSender.sendData(
  //         Ip,
  //         `${mqttProtocol.DisplayResult} initialWt : ${arrTempSplit[0]} ${arrTempSplit[1]
  //         } ; 
  //               finalWt : ${arrLodData["FinWt"].split(" ")[0]} ${arrLodData["FinWt"].split(" ")[1]
  //         }; endResult: ${lodcal} ${"(%W/W)"}`
  //       );
  //       // Object.assign(responseObj, { status: 'success' });
  //       // If Initial weight completes then set initWt flag to false
  //       // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
  //       // tempLODdata.arr[0].flag = false;
  //       //resolve(responseObj);
  //       // return `${protocolIncomingType}R0,,,,,`;
  //     } else {
  //       const objMasterData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           IdsNo: IdsNo,
  //           IsRepoComp: cubicType,
  //         },
  //       });

  //       let res = [[objMasterData]];
  //       var maxRepNo = res[0][0].RepSerNo;

  //       const updateData = await models.tbl_lodmaster.update(
  //         {
  //           FinalWeight: arrLodData["IniWt"].split(" ")[0],
  //         },
  //         {
  //           where: {
  //             RepSerNo: maxRepNo,
  //           },
  //         }
  //       );

  //       if (lodData != undefined) {
  //         lodData.Hmi = strHmi;
  //         lodData.finalWt = arrLodData["IniWt"].split(" ")[0];
  //       }
  //     }

  //     // objProtocolData.IniWt = ;
  //     // objProtocolData.finalWt = arrLodData.finalWt.split(' ')[0];
  //     // await database.update(updateData);
  //     //extra part added 16/06/23
  //     const objMasterData = await models.tbl_lodmaster.findAll({
  //       attributes: [
  //         [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //       ],
  //       where: {
  //         BFGCode: productObj.Sys_BFGCode,
  //         ProductName: productObj.Sys_ProductName,
  //         PVersion: productObj.Sys_PVersion,
  //         Version: productObj.Sys_Version,
  //         BatchNo: productObj.Sys_Batch,
  //         IdsNo: IdsNo,
  //         // IsRepoComp: cubicType,
  //       },
  //     });

  //     let res = [objMasterData];
  //     var lastInsertedId = res[0][0].RepSerNo;
  //     // var maxRepNo = res.pop();
  //     var remark;
  //     var lodmaster = await models.tbl_lodmaster.findAll({
  //       where: {
  //         RepSerNo: lastInsertedId,
  //       },
  //     });
  //     if (
  //       parseFloat(lodmaster[0].MinLimit) <= parseFloat(lodcal) &&
  //       parseFloat(lodcal) <= parseFloat(lodmaster[0].MaxLimit)
  //     ) {
  //       remark = "Complies";
  //     } else {
  //       remark = "Not Complies";
  //     }

  //     var Result_remrk;
  //     if (remark == "Complies") {
  //       Result_remrk = "Report Within Limit";
  //     } else {
  //       Result_remrk = "Report Out Of Limit";
  //     }

  //     var remarkupdate = await models.tbl_lodmaster.update(
  //       {
  //         IdsNo: strHmi,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Remark: remark,
  //       },
  //       {
  //         where: {
  //           RepSerNo: maxRepSr,
  //         },
  //       }
  //     );

  //     var objActivity = {};
  //     Object.assign(
  //       objActivity,
  //       { strUserId: tempUserObject.UserId },
  //       { strUserName: tempUserObject.UserName },
  //       { activity: "LOD Weighment Completed on TSH" + strHmi }
  //     );
  //     await objActivityLog.ActivityLogEntry(objActivity);

  //     // *********************OPC CODE***************
  //     let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
  //     var menuName = tempMenuLOD.InstrumentType;
  //     if (menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
  //       var loddetail = await models.tbl_lodmaster.findAll({
  //         where: {
  //           RepSerNo: lastInsertedId,
  //         },
  //       });

  //       var lodDataOPC = {
  //         BatchNo: loddetail[0].BatchNo,
  //         TestStart: loddetail[0].PrDate,
  //         SetDryingTemp: loddetail[0].SetTemp,
  //         TestEnd: momentObj().format("HH:mm:ss"),
  //         FinalWeight: loddetail[0].FinalWeight,
  //         Layer: loddetail[0].Layer,
  //         ActLossOnDrying: 0,
  //         Lot: 0,
  //         ProdName: loddetail[0].ProductName,
  //         TestResult: remark,
  //         Stage: "",
  //         StartWeight: loddetail[0].InitialWeight,
  //         TestName: tempMenuLOD.menuName,
  //       };
  //       // await objOPCops.MoistAnalizer(lodDataOPC, loddetail, strHmi, Ip)
  //     }
  //     // await objBatchSummary.saveBatchSummaryLOD(productObj, productObj.Sys_IDSNo, lodData, tempUserObject);
  //     // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
  //     // var resultRemark = `R3,,,,,`;
  //     // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitialWeight-FinalWeight)/InitialWeight)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(minLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(maxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${maxRepNo}`);
  //     // var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100)
  //     // // Object.assign(responseObj, { status: 'success' })
  //     // if (parseFloat(LOD[0][0].MINWT) < parseFloat(LOD[0][0].lodPer) &&
  //     //     parseFloat(LOD[0][0].lodPer) <= parseFloat(LOD[0][0].MAXWT)) {
  //     //     resultRemark = `R1,,,,,`;
  //     // } else {
  //     //     resultRemark = `R2,,,,,`;
  //     // }
  //     // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} finalWt : ${arrLodData["Start Weight"].split(' ')[0]} ${arrLodData["Start Weight"].split(' ')[1]}; FinalWeight : ${arrLodData["End Result"].split(' ')[0]}`);
  //     //  mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} ${remark}`);
  //     mqttSender.sendData(
  //       Ip,
  //       `${GLOBAL_NOMENCLATURE.DisplayMessage}${Result_remrk}`
  //     );
  //     //mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} LOD Test Completed`);

  //     // return resultRemark;
  //     // var objUpdateValidation = {
  //     //     str_tableName: "tbl_cubical",
  //     //     data: [
  //     //         { str_colName: 'Sys_Validation', value: 0 },
  //     //     ],
  //     //     condition: [
  //     //         { str_colName: 'Sys_IDSNo', value: IdsNo },
  //     //     ]
  //     // }
  //     // await database.update(objUpdateValidation);

  //     // For LOD We have to sent direct request to generate report
  //     // Online report for LOD
  //     // if (productObj.Sys_RptType == 0) {
  //     //     var objOnlineReport = {
  //     //         SelectedAction: maxRepNo,
  //     //         UserId: tempUserObject.UserId,
  //     //         UserName: tempUserObject.UserName,
  //     //         waterMark: true,
  //     //         SelectedValue: LOD[0][0].lodPer,
  //     //     }
  //     //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);

  //     //     var objReport = {
  //     //         reportOption: 'Moisture Analyzer',
  //     //         RepSerNo: maxRepNo
  //     //     }
  //     //     await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.Sys_PrinterName);
  //     // } else {
  //     //     // console.log('Initial report')
  //     // }
  //     //clearing and reiniting LOD DATA
  //     // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //     // if (objLodData == undefined) {
  //     //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //     // }
  //     // else {
  //     //     objLodData.arr = [];
  //     // }
  //   } catch (err) {
  //     // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //     // if (objLodData == undefined) {
  //     //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //     // }
  //     // else {
  //     //     objLodData.arr = [];
  //     // }
  //     // Error loging in Error file
  //     // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , ";
  //     // logError = logError + err.stack;
  //     // //commented by vivek on 31-07-2020*********************************** */
  //     // //ErrorLog.error(logError);
  //     // ErrorLog.addToErrorLog(logError);
  //     //******************************************************************* */
  //     console.log(err);
  //     throw new Error(err);
  //   }
  // }

  // async saveLodDataHX204(
  //   productObj,
  //   arrLodData,
  //   tempUserObject,
  //   IdsNo,
  //   counter,
  //   strHmi,
  //   Ip,
  //   instrumentData,
  //   obj
  // ) {
  //   try {
  //     var department = "";
  //     let responseObj = {};
  //     var selectedCubicle;
  //     var Ip = Ip;
  //     var currentCubicle = globalData.arrIdsInfo.find(
  //       (k) => k.Ip == Ip
  //     ).cubicalData;
  //     var cubicType,
  //       GranuRepoHeading = 0,
  //       decimalPoint;
  //     department = productObj.Sys_dept;
  //     let lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);
  //     let limits = globalData.arr_limits.find((k) => k.Ip == Ip);
  //     limits = limits.Menus.filter((k) => k.LOD != undefined)[0];
  //     var arrUsers = globalData.arrUsers.find((k) => k.Ip == Ip);
  //     // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
  //     //added 16/06/23
  //     let hmiDetails = globalData.arrWeighmentProductData.find(
  //       (k) => k.Ip == Ip
  //     ).data;
  //     var lodData1_value = Object.assign(arrLodData, { Ip: Ip });
  //     if (lodData == undefined) {
  //       globalData.arrProtocolData.push(lodData1_value);
  //       // globalData.arrProtocolData.push({'strHmi':strHmi})
  //     }
  //     lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);

  //     globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
  //       ? globalData.dataMoist
  //       : globalData.dataMoist.splice(
  //         globalData.dataMoist.findIndex((k) => k.Ip == Ip),
  //         1
  //       );

  //     let selectedIdsNo;
  //     var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
  //     if (IPQCObject != undefined) {
  //       selectedIdsNo = IPQCObject.selectedIds;
  //     } else {
  //       selectedIdsNo = IdsNo;
  //     }

  //     var ProductType = globalData.arrProductTypeArray.find(
  //       (k) => k.Ip == Ip
  //     ).productType; //ProductType
  //     if (
  //       productObj.Sys_CubType == "IPQC" &&
  //       (productObj.Sys_Area == "Granulation" ||
  //         productObj.Sys_Area == "Effervescent Granulation" ||
  //         productObj.Sys_Area == "Pallet Coating")
  //     ) {
  //       selectedCubicle = productObj;
  //       cubicType = 1;
  //       // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
  //       let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
  //       switch (tempMenuLOD.menuName) {
  //         case "LOD": // COMPRESSED DRY
  //           GranuRepoHeading = 1;
  //           break;
  //         case "GRANULES LUB": //COMPRESSED LUB
  //           GranuRepoHeading = 2;
  //           break;
  //         case "LAYER1 DRY":
  //           GranuRepoHeading = 3;
  //           break;
  //         case "LAYER1 LUB":
  //           GranuRepoHeading = 4;
  //           break;
  //         case "LAYER2 DRY":
  //           GranuRepoHeading = 5;
  //           break;
  //         case "LAYER2 LUB":
  //           GranuRepoHeading = 6;
  //           break;
  //         default:
  //           // for coating and compression
  //           // Finding Out the department of selected for coating and compression
  //           var objGranuInfo = globalData.arrIdsInfo.find((k) => k.Ip == Ip);
  //           let objCompCoatInfo = globalData.arrIdsInfo.find(
  //             (k) =>
  //               k.Sys_ProductName == objGranuInfo.Sys_ProductName &&
  //               k.Sys_BFGCode == objGranuInfo.Sys_BFGCode &&
  //               k.Sys_PVersion == objGranuInfo.Sys_PVersion &&
  //               k.Sys_Version == objGranuInfo.Sys_Version &&
  //               (k.Sys_Area != "Granulation" ||
  //                 k.Sys_Area != "Effervescent Granulation")
  //           );

  //           department = objCompCoatInfo.Sys_dept;
  //           selectedCubicle = objCompCoatInfo;
  //           GranuRepoHeading = 0;
  //           cubicType = 0;
  //       }
  //     } else {
  //       // For Compression and coating
  //       cubicType = 0;
  //       GranuRepoHeading = 0;
  //     }
  //     let now = new Date();
  //     // let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
  //     lodData = globalData.arrProtocolData.find((k) => k.Ip == Ip);
  //     // if (counter == 0) {
  //     if (lodData != undefined) {
  //       // here check product is from granulation or COMP & COAT
  //       let objSelectedLOD = globalData.arrLODTypeSelectedMenu.find(
  //         (k) => k.Ip == Ip
  //       );
  //       var productTableName = "";
  //       if (objSelectedLOD != undefined) {
  //         if (objSelectedLOD.selectedLOD == "LOD COATING") {
  //           productTableName = "tbl_product_tablet_coated";
  //         } else if (objSelectedLOD.selectedLOD == "LOD COMPRESSION") {
  //           productTableName = "tbl_product_tablet";
  //         }
  //       } else if (
  //         productObj.Sys_Area == "Compression" ||
  //         productObj.Sys_Area == "Effervescent Compression"
  //       ) {
  //         productTableName = "tbl_product_tablet";
  //       } else if (productObj.Sys_Area == "Coating") {
  //         productTableName = "tbl_product_tablet_coated";
  //       }
  //       // var res = await proObj.productData(productObj, productTableName);

  //       if (GranuRepoHeading != 0) {
  //         var paramNom = `Param${GranuRepoHeading}_Nom`;
  //         var paramLow = `Param${GranuRepoHeading}_Low`;
  //         var paramUpp = `Param${GranuRepoHeading}_Upp`;
  //         var paramDp = `Param${GranuRepoHeading}_DP`;
  //         var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
  //       } else {
  //         var paramNom = `Param16_Nom`;
  //         var paramLow = `Param16_T1Neg`;
  //         var paramUpp = `Param16_T1Pos`;
  //         var paramDp = `Param16_DP`;
  //         var paramIsOnStd = `Param16_LimitOn`;
  //       }

  //       const checkData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           IdsNo: IdsNo,
  //         },
  //       });

  //       let result = [[checkData]];
  //       var intMstSerNo;
  //       if (result[0][0].MstSerNo == null) {
  //         intMstSerNo = 1;
  //       } else {
  //         var newMstSerNo = result[0][0].MstSerNo + 1;
  //         intMstSerNo = newMstSerNo;
  //       }
  //       const checkBRepSer = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           ReportType: productObj.Sys_RptType,
  //           Side: productObj.Sys_RotaryType,
  //         },
  //       });

  //       let batchResult = [checkBRepSer];
  //       var intBRepSerNo;
  //       if (batchResult[0][0].RepSerNo == null) {
  //         intBRepSerNo = 1;
  //       } else {
  //         var newBRepSerNo = batchResult[0][0].RepSerNo + 1;
  //         intBRepSerNo = newBRepSerNo;
  //       }
  //       var arrTempSplit = arrLodData["StartWeight"].split(" ");
  //       decimalPoint = this.precision(Number(arrTempSplit[0]));
  //       var finwt = arrLodData["FinWt"].split(" ");
  //       var finwt = finwt[0];
  //       var saveLodData = await models.tbl_lodmaster.create({
  //         MstSerNo: intMstSerNo,
  //         BRepSerNo: intBRepSerNo,
  //         BFGCode: productObj.Sys_BFGCode,
  //         ProductName: productObj.Sys_ProductName,
  //         ProductType: ProductType.ProductType,
  //         IdsNo: IdsNo,
  //         BatchNo: productObj.Sys_Batch,
  //         StartTm: arrUsers.Time,
  //         CubicleName: productObj.Sys_CubicName,
  //         CubicalNo: productObj.Sys_CubicNo,
  //         CubicleLocation: department,
  //         InstruId: 0,
  //         Side: productObj.Sys_RotaryType,
  //         DryingTemp: 0,
  //         SampleWt: 0,
  //         FinalWeight: finwt,
  //         UserId: tempUserObject.UserId,
  //         UserName: tempUserObject.UserName,
  //         IsArchived: 0,
  //         PrDate: momentObj().format("YYYY-MM-DD"),
  //         PrTime: arrUsers.Time,
  //         PrintNo: 0,
  //         Remark: 0,
  //         ReportType: productObj.Sys_RptType,
  //         MachineId: productObj.Sys_MachineCode,
  //         MinLimit: limits.LOD.T1Neg,
  //         MaxLimit: limits.LOD.T1Pos,
  //         Stage: productObj.Sys_Stage,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Unit: 0,
  //         DecimalPoint: decimalPoint,
  //         WgmtModeNo: 0,
  //         BatchComplete: 0,
  //         LODID: currentCubicle.Sys_MoistID,
  //         PVersion: productObj.Sys_PVersion,
  //         VERSION: productObj.Sys_Version,
  //         LotNumber: productObj.Sys_LotNo,
  //         InitialWeight: arrLodData["StartWeight"].split(" ")[0],
  //         MoistCont: 0,
  //         RotaryType: 0,
  //         BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
  //         Layer: "0",
  //         TotalTime: arrLodData["Total"].split(" ")[0],
  //         SetTemp: arrLodData["DryingTemp"].split(" ")[0],
  //         // InitalWt: arrLodData["Start Weight"].split(' ')[0],
  //         // FinalWt: arrLodData["End Result"].split(' ')[0],
  //         IsRepoComp: cubicType,
  //         GranuRepoHeading: GranuRepoHeading,
  //         RepoLabel11: currentCubicle.Sys_Validation,
  //         Lot: "NA",
  //         AREA: productObj.Sys_Area,
  //         AppearanceDesc: productObj.Sys_Appearance,
  //         LODPer: arrLodData["EndResult"].split(" ")[0],
  //         // MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
  //         GenericName: productObj.Sys_GenericName,
  //         BMRNo: productObj.Sys_BMRNo,
  //       });

  //       var maxRepSr = saveLodData.dataValues.RepSerNo;

  //       if (lodData == undefined) {
  //         globalData.arrProtocolData.push({
  //           Hmi: strHmi,
  //           idsNo: IdsNo,
  //           IniWt: arrTempSplit[0],
  //         });
  //       }
  //       // await database.save(saveLodData);
  //       mqttSender.sendData(
  //         Ip,
  //         `${mqttProtocol.DisplayResult} initialWt : ${arrTempSplit[0]} ${arrTempSplit[1]
  //         } ; 
  //               finalTemp : ${arrLodData["DryingTemp"].split(" ")[0]
  //         } ${"C"}; endResult: ${arrLodData["EndResult"].split(" ")[0]} ${arrLodData["EndResult"].split(" ")[1]
  //         }`
  //       );
  //       // Object.assign(responseObj, { status: 'success' });
  //       // If Initial weight completes then set initWt flag to false
  //       // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
  //       // tempLODdata.arr[0].flag = false;
  //       //resolve(responseObj);
  //       // return `${protocolIncomingType}R0,,,,,`;
  //     } else {
  //       const objMasterData = await models.tbl_lodmaster.findAll({
  //         attributes: [
  //           [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //         ],
  //         where: {
  //           BFGCode: productObj.Sys_BFGCode,
  //           ProductName: productObj.Sys_ProductName,
  //           PVersion: productObj.Sys_PVersion,
  //           Version: productObj.Sys_Version,
  //           BatchNo: productObj.Sys_Batch,
  //           IdsNo: IdsNo,
  //           IsRepoComp: cubicType,
  //         },
  //       });

  //       let res = [[objMasterData]];
  //       var maxRepNo = res[0][0].RepSerNo;

  //       const updateData = await models.tbl_lodmaster.update(
  //         {
  //           FinalWeight: arrLodData["StartWeight"].split(" ")[0],
  //         },
  //         {
  //           where: {
  //             RepSerNo: maxRepNo,
  //           },
  //         }
  //       );

  //       if (lodData != undefined) {
  //         lodData.Hmi = strHmi;
  //         lodData.finalWt = arrLodData["StartWeight"].split(" ")[0];
  //       }
  //     }

  //     // objProtocolData.IniWt = ;
  //     // objProtocolData.finalWt = arrLodData.finalWt.split(' ')[0];
  //     // await database.update(updateData);
  //     //extra part added 16/06/23
  //     const objMasterData = await models.tbl_lodmaster.findAll({
  //       attributes: [
  //         [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
  //       ],
  //       where: {
  //         BFGCode: productObj.Sys_BFGCode,
  //         ProductName: productObj.Sys_ProductName,
  //         PVersion: productObj.Sys_PVersion,
  //         Version: productObj.Sys_Version,
  //         BatchNo: productObj.Sys_Batch,
  //         IdsNo: IdsNo,
  //         // IsRepoComp: cubicType,
  //       },
  //     });

  //     let res = [objMasterData];
  //     var lastInsertedId = res[0][0].RepSerNo;
  //     // var maxRepNo = res.pop();
  //     var remark;
  //     var lodmaster = await models.tbl_lodmaster.findAll({
  //       where: {
  //         RepSerNo: lastInsertedId,
  //       },
  //     });
  //     if (
  //       parseFloat(lodmaster[0].MinLimit) <=
  //       parseFloat(arrLodData["EndResult"].split(" ")[0]) &&
  //       parseFloat(arrLodData["EndResult"].split(" ")[0]) <=
  //       parseFloat(lodmaster[0].MaxLimit)
  //     ) {
  //       remark = "Complies";
  //     } else {
  //       remark = "Not Complies";
  //     }

  //     var Result_remrk;
  //     if (remark == "Complies") {
  //       Result_remrk = "Report Within Limit";
  //     } else {
  //       Result_remrk = "Report Out Of Limit";
  //     }

  //     var PrEndTime;
  //     var PrEndDate;
  //     var remarkupdate = await models.tbl_lodmaster.update(
  //       {
  //         IdsNo: strHmi,
  //         PrEndDate: momentObj().format("YYYY-MM-DD"),
  //         PrEndTime: momentObj().format("HH:mm:ss"),
  //         Remark: remark,
  //       },
  //       {
  //         where: {
  //           RepSerNo: maxRepSr,
  //         },
  //       }
  //     );

  //     var objActivity = {};
  //     Object.assign(
  //       objActivity,
  //       { strUserId: tempUserObject.UserId },
  //       { strUserName: tempUserObject.UserName },
  //       { activity: "LOD Weighment Completed on TSH" + strHmi }
  //     );
  //     await objActivityLog.ActivityLogEntry(objActivity);

  //     // *********************OPC CODE***************
  //     let tempMenuLOD = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
  //     var menuName = tempMenuLOD.InstrumentType;
  //     if (menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
  //       var loddetail = await models.tbl_lodmaster.findAll({
  //         where: {
  //           RepSerNo: lastInsertedId,
  //         },
  //       });

  //       var lodDataOPC = {
  //         BatchNo: loddetail[0].BatchNo,
  //         TestStart: loddetail[0].PrDate,
  //         SetDryingTemp: loddetail[0].SetTemp,
  //         TestEnd: momentObj(loddetail[0].PrTime).format("HH:mm:ss"),
  //         FinalWeight: loddetail[0].FinalWeight,
  //         Layer: loddetail[0].Layer,
  //         ActLossOnDrying: 0,
  //         Lot: 0,
  //         ProdName: loddetail[0].ProductName,
  //         TestResult: remark,
  //         Stage: "",
  //         StartWeight: loddetail[0].InitialWeight,
  //         TestName: tempMenuLOD.menuName,
  //       };
  //       // (globalData.arrSelectedMenu.findIndex((element) => element.Ip === Ip)) == -1 ?
  //       // globalData.arrSelectedMenu :
  //       // globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex((element) => element.Ip === Ip), 1);
  //       // await objOPCops.MoistAnalizer(lodDataOPC, loddetail, strHmi, Ip)
  //       var tempData = instrumentData.split("\n");
  //     }

  //     // await objBatchSummary.saveBatchSummaryLOD(productObj, productObj.Sys_IDSNo, lodData, tempUserObject);
  //     // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
  //     // var resultRemark = `R3,,,,,`;
  //     // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitialWeight-FinalWeight)/InitialWeight)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(minLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(maxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${maxRepNo}`);
  //     // var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100)
  //     // // Object.assign(responseObj, { status: 'success' })
  //     // if (parseFloat(LOD[0][0].MINWT) < parseFloat(LOD[0][0].lodPer) &&
  //     //     parseFloat(LOD[0][0].lodPer) <= parseFloat(LOD[0][0].MAXWT)) {
  //     //     resultRemark = `R1,,,,,`;
  //     // } else {
  //     //     resultRemark = `R2,,,,,`;
  //     // }
  //     // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} finalWt : ${arrLodData["Start Weight"].split(' ')[0]} ${arrLodData["Start Weight"].split(' ')[1]}; FinalWeight : ${arrLodData["End Result"].split(' ')[0]}`);
  //     //  mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} ${remark}`);

  //     mqttSender.sendData(
  //       Ip,
  //       `${GLOBAL_NOMENCLATURE.DisplayMessage}${Result_remrk}`
  //     );
  //     //mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} LOD Test Completed`);

  //     // return resultRemark;
  //     // var objUpdateValidation = {
  //     //     str_tableName: "tbl_cubical",
  //     //     data: [
  //     //         { str_colName: 'Sys_Validation', value: 0 },
  //     //     ],
  //     //     condition: [
  //     //         { str_colName: 'Sys_IDSNo', value: IdsNo },
  //     //     ]
  //     // }
  //     // await database.update(objUpdateValidation);

  //     // For LOD We have to sent direct request to generate report
  //     // Online report for LOD
  //     // if (productObj.Sys_RptType == 0) {
  //     //     var objOnlineReport = {
  //     //         SelectedAction: maxRepNo,
  //     //         UserId: tempUserObject.UserId,
  //     //         UserName: tempUserObject.UserName,
  //     //         waterMark: true,
  //     //         SelectedValue: LOD[0][0].lodPer,
  //     //     }
  //     //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);

  //     //     var objReport = {
  //     //         reportOption: 'Moisture Analyzer',
  //     //         RepSerNo: maxRepNo
  //     //     }
  //     //     await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.Sys_PrinterName);
  //     // } else {
  //     //     // console.log('Initial report')
  //     // }
  //     //clearing and reiniting LOD DATA
  //     // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //     // if (objLodData == undefined) {
  //     //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //     // }
  //     // else {
  //     //     objLodData.arr = [];
  //     // }
  //   } catch (err) {
  //     // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //     // if (objLodData == undefined) {
  //     //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //     // }
  //     // else {
  //     //     objLodData.arr = [];
  //     // }
  //     // Error loging in Error file
  //     // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , ";
  //     // logError = logError + err.stack;
  //     // //commented by vivek on 31-07-2020*********************************** */
  //     // //ErrorLog.error(logError);
  //     // ErrorLog.addToErrorLog(logError);
  //     //******************************************************************* */
  //     console.log(err);
  //     throw new Error(err);
  //   }
  // }

  // async saveLodDataHX204(productObj, arrLodData, tempUserObject, IdsNo, counter, strHmi, Ip, instrumentData) {
  //     try {
  //         var department = "";
  //         let responseObj = {};
  //         var selectedCubicle;
  //         var Ip = Ip
  //         var currentCubicle = globalData.arrIdsInfo.find(k => k.Ip == Ip).cubicalData;
  //         var cubicType, GranuRepoHeading = 0, decimalPoint;
  //         department = productObj.Sys_dept;
  //         let lodData = globalData.arrProtocolData.find(k => k.Ip == Ip);
  //         let limits = globalData.arr_limits.find(k => k.Ip == Ip);
  //         limits = limits.Menus.filter(k => k.LOD != undefined)[0];
  //         var arrUsers = globalData.arrUsers.find(k => k.Ip == Ip);
  //         // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
  //         //added 16/06/23
  //         let hmiDetails = globalData.arrWeighmentProductData.find(k => k.Ip == Ip).data;
  //         var lodData1_value = Object.assign(arrLodData, { Ip: Ip })
  //         if (lodData == undefined) {

  //             globalData.arrProtocolData.push(lodData1_value)
  //             // globalData.arrProtocolData.push({'strHmi':strHmi})
  //         }
  //         lodData = globalData.arrProtocolData.find(k => k.Ip == Ip);

  //         globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
  //             ? globalData.dataMoist
  //             : globalData.dataMoist.splice(
  //                 globalData.dataMoist.findIndex((k) => k.Ip == Ip),
  //                 1
  //             );

  //         let selectedIdsNo;
  //         var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
  //         if (IPQCObject != undefined) {
  //             selectedIdsNo = IPQCObject.selectedIds;
  //         } else {
  //             selectedIdsNo = IdsNo;
  //         }

  //         var ProductType = globalData.arrProductTypeArray.find(k => k.Ip == Ip).productType; //ProductType
  //         if (productObj.Sys_CubType == 'IPQC' && (productObj.Sys_Area == 'Granulation' || productObj.Sys_Area == 'Effervescent Granulation'
  //             || productObj.Sys_Area == 'Pallet Coating')) {

  //             selectedCubicle = productObj;
  //             cubicType = 1;
  //             // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
  //             let tempMenuLOD = globalData.arrSelectedMenu.find(k => k.Ip == Ip);
  //             switch (tempMenuLOD.menuName) {
  //                 case 'LOD': // COMPRESSED DRY
  //                     GranuRepoHeading = 1;
  //                     break;
  //                 case 'GRANULES LUB': //COMPRESSED LUB
  //                     GranuRepoHeading = 2;
  //                     break;
  //                 case 'LAYER1 DRY':
  //                     GranuRepoHeading = 3;
  //                     break;
  //                 case 'LAYER1 LUB':
  //                     GranuRepoHeading = 4;
  //                     break;
  //                 case 'LAYER2 DRY':
  //                     GranuRepoHeading = 5;
  //                     break;
  //                 case 'LAYER2 LUB':
  //                     GranuRepoHeading = 6;
  //                     break;
  //                 default:
  //                     // for coating and compression
  //                     // Finding Out the department of selected for coating and compression
  //                     var objGranuInfo = globalData.arrIdsInfo.find(k => k.Ip == Ip);
  //                     let objCompCoatInfo = globalData.arrIdsInfo.find(k => k.Sys_ProductName == objGranuInfo.Sys_ProductName
  //                         && k.Sys_BFGCode == objGranuInfo.Sys_BFGCode && k.Sys_PVersion == objGranuInfo.Sys_PVersion
  //                         && k.Sys_Version == objGranuInfo.Sys_Version && (k.Sys_Area != 'Granulation' || k.Sys_Area != 'Effervescent Granulation'));

  //                     department = objCompCoatInfo.Sys_dept;
  //                     selectedCubicle = objCompCoatInfo;
  //                     GranuRepoHeading = 0;
  //                     cubicType = 0;
  //             }
  //         } else {
  //             // For Compression and coating
  //             cubicType = 0;
  //             GranuRepoHeading = 0;
  //         }
  //         let now = new Date();
  //         // let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
  //         lodData = globalData.arrProtocolData.find(k => k.Ip == Ip);
  //         // if (counter == 0) {
  //         if (lodData != undefined) {
  //             // here check product is from granulation or COMP & COAT
  //             let objSelectedLOD = globalData.arrLODTypeSelectedMenu.find(k => k.Ip == Ip);
  //             var productTableName = "";
  //             if (objSelectedLOD != undefined) {
  //                 if (objSelectedLOD.selectedLOD == "LOD COATING") {
  //                     productTableName = "tbl_product_tablet_coated";
  //                 } else if (objSelectedLOD.selectedLOD == "LOD COMPRESSION") {
  //                     productTableName = "tbl_product_tablet";
  //                 }
  //             } else if (productObj.Sys_Area == 'Compression' || productObj.Sys_Area == 'Effervescent Compression') {
  //                 productTableName = "tbl_product_tablet";
  //             } else if (productObj.Sys_Area == 'Coating') {
  //                 productTableName = "tbl_product_tablet_coated";
  //             }
  //             // var res = await proObj.productData(productObj, productTableName);

  //             if (GranuRepoHeading != 0) {
  //                 var paramNom = `Param${GranuRepoHeading}_Nom`;
  //                 var paramLow = `Param${GranuRepoHeading}_Low`;
  //                 var paramUpp = `Param${GranuRepoHeading}_Upp`;
  //                 var paramDp = `Param${GranuRepoHeading}_DP`;
  //                 var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
  //             } else {
  //                 var paramNom = `Param16_Nom`;
  //                 var paramLow = `Param16_T1Neg`;
  //                 var paramUpp = `Param16_T1Pos`;
  //                 var paramDp = `Param16_DP`;
  //                 var paramIsOnStd = `Param16_LimitOn`;
  //             }

  //             const checkData = await models.tbl_lodmaster.findAll({
  //                 attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'MstSerNo']],
  //                 where: {
  //                     BFGCode: productObj.Sys_BFGCode,
  //                     ProductName: productObj.Sys_ProductName,
  //                     PVersion: productObj.Sys_PVersion,
  //                     Version: productObj.Sys_Version,
  //                     BatchNo: productObj.Sys_Batch,
  //                     IdsNo: IdsNo,
  //                 }
  //             })

  //             let result = [[checkData]]
  //             var intMstSerNo;
  //             if (result[0][0].MstSerNo == null) {
  //                 intMstSerNo = 1;
  //             } else {
  //                 var newMstSerNo = result[0][0].MstSerNo + 1;
  //                 intMstSerNo = newMstSerNo;
  //             }
  //             const checkBRepSer = await models.tbl_lodmaster.findAll({
  //                 attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //                 where: {
  //                     BFGCode: productObj.Sys_BFGCode,
  //                     ProductName: productObj.Sys_ProductName,
  //                     PVersion: productObj.Sys_PVersion,
  //                     Version: productObj.Sys_Version,
  //                     BatchNo: productObj.Sys_Batch,
  //                     ReportType: productObj.Sys_RptType,
  //                     Side: productObj.Sys_RotaryType,
  //                 }
  //             })

  //             let batchResult = [checkBRepSer];
  //             var intBRepSerNo;
  //             if (batchResult[0][0].RepSerNo == null) {
  //                 intBRepSerNo = 1;
  //             } else {
  //                 var newBRepSerNo = batchResult[0][0].RepSerNo + 1;
  //                 intBRepSerNo = newBRepSerNo;
  //             }
  //             var arrTempSplit = arrLodData["StartWeight"].split(" ");
  //             decimalPoint = this.precision(Number(arrTempSplit[0]));
  //             var saveLodData = await models.tbl_lodmaster.create({
  //                 MstSerNo: intMstSerNo,
  //                 BRepSerNo: intBRepSerNo,
  //                 BFGCode: productObj.Sys_BFGCode,
  //                 ProductName: productObj.Sys_ProductName,
  //                 ProductType: ProductType.ProductType,
  //                 IdsNo: IdsNo,
  //                 BatchNo: productObj.Sys_Batch,
  //                 StartTm: arrUsers.Time,
  //                 CubicleName: productObj.Sys_CubicName,
  //                 CubicalNo: productObj.Sys_CubicNo,
  //                 CubicleLocation: department,
  //                 InstruId: 0,
  //                 Side: productObj.Sys_RotaryType,
  //                 DryingTemp: 0,
  //                 SampleWt: 0,
  //                 FinalWeight: 0,
  //                 UserId: tempUserObject.UserId,
  //                 UserName: tempUserObject.UserName,
  //                 IsArchived: 0,
  //                 PrDate: momentObj().format('YYYY-MM-DD'),
  //                 PrTime: arrUsers.Time,
  //                 PrintNo: 0,
  //                 Remark: 0,
  //                 ReportType: productObj.Sys_RptType,
  //                 MachineId: productObj.Sys_MachineCode,
  //                 MinLimit: limits.LOD.T1Neg,
  //                 MaxLimit: limits.LOD.T1Pos,
  //                 Stage: productObj.Sys_Stage,
  //                 PrEndDate: momentObj().format('YYYY-MM-DD'),
  //                 PrEndTime: momentObj().format('HH:mm:ss'),
  //                 Unit: 0,
  //                 DecimalPoint: decimalPoint,
  //                 WgmtModeNo: 0,
  //                 BatchComplete: 0,
  //                 LODID: currentCubicle.Sys_MoistID,
  //                 PVersion: productObj.Sys_PVersion,
  //                 VERSION: productObj.Sys_Version,
  //                 LotNumber: productObj.Sys_LotNo,
  //                 InitialWeight: arrLodData["StartWeight"].split(' ')[0],
  //                 MoistCont: 0,
  //                 RotaryType: 0,
  //                 BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
  //                 Layer: "0",
  //                 TotalTime: arrLodData["Total"].split(' ')[0],
  //                 SetTemp: arrLodData["DryingTemp"].split(' ')[0],
  //                 // InitalWt: arrLodData["Start Weight"].split(' ')[0],
  //                 // FinalWt: arrLodData["End Result"].split(' ')[0],
  //                 IsRepoComp: cubicType,
  //                 GranuRepoHeading: GranuRepoHeading,
  //                 RepoLabel11: currentCubicle.Sys_Validation,
  //                 Lot: 'NA',
  //                 AREA: productObj.Sys_Area,
  //                 AppearanceDesc: productObj.Sys_Appearance,
  //                 LODPer: arrLodData["EndResult"].split(' ')[0],
  //                 // MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
  //                 GenericName: productObj.Sys_GenericName,
  //                 BMRNo: productObj.Sys_BMRNo,
  //             })

  //             var maxRepSr = saveLodData.dataValues.RepSerNo

  //             if (lodData == undefined) {
  //                 globalData.arrProtocolData.push({
  //                     Hmi: strHmi,
  //                     idsNo: IdsNo,
  //                     IniWt: arrTempSplit[0]
  //                 })
  //             }
  //             // await database.save(saveLodData);
  //             mqttSender.sendData(Ip, `${mqttProtocol.DisplayResult} initialWt : ${arrTempSplit[0]} ${arrTempSplit[1]} ;
  //             finalTemp : ${arrLodData['DryingTemp'].split(' ')[0]} ${arrLodData['DryingTemp'].split(' ')[1]}; endResult: ${arrLodData['EndResult'].split(' ')[0]} ${arrLodData['EndResult'].split(' ')[1]}`);
  //             // Object.assign(responseObj, { status: 'success' });
  //             // If Initial weight completes then set initWt flag to false
  //             // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
  //             // tempLODdata.arr[0].flag = false;
  //             //resolve(responseObj);
  //             // return `${protocolIncomingType}R0,,,,,`;
  //         }
  //         else {
  //             const objMasterData = await models.tbl_lodmaster.findAll({
  //                 attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //                 where: {
  //                     BFGCode: productObj.Sys_BFGCode,
  //                     ProductName: productObj.Sys_ProductName,
  //                     PVersion: productObj.Sys_PVersion,
  //                     Version: productObj.Sys_Version,
  //                     BatchNo: productObj.Sys_Batch,
  //                     IdsNo: IdsNo,
  //                     IsRepoComp: cubicType,
  //                 }
  //             })

  //             let res = [[objMasterData]];
  //             var maxRepNo = res[0][0].RepSerNo;

  //             const updateData = await models.tbl_lodmaster.update({
  //                 FinalWeight: arrLodData['StartWeight'].split(' ')[0]
  //             }, {
  //                 where: {
  //                     RepSerNo: maxRepNo
  //                 }
  //             })

  //             if (lodData != undefined) {
  //                 lodData.Hmi = strHmi;
  //                 lodData.finalWt = arrLodData['StartWeight'].split(' ')[0];
  //             }
  //         }

  //         // objProtocolData.IniWt = ;
  //         // objProtocolData.finalWt = arrLodData.finalWt.split(' ')[0];
  //         // await database.update(updateData);
  //         //extra part added 16/06/23
  //         const objMasterData = await models.tbl_lodmaster.findAll({
  //             attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //             where: {
  //                 BFGCode: productObj.Sys_BFGCode,
  //                 ProductName: productObj.Sys_ProductName,
  //                 PVersion: productObj.Sys_PVersion,
  //                 Version: productObj.Sys_Version,
  //                 BatchNo: productObj.Sys_Batch,
  //                 IdsNo: IdsNo,
  //                 // IsRepoComp: cubicType,
  //             }
  //         })

  //         let res = [objMasterData];
  //         var lastInsertedId = res[0][0].RepSerNo;
  //         // var maxRepNo = res.pop();
  //         var remark;
  //         var lodmaster = await models.tbl_lodmaster.findAll({
  //             where: {
  //                 RepSerNo: lastInsertedId
  //             }
  //         })
  //         if (parseFloat(lodmaster[0].MinLimit) <= parseFloat(arrLodData['EndResult'].split(' ')[0]) &&
  //             parseFloat(arrLodData['EndResult'].split(' ')[0]) <= parseFloat(lodmaster[0].MaxLimit)) {
  //             remark = "Complies";
  //         } else {
  //             remark = "Not Complies";
  //         }

  //         var Result_remrk
  //         if (remark == "Complies") {
  //             Result_remrk = 'Report Within Limit'
  //         } else {
  //             Result_remrk = 'Report Out Of Limit'
  //         }

  //         var PrEndTime;
  //         var PrEndDate;
  //         var remarkupdate = await models.tbl_lodmaster.update({
  //             IdsNo: strHmi,
  //             PrEndDate: momentObj().format('YYYY-MM-DD'),
  //             PrEndTime: momentObj().format('HH:mm:ss'),
  //             Remark: remark,
  //         }, {
  //             where: {
  //                 RepSerNo: maxRepSr

  //             }
  //         })

  //         var objActivity = {};
  //         Object.assign(objActivity,
  //             { strUserId: tempUserObject.UserId },
  //             { strUserName: tempUserObject.UserName },
  //             { activity: 'LOD Weighment Completed on TSH' + strHmi });
  //         await objActivityLog.ActivityLogEntry(objActivity);

  //         // *********************OPC CODE***************
  //         let tempMenuLOD = globalData.arrSelectedMenu.find(k => k.Ip == Ip);
  //         var menuName = tempMenuLOD.InstrumentType
  //         if (menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
  //             var loddetail = await models.tbl_lodmaster.findAll({
  //                 where: {
  //                     RepSerNo: lastInsertedId
  //                 }
  //             })

  //             var lodDataOPC = {
  //                 BatchNo: loddetail[0].BatchNo,
  //                 TestStart: (loddetail[0].PrDate),
  //                 SetDryingTemp: loddetail[0].SetTemp,
  //                 TestEnd: momentObj(loddetail[0].PrTime).format('HH:mm:ss'),
  //                 FinalWeight: loddetail[0].FinalWeight,
  //                 Layer: loddetail[0].Layer,
  //                 ActLossOnDrying: 0,
  //                 Lot: 0,
  //                 ProdName: loddetail[0].ProductName,
  //                 TestResult: remark,
  //                 Stage: "",
  //                 StartWeight: loddetail[0].InitialWeight,
  //                 TestName: tempMenuLOD.menuName
  //             }
  //             // await objOPCops.MoistAnalizer(lodDataOPC, loddetail, strHmi, Ip)
  //         }
  //         // await objBatchSummary.saveBatchSummaryLOD(productObj, productObj.Sys_IDSNo, lodData, tempUserObject);
  //         // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
  //         // var resultRemark = `R3,,,,,`;
  //         // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitialWeight-FinalWeight)/InitialWeight)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(minLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(maxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${maxRepNo}`);
  //         // var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100)
  //         // // Object.assign(responseObj, { status: 'success' })
  //         // if (parseFloat(LOD[0][0].MINWT) < parseFloat(LOD[0][0].lodPer) &&
  //         //     parseFloat(LOD[0][0].lodPer) <= parseFloat(LOD[0][0].MAXWT)) {
  //         //     resultRemark = `R1,,,,,`;
  //         // } else {
  //         //     resultRemark = `R2,,,,,`;
  //         // }
  //         // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} finalWt : ${arrLodData["Start Weight"].split(' ')[0]} ${arrLodData["Start Weight"].split(' ')[1]}; FinalWeight : ${arrLodData["End Result"].split(' ')[0]}`);
  //         //  mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} ${remark}`);

  //         mqttSender.sendData(Ip, `${GLOBAL_NOMENCLATURE.DisplayMessage}${Result_remrk}`);
  //         //mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage} LOD Test Completed`);

  //         // return resultRemark;
  //         // var objUpdateValidation = {
  //         //     str_tableName: "tbl_cubical",
  //         //     data: [
  //         //         { str_colName: 'Sys_Validation', value: 0 },
  //         //     ],
  //         //     condition: [
  //         //         { str_colName: 'Sys_IDSNo', value: IdsNo },
  //         //     ]
  //         // }
  //         // await database.update(objUpdateValidation);

  //         // For LOD We have to sent direct request to generate report
  //         // Online report for LOD
  //         // if (productObj.Sys_RptType == 0) {
  //         //     var objOnlineReport = {
  //         //         SelectedAction: maxRepNo,
  //         //         UserId: tempUserObject.UserId,
  //         //         UserName: tempUserObject.UserName,
  //         //         waterMark: true,
  //         //         SelectedValue: LOD[0][0].lodPer,
  //         //     }
  //         //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);

  //         //     var objReport = {
  //         //         reportOption: 'Moisture Analyzer',
  //         //         RepSerNo: maxRepNo
  //         //     }
  //         //     await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.Sys_PrinterName);
  //         // } else {
  //         //     // console.log('Initial report')
  //         // }
  //         //clearing and reiniting LOD DATA
  //         // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //         // if (objLodData == undefined) {
  //         //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //         // }
  //         // else {
  //         //     objLodData.arr = [];
  //         // }

  //     } catch (err) {
  //         // var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
  //         // if (objLodData == undefined) {
  //         //     globalData.arrLodData.push({ idsNo: IdsNo, arr: [] })
  //         // }
  //         // else {
  //         //     objLodData.arr = [];
  //         // }
  //         // Error loging in Error file
  //         // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , ";
  //         // logError = logError + err.stack;
  //         // //commented by vivek on 31-07-2020*********************************** */
  //         // //ErrorLog.error(logError);
  //         // ErrorLog.addToErrorLog(logError);
  //         //******************************************************************* */
  //         console.log(err)
  //         throw new Error(err);
  //     }
  // }

  precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1,
      p = 0;
    while (Math.round(a * e) / e !== a) {
      e *= 10;
      p++;
    }
    return p;
  }
}
module.exports = LOD;
