const globalData = require("../../global/globalData");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsCommonWeightment = require("../Product/clsCommonWeightment");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
const Database = require("../../database/clsQueryProcess");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const models = require("../../../config/dbConnection").models;
// const sequelize = require("../../../config/dbConnection").sequelize;
// const { QueryTypes, where, NUMBER, json } = require("sequelize");
const maths = require("mathjs");
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const clsPrintOperation = require("../Print/clsPrintOperation");
const clsCalculation = require('../clsCalculationOperation');
const config = require("../../../../IncrencyV4DRLTSHConfig.json");

const objcallPrint = new clsPrintOperation();
const objMonit = new clsMonit();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objCommonWeightment = new clsCommonWeightment();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const objcalc = new clsCalculation();
const moment = require("moment");

class Individual {

  async processData(instrumentType, __parameterObj) {
    try {
      let readingIgnore;
      let counter = 0;
      let RecNo = 1;
      let dsIp = __parameterObj.DsIp;
      let dsNo = __parameterObj.DsNo;
      let tabIp = __parameterObj.TabIp;
      let menuName = __parameterObj.menuName;
      let ProtocolPortNo = __parameterObj.ProtocolPortNo;

      let cubicObjData = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);

      let unitObj = {
        minMaxDp: __parameterObj.minMaxDp,
        minMaxPerDp: __parameterObj.minMaxPerDp,
        avgDp: __parameterObj.avgDp,
        stdDevDp: __parameterObj.stdDevDp,
        decPoint: __parameterObj.decPoint
      }

      let unit = (__parameterObj.unit) ? __parameterObj.unit : '';
      let actualWt = __parameterObj.actualWt;

      let cubicObj = cubicObjData.cubicalData;
      let batchNo = cubicObj.Sys_Batch;

      let objSelMenu = __parameterObj.SelectedMenuDetails;
      let side = objSelMenu.Side;
      let sampleNo = (menuName != GLOBAL_NOMENCLATURE.GroupMenu && menuName != GLOBAL_NOMENCLATURE.EmptyGroupMenu) ? parseFloat(objSelMenu.selectedProductDetail.noOfSamples) : 1;
      let maxLimitT2 = objSelMenu.selectedProductDetail.T2Pos;
      let minLimitT2 = objSelMenu.selectedProductDetail.T2Neg;
      let minLimitT1 = 0, maxLimitT1 = 0;

      let getProductType = await models.tbl_product_master.findOne({ where: { MPN_Code: cubicObj.Sys_MPNCode } })
      if (getProductType) { cubicObj.ProductType = getProductType.ProductType };
      let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp);

      let masterTableIncomplete = getTableName.masterTableIncomplete;
      let detailTableIncomplete = getTableName.detailTableIncomplete;
      let masterTable = getTableName.masterTable;
      __parameterObj.masterTable = getTableName.masterTable;
      __parameterObj.detailTable = getTableName.detailTable;
      __parameterObj.masterTableIncomplete = masterTableIncomplete;
      __parameterObj.detailTableIncomplete = detailTableIncomplete;
      __parameterObj.batchSummaryMasterTable = getTableName.batchSummaryMasterTable;
      __parameterObj.batchSummaryDetailTable = getTableName.batchSummaryDetailTable;
      __parameterObj.cubicObj = cubicObj;
      __parameterObj.UserData = tempUserObject;
      __parameterObj.RecSampleNo = counter;
      __parameterObj.typeValue = getTableName.typeValue;
      __parameterObj.RecNo = RecNo;

      let getPowerbackupData = await objPowerBackup.getPowerbackupData(__parameterObj)
      if (!getPowerbackupData) {
        counter = (menuName != GLOBAL_NOMENCLATURE.GroupMenu && menuName != GLOBAL_NOMENCLATURE.EmptyGroupMenu) ? counter + 1 : 1;
      } else {

        if (getPowerbackupData && cubicObj.isPreStart == 1) {
          let whereCondiition = { RepSerNo: getPowerbackupData.Incomp_RepSerNo, Side: side }
          if (menuName != GLOBAL_NOMENCLATURE.GroupMenu) whereCondiition.isCompleted = 0
          const selectRepSrNoObj = await models[detailTableIncomplete].findAll({ where: whereCondiition });
          counter = selectRepSrNoObj.length + 1;
          RecNo = selectRepSrNoObj.length + 1
          __parameterObj.RecNo = RecNo


        }
        if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
          counter = 1;
        } else {
          if (cubicObj.isPreStart != 1) {
            if (getPowerbackupData) counter = getPowerbackupData.RecSampleNo;
            (getPowerbackupData.RecSampleNo == counter && getPowerbackupData.isException == 0) ? counter = counter + 1 : counter

          }
        }
      }

      __parameterObj.RecSampleNo = counter;


      if (__parameterObj.invalidWeightFlag || __parameterObj.invalidUnitFlag) {
        let errorMsg;
        if (__parameterObj.invalidWeightFlag && __parameterObj.invalidUnitFlag) {
          errorMsg = "Weight";
        } else {
          let result = actualWt.substr(actualWt.search(/\d/));
          console.log(result);
          errorMsg = (__parameterObj.invalidWeightFlag) ? "Weight" : "Unit"
        }

        // if (actualWt.match(/[a-zA-z]/g) == null) {
        //   actualWt = Number(actualWt).toFixed(__parameterObj.decPoint);
        // }

        let actualWtUnit = (unit) ? `${actualWt} ${unit}` : actualWt;
        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${(cubicObj.isPreStart == 1 ? RecNo : counter)}:${actualWtUnit}:${"Orange"}`
        );
        mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid ${errorMsg} Recieved`);
      }

      if (counter == 1 && !getPowerbackupData) {
        await objCommonInsertOpt.insert_Into_Incomplete_Master1(__parameterObj);
        await models.tbl_remark_incomplete_master.create({
          DsNo: dsNo,
          TabIp: tabIp,
          paramName: menuName,
          tableName: masterTableIncomplete,
          BatchNumber: batchNo,
        });

        let activity_msg = `${menuName} Test Started on DS ${dsNo}`
        activity_msg = (side == "NA") ? activity_msg : `${activity_msg} for side ${side}`;

        let __activityObj = {
          strUserId: tempUserObject.UserId,
          strUserName: tempUserObject.UserName,
          batch: batchNo,
          activity: activity_msg,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          instrumentType,
          dsNo,
          `tbl_instrumentlog_${instrumentType.toLowerCase()}`,
          menuName,
          "started",
          tabIp,
          tempUserObject,
          cubicObjData,
        );
      }

      let color;
      let limit
      if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) {
        let limitObjResp = await objCommonUseFunc.SendCommon1({
          dsNo,
          actualWt,
          readingIgnore,
          minLimitT2,
          maxLimitT2,
          minLimitT1,
          maxLimitT1,
          menuName,
          counter,
          tabIp
        });
        color = limitObjResp.Color;
        limit = limitObjResp.limit;
        if (limit != "DisplayMessage:Within Limit") { __parameterObj.isExceptionValue = 1 }
      }

      let lastInserted_repsrno = await objCommonInsertOpt.insert_Into_Incomplete_Detail1(__parameterObj, limit);
      __parameterObj.Incomp_RepSerNo = lastInserted_repsrno.repSerNo;
      actualWt = lastInserted_repsrno.actualWt;

      if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag && __parameterObj.isExceptionValue == 0) {
        await objcalc.calculation_operation_new(lastInserted_repsrno.repSerNo, masterTableIncomplete, detailTableIncomplete, actualWt, unitObj, menuName, __parameterObj.typeValue, cubicObj.Sys_RptType, unit, cubicObj.isPreStart);
      }

      // if (menuName != GLOBAL_NOMENCLATURE.GroupMenu) {
      await objPowerBackup.getStatusoFTestForPowerBackup1(__parameterObj);
      // }

      if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) {
        let hmiEntryinConfig = globalData.arrConfigSettings.find((k) => k.DsNo == dsNo && k.TabIp == tabIp).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command && hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);

        // let limitObjResp = await objCommonUseFunc.SendCommon1({
        //   dsNo,
        //   actualWt,
        //   readingIgnore,
        //   minLimitT2,
        //   maxLimitT2,
        //   minLimitT1,
        //   maxLimitT1,
        //   menuName,
        //   counter,
        //   tabIp
        // });
        // let color = limitObjResp.Color;
        // let limit = limitObjResp.limit;

        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${(cubicObj.isPreStart == 1 ? RecNo : counter)}:${Number(actualWt).toFixed(lastInserted_repsrno.decimal)} ${unit}:${color}`
        );

        if (autoTare) {
          mqttSender.sendData(
            dsNo,
            `Port ${ProtocolPortNo}:${mqttProtocol.ComWrite}:${tareCommand}`
          );
        }
        if (limit != "DisplayMessage:Within Limit") {
          __parameterObj.invalidWeightFlag = true;
          mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${limit}`);
        }
      }

      // let obj = {
      //   menuName,
      //   dsNo,
      //   tabIp,
      //   ProtocolPortNo,
      //   counter,
      //   sampleNo,
      //   invalidWeightFlag: __parameterObj.invalidWeightFlag,
      //   invalidUnitFlag: __parameterObj.invalidUnitFlag,
      //   actualWt,
      //   unit,
      //   rptType: cubicObj.Sys_RptType,
      //   batchId: cubicObj.Sys_Batch,
      //   sfoId: cubicObj.Sys_SFOID,
      //   isManual:cubicObj.isManual
      // }
      // let handleMesArr
      // if (cubicObj.isManual == 0 && cubicObj.Sys_RptType == 0 && counter != sampleNo) {
      // if (counter != sampleNo) {
      //   handleMesArr = objCommonWeightment.handleMesArr(obj);
      // }
      let tempPbkupObj = globalData.monitDetail.find(k => k.DsNo == dsNo);
      if (tempPbkupObj != undefined) {
        if (tempPbkupObj.data != undefined) {
          if (tempPbkupObj.data.length > 0) {
            for (var i = 0; i < tempPbkupObj.data.length; i++) {
              await objMonit.monit({
                case: 'TestWeight',
                Hmi: dsNo,
                data: {
                  Weight: tempPbkupObj.data[i].DataValue,
                  srNo: i + 1,
                  message: limit
                }
              })
            }
          }
        }
        var index = globalData.monitDetail.findIndex(k => k.DsNo == dsNo);
        globalData.monitDetail[index].data = [];
      }
      await objMonit.monit({
        case: 'TestWeight',
        Hmi: dsNo,
        data: {
          Weight: actualWt,
          srNo: counter,
          message: limit
        }
      });
      if ((counter == sampleNo) && ((!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) || cubicObj.isPreStart == 1)) {
        let getLimitsObj = objCommonWeightment.getLimitsObj(getTableName.typeValue, cubicObj.Sys_RptType);
        var remark = "Complies";
        var get_Datavalue1 = await models[masterTableIncomplete].findAll({ where: { RepSerNo: lastInserted_repsrno.repSerNo } });
        if (Number(get_Datavalue1[0][getLimitsObj.NoOfAbove2]) != 0 || Number(get_Datavalue1[0][getLimitsObj.NoOfBelow2]) != 0) {
          remark = "Not Complies";
          // SampleRemark.OutOfRemark = true;
        }
        let calObject= await objcalc.calculation_operation_new(lastInserted_repsrno.repSerNo, masterTableIncomplete, detailTableIncomplete, actualWt, unitObj, menuName, __parameterObj.typeValue, cubicObj.Sys_RptType, unit, cubicObj.isPreStart);
        // let parseDatesObj = objCommonInsertOpt.parseJSON(get_Datavalue1[0].dates_json,calObject.jsonDates)

        await models[masterTableIncomplete].update({
          [getLimitsObj.PrEndTime] :moment().format('HH:mm:ss'),
          [getLimitsObj.PrEndDate]: moment().format('YYYY-MM-DD'),
          // [getLimitsObj.PrEndTime] :objCommonInsertOpt.customDateTimeformatter(get_Datavalue1[0][getLimitsObj.PrEndTime],'HH:mm:ss'),
          // [getLimitsObj.PrEndDate]:objCommonInsertOpt.customDateTimeformatter(get_Datavalue1[0][getLimitsObj.PrEndDate],'YYYY-MM-DD'),
          // dates_json:parseDatesObj
        },{
          where:{
            RepSerNo:lastInserted_repsrno.repSerNo
          }
        })
        let Ocal_data = calObject.result
        var cal_data = {
          averageWeight: Ocal_data.avg,
          maxWeight: Ocal_data.max_value,
          minWeight: Ocal_data.min_value,
          stdWeight: Ocal_data.std_value,
          rstdWeight: Ocal_data.rsd_value,
          totalweight: Ocal_data.finalSum
        }
        __parameterObj.remark = remark;
        var Result_remark = (remark == "Complies") ? "Report Within Limit" : "Report Out Of Limit";
        var menuSeqCount;
        // if (cubicObj.Sys_RptType == 0) {
        // await objCommonInsertOpt.saveCompleteData1(__parameterObj);
        // } else {
        // if(side == 'NA' || side == 'RHS') {
        menuSeqCount = await objCommonInsertOpt.updateMenuSequenceEntry(dsNo, tabIp, menuName, lastInserted_repsrno.repSerNo, masterTableIncomplete, masterTable, cubicObj, ProtocolPortNo, side, 'NA', Result_remark);
        // }
        // }

        await models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp, Sys_Batch: cubicObj.Sys_Batch, WeighmentName: menuName } });
        await models.tbl_cubical.update({ Sys_Validation: 0 }, { where: { Sys_DSNumber: dsNo } });
        // if (remark == "Complies" && cubicObj.Sys_RptType == 0) {
        //   let productType = 1;
        //   let obj = {
        //     recordFrom: "Current",
        //     reportOption: menuName,
        //     reportType: "Complete",
        //     testType: "Regular",
        //     RepSerNo: Remark.res.RepSerNo,
        //     userId: tempUserObject.UserId,
        //     username: tempUserObject.UserName,
        //     printNo: 0,
        //     str_url: productType == 1 ? "Tablet" : "Capsule",
        //   };
        //   await objcallPrint.callViewTabReport(obj, productType, dsNo, cubicObj);
        // }

        let activity_msg = `${menuName} Test Completed on DS ${dsNo}`
        activity_msg = (side == "NA") ? activity_msg : `${activity_msg} for side ${side}`;

        let __activityObj = {
          strUserId: tempUserObject.UserId,
          strUserName: tempUserObject.UserName,
          batch: batchNo,
          activity: activity_msg,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          instrumentType,
          dsNo,
          `tbl_instrumentlog_${instrumentType.toLowerCase()}`,
          menuName,
          "completed",
          tabIp,
          tempUserObject,
          cubicObjData,
        );

        // if (cubicObj.isManual == 0 && cubicObj.Sys_RptType !=undefined) {

        // mqttSender.sendData(
        //   dsNo,
        //   `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted}${Result_remark}`
        // );

        // if (cubicObj.Sys_RotaryType == "Double" && side == "LHS") {
        //   obj.sideChangeMsg = `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Side Changes to RHS`;
        // }
        // obj.cal_data = cal_data
        // handleMesArr = objCommonWeightment.handleMesArr(obj);
        // }

        // if ((!menuSeqCount && menuSeqCount == 0) && cubicObj.isManual == 0 && cubicObj.Sys_RptType == 1) {
        //   mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
        // }

        // if (cubicObj.Sys_RotaryType == "Double" && side == "LHS" && cubicObj.isManual == 1) {
        //   let sideChangeMsg = `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Side Changes to RHS`;
        //   mqttSender.sendData(dsNo, sideChangeMsg);
        // }

        globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrCurrentOperationStatus
          : globalData.arrCurrentOperationStatus.splice(
            globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );

        globalData.arrOutFlagForTest.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrOutFlagForTest
          : globalData.arrOutFlagForTest.splice(
            globalData.arrOutFlagForTest.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );

        //test splice if rotarty is not double
        globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrSelectedMenu
          : globalData.arrSelectedMenu.splice(
            globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );
      }

    } catch (error) {
      throw new Error(error);
    }
  }
}
module.exports = Individual;
