//packages
const date = require("date-and-time");

const globalData = require("../../global/globalData");
const Database = require("../../database/clsQueryProcess");
const MqttSender = require("../Mqtt/mqttSender.class");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const ActivityModel = require("../clsActivityLog.model");
const InstrumentUsageModel = require("../clsInstrumentUsageLog");
const MqttModel = require("../Mqtt/mqttSender.class");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const serverConfig = require("../../../../IncrencyV4DRLTSHConfig.json");
const momentObj = require("moment");
const maths = require("mathjs");
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const clsCommonWeightment = require("../Product/clsCommonWeightment");
const objCommonWeightment = new clsCommonWeightment()
const check_srNO_ = require("../Product/cls_consolidate_reportOperation");
const check_srNO = new check_srNO_();
const objMonit = new clsMonit();
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const objCommonInsertOpt = new clsCommonInsertOpt();
const database = new Database();
const now = new Date();
const objformulaFun = new FormulaFunModel();
const objActivityLog = new ActivityModel();
const objInstrumentUsage = new InstrumentUsageModel();
const mqttSender = new MqttModel();
const objCommonUseFunc = new clsCommonUseFunction();
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
//const { models } = require('../../../config/dbConnection');
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes, where } = require("sequelize");
const { numericDependencies } = require("mathjs");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup.js");
// const OPCops = require("../OPC/opcOps");

const clsCalculations = require('../clsCalculationOperation.js');
const tbl_cubical = require("../../../../IncrencyV4_DRL_Model/models/Setting/System Setting/tbl_cubical.js");
const commonCalculations = new clsCalculations()
const objPowerBackup = new PowerBackup();
// const objOPCops = new OPCops();

class Group {
  async processGroupData(instrumentType, __parameterObj) {
    try {
      let readingIgnore;
      let counter = 1;
      let decimal = 0;
      let dsIp = __parameterObj.DsIp;
      let dsNo = __parameterObj.DsNo;
      let tabIp = __parameterObj.TabIp;
      let menuName = __parameterObj.menuName;
      let ProtocolPortNo = __parameterObj.ProtocolPortNo;

      let cubicObjData = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);

      let unitObj = {
        minMaxDp: __parameterObj.minMaxDp,
        minMaxPerDp: __parameterObj.minMaxPerDp,
        avgDp: __parameterObj.avgDp,
        stdDevDp: __parameterObj.stdDevDp,
        decPoint: __parameterObj.decPoint
      }

      let unit = (__parameterObj.unit) ? __parameterObj.unit : '';
      let actualWt = __parameterObj.actualWt;

      let cubicObj = cubicObjData.cubicalData;
      let batchNo = cubicObj.Sys_Batch;

      let objSelMenu = __parameterObj.SelectedMenuDetails;
      let side = objSelMenu.Side;
      let sampleCount = (serverConfig.plant != "FT03") ? 1 : 3;
      let sampleNo = (menuName != GLOBAL_NOMENCLATURE.GroupMenu) ? parseFloat(objSelMenu.selectedProductDetail.noOfSamples) : sampleCount;
      // let maxLimitT2 = objSelMenu.selectedProductDetail.T2Pos;//
      // let minLimitT2 = objSelMenu.selectedProductDetail.T2Neg;//
      // let minLimitT1 = 0, maxLimitT1 = 0;//

      let getProductType = await models.tbl_product_master.findOne({ where: { MPN_Code: cubicObj.Sys_MPNCode } })
      if (getProductType) { cubicObj.ProductType = getProductType.ProductType };
      let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp);

      let masterTableIncomplete = getTableName.masterTableIncomplete;
      let detailTableIncomplete = getTableName.detailTableIncomplete;
      let masterTable = getTableName.masterTable;
      __parameterObj.masterTable = getTableName.masterTable;
      __parameterObj.detailTable = getTableName.detailTable;
      __parameterObj.masterTableIncomplete = masterTableIncomplete;
      __parameterObj.detailTableIncomplete = detailTableIncomplete;
      __parameterObj.batchSummaryMasterTable = getTableName.batchSummaryMasterTable;
      __parameterObj.batchSummaryDetailTable = getTableName.batchSummaryDetailTable;
      __parameterObj.cubicObj = cubicObj;
      __parameterObj.UserData = tempUserObject;
      __parameterObj.RecSampleNo = counter;
      __parameterObj.typeValue = getTableName.typeValue;

      let getPowerbackupData = await objPowerBackup.getPowerbackupData(__parameterObj)

      if (!getPowerbackupData) {
        counter = (menuName != GLOBAL_NOMENCLATURE.GroupMenu) ? counter + 1 : 1;
      } else {
        if (getPowerbackupData) counter = getPowerbackupData.RecSampleNo;
        if (getPowerbackupData.RecSampleNo == counter && getPowerbackupData.isException == 0) counter = counter + 1
      }

      __parameterObj.RecSampleNo = counter;

      if (__parameterObj.invalidWeightFlag || __parameterObj.invalidUnitFlag) {
        let errorMsg;
        if (__parameterObj.invalidWeightFlag && __parameterObj.invalidUnitFlag) {
          errorMsg = "Weight";
        } else {
          let result = actualWt.substr(actualWt.search(/\d/));
          console.log(result);
          errorMsg = (__parameterObj.invalidWeightFlag) ? "Weight" : "Unit"
        }

        if (actualWt.match(/[a-zA-z]/g) == null) {
          actualWt = Number(actualWt).toFixed(__parameterObj.decPoint);
        }

        let actualWtUnit = (unit) ? `${actualWt} ${unit}` : actualWt;
        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${counter}:${actualWtUnit}:${"Orange"}`
        );
        mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid ${errorMsg} Recieved`);
      }

      if (counter == 1 && !getPowerbackupData) {
        await objCommonInsertOpt.insert_Into_Incomplete_Master1(__parameterObj);
        await models.tbl_remark_incomplete_master.create({
          DsNo: dsNo,
          TabIp: tabIp,
          paramName: menuName,
          tableName: masterTableIncomplete,
          BatchNumber: batchNo,
        });

        let activity_msg = `${menuName} Test Started on DS ${dsNo}`
        activity_msg = (side == "NA") ? activity_msg : `${activity_msg} for side ${side}`;

        let __activityObj = {
          strUserId: tempUserObject.UserId,
          strUserName: tempUserObject.UserName,
          batch: batchNo,
          activity: activity_msg,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          instrumentType,
          dsNo,
          `tbl_instrumentlog_${instrumentType.toLowerCase()}`,
          menuName,
          "started",
          tabIp,
          tempUserObject,
          cubicObjData,
        );
      }

      let color;
      let limit = ''
      if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) {
        // let limitObjResp = await objCommonUseFunc.SendCommon1({
        //   dsNo,
        //   actualWt,
        //   readingIgnore,
        //   minLimitT2,
        //   maxLimitT2,
        //   minLimitT1,
        //   maxLimitT1,
        //   menuName,
        //   counter,
        //   tabIp
        // });
        let regex = /\d+(.\d+)/
        if (actualWt.match(regex)) {
          limit = 'DisplayMessage:Within Limit'
        }
        else {
          limit = ''
        }
        // color = limitObjResp.Color;
        // limit = limitObjResp.limit;
        // if (limit != "DisplayMessage:Within Limit") { __parameterObj.isExceptionValue = 1 }//
      }
      let lastInserted_repsrno

      //insertion into initialdetaile2
      if (counter == 1) {
        lastInserted_repsrno = await objCommonInsertOpt.insert_Into_Incomplete_Detail1(__parameterObj, limit);
        __parameterObj.Incomp_RepSerNo = lastInserted_repsrno.repSerNo;

      }
      else {
        let samplesNoInDB = counter - 1;
        let columnName = `DataValue${samplesNoInDB}`

        let repSerNo = await objCommonInsertOpt.lastInsertedRecords1(batchNo, cubicObjData.cubicalData.Sys_MPNCode, cubicObjData.cubicalData.Sys_RptType, masterTableIncomplete, dsNo, tabIp);
        const insertDetail = await models.tbl_tab_detail2_incomplete.update({
          [columnName]: actualWt
        }, { where: { RepSerNo: repSerNo } });

        const masterData = await models.tbl_tab_master2_incomplete.findAll({ where: { RepSerNo: repSerNo } });
        if (masterData.length > 0) {
          const selectRepSrNoObj = await models[detailTableIncomplete].findAll({ where: { RepSerNo: repSerNo, Side: side, isException: 0 } });
          if (selectRepSrNoObj.length > 0) {
            let getLimitsObj = objCommonWeightment.getLimitsObj(__parameterObj.typeValue, cubicObjData.cubicalData.Sys_RptType)
            // decimal = (selectRepSrNoObj.length === 0) ? masterData[0][getLimitsObj.DecimalPoint] : __parameterObj.decPoint;
            decimal = selectRepSrNoObj[0].DP;

          } else {
            decimal = __parameterObj.decPoint
          }
        }
        lastInserted_repsrno = {
          repSerNo: repSerNo,
          decimal: decimal,
          actualWt: actualWt
        }
      }



      // if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag && __parameterObj.isExceptionValue == 0) {
      //   await commonCalculations.calculation_operation_new(lastInserted_repsrno.repSerNo, masterTableIncomplete, detailTableIncomplete, actualWt, unitObj, menuName, __parameterObj.typeValue, cubicObj.Sys_RptType, unit);
      // }

      // if (menuName != GLOBAL_NOMENCLATURE.GroupMenu) {
      await objPowerBackup.getStatusoFTestForPowerBackup1(__parameterObj);
      // }

      if (!__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) {
        let hmiEntryinConfig = globalData.arrConfigSettings.find((k) => k.DsNo == dsNo && k.TabIp == tabIp).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command && hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);

        // let limitObjResp = await objCommonUseFunc.SendCommon1({
        //   dsNo,
        //   actualWt,
        //   readingIgnore,
        //   minLimitT2,
        //   maxLimitT2,
        //   minLimitT1,
        //   maxLimitT1,
        //   menuName,
        //   counter,
        //   tabIp
        // });
        let color = 'white';
        // let limit = limitObjResp.limit;

        mqttSender.sendData(
          dsNo,
          `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${counter}:${Number(actualWt).toFixed(lastInserted_repsrno.decimal)} ${unit}:${color}`
        );

        if (autoTare) {
          mqttSender.sendData(
            dsNo,
            `Port ${ProtocolPortNo}:${mqttProtocol.ComWrite}:${tareCommand}`
          );
        }
        if (limit != "DisplayMessage:Within Limit") {
          __parameterObj.invalidWeightFlag = true;
          mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${limit}`);
        }
      }

      let obj = {
        menuName,
        dsNo,
        tabIp,
        ProtocolPortNo,
        counter,
        sampleNo,
        invalidWeightFlag: __parameterObj.invalidWeightFlag,
        invalidUnitFlag: __parameterObj.invalidUnitFlag,
        actualWt,
        unit,
        rptType: cubicObj.Sys_RptType,
        batchId: cubicObj.Sys_Batch,
        sfoId: cubicObj.Sys_SFOID,
        isManual: cubicObj.isManual,
        Area: cubicObj.Sys_Area
      }
      let handleMesArr
      if (cubicObj.isManual == 0 && counter < sampleNo) {
        handleMesArr = objCommonWeightment.handleMesArr(obj);
      }

      let tempPbkupObj = globalData.monitDetail.find(k => k.DsNo == dsNo);
      if (tempPbkupObj != undefined) {
        if (tempPbkupObj.data != undefined) {
          if (tempPbkupObj.data.length > 0) {
            for (var i = 0; i < tempPbkupObj.data.length; i++) {
              await objMonit.monit({
                case: 'TestWeight',
                Hmi: dsNo,
                data: {
                  Weight: tempPbkupObj.data[i].DataValue,
                  srNo: i + 1,
                  message: limit
                }
              })
            }
          }
        }
        var index = globalData.monitDetail.findIndex(k => k.DsNo == dsNo);
        globalData.monitDetail[index].data = [];
      }
      await objMonit.monit({
        case: 'TestWeight',
        Hmi: dsNo,
        data: {
          Weight: actualWt,
          srNo: counter,
          message: limit
        }
      });
      if (counter == sampleNo && !__parameterObj.invalidWeightFlag && !__parameterObj.invalidUnitFlag) {
        let getLimitsObj = objCommonWeightment.getLimitsObj(getTableName.typeValue, cubicObj.Sys_RptType);
        var remark = "Complies";
        var get_Datavalue1 = await models[masterTableIncomplete].findAll({ where: { RepSerNo: lastInserted_repsrno.repSerNo } });
        if (Number(get_Datavalue1[0][getLimitsObj.NoOfAbove2]) != 0 || Number(get_Datavalue1[0][getLimitsObj.NoOfBelow2]) != 0) {
          remark = "Not Complies";
          // SampleRemark.OutOfRemark = true;
        }
        // let Ocal_data = await commonCalculations.calculation_operation_new(lastInserted_repsrno.repSerNo, masterTableIncomplete, detailTableIncomplete, actualWt, unitObj, menuName, __parameterObj.typeValue, cubicObj.Sys_RptType, unit);
        // var cal_data = {
        //   averageWeight: Ocal_data.avg,
        //   maxWeight: Ocal_data.max_value,
        //   minWeight: Ocal_data.min_value,
        //   stdWeight: Ocal_data.std_value,
        //   rstdWeight: Ocal_data.rsd_value,
        //   totalweight: Ocal_data.finalSum
        // }
        __parameterObj.remark = remark;
        var Result_remark = 'Test Completed';
        var menuSeqCount;
        if (counter == sampleNo && __parameterObj.invalidWeightFlag == false && __parameterObj.invalidUnitFlag == false) {
          let result = await objCommonInsertOpt.saveCompleteData1(__parameterObj);
          obj.RepSerNo = result.res.RepSerNo;
          let flag = true;
          let detail = await models.tbl_tab_detail2.findOne({ where: { RepSerNo: obj.RepSerNo } })
          let sum = parseFloat(detail.DataValue) + parseFloat(detail.DataValue1) + parseFloat(detail.DataValue2)
          let avg = Number(maths.round((sum / 3), 3)).toFixed(3)
          if(!isNaN(avg)){
            await models.tbl_tab_master2.update({
              avgwt2: Number(maths.round(avg, 3)).toFixed(3)
            },
              {
                where: {
                  RepSerNo: obj.RepSerNo
                }
              })
          }
          
          if (cubicObj.isManual == 0) {
            obj.avg = avg != 'NaN' ? avg : 'NA';
            handleMesArr = objCommonWeightment.handleMesArr(obj);
          }

          mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted} ${Result_remark}:OkBtn ${flag}`)
          if (cubicObj.isManual == 0) {
            mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
          }
        }
        await models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp, Sys_Batch: cubicObj.Sys_Batch, WeighmentName: menuName } });
        await models.tbl_cubical.update({ Sys_Validation: 0 }, { where: { Sys_DSNumber: dsNo } });
        // if (remark == "Complies" && cubicObj.Sys_RptType == 0) {
        //   let productType = 1;
        //   let obj = {
        //     recordFrom: "Current",
        //     reportOption: menuName,
        //     reportType: "Complete",
        //     testType: "Regular",
        //     RepSerNo: Remark.res.RepSerNo,
        //     userId: tempUserObject.UserId,
        //     username: tempUserObject.UserName,
        //     printNo: 0,
        //     str_url: productType == 1 ? "Tablet" : "Capsule",
        //   };
        //   await objcallPrint.callViewTabReport(obj, productType, dsNo, cubicObj);
        // }

        let activity_msg = `${menuName} Test Completed on DS ${dsNo}`
        activity_msg = (side == "NA") ? activity_msg : `${activity_msg} for side ${side}`;

        let __activityObj = {
          strUserId: tempUserObject.UserId,
          strUserName: tempUserObject.UserName,
          batch: batchNo,
          activity: activity_msg,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          instrumentType,
          dsNo,
          `tbl_instrumentlog_${instrumentType.toLowerCase()}`,
          menuName,
          "completed",
          tabIp,
          tempUserObject,
          cubicObjData,
        );

        // if (cubicObj.isManual == 0 && cubicObj.Sys_RptType !=undefined) {

        // mqttSender.sendData(
        //   dsNo,
        //   `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted}${Result_remark}`
        // );

        // if (cubicObj.Sys_RotaryType == "Double" && side == "LHS") {
        //   obj.sideChangeMsg = `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Side Changes to RHS`;
        // }
        // obj.cal_data = cal_data
        // handleMesArr = objCommonWeightment.handleMesArr(obj);
        // }

        // if ((!menuSeqCount && menuSeqCount == 0) && cubicObj.isManual == 0 && cubicObj.Sys_RptType == 1) {
        //   mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
        // }

        // if (cubicObj.Sys_RotaryType == "Double" && side == "LHS" && cubicObj.isManual == 1) {
        //   let sideChangeMsg = `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Side Changes to RHS`;
        //   mqttSender.sendData(dsNo, sideChangeMsg);
        // }

        globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrCurrentOperationStatus
          : globalData.arrCurrentOperationStatus.splice(
            globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );

        globalData.arrOutFlagForTest.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrOutFlagForTest
          : globalData.arrOutFlagForTest.splice(
            globalData.arrOutFlagForTest.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );

        //test splice if rotarty is not double
        globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
          ? globalData.arrSelectedMenu
          : globalData.arrSelectedMenu.splice(
            globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
            1
          );
      }

    } catch (error) {
      console.log(error);
      throw new Error(error);
    }
  }


  async calculateSeqNo(dataObj) {
    try {
      const masterTableName = dataObj.masterTable;
      const detailTableName = dataObj.detailTable;
      let side = dataObj.side;

      let selectRes = await models[masterTableName].max("RepSerNo", {
        where: {
          BFGCode: dataObj.BFGCode,
          ProductName: dataObj.ProductName,
          PVersion: dataObj.PVersion,
          Version: dataObj.Version,
          BatchNo: dataObj.BatchNo,
        },
      });



      if (!selectRes) {
        return 1;
      } else {
        let reqSeqRes = await models[detailTableName].max("RecSeqNo", {
          where: {
            RepSerNo: selectRes,
            Side: side == "NA" ? "Single" : side,
          },
        });

        if (!reqSeqRes) {
          return 1;
        } else {
          return reqSeqRes + 1;
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }
}
module.exports = Group;
