const date = require('date-and-time');
const moment = require('moment')
const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const clsformulaFun = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const serverConfig = require('../../global/serverConfig');
const clsMenuRequest = require('../Menu/MenuRequest.model')
const clsBatchSummary = require('../Product/clsBatchSummaryOperation');
const clsProObj = require('../Product/clsProductDetailModel');
const clsSP = require('../../model/Product/clsStoreProcedure');
const maths = require('mathjs');
const { create, all } = require("mathjs");
const clsCommonWeightment = require("../Product/clsCommonWeightment");
const objCommonWeightment = new clsCommonWeightment()
const check_srNO_ = require("../Product/cls_consolidate_reportOperation");
const check_srNO = new check_srNO_();
// const date = require('date-and-time');
const Global_Nomenclature = require('../../global/GLOBAL_NOMENCLATURE')
const clsPrintOperations = require("../Print/clsPrintOperation")
const configFile = require("../../../../IncrencyV4DRLTSHConfig.json");
const printOperations = new clsPrintOperations()
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new clsformulaFun();
const objMenuRequest = new clsMenuRequest();
const objBatchSummary = new clsBatchSummary();
const proObj = new clsProObj();
const objSP = new clsSP();
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();
const { QueryTypes } = require('sequelize');
const config = {};
const mathj = create(all, config);
// const fetchDetails = new clsFetchDetail();
// const Global_Nomenclature=Global_Nomenclature();
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize
const { where } = require('sequelize/lib/sequelize');
const tbl_powerbackup = require('../../../../IncrencyV4_DRL_Model/models/Report/Common Tablet-Capsule/tbl_powerbackup');
const tbl_menu_sequence = require('../../../../IncrencyV4_DRL_Model/models/Menu/tbl_menu_sequence');
const tbl_exception_sample_initial = require('../../../../IncrencyV4_DRL_Model/models/Report/Tablet/tbl_exception_sample_initial');

class FriabilityModel {
    constructor() {
        this.math = maths;
    }
    async processFriabilityData(dataObj) {
        try {
            let strHmi = dataObj.Hmi;
            let strIdsNo = dataObj.idsNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            // let ProtocolPortNo = __parameterObj.ProtocolPortNo;

            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

            let __activityObj = {
                strUserId: tempUserObject.UserId,
                strUserName: tempUserObject.UserName,
                batch: CurrentCubicalObj.Sys_Batch,
                activity: `Friability Test Started on TSH ${strHmi}`
            }
            let Friabilitydetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            var timeForFriabStart = Friabilitydetail.data.Time
            timeForFriabStart = moment().format(timeForFriabStart, ' hh:mm:ss ');

            await objActivityLog.ActivityLogEntry(__activityObj, timeForFriabStart);


            await objInstrumentUsage.InstrumentUsageForDTandFriab('Friabilator',
                strIdsNo, 'tbl_instrumentlog_friability', 'Friabilator', 'started', timeForFriabStart);

            if (hmiDetailsInPMenu.Sys_RotaryType == "Double" && dataObj.recived_string_type == "Single") {
                console.log("invalid string")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`);

            } else if (hmiDetailsInPMenu.Sys_RotaryType == "Single" && dataObj.recived_string_type == "Double") {
                console.log("invalid string")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`);
            }
            else {
                //type
                // let strIdsNo = dataObj.idsNo;
                let actualWtA2, actualWtB2;
                let actualWtA1 = dataObj.actualWtAfterDrum1.split(' ');
                let actualWtB1 = dataObj.actualWtBeforeDrum1.split(' ');

                if (dataObj.actualWtAfterDrum2 != undefined) {
                    actualWtA2 = dataObj.actualWtAfterDrum2.split(' ')
                } else {
                    actualWtA2 = 0;
                }
                if (dataObj.actualWtBeforeDrum2 != undefined) {
                    actualWtB2 = dataObj.actualWtBeforeDrum2.split(' ')
                } else {
                    actualWtB2 = 0;
                }


                // let decimal1 = dataObj.decPoint1
                // let decimal2 = dataObj.decPoint2;
                // let unit1 = dataObj.unit1
                // let unit2 = dataObj.unit2;
                const menuName = dataObj.menuName;
                let typeValue;


                let lwtBeforeTest, lwtAfterTest, rwtAfterTest, rwtBeforeTest, nwtBeforeTest, nwtAfterTest;
                let objActivity = {};
                const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
                const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
                const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
                let batchNo = FriabilityDetail1.data.Batch;
                let sample = FriabilityDetail1.data.noOfSample;
                var menuStartTime = FriabilityDetail1.data.Time
                menuStartTime = moment().format(menuStartTime, ' hh:mm:ss ');
                var menuStartDate = FriabilityDetail1.data.Date
                menuStartDate = moment().format('YYYY-MM-DD', menuStartDate);
                let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
                let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
                let strTableName, strDetailTbl;

                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounter.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }

                tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

                switch (menuName) {
                    case 'Friability': {
                        strTableName = "tbl_tab_friability";
                        typeValue = 8;
                    }
                        break;
                    default:
                }

                let productObj = FriabilityDetail1.data;
                let side;
                if (hmiDetailsInPMenu.Sys_RotaryType == 'Single') {
                    side = "NA";
                    console.log('single');
                } else {
                    side = "LHS";
                }

                lwtBeforeTest = parseFloat(actualWtB1[0]);
                lwtBeforeTest = this.math.round(lwtBeforeTest, 3)
                // lwtBeforeTest =lwtBeforeTest.toFixed(3)
                rwtBeforeTest = isNaN(parseFloat(actualWtB2[0])) == true ? 0 : parseFloat(actualWtB2[0]);
                rwtBeforeTest = this.math.round(rwtBeforeTest, 3)

                lwtAfterTest = parseFloat(actualWtA1[0]);
                lwtAfterTest = this.math.round(lwtAfterTest, 3)
                rwtAfterTest = isNaN(parseFloat(actualWtA2[0])) == true ? 0 : parseFloat(actualWtA2[0]);
                rwtAfterTest = this.math.round(rwtAfterTest, 3)


                nwtBeforeTest = 0;
                nwtAfterTest = 0;

                if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
                    nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest);
                    nwtBeforeTest = this.math.round(nwtBeforeTest, 3)
                    nwtAfterTest = 0
                } else {
                    nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest);
                    nwtBeforeTest = this.math.round(nwtBeforeTest, 3)
                    nwtAfterTest = (((rwtBeforeTest - rwtAfterTest) * 100) / rwtBeforeTest);
                    nwtAfterTest = this.math.round(nwtAfterTest, 3)
                }
                var Drum_1 = dataObj.friability_drum1 == undefined ? "" : dataObj.friability_drum1.split('%')
                var Drum_2 = dataObj.friability_drum2 == undefined ? "" : dataObj.friability_drum2.split('%')

                const __parameterFriability = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: productDetail.productType,
                    uniqueSerialNumber: strIdsNo,
                    friabId: dataObj.instrumentId,
                    WTBD1: Number(lwtBeforeTest).toFixed(3),
                    WTAD1: Number(lwtAfterTest).toFixed(3),
                    WTBD2: Number(rwtBeforeTest).toFixed(3),
                    WTAD2: Number(rwtAfterTest).toFixed(3),
                    nwtBeforeTest: Number(nwtBeforeTest).toFixed(2),
                    nwtAfterTest: Number(nwtAfterTest).toFixed(2),
                    friability_drum1: Number(Drum_1[0]).toFixed(2),
                    friability_drum2: Number(Drum_2[0]).toFixed(2),
                    strHmi: strHmi,
                    strIdsNo: strIdsNo,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail,
                    Batch: batchNo,
                    interval: FriabilityDetail1.data,
                    menuStartTime: menuStartTime,
                    menuStartDate: menuStartDate,
                    side: side,
                    actualCount: dataObj.actualCount,
                    actualRpm: dataObj.actualRpm,
                }


                // var res = await proObj.productData(productObj)
                // let productDetail = productDetail.productType
                let now = new Date();
                let batchSummaryObject = {
                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                    Version: hmiDetailsInPMenu.Sys_Version,
                    Area: hmiDetailsInPMenu.Sys_Area,
                    PrdType: 1,
                    CubType: hmiDetailsInPMenu.Sys_CubType,
                    CubicleNo: hmiDetailsInPMenu.Sys_CubicNo,
                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                    Side: side == "NA" ? "Single" : "Double",
                    InstrumentID: CurrentCubicalObj.Sys_FriabID,
                    UserId: tempUserObject.UserId,
                    UserName: tempUserObject.UserName,
                    nwtBeforeTest: Number(nwtBeforeTest).toFixed(3),
                    nwtAfterTest: Number(nwtAfterTest).toFixed(3),
                    lwtBeforeTest: Number(lwtBeforeTest).toFixed(3),
                    lwtAfterTest: Number(lwtAfterTest).toFixed(3),
                    rwtBeforeTest: Number(rwtBeforeTest).toFixed(3),
                    rwtAfterTest: Number(rwtAfterTest).toFixed(3),
                    friability_drum1: Number(nwtBeforeTest).toFixed(2),
                    friability_drum2: Number(rwtAfterTest).toFixed(2),
                    Dept: hmiDetailsInPMenu.Sys_dept,
                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                    Tol1Neg: productDetail.productDetail[0][0].Param8_T1Neg,
                    Tol1Pos: productDetail.productDetail[0][0].Param8_T1Pos,
                    BatchSize: productDetail.productType.BatchSize,
                    PrTime: moment().format('HH:mm:ss'),
                    PrDate: moment().format('YYYY-MM-DD'),
                }

                console.log(batchSummaryObject);
                let resFri = await this.saveToCompleteData(__parameterFriability, productDetail);
                if (resFri) {
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: CurrentCubicalObj.Sys_Batch },
                        { activity: `Friability Test Completed on TSH ${strHmi}` });

                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Friabilator', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

                }
                var result = await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1, dataObj);
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': CurrentCubicalObj.Sys_rpi
                    }

                });
                var NMT = FriabilityDetail1.data.NMT.split("%")[0]
                if (dataObj.friability_drum1 != undefined) {
                    var drum1 = __parameterFriability.nwtBeforeTest
                }
                if (dataObj.friability_drum2 != undefined) {
                    var drum2 = __parameterFriability.nwtAfterTest
                }
                var remark1
                if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
                    if (Number(NMT) >= Number(drum1)) {
                        remark1 = 'Complies'
                    } else {
                        remark1 = 'Not Complies'
                    }
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${__parameterFriability.WTBD1.concat(' gm')};WTAD1:${__parameterFriability.WTAD1.concat(' gm')};NWTD1:${nwtBeforeTest};Perc1:${dataObj.friability_drum1};`);
                } else {
                    if (Number(NMT) >= Number(drum1) && Number(NMT) >= Number(drum2)) {
                        remark1 = 'Complies'
                    } else {
                        remark1 = 'Not Complies'
                    }
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${__parameterFriability.WTBD1.concat(' gm')};WTAD1:${__parameterFriability.WTAD1.concat(' gm')};WTBD2:${__parameterFriability.WTBD2.concat(' gm')};WTAD2:${__parameterFriability.WTAD2.concat(' gm')};NWTD1:${nwtBeforeTest};NWTD2:${nwtAfterTest};Perc1:${dataObj.friability_drum1};Perc2:${dataObj.friability_drum2}`);
                }
                // await objOPCops.Friability(resFri,remark1)
                await models.tbl_tab_friability.update({
                    NWtRemark: remark1
                }, {
                    where: {
                        RepSerNo: resFri
                    }
                });
                if (remark1 == "Complies") {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: "Friability",
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: resFri,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: productDetail.productType.ProductType === 1 ? "Tablet" : "Capsule"
                    }


                    await printOperations.callViewTabReport(printObj, productDetail.productType.ProductType, strHmi)
                }
                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentProductData :
                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrProductTypeArray :
                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentCounter :
                    globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                //test splice if rotarty is not double
                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed `);
            }
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }
    }

    async saveToCompleteData(data, friDetail) {
        try {
            let strHmi = data.strHmi;
            let strIdsNo = data.strIdsNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData; //idsNo
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let productObj = data.objProductDetails;

            let now = new Date();

            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }


            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

            var result = await models.tbl_tab_friability.findAll({
                attributes: [
                    [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                ],
                where: {
                    'BFGCode': productObj.ProductId,
                    'ProductName': productObj.ProductName,
                    'PVersion': productObj.ProductVersion,
                    'Version': productObj.Version,
                    'BatchNo': data.Batch,
                    'IdsNo': strHmi,
                }
            })


            var intMstSerNo;
            if (result[0].SeqNo == null) {
                intMstSerNo = 1;
            } else {
                var newMstSerNo = result[0].SeqNo + 1;
                intMstSerNo = newMstSerNo;
            }

            let instrumentID = data.friabId

            //remove net wt 
            let bRepSerNo = await this.getMaxBRepSerNo(productObj.ProductName, data.Batch, 'tbl_tab_friability', hmiDetailsInPMenu.Sys_RptType, hmiDetailsInPMenu.Sys_RotaryType)
            var lastinserted = await models.tbl_tab_friability.create({
                'MstSerNo': intMstSerNo,
                'BFGCode': productObj.ProductId,
                'ProductName': productObj.ProductName,
                'ProductType': productObj.ProductType,
                'IdsNo': strHmi,
                'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                'BatchNo': data.Batch,
                'UserId': tempUserObject.UserId,
                'UserName': tempUserObject.UserName,
                'PrDate': data.menuStartDate,
                'PrTime': data.menuStartTime,
                // 'PrTime': date.format(now, 'HH:mm:ss'),
                'PrEndDate': moment().format('YYYY-MM-DD'),
                'PrEndTime': moment().format('HH:mm:ss'),
                'Side': hmiDetailsInPMenu.Sys_RotaryType !== "Single" ? "Double" : "Single",
                'Unit': 'g',
                'DecimalPoint': 0,
                'WgmtModeNo': 8,
                'FriNMTLimit': friDetail.productDetail[0][0].Param8_Nom,
                'SetCount': friDetail.productDetail[0][0].Param8_T1Neg,
                'SetRPM': friDetail.productDetail[0][0].Param8_T1Pos,
                'FriabilityQty': Number(data.interval.noOfSample),
                'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                'ReportType': hmiDetailsInPMenu.Sys_RptType,
                'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                'MFGCode': hmiDetailsInPMenu.Sys_MfgCode,
                'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': CurrentCubicalObj.Sys_FriabID,
                'FriabilityID': instrumentID,
                'BalanceId': CurrentCubicalObj.Sys_BalID,
                'NWtBeforeTest': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtBeforeTest,
                'NWtAfterTest': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTAD1 : data.nwtBeforeTest,
                'NWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.nwtBeforeTest : data.nwtBeforeTest,
                'LWtBeforeTest': data.WTBD1,
                'LWtAfterTest': data.WTAD1,
                'LWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtBeforeTest,
                'RWtBeforeTest': data.WTBD2,
                'RWtAfterTest': data.WTAD2,
                'RWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtAfterTest,
                'PrintNo': 0,
                'IsArchived': 0,
                // 'BalanceId': data.strBalId,
                'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                'Version': hmiDetailsInPMenu.Sys_Version,
                'BRepSerNo': bRepSerNo,
                'RepoLabel11': hmiDetailsInPMenu.Sys_Validation,
                'Lot': 'LotNo',
                'ActualCount': Number(data.actualCount),
                'ActualRPM': Number(data.actualRpm),
                "NMT": Number(data.interval.NMT.split("%")[0]).toFixed(2),
                'Area': hmiDetailsInPMenu.Sys_Area,
                'AppearanceDesc': hmiDetailsInPMenu.Sys_Appearance,
                'MachineSpeed_Min': hmiDetailsInPMenu.Sys_MachineSpeed_Min,
                'MachineSpeed_Max': hmiDetailsInPMenu.Sys_MachineSpeed_Max,
                'GenericName': hmiDetailsInPMenu.Sys_GenericName,
                'BMRNo': hmiDetailsInPMenu.Sys_BMRNo,
                'Stage': hmiDetailsInPMenu.Sys_Stage,
                'Interval': data.interval.interval
            })

            return lastinserted.RepSerNo

        } catch (error) {
            console.log(error)
            throw new Error(error);
        }
    }

    //for Balance With Friability
    async processBalanceFriabilityData(dataObj) {
        try {
            let now = new Date();
            const moment = require('moment')
            let strHmi = dataObj.Hmi;
            let strIdsNo = dataObj.idsNo;
            let receiveWt = mathj.round(dataObj.actualWt, 3).toFixed(3);
            let unit = dataObj.unit.toLowerCase();//dataObj.unit;
            let mqunit = dataObj.mqtt;
            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);
            const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            let batchNo = FriabilityDetail1.data.Batch;
            let sample = FriabilityDetail1.data.noOfSample;
            let ProtocolPortNo = dataObj.ProtocolPortNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            if (mqunit == 'g') {
                var GroupUn = mqunit.includes('g')
                if (GroupUn == true) {
                    mqunit = "gm"
                }
            }
            // if (mqunit != 'gm') {
            //     console.log(mqunit);
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Weight Recieved!`);
            //     let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
            //     let autoTare = hmiEntryinConfig[0].AutoTare;
            //     let tareCommand = hmiEntryinConfig[0].Tare_Command
            //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
            //     return
            // }
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            var SelectstrHmi
            if (IPQCObject != undefined) {
                SelectstrHmi = IPQCObject.selectedIds.Idsno;
            } else {
                SelectstrHmi = strHmi;
            }

            let selectedIdsNo;

            if (FriabilityDetail1.data.Rotary == 'Double') {
                let SideArray = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi)
                if (SideArray != undefined) {
                    var Side = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi).Side
                }
                var tempSide;
                if (FriabilityDetail1.data.Rotary == 'Double') {
                    if (FriabilityDetail1.data.Side == 'LHS') {
                        tempSide = 'RHS'
                    } else {
                        tempSide = 'LHS'
                    }
                }
            }
            const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);


            let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
            let lstInsertId;
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let objActivity = {};
            let __activityObj = {};


            //powerbackup

            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                    // SelectedIds: SelectstrHmi,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    WeighmentName: 'FRIAB',
                    IdsNo: strHmi
                }
            })

            powerbacc = powerbacc.pop();

            if (powerbacc != undefined) {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'Hmi': strHmi,
                        'counter': powerbacc.Before_Count
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'Hmi': strHmi,
                        'counter': powerbacc.After_Count
                    })
                }
            } else {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }
            }


            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);

            //temp counter for double

            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);

            // await objInstrumentUsage.InstrumentUsage('Balance',
            //     strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'started');
            // }

            const __parameterFriability = {
                objProductDetails: productDetail.productType,
                uniqueSerialNumber: strIdsNo,
                strBalId: dataObj.instrumentId,
                strHmi: strHmi,
                receiveWt: receiveWt,
                seqNoOfWt: tempCounterObj.counter,
                productType: objSelMenu.selectedProductDetail,
                Batch: batchNo,
                unit: unit,
                Api_data: FriabilityDetail1
            }
            let resSelectFri = await models.tbl_tab_detail8.findAll({
                attributes: [[sequelize.fn('max', sequelize.col('RecSeqNo')), 'RecSeqNo']],
                where: {
                    BalanceID: dataObj.instrumentId,
                    Side: FriabilityDetail1.data.Side
                }
            })
            let recNo = resSelectFri[0].RecSeqNo + 1


            let removeTimeForMenuDisable = productDetail.productDetail[0][0].Param8_T1Neg / productDetail.productDetail[0][0].Param8_T1Pos;
            var addTime = this.AddMinutesToDate(new moment(), removeTimeForMenuDisable);
            var dateFormat = addTime.split(' ');
            // dateFormat = dateFormat[1];
            var dateFormat1 = dateFormat[1];
            // var dateFormat1 = this.DateFormat(addTime);
            // console.log(dateFormat);



            //before

            if (FriabilityDetail1.data.Rotary == 'Double') {

                if ((tempCounterObj.counter == 0 || tempCounterObj.counter == 1) && (tempCounterObjAfter.counter == 0)) {
                    //send wt  before for both side

                    if (tempCounterObj.counter == 0) {
                        // Weighment Started for side LHS
                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            batch: batchNo,
                            activity: `Friability Weighment Started on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'started');

                        /**
                         * Differntiated logon to insert according to double and single
                         */

                        //master entry 
                        const checkEntry = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            ],
                            where: {
                                ProductName: CurrentCubicalObj.Sys_ProductName,
                                // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                                BatchNo: CurrentCubicalObj.Sys_Batch,
                                PVersion: CurrentCubicalObj.Sys_PVersion,
                                Version: CurrentCubicalObj.Sys_Version,
                                BFGCode: CurrentCubicalObj.Sys_BFGCode,
                                CubicleType: CurrentCubicalObj.Sys_CubType,
                                ReportType: CurrentCubicalObj.Sys_RptType,
                                Side: FriabilityDetail1.data.Side

                            },
                            raw: true
                        });

                        if (checkEntry[0].lastInsertedID == null) {
                            lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                        }
                        if (checkEntry[0].lastInsertedID != null) {

                            lstInsertId = checkEntry[0]

                        }
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.idsNo;
                        // } else {
                        //     strHmi = strHmi;
                        // }

                        //detailEntry
                        await models.tbl_tab_detail8.create({
                            RepSerNo: lstInsertId.masterRepSerNo,
                            MstSerNo: lstInsertId.lastInsertedID,
                            RecSeqNo: recNo,
                            InitialWt: receiveWt,
                            FinalWt: '0',
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: FriabilityDetail1.data.Side,
                            DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            IdsNo: strHmi
                        })
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.selectedIds.Idsno;
                        // } else {
                        //     strHmi = strHmi;
                        // }
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');
                        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        var SelectedIdsNo
                        if (IPQCObject != undefined) {
                            SelectedIdsNo = IPQCObject.selectedIds.Idsno;
                        } else {
                            SelectedIdsNo = strHmi;
                        }
                        const obj = {
                            'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                            // 'WeighmentType': 8,
                            'WeighmentName': 'FRIAB',
                            'Userid': tempUserObject.UserId,
                            'ReportType': hmiDetailsInPMenu.Sys_RptType,
                            // 'RotartyType': hmiDetailsInPMenu.Sys_RotaryType,
                            'Sys_CubType': 1,
                            'Sys_Batch': batchNo,
                            'Sys_BFGCode': hmiDetailsInPMenu.Sys_BFGCode,
                            'Before_Count': 1,
                            'After_Count': 0,
                            "Idsno": strHmi,
                            // 'Time': dateFormat, comp: 'eq',
                            'Incomp_RepSerNo': lstInsertId.masterRepSerNo,
                            'RecSampleNo': 1,
                            'SeqNo': 0,
                            SelectedIds: SelectedIdsNo
                        }


                        if (FriabilityDetail1.data.Rotary == "Single") {
                            Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)
                        }
                        // await database.save(saveFriabilityPowerBackup)
                        if (FriabilityDetail1.data.Rotary == "Double" && powerbacc == undefined) {
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)

                        } else {
                            //update
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            if (FriabilityDetail1.data.Rotary == "Double" && powerbacc.Before_Count == 1) {
                                await models.tbl_powerbackup.update({
                                    Side_RepSerNo: lstInsertId.masterRepSerNo,
                                    EntryTimeStamp: addTime
                                }, {
                                    where: {
                                        // CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                        WeighmentName: 'FRIAB',
                                        SelectedIds: SelectstrHmi,
                                        Sys_CubType: 1,
                                        IdsNo: strHmi
                                        // TableType : "NULL"
                                    }
                                })
                            }
                        }
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${receiveWt + " " + unit}`);

                        //monit


                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )} ${unit}`, srNo: "", message: 'InitialWeight'
                            }
                        });

                        if (FriabilityDetail1.data.Rotary == "Double") {
                            mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }
                    }


                    if (FriabilityDetail1.data.Rotary == "Double") {
                        tempCounterObj.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                        //left before wt drum 1 ka 
                    }
                    //  else if (FriabilityDetail1.data.Rotary == "Single") {
                    //     tempCounterObjAfter.counter += 1;
                    //     let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                    //     if (timeForMenuDisable == undefined) {
                    //         globalData.arrTimeForMenuDisable.push({
                    //             Hmi: strHmi,
                    //             idsNo: strIdsNo,
                    //             // timeForMenuHide: removeTimeForMenuDisable,
                    //             formatedTime: dateFormat1
                    //         })
                    //     } else {
                    //         // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                    //         timeForMenuDisable.timeForMenuHide = dateFormat1;

                    //     }
                    // }


                    /**
                     * For Double update in RWtBeforeTest column
                     */
                    if (tempCounterObj.counter == 2) {
                        // Weighment Started for side RHS
                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            batch: batchNo,
                            activity: `Friability Weighment Started on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);
                        //No RptType
                        // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE 'IdsNo' = '${strHmi}' AND 'BatchNo' = '${batchNo}') AND 'DataValue2' = 0`;
                        var checkEntry = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            ],
                            where: {
                                ProductName: CurrentCubicalObj.Sys_ProductName,
                                // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                                BatchNo: CurrentCubicalObj.Sys_Batch,
                                PVersion: CurrentCubicalObj.Sys_PVersion,
                                Version: CurrentCubicalObj.Sys_Version,
                                BFGCode: CurrentCubicalObj.Sys_BFGCode,
                                CubicleType: CurrentCubicalObj.Sys_CubType,
                                ReportType: CurrentCubicalObj.Sys_RptType,
                                Side: FriabilityDetail1.data.Side

                            },
                            raw: true
                        });

                        if (checkEntry[0].lastInsertedID == null) {
                            lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                        }
                        if (checkEntry[0].lastInsertedID != null) {

                            lstInsertId = checkEntry[0]

                        }
                        var checkEntry = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            ],
                            where: {
                                ProductName: CurrentCubicalObj.Sys_ProductName,
                                // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                                BatchNo: CurrentCubicalObj.Sys_Batch,
                                PVersion: CurrentCubicalObj.Sys_PVersion,
                                Version: CurrentCubicalObj.Sys_Version,
                                BFGCode: CurrentCubicalObj.Sys_BFGCode,
                                CubicleType: CurrentCubicalObj.Sys_CubType,
                                ReportType: CurrentCubicalObj.Sys_RptType,
                                Side: FriabilityDetail1.data.Side,

                            },
                            raw: true
                        });
                        checkEntry = checkEntry[0]
                        var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE BatchNo = '${batchNo}') AND FinalWt = '0' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}' `

                        var resBatch = await sequelize.query(sqlquery, {
                            type: QueryTypes.SELECT
                        });
                        //update WTAR2
                        // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE Side = '${FriabilityDetail1.data.Side}') AND UserID = '${FriabilityDetail1.data.userid}' AND UserName = '${FriabilityDetail1.data.userName}'  AND IdsNo = '${strHmi}' AND DataValue2 = 0`
                        sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`

                        resBatch = await sequelize.query(sqlquery, {
                            type: QueryTypes.SELECT
                        });
                        var result = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                            ],
                            where: {
                                // 'IdsNo': strHmi,
                                BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                ReportType: hmiDetailsInPMenu.Sys_RptType
                            },
                            raw: true
                        })

                        if (powerbacc != undefined) {
                            if (powerbacc.Before_Count == 1 && powerbacc.After_Count == 0) {
                                FriabilityDetail1.data.Side = 'RHS'
                            }
                        }

                        await models.tbl_tab_detail8.create({
                            RepSerNo: result[0].RepSerNo,
                            MstSerNo: result[0].SeqNo,
                            RecSeqNo: recNo,
                            InitialWt: receiveWt,
                            FinalWt: '0',
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: FriabilityDetail1.data.Side,
                            DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            IdsNo: strHmi
                        })
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                        await models.tbl_powerbackup.update({
                            Side_RepSerNo: result[0].RepSerNo,
                            RecSampleNo: tempCounterObj.counter,
                            Before_Count: tempCounterObj.counter,
                            EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                SelectedIds: SelectstrHmi,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        });

                        await models.tbl_powerbackup.update({
                            After_Count: 0,
                            // EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                IdsNo: strHmi,
                                WeighmentName: 'FRIAB'
                            }
                        });
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${receiveWt + " " + unit}`);

                        //monit

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )} ${unit}`, srNo: "", message: 'InitialWeight'
                            }
                        });


                        // if (autoTare) {
                        //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                        // }

                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }

                        // }

                    }
                    //FRIABILITY BEFORE SAMPLE COMPLETED, NOW WAIT FOR 

                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);


                    if (FriabilityDetail1.data.Rotary == "Single") {
                        // setTimeout(()=>{mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`)},1000);

                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    } else if (FriabilityDetail1.data.Rotary == "Double" && tempCounterObj.counter == 2) {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    }

                } else {

                    let now = new Date();
                    let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                    let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    // console.log(this.DateFormat(now, time));
                    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                    // if (IPQCObject != undefined) {
                    //     strHmi = IPQCObject.idsNo;
                    // } else {
                    //     strHmi = strHmi;
                    // }
                    if (powerbacc != undefined) {
                        if (powerbacc.Before_Count == 2 && powerbacc.After_Count == 1) {
                            FriabilityDetail1.data.Side = 'RHS'
                        }
                    }
                    //No RptType
                    var checkEntry = await models.tbl_tab_master8.findAll({
                        attributes: [
                            // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        ],
                        where: {
                            ProductName: CurrentCubicalObj.Sys_ProductName,
                            // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                            BatchNo: CurrentCubicalObj.Sys_Batch,
                            PVersion: CurrentCubicalObj.Sys_PVersion,
                            Version: CurrentCubicalObj.Sys_Version,
                            BFGCode: CurrentCubicalObj.Sys_BFGCode,
                            CubicleType: CurrentCubicalObj.Sys_CubType,
                            ReportType: CurrentCubicalObj.Sys_RptType,
                            Side: FriabilityDetail1.data.Side,

                        },
                        raw: true
                    });
                    checkEntry = checkEntry[0]
                    var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`
                    // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE Side = '${FriabilityDetail1.data.Side}') AND UserID = '${FriabilityDetail1.data.userid}' AND UserName = '${FriabilityDetail1.data.userName}'  AND IdsNo = '${strHmi}' AND DataValue2 = 0`
                    var resBatch = await sequelize.query(sqlquery, {
                        type: QueryTypes.SELECT
                    });
                    if (Date.parse(currentTime) >= Date.parse(initSampletime)) {
                        let __paramProductData = {
                            ProductId: __parameterFriability.objProductDetails.ProductId,
                            ProductName: __parameterFriability.objProductDetails.ProductName,
                            ProductVersion: __parameterFriability.objProductDetails.ProductVersion,
                            Version: __parameterFriability.objProductDetails.Version,
                            Batch: __parameterFriability.Batch,
                            uniqueSerialNumber: __parameterFriability.strHmi
                        }

                        if (FriabilityDetail1.data.Rotary == "Single") {
                            tempCounterObjAfter.counter = 0;
                        }


                        //after enable menu 
                        //clear this array tempCounterObj.counter
                        if (tempCounterObjAfter.counter == 0) {
                            // lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                            var result = await this.checkProductData(__paramProductData, __parameterFriability.strHmi);
                            // const selectData = {
                            //     str_tableName: 'tbl_tab_friability',
                            //     data: '*',
                            //     condition: [
                            //         { str_colName: 'MstSerNo', value: result[0][0].SeqNo }
                            //     ]
                            // }
                            // let resSelectFri = await database.select(selectData);
                            let resSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    RecSeqNo: resBatch[0].RecSeqNo
                                }
                            })
                            resSelectFri = resSelectFri[0];




                            //powerbackup

                            var updateData;
                            if (FriabilityDetail1.data.Rotary == "Single") {

                                await models.tbl_tab_detail8.update({
                                    'FinalWt': receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        RecNo: resBatch[0].RecNo,
                                        'MstSerNo': result[0].SeqNo,
                                        "RepSerNo": result[0].RepSerNo,
                                        IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                    }
                                });


                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');
                                var NMT = __parameterFriability.productType.nominal
                                var drum1 = NWtBeforeTest
                                var remark1

                                // if (Number(NMT) >= Number(drum1)) {
                                //     remark1 = 'Complies'
                                // } else {
                                //     remark1 = 'Not Complies'
                                // }
                                if (((drum1).includes('-'))) {
                                    // remark1 = 'Within Limit'
                                    drum1 = '0.00'
                                }
                                if (Number(NMT) >= Number(drum1)) {
                                    remark1 = 'Within Limit'
                                } else {
                                    remark1 = 'Out of Limit'
                                }


                                await models.tbl_tab_detail8.update({
                                    // FriabVal: NWtBeforeTest,
                                    FriabVal: drum1,
                                    Remark: remark1
                                }, {
                                    where: {
                                        RecNo: resBatch[0].RecNo,
                                        RepSerNo: resBatch[0].RepSerNo,
                                    }
                                });
                            } else {


                                if (FriabilityDetail1.data.Side == resBatch[0].Side) {
                                    await models.tbl_tab_detail8.update({
                                        FinalWt: receiveWt,
                                        PrEndTime: moment().format('HH:mm:ss'),
                                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                    }, {
                                        where: {
                                            RecNo: resBatch[0].RecNo,
                                            RepSerNo: resBatch[0].RepSerNo,
                                            Side: resBatch[0].Side,
                                            IdsNo: strHmi,
                                        }
                                    });
                                }


                            }

                            // uppdate according to double rotary
                            let respSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    RecSeqNo: resBatch[0].RecSeqNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                    IdsNo: strHmi
                                }
                            })
                            respSelectFri = respSelectFri[0];


                            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                            // if (IPQCObject != undefined) {
                            //     strHmi = IPQCObject.selectedIds.Idsno;
                            // } else {
                            //     strHmi = strHmi;
                            // }



                            //powerbackup

                            await models.tbl_powerbackup.update({
                                After_Count: 1
                            }, {
                                where: {
                                    'CubicalNo': powerbacc.CubicalNo,
                                    SelectedIds: SelectstrHmi,
                                    WeighmentName: 'FRIAB',
                                    IdsNo: strHmi

                                }
                            })


                            if (FriabilityDetail1.data.Rotary == "Single") {

                                let NWtBeforeTest = (((respSelectFri.InitialWt - respSelectFri.FinalWt) / respSelectFri.InitialWt) * 100).toFixed(2);
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.side,
                                    InstrumentID: hmiDetailsInPMenu.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWtBeforeTest,
                                    lwtBeforeTest: respSelectFri.InitialWt,
                                    lwtAfterTest: respSelectFri.FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: productDetail.productDetail[0][0].Param8_Nom,
                                    PrTime: date.format(new Date(), 'HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD')
                                }

                            }

                            var NMT = __parameterFriability.productType.nominal
                            var NWBeforeTest = mathj.round((((respSelectFri.InitialWt - receiveWt) / respSelectFri.InitialWt) * 100), dp).toFixed(dp); //dec set to 3 as per requirement (mail 09-07-24)
                            var drum1 = NWBeforeTest
                            var remark1

                            // if (Number(NMT) >= Number(drum1)) {
                            //     remark1 = 'Complies'
                            // } else {
                            //     remark1 = 'Not Complies'
                            // }
                            if (((drum1).includes('-'))) {
                                // remark1 = 'Within Limit'
                                drum1 = '0.00'
                            }
                            if (Number(NMT) >= Number(drum1)) {
                                remark1 = 'Within Limit'
                            } else {
                                remark1 = 'Out of Limit'
                            }

                            await models.tbl_tab_detail8.update({
                                // FriabVal: NWBeforeTest,
                                FriabVal: drum1,
                                Remark: remark1
                            }, {
                                where: {
                                    RecNo: resBatch[0].RecNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                }
                            });
                            if (FriabilityDetail1.data.Rotary == "Double") {

                                // let NWtBeforeTest = ((((respSelectFri.InitialWt - respSelectFri.FinalWt)/ respSelectFri.InitialWt) * 100) ).toFixed(5);
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: hmiDetailsInPMenu.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWBeforeTest,
                                    lwtBeforeTest: respSelectFri.InitialWt,
                                    lwtAfterTest: respSelectFri.FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    // LHSflag: 0,
                                    // RHSflag: 0,
                                    Nom: productDetail.productDetail[0][0].Param8_Nom,
                                    PrTime: date.format(new Date(), 'HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD')
                                }
                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);

                            }
                            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                            let autoTare = hmiEntryinConfig[0].AutoTare;
                            let tareCommand = hmiEntryinConfig[0].Tare_Command
                            if (FriabilityDetail1.data.Rotary == "Single") {
                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo);
                                let nwtD1 = (((resSelectFri.InitialWt - receiveWt) / resSelectFri.InitialWt) * 100).toFixed(5);
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);

                                //monit

                                await objMonit.monit({
                                    case: 'TestWeight', Hmi: strHmi, data: {
                                        Weight: `${Number(
                                            receiveWt
                                        )} ${unit}`, srNo: "", message: 'FinalWeight'
                                    }
                                });

                                if (autoTare) {
                                    mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                }
                            } else {

                                let respSelect = await models.tbl_tab_detail8.findAll({
                                    where: {
                                        RecNo: resBatch[0].RecNo
                                    }
                                })
                                respSelect = respSelect[0];
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${respSelect.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                //monit


                                await objMonit.monit({
                                    case: 'TestWeight', Hmi: strHmi, data: {
                                        Weight: `${Number(
                                            receiveWt
                                        )} ${unit}`, srNo: "", message: 'FinalWeight'
                                    }
                                });

                            }
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAL1:${receiveWt + " " + unit}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }
                            if (FriabilityDetail1.data.Rotary == "Double") {
                                mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);

                            }
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }

                        if (FriabilityDetail1.data.Rotary == "Double") {
                            tempCounterObjAfter.counter += 1;
                        }



                        if (tempCounterObjAfter.counter == 2) {
                            //update WTAR2
                            var result = await this.checkProductData(__paramProductData, strHmi);

                            let resSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    // MstSerNo: result[0].SeqNo,
                                    RecNo: resBatch[0].RecNo,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri;

                            let nwtAfterTest;
                            let nwtBeforeTest;
                            resSelectFri = resSelectFri.pop()
                            nwtBeforeTest = mathj.round((((resSelectFri.InitialWt - resSelectFri.FinalWt) / resSelectFri.InitialWt) * 100), 2).toFixed(2);
                            nwtAfterTest = mathj.round((((resSelectFri.InitialWt - receiveWt) / resSelectFri.InitialWt) * 100), 3).toFixed(3); //dec set to 3 as per requirement (mail 09-07-24)
                            if (result) {
                                //update WTAR2
                                var result = await models.tbl_tab_detail8.findAll({
                                    attributes: [
                                        [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                        [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                        [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                                    ],
                                    where: {
                                        'RepSerNo': result[0].RepSerNo,
                                        'Side': FriabilityDetail1.data.Side,
                                        IdsNo: strHmi
                                    },
                                    raw: true
                                })
                                const updateData = await models.tbl_tab_detail8.update({

                                    FinalWt: receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        // 'RecNo': result[0].RecNo,
                                        'RecNo': resBatch[0].RecNo,
                                        IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber
                                        // NWtAfterTest: nwtAfterTest
                                    }
                                });
                                //  result = await models.tbl_tab_detail8.findAll({
                                //     where: {
                                //         'RepSerNo': result[0].RepSerNo,
                                //         'Side': FriabilityDetail1.data.Side,
                                //         IdsNo: strHmi
                                //     },
                                //     raw: true
                                // })
                                var NMT = __parameterFriability.productType.nominal
                                var drum1 = nwtAfterTest
                                var remark1

                                // if (Number(NMT) >= Number(drum1)) {
                                //     remark1 = 'Complies'
                                // } else {
                                //     remark1 = 'Not Complies'
                                // }

                                if (((drum1).includes('-'))) {
                                    // remark1 = 'Within Limit'
                                    drum1 = '0.00'
                                }
                                if (Number(NMT) >= Number(drum1)) {
                                    remark1 = 'Within Limit'
                                } else {
                                    remark1 = 'Out of Limit'
                                }


                                await models.tbl_tab_detail8.update({
                                    'FriabVal': drum1,
                                    Remark: remark1
                                }, {
                                    where: {
                                        RecNo: resBatch[0].RecNo,
                                        RepSerNo: resBatch[0].RepSerNo,
                                    }
                                });
                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                // await objInstrumentUsage.InstrumentUsage('Balance',
                                //     strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                                //power backup
                                const updateDataPower = await models.tbl_powerbackup.update({
                                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                                    'WeightmentType': 8,
                                    'RepSerno': result[0].RepSerNo
                                }, {
                                    where: {
                                        After_Count: tempCounterObjAfter.counter,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }

                                })

                                // await database.update(updateDataPower);
                                let batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: hmiDetailsInPMenu.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,

                                    nwtBeforeTest: nwtAfterTest,
                                    nwtAfterTest: nwtAfterTest,
                                    lwtBeforeTest: resSelectFri.InitialWt,
                                    lwtAfterTest: receiveWt,
                                    rwtBeforeTest: resSelectFri.InitialWt,
                                    rwtAfterTest: receiveWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    // LHSflag: 1,
                                    // RHSflag: 1,
                                    Nom: productDetail.productDetail[0][0].Param8_Nom,
                                    PrTime: date.format(now, 'HH:mm:ss'),
                                    PrDate: date.format(now, 'YYYY-MM-DD')
                                }




                                await objBatchSummary.saveBatchSummaryFriability1(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);
                                await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, 'tbl_tab_master8');

                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });
                                if (hmiDetailsInPMenu.Sys_RotaryType == 'Double') {
                                    if (Side.length == 1) {
                                        if (Side[0] == 'LHS') {
                                            Side = 'RHS'
                                        } else {
                                            Side = 'LHS'
                                        }
                                        //    if(Number(sample) == Number(tempCounterObj.counter)){
                                        mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}:${tempSide}`);
                                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                                        let autoTare = hmiEntryinConfig[0].AutoTare;
                                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                                        if (autoTare) {
                                            mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                        }

                                        //    } 
                                    } else {
                                        // Weighment Completed for side RHS
                                        Object.assign(objActivity,
                                            { strUserId: tempUserObject.UserId },
                                            { strUserName: tempUserObject.UserName },
                                            { batch: hmiDetailsInPMenu.Sys_Batch },
                                            { activity: `Friability Weighment Completed on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}` }) //For Side ${FriabilityDetail1.data.Side}` });

                                        await objActivityLog.ActivityLogEntry(objActivity);
                                        await objInstrumentUsage.InstrumentUsage('Balance',
                                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');
                                        // await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'completed');

                                        const objUpdateValidation = await models.tbl_cubical.update({
                                            'Sys_Validation': 0
                                        }, {
                                            where: {
                                                'Sys_IDSNo': CurrentCubicalObj.Sys_IDSNo
                                            }

                                        });
                                        let respSelect = await models.tbl_tab_detail8.findAll({
                                            where: {
                                                RecNo: resBatch[0].RecNo
                                            }
                                        })
                                        respSelect = respSelect[0];
                                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${respSelect.InitialWt} ${unit};WTAR2:${receiveWt + " " + unit};NWTD2:${receiveWt} ${unit}`);

                                        //monit


                                        await objMonit.monit({
                                            case: 'TestWeight', Hmi: strHmi, data: {
                                                Weight: `${Number(
                                                    receiveWt
                                                )} ${unit}`, srNo: "", message: 'FinalWeight'
                                            }
                                        });
                                        //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAR2:${receiveWt + " " + unit}`);

                                        globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentProductData :
                                            globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrProductTypeArray :
                                            globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterForFriab :
                                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                        //test splice if rotarty is not double
                                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrSelectedMenu :
                                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterAfter :
                                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi), 1);
                                        globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.DoubSideForFriab : globalData.DoubSideForFriab.splice(globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);

                                        // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`);
                                    }

                                    return

                                }
                            }


                        }
                        tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
                        // Weighment Completed for side LHS
                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { batch: hmiDetailsInPMenu.Sys_Batch },
                            { activity: `Friability Weighment Completed on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}` });

                        await objActivityLog.ActivityLogEntry(objActivity);
                        if (tempCounterObjAfter != undefined) {
                            if (tempCounterObjAfter.counter == 0 || FriabilityDetail1.data.Rotary == "Single") {
                                //batch summary 


                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });

                                let updateFriability = await models.tbl_tab_master8.update({
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    PrEndTime: date.format(new Date(), 'HH:mm:ss')
                                }, {
                                    where: {
                                        RepSerNo: result[0].RepSerNo
                                    }
                                })


                                Object.assign(objActivity,
                                    { strUserId: tempUserObject.UserId },
                                    { strUserName: tempUserObject.UserName },
                                    { batch: hmiDetailsInPMenu.Sys_Batch },
                                    { activity: `Friability Weighment Completed on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}` });

                                await objActivityLog.ActivityLogEntry(objActivity);

                                await objInstrumentUsage.InstrumentUsage('Balance', strHmi, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentProductData :
                                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrProductTypeArray :
                                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentCounterForFriab :
                                    globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                //test splice if rotarty is not double
                                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrSelectedMenu :
                                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                                //monit
                                await objMonit.monit({
                                    case: 'ReportStatus', Hmi: strHmi, data: {
                                        message: 'Friability Test Completed'
                                    }
                                });

                            }
                        }


                    } else {

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }




                }
            } else {

                if ((tempCounterObj.counter == 0) && (tempCounterObjAfter.counter == 0)) {
                    //send wt  before for both side

                    if (tempCounterObj.counter == 0) {

                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            batch: CurrentCubicalObj.Sys_Batch,
                            activity: `Friability Weighment Started on TSH ${strHmi}`  //For Side ${FriabilityDetail1.data.Side}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'started');

                        /**
                         * Differntiated logon to insert according to double and single
                         */

                        //master entry 
                        const checkEntry = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            ],
                            where: {
                                ProductName: CurrentCubicalObj.Sys_ProductName,
                                // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                                BatchNo: CurrentCubicalObj.Sys_Batch,
                                PVersion: CurrentCubicalObj.Sys_PVersion,
                                Version: CurrentCubicalObj.Sys_Version,
                                BFGCode: CurrentCubicalObj.Sys_BFGCode,
                                CubicleType: CurrentCubicalObj.Sys_CubType,
                                ReportType: CurrentCubicalObj.Sys_RptType,
                                Side: FriabilityDetail1.data.Side,
                            },
                            raw: true
                        });

                        if (checkEntry[0].lastInsertedID == null) {
                            lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                        }
                        if (checkEntry[0].lastInsertedID != null) {

                            lstInsertId = checkEntry[0]

                        }
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.idsNo;
                        // } else {
                        //     strHmi = strHmi;
                        // }

                        //detailEntry
                        await models.tbl_tab_detail8.create({
                            RepSerNo: lstInsertId.masterRepSerNo,
                            MstSerNo: lstInsertId.lastInsertedID,
                            RecSeqNo: 1,
                            InitialWt: receiveWt,
                            FinalWt: '0',
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: FriabilityDetail1.data.Side,
                            DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            IdsNo: strHmi
                        })
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.selectedIds.Idsno;
                        // } else {
                        //     strHmi = strHmi;
                        // }
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        var SelectedIdsNo
                        if (IPQCObject != undefined) {
                            SelectedIdsNo = IPQCObject.selectedIds.Idsno;
                        } else {
                            SelectedIdsNo = strHmi;
                        }
                        const obj = {
                            'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                            // 'WeighmentType': 8,
                            'WeighmentName': 'FRIAB',
                            'Userid': tempUserObject.UserId,
                            'ReportType': hmiDetailsInPMenu.Sys_RptType,
                            // 'RotartyType': hmiDetailsInPMenu.Sys_RotaryType,
                            'Sys_CubType': 1,
                            'Sys_Batch': batchNo,
                            'Sys_BFGCode': hmiDetailsInPMenu.Sys_BFGCode,
                            'Before_Count': 1,
                            'After_Count': 0,
                            "Idsno": strHmi,
                            // 'Time': dateFormat, comp: 'eq',
                            'Incomp_RepSerNo': lstInsertId.masterRepSerNo,
                            'RecSampleNo': 1,
                            'SeqNo': 0,
                            SelectedIds: SelectedIdsNo
                        }


                        if (FriabilityDetail1.data.Rotary == "Single") {
                            Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)
                        }
                        // await database.save(saveFriabilityPowerBackup)
                        if (FriabilityDetail1.data.Rotary == "Double" && powerbacc == undefined) {
                            await models.tbl_powerbackup.create(obj)

                        } else {
                            //update
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            if (FriabilityDetail1.data.Rotary == "Double" && powerbacc.Before_Count == 1) {
                                await models.tbl_powerbackup.update({
                                    EntryTimeStamp: addTime
                                }, {
                                    where: {
                                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                })
                            }
                        }
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${receiveWt + " " + unit}`);
                        if (FriabilityDetail1.data.Rotary == "Double") {
                            mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }
                    }


                    if (FriabilityDetail1.data.Rotary == "Double") {
                        tempCounterObj.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                        //left before wt drum 1 ka 
                    } else if (FriabilityDetail1.data.Rotary == "Single") {
                        tempCounterObjAfter.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                    }


                    /**
                     * For Double update in RWtBeforeTest column
                     */
                    if (tempCounterObj.counter == 2) {
                        //update WTAR2
                        //No RptType
                        var result = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                            ],
                            where: {
                                'Idsno': strHmi,
                            },
                            raw: true
                        })

                        await models.tbl_tab_detail8.create({
                            RepSerNo: result[0].RepSerNo,
                            MstSerNo: result[0].SeqNo,
                            RecSeqNo: 2,
                            InitialWt: receiveWt,
                            FinalWt: '0',
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: FriabilityDetail1.data.Side,
                            DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            IdsNo: strHmi
                        })
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');


                        //power backup


                        await models.tbl_powerbackup.update({
                            RecSampleNo: tempCounterObj.counter,
                            Before_Count: tempCounterObj.counter,
                            EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        })

                        await models.tbl_powerbackup.update({
                            After_Count: 0,
                            // EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        })





                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);

                        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${receiveWt + " " + unit}`);

                        //monit


                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )} ${unit}`, srNo: "", message: 'FinalWeight'
                            }
                        });

                        // if (autoTare) {
                        //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                        // }

                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }

                        // }

                    }
                    //FRIABILITY BEFORE SAMPLE COMPLETED, NOW WAIT FOR 

                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);


                    if (FriabilityDetail1.data.Rotary == "Single") {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    } else if (FriabilityDetail1.data.Rotary == "Double" && tempCounterObj.counter == 2) {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    }

                } else {

                    let now = new Date();
                    let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                    let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                    // if (IPQCObject != undefined) {
                    //     strHmi = IPQCObject.idsNo;
                    // } else {
                    //     strHmi = strHmi;
                    // }
                    // console.log(this.DateFormat(now, time));
                    //No RptType
                    var checkEntry = await models.tbl_tab_master8.findAll({
                        attributes: [
                            // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        ],
                        where: {
                            ProductName: CurrentCubicalObj.Sys_ProductName,
                            // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                            BatchNo: CurrentCubicalObj.Sys_Batch,
                            PVersion: CurrentCubicalObj.Sys_PVersion,
                            Version: CurrentCubicalObj.Sys_Version,
                            BFGCode: CurrentCubicalObj.Sys_BFGCode,
                            CubicleType: CurrentCubicalObj.Sys_CubType,
                            ReportType: CurrentCubicalObj.Sys_RptType,
                            Side: FriabilityDetail1.data.Side,

                        },
                        raw: true
                    });
                    checkEntry = checkEntry[0]
                    var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE BatchNo = '${batchNo}') AND FinalWt = '0' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}'`
                    sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`

                    var resBatch = await sequelize.query(sqlquery, {
                        type: QueryTypes.SELECT
                    });
                    if (Date.parse(currentTime) >= Date.parse(initSampletime)) {
                        let __paramProductData = {
                            ProductId: __parameterFriability.objProductDetails.ProductId,
                            ProductName: __parameterFriability.objProductDetails.ProductName,
                            ProductVersion: __parameterFriability.objProductDetails.ProductVersion,
                            Version: __parameterFriability.objProductDetails.Version,
                            Batch: __parameterFriability.Batch,
                            uniqueSerialNumber: __parameterFriability.strHmi
                        }

                        if (FriabilityDetail1.data.Rotary == "Single") {
                            tempCounterObjAfter.counter = 0;
                        }


                        //after enable menu 
                        //clear this array tempCounterObj.counter
                        if (tempCounterObjAfter.counter == 0) {
                            // lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                            var result = await this.checkProductData(__paramProductData, __parameterFriability.strHmi);

                            let resSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    MstSerNo: resBatch[0].RecSeqNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                    'Side': FriabilityDetail1.data.Side,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri[0];




                            //powerbackup

                            var updateData;
                            if (FriabilityDetail1.data.Rotary == "Single") {

                                await models.tbl_tab_detail8.update({
                                    'FinalWt': receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        RecNo: resBatch[0].RecNo,
                                        RepSerNo: resBatch[0].RepSerNo,
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo':SelectstrHmi
                                    }
                                })

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                            } else {


                                await models.tbl_tab_detail8.update({
                                    'FinalWt': receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        'MstSerNo': result[0].SeqNo,
                                        'RecSeqNo': recNo,
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                    }
                                })
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                            }

                            // uppdate according to double rotary
                            let respSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    RecNo: resBatch[0].RecNo,
                                }
                            })
                            respSelectFri = respSelectFri[0];






                            //powerbackup

                            await models.tbl_powerbackup.update({
                                After_Count: 1
                            }, {
                                where: {
                                    'CubicalNo': powerbacc.CubicalNo,
                                    WeighmentName: 'FRIAB',
                                    IdsNo: strHmi
                                }
                            })



                            if (FriabilityDetail1.data.Rotary == "Single") {

                                var NWtBeforeTest = mathj.round((((respSelectFri.InitialWt - respSelectFri.FinalWt) / respSelectFri.InitialWt) * 100), 3).toFixed(3); //dec point to 3 as per requirement (mail 09-07-24)
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: hmiDetailsInPMenu.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWtBeforeTest,
                                    lwtBeforeTest: respSelectFri.InitialWt,
                                    lwtAfterTest: respSelectFri.FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: productDetail.productDetail[0][0].Param8_Nom,
                                    PrTime: date.format(new Date(), 'HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD')
                                }

                            }
                            await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo);
                            var NMT = __parameterFriability.productType.nominal
                            var drum1 = NWtBeforeTest
                            var remark1
                            if (((drum1).includes('-'))) {
                                // remark1 = 'Within Limit'
                                drum1 = '0.00'
                            }
                            if (Number(NMT) >= Number(drum1)) {
                                remark1 = 'Within Limit'
                            } else {
                                remark1 = 'Out of Limit'
                            }


                            await models.tbl_tab_detail8.update({
                                // 'FriabVal': NWtBeforeTest,
                                FriabVal: drum1,
                                Remark: remark1
                            }, {
                                where: {
                                    RecNo: resBatch[0].RecNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                    // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                    // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                    // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                    // 'Version': __parameterFriability.objProductDetails.Version,
                                    // 'BatchNo': __parameterFriability.Batch,
                                    // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                }
                            });
                            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                            let autoTare = hmiEntryinConfig[0].AutoTare;
                            let tareCommand = hmiEntryinConfig[0].Tare_Command
                            if (FriabilityDetail1.data.Rotary == "Single") {
                                // await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo);
                                let nwtD1 = (((respSelectFri.InitialWt - receiveWt) * 100) / respSelectFri.InitialWt).toFixed(5);
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resBatch[0].InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                if (autoTare) {
                                    mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                }
                            } else {
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${respSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);

                            }
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAL1:${receiveWt + " " + unit}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }
                            if (FriabilityDetail1.data.Rotary == "Double") {
                                mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);

                            }
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }

                        if (FriabilityDetail1.data.Rotary == "Double") {
                            tempCounterObjAfter.counter += 1;
                        }



                        if (tempCounterObjAfter.counter == 2) {
                            //update WTAR2
                            var result = await this.checkProductData(__paramProductData, strHmi);

                            let resSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    MstSerNo: result[0].SeqNo,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri;

                            let nwtAfterTest;
                            let nwtBeforeTest;
                            nwtBeforeTest = (((resSelectFri[0].InitialWt - resSelectFri[0].FinalWt) / resSelectFri[0].InitialWt) * 100).toFixed(2);
                            nwtAfterTest = (((resSelectFri[1].InitialWt - receiveWt) / resSelectFri[1].InitialWt) * 100).toFixed(2);
                            if (result) {
                                //update WTAR2
                                var result = await models.tbl_tab_detail8.findAll({
                                    attributes: [
                                        [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                        [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                        [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                                    ],
                                    where: {
                                        'RepSerNo': result[0].RepSerNo,
                                        IdsNo: strHmi,
                                        // 'Side' :FriabilityDetail1.data.Side
                                    },
                                    raw: true
                                })
                                const updateData = await models.tbl_tab_detail8.update({

                                    FinalWt: receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        'RecNo': result[0].RecNo,
                                        IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber
                                        // NWtAfterTest: nwtAfterTest
                                    }
                                })
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');





                                //power backup
                                const updateDataPower = await models.tbl_powerbackup.update({
                                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                                    'WeightmentType': 8,
                                    'RepSerno': result[0].RepSerNo
                                }, {
                                    where: {
                                        After_Count: tempCounterObjAfter.counter,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }

                                })

                                let batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.side,
                                    InstrumentID: hmiDetailsInPMenu.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,

                                    nwtBeforeTest: nwtBeforeTest,
                                    nwtAfterTest: nwtAfterTest,
                                    lwtBeforeTest: resSelectFri[0].InitialWt,
                                    lwtAfterTest: resSelectFri[0].FinalWt,
                                    rwtBeforeTest: resSelectFri[1].InitialWt,
                                    rwtAfterTest: resSelectFri[1].FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: productDetail.productDetail.Param8_Nom,
                                    PrTime: date.format(now, 'HH:mm:ss'),
                                    PrDate: date.format(now, 'YYYY-MM-DD')
                                }




                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);
                                await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, 'tbl_tab_master8');
                                const objUpdateValidation = await models.tbl_cubical.update({
                                    'Sys_Validation': 0
                                }, {
                                    where: {
                                        'Sys_IDSNo': CurrentCubicalObj.Sys_IDSNo
                                    }

                                });

                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });
                                if (hmiDetailsInPMenu.Sys_RotaryType == 'Double') {
                                    if (Side.length == 1) {
                                        if (Side[0] == 'LHS') {
                                            Side = 'RHS'
                                        } else {
                                            Side = 'LHS'
                                        }
                                        //    if(Number(sample) == Number(tempCounterObj.counter)){
                                        mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}:${tempSide}`);
                                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                                        let autoTare = hmiEntryinConfig[0].AutoTare;
                                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                                        if (autoTare) {
                                            mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                        }

                                        //    } 
                                    } else {
                                        Object.assign(objActivity,
                                            { strUserId: tempUserObject.UserId },
                                            { strUserName: tempUserObject.UserName },
                                            { batch: hmiDetailsInPMenu.Sys_Batch },
                                            { activity: `Friability Weighment Completed on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}` });

                                        await objActivityLog.ActivityLogEntry(objActivity);
                                        // await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'completed');

                                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                        //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAR2:${receiveWt + " " + unit}`);

                                        //monit

                                        //     if(globalData.monitDetail.length > 0){
                                        //         for(var i = 0; i<globalData.monitDetail.length; i++){
                                        //             await objMonit.monit({
                                        //                 case: 'TestWeight',
                                        //                 Hmi: strHmi,
                                        //                 data: {
                                        //                     Weight: globalData.monitDetail[i].DataValue,
                                        //                     srNo:i,
                                        //                     message: ""
                                        //                 } 
                                        //         })
                                        //     }
                                        //     globalData.monitDetail = []
                                        // }
                                        await objMonit.monit({
                                            case: 'TestWeight', Hmi: strHmi, data: {
                                                Weight: `${Number(
                                                    receiveWt
                                                )} ${unit}`, srNo: "", message: 'FinalWeight'
                                            }
                                        });

                                        globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentProductData :
                                            globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrProductTypeArray :
                                            globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterForFriab :
                                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                        //test splice if rotarty is not double
                                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrSelectedMenu :
                                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterAfter :
                                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi), 1);
                                        globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.DoubSideForFriab : globalData.DoubSideForFriab.splice(globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                                        // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`);
                                        //monit
                                        await objMonit.monit({
                                            case: 'ReportStatus', Hmi: strHmi, data: {
                                                message: 'Friability Test Completed'
                                            }
                                        });
                                    }

                                    return

                                }
                            }


                        }
                        tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
                        if (tempCounterObjAfter != undefined) {
                            if (tempCounterObjAfter.counter == 0 || FriabilityDetail1.data.Rotary == "Single") {
                                //batch summary 


                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.idsNo;
                                // } else {
                                //     strHmi = strHmi;
                                // }

                                let updateFriability = await models.tbl_tab_master8.update({
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    PrEndTime: date.format(new Date(), 'HH:mm:ss')
                                }, {
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                        IdsNo: strHmi
                                    }
                                })

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }


                                Object.assign(objActivity,
                                    { strUserId: tempUserObject.UserId },
                                    { strUserName: tempUserObject.UserName },
                                    { batch: hmiDetailsInPMenu.Sys_Batch },
                                    { activity: `Friability Weighment Completed on TSH ${strHmi}` }); // For Side ${FriabilityDetail1.data.Side}` });

                                await objActivityLog.ActivityLogEntry(objActivity);
                                await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                                const objUpdateValidation = await models.tbl_cubical.update({
                                    'Sys_Validation': 0
                                }, {
                                    where: {
                                        'Sys_IDSNo': CurrentCubicalObj.Sys_IDSNo
                                    }

                                });

                                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentProductData :
                                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrProductTypeArray :
                                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentCounterForFriab :
                                    globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                //test splice if rotarty is not double
                                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrSelectedMenu :
                                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                            }
                        }


                    } else {

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }




                }
            }



            //disable the menu after  send before wt 
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }


    async processBalanceFriabilityData2(dataObj) {
        try {
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let actualWt = dataObj.actualWt;
            let invalidUnitFlag = dataObj.invalidUnitFlag;
            let invalidWeightFlag = dataObj.invalidWeightFlag;
            let selectedMenuDetails = dataObj.SelectedMenuDetails
            let protocolPortNo = dataObj.ProtocolPortNo
            let T2Pos = selectedMenuDetails.selectedProductDetail.T2Pos
            let T2Neg = selectedMenuDetails.selectedProductDetail.T2Neg
            let unit = selectedMenuDetails.selectedProductDetail.unit ?? 'gm'
            let dp = selectedMenuDetails.selectedProductDetail.dp
            let FriabRotaryType = selectedMenuDetails.rotary;
            let nominal = selectedMenuDetails?.selectedProductDetail?.Nominal ?? 0;
            let rpm = selectedMenuDetails?.selectedProductDetail?.RPM ?? 4;
            let cubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp).cubicalData
            let getTableName = objCommonWeightment.getTableName(cubicInfo, 'Friability', strDsNo, strTabIp)
            let masterTable = cubicInfo.Sys_RptType != undefined ? getTableName.masterTableIncomplete : getTableName.masterTable;

            // Nominal ki condition handle karni hai

            // if(invalidUnitFlag){
            //     return mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Invalid Unit Recieved`)
            // }

            let repSerNo;



            // this db call for checking ipqc

            let ipcCubicData = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: strDsNo
                }
            })

            // if ipqc then cubical details changes
            let cubicleName = cubicInfo.Sys_CubicName
            let cubicleNo = cubicInfo.Sys_CubicNo
            let cubType = cubicInfo.Sys_CubType

            if (cubicInfo.Sys_CubicNo != ipcCubicData.Sys_CubicNo || cubicInfo.Sys_CubType != ipcCubicData.Sys_CubType) {
                cubicleName = ipcCubicData.Sys_CubicName
                cubicleNo = ipcCubicData.Sys_CubicNo
                cubType = ipcCubicData.Sys_CubType
            }

            let userInfo = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)

            let objMstFinder = {
                tableName: masterTable,
                ProductName: cubicInfo.Sys_ProductName,
                Batch: cubicInfo.Sys_Batch,
                PVersion: cubicInfo.Sys_PVersion,
                Version: cubicInfo.Sys_Version,
                BFGCode: cubicInfo.Sys_BFGCode,
                CubType: cubType,
                RptType: cubicInfo.Sys_RptType,
                MPN: cubicInfo.Sys_MPNCode
            }

            let sideNo = FriabRotaryType == 'Double' ? 1 : 0;

            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let removeTimeForMenuDisable = T2Neg / T2Pos;
            var addTime = this.AddMinutesToDate(new moment(), removeTimeForMenuDisable);
            var dateFormat = addTime.split(' ');
            var dateFormat1 = dateFormat[1];

            let whereObj = {};

            let InitialWt = 'InitialWt';
            let FinalWt = 'FinalWt';
            let FriabVal = 'FriabVal';
            if (cubicInfo.Sys_RptType) {
                InitialWt = 'BeforeValue';
                FinalWt = 'AfterValue';
                FriabVal = 'NetValue'

                let menuSequence = await models.tbl_menu_sequence.findAll({

                    where: {

                        TabIp: strTabIp,
                        DS_Number: strDsNo,
                    }
                })

                repSerNo = menuSequence.length > 0 ? menuSequence[0].RepSerNo : null

                let mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicInfo, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })
                if (repSerNo == 0) {
                    let mstEntry = await models[masterTable].create({
                        MstSerNo: mastSerNo,
                        CubicalNo: cubicInfo.Sys_CubicNo,
                        CubicleName: cubicInfo.Sys_CubicName,
                        CubicleType: cubicInfo.Sys_CubType,
                        MPN_Code: cubicInfo.Sys_MPNCode,
                        SFOID: selectedMenuDetails.SFOID,
                        ProductType: 1,
                        Area: cubicInfo.Sys_Area,
                        MachineCode: selectedMenuDetails?.EquipmentCode ?? null,
                        PVersion: cubicInfo.Sys_PVersion,
                        Version: cubicInfo.Sys_Version,
                        BatchNo: cubicInfo.Sys_Batch,
                        BFGCode: cubicInfo.Sys_BFGCode,
                        // Param7_T2NegTol: hardnessneg2,
                        // Param7_T2PosTol: hardnesspos2,
                        // Param3_T2PosTol: thicknespos2,
                        // Param3_T2NegTol: thicknesneg2,
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        ProductName: cubicInfo.Sys_ProductName,
                        UserId: userInfo.UserId,
                        UserName: userInfo.UserName,
                        Idsno: cubicInfo.Sys_DSNumber,
                        BalanceId: cubicInfo.Sys_BalID,
                        VernierId: cubicInfo.Sys_VernierID,
                        FriabilityID: cubicInfo.Sys_FriabID,
                        HardnessID: cubicInfo.Sys_HardID,
                        DTID: cubicInfo.Sys_DTID,
                        Qty: selectedMenuDetails.individualsamplecount,
                        GrpQty: selectedMenuDetails.groupQty,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                        Param8_PrTime: moment().format('HH:mm:ss'),
                        Param8_PrDate: moment().format('YYYY-MM-DD'),
                        Param8_Nom: nominal,
                        Param8_DecimalPoint: dp,
                        Param8_T1Pos: rpm,
                        Param8_Unit: unit,
                        Repetition: cubicInfo.Sys_Repetition,
                        ReportType: cubicInfo.Sys_RptType,
                        NoOfStations: equipmentData.Machine_Punches,
                        Side: cubicInfo.Sys_RotaryType,
                        LHSContainerNo: selectedMenuDetails.LHSContainerNo,
                        RHSContainerNo: selectedMenuDetails.RHSContainerNo,
                        MesTestType: cubicInfo.MesTestType,
                        MesSide: cubicInfo.MesSide,
                    })


                    await models.tbl_menu_sequence.update({
                        RepSerNo: mstEntry.RepSerNo
                    }, {
                        where: {
                            DS_Number: strDsNo,
                            TabIp: strTabIp
                        }
                    })


                    repSerNo = mstEntry.RepSerNo


                }

                Object.assign(whereObj, { RepSerNo: repSerNo })
            } else {
                Object.assign(whereObj, {
                    ProductName: cubicInfo.Sys_ProductName,
                    BatchNo: cubicInfo.Sys_Batch,
                    PVersion: cubicInfo.Sys_PVersion,
                    Version: cubicInfo.Sys_Version,
                    // BFGCode: cubicInfo.Sys_BFGCode,
                    MPN_Code: cubicInfo.Sys_MPNCode,
                    CubicleType: cubType,
                    ReportType: cubicInfo.Sys_RptType,
                    Side: FriabRotaryType
                })

            }

            // if(repSerNo == 0){

            // }

            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: cubicleNo,
                    Sys_Batch: cubicInfo.Sys_Batch,
                    WeighmentName: 'FRIAB',
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    Side_RepSerNo: sideNo,
                    MPN_Code: cubicInfo.Sys_MPNCode
                }
            })

            powerbacc = powerbacc.pop();


            if (powerbacc != undefined) {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.Before_Count,
                        'FriabSide': sideNo
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.After_Count,
                        'FriabSide': sideNo
                    })
                }
            } else {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }
            }

            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.DsNo == strDsNo).configSetting;
            let autoTare = hmiEntryinConfig[0].AutoTare;
            let tareCommand = hmiEntryinConfig[0].Tare_Command




            if (FriabRotaryType == 'Double') {


                if ((tempCounterObj.counter == 0 || tempCounterObj.counter == 1) && tempCounterObjAfter.counter == 0) {
                    const checkEntry = await models[masterTable].findAll({
                        attributes: [
                            // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSerNo"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        ],
                        where: whereObj
                        // {
                        // ProductName: cubicInfo.Sys_ProductName,
                        // BatchNo: cubicInfo.Sys_Batch,
                        // PVersion: cubicInfo.Sys_PVersion,
                        // Version: cubicInfo.Sys_Version,
                        // // BFGCode: cubicInfo.Sys_BFGCode,
                        // MPN_Code: cubicInfo.Sys_MPNCode,
                        // CubicleType: cubType,
                        // ReportType: cubicInfo.Sys_RptType,
                        // Side: FriabRotaryType
                        // },
                    });


                    if (tempCounterObj.counter == 0) {

                        let _activityObj = {
                            strUserId: userInfo.UserId,
                            strUserName: userInfo.UserName,
                            batch: cubicInfo.Sys_Batch,
                            activity: `Friability Test started on DS ${strDsNo} for Rotary ${FriabRotaryType} side LHS`
                        };

                        await objActivityLog.ActivityLogEntry(_activityObj);
                        await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, `tbl_instrumentlog_balance`, 'Friability', 'Started', strTabIp, userInfo, { cubicalData: cubicInfo })

                        let mstSerNo = await this.calculateMasterSerialNo(objMstFinder)

                        if (!cubicInfo.Sys_RptType) {

                            let mstEntry = await models.tbl_tab_master8.create({
                                MstSerNo: mstSerNo,
                                BFGCode: cubicInfo.Sys_BFGCode,
                                ProductName: cubicInfo.Sys_ProductName,
                                ProductType: cubicInfo.Sys_ProductType,
                                Qty: selectedMenuDetails.noOfSamples,
                                DsNo: strDsNo,
                                CubicalNo: cubicleNo,
                                BalanceId: (dataObj.instrumentId == 'None') ? 'NA' : dataObj.instrumentId,
                                FriabilityID: (cubicInfo.Sys_FriabID == 'None') ? 'NA' : cubicInfo.Sys_FriabID,
                                BatchNo: cubicInfo.Sys_Batch,
                                UserName: userInfo.UserName,
                                UserId: userInfo.UserId,
                                PrDate: moment().format('YYYY-MM-DD'),
                                PrTime: moment().format('HH:mm:ss'),
                                Side: FriabRotaryType,
                                Unit: selectedMenuDetails.selectedProductDetail.unit,
                                WgmtModeNo: 8,
                                // NMT: productParams.nominal.toFixed(2),
                                // SetCount: productParams.T1Neg,
                                // SetRPM: productParams.T1Pos,
                                T2NegTol: T2Neg,
                                T2PosTol: T2Pos,
                                CubicleType: cubType,
                                ReportType: cubicInfo.Sys_RptType,
                                MachineCode: selectedMenuDetails.EquipmentCode,
                                MFGCode: cubicInfo.Sys_Stage,
                                BatchSize: cubicInfo.Sys_BatchSize,
                                CubicleName: cubicleName,
                                CubicleLocation: cubicInfo.Sys_Area,
                                PrintNo: 0,
                                IsArchived: 0,
                                PVersion: cubicInfo.Sys_PVersion,
                                Version: cubicInfo.Sys_Version,
                                Lot: cubicInfo.Sys_LotNo,
                                Area: cubicInfo.Sys_Area,
                                Stage: cubicInfo.Sys_Stage,
                                SFOID: selectedMenuDetails.SFOID,
                                MPN_Code: cubicInfo.Sys_MPNCode
                            })

                            repSerNo = mstEntry.RepSerNo;
                        }




                        await models[getTableName.detailTable].create({
                            RepSerNo: repSerNo,
                            // MstSerNo: mstEntry.MstSerNo,
                            // RecSeqNo: recNo,
                            [InitialWt]: actualWt,
                            [FinalWt]: '0',
                            UserId: userInfo.UserId,
                            UserName: userInfo.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: 'LHS',
                            BalanceID: dataObj.instrumentId,
                            DsNo: strDsNo
                        })



                        await models.tbl_powerbackup.create({
                            CubicalNo: cubicleNo,
                            WeighmentType: 8,
                            WeighmentName: 'FRIAB',
                            Userid: userInfo.UserId,
                            ReportType: cubicInfo.Sys_RptType,
                            RotartyType: FriabRotaryType,
                            Sys_CubType: cubType,
                            Sys_Batch: cubicInfo.Sys_Batch,
                            // Sys_BFGCode: cubicInfo.Sys_BFGCode,
                            Before_Count: tempCounterObj.counter + 1,
                            After_Count: 0,
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            Incomp_RepSerNo: repSerNo,
                            RecSampleNo: 1,
                            ProductType: 1,
                            EntryTimeStamp: addTime,
                            Side_RepSerNo: sideNo,
                            MPN_Code: cubicInfo.Sys_MPNCode
                        })


                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}`);
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.Sideprotocol}${'RHS'}`);


                    }

                    if (tempCounterObj.counter == 1 && checkEntry[0].masterRepSerNo != null) {

                        let _activityObj = {
                            strUserId: userInfo.UserId,
                            strUserName: userInfo.UserName,
                            batch: cubicInfo.Sys_Batch,
                            activity: `Friability Test started on DS ${strDsNo} for Rotary ${FriabRotaryType} side RHS`
                        };

                        await objActivityLog.ActivityLogEntry(_activityObj);

                        repSerNo = checkEntry[0].masterRepSerNo
                        await models[getTableName.detailTable].create({
                            RepSerNo: repSerNo,
                            MstSerNo: checkEntry[0].mstSerNo,
                            // RecSeqNo: recNo,
                            [InitialWt]: actualWt,
                            [FinalWt]: '0',
                            UserId: userInfo.UserId,
                            UserName: userInfo.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: 'RHS',
                            // DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            DsNo: strDsNo
                        })

                        tempCounterObj.counter += 1

                        models.tbl_powerbackup.update(
                            {
                                Before_Count: tempCounterObj.counter
                            }, {
                            where: {
                                CubicalNo: cubicleNo,
                                Sys_Batch: cubicInfo.Sys_Batch,
                                WeighmentName: 'FRIAB',
                                DsNo: strDsNo,
                                TabIp: strTabIp,
                                Incomp_RepSerNo: repSerNo,
                                Side_RepSerNo: sideNo,
                            }
                        }
                        )

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBR2:${actualWt + " " + unit}`);

                        if (autoTare) {
                            mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                        }

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Friability Before Samples Completed, now wait for ${removeTimeForMenuDisable}`)

                    } else {
                        tempCounterObj.counter += 1;
                    }

                } else {
                    let now = new Date();
                    let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.DsNo == strDsNo);
                    let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    let side = 'LHS'

                    let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.DsNo == strDsNo).configSetting;
                    let autoTare = hmiEntryinConfig[0].AutoTare;
                    let tareCommand = hmiEntryinConfig[0].Tare_Command

                    if (powerbacc != undefined) {
                        if (powerbacc.Before_Count == 2 && powerbacc.After_Count == 1 && tempCounterObjAfter.counter == 1) {
                            tempCounterObjAfter.counter = 2
                            side = 'RHS'
                        }
                    }

                    var checkEntry = await models[masterTable].findAll({
                        attributes: [
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSerNo"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        ],
                        where: whereObj
                        // {
                        //     ProductName: cubicInfo.Sys_ProductName,
                        //     BatchNo: cubicInfo.Sys_Batch,
                        //     PVersion: cubicInfo.Sys_PVersion,
                        //     Version: cubicInfo.Sys_Version,
                        //     // BFGCode: cubicInfo.Sys_BFGCode,
                        //     CubicleType: cubType,
                        //     ReportType: cubicInfo.Sys_RptType,
                        //     Side: FriabRotaryType,
                        //     MPN_Code: cubicInfo.Sys_MPNCode

                        // }
                        ,
                        raw: true
                    });
                    checkEntry = checkEntry[0]

                    if (powerbacc) initSampletime = powerbacc.EntryTimeStamp;

                    if (Date.parse(currentTime) >= Date.parse(initSampletime)) {
                        let __paramProductData = {
                            ProductId: cubicInfo.Sys_BFGCode,
                            ProductName: cubicInfo.Sys_ProductName,
                            ProductVersion: cubicInfo.Sys_PVersion,
                            Version: cubicInfo.Sys_Version,
                            Batch: cubicInfo.Sys_Batch,
                            uniqueSerialNumber: strDsNo,
                            Side: FriabRotaryType,
                            cubicleName: cubicleName,
                            cubType: cubType,
                            cubicleNo: cubicleNo,
                            MPN: cubicInfo.Sys_MPNCode
                        }

                        if (tempCounterObjAfter.counter == 0 && tempCounterObj.counter == 2) {

                            var result = await this.checkProductData(whereObj, strDsNo);

                            if (result[0].RepSerNo != null) {

                                let respSelectFri = await models[getTableName.detailTable].findAll({
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                        Side: side
                                    }
                                })
                                respSelectFri = respSelectFri[0];

                                await models.tbl_powerbackup.update({
                                    After_Count: tempCounterObjAfter.counter + 1
                                }, {
                                    where: {
                                        CubicalNo: powerbacc.CubicalNo,
                                        WeighmentName: 'FRIAB',
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        Side_RepSerNo: sideNo

                                    }
                                })

                                // var NMT = __parameterFriability.productType.nominal
                                var NWBeforeTest = mathj.round((((respSelectFri[InitialWt] - actualWt) / respSelectFri[InitialWt]) * 100), dp).toFixed(dp); //dec set to 3 as per requirement (mail 09-07-24)
                                var drum1 = NWBeforeTest
                                var remark1

                                if (((drum1).includes('-'))) {
                                    // remark1 = 'Within Limit'
                                    drum1 = '0.00'
                                }

                                if (drum1 > T2Neg && drum1 < T2Pos) {
                                    remark1 = 'Within Limit'
                                } else {
                                    remark1 = 'Out Of Limit'
                                }

                                await models[getTableName.detailTable].update({
                                    // FriabVal: NWBeforeTest,
                                    [FriabVal]: drum1,
                                    [FinalWt]: actualWt,
                                    Remark: remark1
                                }, {
                                    where: {
                                        RecNo: respSelectFri.RecNo,
                                        RepSerNo: respSelectFri.RepSerNo,
                                    }
                                });



                                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${respSelectFri.InitialWt} ${unit};WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);

                                // await objMonit.monit({
                                //     case: 'TestWeight', Hmi: strHmi, data: {
                                //         Weight: `${Number(
                                //             receiveWt
                                //         )} ${unit}`, srNo: "", message: 'FinalWeight'
                                //     }
                                // });

                                let _activityObj = {
                                    strUserId: userInfo.UserId,
                                    strUserName: userInfo.UserName,
                                    batch: cubicInfo.Sys_Batch,
                                    activity: `Friability Test Completed on DS ${strDsNo} for Rotary ${FriabRotaryType} side LHS`
                                };

                                await objActivityLog.ActivityLogEntry(_activityObj);

                                if (autoTare) {
                                    mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                                }


                            }

                            tempCounterObjAfter.counter += 1;
                        }





                        if (tempCounterObjAfter.counter == 2 && tempCounterObj.counter == 2) {
                            //update WTAR2
                            var result = await this.checkProductData(__paramProductData, strDsNo);

                            let resSelectFri = await models[getTableName.detailTable].findAll({
                                where: {
                                    RepSerNo: result[0].RepSerNo,
                                    Side: side
                                }
                            })

                            let nwtAfterTest;
                            let nwtBeforeTest;
                            resSelectFri = resSelectFri.pop()
                            nwtBeforeTest = mathj.round((((resSelectFri[InitialWt] - resSelectFri[FinalWt]) / resSelectFri[InitialWt]) * 100), dp).toFixed(dp);
                            nwtAfterTest = mathj.round((((resSelectFri[InitialWt] - actualWt) / resSelectFri[InitialWt]) * 100), dp).toFixed(dp); //dec set to 3 as per requirement (mail 09-07-24)
                            if (result) {
                                //update WTAR2
                                // var detailRecords = await models.tbl_tab_detail8.findAll({
                                //     attributes: [
                                //         [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                                //     ],
                                //     where: {
                                //         'RepSerNo':resSelectFri.RepSerNo,
                                //         'Side': side,
                                //     },
                                //     raw: true
                                // })

                                var drum1 = nwtAfterTest
                                var remark1



                                if (((drum1).includes('-'))) {
                                    // remark1 = 'Within Limit'
                                    drum1 = '0.00'
                                }
                                if (drum1 > T2Neg && drum1 < T2Pos) {
                                    remark1 = 'Within Limit'
                                } else {
                                    remark1 = 'Out of Limit'
                                }


                                const updateData = await models[getTableName.detailTable].update({

                                    [FinalWt]: actualWt,
                                    Remark: remark1,
                                    [FriabVal]: nwtAfterTest,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                }, {
                                    where: {
                                        RecNo: resSelectFri.RecNo,
                                        RepSerNo: resSelectFri.RepSerNo
                                    }
                                });


                                if (cubicInfo.Sys_RptType != undefined) {

                                    let masterData = await models[getTableName.masterTable].update({
                                        PrEndTime: moment().format('HH:mm:ss'),
                                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                        Param8_PrEndTime: moment().format('HH:mm:ss'),
                                        Param8_PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    }, {
                                        where: {
                                            RepSerNo: resSelectFri.RepSerNo
                                        }
                                    });
                                }

                                const updateDataPower = await models.tbl_powerbackup.update({
                                    'CubicalNo': cubicleNo,
                                    'WeightmentType': 8,
                                    'RepSerno': result[0].RepSerNo
                                }, {
                                    where: {
                                        After_Count: tempCounterObjAfter.counter,
                                        WeighmentName: 'FRIAB',
                                        DsNo: strDsNo,
                                        TabIp: strTabIp
                                    }

                                })



                                let resSelectFri2 = await models[getTableName.detailTable].findAll({
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                })


                                let batchSummaryObject = {
                                    BFGCode: cubicInfo.Sys_BFGCode,
                                    ProductName: cubicInfo.Sys_ProductName,
                                    PVersion: cubicInfo.Sys_PVersion,
                                    Version: cubicInfo.Sys_Version,
                                    PrdType: 1,
                                    CubType: cubicInfo.Sys_CubType,
                                    BatchNo: cubicInfo.Sys_Batch,
                                    Unit: cubicInfo.Sys_BatchSizeUnit,
                                    Side: FriabRotaryType,
                                    InstrumentID: dataObj.instrumentId,
                                    UserId: userInfo.UserId,
                                    UserName: userInfo.UserName,

                                    nwtBeforeTest: nwtBeforeTest,
                                    nwtAfterTest: nwtAfterTest,
                                    lwtBeforeTest: resSelectFri2[0][InitialWt],
                                    lwtAfterTest: resSelectFri2[0][FinalWt],
                                    rwtBeforeTest: resSelectFri2[1][InitialWt],
                                    rwtAfterTest: resSelectFri2[1][FinalWt],
                                    Dept: cubicInfo.Sys_dept,
                                    Area: cubicInfo.Sys_Area,
                                    Nom: '1.0',
                                    PrTime: date.format(now, 'HH:mm:ss'),
                                    PrDate: date.format(now, 'YYYY-MM-DD'),
                                    MPN_Code: cubicInfo.Sys_MPNCode
                                }


                                await objBatchSummary.saveBatchSummaryFriability1(batchSummaryObject, strDsNo);




                                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBR2:${resSelectFri.InitialWt} ${unit};WTAR2:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);


                                if (autoTare) {
                                    mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                                }




                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });

                            }


                            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo);


                            // await models.tbl_powerbackup.destroy({
                            //     where: {
                            //         'CubicalNo': powerbacc.CubicalNo,
                            //         WeighmentName: 'FRIAB',
                            //         DsNo: strDsNo,
                            //         TabIp: strTabIp
                            //     }
                            // })


                            let objActivity = {}
                            Object.assign(objActivity,
                                { strUserId: userInfo.UserId },
                                { strUserName: userInfo.UserName },
                                { batch: cubicInfo.Sys_Batch },
                                { activity: `Friability Test Completed on Ds ${strDsNo} For Rotary ${FriabRotaryType} Side RHS` });

                            await objActivityLog.ActivityLogEntry(objActivity);

                            await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed', strTabIp, userInfo, { cubicalData: cubicInfo });

                            globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                                globalData.arrWeighmentCounterForFriab :
                                globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                            globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                                globalData.arrWeighmentCounterAfter :
                                globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);




                            //     globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                            //test splice if rotarty is not double
                            globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1 ?
                                globalData.arrSelectedMenu :
                                globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp), 1);

                            setTimeout(() => { mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                            //monit
                            // await objMonit.monit({
                            //     case: 'ReportStatus', Hmi: strHmi, data: {
                            //         message: 'Friability Test Completed'
                            //     }
                            // });



                        }


                    } else {

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }


                }
            } else {

                let side = FriabRotaryType != 'Double' ? 'NA' : 'NA'
                let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))

                if (powerbacc) initSampletime = powerbacc.EntryTimeStamp



                var checkEntry = await models[masterTable].findAll({
                    attributes: [
                        [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSrNo"],
                        [sequelize.fn('MAX', sequelize.col("SrNo")), "RecNo"],
                        [sequelize.fn('MAX', sequelize.col("RepSerNo")), "mstRepSrNo"],
                    ],
                    where: whereObj
                    //  {
                    //     ProductName: cubicInfo.Sys_ProductName,
                    //     BatchNo: cubicInfo.Sys_Batch,
                    //     PVersion: cubicInfo.Sys_PVersion,
                    //     Version: cubicInfo.Sys_Version,
                    //     // BFGCode: cubicInfo.Sys_BFGCode,
                    //     CubicleType: cubType,
                    //     ReportType: cubicInfo.Sys_RptType,
                    //     Side: FriabRotaryType,
                    //     MPN_Code: cubicInfo.Sys_MPNCode
                    // }
                    ,
                    raw: true
                });

                // let MstRecSerNo = checkEntry[0].mstSrNo ? checkEntry[0].mstSrNo : 1;
                let RecNo = checkEntry[0].RecNo ? checkEntry[0].RecNo : 1;

                if (powerbacc != undefined) {
                    if (powerbacc.Before_Count == 1 && powerbacc.After_Count == 0 && tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 0) {
                        tempCounterObjAfter.counter = 1
                    }
                }

                if (tempCounterObj.counter == 0 && tempCounterObjAfter.counter == 0) {

                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicInfo.Sys_Batch,
                        activity: `Friability Test started on DS ${strDsNo} for Side ${FriabRotaryType}`
                    };

                    await objActivityLog.ActivityLogEntry(_activityObj);

                    let mstSrNo = this.calculateMasterSerialNo(objMstFinder)

                    let mstEntry = await models.tbl_tab_master8.create({
                        MstSerNo: mstSrNo,
                        SrNo: RecNo + 1,
                        BFGCode: cubicInfo.Sys_BFGCode,
                        ProductName: cubicInfo.Sys_ProductName,
                        ProductType: cubicInfo.Sys_ProductType,
                        Qty: selectedMenuDetails.noOfSamples,
                        DsNo: strDsNo,
                        CubicalNo: cubicleNo,
                        BalanceId: dataObj.instrumentId,
                        FriabilityID: cubicInfo.Sys_FriabID,
                        BatchNo: cubicInfo.Sys_Batch,
                        UserName: userInfo.UserName,
                        UserId: userInfo.UserId,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        Side: FriabRotaryType,
                        Unit: selectedMenuDetails.selectedProductDetail.unit,
                        WgmtModeNo: 8,
                        // NMT: productParams.nominal.toFixed(2),
                        // SetCount: productParams.T1Neg,
                        // SetRPM: productParams.T1Pos,
                        T2NegTol: T2Neg,
                        T2PosTol: T2Pos,
                        CubicleType: cubType,
                        ReportType: cubicInfo.Sys_RptType,
                        MachineCode: selectedMenuDetails.EquipmentCode,
                        MFGCode: cubicInfo.Sys_Stage,
                        BatchSize: cubicInfo.Sys_BatchSize,
                        CubicleName: cubicleName,
                        CubicleLocation: cubicInfo.Sys_Area,
                        PrintNo: 0,
                        IsArchived: 0,
                        PVersion: cubicInfo.Sys_PVersion,
                        Version: cubicInfo.Sys_Version,
                        Lot: cubicInfo.Sys_LotNo,
                        Area: cubicInfo.Sys_Area,
                        Stage: cubicInfo.Sys_Stage,
                        SFOID: selectedMenuDetails.SFOID,
                        MPN_Code: cubicInfo.Sys_MPNCode
                    })

                    let detailEntry = await models.tbl_tab_detail8.create({
                        RepSerNo: mstEntry.RepSerNo,
                        MstSerNo: mstEntry.MstSerNo,
                        RecSeqNo: mstEntry.SrNo,
                        InitialWt: actualWt,
                        [FinalWt]: '0',
                        UserId: userInfo.UserId,
                        UserName: userInfo.UserName,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        Side: 'NA',
                        BalanceID: dataObj.instrumentId,
                        DsNo: strDsNo,
                        Side: side
                    })

                    mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}`);

                    if (autoTare) {
                        mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                    }

                    tempCounterObj.counter += 1;

                    if (!powerbacc) {
                        await models.tbl_powerbackup.create({
                            CubicalNo: cubicleNo,
                            WeighmentType: 8,
                            WeighmentName: 'FRIAB',
                            Userid: userInfo.UserId,
                            ReportType: cubicInfo.Sys_RptType,
                            RotartyType: FriabRotaryType,
                            Sys_CubType: cubType,
                            Sys_Batch: cubicInfo.Sys_Batch,
                            Sys_BFGCode: cubicInfo.Sys_BFGCode,
                            Before_Count: tempCounterObj.counter,
                            After_Count: 0,
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            Incomp_RepSerNo: detailEntry.RepSerNo,
                            RecSampleNo: detailEntry.RecSeqNo,
                            ProductType: 1,
                            Side_RepSerNo: sideNo,
                            EntryTimeStamp: addTime,
                            MPN_Code: cubicInfo.Sys_MPNCode
                        })
                    }

                }

                if (tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 1) {

                    if (currentTime > initSampletime) {



                        let detailData = await models.tbl_tab_detail8.findAll({
                            where: {
                                RepSerNo: powerbacc.Incomp_RepSerNo,
                                RecSeqNo: powerbacc.RecSampleNo
                            }
                        })

                        detailData = detailData.pop();

                        let InitialWt = detailData[InitialWt];
                        let Nominal;
                        let remark1
                        let nwtAfterTest = mathj.round((((InitialWt - actualWt) / InitialWt) * 100), dp).toFixed(dp);

                        if (nwtAfterTest > T2Neg && nwtAfterTest < remark1) {
                            remark1 = 'Within Limit'
                        } else {
                            remark1 = 'Out Of Limit'
                        }

                        const updateData = await models.tbl_tab_detail8.update({

                            [FinalWt]: actualWt,
                            Remark: remark1,
                            [FriabVal]: nwtAfterTest,
                            PrEndTime: moment().format('HH:mm:ss'),
                            PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                        }, {
                            where: {
                                RecSeqNo: detailData.RecSeqNo,
                                RepSerNo: detailData.RepSerNo,
                                Side: side
                            }
                        });

                        await models.tbl_tab_master8.update({
                            PrEndTime: moment().format('HH:mm:ss'),
                            PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                        }, {
                            where: {
                                RepSerNo: resSelectFri.RepSerNo
                            }
                        })

                        let batchSummaryObject = {
                            BFGCode: cubicInfo.Sys_BFGCode,
                            ProductName: cubicInfo.Sys_ProductName,
                            PVersion: cubicInfo.Sys_PVersion,
                            Version: cubicInfo.Sys_Version,
                            PrdType: 1,
                            CubType: cubicInfo.Sys_CubType,
                            BatchNo: cubicInfo.Sys_Batch,
                            Unit: cubicInfo.Sys_BatchSizeUnit,
                            Side: FriabRotaryType,
                            InstrumentID: dataObj.instrumentId,
                            UserId: userInfo.UserId,
                            UserName: userInfo.UserName,

                            // nwtBeforeTest: nwtBeforeTest,
                            nwtAfterTest: nwtAfterTest,
                            lwtBeforeTest: resSelectFri2[0][InitialWt],
                            lwtAfterTest: resSelectFri2[0][FinalWt],
                            rwtBeforeTest: resSelectFri2[1][InitialWt],
                            rwtAfterTest: resSelectFri2[1][FinalWt],
                            Dept: cubicInfo.Sys_dept,
                            Area: cubicInfo.Sys_Area,
                            Nom: '1.0',
                            PrTime: date.format(now, 'HH:mm:ss'),
                            PrDate: date.format(now, 'YYYY-MM-DD'),
                            MPN_Code: cubicInfo.Sys_MPNCode
                        }

                        // await objBatchSummary.saveBatchSummaryFriability1(batchSummaryObject, strDsNo);

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${InitialWt} ${unit};WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);


                        let objActivity = {}
                        Object.assign(objActivity,
                            { strUserId: userInfo.UserId },
                            { strUserName: userInfo.UserName },
                            { batch: cubicInfo.Sys_Batch },
                            { activity: `Friability Test Completed on Ds ${strDsNo} For Rotary ${FriabRotaryType}` });

                        await objActivityLog.ActivityLogEntry(objActivity);

                        await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed', strTabIp, userInfo, { cubicalData: cubicInfo });
                        await models.tbl_powerbackup.destroy({
                            where: {
                                DsNo: strDsNo,
                                TabIp: strTabIp,
                                WeighmentName: 'FRIAB',
                            }
                        });


                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                            globalData.arrWeighmentCounterForFriab :
                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                        globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                            globalData.arrWeighmentCounterAfter :
                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);


                        globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1 ?
                            globalData.arrSelectedMenu :
                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp), 1);

                        setTimeout(() => { mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.TestCompleted} Test Completed`) }, 1000);


                    } else {

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }

                }
            }


        } catch (error) {
            console.log(error)
        }
    }

    async processBalanceFriabilityInitial(dataObj) {
        try {
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let actualWt = dataObj.actualWt;
            let invalidUnitFlag = dataObj.invalidUnitFlag;
            let invalidWeightFlag = dataObj.invalidWeightFlag;
            let selectedMenuDetails = dataObj.SelectedMenuDetails
            let protocolPortNo = dataObj.ProtocolPortNo
            let T2Pos = selectedMenuDetails.selectedProductDetail.T2Pos
            let T2Neg = selectedMenuDetails.selectedProductDetail.T2Neg
            let unit = selectedMenuDetails.selectedProductDetail.unit ?? 'gm';
            unit = unit == 'gm' ? 'g' : unit;
            let dp = selectedMenuDetails.selectedProductDetail.dp
            let FriabRotaryType = selectedMenuDetails.rotary ?? 'LHS';
            // let FriabRotaryType = 'LHS';
            let nominal = selectedMenuDetails?.selectedProductDetail?.Nominal ?? 1.0;
            let rpmValue = selectedMenuDetails?.selectedProductDetail?.RPM ?? '00:04:00';
            let rpm = parseInt(rpmValue.split(':')[1])
            let cubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp).cubicalData
            let getTableName = objCommonWeightment.getTableName(cubicInfo, 'Friability', strDsNo, strTabIp)
            let masterTable = cubicInfo.Sys_RptType != undefined ? getTableName.masterTableIncomplete : getTableName.masterTable;
            let exceptionTable = cubicInfo.Sys_RptType ? 'tbl_exception_sample_initial' : 'tbl_exception_sample'

            // Nominal ki condition handle karni hai

            // if(invalidUnitFlag){
            //     return mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Invalid Unit Recieved`)
            // }


            let arrseelcted = globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp)


            let repSerNo;

            let NLT = await models.tbl_cubicle_product_sample.findOne({
                where: {
                    Sys_CubicNo: cubicInfo.Sys_CubicNo
                }
            })

            let NLTWeight = NLT.Friability.split(' ')[1]

            // this db call for checking ipqc

            let ipcCubicData = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: strDsNo
                }
            })

            // if ipqc then cubical details changes
            let cubicleName = cubicInfo.Sys_CubicName
            let cubicleNo = cubicInfo.Sys_CubicNo
            let cubType = cubicInfo.Sys_CubType

            if (cubicInfo.Sys_CubicNo != ipcCubicData.Sys_CubicNo || cubicInfo.Sys_CubType != ipcCubicData.Sys_CubType) {
                cubicleName = ipcCubicData.Sys_CubicName
                cubicleNo = ipcCubicData.Sys_CubicNo
                cubType = ipcCubicData.Sys_CubType
            }

            let userInfo = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)

            let whereObj = {};

            let InitialWt = 'InitialWt';
            let FinalWt = 'FinalWt';
            let FriabVal = 'FriabVal';
            let sideNo = FriabRotaryType == 'RHS' ? 1 : 0;
            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: cubicleNo,
                    Sys_Batch: cubicInfo.Sys_Batch,
                    WeighmentName: 'FRIAB',
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    Side_RepSerNo: sideNo,
                    MPN_Code: cubicInfo.Sys_MPNCode
                }
            })

            powerbacc = powerbacc.pop();

            if (cubicInfo.Sys_RptType != undefined) {
                InitialWt = 'BeforeValue';
                FinalWt = 'AfterValue';
                FriabVal = 'NetValue'

                let menuSequence = await models.tbl_menu_sequence.findAll({
                    where: {
                        TabIp: strTabIp,
                        DS_Number: strDsNo,
                    }
                })

                const equipmentData = await models.tbl_machine.findOne({
                    attributes: ['Machine_Punches'],
                    where: { Machine_ID: cubicInfo.Sys_MachineCode }
                })

                repSerNo = menuSequence.length > 0 ? menuSequence[0].RepSerNo : null

                var mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicInfo, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })
                if (repSerNo == 0) {
                    let mstEntry = await models[masterTable].create({
                        MstSerNo: mastSerNo,
                        CubicalNo: cubicInfo.Sys_CubicNo,
                        // CubicleName: cubicInfo.Sys_CubicalName,
                        CubicleName: cubicleName,
                        CubicleType: cubicInfo.Sys_CubicalType,
                        ProductName: cubicInfo.Sys_ProductName,
                        MPN_Code: cubicInfo.Sys_MPNCode,
                        SFOID: selectedMenuDetails.SFOID,
                        ProductType: 1,
                        Area: cubicInfo.Sys_Area,
                        MachineCode: selectedMenuDetails?.EquipmentCode ?? null,
                        PVersion: cubicInfo.Sys_PVersion,
                        Version: cubicInfo.Sys_Version,
                        BatchNo: cubicInfo.Sys_Batch,
                        BFGCode: cubicInfo.Sys_BFGCode,
                        // Param7_T2NegTol: hardnessneg2,
                        // Param7_T2PosTol: hardnesspos2,
                        // Param3_T2PosTol: thicknespos2,
                        // Param3_T2NegTol: thicknesneg2,
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        ProductName: cubicInfo.Sys_ProductName,
                        UserId: userInfo.UserId,
                        UserName: userInfo.UserName,
                        Idsno: cubicInfo.Sys_DSNumber,
                        BalanceId: cubicInfo.Sys_BalID,
                        // VernierId: cubicInfo.Sys_VernierID,
                        FriabilityID: (cubicInfo.Sys_FriabID == 'None') ? 'NA' : cubicInfo.Sys_FriabID,
                        // HardnessID: cubicInfo.Sys_HardID,
                        // DTID: cubicInfo.Sys_DTID,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                        Param8_PrTime: moment().format('HH:mm:ss'),
                        Param8_PrDate: moment().format('YYYY-MM-DD'),
                        Param8_Nom: nominal,
                        Param8_DecimalPoint: dp,
                        Param8_T1Pos: rpm,
                        Param8_Unit: unit,
                        Repetition: cubicInfo.Sys_Repetition,
                        ReportType: cubicInfo.Sys_RptType,
                        Qty: selectedMenuDetails.individualsamplecount,
                        GrpQty: selectedMenuDetails.groupQty,
                        NoOfStations: equipmentData.Machine_Punches,
                        Side: cubicInfo.Sys_RotaryType,
                        LHSContainerNo: selectedMenuDetails.LHSContainerNo,
                        RHSContainerNo: selectedMenuDetails.RHSContainerNo,
                        MesTestType: cubicInfo.MesTestType,
                        MesSide: cubicInfo.MesSide,
                    })


                    await models.tbl_menu_sequence.update({
                        RepSerNo: mstEntry.RepSerNo
                    }, {
                        where: {
                            DS_Number: strDsNo,
                            TabIp: strTabIp
                        }
                    })


                    repSerNo = mstEntry.RepSerNo


                } else {
                    if (!powerbacc) {
                        await models[masterTable].update({
                            Param8_PrTime: moment().format('HH:mm:ss'),
                            Param8_PrDate: moment().format('YYYY-MM-DD'),
                            Param8_Nom: nominal,
                            Param8_DecimalPoint: dp,
                            Param8_T1Pos: rpm,
                            Param8_Unit: unit,
                            FriabilityID: (cubicInfo.Sys_FriabID == 'None') ? 'NA' : cubicInfo.Sys_FriabID,
                        }, {
                            where: {
                                RepSerNo: repSerNo
                            }
                        });
                    }

                }

                Object.assign(whereObj, { RepSerNo: repSerNo })
            } else {
                // await this.processBalanceFriabilityData2(dataObj)

            }

            let objMstFinder = {
                tableName: masterTable,
                ProductName: cubicInfo.Sys_ProductName,
                Batch: cubicInfo.Sys_Batch,
                PVersion: cubicInfo.Sys_PVersion,
                Version: cubicInfo.Sys_Version,
                BFGCode: cubicInfo.Sys_BFGCode,
                CubType: cubType,
                RptType: cubicInfo.Sys_RptType,
                MPN: cubicInfo.Sys_MPNCode
            }

            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let removeTimeForMenuDisable = rpm;
            var addTime = this.AddMinutesToDate(new moment(), removeTimeForMenuDisable);
            var dateFormat = addTime.split(' ');
            var dateFormat1 = dateFormat[1];

            if (powerbacc != undefined) {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.Before_Count,
                        'FriabSide': sideNo
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.After_Count,
                        'FriabSide': sideNo
                    })
                }
            } else {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }
            }

            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.DsNo == strDsNo).configSetting;
            let autoTare = hmiEntryinConfig[0].AutoTare;
            let tareCommand = hmiEntryinConfig[0].Tare_Command



            if ((FriabRotaryType == 'LHS' || FriabRotaryType == 'RHS' || FriabRotaryType == 'NA') && cubicInfo.Sys_RptType != undefined) {

                let side = FriabRotaryType;
                let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))

                if (powerbacc) initSampletime = powerbacc.EntryTimeStamp

                // var checkEntry = await models[masterTable].findAll({
                //     attributes: [
                //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSrNo"],
                //         // [sequelize.fn('MAX', sequelize.col("SrNo")), "RecNo"],
                //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "mstRepSrNo"],
                //     ],
                //     where: whereObj
                //     ,
                //     raw: true
                // });

                // let MstRecSerNo = checkEntry[0].mstSrNo ? checkEntry[0].mstSrNo : 1;
                // let RecNo = checkEntry[0].RecNo ? checkEntry[0].RecNo : 1;

                if (powerbacc != undefined) {
                    if (powerbacc.Before_Count == 1 && powerbacc.After_Count == 0 && tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 0) {
                        tempCounterObjAfter.counter = 1

                    }
                }

                if (tempCounterObj.counter == 0 && tempCounterObjAfter.counter == 0) {

                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicInfo.Sys_Batch,
                        activity: `Friability Test started on DS ${strDsNo} for Side ${FriabRotaryType}`
                    };

                    await objActivityLog.ActivityLogEntry(_activityObj);

                    if (parseFloat(actualWt) <= parseFloat(NLTWeight)) {
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Before Weight must be ${NLT.Friability}`);
                        return;
                    }

                    var detailEntry = await models[getTableName.detailTableIncomplete].create({
                        RepSerNo: repSerNo,
                        // MstSerNo: mstEntry.MstSerNo,
                        RecSeqNo: 1,
                        [InitialWt]: actualWt,
                        [FinalWt]: '0',
                        UserId: userInfo.UserId,
                        UserName: userInfo.UserName,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        Side: side,
                        InstrumentID: dataObj.instrumentId,
                        DsNo: strDsNo,
                        BatchNo: cubicInfo.Sys_Batch,
                        DP: dp,
                        DataValueUnit: unit,
                        ProductName: cubicInfo.Sys_ProductName,

                        // InstrumentID: 
                    })

                    await objMonit.monit({
                        case: 'TestWeight', Hmi: strDsNo, data: {
                            Weight: `${Number(
                                actualWt
                            )} ${unit}`, srNo: "", message: 'InitialWeight'
                        }
                    });
                    mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}`);

                    if (autoTare) {
                        mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                    }

                    tempCounterObj.counter += 1;

                    if (!powerbacc) {
                        await models.tbl_powerbackup.create({
                            CubicalNo: cubicleNo,
                            WeighmentType: 8,
                            WeighmentName: 'FRIAB',
                            Userid: userInfo.UserId,
                            ReportType: cubicInfo.Sys_RptType,
                            RotartyType: FriabRotaryType,
                            Sys_CubType: cubType,
                            Sys_Batch: cubicInfo.Sys_Batch,
                            Sys_BFGCode: cubicInfo.Sys_BFGCode,
                            Before_Count: tempCounterObj.counter,
                            After_Count: 0,
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            Incomp_RepSerNo: detailEntry.RepSerNo,
                            RecSampleNo: detailEntry.RecSeqNo,
                            ProductType: 1,
                            Side_RepSerNo: sideNo,
                            EntryTimeStamp: addTime,
                            MPN_Code: cubicInfo.Sys_MPNCode
                        })
                    } else {
                        await models.tbl_powerbackup.update({
                            Before_Count: tempCounterObj.counter,
                            After_Count: 0,
                            EntryTimeStamp: addTime,
                        },
                            {
                                where: {
                                    Incomp_RepSerNo: repSerNo,
                                    WeighmentType: 8,
                                    WeighmentName: 'FRIAB',
                                    RecSampleNo: detailEntry.RecSeqNo,
                                    Side_RepSerNo: sideNo
                                }
                            });
                    }

                    mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Friability Before Samples Completed, now wait for ${removeTimeForMenuDisable} min. 00 sec`)

                }

                if (tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 1) {

                    if (initSampletime < currentTime) {



                        let detailData = await models[getTableName.detailTableIncomplete].findAll({
                            where: {
                                RepSerNo: powerbacc.Incomp_RepSerNo,
                                RecSeqNo: powerbacc.RecSampleNo
                            }
                        })

                        detailData = detailData.pop();

                        let initialwt = detailData[InitialWt];
                        let remark1
                        let nwtAfterTest = mathj.round((((initialwt - actualWt) / initialwt) * 100), dp).toFixed(3);

                        if (nwtAfterTest <= nominal) {
                            remark1 = 'Within Limit'
                        } else {
                            remark1 = 'Out Of Limit'
                        }

                        const updateData = await models[getTableName.detailTableIncomplete].update({

                            [FinalWt]: actualWt,
                            Remark: remark1,
                            [FriabVal]: nwtAfterTest,
                            PrEndTime: moment().format('HH:mm:ss'),
                            PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                            IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                            isException: remark1 == 'Within Limit' ? 0 : 1
                        }, {
                            where: {
                                RecNo: detailData.RecNo,
                                RepSerNo: detailData.RepSerNo,
                                Side: side
                            }
                        });

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strDsNo, data: {
                                Weight: `${Number(
                                    actualWt
                                )} ${unit}`, srNo: "", message: 'FinalWeight'
                            }
                        });
                        if (remark1 != 'Within Limit') {
                            // await models[exceptionTable].create({
                            //     IDSNo: null,
                            //     Remark: remark1,
                            //     DataValue: nwtAfterTest,
                            //     DataValueUnit: unit,
                            //     RepSerNo: powerbacc.Incomp_RepSerNo,
                            //     MenuName: 'Friability',
                            //     ProductType: 1,
                            //     Repetition: cubicInfo.Sys_Repetition,
                            //     // TypeValue :
                            //     BFGCode: cubicInfo.Sys_BFGCode,
                            //     ProductName: cubicInfo.Sys_ProductName,
                            //     BatchNo: cubicInfo.Sys_Batch,
                            //     // Department :
                            //     SFOID: selectedMenuDetails.SFOID,
                            //     // MachineCode: dataObj.EquipmentCode,
                            //     PrDate: moment().format('YYYY-MM-DD'),
                            //     prTime: moment().format('HH:mm:ss'),
                            //     Side: side,
                            //     // InstrumentId: InstrumentId,
                            //     T1NegTol: nominal,
                            //     // T1PosTo: maxLimitT2,
                            //     SampleNo: 1,
                            //     CheckByDate: null,
                            //     CheckByName: null,
                            //     CheckById: null,
                            //     Area: cubicInfo.Sys_Area,
                            //     UserID: userInfo.UserId,
                            //     UserName: userInfo.UserName,
                            //     ProductType: 1,
                            //     TypValue: cubicInfo.Sys_RptType
                            //     // SampleNo: 1
                            // })

                            mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);

                            mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}${remark1}`);

                            await models.tbl_powerbackup.update({
                                Before_Count: 0,
                                After_Count: 0,
                                isException: remark1 == 'Within Limit' ? 0 : 1
                            },
                                {
                                    where: {
                                        Incomp_RepSerNo: detailData.RepSerNo,
                                        WeighmentType: 8,
                                        WeighmentName: 'FRIAB',
                                        RecSampleNo: detailData.RecSeqNo,
                                        Side_RepSerNo: sideNo
                                    }
                                });

                        } else {
                            await models[masterTable].update({
                                Param8_PrEndTime: moment().format('HH:mm:ss'),
                                Param8_PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                Param8_Remark: remark1,
                                Param8_AvgNet: nwtAfterTest,
                                Param8_MinWeight: nwtAfterTest,
                                Param8_MaxWeight: nwtAfterTest,
                                IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                            }, {
                                where: {
                                    RepSerNo: powerbacc.Incomp_RepSerNo
                                }
                            });

                            mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);


                            var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Friability", detailData.RepSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicInfo, protocolPortNo, 'NA', 'NA', 'Test Completed')

                            let objActivity = {}
                            Object.assign(objActivity,
                                { strUserId: userInfo.UserId },
                                { strUserName: userInfo.UserName },
                                { batch: cubicInfo.Sys_Batch },
                                { activity: `Friability Test Completed on Ds ${strDsNo} For Rotary ${FriabRotaryType}` });
                            var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Friability", detailData.RepSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicInfo, protocolPortNo, 'NA', 'NA', 'Test Completed')
                            await objMonit.monit({
                                case: 'ReportStatus', Hmi: strDsNo, data: {
                                    message: 'Friability Test Completed'
                                }
                            });
                            await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed', strTabIp, userInfo, { cubicalData: cubicInfo });

                            // await models.tbl_powerbackup.destroy({
                            //     where: {
                            //         Incomp_RepSerNo: detailData.RepSerNo,
                            //         WeighmentType: 8,
                            //         WeighmentName: 'FRIAB',
                            //         RecSampleNo: detailData.RecSeqNo,
                            //         Side_RepSerNo: sideNo
                            //     }
                            // })
                            await models.tbl_powerbackup.destroy({
                                where: {
                                    DsNo: strDsNo,
                                    TabIp: strTabIp,
                                    WeighmentName: 'FRIAB',
                                }
                            });


                            globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1 ?
                                globalData.arrSelectedMenu :
                                globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp), 1);


                        }



                        // let mesArr = globalData.MESArray.push(
                        //     {
                        //         menuName: 'Friability',
                        //         payload: {'Friability': { BeforeValue: initialwt, AfterValue:actualWt , FirabValue: nwtAfterTest ,isMesChecked: false } }],
                        //         dsNo: strDsNo,
                        //         tabIp: strTabIp,
                        //         portNo: protocolPortNo,
                        //         isCompleted: false, 
                        //         RepSerNo: repSerNo
                        //     }
                        // )

                        // console.log(mesArr)
                        // let batchSummaryObject = {
                        //     BFGCode: cubicInfo.Sys_BFGCode,
                        //     ProductName: cubicInfo.Sys_ProductName,
                        //     PVersion: cubicInfo.Sys_PVersion,
                        //     Version: cubicInfo.Sys_Version,
                        //     PrdType: 1,
                        //     CubType: cubicInfo.Sys_CubType,
                        //     BatchNo: cubicInfo.Sys_Batch,
                        //     Unit: cubicInfo.Sys_BatchSizeUnit,
                        //     Side: FriabRotaryType,
                        //     InstrumentID: dataObj.instrumentId,
                        //     UserId: userInfo.UserId,
                        //     UserName: userInfo.UserName,

                        //     // nwtBeforeTest: nwtBeforeTest,
                        //     nwtAfterTest: nwtAfterTest,
                        //     lwtBeforeTest: resSelectFri2[0][InitialWt],
                        //     lwtAfterTest: resSelectFri2[0][FinalWt],
                        //     rwtBeforeTest: resSelectFri2[1][InitialWt],
                        //     rwtAfterTest: resSelectFri2[1][FinalWt],
                        //     Dept: cubicInfo.Sys_dept,
                        //     Area: cubicInfo.Sys_Area,
                        //     Nom: '1.0',
                        //     PrTime: date.format(now, 'HH:mm:ss'),
                        //     PrDate: date.format(now, 'YYYY-MM-DD'),
                        //     MPN_Code: cubicInfo.Sys_MPNCode
                        // }

                        // await objBatchSummary.saveBatchSummaryFriability1(batchSummaryObject, strDsNo);






                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                            globalData.arrWeighmentCounterForFriab :
                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                        globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                            globalData.arrWeighmentCounterAfter :
                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);



                        if (count == 0) {

                        }
                        // setTimeout(() => { mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.TestCompleted} Test Completed`) }, 1000);



                    } else {

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }

                } else if (tempCounterObj.counter == 0 && tempCounterObjAfter.counter == 1) {
                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                    globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                        globalData.arrWeighmentCounterAfter :
                        globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);




                }

            }

        } catch (error) {
            console.log(error)
        }
    }

    async calculateMasterSerialNo(obj) {
        let masterTable = obj.tableName
        let mstSrNo;
        let data = await models[masterTable].findAll({
            attributes: [
                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSerNo"],
                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
            ],
            where: {
                ProductName: obj.ProductName,
                BatchNo: obj.Batch,
                PVersion: obj.PVersion,
                Version: obj.Version,
                BFGCode: obj.BFGCode,
                MPN_Code: obj.MPN,
                // CubicleType: obj.CubType,
                // ReportType: obj.RptType,
            },
        })

        if (data[data.length - 1].mstSerNo != null) {
            mstSrNo = data[data.length - 1].mstSerNo + 1
        } else {
            // let data2 = await models[masterTable].findAll({
            //     attributes: [
            //         // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
            //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSerNo"],
            //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
            //     ],
            //     where: {
            //         ProductName: obj.ProductName,
            //         PVersion: obj.PVersion,
            //         Version: obj.Version,       
            //         CubicleType: obj.CubType,
            //         ReportType: obj.RptType,
            //     },
            // })

            // if(data2[data2.length-1].mstSerNo!=null){
            //     mstSrNo = data2[data2.length-1].mstSerNo + 1;
            // }else{
            //     mstSrNo = 1;
            // }

            mstSrNo = 1
        }

        return mstSrNo;
    }

    async saveToBalanceCompleteData(data, friDetail) {
        try {
            let strHmi = data.strHmi;
            let strIdsNo = data.uniqueSerialNumber;
            const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let sample = parseFloat(FriabilityDetail1.data.noOfSample);
            let Side = FriabilityDetail1.data.Side;


            let selectedIdsNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.Hmi == strHmi);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            //     strHmi = strHmi;
            // }

            var cubicData = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: strHmi
                }
            })
            let IPQC = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let setDataAccToColunSingle = 0;
            let setDataAccToColunDouble = 0;
            if (IPQC.Sys_RptType == 'Double') {
                setDataAccToColunDouble = data.receiveWt;
            } else {
                setDataAccToColunSingle = data.receiveWt;
            }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData; //idsNo

            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let productObj = data.objProductDetails;
            let productParams = data.productType;
            let now = new Date();

            let __paramProductData = {
                ProductId: productObj.ProductId,
                ProductName: productObj.ProductName,
                ProductVersion: productObj.ProductVersion,
                Version: productObj.Version,
                Batch: data.Batch,
                Side: Side,
                // uniqueSerialNumber: data.uniqueSerialNumber
                uniqueSerialNumber: strHmi
            }

            var result = await this.checkProductData(__paramProductData, strHmi);
            var intMstSerNo;

            if (result.length <= 0) {
                intMstSerNo = 1;
            } else {
                var newMstSerNo = result[0].SeqNo + 1;
                intMstSerNo = newMstSerNo;
            }
            // if (Side == 'RHS') {
            //     intMstSerNo = result[0].SeqNo
            // } else {
            //     intMstSerNo = result[0].SeqNo + 1
            // }


            let bRepSerNo = await this.getMaxBRepSerNo(productObj.ProductName, hmiDetailsInPMenu.Sys_Batch, "tbl_tab_master8", hmiDetailsInPMenu.Sys_RptType, hmiDetailsInPMenu.Sys_CubType)
            // let resultCompleteData = await database.save(saveFriData);
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }
            let resultCompleteData = await models.tbl_tab_master8.create({
                'MstSerNo': intMstSerNo,
                'InstruId': 0,
                'BFGCode': productObj.ProductId,
                'ProductName': productObj.ProductName,
                'ProductType': productObj.ProductType,
                'Qty': sample,
                'GrpQty': sample,
                // 'GrpFreq': productObj.ProductType,
                'Idsno': strHmi,
                'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                'BalanceId': hmiDetailsInPMenu.Sys_BalID,
                // "FriabilityID": hmiDetailsInPMenu.Sys_FriabID,
                'FriabilityID': cubicData[0].Sys_FriabID,
                // 'BalanceNo': hmiDetailsInPMenu.Sys_CubicNo,
                // 'VernierId': hmiDetailsInPMenu.Sys_CubicNo,
                // 'VernierNo': hmiDetailsInPMenu.Sys_CubicNo,
                'BatchNo': hmiDetailsInPMenu.Sys_Batch,
                'UserName': FriabilityDetail1.data.userName,
                'UserId': FriabilityDetail1.data.userId,
                'PrDate': moment().format('YYYY-MM-DD'),
                'PrTime': moment().format('HH:mm:ss'),
                // 'PrEndDate': hmiDetailsInPMenu.Sys_CubicNo,
                // 'PrEndTime': hmiDetailsInPMenu.Sys_CubicNo,
                'Side': Side,
                'Unit': hmiDetailsInPMenu.Sys_CubicNo,
                //    'DecimalPoint': hmiDetailsInPMenu.Sys_CubicNo,
                'WgmtModeNo': 8,
                'NMT': productParams.nominal.toFixed(2),
                'SetCount': productParams.T1Neg,
                'SetRPM': productParams.T1Pos,
                // 'T2NegTol': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T2PosTol': hmiDetailsInPMenu.Sys_CubicNo,
                'limitOn': data.productType.LimitOn,
                // 'T1NMTTab': hmiDetailsInPMenu.Sys_CubicNo,
                // 'NomEmpty': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T1NegEmpty': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T1PosEmpty': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T2NegEmpty': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T2PosEmpty': hmiDetailsInPMenu.Sys_CubicNo,
                // 'NomNet': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T1NegNet': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T1PosNet': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T2NegNet': hmiDetailsInPMenu.Sys_CubicNo,
                // 'T2PosNet': hmiDetailsInPMenu.Sys_CubicNo,
                'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                'ReportType': hmiDetailsInPMenu.Sys_RptType,
                'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                'MFGCode': hmiDetailsInPMenu.Sys_Stage,
                'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': hmiDetailsInPMenu.Sys_CubicNo,
                // 'HardnessID': hmiDetailsInPMenu.Sys_CubicNo,
                'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                'CubicleLocation': hmiDetailsInPMenu.Sys_Area,
                // 'RepoLabel10': hmiDetailsInPMenu.Sys_Area,
                // 'RepoLabel11': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel12': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel13': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel14': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel15': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel16': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel17': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel18': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel19': hmiDetailsInPMenu.Sys_CubicNo,
                // 'RepoLabel20': hmiDetailsInPMenu.Sys_CubicNo,
                'PrintNo': 0,
                'IsArchived': 0,
                'GraphType': 'Standard',
                // 'BatchComplete': hmiDetailsInPMenu.Sys_CubicNo,
                'PVersion': productObj.ProductVersion,
                'Version': productObj.Version,
                // 'CheckedByID': hmiDetailsInPMenu.Sys_CubicNo,
                // 'CheckedByName': hmiDetailsInPMenu.Sys_CubicNo,
                // 'CheckedByDate': hmiDetailsInPMenu.Sys_CubicNo,
                // 'BRepSerNo': hmiDetailsInPMenu.Sys_CubicNo,
                'Lot': hmiDetailsInPMenu.Sys_LotNo,
                // 'Area': hmiDetailsInPMenu.Sys_CubicNo,
                // 'SideNo': hmiDetailsInPMenu.Sys_CubicNo,
                // 'AppearanceDesc': hmiDetailsInPMenu.Sys_CubicNo,
                // 'MachineSpeed_Min': hmiDetailsInPMenu.Sys_CubicNo,
                // 'MachineSpeed_Max': hmiDetailsInPMenu.Sys_CubicNo,
                // 'GenericName': hmiDetailsInPMenu.Sys_CubicNo,
                // 'BMRNo': hmiDetailsInPMenu.Sys_CubicNo,
                // 'IsPrintable': hmiDetailsInPMenu.Sys_CubicNo,
                // 'Stage': hmiDetailsInPMenu.Sys_CubicNo,
                //'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                // 'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                // 'UserId': tempUserObject.UserId,
                // 'BatchNo': hmiDetailsInPMenu.Sys_Batch,
                // 'UserName': tempUserObject.UserName,
                // 'PrDate': date.format(now, 'YYYY-MM-DD'),
                // 'PrTime': date.format(now, 'HH:mm:ss'),
                // 'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                // 'PrEndTime': date.format(now, 'HH:mm:ss'),
                //  'Side': hmiDetailsInPMenu.Sys_RotaryType,
                // //'Unit': hmiDetailsInPMenu.Sys_BatchSizeUnit ,
                'Unit': 'g',
                // 'DecimalPoint': 0,
                // 'WgmtModeNo': 8,
                // 'FriNMTLimit': friDetail.productDetail.Param8_Nom,
                // 'SetCount': friDetail.productDetail.Param8_T1Neg,
                // 'SetRPM': friDetail.productDetail.Param8_T1Pos,
                // 'FriabilityQty': '10',
                //  'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                // 'ReportType': hmiDetailsInPMenu.Sys_RptType,
                // 'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                //    'MFGCode': hmiDetailsInPMenu.Sys_MfgCode,
                // 'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': CurrentCubicalObj.Sys_FriabID,
                // 'NWtBeforeTest': setDataAccToColunSingle,
                // 'NWtAfterTest': 0,
                // 'LWtBeforeTest': setDataAccToColunDouble,
                // //'LWtAfterTest': data.WTAD1 ,
                // //'RWtBeforeTest': data.WTBD2 ,
                // //'RWtAfterTest': data.WTAD2 ,
                // 'PrintNo': 0,
                // 'IsArchived': 0,
                // 'BalanceId': CurrentCubicalObj.Sys_BalID,
                // 'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                // 'Version': hmiDetailsInPMenu.Sys_Version,
                'BRepSerNo': bRepSerNo,
                // 'RepoLabel11': hmiDetailsInPMenu.Sys_Validation,
                // 'Lot': 'LotNo',
                // 'ActualCount': 25,
                // 'ActualRPM': 100,
                'Area': hmiDetailsInPMenu.Sys_Area,
                // 'AppearanceDesc': hmiDetailsInPMenu.Sys_Appearance,
                // 'MachineSpeed_Min': hmiDetailsInPMenu.Sys_MachineSpeed_Min,
                // 'MachineSpeed_Max': hmiDetailsInPMenu.Sys_MachineSpeed_Max,
                // 'GenericName': hmiDetailsInPMenu.Sys_GenericName,
                'BMRNo': hmiDetailsInPMenu.Sys_BMRNo,
                Stage: hmiDetailsInPMenu.Sys_Stage,
                // Interval: FriabilityDetail1.data.interval
            })
            var lastInsertedID = resultCompleteData.MstSerNo;
            var RepSerNo = resultCompleteData.RepSerNo;
            return {
                lastInsertedID: lastInsertedID,
                masterRepSerNo: RepSerNo
            };
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }

    async checkProductData(productObj, selectedIdsNo = "") {
        try {
            // const checkData = {
            //     str_tableName: 'tbl_tab_friability',
            //     data: 'MAX(MstSerNo) AS SeqNo ,MAX(RepSerNo) AS RepSerNo',
            //     condition: [
            //         { str_colName: 'BFGCode', value: productObj.ProductId, comp: 'eq' },
            //         { str_colName: 'ProductName', value: productObj.ProductName, comp: 'eq' },
            //         { str_colName: 'PVersion', value: productObj.ProductVersion, comp: 'eq' },
            //         { str_colName: 'Version', value: productObj.Version, comp: 'eq' },
            //         { str_colName: 'BatchNo', value: productObj.Batch, comp: 'eq' },
            //         { str_colName: 'IdsNo', value: productObj.uniqueSerialNumber, comp: 'eq' },
            //     ]
            // }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.DsNo == selectedIdsNo).cubicalData;

            // var result = await database.select(checkData);
            var result = await models.tbl_tab_master8.findAll({
                attributes: [
                    [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                    [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                ],
                where: {
                    'BFGCode': productObj.ProductId,
                    'ProductName': productObj.ProductName,
                    'PVersion': productObj.ProductVersion,
                    'Version': productObj.Version,
                    'BatchNo': productObj.Batch,
                    'ReportType': hmiDetailsInPMenu.Sys_RptType,
                    Side: productObj.Side,
                    CubicleName: productObj.cubicleName,
                    CubicalNo: productObj.cubicleNo,
                    CubicleType: productObj.cubType
                    // 'IdsNo': hmiDetailsInPMenu.Sys_IDSNo,
                },
                raw: true
            })
            return result;
        } catch (error) {
            throw new Error(error);
        }
    }

    AddMinutesToDate(date, minutes) {
        return moment(date.add(minutes, 'minutes')).format('YYYY-MM-DD HH:mm:ss')

        // return new Date(date.getTime() + minutes * 60000);
    }

    DateFormat(date) {
        var days = date.getDate();
        var year = date.getFullYear();
        var month = (date.getMonth() + 1);
        var hours = date.getHours();
        var minutes = date.getMinutes();
        minutes = minutes < 10 ? '0' + minutes : minutes;
        var strTime = month + '/' + days + '/' + year + ' ' + hours + ':' + minutes;
        //var strTime = hours + ':' + minutes;
        return strTime;
    }

    /**
     * process BFBO 
     */
    async processBFBO(dataObj) {
        let strHmi = dataObj.Hmi;
        let strIdsNo = dataObj.idsNo;
        let receiveWt = dataObj.actualWt;
        let unit = dataObj.unit;
        await this.insertFriabilityOnBal(strHmi, strIdsNo, receiveWt);
    }

    async insertFriabilityOnBal(strHmi, IdsNo, protocol) {
        try {
            let now = new Date();
            var actualProtocol = protocol;
            let selectedIds;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            //var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
            var CurrentCubic = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
            if (IPQCObject != undefined) {
                selectedIds = IPQCObject.selectedIds;
            } else {
                selectedIds = IdsNo;
            }
            var tempCubic = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
            var objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);

            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);
            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounterForFriab.push({ 'Hmi': strHmi, 'counter': 0 })
            }
            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);

            if (tempCubic.Sys_RotaryType == "Double") {

                if (objFriBal == undefined) {
                    globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                } else {
                    objFriBal.dataValue2 = actualProtocol;
                }
            } else {
                if (objFriBal == undefined) {
                    globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                } else {
                    objFriBal.dataValue1 = actualProtocol;
                }
            }

            objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
            var menuDetailsArr = globalData.arr_limits.find(k => k.idsNo == IdsNo);
            let tempLimits = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == 'Friability')[0]['Friability'];
            // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
            var productObj = globalData.arrProductTypeArray.find(k => k.idsNo == IdsNo);
            var rwtAfterTest, rwtBeforeTest, nwtAfterTest, nwtBeforeTest, lwtAfterTest, lwtBeforeTest, decimalPoint;
            var ActualRPM = "";
            var ActualCount = ""
            var intervalFound;




            // var tdValue = actualProtocol.substring(0, 5);//starting 
            // var recPrtotocol = actualProtocol.substring(7).trim().split(" ");
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let retuRes = await this.checkFriabilityStatus(IdsNo);

            if (retuRes.status == 'before') {
                if (tempCubic.Sys_RotaryType == 'Double') {
                    tempCounterObj.counter += 1; //counter only for Double rotary
                    lwtBeforeTest = objFriBal.dataValue1;
                    rwtBeforeTest = objFriBal.dataValue2;
                    nwtBeforeTest = 0;
                    decimalPoint = await this.precision(Number(objFriBal.dataValue1))
                } else {
                    lwtBeforeTest = 0;
                    rwtBeforeTest = 0;
                    nwtBeforeTest = objFriBal.dataValue1;
                    decimalPoint = await this.precision(Number(objFriBal.dataValue1))
                }
                var res = await proObj.productData(tempCubic);
                const checkData = {
                    str_tableName: 'tbl_tab_friability',
                    data: 'MAX(MstSerNo) AS SeqNo',
                    condition: [
                        { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
                        { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
                        { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
                        { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
                        { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
                        { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
                        { str_colName: 'CubicleType', value: tempCubic.Sys_CubType, comp: 'eq' },
                        { str_colName: 'RepoLabel10', value: tempCubic.Sys_IPQCType, comp: 'eq' },
                    ]
                }
                var result = await database.select(checkData);
                var intMstSerNo;
                if (retuRes.status == 'before') {
                    if (result[0][0].SeqNo == null) {
                        intMstSerNo = 1;
                    } else {
                        intMstSerNo = result[0][0].SeqNo;
                    }
                } else {
                    if (result[0][0].SeqNo == null) {
                        intMstSerNo = 1;
                    } else {
                        var newMstSerNo = result[0][0].SeqNo + 1;
                        intMstSerNo = newMstSerNo;
                    }
                }

                let bRepSerNo = await this.getMaxBRepSerNo(tempCubic.Sys_ProductName, tempCubic.Sys_Batch, 'tbl_tab_friability', tempCubic.Sys_RptType)

                if (tempCounterObj.counter == 1 || tempCubic.Sys_RotaryType == 'Single') {
                    var saveFriData = {
                        str_tableName: 'tbl_tab_friability',
                        data: [
                            { str_colName: 'MstSerNo', value: intMstSerNo },
                            { str_colName: 'InstruId', value: 0 },
                            { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode },
                            { str_colName: 'ProductName', value: tempCubic.Sys_ProductName },
                            { str_colName: 'ProductType', value: productObj.productType.ProductType },
                            { str_colName: 'IdsNo', value: selectedIds },
                            { str_colName: 'CubicalNo', value: tempCubic.Sys_CubicNo },
                            { str_colName: 'CubicleName', value: tempCubic.Sys_CubicName },
                            { str_colName: 'CubicleLocation', value: tempCubic.Sys_dept },
                            { str_colName: 'BatchNo', value: tempCubic.Sys_Batch },
                            //{ str_colName: 'NoOfSample', value: productObj.Sys_Batch },
                            { str_colName: 'UserId', value: tempUserObject.UserId },
                            { str_colName: 'UserName', value: tempUserObject.UserName },
                            { str_colName: 'PrDate', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'PrTime', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'Side', value: tempCubic.Sys_RotaryType },
                            { str_colName: 'Unit', value: 'g' },
                            { str_colName: 'DecimalPoint', value: decimalPoint },
                            { str_colName: 'WgmtModeNo', value: 8 },
                            { str_colName: 'FriNMTLimit', value: parseFloat(res[1].Param8_Nom) },
                            { str_colName: 'SetCount', value: parseFloat(res[1].Param8_T1Neg) },
                            { str_colName: 'SetRPM', value: parseFloat(res[1].Param8_T1Pos) },
                            { str_colName: 'FriabilityQty', value: tempLimits.noOfSamples },
                            { str_colName: 'CubicleType', value: tempCubic.Sys_CubType },
                            { str_colName: 'RepoLabel10', value: tempCubic.Sys_IPQCType },
                            { str_colName: 'ReportType', value: tempCubic.Sys_RptType },
                            { str_colName: 'MachineCode', value: tempCubic.Sys_MachineCode },
                            { str_colName: 'MFGCode', value: tempCubic.Sys_MfgCode },
                            { str_colName: 'BatchSize', value: `${tempCubic.Sys_BatchSize} ${tempCubic.Sys_BatchSizeUnit}` },
                            { str_colName: 'FriabilityID', value: CurrentCubic.Sys_FriabID },
                            { str_colName: 'NWtBeforeTest', value: nwtBeforeTest },
                            // { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                            { str_colName: 'LWtBeforeTest', value: lwtBeforeTest },
                            // { str_colName: 'LWtAfterTest', value: lwtAfterTest },
                            //{ str_colName: 'RHSSrNo', value: productObj.CubicleType },
                            { str_colName: 'RWtBeforeTest', value: rwtBeforeTest },
                            // { str_colName: 'RWtAfterTest', value: rwtAfterTest },
                            { str_colName: 'PrintNo', value: 0 },
                            { str_colName: 'IsArchived', value: 0 },
                            //{ str_colName: 'BatchComplete', value: date.format(now, 'HH:mm:ss') },
                            //{ str_colName: 'GraphType', value: productObj.HardnessID },
                            { str_colName: 'BalanceId', value: CurrentCubic.Sys_BalID },
                            { str_colName: 'PVersion', value: tempCubic.Sys_PVersion },
                            { str_colName: 'Version', value: tempCubic.Sys_Version },
                            //{ str_colName: 'CheckedByID', value: productObj.RepoLabel11 },
                            //{ str_colName: 'CheckedByName', value: productObj.Sys_BalID },
                            //{ str_colName: 'CheckedByDate', value: productObj.RepoLabel13 },
                            //{ str_colName: 'Stage', value: productObj.PrintNo },
                            //objLotData.LotNo
                            { str_colName: 'BRepSerNo', value: bRepSerNo },
                            { str_colName: 'RepoLabel11', value: tempCubic.Sys_Validation },
                            { str_colName: 'Lot', value: 'NA' },
                            // { str_colName: 'ActualCount', value: parseFloat(res[1].Param8_T1Neg) },
                            // { str_colName: 'ActualRPM', value: parseFloat(res[1].Param8_T1Pos) },
                            { str_colName: 'Area', value: tempCubic.Sys_Area },
                            { str_colName: 'AppearanceDesc', value: tempCubic.Sys_Appearance },
                            { str_colName: 'MachineSpeed_Min', value: tempCubic.Sys_MachineSpeed_Min },
                            { str_colName: 'MachineSpeed_Max', value: tempCubic.Sys_MachineSpeed_Max },
                            { str_colName: 'GenericName', value: tempCubic.Sys_GenericName },
                            { str_colName: 'BMRNo', value: tempCubic.Sys_BMRNo },


                        ]
                    }
                    //console.log(saveFriData);
                    await database.save(saveFriData);
                } else {
                    let updateFriability = {
                        str_tableName: 'tbl_tab_friability',
                        data: [
                            { str_colName: 'RWtBeforeTest', value: rwtBeforeTest },
                            { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                            { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                        ],
                        condition: [
                            { str_colName: 'RepSerNo', value: retuRes.sqNo },
                        ]
                    }
                    await database.update(updateFriability);
                }

                //objMonitor.monit({ case: 'FRIFINWT', idsNo: IdsNo, data: { test: 'FRIABILITY' } });
                // As soon as Before weight is taken the we have to hide menu for specific time
                var objActivity = {};
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { batch: tempCubic.Sys_Batch },
                    { activity: 'Friability Weighment Started on IDS' + IdsNo });
                await objActivityLog.ActivityLogEntry(objActivity)
                // Instrument usage for Friability completed
                if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                    var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                    if (IPQCObject != undefined) {
                        selectedIds = IPQCObject.selectedIds;
                    } else {
                        selectedIds = IdsNo;
                    }
                    var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                    tempBFBO.before = true;
                }
                await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', 'Friability Weighment', 'started')
                await this.updateFriabilityTime(IdsNo, tempLimits);
                if (tempCubic.Sys_RotaryType == 'Double') {
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${lwtBeforeTest} g`);
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2:${rwtBeforeTest} g`)

                } else {
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${nwtBeforeTest} g`);
                }

                return true;

            } else {
                //FrabilityOnBal
                if (tempCounterObj.counter == 2 && tempCubic.Sys_RotaryType == "Double") {
                    globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds) == -1 ?
                        globalData.FrabilityOnBal :
                        globalData.FrabilityOnBal.splice(globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds), 1);
                }


                var objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
                if (tempCubic.Sys_RotaryType == "Double") {

                    if (objFriBal == undefined) {
                        globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                    } else {
                        objFriBal.dataValue2 = actualProtocol;
                    }
                }

                objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
                if (tempCubic.Sys_RotaryType == 'Double') {
                    tempCounterObj.counter += 1; //counter only for Double rotary
                    lwtAfterTest = objFriBal.dataValue1;
                    rwtAfterTest = objFriBal.dataValue2;
                    nwtAfterTest = 0;

                } else {
                    lwtAfterTest = 0;
                    rwtAfterTest = 0;
                    nwtAfterTest = objFriBal.dataValue1;

                }


                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 3) {
                    let updateFriability = await models.tbl_tab_master8.update({
                        LWtAfterTest: lwtAfterTest,
                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                        PrEndTime: date.format(new Date(), 'HH:mm:ss'),

                    }, {
                        where: {
                            RepSerNo: retuRes.sqNo
                        }
                    })
                    // {
                    //     str_tableName: 'tbl_tab_friability',
                    //     data: [
                    //         { str_colName: 'LWtAfterTest', value: lwtAfterTest },
                    //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                    //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                    //     ],
                    //     condition: [
                    //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    //     ]
                    // }

                } if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    let updateFriability = await models.tbl_tab_master8.update({
                        NWtAfterTest: nwtAfterTest,
                        RWtAfterTest: rwtAfterTest,
                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                        PrEndTime: date.format(new Date(), 'HH:mm:ss')
                    }, {
                        where: {
                            RepSerNo: retuRes.sqNo
                        }
                    })
                    // let updateFriability = await 
                    // {
                    //     str_tableName: 'tbl_tab_friability',
                    //     data: [
                    //         { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                    //         { str_colName: 'RWtAfterTest', value: rwtAfterTest },
                    //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                    //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                    //     ],
                    //     condition: [
                    //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    //     ]
                    // }
                    await database.update(updateFriability);
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        let updateFriability = await models.tbl_tab_master8.update({
                            NWtAfterTest: nwtAfterTest,
                            PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                            PrEndTime: date.format(new Date(), 'HH:mm:ss')
                        }, {
                            where: {
                                RepSerNo: retuRes.sqNo
                            }
                        })
                        // let updateFriability = {
                        //     str_tableName: 'tbl_tab_friability',
                        //     data: [
                        //         { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                        //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                        //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                        //     ],
                        //     condition: [
                        //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                        //     ]
                        // }
                        await database.update(updateFriability);
                    }

                }


                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                        // if (IPQCObject != undefined) {
                        //     selectedIds = IPQCObject.selectedIds;
                        // } else {
                        //     selectedIds = IdsNo;
                        // }
                        var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                        tempBFBO.before = false;
                        tempBFBO.setParam = false;
                        tempBFBO.after = false;
                    }
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                            // if (IPQCObject != undefined) {
                            //     selectedIds = IPQCObject.selectedIds;
                            // } else {
                            //     selectedIds = IdsNo;
                            // }
                            var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                            tempBFBO.before = false;
                            tempBFBO.setParam = false;
                            tempBFBO.after = false;
                        }
                    }

                }


                // Selecting the value from friability
                var selectObj = {
                    str_tableName: 'tbl_tab_friability',
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                let friabilityInfo = await database.select(selectObj);
                // if (serverConfig.ProjectName == 'MLVeer') {
                //     // Added for only MLVERR on 30/05/2020
                //     var SPresu = await objSP.PercentageCalculationForFriability(retuRes.sqNo);
                // }

                //insert batch summary and clear the array
                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    let batchSummaryObject = {
                        BFGCode: tempCubic.Sys_BFGCode,
                        ProductName: tempCubic.Sys_ProductName,
                        PVersion: tempCubic.Sys_PVersion,
                        Version: tempCubic.Sys_Version,
                        PrdType: 1,
                        CubType: tempCubic.Sys_CubType,
                        BatchNo: tempCubic.Sys_Batch,
                        Unit: 'g',
                        Side: tempCubic.Sys_RotaryType,
                        InstrumentID: CurrentCubic.Sys_BalID,
                        UserId: tempUserObject.UserId,
                        UserName: tempUserObject.UserName,
                        nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
                        nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
                        lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
                        lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
                        rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
                        rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
                        Dept: tempCubic.Sys_dept,
                        Nom: friabilityInfo[0][0].FriNMTLimit,
                        PrTime: date.format(now, 'HH:mm:ss'),
                        PrDate: date.format(now, 'YYYY-MM-DD'),
                        ReportType: 0,
                        DP: friabilityInfo[0][0].DecimalPoint
                    }
                    await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo);
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: tempCubic.Sys_Batch },
                        { activity: `FRIAB Weighment Completed on IDS ${strHmi} For Side ${FriabilityDetail1.data.Side}` });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    // Instrument usage for Friability completed
                    await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

                    var response = await objSP.getRemarkForFriability(retuRes.sqNo);

                    if (tempCubic.Sys_RotaryType == 'Double') {
                        var netWtD1 = Math.round(friabilityInfo[0][0].LWtAfterTest - friabilityInfo[0][0].LWtBeforeTest);
                        var netWtD2 = Math.round(friabilityInfo[0][0].RWtAfterTest - friabilityInfo[0][0].RWtBeforeTest);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].LWtBeforeTest} g;WTAD1:${friabilityInfo[0][0].LWtAfterTest} g;NWTD1:${netWtD1} g`);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2 : ${friabilityInfo[0][0].RWtBeforeTest} g;WTAD2:${friabilityInfo[0][0].RWtAfterTest} g;NWTD2:${netWtD2} g`)

                    }



                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);
                    //need to check response of remark 
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
                    globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrBFBO :
                        globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                    (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                    //test splice if rotarty is not double
                    globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrSelectedMenu :
                        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                    mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability Test Completed`);
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        let batchSummaryObject = {
                            BFGCode: tempCubic.Sys_BFGCode,
                            ProductName: tempCubic.Sys_ProductName,
                            PVersion: tempCubic.Sys_PVersion,
                            Version: tempCubic.Sys_Version,
                            PrdType: 1,
                            CubType: tempCubic.Sys_CubType,
                            BatchNo: tempCubic.Sys_Batch,
                            Unit: 'g',
                            Side: tempCubic.Sys_RotaryType,
                            InstrumentID: CurrentCubic.Sys_BalID,
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
                            nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
                            lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
                            lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
                            rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
                            rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
                            Dept: tempCubic.Sys_dept,
                            Nom: friabilityInfo[0][0].FriNMTLimit,
                            PrTime: date.format(now, 'HH:mm:ss'),
                            PrDate: date.format(now, 'YYYY-MM-DD'),
                            ReportType: 0,
                            DP: friabilityInfo[0][0].DecimalPoint
                        }
                        await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo);
                        var objActivity = {};
                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { batch: tempCubic.Sys_Batch },
                            { activity: `FRIAB Weighment Completed on IDS ${strHmi} For Side ${FriabilityDetail1.data.Side}` });
                        await objActivityLog.ActivityLogEntry(objActivity);
                        // Instrument usage for Friability completed
                        await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

                        var response = await objSP.getRemarkForFriability(retuRes.sqNo);
                        var netWtforSingle = Math.round(friabilityInfo[0][0].NWtAfterTest - friabilityInfo[0][0].NWtBeforeTest);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].NWtBeforeTest};WTAD1:${friabilityInfo[0][0].NWtAfterTest} g;NWTD1:${netWtforSingle} g`);


                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);


                        //need to check response of remark 
                        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
                        globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrBFBO :
                            globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrWeighmentCounterForFriab :
                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                        //test splice if rotarty is not double
                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrSelectedMenu :
                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Test Completed`);
                    }
                }





                return;
            }
        } catch (error) {
            console.log(error)
            return error;
        }
    }


    async checkFriabilityStatus(IdsNo) {
        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
        var selectedIds;
        var returnResult = {};
        if (IPQCObject != undefined) {
            selectedIds = IPQCObject.selectedIds;
        } else {
            selectedIds = IdsNo;
        }
        var tempCubic = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
        const checkData = {
            str_tableName: 'tbl_tab_friability',
            data: 'MAX(RepSerNo) AS SeqNo',
            condition: [
                { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
                { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
                { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
                { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
                { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
                { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
            ]
        }
        var checkFlag = 0;
        var chkResult = await database.select(checkData);
        var result = [];
        if (chkResult[0][0].SeqNo == null) {
            checkFlag = 0;
        } else {
            checkFlag = 1;
        }
        if (checkFlag == 1) {
            var fraibData = {
                str_tableName: 'tbl_tab_friability',
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: chkResult[0][0].SeqNo, comp: 'eq' },
                ]
            }
            result = await database.select(fraibData);
            result = result[0]
        }
        if (result.length > 0) {
            if (tempCubic.Sys_RotaryType == 'Double') {
                if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                }
                else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })


                } else if (result[0].LWtBeforeTest == 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            } else {
                if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest == 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            }
        } else {
            Object.assign(returnResult, { status: 'before', sqNo: 0 })

        }
        return returnResult;
    }

    async updateFriabilityTime(IdsNo, tempLimits) {
        try {
            // Fetching global array for Fraibitlity
            var selectedIds = IdsNo;;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            // if (IPQCObject != undefined) {
            //     selectedIds = IPQCObject.selectedIds;
            // } else {
            //     selectedIds  = IdsNo;
            // }
            let COUNT = parseFloat(tempLimits.T1Neg);
            let RPM = parseFloat(tempLimits.T1Pos);
            let SECONDS = (COUNT / RPM) * 60
            // var tempOBJ = globalData.arrFriabilityMenuVisibility.find(k => k.idsNo == selectedIds);
            // tempOBJ.ETS = SECONDS;
            // console.log(globalData.arrFriabilityMenuVisibility)
        } catch (err) {
            console.log(err);
            return err
        }
    }

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    /**
     * Fribilator Bulk Data
     */
    async insertBulkFriabilityComb(_paramObj) {
        try {
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
            let strHmi = _paramObj.Hmi;
            let strIdsNo = _paramObj.idsNo;
            let receiveWt = _paramObj.actualWt;
            let unit = _paramObj.unit;
            // if (IPQCObject != undefined) {
            //     selectedIds = IPQCObject.selectedIds;
            // } else {
            //     selectedIds = IdsNo;
            // }
            let cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo);
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

            var objActivity = {};
            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { batch: cubicalData.cubicalData.Sys_Batch },
                { activity: 'Friabilator Started on IDS' + strIdsNo });
            await objActivityLog.ActivityLogEntry(objActivity);
            // Instrument usage for Friability started
            // objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', 'Friability', 'started');

            let retuRes = await this.checkFriabilityStatus(strIdsNo);

            if (retuRes.status != 'before') {
                var updateFriability = {
                    str_tableName: 'tbl_tab_friability',
                    data: [
                        { str_colName: 'ActualCount', value: _paramObj.rpm },
                        { str_colName: 'ActualRPM', value: _paramObj.rpmCount },
                    ],
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                await database.update(updateFriability);


                var selectFriability = {
                    str_tableName: 'tbl_tab_friability',
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                let getBeforeWt = await database.select(selectFriability);

                /**
                 * getting before weight for double and single
                 */

                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                }


                var objActivity = {};
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { batch: cubicalData.cubicalData.Sys_Batch },
                    { activity: 'Friabilator String completed on IDS' + strIdsNo });
                await objActivityLog.ActivityLogEntry(objActivity);
                objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

                if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                    var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == strIdsNo);
                    tempBFBO.setParam = true;
                }


                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                }


            } else {
                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                }
            }

        } catch (err) {
            throw new Error(err);
        }
    }

    async getMaxBRepSerNo(productName, strBatch, strTableName, reportType, cubType) {
        try {
            const tblDetails = await models[strTableName].findAll({
                where: {
                    // PVersion: selectedCub.Sys_PVersion,
                    // Version: selectedCub.Sys_Version,
                    BatchNo: strBatch,
                    // BFGCode: dataObj.objProductDetails.ProductId,
                    ProductName: productName,
                    ReportType: reportType,
                    // CubicleType:cubType

                }
            }
            )
            // const tblDetails1 = await models[incomplete].findAll({
            //     where: {
            //         // PVersion: selectedCub.Sys_PVersion,
            //         // Version: selectedCub.Sys_Version,
            //         BatchNo: strBatch,
            //         // BFGCode: dataObj.objProductDetails.ProductId,
            //         ProductName: productName,
            //         ReportType:reportType,

            //     }
            // }
            // )

            if (tblDetails.length != 0) {
                let maxColumn = tblDetails.length >= 1 ? tblDetails.pop() : tblDetails;
                // if (tblDetails.length != 0) {
                //     let maxColumninc = tblDetails1.length >= 1 ? tblDetails1.pop() : tblDetails1
                let BRepSerNo = maxColumn.BRepSerNo + 1
                return BRepSerNo;
            } else {
                return 1
            }
        } catch (error) {
            throw new Error()
        }
    }




    async processBalanceFriabilityInitialNextButtonFunctionality(dataObj) {
        try {
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let actualWt = dataObj.actualWt;
            let invalidUnitFlag = dataObj.invalidUnitFlag;
            let invalidWeightFlag = dataObj.invalidWeightFlag;
            let selectedMenuDetails = dataObj.SelectedMenuDetails
            let protocolPortNo = dataObj.ProtocolPortNo
            let T2Pos = selectedMenuDetails.selectedProductDetail.T2Pos
            let T2Neg = selectedMenuDetails.selectedProductDetail.T2Neg
            let unit = selectedMenuDetails.selectedProductDetail.unit ?? 'gm';
            unit = unit == 'gm' ? 'g' : unit;
            let dp = selectedMenuDetails.selectedProductDetail.dp
            let FriabRotaryType = selectedMenuDetails.rotary ?? 'LHS';
            // let FriabRotaryType = 'LHS';
            let nominal = selectedMenuDetails?.selectedProductDetail?.Nominal ?? 1.0;
            // let rpmValue = selectedMenuDetails?.selectedProductDetail?.RPM ?? '00:04:00';
            let rpmValue = Global_Nomenclature.StaticFriabilityRange;
            let rpm = parseInt(rpmValue.split(':')[1])
            let cubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp).cubicalData
            let getTableName = objCommonWeightment.getTableName(cubicInfo, 'Friability', strDsNo, strTabIp)
            let masterTable = cubicInfo.Sys_RptType != undefined ? getTableName.masterTableIncomplete : getTableName.masterTable;
            let exceptionTable = cubicInfo.Sys_RptType ? 'tbl_exception_sample_initial' : 'tbl_exception_sample'

            // Nominal ki condition handle karni hai

            // if(invalidUnitFlag){
            //     return mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Invalid Unit Recieved`)
            // }


            let arrseelcted = globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp)


            let repSerNo;

            let NLT = await models.tbl_cubicle_product_sample.findOne({
                where: {
                    Sys_CubicNo: cubicInfo.Sys_CubicNo
                }
            })

            // let NLTWeight = NLT.Friability.split(' ')[1]
            let NLTWeight = 6.50

            // this db call for checking ipqc

            let ipcCubicData = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: strDsNo
                }
            })

            // if ipqc then cubical details changes
            let cubicleName = cubicInfo.Sys_CubicName
            let cubicleNo = cubicInfo.Sys_CubicNo
            let cubType = cubicInfo.Sys_CubType

            if (cubicInfo.Sys_CubicNo != ipcCubicData.Sys_CubicNo || cubicInfo.Sys_CubType != ipcCubicData.Sys_CubType) {
                cubicleName = ipcCubicData.Sys_CubicName
                cubicleNo = ipcCubicData.Sys_CubicNo
                cubType = ipcCubicData.Sys_CubType
            }

            let userInfo = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)

            let whereObj = {};

            let InitialWt = 'InitialWt';
            let FinalWt = 'FinalWt';
            let FriabVal = 'FriabVal';
            let sideNo = FriabRotaryType == 'RHS' ? 1 : 0;
            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: cubicleNo,
                    Sys_Batch: cubicInfo.Sys_Batch,
                    WeighmentName: 'FRIAB',
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    Side_RepSerNo: sideNo,
                    MPN_Code: cubicInfo.Sys_MPNCode
                }
            })

            powerbacc = powerbacc.pop();

            if (cubicInfo.Sys_RptType != undefined) {
                InitialWt = 'BeforeValue';
                FinalWt = 'AfterValue';
                FriabVal = 'NetValue'

                let menuSequence = await models.tbl_menu_sequence.findAll({
                    where: {
                        TabIp: strTabIp,
                        DS_Number: strDsNo,
                    }
                })

                const equipmentData = await models.tbl_machine.findOne({
                    attributes: ['Machine_Punches'],
                    where: { Machine_ID: cubicInfo.Sys_MachineCode }
                })

                repSerNo = menuSequence.length > 0 ? menuSequence[0].RepSerNo : null

                var mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicInfo, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })
                if (repSerNo == 0) {
                    let mstEntry = await models[masterTable].create({
                        MstSerNo: mastSerNo,
                        CubicalNo: cubicInfo.Sys_CubicNo,
                        // CubicleName: cubicInfo.Sys_CubicalName,
                        CubicleName: cubicleName,
                        CubicleType: cubicInfo.Sys_CubType,
                        ProductName: cubicInfo.Sys_ProductName,
                        MPN_Code: cubicInfo.Sys_MPNCode,
                        SFOID: selectedMenuDetails.SFOID,
                        ProductType: 1,
                        Area: cubicInfo.Sys_Area,
                        MachineCode: selectedMenuDetails?.EquipmentCode ?? null,
                        PVersion: cubicInfo.Sys_PVersion,
                        Version: cubicInfo.Sys_Version,
                        BatchNo: cubicInfo.Sys_Batch,
                        BFGCode: cubicInfo.Sys_BFGCode,
                        // Param7_T2NegTol: hardnessneg2,
                        // Param7_T2PosTol: hardnesspos2,
                        // Param3_T2PosTol: thicknespos2,
                        // Param3_T2NegTol: thicknesneg2,
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        ProductName: cubicInfo.Sys_ProductName,
                        UserId: userInfo.UserId,
                        UserName: userInfo.UserName,
                        Idsno: cubicInfo.Sys_DSNumber,
                        BalanceId: cubicInfo.Sys_BalID,
                        Qty: selectedMenuDetails.individualsamplecount,
                        GrpQty: selectedMenuDetails.groupQty,
                        // VernierId: cubicInfo.Sys_VernierID,
                        FriabilityID: (cubicInfo.Sys_FriabID == 'None') ? 'NA' : cubicInfo.Sys_FriabID,
                        // HardnessID: cubicInfo.Sys_HardID,
                        // DTID: cubicInfo.Sys_DTID,
                        PrDate: moment().format('YYYY-MM-DD'),
                        PrTime: moment().format('HH:mm:ss'),
                        IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                        Param8_PrTime: moment().format('HH:mm:ss'),
                        Param8_PrDate: moment().format('YYYY-MM-DD'),
                        Param8_Nom: nominal,
                        Param8_DecimalPoint: dp,
                        Param8_T1Pos: rpm,
                        Param8_Unit: unit,
                        Repetition: cubicInfo.Sys_Repetition,
                        ReportType: cubicInfo.Sys_RptType,
                        NoOfStations: equipmentData.Machine_Punches,
                        Side: cubicInfo.Sys_RotaryType,
                        LHSContainerNo: selectedMenuDetails.LHSContainerNo,
                        RHSContainerNo: selectedMenuDetails.RHSContainerNo,
                        MesTestType: cubicInfo.MesTestType,
                        MesSide: cubicInfo.MesSide,

                    })


                    await models.tbl_menu_sequence.update({
                        RepSerNo: mstEntry.RepSerNo
                    }, {
                        where: {
                            DS_Number: strDsNo,
                            TabIp: strTabIp
                        }
                    })


                    repSerNo = mstEntry.RepSerNo


                } else {
                    var masterIncompData = await models[masterTable].findOne({
                        where: {
                            RepSerno: repSerNo
                        }
                    })
                    if(!powerbacc) {
                        let objdates = {
                            Param8_PrDate: moment().format("YYYY-MM-DD"),
                            Param8_PrTime: moment().format("HH:mm:ss")
                        }
                        // let parseDatesObj = objCommonInsertOpt.parseJSON(masterIncompData.dates_json, objdates)
                        await models[masterTable].update({
                            Param8_PrTime: moment().format('HH:mm:ss'),
                            Param8_PrDate:  moment().format('YYYY-MM-DD'),
                            // Param8_PrTime: objCommonInsertOpt.customDateTimeformatter(masterIncompData.Param8_PrTime,'HH:mm:ss'),
                            // Param8_PrDate: objCommonInsertOpt.customDateTimeformatter(masterIncompData.Param8_PrDate,'YYYY-MM-DD'),
                            Param8_Nom: nominal,
                            Param8_DecimalPoint: dp,
                            Param8_T1Pos: rpm,
                            Param8_Unit: unit,
                            FriabilityID: cubicInfo.Sys_FriabID ?? 'NA',
                            // dates_json: parseDatesObj
                        },{
                            where: {
                                RepSerNo: repSerNo
                            }
                        });
                    }

                }

                Object.assign(whereObj, { RepSerNo: repSerNo })
            } else {
                // await this.processBalanceFriabilityData2(dataObj)

            }

            let objMstFinder = {
                tableName: masterTable,
                ProductName: cubicInfo.Sys_ProductName,
                Batch: cubicInfo.Sys_Batch,
                PVersion: cubicInfo.Sys_PVersion,
                Version: cubicInfo.Sys_Version,
                BFGCode: cubicInfo.Sys_BFGCode,
                CubType: cubType,
                RptType: cubicInfo.Sys_RptType,
                MPN: cubicInfo.Sys_MPNCode
            }

            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let removeTimeForMenuDisable = rpm;
            var addTime = this.AddMinutesToDate(new moment(), removeTimeForMenuDisable);
            var dateFormat = addTime.split(' ');
            var dateFormat1 = dateFormat[1];

            if (powerbacc != undefined) {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.Before_Count,
                        'FriabSide': sideNo
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': powerbacc.After_Count,
                        'FriabSide': sideNo
                    })
                }
            } else {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'DsNo': strDsNo,
                        'TabIp': strTabIp,
                        'counter': 0,
                        'FriabSide': sideNo,
                    })
                }
            }

            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)
            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo)

            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.DsNo == strDsNo).configSetting;
            let autoTare = hmiEntryinConfig[0].AutoTare;
            let tareCommand = hmiEntryinConfig[0].Tare_Command



            if ((FriabRotaryType == 'LHS' || FriabRotaryType == 'RHS' || FriabRotaryType == 'NA') && cubicInfo.Sys_RptType != undefined) {

                let side = FriabRotaryType;
                let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))

                if (powerbacc) initSampletime = powerbacc.EntryTimeStamp

                // var checkEntry = await models[masterTable].findAll({
                //     attributes: [
                //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "mstSrNo"],
                //         // [sequelize.fn('MAX', sequelize.col("SrNo")), "RecNo"],
                //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "mstRepSrNo"],
                //     ],
                //     where: whereObj
                //     ,
                //     raw: true
                // });

                // let MstRecSerNo = checkEntry[0].mstSrNo ? checkEntry[0].mstSrNo : 1;
                // let RecNo = checkEntry[0].RecNo ? checkEntry[0].RecNo : 1;

                if (powerbacc != undefined) {
                    if (powerbacc.Before_Count == 1 && powerbacc.After_Count == 0 && tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 0) {
                        tempCounterObjAfter.counter = 1

                    }
                }

                if (tempCounterObj.counter == 0 && tempCounterObjAfter.counter == 0) {

                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicInfo.Sys_Batch,
                        activity: `Friability Test started on DS ${strDsNo} for Side ${FriabRotaryType}`
                    };

                    if (parseFloat(actualWt) < parseFloat(NLTWeight)) {
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}:Orange`);
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Before Weight must be ${NLT.Friability}`);
                        return;
                    }

                    if (selectedMenuDetails?.nextFlag) {
                        var detailEntry = await models[getTableName.detailTableIncomplete].create({
                            RepSerNo: repSerNo,
                            // MstSerNo: mstEntry.MstSerNo,
                            RecSeqNo: 1,
                            [InitialWt]: actualWt,
                            // [FinalWt]: '0',
                            UserId: userInfo.UserId,
                            UserName: userInfo.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: side,
                            InstrumentID: dataObj.instrumentId,
                            DsNo: strDsNo,
                            BatchNo: cubicInfo.Sys_Batch,
                            DP: dp,
                            DataValueUnit: unit,
                            ProductName: cubicInfo.Sys_ProductName,
                            Repetition:cubicInfo.Sys_Repetition,
                            SFOID: cubicInfo.Sys_SFOID

                            // InstrumentID: 
                        })

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strDsNo, data: {
                                Weight: `${Number(
                                    actualWt
                                )} ${unit}`, srNo: "", message: 'InitialWeight'
                            }
                        });
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}`);

                        if (autoTare) {
                            mqttSender.sendData(strDsNo, `${mqttProtocol.ComWrite}${protocolPortNo}:${tareCommand}`);
                        }

                        tempCounterObj.counter += 1;

                        if (!powerbacc) {
                            await models.tbl_powerbackup.create({
                                CubicalNo: cubicleNo,
                                WeighmentType: 8,
                                WeighmentName: 'FRIAB',
                                Userid: userInfo.UserId,
                                ReportType: cubicInfo.Sys_RptType,
                                RotartyType: FriabRotaryType,
                                Sys_CubType: cubType,
                                Sys_Batch: cubicInfo.Sys_Batch,
                                Sys_BFGCode: cubicInfo.Sys_BFGCode,
                                Before_Count: tempCounterObj.counter,
                                After_Count: 0,
                                DsNo: strDsNo,
                                TabIp: strTabIp,
                                Incomp_RepSerNo: detailEntry.RepSerNo,
                                RecSampleNo: detailEntry.RecSeqNo,
                                ProductType: 1,
                                Side_RepSerNo: sideNo,
                                EntryTimeStamp: addTime,
                                MPN_Code: cubicInfo.Sys_MPNCode
                            })
                        } else {
                            await models.tbl_powerbackup.update({
                                Before_Count: tempCounterObj.counter,
                                After_Count: 0,
                                EntryTimeStamp: addTime,
                            },
                                {
                                    where: {
                                        Incomp_RepSerNo: repSerNo,
                                        WeighmentType: 8,
                                        WeighmentName: 'FRIAB',
                                        RecSampleNo: detailEntry.RecSeqNo,
                                        Side_RepSerNo: sideNo
                                    }
                                });
                        }

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage} Friability Before Samples Completed, now wait for ${removeTimeForMenuDisable} min. 00 sec`)
                        selectedMenuDetails.nextFlag = undefined
                    } else {
                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTBL1:${actualWt + " " + unit}`);
                        await objActivityLog.ActivityLogEntry(_activityObj);
                        await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, 'tbl_instrumentlog_balance', 'Friability', 'started', strTabIp, userInfo, { cubicalData: cubicInfo });
                        selectedMenuDetails.nextFlag = undefined
                    }
                }
                if (tempCounterObj.counter == 1 && tempCounterObjAfter.counter == 1) {

                    if (initSampletime < currentTime) {

                        if (selectedMenuDetails.nextFlag) {

                            let detailData = await models[getTableName.detailTableIncomplete].findAll({
                                where: {
                                    RepSerNo: powerbacc.Incomp_RepSerNo,
                                    RecSeqNo: powerbacc.RecSampleNo
                                }
                            })

                            detailData = detailData.pop();

                            let initialwt = detailData[InitialWt];
                            let remark1
                            let nwtAfterTest = mathj.round((((initialwt - actualWt) / initialwt) * 100), dp).toFixed(3);

                            if (nwtAfterTest <= nominal) {
                                remark1 = 'Within Limit'
                            } else {
                                remark1 = 'Out Of Limit'
                            }

                            const updateData = await models[getTableName.detailTableIncomplete].update({

                                [FinalWt]: actualWt,
                                Remark: remark1,
                                [FriabVal]: nwtAfterTest,
                                PrEndTime: moment().format('HH:mm:ss'),
                                PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                                isException: remark1 == 'Within Limit' ? 0 : 1
                            }, {
                                where: {
                                    RecNo: detailData.RecNo,
                                    RepSerNo: detailData.RepSerNo,
                                    Side: side
                                }
                            });

                            await objMonit.monit({
                                case: 'TestWeight', Hmi: strDsNo, data: {
                                    Weight: `${Number(
                                        actualWt
                                    )} ${unit}`, srNo: "", message: 'FinalWeight'
                                }
                            });
                            if (remark1 != 'Within Limit') {
                                // await models[exceptionTable].create({
                                //     IDSNo: null,
                                //     Remark: remark1,
                                //     DataValue: nwtAfterTest,
                                //     DataValueUnit: unit,
                                //     RepSerNo: powerbacc.Incomp_RepSerNo,
                                //     MenuName: 'Friability',
                                //     ProductType: 1,
                                //     Repetition: cubicInfo.Sys_Repetition,
                                //     // TypeValue :
                                //     BFGCode: cubicInfo.Sys_BFGCode,
                                //     ProductName: cubicInfo.Sys_ProductName,
                                //     BatchNo: cubicInfo.Sys_Batch,
                                //     // Department :
                                //     SFOID: selectedMenuDetails.SFOID,
                                //     // MachineCode: dataObj.EquipmentCode,
                                //     PrDate: moment().format('YYYY-MM-DD'),
                                //     prTime: moment().format('HH:mm:ss'),
                                //     Side: side,
                                //     // InstrumentId: InstrumentId,
                                //     T1NegTol: nominal,
                                //     // T1PosTo: maxLimitT2,
                                //     SampleNo: 1,
                                //     CheckByDate: null,
                                //     CheckByName: null,
                                //     CheckById: null,
                                //     Area: cubicInfo.Sys_Area,
                                //     UserID: userInfo.UserId,
                                //     UserName: userInfo.UserName,
                                //     ProductType: 1,
                                //     TypValue: cubicInfo.Sys_RptType
                                //     // SampleNo: 1
                                // })

                                // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);
                                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${nwtAfterTest} %`);

                                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}${remark1}`);

                                await models.tbl_powerbackup.update({
                                    Before_Count: 0,
                                    After_Count: 0,
                                    isException: remark1 == 'Within Limit' ? 0 : 1
                                },
                                    {
                                        where: {
                                            Incomp_RepSerNo: detailData.RepSerNo,
                                            WeighmentType: 8,
                                            WeighmentName: 'FRIAB',
                                            RecSampleNo: detailData.RecSeqNo,
                                            Side_RepSerNo: sideNo
                                        }
                                    });

                                selectedMenuDetails.nextFlag = undefined

                            } else {
                                let objdates = {
                                    Param8_PrEndDate: moment().format("YYYY-MM-DD"),
                                    Param8_PrEndTime: moment().format("HH:mm:ss")
                                }
                                // let parseDatesObj = objCommonInsertOpt.parseJSON(masterIncompData.dates_json, objdates)
                                await models[masterTable].update({
                                    Param8_PrEndTime: objCommonInsertOpt.customDateTimeformatter(masterIncompData.Param8_PrEndTime,'HH:mm:ss'),
                                    Param8_PrEndDate: objCommonInsertOpt.customDateTimeformatter(masterIncompData.Param8_PrEndDate,'YYYY-MM-DD'),
                                    Param8_Remark: remark1,
                                    Param8_AvgNet: nwtAfterTest,
                                    Param8_MinWeight: nwtAfterTest,
                                    Param8_MaxWeight: nwtAfterTest,
                                    IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                                    // dates_json:parseDatesObj
                                }, {
                                    where: {
                                        RepSerNo: powerbacc.Incomp_RepSerNo
                                    }
                                });

                                // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);
                                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${nwtAfterTest} %`);


                                var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Friability", detailData.RepSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicInfo, protocolPortNo, 'NA', 'NA', 'Test Completed')

                                let objActivity = {}
                                Object.assign(objActivity,
                                    { strUserId: userInfo.UserId },
                                    { strUserName: userInfo.UserName },
                                    { batch: cubicInfo.Sys_Batch },
                                    { activity: `Friability Test Completed on Ds ${strDsNo} For Rotary ${FriabRotaryType}` });
                                // var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Friability", detailData.RepSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicInfo, protocolPortNo, 'NA', 'NA', 'Test Completed')
                                await objMonit.monit({
                                    case: 'ReportStatus', Hmi: strDsNo, data: {
                                        message: 'Friability Test Completed'
                                    }
                                });
                                await objActivityLog.ActivityLogEntry(objActivity);
                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        DsNo: strDsNo,
                                        TabIp: strTabIp,
                                        WeighmentName: 'FRIAB',
                                    }
                                });


                                globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1 ?
                                    globalData.arrSelectedMenu :
                                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp), 1);


                            }

                            await objInstrumentUsage.InstrumentUsage('Balance', strDsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed', strTabIp, userInfo, { cubicalData: cubicInfo });

                            // let mesArr = globalData.MESArray.push(
                            //     {
                            //         menuName: 'Friability',
                            //         payload: {'Friability': { BeforeValue: initialwt, AfterValue:actualWt , FirabValue: nwtAfterTest ,isMesChecked: false } }],
                            //         dsNo: strDsNo,
                            //         tabIp: strTabIp,
                            //         portNo: protocolPortNo,
                            //         isCompleted: false, 
                            //         RepSerNo: repSerNo
                            //     }
                            // )

                            // console.log(mesArr)
                            // let batchSummaryObject = {
                            //     BFGCode: cubicInfo.Sys_BFGCode,
                            //     ProductName: cubicInfo.Sys_ProductName,
                            //     PVersion: cubicInfo.Sys_PVersion,
                            //     Version: cubicInfo.Sys_Version,
                            //     PrdType: 1,
                            //     CubType: cubicInfo.Sys_CubType,
                            //     BatchNo: cubicInfo.Sys_Batch,
                            //     Unit: cubicInfo.Sys_BatchSizeUnit,
                            //     Side: FriabRotaryType,
                            //     InstrumentID: dataObj.instrumentId,
                            //     UserId: userInfo.UserId,
                            //     UserName: userInfo.UserName,

                            //     // nwtBeforeTest: nwtBeforeTest,
                            //     nwtAfterTest: nwtAfterTest,
                            //     lwtBeforeTest: resSelectFri2[0][InitialWt],
                            //     lwtAfterTest: resSelectFri2[0][FinalWt],
                            //     rwtBeforeTest: resSelectFri2[1][InitialWt],
                            //     rwtAfterTest: resSelectFri2[1][FinalWt],
                            //     Dept: cubicInfo.Sys_dept,
                            //     Area: cubicInfo.Sys_Area,
                            //     Nom: '1.0',
                            //     PrTime: date.format(now, 'HH:mm:ss'),
                            //     PrDate: date.format(now, 'YYYY-MM-DD'),
                            //     MPN_Code: cubicInfo.Sys_MPNCode
                            // }

                            // await objBatchSummary.saveBatchSummaryFriability1(batchSummaryObject, strDsNo);






                            globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                                globalData.arrWeighmentCounterForFriab :
                                globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                            globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                                globalData.arrWeighmentCounterAfter :
                                globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);



                            if (count == 0) {

                            }
                            // setTimeout(() => { mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.TestCompleted} Test Completed`) }, 1000);

                        } else {

                            // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);
                            mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:NA`);
                            selectedMenuDetails.nextFlag = undefined
                            return;

                        }

                    } else {

                        mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                        selectedMenuDetails.nextFlag = undefined
                    }

                } else if (tempCounterObj.counter == 0 && tempCounterObjAfter.counter == 1) {
                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);

                    globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo) == -1 ?
                        globalData.arrWeighmentCounterAfter :
                        globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.FriabSide == sideNo), 1);




                }

            }

        } catch (error) {
            console.log(error)
        }
    }


    async processFriability(dataObj) {
        try {
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            // let actualWt = dataObj.actualWt;
            // let invalidUnitFlag = dataObj.invalidUnitFlag;
            // let invalidWeightFlag = dataObj.invalidWeightFlag;
            let selectedMenuDetails = dataObj.SelectedMenuDetails
            let protocolPortNo = dataObj.SelectedMenuDetails.portNo
            // let T2Pos = selectedMenuDetails.selectedProductDetail.T2Pos
            // let T2Neg = selectedMenuDetails.selectedProductDetail.T2Neg
            let unit = selectedMenuDetails.selectedProductDetail.unit ?? 'gm';
            unit = unit == 'gm' ? 'g' : unit;
            let dp = selectedMenuDetails.selectedProductDetail.dp
            let FriabRotaryType = selectedMenuDetails.rotary ?? 'LHS';

            let nominal = selectedMenuDetails?.selectedProductDetail?.Nominal ?? 1.0;

            let rpmValue = Global_Nomenclature.StaticFriabilityRange;
            let rpm = parseInt(rpmValue.split(':')[1])
            let cubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp).cubicalData
            let getTableName = objCommonWeightment.getTableName(cubicInfo, 'Friability', strDsNo, strTabIp)
            // let masterTable = getTableName.masterTable;
            let masterTableIncomplete = getTableName.masterTableIncomplete
            let exceptionTable = 'tbl_exception_sample_initial'

            let repSerNo;



            let ipcCubicData = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: strDsNo
                }
            })

            let NLT = await models.tbl_cubicle_product_sample.findOne({
                where: {
                    Sys_CubicNo: cubicInfo.Sys_CubicNo
                }
            })

            let NLTWeight = NLT.Friability.split(' ')[1]

            // if ipqc then cubical details changes
            let cubicleName = cubicInfo.Sys_CubicName
            let cubicleNo = cubicInfo.Sys_CubicNo
            let cubType = cubicInfo.Sys_CubType

            if (cubicInfo.Sys_CubicNo != ipcCubicData.Sys_CubicNo || cubicInfo.Sys_CubType != ipcCubicData.Sys_CubType) {
                cubicleName = ipcCubicData.Sys_CubicName
                cubicleNo = ipcCubicData.Sys_CubicNo
                cubType = ipcCubicData.Sys_CubType
            }

            let userInfo = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)

            let whereObj = {};
            let sideNo = FriabRotaryType == 'RHS' ? 1 : 0;
            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    Sys_Batch: cubicInfo.Sys_Batch,
                    DsNo: strDsNo
                }
            })

            powerbacc = powerbacc.pop();

            let InitialWt = 0;
            let FinalWt = 0;
            let FriabVal = 0;

            let menuSequence = await models.tbl_menu_sequence.findAll({
                where: {
                    TabIp: strTabIp,
                    DS_Number: strDsNo,
                }
            })

            let mesData = await models.tbl_mes_data.findOne({
                where: {
                    isSetInCubical: 1,
                    BatchId: cubicInfo.Sys_Batch,
                    DS_Number: strDsNo,
                }
            })

            const equipmentData = await models.tbl_machine.findOne({
                where: { Machine_ID: cubicInfo.Sys_MachineCode }
            })



            let _activityObj = {
                strUserId: userInfo.UserId,
                strUserName: userInfo.UserName,
                batch: cubicInfo.Sys_Batch,
                activity: `Friability Test started on DS ${strDsNo} `
            };

            await objActivityLog.ActivityLogEntry(_activityObj);
            await objInstrumentUsage.InstrumentUsage('Friabilator', strDsNo, 'tbl_instrumentlog_friability', 'Friability', 'started', strTabIp, userInfo, { cubicalData: cubicInfo });



            repSerNo = menuSequence.length > 0 ? menuSequence[0].RepSerNo : null

            var mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicInfo, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })
            if (repSerNo == 0) {
                let mstEntry = await models[masterTableIncomplete].create({
                    MstSerNo: mastSerNo,
                    CubicalNo: cubicInfo.Sys_CubicNo,
                    // CubicleName: cubicInfo.Sys_CubicalName,
                    CubicleName: cubicleName,
                    CubicleType: cubicInfo.Sys_CubType,
                    ProductName: cubicInfo.Sys_ProductName,
                    MPN_Code: cubicInfo.Sys_MPNCode,
                    SFOID: selectedMenuDetails.SFOID,
                    ProductType: 1,
                    Area: cubicInfo.Sys_Area,
                    MachineCode: selectedMenuDetails?.EquipmentCode ?? null,
                    PVersion: cubicInfo.Sys_PVersion,
                    Version: cubicInfo.Sys_Version,
                    BatchNo: cubicInfo.Sys_Batch,
                    BFGCode: cubicInfo.Sys_BFGCode,
                    // Param7_T2NegTol: hardnessneg2,
                    // Param7_T2PosTol: hardnesspos2,
                    // Param3_T2PosTol: thicknespos2,
                    // Param3_T2NegTol: thicknesneg2,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    ProductName: cubicInfo.Sys_ProductName,
                    UserId: userInfo.UserId,
                    UserName: userInfo.UserName,
                    Idsno: cubicInfo.Sys_DSNumber,
                    // BalanceId: cubicInfo.Sys_BalID,
                    Qty: selectedMenuDetails.individualsamplecount,
                    GrpQty: selectedMenuDetails.groupQty,
                    // VernierId: cubicInfo.Sys_VernierID,
                    FriabilityID: (cubicInfo.Sys_FriabID == 'None') ? 'NA' : cubicInfo.Sys_FriabID,
                    // HardnessID: cubicInfo.Sys_HardID,
                    // DTID: cubicInfo.Sys_DTID,
                    PrDate: moment().format('YYYY-MM-DD'),
                    PrTime: moment().format('HH:mm:ss'),
                    IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                    Param8_PrTime: moment().format('HH:mm:ss'),
                    Param8_PrDate: moment().format('YYYY-MM-DD'),
                    Param8_Nom: nominal,
                    Param8_DecimalPoint: dp,
                    Param8_T1Pos: rpm,
                    Param8_Unit: unit,
                    Repetition: cubicInfo.Sys_Repetition,
                    ReportType: cubicInfo.Sys_RptType,
                    NoOfStations: equipmentData.Machine_Punches,
                    Side: cubicInfo.Sys_RotaryType,
                    LHSContainerNo: selectedMenuDetails.LHSContainerNo,
                    RHSContainerNo: selectedMenuDetails.RHSContainerNo,
                    MesTestType: cubicInfo.MesTestType,
                    MesSide: cubicInfo.MesSide,

                })


                await models.tbl_menu_sequence.update({
                    RepSerNo: mstEntry.RepSerNo
                }, {
                    where: {
                        DS_Number: strDsNo,
                        TabIp: strTabIp
                    }
                })


                repSerNo = mstEntry.RepSerNo


            } else {

                await models[masterTableIncomplete].update({
                    Param8_PrTime: moment().format('HH:mm:ss'),
                    Param8_PrDate: moment().format('YYYY-MM-DD'),
                    Param8_Nom: nominal,
                    Param8_DecimalPoint: dp,
                    Param8_T1Pos: rpm,
                    Param8_Unit: unit,
                    FriabilityID: cubicInfo.Sys_FriabID ?? 'NA',
                }, {
                    where: {
                        RepSerNo: repSerNo
                    }
                });


            }


            if (mesData.Side == 'NA' || mesData.Side == 'LHS') {
                InitialWt = parseFloat(dataObj.actualWtBeforeDrum1);
                FinalWt = parseFloat(dataObj.actualWtAfterDrum1);
                FriabVal = parseFloat(dataObj.friability_drum1);

            } else {
                InitialWt = parseFloat(dataObj.actualWtBeforeDrum2);
                FinalWt = parseFloat(dataObj.actualWtAfterDrum2);
                FriabVal = parseFloat(dataObj.friability_drum2);
            }

            // if ((parseFloat(InitialWt) <= parseFloat(NLTWeight)) || (parseFloat(FinalWt) <= parseFloat(NLTWeight))) {
            //     mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}BeforWeight:${InitialWt + " " + unit};AfterWeight:${FinalWt + " " + unit};NetValue:${FriabVal + " %"}:Orange`);
            //     mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}  Weight must be ${NLT.Friability}`);
            //     return;
            // }

            let remark1

            if((InitialWt <= NLTWeight && FinalWt < NLTWeight) && configFile.plant == 'PUI'){
                  remark1 = 'Below Limit'
            }
            else if(FriabVal <= nominal && (InitialWt > NLTWeight || FinalWt > NLTWeight)) {
                remark1 = 'Within Limit'
            }else {
                remark1 = 'Out Of Limit'
            }

            let detailEntry = await models[getTableName.detailTableIncomplete].create({
                RepSerNo: repSerNo,
                // MstSerNo: mstEntry.MstSerNo,
                RecSeqNo: 1,
                BeforeValue: InitialWt,
                AfterValue: FinalWt,
                UserId: userInfo.UserId,
                UserName: userInfo.UserName,
                PrDate: moment().format('YYYY-MM-DD'),
                PrTime: moment().format('HH:mm:ss'),
                Side: mesData.Side,
                InstrumentID: dataObj.instrumentId,
                DsNo: strDsNo,
                BatchNo: cubicInfo.Sys_Batch,
                DP: dp,
                DataValueUnit: unit,
                ProductName: cubicInfo.Sys_ProductName,
                isException: remark1 == 'Within Limit' ? 0 : 1,
                NetValue: FriabVal,
                Remark: remark1,
                AvgWeight: FriabVal,
                NetValue: FriabVal,
                AvgWeight: FriabVal,
                PrEndTime: moment().format('HH:mm:ss'),
                PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
            })

            if (!powerbacc) {
                powerbacc = await models.tbl_powerbackup.create({
                    CubicalNo: cubicleNo,
                    WeighmentType: 8,
                    WeighmentName: 'FRIAB',
                    Userid: userInfo.UserId,
                    ReportType: cubicInfo.Sys_RptType,
                    RotartyType: FriabRotaryType,
                    Sys_CubType: cubType,
                    Sys_Batch: cubicInfo.Sys_Batch,
                    Sys_BFGCode: cubicInfo.Sys_BFGCode,
                    // Before_Count: tempCounterObj.counter,
                    After_Count: 0,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    Incomp_RepSerNo: detailEntry.RepSerNo,
                    RecSampleNo: detailEntry.RecSeqNo,
                    ProductType: 1,
                    Side_RepSerNo: sideNo,
                    // EntryTimeStamp: addTime,
                    MPN_Code: cubicInfo.Sys_MPNCode
                })
            }

            // let nwtAfterTest = Math.round((((InitialWt - FinalWt) / InitialWt) * 100), dp).toFixed(3);
            // let nwtAfterTest =(((InitialWt - FinalWt) / InitialWt) * 100).toFixed(3);


            if (remark1 != 'Within Limit') {

                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}BeforWeight:${InitialWt + " " + unit};AfterWeight:${FinalWt + " " + unit};NetValue:${FriabVal + " %"}:Orange`);

                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}${remark1}: OkBtn true`);

                await models.tbl_powerbackup.update({
                    isException: remark1 == 'Within Limit' ? 0 : 1
                },
                    {
                        where: {
                            Incomp_RepSerNo: detailEntry.RepSerNo,
                            WeighmentType: 8,
                            WeighmentName: 'FRIAB',
                            RecSampleNo: detailEntry.RecSeqNo,
                            Side_RepSerNo: sideNo
                        }
                    });

            } else {
                await await models.tbl_tab_initialmaster_incomplete.update({
                    Param8_PrEndTime: moment().format('HH:mm:ss'),
                    Param8_PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                    Param8_Remark: remark1,
                    Param8_AvgNet: FriabVal,
                    Param8_MinWeight: FriabVal,
                    Param8_MaxWeight: FriabVal,
                    // PrDate: moment().format('YYYY-MM-DD'),
                    // PrTime: moment().format('HH:mm:ss'),
                    Param8_PrTime: moment().format('HH:mm:ss'),
                    Param8_PrDate: moment().format('YYYY-MM-DD'),
                    // Param8_Nom: nominal,
                    // Param8_DecimalPoint: dp,
                    // Param8_T1Pos: rpm,
                    // Param8_Unit: unit,
                    LHSContainerNo: selectedMenuDetails.LHSContainerNo,
                    RHSContainerNo: selectedMenuDetails.RHSContainerNo,
                    MesTestType: cubicInfo.MesTestType,
                    MesSide: cubicInfo.MesSide,
                }, {
                    where: {
                        RepSerNo: powerbacc.Incomp_RepSerNo
                    }
                });

                // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult}WTAL1:${actualWt + " " + unit};NWTD1:${actualWt} ${unit}`);
                mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayResult};BeforeWeight:${InitialWt + " " + unit};AfterWeight:${FinalWt + " " + unit};NetWeight:${FriabVal + " %"} `);
                // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.TestCompleted} ${remark1}`)
                // let remark = "Report Within Limit";
                // mqttSender.sendData(strDsNo, `Port ${protocolPortNo}:${mqttProtocol.DisplayMessage}${remark1}: OkBtn true`);

                let objActivity = {}
                Object.assign(objActivity,
                    { strUserId: userInfo.UserId },
                    { strUserName: userInfo.UserName },
                    { batch: cubicInfo.Sys_Batch },
                    { activity: `Friability Test Completed on Ds ${strDsNo} For Rotary ${FriabRotaryType}` });
                await objActivityLog.ActivityLogEntry(objActivity);
                var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Friability", detailEntry.RepSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicInfo, protocolPortNo, 'NA', 'NA', 'Test Completed')
                await objMonit.monit({
                    case: 'ReportStatus', Hmi: strDsNo, data: {
                        message: 'Friability Test Completed'
                    }
                });
                // Object.assign(objActivity,
                //     { strUserId: tempUserObject.UserId },
                //     { strUserName: tempUserObject.UserName },
                //     { batch: CurrentCubicalObj.Sys_Batch },
                //     { activity: `Friability Test Completed on TSH ${strHmi}` });

                // await objActivityLog.ActivityLogEntry(objActivity);
                // await objInstrumentUsage.InstrumentUsage('Friabilator', strDsNo, 'tbl_instrumentlog_friability', '', 'completed');
                await objInstrumentUsage.InstrumentUsage('Friabilator', strDsNo, 'tbl_instrumentlog_friability', 'Friability', 'completed', strTabIp, userInfo, { cubicalData: cubicInfo });

                await models.tbl_powerbackup.destroy({
                    where: {
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        WeighmentName: 'FRIAB',
                    }
                })


                globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == strDsNo && k.TabIp == strTabIp), 1);

                // mqttSender.sendData(strDsNo, `${mqttProtocol.DisplayMessage}Test Completed :OkBtn true`);
            }





        } catch (error) {
            console.log(error);
        }
    }

}



module.exports = FriabilityModel;