const database = require('../../global/dbCon');
const globalData = require('../../global/globalData');
const Database = require('../../database/clsQueryProcess')
const database1 = new Database();
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
class IncompleteReport {

    async getIncompleteData1(dataObj) {
        try {
            let responseObj = {};
            let cubicObj = dataObj.cubicObj;
            let dsNo = dataObj.DsNo;
            let masterTable = dataObj.masterTableIncomplete;
            let detailTable = dataObj.detailTableIncomplete;

            let getMaxData = await models[masterTable].findAll({
                attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
                where: {
                    MPN_Code: cubicObj.Sys_MPNCode,
                    // BFGCode: cubicObj.Sys_BFGCode,
                    // ProductName: cubicObj.Sys_ProductName,
                    // PVersion: objWeighment.ProductVersion,
                    // Version: objWeighment.Version,
                    BatchNo: cubicObj.Sys_Batch,
                    DsNo: dsNo,
                    Inprocess: 1
                }

            })

            let objIncompleteData = await models[masterTable].findAll({
                where: {
                    MPN_Code: cubicObj.Sys_MPNCode,
                    // BFGCode: cubicObj.Sys_BFGCode,
                    // ProductName: cubicObj.Sys_ProductName,
                    // PVersion: objWeighment.ProductVersion,
                    // Version: objWeighment.Version,
                    BatchNo: cubicObj.Sys_Batch,
                    DsNo: dsNo,
                    Inprocess: 1,
                    RepSerNo: getMaxData[0].RepSerNo
                }

            })
            objIncompleteData = cubicObj.ProductType == 3
                ? objIncompleteData.condition.push({ str_colName: 'TestType', value: tempMenu.menu })
                : objIncompleteData


            // let masterresult = [objIncompleteData]
            // masterresult = masterresult[0].pop();
            let masterresult = objIncompleteData[0];
            var RepSerNo = masterresult.RepSerNo;
            const incompleteDetailData = await models[detailTable].findAll({ where: { RepSerNo: RepSerNo } })
            let filterGarbageData;
            let detailresult

            if (dataObj.menuName == "Hardness") {
                detailresult = incompleteDetailData;
                filterGarbageData = []
            } else {
                filterGarbageData = incompleteDetailData.filter(e => e.isException == 1)
                detailresult = incompleteDetailData.filter(e => e.isException == 0)
            }

            Object.assign(responseObj, {
                incompleteData: masterresult,
                detailData: detailresult,
                garbageData: filterGarbageData
            })

            return responseObj;

        } catch (error) {
            throw new Error(error);
        }

    }

    async getIncompleteData(objWeighmentData, strMasterTableName, strDetailTableName, dsNo, tabIp, tempProductType) {
        try {
            let selectedDsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
            if (IPQCObject != undefined) {
                selectedDsNo = IPQCObject.selectedIds;
            } else {
                selectedDsNo = dsNo;
            }
            let responseObj = {};
            let objWeighment = tempProductType.productType;
            let strBatch = objWeighmentData.objProductDetails.Batch;

            if (objWeighment == undefined) {
                objWeighment = {}
                objWeighment.ProductId = tempProductType.Sys_BFGCode
                objWeighment.ProductName = tempProductType.Sys_ProductName
                strBatch = tempProductType.Sys_Batch
            }

            let tableMasterName = strMasterTableName.concat('_incomplete')
            let objIncompleteData = await models[tableMasterName].findAll({
                where: {
                    MPN_Code: tempProductType.Sys_MPNCode, 
                    // BFGCode: objWeighment.ProductId,
                    // ProductName: objWeighment.ProductName,
                    // PVersion: objWeighment.ProductVersion,
                    // Version: objWeighment.Version,
                    Inprocess: 0,
                    BatchNo: strBatch,
                    DsNo: selectedDsNo,
                }

            })
            objIncompleteData = objWeighment.ProductType == 3
                ? objIncompleteData.condition.push({ str_colName: 'TestType', value: tempMenu.menu })
                : objIncompleteData


            let masterresult = [objIncompleteData]
            masterresult = masterresult[0].pop();
            masterresult = masterresult;
            var RepSerNo = masterresult.RepSerNo;
            var tableDetailName = strDetailTableName.concat('_incomplete')
            const incompleteDetailData = await models[tableDetailName].findAll({ where: { RepSerNo: RepSerNo } })
            let filterGarbageData;
            let detailresult

            if (objWeighmentData.objProductDetails.menuName == "Hardness") {
                // detailresult = incompleteDetailData
                detailresult = incompleteDetailData.filter(e => e.isException == 0)
                filterGarbageData = incompleteDetailData.filter(e => e.isException == 1)
            } else {
                filterGarbageData = incompleteDetailData.filter(e => e.isException == 1)
                detailresult = incompleteDetailData.filter(e => e.isException == 0)
            }

            Object.assign(responseObj, {
                incompleteData: masterresult,
                detailData: detailresult,
                garbageData: filterGarbageData,
                completeTableName: strMasterTableName,
                detailTableName: strDetailTableName,
                incompleteTableName: tableMasterName,
                incompletedetailTableName: tableDetailName
            })

            return responseObj;

        } catch (error) {
            throw new Error(error);
        }

    }

    async getDiffIncomepleteData(objWeighmentData, strMasterTableName, strDetailTableName, IdsNo) {
        try {
            // const objWeighmentData = dataObj.data;
            // const strMasterTableName = dataObj.masterTable;
            // const strDetailTableName = dataObj.detailTable;
            var strHmi = IdsNo;

            let selectedIdsNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.Hmi == IdsNo);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            //     selectedIdsNo = IdsNo;
            // }

            const tempProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
            //var tempMenu = globalData.arrMultihealerMS.find(k=>k.idsNo == IdsNo);
            let responseObj = {};
            let objWeighment = tempProductType.productType;
            let strBatch = objWeighmentData.objProductDetails.Batch;

            let selectedCub = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }
            let tableMasterName = strMasterTableName.concat('_incomplete')

            let objIncompleteData = await models[tableMasterName].findAll({
                where: {
                    BFGCode: objWeighment.ProductId,
                    ProductName: objWeighment.ProductName,
                    PVersion: objWeighment.ProductVersion,
                    VERSION: objWeighment.Version,
                    BatchNo: strBatch,
                    // CubicleType: selectedCub.Sys_CubType,
                    Idsno: strHmi // change idsNo to strHmi
                }
            })

            //     str_tableName: strMasterTableName + '_incomplete',
            //     data: '*',
            //     condition: [
            //         { str_colName: 'BFGCode', value: objWeighment.ProductId },
            //         { str_colName: 'ProductName', value: objWeighment.ProductName },
            //         { str_colName: 'PVersion', value: objWeighment.ProductVersion },
            //         { str_colName: 'VERSION', value: objWeighment.Version },
            //         { str_colName: 'BatchNo', value: strBatch },
            //         { str_colName: 'Idsno', value: IdsNo },
            //     ]
            // }
            objIncompleteData = objWeighment.ProductType == 3 ?
                objIncompleteData.condition.push({ str_colName: 'TestType', value: tempMenu.menu }) :
                objIncompleteData


            let masterresult = [objIncompleteData]
            masterresult = masterresult[0].pop(); //uncommented 07/02/23

            masterresult = masterresult;
            //console.log(masterresult);
            var RepSerNo = masterresult.RepSerNo;
            //console.log(RepSerNo);

            var tableDetailName = strDetailTableName.concat('_incomplete')

            const incompleteDetailData = await models[tableDetailName].findAll({
                where: {
                    RepSerNo: RepSerNo
                }

            })
            // {
            //     // str_tableName: strDetailTableName + '_incomplete',
            //     data: '*',
            //     condition: [
            //         { str_colName: 'RepSerNo', value: RepSerNo, comp: 'eq' }
            //     ]
            // }
            let detailresult = [incompleteDetailData]
            Object.assign(responseObj, {
                incompleteData: masterresult,
                detailData: detailresult[0],
                completeTableName: strMasterTableName,
                detailTableName: strDetailTableName,
                incompleteTableName: tableMasterName,
                incompletedetailTableName: tableDetailName
            })

            return responseObj;

        } catch (error) {
            throw new Error(error);
        }

    }
}
module.exports = IncompleteReport;