const globalData = require("../../global/globalData");
const date = require("date-and-time");
const Database = require("../../database/clsQueryProcess");
const IncompleteReport = require("./clsIncompleteReport");
const clsWeighmentDataTransfer = require("./clsWeighmentDataTransfer");
const clsCommonWeightment = require("./clsCommonWeightment");
const clsFormula = require("../Product/clsformulaFun.model");
const BatchSummaryModel = require("../Product/clsBatchSummaryOperation");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const clsMqttSender = require('../Mqtt/mqttSender.class');
const check_srNO_ = require("./cls_consolidate_reportOperation");
const clsCalculation = require('../clsCalculationOperation');
const ConfigFile = require("../../../../IncrencyV4DRLTSHConfig.json");
const objformulaFun = new FormulaFunModel();
const mqttSender = new clsMqttSender();
// const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
// const dbcon = require('../../Utills/db');
const moment = require("moment");
const check_srNO = new check_srNO_();
const objWeighmentDataTransfer = new clsWeighmentDataTransfer();
const objIncompleteReport = new IncompleteReport();
const database = new Database();
const objFormula = new clsFormula();
const now = new Date();
const objBatchSummary = new BatchSummaryModel();
const objCommonWeightment = new clsCommonWeightment();
const objcalc = new clsCalculation();
const { Op, where } = require("sequelize");
// const { tbl_cubical } = require('sequelize');
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const momentObj = require("moment");
const { create, all } = require("mathjs");
const serverConfig = require('../../global/serverConfig');
const serverConfigs = require("../../../../IncrencyV4DRLTSHConfig.json");
const tbl_batchsummary = require("../../../../IncrencyV4_DRL_Model/models/Report/Batch Summary/tbl_batchsummary");
const tbl_batchsummary_master = require("../../../../IncrencyV4_DRL_Model/models/Report/Batch Summary/tbl_batchsummary_master");
const config = {};
const maths = create(all, config);

class InsertOperation {

  async insert_Into_Incomplete_Detail1(dataObj, limit) {
    try {
      let objSelMenu = dataObj.SelectedMenuDetails;
      let side = objSelMenu.Side;
      const masterTableIncomplete = dataObj.masterTableIncomplete;
      const detailTableIncomplete = dataObj.detailTableIncomplete;
      let productDetail = dataObj.SelectedMenuDetails.selectedProductDetail;
      let dsNo = dataObj.DsNo
      let actualWt = dataObj.actualWt;
      const protocolDecPoint = dataObj.decPoint;

      let userObj = dataObj.UserData;
      let decimal = 0, sample_count = 0;
      let tabIp = dataObj.TabIp;

      let cubicObj = dataObj.cubicObj;
      let batchNo = cubicObj.Sys_Batch
      let mpnCode = cubicObj.Sys_MPNCode;
      let rptType = cubicObj.Sys_RptType;

      const seqNoOfWt = cubicObj.isPreStart == 1 ? dataObj?.RecNo ?? 1 : dataObj.RecSampleNo;
      // let selectedDsNo;

      // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      // if (IPQCObject != undefined) {
      //   selectedDsNo = IPQCObject.selectedDs;
      // } else {
      //   selectedDsNo = dsNo;
      // }
      let repSerNo = await this.lastInsertedRecords1(batchNo, mpnCode, rptType, masterTableIncomplete, dsNo, tabIp);
      const masterData = await models[masterTableIncomplete].findAll({ where: { RepSerNo: repSerNo } });
      if (masterData.length > 0) {
        let whereCondtion = { RepSerNo: repSerNo, Side: side, isException: 0 }
        if (dataObj.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || dataObj.menuName == GLOBAL_NOMENCLATURE.LockedLength || dataObj.menuName == GLOBAL_NOMENCLATURE.Differential) {
          whereCondtion.isCompleted = 0
        }
        const selectRepSrNoObj = await models[detailTableIncomplete].findAll({ where: whereCondtion });
        if (selectRepSrNoObj.length > 0) {
          let getLimitsObj = objCommonWeightment.getLimitsObj(dataObj.typeValue, cubicObj.Sys_RptType)
          decimal = (selectRepSrNoObj.length === 0) ? masterData[0][getLimitsObj.DecimalPoint] : protocolDecPoint;
          sample_count = selectRepSrNoObj.length;
        } else {
          decimal = protocolDecPoint
        }
      }
      // var dp;
      // if (dataObj.ProtocolUnit == 'mm') dp = 2;
      // dp = (selectRepSrNoObj.length == 0) ? protocolDecPoint : selectRepSrNoObj[0].DP


      if (sample_count == Number(productDetail.noOfSamples) && dataObj.isExceptionValue != 1) {
        return { repSerNo: repSerNo, decimal: decimal, actualWt: actualWt };
      }

      if (!dataObj.invalidWeightFlag && actualWt.match(/[a-zA-z]/g) == null) actualWt = Number(maths.round(actualWt, decimal)).toFixed(decimal)

      let instrumentId = masterData[0]?.BalanceId
      let vernierTests = [GLOBAL_NOMENCLATURE.ThicknessMenu, GLOBAL_NOMENCLATURE.LengthMenu, GLOBAL_NOMENCLATURE.DiameterMenu, GLOBAL_NOMENCLATURE.LockedLength];
      if (vernierTests.includes(dataObj.menuName)) { instrumentId = masterData[0].VernierId }
      const insertDetail = await models[detailTableIncomplete].create({
        RepSerNo: repSerNo,
        MstSerNo: masterData[0].MstSerNo,
        RecSeqNo: seqNoOfWt,
        DataValue: actualWt,
        DataValueUnit: dataObj.unit,
        DP: decimal,
        UserId: userObj.UserId,
        UserName: userObj.UserName,
        Side: side,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        BFGCode: "NA",
        ProductName: cubicObj.Sys_ProductName,
        PVersion: cubicObj.Sys_PVersion,
        Version: cubicObj.Sys_Version,
        BatchNo: cubicObj.Sys_Batch,
        InstrumentID: instrumentId,
        isException: dataObj.isExceptionValue,
        NoOfSample: productDetail?.noOfSamples,
        SprayPeriod: cubicObj.SprayPeriod,
        NetValue: dataObj.menuName == GLOBAL_NOMENCLATURE.Differential ? actualWt : null,
        Repetition: masterData[0].Repetition,
        SFOID: masterData[0].SFOID
        // Remark: (limit == 'DisplayMessage:Within Limit' && dataObj.isExceptionValue == 0) ? 'Within Limit' : 'Out Of Limit'
      });

      let obj = {
        repSerNo: repSerNo,
        decimal: decimal,
        actualWt: actualWt
      }
      return obj;

    } catch (err) {
      console.log(`Error insert_Into_Incomplete_Detail1: ${err}`)
      throw new Error(err)
    }
  }

  async lastInsertedRecords1(batchNo, mpnCode, rptType, masterTableIncomplete, dsNo, tabIp) {
    try {
      let selectRepSrNoObj = await models[masterTableIncomplete].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BatchNo: batchNo,
          MPN_Code: mpnCode,
          DsNo: dsNo,
          // ReportType: rptType
        },
      });

      let arrResultDaily_RepNo = selectRepSrNoObj[0];
      let intMstSerNo = (arrResultDaily_RepNo) ? arrResultDaily_RepNo.RepSerNo : 1

      return intMstSerNo;

    } catch (error) {
      throw new Error(error);
    }
  }

  async insert_Into_Incomplete_Master1(dataObj) {
    try {
      const dsNo = dataObj.DsNo;
      const dsIp = dataObj.DsIp;
      const tabIp = dataObj.TabIp;
      let masterTable = dataObj.masterTableIncomplete;
      const ProtocolUnit = dataObj.unit;
      const ProtocolDecPoint = dataObj.decPoint;

      let objSelMenu = dataObj.SelectedMenuDetails;
      const objProductDetails = objSelMenu.selectedProductDetail;
      let cubicObj = dataObj.cubicObj
      const intProductType = cubicObj.ProductType;
      let userObj = dataObj.UserData;

      // var intNominal = dataObj.objProductDetails.Nominal;
      // const DecPoint = ProtocolUnit == 'mm' ? 2 : 3;

      let side = cubicObj.Sys_RotaryType;
      // var SideARR = globalData.arrside.find(k => k.DsNo == dsNo && k.TabIp == tabIp)
      // if (SideARR == undefined) {
      //   if (cubicObj.Sys_RotaryType == "Single") {
      //     side = "NA";
      //   } else if (cubicObj.Sys_RotaryType == "Double") {
      //     side = objSelMenu.Side;
      //   }
      // } else {
      //   side = SideARR.Side
      // }

      // let productMaster = globalData.arrProductTypeArray.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      // var nomdata;
      // if (intProductType == 2) {
      //   nomdata = await models.tbl_setnominalcapsule.findAll({
      //     where: {
      //       CubicleNo: hmiDetailsInPMenu.Sys_CubicNo,
      //       CubicleName: hmiDetailsInPMenu.Sys_CubicName,
      //       // BatchNo: hmiDetailsInPMenu.Sys_Batch
      //     }
      //   });
      // }
      // intNominal = intProductType == 2 ? Number(maths.round(nomdata[0].Param1_Nom, nomdata[0].Param1_DP)).toFixed(nomdata[0].Param1_DP) + ' ' + objProductDetails.unit
      // : Number(maths.round(intNominal.split(' ')[0], ProtocolDecPoint);
      // var LimitOn = productMaster.productDetail
      //for calculation,extra part added
      var dp = ProtocolDecPoint;  //ProtocolDecPoint;
      var unit_stdlimit = (objProductDetails.LimitOn == 0 ? objProductDetails.unit : '%')
      var std_Limit2;

      if (cubicObj.Sys_Area != 'Coating') {
        if (Number(intProductType == 1)) {
          // if (Number(objProductDetails.T1Neg) != 0) {
          //   if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
          //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'tablets by' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          //   } else {
          //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'tablets by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          //   }
          // } else {
          //   std_Limit1 = 'NA'
          // }
          if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
            std_Limit2 = 'None of tablets by ' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          } else {
            std_Limit2 = 'None of tablets by ±' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase();
          }
        }
        else {
          // if (Number(objProductDetails.T1Neg) != 0) {
          //   if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
          //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'Capsules by' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          //   } else {
          //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'Capsules by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          //   }
          // } else {
          //   std_Limit1 = 'NA'
          // }
          if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
            std_Limit2 = 'None of Capsules by ' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
          } else {
            std_Limit2 = 'None of Capsules by ±' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase();
          }
        }

      }


      // var nob1 = 0;
      // var noa1 = 0;
      // var nob2 = 0;
      // var noa2 = 0;

      // if (Number(ProtocolData) < Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 2
      //   nob2 = 1;
      // } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 2
      //   noa2 = 1;
      // }
      // if (dataObj.objProductDetails.T1Neg != 0 && dataObj.objProductDetails.T1Pos != 0) {
      //   if (Number(ProtocolData) < Number(dataObj.objProductDetails.T1Neg) && Number(ProtocolData) >= Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 1
      //     nob1 = 1;
      //   } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T1Pos) && Number(ProtocolData) <= Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 1
      //     noa1 = 1;
      //   }
      // }


      let repSerNoMenuSeq;
      // if (cubicObj.Sys_RptType != undefined) {
      let findRepSerNoInMenuSeq = await models.tbl_menu_sequence.findOne({
        where: {
          DS_Number: dsNo, TabIp: tabIp, RepSerNo: {
            [Op.and]: {
              [Op.ne]: null,
              [Op.ne]: 0
            }
          }
        }
      })
      if (findRepSerNoInMenuSeq) repSerNoMenuSeq = findRepSerNoInMenuSeq.RepSerNo
      // }

      let check_master_SRno;
      if (!repSerNoMenuSeq) {
        check_master_SRno = await check_srNO.check_master_SRno1(dataObj)
      }

      let lastInsertedRepserNo;
      if (!repSerNoMenuSeq) {
        let equipmentData = await models.tbl_machine.findOne({
          attributes: ['Machine_Punches'],
          where: {
            Machine_ID: cubicObj.Sys_MachineCode
          }
        })

        let balanceData = await models.tbl_balance.findOne({
          attributes: ['Bal_Model', 'Bal_Make', 'Bal_SrNo'],
          where: {
            Bal_ID: cubicObj.Sys_BalID
          }
        })

        let obj = {
          check_master_SRno: check_master_SRno,
          ProtocolUnit: ProtocolUnit,
          dsNo: dsNo,
          tabIp: tabIp,
          ProtocolDecPoint: ProtocolDecPoint,
          side: side,
          dp: dp,
          typeValue: dataObj.typeValue,
          masterTable: dataObj.masterTable,
          equipmentData: equipmentData,
          balanceData: balanceData
        }
        if (std_Limit2) {
          obj.std_Limit2 = std_Limit2
        }
        let createMasterIncompleteObj = objCommonWeightment.createMasterIncompleteObj(objProductDetails, objSelMenu, cubicObj, userObj, obj)
        const insertObj = await models[masterTable].create(createMasterIncompleteObj);
        lastInsertedRepserNo = insertObj.RepSerNo
      } else {
        //Update Initial Master
        let limitsObj = objCommonWeightment.getLimitsObj(dataObj.typeValue, cubicObj.Sys_RptType)
        if (cubicObj.Sys_CubType === "Coating") {
          limitsObj = objCommonWeightment.manageLimitobjForCoating(limitsObj)
        }
        let incompleteMasterQuery = `select ISJSON(dates_json) as IsValidJson,* from ${masterTable} where RepSerNo = ${repSerNoMenuSeq}`
        let result = await sequelize.query(incompleteMasterQuery, { type: QueryTypes.SELECT })
        // let jsonDates = {
        //   [limitsObj.PrDate]: momentObj().format("YYYY-MM-DD"),
        //   [limitsObj.PrTime]: momentObj().format("HH:mm:ss")
        // }

        // let parseDatesObj = this.parseJSON(result[0].dates_json, jsonDates)

        let updateLimits = await models[masterTable].update({
          [limitsObj.T2NegTol]: maths.round(objProductDetails.T2Neg, dp).toFixed(dp),
          [limitsObj.T2PosTol]: maths.round(objProductDetails.T2Pos, dp).toFixed(dp),
          [limitsObj.DecimalPoint]: dp,
          [limitsObj.Unit]: ProtocolUnit,
          [limitsObj.PrDate]: momentObj().format("YYYY-MM-DD"),
          [limitsObj.PrTime]: momentObj().format("HH:mm:ss"),
          // [limitsObj.PrDate]: this.customDateTimeformatter(result[0][limitsObj.PrDate], "YYYY-MM-DD"),
          // [limitsObj.PrTime]: this.customDateTimeformatter(result[0][limitsObj.PrTime], "HH:mm:ss"),
          [limitsObj.Nom]: maths.round(objProductDetails.Nom, dp).toFixed(dp),
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          // dates_json: parseDatesObj
        }, {
          where: { RepSerNo: repSerNoMenuSeq }
        })


      }

      // if (cubicObj.Sys_RptType != undefined) {
      let findRepSerNo = await models.tbl_menu_sequence.findOne({
        where: {
          DS_Number: dsNo, TabIp: tabIp, RepSerNo: {
            [Op.or]: {
              [Op.eq]: null,
              [Op.eq]: 0
            }
          }
        }
      })
      if (findRepSerNo) {
        await models.tbl_menu_sequence.update({
          RepSerNo: lastInsertedRepserNo
        }, {
          where: { RecNo: findRepSerNo.RecNo }
        })
      }
      // }

      var obj = {
        srno: lastInsertedRepserNo,
        decimal: dp
      }
      return obj
    } catch (error) {
      throw new Error(error);
    }
  }

  // async insert_Into_Incomplete_Master(dataObj, hmiDetailsInPMenu) {
  //   try {
  //     const dsNo = dataObj.DsNo;
  //     const dsIp = dataObj.DsIp;
  //     const tabIp = dataObj.TabIp;
  //     let objSelMenu = dataObj.SelectedMenuDetails;
  //     const strTableName = dataObj.strTableName;
  //     const objProductDetails = objSelMenu.selectedProductDetail;
  //     const ProtocolUnit = dataObj.ProtocolUnit;
  //     const ProtocolDecPoint = dataObj.ProtocolDecPoint;
  //     const strHmi = dataObj.strHmi;
  //     const intProductType = dataObj.productType;
  //     var intNominal = dataObj.objProductDetails.Nominal;
  //     const DecPoint = ProtocolUnit == 'mm' ? 2 : 3;
  //     let side;
  //     var SideARR = globalData.arrside.find(k => k.DsNo == dsNo && k.TabIp == tabIp)
  //     if (SideARR == undefined) {
  //       if (dataObj.objProductDetails.Rotary == "Single") {
  //         side = "NA";
  //       } else if (dataObj.objProductDetails.Rotary == "Double") {
  //         side = dataObj.objProductDetails.Side;
  //       }
  //     } else {
  //       side = SideARR.Side
  //     }

  //     let productMaster = globalData.arrProductTypeArray.find((k) => k.DsNo == dsNo);
  //     var nomdata;
  //     if (intProductType == 2) {
  //       nomdata = await models.tbl_setnominalcapsule.findAll({
  //         where: {
  //           CubicleNo: hmiDetailsInPMenu.Sys_CubicNo,
  //           CubicleName: hmiDetailsInPMenu.Sys_CubicName,
  //           // BatchNo: hmiDetailsInPMenu.Sys_Batch
  //         }
  //       });
  //     }
  //     // intNominal = intProductType == 2 ? Number(maths.round(nomdata[0].Param1_Nom, nomdata[0].Param1_DP)).toFixed(nomdata[0].Param1_DP) + ' ' + objProductDetails.unit
  //     // : Number(maths.round(intNominal.split(' ')[0], ProtocolDecPoint);
  //     var LimitOn = productMaster.productDetail
  //     //for calculation,extra part added
  //     var dp = ProtocolDecPoint;  //ProtocolDecPoint;
  //     var unit_stdlimit = (objProductDetails.LimitOn == 0 ? objProductDetails.unit : '%')
  //     var std_Limit1;
  //     var std_Limit2;

  //     if (Number(objProductDetails.ProductType == 1)) {
  //       // if (Number(objProductDetails.T1Neg) != 0) {
  //       //   if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
  //       //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'tablets by' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       //   } else {
  //       //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'tablets by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       //   }
  //       // } else {
  //       //   std_Limit1 = 'NA'
  //       // }
  //       if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
  //         std_Limit2 = 'None of tablets by ' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       } else {
  //         std_Limit2 = 'None of tablets by ±' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase();
  //       }
  //     }
  //     else {
  //       // if (Number(objProductDetails.T1Neg) != 0) {
  //       //   if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
  //       //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'Capsules by' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       //   } else {
  //       //     std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'Capsules by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       //   }
  //       // } else {
  //       //   std_Limit1 = 'NA'
  //       // }
  //       if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
  //         std_Limit2 = 'None of Capsules by ' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
  //       } else {
  //         std_Limit2 = 'None of Capsules by ±' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase();
  //       }
  //     }

  //     // var nob1 = 0;
  //     // var noa1 = 0;
  //     // var nob2 = 0;
  //     // var noa2 = 0;

  //     // if (Number(ProtocolData) < Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 2
  //     //   nob2 = 1;
  //     // } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 2
  //     //   noa2 = 1;
  //     // }
  //     // if (dataObj.objProductDetails.T1Neg != 0 && dataObj.objProductDetails.T1Pos != 0) {
  //     //   if (Number(ProtocolData) < Number(dataObj.objProductDetails.T1Neg) && Number(ProtocolData) >= Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 1
  //     //     nob1 = 1;
  //     //   } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T1Pos) && Number(ProtocolData) <= Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 1
  //     //     noa1 = 1;
  //     //   }
  //     // }


  //     let tblName = strTableName.concat("_incomplete");
  //     var check_master_SRno = await check_srNO.check_master_SRno(dataObj, hmiDetailsInPMenu, dsNo, objProductDetails, strTableName, side)

  //     const insertObj = await models[tblName].create({
  //       MstSerNo: check_master_SRno,
  //       // InstruId: 1,
  //       BFGCode: dataObj.objProductDetails.ProductId,
  //       SFOID: hmiDetailsInPMenu.Sys_SFOID,
  //       MPN_Code: hmiDetailsInPMenu.Sys_MPNCode,
  //       Repeatation: hmiDetailsInPMenu.Sys_Repeatation,
  //       ProductName: dataObj.objProductDetails.ProductName,
  //       ProductType: productMaster.productType.ProductType,
  //       Qty: Number(dataObj.objProductDetails.noOfSample),
  //       GrpQty: 0,
  //       GrpFreq: 0,
  //       DsNo: dsNo,
  //       Idsno: dsNo,
  //       TabIp: tabIp,
  //       // CubicalNo: selectedCub.Sys_CubicNo,
  //       CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
  //       Department: hmiDetailsInPMenu.Sys_dept,
  //       BalanceId: hmiDetailsInPMenu.Sys_BalID,
  //       BalanceNo: 0,
  //       // VernierId: hmiDetailsInPMenu.Sys_VernierID,
  //       VernierId: dataObj.strBalId,
  //       VernierNo: 0,
  //       BatchNo: dataObj.objProductDetails.Batch,
  //       UserId: dataObj.objProductDetails.userId,
  //       UserName: dataObj.objProductDetails.userName,
  //       PrDate: momentObj().format("YYYY-MM-DD"),
  //       PrTime: momentObj().format("HH:mm:ss"),
  //       PrEndDate: momentObj().format("YYYY-MM-DD"),
  //       PrEndTime: momentObj().format("HH:mm:ss"),
  //       // PrEndTime: '',
  //       Side: side,
  //       // SideNo:0,
  //       Unit: (ProtocolUnit).toLowerCase(),
  //       DecimalPoint: ProtocolDecPoint,
  //       WgmtModeNo: Number(dataObj.strTableName.split('master')[1]),
  //       // Nom: intNominal.split(' ')[0],
  //       // T1NegTolActual: objProductDetails.T1Neg,
  //       // T1PosTolActual: objProductDetails.T1Pos,
  //       // T2NegTolActual: objProductDetails.T2Neg,
  //       // T2PosTolActual: objProductDetails.T2Pos,
  //       T1NegTol: maths.round(objProductDetails.T2Neg, dp).toFixed(dp),
  //       T1PosTol: maths.round(objProductDetails.T2Pos, dp).toFixed(dp),
  //       // T2NegTol: dataObj.objProductDetails.T2Neg,
  //       // T2PosTol: dataObj.objProductDetails.T2Pos,
  //       NMT: objProductDetails.NMT,
  //       limitOn: objProductDetails.LimitOn,
  //       // T1NMTTab:  objProductDetailsNMT
  //       NomEmpty: "0",
  //       T1NegEmpty: "0",
  //       T1PosEmpty: "0",
  //       T2NegEmpty: "0",
  //       T2PosEmpty: "0",
  //       NomNet: "0",
  //       T1NegNet: "0",
  //       T1PosNet: "0",
  //       T2NegNet: "0",
  //       T2PosNet: "0",
  //       CubicleType: hmiDetailsInPMenu.Sys_CubType,
  //       IPQCType: hmiDetailsInPMenu.Sys_IPQCType,
  //       ReportType: hmiDetailsInPMenu.Sys_RptType,
  //       MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
  //       MFGCode: hmiDetailsInPMenu.Sys_MfgCode,
  //       BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
  //       FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
  //       HardnessID: hmiDetailsInPMenu.Sys_HardID,
  //       CubicleName: hmiDetailsInPMenu.Sys_CubicName,
  //       CubicleLocation: hmiDetailsInPMenu.Sys_Location,
  //       Stage: hmiDetailsInPMenu.Sys_Stage,
  //       // RepoLabel10: "Standard",
  //       // RepoLabel11: 0,
  //       // RepoLabel12: "Null",
  //       // RepoLabel13: "Null",
  //       Layer: "NA",
  //       Nom_stdtarget: "NULL",
  //       PrintNo: 0,
  //       IsArchived: 0,
  //       GraphType: "0",
  //       BatchComplete: 0,
  //       PVersion: hmiDetailsInPMenu.Sys_PVersion,
  //       Version: hmiDetailsInPMenu.Sys_Version,
  //       BRepSerNo: 0,
  //       Lot: dataObj.objProductDetails.lotno,
  //       Area: hmiDetailsInPMenu.Sys_Area,
  //       AvgWeight: 0,
  //       MinWeight: 0,
  //       MaxWeight: 0,
  //       StdDev: 0,
  //       MinPer: 0,
  //       MaxPer: 0,
  //       // StdLimit1: std_Limit1,
  //       StdLimit2: std_Limit2,
  //       NoOfBelow1: 0,
  //       NoOfAbove1: 0,
  //       NoOfBelow2: 0,
  //       NoOfAbove2: 0,
  //       Inprocess: 1
  //     });

  //     let arrResult = [insertObj.dataValues];
  //     var obj = {
  //       srno: arrResult[0].RepSerNo,
  //       decimal: dp
  //     }
  //     return obj
  //   } catch (error) {
  //     throw new Error(error);
  //   }
  // }

  // async insert_Into_Incomplete_Detail(dataObj, hmiDetailsInPMenu, userobj) {
  //   try {
  //     const strmasterTbl = dataObj.strTableName;
  //     const strDetailTbl = dataObj.strDetailTbl;
  //     let dsNo = dataObj.DsNo
  //     let strProtocolData = dataObj.ProtocolData;
  //     const strDecPoint = dataObj.ProtocolDecPoint;
  //     const RecSampleNo = dataObj.RecSampleNo;
  //     var decimal;
  //     let tabIp = dataObj.TabIp;
  //     let selectedDsNo;

  //     var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
  //     if (IPQCObject != undefined) {
  //       selectedDsNo = IPQCObject.selectedDs;
  //     } else {
  //       selectedDsNo = dsNo;
  //     }
  //     let side;
  //     var SideARR = globalData.arrside.find(k => k.DsNo == dsNo && k.TabIp == tabIp)
  //     if (SideARR == undefined) {
  //       if (dataObj.objProductDetails.Rotary == "Single") {
  //         side = "NA";
  //       } else if (dataObj.objProductDetails.Rotary == "Double") {
  //         side = dataObj.objProductDetails.Side;
  //       }
  //     } else {
  //       side = SideARR.Side
  //     }

  //     let repSerNo = await this.lastInsertedRecords(
  //       hmiDetailsInPMenu.Sys_ProductName,
  //       hmiDetailsInPMenu.Sys_BFGCode,
  //       // hmiDetailsInPMenu.Sys_PVersion,
  //       // hmiDetailsInPMenu.Sys_Version,
  //       // hmiDetailsInPMenu.Sys_Batch,
  //       strmasterTbl,
  //       dsNo,
  //       tabIp
  //     );
  //     /**
  //      * get decimal
  //      */
  //     let tbName = strDetailTbl.concat("_incomplete");
  //     const selectRepSrNoObj = await models[tbName].findAll({
  //       where: {
  //         RepSerNo: repSerNo,
  //       },
  //     });
  //     let arrResult_RepNo = [selectRepSrNoObj];
  //     if (arrResult_RepNo[0].length == 0) {
  //       decimal = strDecPoint;
  //     } else {
  //       decimal = arrResult_RepNo[0][0].DP;
  //     }

  //     let tbNamemaster = strmasterTbl.concat("_incomplete");
  //     const selectObj = await models[tbNamemaster].findAll({
  //       where: {
  //         RepSerNo: repSerNo
  //       },
  //     });
  //     var dp;
  //     if (dataObj.ProtocolUnit == 'mm') {
  //       dp = 2
  //     } else {
  //       dp = selectObj[0].DecimalPoint
  //     }
  //     var sample_count = selectRepSrNoObj.length
  //     if (sample_count == Number(dataObj.objProductDetails.noOfSample) && dataObj.isExceptionValue != 1) {
  //       return { repSerNo: repSerNo, decimal: decimal };
  //     }

  //     if (dataObj.isExceptionValue === 0) strProtocolData = Number(maths.round(strProtocolData, dp)).toFixed(dp)

  //     var tableName = strDetailTbl.concat("_incomplete");
  //     const insertDetail = await models[tableName].create({
  //       RepSerNo: repSerNo,
  //       MstSerNo: selectObj[0].MstSerNo,
  //       RecSeqNo: RecSampleNo,
  //       DataValue: strProtocolData,
  //       DP: decimal,
  //       UserId: userobj.UserId,
  //       UserName: userobj.UserName,
  //       // Side: side,
  //       PrDate: momentObj().format("YYYY-MM-DD"),
  //       PrTime: momentObj().format("HH:mm:ss"),
  //       PrEndDate: momentObj().format("YYYY-MM-DD"),
  //       PrEndTime: momentObj().format("HH:mm:ss"),
  //       BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
  //       ProductName: hmiDetailsInPMenu.Sys_ProductName,
  //       PVersion: hmiDetailsInPMenu.Sys_PVersion,
  //       Version: hmiDetailsInPMenu.Sys_Version,
  //       BatchNo: hmiDetailsInPMenu.Sys_Batch,
  //       BalanceId: hmiDetailsInPMenu.Sys_BalID,
  //       isException: dataObj.isExceptionValue
  //     });


  //     let arrResult = [insertDetail.dataValues];
  //     let obj = {
  //       repSerNo: repSerNo,
  //       decimal: dp,
  //       strProtocolData: strProtocolData
  //     }
  //     return obj;
  //   } catch (error) {
  //     throw new Error(error);
  //   }
  // }

  async lastInsertedRecords(
    strProductName,
    StrBFGCode,
    // StrProductVersion,
    // StrVersion,
    // StrBatch,
    tableName,
    dsNo,
    tabIp
  ) {
    try {
      let intMstSerNo;
      tableName = tableName.concat("_incomplete");
      let selectRepSrNoObj = await models[tableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          ProductName: strProductName,
          BFGCode: StrBFGCode,
          DsNo: dsNo,
          TabIp: tabIp
          // PVersion: StrProductVersion,
          // Version: StrVersion,
          // BatchNo: StrBatch,
          // Idsno: Ip
        },
      });

      let arrResultDaily_RepNo = [selectRepSrNoObj];

      let intDaily_RepNo = arrResultDaily_RepNo[0].RepSerNo;
      if (arrResultDaily_RepNo[0][0].RepSerNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = arrResultDaily_RepNo[0][0].RepSerNo;
        intMstSerNo = newMstSerNo;
      }
      return intMstSerNo;
    } catch (error) {
      console.log(error);
    }
  }

  async lastInsertedSeqNo(tableName, repSerNo) {
    try {
      tableName = tableName.concat("_incomplete");
      let selectRepSrNoObj = await models[tableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RecSeqNo")), "RecSeqNo"],
        ],
        where: {
          RecSeqNo: repSerNo,
          // BatchNo:cubicalObj.Sys_Batch,
          // Idsno:cubicalObj.Sys_IDSNo
        },
      });

      let arrResultDaily_RepNo = [selectRepSrNoObj];

      // let intDaily_RepNo = arrResultDaily_RepNo[0].RepSerNo;
      let intMstSerNo;
      if (arrResultDaily_RepNo[0][0].RecSeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = arrResultDaily_RepNo[0][0].RecSeqNo;
        intMstSerNo = newMstSerNo + 1;
      }
      return intMstSerNo;
    } catch (error) {
      console.log(error);
    }
  }


  async findRecSequenceNumberforCoating(masterRepSerNo, masterEntry) {
    try {
      let recSeqNo;
      let batchDetailEntries = await models[`tbl_batchsummary_detail2_Coating`].findAll({
        where: {
          RepSerNo: masterRepSerNo,
          // Side: masterEntry[0].Side
        }
      })

      if (batchDetailEntries.length > 0) {
        let lastRecord = batchDetailEntries[batchDetailEntries.length - 1].RecSeqNo
        recSeqNo = lastRecord + 1
      } else {
        recSeqNo = 1
      }
      console.log(recSeqNo)
      return recSeqNo
    } catch (error) {
      console.log(error)
    }
  }


  async checkMasterEntryOfCoating(data, repSerNo, masterEntry, userInfo, date, endDate, time, endTime) {
    try {
      let batchSummaryMasterTable = `tbl_batchsummary_master2_Coating`
      let perticularBatchMaster = await models[batchSummaryMasterTable].findAll(
        {
          where: {
            // RepSerNo: data.RepSerNo,
            BatchNo: data.dataObj.cubicObj.Sys_Batch,
            Area: data.dataObj.cubicObj.Sys_Area,
            CubicName: data.dataObj.cubicObj.Sys_CubicName
          }
        }
      )

      if (perticularBatchMaster.length > 0) {
        return perticularBatchMaster[0].RepSerNo
      }
      else {
        const objInsertMasterData = await models[batchSummaryMasterTable].create({
          // RepSerNo: masterEntry[0].RepSerNo,
          MPN_Code: masterEntry[0].MPN_Code,
          Area: masterEntry[0].Area,
          BFGCode: masterEntry[0].BFGCode,
          ProductName: masterEntry[0].ProductName,
          PVersion: masterEntry[0].PVersion,
          PrdType: masterEntry[0].PrdType ? masterEntry[0].PrdType : 1,
          Version: masterEntry[0].Version,
          BatchNo: masterEntry[0].BatchNo,
          CubicalNo: masterEntry[0].CubicalNo,
          CubicleType: masterEntry[0].CubicleType,
          CubicName: masterEntry[0].CubicleName,
          BatchSize: masterEntry[0].BatchSize,
          AvgValue: masterEntry[0].AvgWeight,//////////
          Remark: masterEntry[0].Remark,
          PrDate: masterEntry[0].PrDate,
          PrEndDate: masterEntry[0].PrEndDate,
          PrEndTime: masterEntry[0].PrEndTime,
          StartDate: `${momentObj(date).format('DD.MM.YYYY')} ${momentObj(time).format("HH:mm:ss")}`,
          EndDate: `${momentObj(endDate).format('DD.MM.YYYY')} ${momentObj(endTime).format("HH:mm:ss")}`,
          // DP: masterEntry[0].DP,   // NO ABOVE DATA IN THE MASTER2 TABLE
          Unit: masterEntry[0].Unit,
          Lot: masterEntry[0].Lot,
          BatchCompleted: 1,
          // StdTime: masterEntry[0].,
          MachineCode: masterEntry[0].MachineCode,
          // NoOfStations: masterEntry[0].CubicleType,
          // LHSContainerNo: masterEntry[0].CubicleType,
          // RHSContainerNo: masterEntry[0].CubicleType,


          Make: masterEntry[0].Make,
          Model: masterEntry[0].Model,
          SerialNo: masterEntry[0].SerialNo,
          CoatingType: masterEntry[0].CoatingType,
          SprayPeriod: masterEntry[0].SprayPeriod,
          MesTestType: masterEntry[0].MesTestType,

          // BatchStartTime: masterEntry[0].CubicleType,
          // BatchEndTime: masterEntry[0].CubicleType,

          SFOID: masterEntry[0].SFOID,
          Repetition: masterEntry[0].Repetition,
          InstrumentID: masterEntry[0].BalanceId,
          // UserName: masterEntry[0].CubicleType



        })
        console.log(objInsertMasterData._previousDataValues.RepSerNo)
        return objInsertMasterData._previousDataValues.RepSerNo
      }

    } catch (error) {
      throw new Error(error);
    }
  }



  async saveCompleteBatchDataCoating(data) {
    try {

      let userInfo = globalData.arrUsers.filter(e => e.DsNo == data.dsNo && e.TabIp == data.tabIp)[0];

      let repSerNo = data.isWTTrfr.RepSerNo;

      let masterEntry = await models.tbl_tab_master2.findAll(
        {
          where: {
            BatchNo: data.dataObj.cubicObj.Sys_Batch,
            RepSerNo: repSerNo,
            CubicleName: data.dataObj.cubicObj.Sys_CubicName
          }
        }
      )

      let detailEntries = await models.tbl_tab_detail2.findOne({
        where: {
          BatchNo: data.dataObj.cubicObj.Sys_Batch,
          RepSerNo: repSerNo,
          // CubicleName: data.dataObj.cubicObj.Sys_CubicName
        }
      })

      let date = detailEntries.PrDate
      let endDate = detailEntries.PrEndDate
      let time = detailEntries.PrTime
      let endTime = detailEntries.PrEndTime

      if (masterEntry.length > 0) {

        let masterRepSerNo = await this.checkMasterEntryOfCoating(data, repSerNo, masterEntry, userInfo, date, endDate, time, endTime);
        let recSequenceNo = await this.findRecSequenceNumberforCoating(masterRepSerNo, masterEntry);


        await models.tbl_batchsummary_detail2_Coating.create({
          RepSerNo: masterRepSerNo,
          RecSeqNo: recSequenceNo,
          Date: moment().format('YYYY-MM-DD'),
          Time: moment().format('hh:mm:ss'),
          InstrumentID: masterEntry[0].BalanceId,
          Avg: masterEntry[0].AvgWeight,
          // TestResult: masterEntry[0].TestResult,
          UserID: masterEntry[0].UserID,
          UserName: masterEntry[0].UserName,
          NoOfSample: masterEntry[0].Qty,
          StartTime: `${momentObj(date).format('DD.MM.YYYY')} ${momentObj(time).format("HH:mm:ss")}`,
          EndTime: `${momentObj(endDate).format('DD.MM.YYYY')} ${momentObj(endTime).format("HH:mm:ss")}`,
          SprayPeriod: masterEntry[0].SprayPeriod,
          MesTestType: masterEntry[0].MesTestType,
          DataValue: detailEntries.DataValue,
          DataValue1: detailEntries.DataValue1,
          DataValue2: detailEntries.DataValue2
        })

      }

    } catch (error) {
      throw new Error(error);
    }
  }



  async saveCompleteData1(dataObj) {
    try {
      var tabIp = dataObj.TabIp
      let dsNo = dataObj.DsNo;
      let selectedDsNo;
      // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      // if (IPQCObject != undefined) {
      //   selectedDsNo = IPQCObject.selectedIds;
      // } else {
      //   selectedDsNo = dsNo;
      // }

      let result = await objIncompleteReport.getIncompleteData1(dataObj);
      let reportStatus = await this.removeLimitForRemark1(dataObj, result);
      // await objBatchSummary.saveBatchData1(dataObj, result);
      let isWTTrfr = await objWeighmentDataTransfer.saveCommonDataToComplete1(dataObj, result, dataObj.typeValue);

      // Batch_summray_Coating
      await this.saveCompleteBatchDataCoating({ dsNo, tabIp, dataObj, isWTTrfr });

      var res = isWTTrfr
      await this.deleteIncompleteRemarkEntry(dsNo, tabIp);
      var obj = { res: res }
      return obj;
    } catch (error) {
      throw new Error(error);
    }
  }

  async updateMenuSequenceEntry(dsNo, tabIp, menuName, repSerNo, masterTableIncomplete, masterTable, cubicObj, portNo, side, eqpModel, finalRemark) {
    let dbMenuName = objCommonWeightment.getDbMenuSeqFromMenu(menuName);
    await models.tbl_menu_sequence.update({ [dbMenuName]: 1 }, { where: { DS_NUMBER: dsNo, TabIp: tabIp } })

    var menuSequenceTable = await models.tbl_menu_sequence.findOne({
      attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'RepSerNo', 'TabIp'] },
      where: {
        DS_Number: dsNo,
        TabIp: tabIp
      }
    })

    var count = 0;
    for (let ele in menuSequenceTable) {
      if (menuSequenceTable[`${ele}`] == 0) count++
    }

    if (count == 0) {
      var flag = false
      var newRepSrno = await this.moveIncompleteToCompleteInitial(repSerNo, menuSequenceTable, dsNo, tabIp, masterTableIncomplete, masterTable, cubicObj, portNo, side, eqpModel)
      await this.saveCompleteBatchData({ menuSequenceTable, dsNo, tabIp, cubicObj, newRepSrno })
      // if (menuName != `${GLOBAL_NOMENCLATURE.DTMenu} Test`) {
      if (cubicObj.isManual == 1) flag = true
      mqttSender.sendData(dsNo, `Port ${portNo}:${GLOBAL_NOMENCLATURE.TestCompleted} ${finalRemark}:OkBtn ${flag}`)
      if (cubicObj.isManual == 0) {
        mqttSender.sendData(dsNo, `Port ${portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
      }
    } else {
      finalRemark = cubicObj.isPreStart == 1 && ConfigFile.plant == "PUI" ? "Test Completed" : finalRemark;
      mqttSender.sendData(dsNo, `Port ${portNo}:${GLOBAL_NOMENCLATURE.TestCompleted} ${finalRemark}:OkBtn true`)
    }
    return count;
  }

  async handleMultiTesterData(cubicObj, menuName, dsNo, tabIp, payloadObj, masterRepNo, repSerNo, masterData, remarkObj) {
    try {
      let getTableName = objCommonWeightment.getTableName(cubicObj, GLOBAL_NOMENCLATURE.IndividualMenu, dsNo, tabIp)
      let detailTableIncomplete = getTableName.detailTableIncomplete
      let detailTable = getTableName.detailTable;

      var detailIncompData = await models[detailTableIncomplete].findOne({ attributes: { exclude: ["RepSerNo", "RecNo", "isException", "Remark", "isCompleted"] } })
      detailIncompData = Object.keys(detailIncompData).toString();

      var str_Query = `INSERT INTO ${detailTable} (${detailIncompData}) OUTPUT inserted.RecNo SELECT ${detailIncompData} FROM ${detailTableIncomplete} where RepSerNo = ${repSerNo} AND isCompleted = 0 AND isException = 0 Order By RecSeqNo ASC`
      let result = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      let getLimitsObj = objCommonWeightment.getLimitsObj(getTableName.typeValue, cubicObj.Sys_RptType);
      let unit = masterData[getLimitsObj.Unit]
      let indDifference = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
      let testInfo = {
        unit: masterData[getLimitsObj.Unit],
        averageWeight: `${masterData[getLimitsObj.AvgWeight]} ${unit}`,
        maxWeight: `${masterData[getLimitsObj.MaxWeight]} ${unit}`,
        minWeight: `${masterData[getLimitsObj.MinWeight]} ${unit}`,
        stdWeight: `${masterData[getLimitsObj.StdDev]} ${unit}`,
        rstdWeight: `${masterData[getLimitsObj.RStdDev]} ${unit}`,
        totalweight: `${masterData[getLimitsObj.TotalWeight]} ${unit}`,
        indDifference: `${Number(indDifference).toFixed(3)} ${unit}`
      }

      if (result[0].length > 0) {
        let recNoArr = result[0].map(e => e.RecNo)
        await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RecNo: { [Op.in]: recNoArr } }, RepSerNo: masterRepNo })
        await models[detailTableIncomplete].destroy({ where: { RepSerNo: repSerNo } })
      }

      let multiTesterIndividualData = await models[detailTable].findAll({ attributes: [['DataValue', 'value']], where: { RepSerNo: masterRepNo } })
      if (multiTesterIndividualData.length > 0) {
        let unit = this.isNullOrStringNull(testInfo.unit);
        if (!unit) {
          multiTesterIndividualData = multiTesterIndividualData.map(e => ({
            ...e,
            value: `${e.value} ${testInfo.unit}`
          }))
        }
        multiTesterIndividualData = multiTesterIndividualData.map(e => ({ data: { ...e, isMesChecked: false } }))
        payloadObj.MultiTesterHardness = { 'TestData': multiTesterIndividualData }
        payloadObj.MultiTesterHardness.TestInfo = testInfo
      }
      remarkObj[getLimitsObj.Remark] = 'Within Limit';

      return payloadObj

    } catch (err) {
      throw new Error(err)
    }
  }

  isNullOrStringNull(unit) {
    console.log(unit == null || (typeof unit === 'string' && unit.toLowerCase() === 'null'));
    return unit == null || (typeof unit === 'string' && unit.toLowerCase() === 'null');
  }

  async moveIncompleteToCompleteInitial(repSerNo, menuSequenceTable, dsNo, tabIp, masterTableIncomplete, masterTable, cubicObj, portNo, side, eqpModel) {
    try {
      var masterRepNo = await this.insertIntoMasterTable(masterTableIncomplete, masterTable, repSerNo)
      let payloadObj = {}
      let remarkObj = {}

      let Dp = serverConfigs.plant == "PUI" ? 4 : 3;

      for (let keys in menuSequenceTable) {
        let testInfo;
        let friabUnit;
        if (menuSequenceTable[keys] == 1) {
          let menuName = objCommonWeightment.getMenuNmFromMenuSeq(keys);
          let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp)
          let detailTableIncomplete = getTableName.detailTableIncomplete
          let detailTable = getTableName.detailTable;
          // if (menuName != GLOBAL_NOMENCLATURE.Friability) {
          let excludedArr = [];
          let detailIncompWhereCondition = '';
          let exceptionWhereCondition = {};
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.HardnessMenu || menuName == GLOBAL_NOMENCLATURE.Differential || menuName == GLOBAL_NOMENCLATURE.Friability) {
            excludedArr = ["RepSerNo", "RecNo", "isException", "Remark", "isCompleted"];
            if (menuName == GLOBAL_NOMENCLATURE.HardnessMenu) {
              excludedArr.push('isTerminated')
              detailIncompWhereCondition = `RepSerNo = ${repSerNo} AND isException = 0 AND isCompleted = 0 AND isTerminated = 0`;
            } else {
              detailIncompWhereCondition = `RepSerNo = ${repSerNo} AND isException = 0 AND isCompleted = 0`;

            }
            exceptionWhereCondition = { RepSerNo: repSerNo, isException: 1, isCompleted: 0 }
          } else {
            excludedArr = ["RepSerNo", "RecNo", "isException", "Remark", "isCompleted"];
            detailIncompWhereCondition = `RepSerNo = ${repSerNo} AND isException = 0 AND isCompleted = 0`;
            exceptionWhereCondition = { RepSerNo: repSerNo, isException: 1 }
          }
          var detailIncompData = await models[detailTableIncomplete].findOne({ attributes: { exclude: excludedArr } })
          detailIncompData = Object.keys(detailIncompData).toString();

          var str_Query = `INSERT INTO ${detailTable} (${detailIncompData}) OUTPUT inserted.RecNo SELECT ${detailIncompData} FROM ${detailTableIncomplete} where ${detailIncompWhereCondition}`
          let result = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

          var detailMasterData = await models[masterTableIncomplete].findAll({ where: { RepSerNo: repSerNo } })
          let masterData = detailMasterData[0];

          let multiTesterUnit;
          if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
            let data_eqp = await models.tbl_otherequipment.findAll({
              where: {
                Eqp_ID: cubicObj.Sys_HardID
              }
            })
            eqpModel = data_eqp[0].Eqp_Make
          }
          // if (eqpModel == 'Pharmatest' && menuName == GLOBAL_NOMENCLATURE.Hardness && cubicObj.Sys_RptType == 0) {
          if (eqpModel == 'Pharmatest' && menuName == GLOBAL_NOMENCLATURE.Hardness && cubicObj.Sys_RptType == 0) {
            payloadObj = await this.handleMultiTesterData(cubicObj, menuName, dsNo, tabIp, payloadObj, masterRepNo, repSerNo, masterData, remarkObj)
            multiTesterUnit = payloadObj?.MultiTesterHardness?.TestInfo.Unit
          }

          let menuNotIncludeCalcArr = [GLOBAL_NOMENCLATURE.DTMenu, GLOBAL_NOMENCLATURE.Friability]
          let typeValue = (getTableName.typeValue == 'htd') ? 7 : getTableName.typeValue;
          let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, cubicObj.Sys_RptType);
          remarkObj[getLimitsObj.Remark] = 'Within Limit'
          if (!menuNotIncludeCalcArr.includes(menuName)) {
            let unit = masterData[getLimitsObj.Unit]
            testInfo = {
              unit: (masterData[getLimitsObj.Unit]) ? masterData[getLimitsObj.Unit] : '',
              averageWeight: `${masterData[getLimitsObj.AvgWeight]} ${unit}`,
              maxWeight: `${masterData[getLimitsObj.MaxWeight]} ${unit}`,
              minWeight: `${masterData[getLimitsObj.MinWeight]} ${unit}`,
              stdWeight: `${masterData[getLimitsObj.StdDev]} ${unit}`,
              rstdWeight: `${masterData[getLimitsObj.RStdDev]} ${unit}`,
              totalweight: `${masterData[getLimitsObj.TotalWeight]} ${unit}`,
            }
            if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
              testInfo.stdWeight = `${masterData[getLimitsObj.StdDev]} ${'%'}`;
              let hardranges = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              testInfo.hardrange = `${Number(hardranges).toFixed(3)} ${unit}`
            }

            if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.Differential) {
              let indDifference = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              testInfo.indDifference = `${Number(indDifference).toFixed(Dp)} ${unit}`
            }

            if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
              let getLimitsObj = objCommonWeightment.getLimitsObj(3, cubicObj.Sys_RptType);
              testInfo.unitThick = (masterData[getLimitsObj.Unit]) ? masterData[getLimitsObj.Unit] : '';
              testInfo.averageWeightThick = `${masterData[getLimitsObj.AvgWeight]} ${testInfo.unitThick}`
              testInfo.maxWeightThick = `${masterData[getLimitsObj.MaxWeight]} ${testInfo.unitThick}`
              testInfo.minWeightThick = `${masterData[getLimitsObj.MinWeight]} ${testInfo.unitThick}`
              testInfo.stdWeightThick = `${masterData[getLimitsObj.StdDev]} ${testInfo.unitThick}`
              testInfo.rstdWeightThick = `${masterData[getLimitsObj.RStdDev]} ${testInfo.unitThick}`
              testInfo.totalweightThick = `${masterData[getLimitsObj.TotalWeight]} ${testInfo.unitThick}`
              let thirange = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              testInfo.Thickrange = `${Number(thirange).toFixed(3)} ${testInfo.unitThick}`
              remarkObj[getLimitsObj.Remark] = 'Within Limit'
            }
          } else {
            // let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, cubicObj.Sys_RptType);
            friabUnit = masterData[getLimitsObj.Unit]
            // friabUnit = 'gm';
          }

          var exceptionData = await models[detailTableIncomplete].findAll({ where: exceptionWhereCondition })
          if (exceptionData.length > 0) {
            if (!(eqpModel == 'Vankel' && menuName == GLOBAL_NOMENCLATURE.Hardness)) {
              let exceptionResult = await objWeighmentDataTransfer.moveToExceptionTable(masterRepNo, menuName, detailMasterData[0], exceptionData, cubicObj.Sys_RptType, 0)
            }
          }

          if (result[0].length > 0) {
            let recNoArr = result[0].map(e => e.RecNo)
            await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RecNo: { [Op.in]: recNoArr } }, RepSerNo: masterRepNo })
            let termOrCom = excludedArr.includes('isTerminated') ? 'isTerminated' : 'isCompleted'
            await models[detailTableIncomplete].destroy({ where: { RepSerNo: repSerNo, [termOrCom]: 0 } })
          }
          // }

          // // In Group, we don't store data in detail incomplete table
          // if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
          //   // await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo } })
          //   await models.tbl_exception_sample_initial.update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo, MenuName: menuName } })
          // }

          if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
            await models.tbl_exception_samplehtd_initial.update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo, isTerminated: 0, BatchNo: masterData.BatchNo, Repetition: masterData.Repetition, SFOID: masterData.SFOID } })
            if (eqpModel == 'Pharmatest') {
              await models.tbl_exception_sample_initial.update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo, isTerminated: 0, BatchNo: masterData.BatchNo, SFOID: masterData.SFOID, Repetition: masterData.Repetition } })
            }
          }

          if (cubicObj.isManual == 0) {
            let menuObj = {};
            let attributes;
            switch (menuName) {
              case GLOBAL_NOMENCLATURE.Hardness:
                attributes = [['DataValueHard', 'H'], ['DataValueThick', 'T'], ['DataValueDiam', 'D'], ['DataValueBL', 'BL']]
                break;

              case GLOBAL_NOMENCLATURE.Friability:
                attributes = ['NetValue', 'BeforeValue', 'AfterValue']
                break;

              default:
                attributes = [['DataValue', 'value']];
                break;
            }

            // let attributes = menuName == 'Hardness' ? ['DataValueHard', 'DataValueThick', 'DataValueDiam', 'DataValueBL'] : [['DataValue', 'value']];
            let actualWtData = await models[detailTable].findAll({ attributes: attributes, where: { RepSerNo: masterRepNo } })
            if (cubicObj.isPreStart == 1) {
              if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                exceptionData.map((e) => {
                  actualWtData.splice(e.RecSeqNo - 1, 0, { H: e.DataValueHard, T: e.DataValueThick }
                  )
                })
              } else {
                exceptionData.map((e) => {
                  actualWtData.splice(e.RecSeqNo - 1, 0, { value: e.DataValue }
                  )
                })
              }

            }
            if (actualWtData.length > 0) {
              // Appending Unit According to Menu
              if (testInfo) {
                let isUnitValid = this.isNullOrStringNull(testInfo.unit);
                if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                  if (!isUnitValid) {
                    actualWtData = actualWtData.map(e => ({
                      ...e,
                      H: (testInfo.unit) ? `${e.H} ${testInfo.unit}` : `${e.H}`,
                      T: (testInfo.unitThick) ? `${e.T} ${testInfo.unitThick}` : `${e.T}`,
                      BL: (multiTesterUnit) ? `${e?.BL} ${multiTesterUnit} ` : `${e?.BL}`
                    }))
                  }
                }
                if (menuName != GLOBAL_NOMENCLATURE.Hardness) {
                  if (!isUnitValid) {
                    actualWtData = actualWtData.map(e => ({
                      ...e,
                      value: `${e.value} ${testInfo.unit}`
                    }))
                  }
                }
              }

              if (menuName == GLOBAL_NOMENCLATURE.Friability) {
                actualWtData = actualWtData.map(e => ({
                  ...e,
                  NetValue: (friabUnit) ? `${e.NetValue} % ` : `${e.NetValue} %`,
                  BeforeValue: (friabUnit) ? `${e.BeforeValue} ${friabUnit}` : `${e.BeforeValue}`,
                  AfterValue: (friabUnit) ? `${e.AfterValue} ${friabUnit}` : `${e.AfterValue}`,
                }))
              }
              if (menuName != GLOBAL_NOMENCLATURE.Hardness) {
                actualWtData = actualWtData.map(e => ({ data: { ...e, isMesChecked: false } }))
              }
              if (testInfo) {
                menuObj[menuName] = { 'TestData': actualWtData }
                menuObj[menuName].TestInfo = testInfo
              } else {
                menuObj[menuName] = actualWtData
              }
              payloadObj = Object.assign(payloadObj, menuObj)
            }
            // remarkObj[getLimitsObj.Remark] = 'Within Limit'
            // await models[masterTable].update(remarkObj, { where: { RepSerNo: masterRepNo } })
          }
        }
      }
      if (cubicObj.isManual == 0) {
        let mesData = globalData.MESArray.filter(e => e.dsNo == dsNo && e.portNo == portNo)
        if (mesData.length == 0) {
          let sideChangeMsg;
          if (side == 'RHS') sideChangeMsg = `Port ${portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} Side Changes to RHS`;
          let selectedDSNo = dsNo;
          let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == dsNo && k.tabIp == tabIp);
          if (arrIPQC != undefined) {
            selectedDSNo = arrIPQC.selectedDs.dsNo
          }
          let data = {
            payload: payloadObj,
            DsNo: dsNo,
            TabIp: tabIp,
            selectedDSNo: selectedDSNo,
            portNo: portNo,
            RptType: cubicObj.Sys_RptType,
            isCompleted: true,
            isPosted: false,
            mqttProtocol: sideChangeMsg,
            batchId: cubicObj.Sys_Batch,
            sfoId: cubicObj.Sys_SFOID,
            RepSerNo: masterRepNo,
            Area: cubicObj.Sys_Area
          }
          globalData.MESArray.push(data)
        }
        console.log("-----------Initial------------------");
        console.log(globalData.MESArray);
      }

      remarkObj.IntervalStopTm = momentObj().format('YYYY-MM-DD HH:mm:ss')
      remarkObj.PrDate = momentObj().format('YYYY-MM-DD')
      remarkObj.PrTime = momentObj().format('HH:mm:ss')
      remarkObj.Inprocess = 0
      let isDestroyed = await models[masterTableIncomplete].destroy({ where: { RepSerNo: repSerNo } })
      // let isDestroyed = await models[masterTableIncomplete].destroy({ where: { RepSerNo: repSerNo, isTerminated: 0 } })
      // if (!isDestroyed) {
      // let masterParameters = await models[masterTableIncomplete].findOne({
      //   where:{
      //     RepSerNo:repSerNo
      //   }
      // })
      // await this.updateDatesInMasterTable(repSerNo,masterParameters.dates_json,remarkObj)
      // let columnNameRegex = /(min|max|avg)/i
      // let remarkRegex = /(remark)/i
      // // let paramRegex = /^Param\d+_Pr/
      // let dateReplacemnet = {
      //   Param13_PrDate :  moment('1992-12-08').format('YYYY-MM-DD'),
      //   Param13_PrEndDate :  moment('1992-12-08').format('YYYY-MM-DD'),
      //   Param13_PrEndTime : moment('1992-12-08').startOf('day').format('YYYY-MM-DD HH:mm:ss.SSS0000'),
      //   Param13_PrTime : moment('1992-12-08').startOf('day').format('YYYY-MM-DD HH:mm:ss.SSS0000'),
      // }

      // let inCompDatesObj = JSON.parse(masterParameters.dates_json)
      // for (let key in masterParameters) {
      //   if (key.toLowerCase().match(columnNameRegex) && key.toLowerCase() != 'isterminated') {
      //     masterParameters[key] = 0
      //   } else if (key.toLowerCase().match(remarkRegex)) {
      //     masterParameters[key] = null
      //   }else if( (/^Param\d+_Pr/.test(key)) && inCompDatesObj.hasOwnProperty(key)){
      //       if(moment(masterParameters[key]).format('HH:mm:ss') == inCompDatesObj[key] && key.toLowerCase().includes('time')){
      //         // masterParameters[key] =  moment().startOf('day').format('HH:mm:ss');
      //         masterParameters[key] = moment('1992-12-08').startOf('day').format('YYYY-MM-DD HH:mm:ss.SSS0000');
      //         let startTime;
      //         let endDate;
      //         let startDate;
      //         if(key.includes('EndTime')){
      //             startTime = key.replace('EndTime','Time')
      //             endDate = key.replace('Time','Date')
      //             startDate  = key.replace('EndTime','Date')
      //         }else{
      //             startTime = key
      //             startDate  = key.replace('Time','Date')
      //             endDate = key.replace('Time','EndDate')
      //         }

      //         dateReplacemnet[startTime] = moment('1992-12-08').startOf('day').format('YYYY-MM-DD HH:mm:ss.SSS0000');
      //         dateReplacemnet[endDate] = moment('1992-12-08').format('YYYY-MM-DD')
      //         dateReplacemnet[startDate] = moment('1992-12-08').format('YYYY-MM-DD')

      //         // .format('YYYY-MM-DD HH:mm:ss');

      //       }else{
      //         delete masterParameters[key]
      //       }
      //   }else {
      //     delete masterParameters[key]
      //   }
      // }

      // Object.assign(masterParameters,dateReplacemnet)

      // await this.updateAndDeleteJson(repSerNo, remarkObj)


      // await models[masterTableIncomplete].update(
      //   masterParameters, 
      //   {      
      //   where:{
      //     RepSerNo:repSerNo
      //   }

      // })
      // }
      await models[masterTable].update(remarkObj, { where: { RepSerNo: masterRepNo } })
      await models.tbl_mes_data.update({ isTestCompleted: 1 }, { where: { DS_Number: dsNo, BatchID: cubicObj.Sys_Batch, isSetInCubical: 1 } })
      // await models.tbl_menu_sequence.destroy({ where: { DS_Number: dsNo, TabIp: tabIp, RepSerNo: repSerNo } })
      // // Mes Data Only be deleted for Inprocess here for Startup in sendMenu we will check
      // if (cubicObj.isManual == 1 && cubicObj.Sys_RptType == 0) {
      //   await models.tbl_mes_data.destroy({ where: { DS_Number: dsNo } })
      // }
      // if (cubicObj.isManual == 0 && serverConfigs.plant == "PUI") {
      //   await models.tbl_menu_sequence.destroy({ where: { DS_Number: dsNo, TabIp: tabIp, RepSerNo: repSerNo } })
      //   // await models.tbl_mes_data.destroy({ where: { DS_Number: dsNo } })
      // }

      return masterRepNo

    } catch (err) {
      throw new Error(err)
    }
  }

  async insertIntoMasterTable(masterTableIncomplete, masterTable, repSerNo) {
    try {
      var str_master = await models[masterTableIncomplete].findOne({
        attributes: { exclude: ["RepSerNo", "inprocess", "isTerminated", "dates_json"] }
      })

      str_master = Object.keys(str_master).toString()

      var str_Query = `INSERT INTO ${masterTable} (${str_master}) OUTPUT inserted.RepSerNo SELECT ${str_master} FROM ${masterTableIncomplete} where RepSerNo = ${repSerNo}`

      var RepSrNo = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      return RepSrNo[0][0].RepSerNo

    } catch (error) {
      throw new Error(error)
    }
  }

  async removeLimitForRemark1(dataObj, result) {
    try {
      let objSelMenu = dataObj.SelectedMenuDetails;
      const objProductDetails = objSelMenu.selectedProductDetail;
      let typeValue = dataObj.typeValue;
      // let selectedDsNo;
      // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo);
      // if (IPQCObject != undefined) {
      //   selectedDsNo = IPQCObject.selectedDs;
      // } else {
      //   selectedDsNo = dsNo;
      // }

      // let menuDetailsArr = globalData.arr_limits.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      // let menuDetail = menuDetailsArr.Menus[menuName];
      var outOfLimitCount = 0;
      const valuesForAvg = [];
      let sum = 0;
      var ResultOfReport = "Within of Limit";
      let T1Pos;
      var nosOfTabletForT1 = result.incompleteData.T1NMTTab;
      if (result.incompleteData.GraphType == "1") {
        for (const val of result.detailData) {
          valuesForAvg.push(val.DataValue);
          sum += parseFloat(val.DataValue);
        }
        let avg = sum / valuesForAvg.length;
      }

      switch (typeValue.toString()) {
        case "1":
          T1Pos = objProductDetails.T1Pos;
          break;
        case "8":
          var paramName = "Ind_Layer";
          // if (serverConfig.ProjectName == "RBH") {
          //     paramName = 'Ind_Empty';
          // }
          T1Pos = objProductDetails.T1Pos;
          break;
        case "L":
          T1Pos = objProductDetails.T1Pos;
          break;
        case "3":
          T1Pos = objProductDetails.T1Pos;
          break;
        case "4":
          if (objProductType.ProductType == 1) {
            T1Pos = objProductDetails.T1Pos;
          } else {
            T1Pos = objProductDetails.T1Pos;
          }
          break;
        case "5":
          T1Pos = objProductDetails.T1Pos;
          break;
        case "6":
          T1Pos = objProductDetails.T1Pos;
          break;
        default:
          T1Pos = 1;
      }


      if (outOfLimitCount > 0) {
        // ResultOfReport = `LE1`;
        ResultOfReport = `Out of Limit From T2`;
        // objForLimit.flag = true
        console.log("Out of Limit From T2");
      }

      //For T1 calculations for balance related parameter only
      if (outOfLimitCount == 0 && parseFloat(T1Pos) != 0) {
        if (outOfLimitCount > nosOfTabletForT1) {
          ResultOfReport = "Out of Limit From T1";
        }
      }
      return ResultOfReport;
    } catch (error) {
      throw new Error(error);
    }
  }

  async saveCompleteData(dataObj, strTypeValue, cubicObj) {
    try {
      let masterTable = dataObj.strTableName;
      let detailTable = dataObj.strDetailTbl;
      var tabIp = dataObj.TabIp
      let dsNo = dataObj.DsNo;
      let typeValue = strTypeValue;
      let selectedDsNo;
      var menuName = dataObj.objProductDetails.menuName;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      if (IPQCObject != undefined) {
        selectedDsNo = IPQCObject.selectedIds;
      } else {
        selectedDsNo = dsNo;
      }

      let objProductDetail = globalData.arrProductTypeArray.find((k) => k.DsNo == dsNo);
      let objProductType = objProductDetail.productType;

      let result = await objIncompleteReport.getIncompleteData(dataObj, masterTable, detailTable, dsNo, tabIp, objProductDetail);
      let reportStatus = await this.removeLimitForRemark(result, typeValue, dsNo, objProductType, tabIp, menuName);
      // await objBatchSummary.saveBatchData(
      //   typeValue,
      //   result,
      //   strHmi,
      //   strIdsNo
      // );
      let isWTTrfr = await objWeighmentDataTransfer.saveCommonDataToComplete(
        result,
        typeValue,
        dsNo,
        dataObj.remark,
        menuName,
        tabIp,
        cubicObj
      );
      var res = isWTTrfr
      await this.deleteIncompleteRemarkEntry(dsNo, tabIp);
      var obj = { res: res }
      return obj;
    } catch (error) {
      throw new Error(error);
    }
  }

  async removeLimitForRemark(result, typeValue, dsNo, objProductType, tabIp, menuName) {
    try {
      let selectedDsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == dsNo);
      if (IPQCObject != undefined) {
        selectedDsNo = IPQCObject.selectedDs;
      } else {
        selectedDsNo = dsNo;
      }

      let menuDetailsArr = globalData.arr_limits.find((k) => k.DsNo == dsNo);
      let menuDetail = menuDetailsArr.Menus[menuName];
      var outOfLimitCount = 0;
      const valuesForAvg = [];
      let sum = 0;
      var ResultOfReport = "Within of Limit";
      let T1Pos;
      var nosOfTabletForT1 = result.incompleteData.T1NMTTab;
      if (result.incompleteData.GraphType == "1") {
        for (const val of result.detailData) {
          valuesForAvg.push(val.DataValue);
          sum += parseFloat(val.DataValue);
        }
        let avg = sum / valuesForAvg.length;
      }

      switch (typeValue.toString()) {
        case "1":
          T1Pos = menuDetail.T1Pos;
          break;
        case "8":
          var paramName = "Ind_Layer";
          // if (serverConfig.ProjectName == "RBH") {
          //     paramName = 'Ind_Empty';
          // }
          T1Pos = menuDetail.T1Pos;
          break;
        case "L":
          T1Pos = menuDetail.T1Pos;
          break;
        case "3":
          T1Pos = menuDetail.T1Pos;
          break;
        case "4":
          if (objProductType.ProductType == 1) {
            T1Pos = menuDetail.T1Pos;
          } else {
            T1Pos = menuDetail.T1Pos;
          }
          break;
        case "5":
          T1Pos = menuDetail.T1Pos;
          break;
        case "6":
          T1Pos = menuDetail.T1Pos;
          break;
        default:
          T1Pos = 1;
      }


      if (outOfLimitCount > 0) {
        // ResultOfReport = `LE1`;
        ResultOfReport = `Out of Limit From T2`;
        // objForLimit.flag = true
        console.log("Out of Limit From T2");
      }

      //For T1 calculations for balance related parameter only
      if (outOfLimitCount == 0 && parseFloat(T1Pos) != 0) {

        if (outOfLimitCount > nosOfTabletForT1) {
          ResultOfReport = "Out of Limit From T1";

        }
      }
      return ResultOfReport;
    } catch (error) {
      throw new Error(error);
    }
  }

  async updateEndDate(strDsNo, strTableName) {
    try {
      const cubicalObj = globalData.arrIdsInfo.find((k) => k.DsNo == strDsNo).cubicalData;
      const updateThicknessEndTime = await models[strTableName].update(
        {
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
        },
        {
          where: {
            BFGCode: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            PVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
            BatchNo: cubicalObj.Sys_Batch,
            DsNo: strDsNo,
          },
        }
      );


      updateThicknessEndTime;
    } catch (error) {
      throw new Error(error);
    }
  }

  async deleteIncompleteRemarkEntry(dsNo, tabIp) {
    try {
      const objRemark = await models.tbl_remark_incomplete_master.destroy({
        where: {
          DsNO: dsNo,
          TabIp: tabIp
        },
      });

    } catch (error) {
      throw new Error(error);
    }
  }

  async InsertIncompleteRemarkEntry(dataObj) {
    try {
      let strIdsNo = dataObj.idsNo;
      let strMenuName = dataObj.menuName;
      let batchNo = dataObj.batchNo;
      const masterTable = dataObj.tableName;

      const checkForAlreadyEntry = await tbl_remark_incomplete_master.findAll({
        where: {
          IDSNo: strIdsNo,
          BatchNumber: batchNo,
        },
      });

      let result = checkForAlreadyEntry;
      if (result[0].length == 0) {
        const insertRepoRemarkDetail =
          await models.tbl_remark_incomplete_master.create({});


        await database.save(insertRepoRemarkDetail);
      } else {
        const insertRepoRemarkDetail = {
          str_tableName: "tbl_remark_incomplete_master",
          condition: [
            { str_colName: "IDSNo", value: strIdsNo },
            { str_colName: "BatchNumber", value: batchNo },
          ],
          data: [
            { str_colName: "paramName", value: strMenuName },
            { str_colName: "tableName", value: masterTable + "_incomplete" },
          ],
        };

        await database.update(insertRepoRemarkDetail);
      }
    } catch (error) { }
  }

  async updateSample(sampleNo, DsNo, menuName, TabIp) {
    try {
      if (
        menuName == GLOBAL_NOMENCLATURE.ThicknessMenu ||
        menuName == GLOBAL_NOMENCLATURE.BreadthMenu ||
        menuName == GLOBAL_NOMENCLATURE.IndLayerMenu ||
        menuName == GLOBAL_NOMENCLATURE.LengthMenu ||
        menuName == GLOBAL_NOMENCLATURE.IndividualMenu ||
        menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu ||
        menuName == GLOBAL_NOMENCLATURE.PercentageFine ||
        menuName == GLOBAL_NOMENCLATURE.ParticalSizing
      ) {
        menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.GroupLayer1Menu ||
        menuName == GLOBAL_NOMENCLATURE.GroupLayerMenu ||
        menuName == GLOBAL_NOMENCLATURE.GroupMenu
      ) {
        menuName = GLOBAL_NOMENCLATURE.GroupMenu;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.FriabilityMenu ||
        menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu
      ) {
        menuName = GLOBAL_NOMENCLATURE.FriabilityMenu;
      } else if (menuName == GLOBAL_NOMENCLATURE.TappedDensity) {
        menuName = GLOBAL_NOMENCLATURE.TappedDensity;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer ||
        menuName == "LOD"
      ) {
        menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
      }

      const cubicalDetails = globalData.arrIdsInfo.find(
        (k) => k.TabIp == TabIp && k.DsNo == DsNo
      ).cubicalData;
      console.log(menuName);

      const updateSampleObj = await models.tbl_cubicle_product_sample.update({
        [`${menuName}`]: sampleNo
      },
        {
          where: {
            Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            // Sys_rpi: cubicalDetails.Sys_rpi
          }
        });

      await [updateSampleObj];

      return sampleNo
    } catch (error) {
      throw new Error(error);
    }
  }

  async getCubicalData(DsNo) {
    try {

      let cubicalData = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: DsNo,
        },
      });
      return [cubicalData[0]];
    } catch (error) {
      throw new Error(error);
    }
  }

  async getCubicalIdsNo() {
    try {
      const objListBal = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: {
            [Op.ne]: "NA",
          },
        },
      });

      return [objListBal];
    } catch (error) {
      throw new Error(error);
    }
  }




  async insert_Into_Incomplete_Master_Empty(dataObj) {
    const strTableName = dataObj.strTableName;
    const strIdsNo = dataObj.uniqueSerialNumber;
    let objSelMenu = globalData.arrSelectedMenu.find(
      (k) => k.idsNo == strIdsNo
    );
    const objProductDetails = objSelMenu.selectedProductDetail;
    const strBalId = dataObj.strBalId;
    const ProtocolData = dataObj.ProtocolData;
    const ProtocolUnit = dataObj.ProtocolUnit;
    const ProtocolDecPoint = dataObj.ProtocolDecPoint;
    const strHmi = dataObj.strHmi;

    let side;
    if (dataObj.objProductDetails.Rotary == "Single") {
      side = "NA";
    } else if (dataObj.objProductDetails.Rotary == "Double") {
      side = "LHS";
    }

    let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
      (k) => k.Hmi == strHmi
    ).cubicalData;
    //const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
    let selectedIdsNo;
    var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
    if (IPQCObject != undefined) {
      selectedIdsNo = IPQCObject.selectedIds;
    } else {
      selectedIdsNo = strIdsNo;
    }

    let selectedCub = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIdsNo
    ).cubicalData;

    let productMaster = globalData.arrProductTypeArray.find(
      (k) => k.idsNo == selectedIdsNo
    );

    let tblName = strTableName.concat("_incomplete");

    const insertObj = await models[tblName].create({
      MstSerNo: 1,
      InstruId: 1,
      BFGCode: dataObj.objProductDetails.ProductId,
      ProductName: dataObj.objProductDetails.ProductName,
      Qty: dataObj.objProductDetails.noOfSample,
      GrpQty: 0,
      GrpFreq: 0,
      Idsno: strHmi,
      CubicalNo: selectedCub.Sys_CubicNo,
      BalanceId: hmiDetailsInPMenu.Sys_BalID,
      BalanceNo: 0,
      VernierId: hmiDetailsInPMenu.Sys_VernierID,
      VernierNo: 0,
      BatchNo: dataObj.objProductDetails.Batch,
      UserId: dataObj.objProductDetails.userid,
      UserName: dataObj.objProductDetails.userName,
      PrDate: date.format(now, "YYYY-MM-DD"),
      PrTime: date.format(now, "HH:mm:ss"),
      PrEndDate: date.format(new Date(), "YYYY-MM-DD"),
      PrEndTime: date.format(new Date(), "HH:mm:ss"),

      Side: "NA",
      Unit: ProtocolUnit,
      DecimalPoint: ProtocolDecPoint,
      WgmtModeNo: 1,
      limitOn: 0,

      NomEmpty: 0,
      T1NegEmpty: 0,
      T1PosEmpty: 0,
      T2NegEmpty: 0,
      T2PosEmpty: 0,
      NomNet: 0,
      T1NegNet: 0,
      T1PosNet: 0,
      T2NegNet: 0,
      T2PosNet: 0,
      CubicleType: selectedCub.Sys_CubType,
      ReportType: 0,
      MachineCode: selectedCub.Sys_MachineCode,
      MFGCode: selectedCub.Sys_MfgCode,
      BatchSize: selectedCub.Sys_BatchSize,
      FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
      HardnessID: hmiDetailsInPMenu.Sys_HardID,
      CubicleName: selectedCub.Sys_CubicName,
      CubicleLocation: selectedCub.Sys_Location,
      RepoLabel10: "Standard",
      RepoLabel11: 0,
      RepoLabel12: "Null",
      RepoLabel13: "Null",
      PrintNo: 0,
      IsArchived: 0,
      GraphType: 0,
      BatchComplete: 0,
      PVersion: selectedCub.Sys_PVersion,
      Version: selectedCub.Sys_Version,
      BRepSerNo: 0,
      Lot: selectedCub.Sys_LotNo,
      Area: selectedCub.Sys_Area,
    });

    let arrResult = [insertObj];
    return arrResult[0];
  }

  async saveCompleteEmptyData(dataObj, strTypeValue) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let typeValue = strTypeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      if (dataObj.objProductDetails.menuName == "EMPTY") {
        masterTable = "tbl_cap_master9";
        detailTable = "tbl_cap_detail9";
      }


      let result = await objIncompleteReport.getIncomepleteEmptyShellData(
        dataObj,
        masterTable,
        detailTable,
        strHmi
      );

      let isWTTrfr = await objWeighmentDataTransfer.saveEmptyDataToComplete(
        result,
        typeValue,
        strHmi
      );
      await this.deleteEmptyIncompleteRemarkEntry(strHmi, strIdsNo);
    } catch (error) {
      throw new Error(error);
    }
  }

  async deleteEmptyIncompleteRemarkEntry(strHmi, strIdsNo) {
    try {
      let CubicInfo = globalData.arrIdsInfo.find((k) => k.Hmi == strHmi);
      let StrBatch = CubicInfo.cubicalData.Sys_Batch;
      const objRemark = await models.tbl_remark_incomplete_master.destroy({
        where: {
          IDSNo: strHmi,
          BatchNumber: StrBatch,
        },
      });

    } catch (error) {
      throw new Error(error);
    }
  }

  async insert_Into_Incomplete_Empty_Detail(dataObj) {
    try {
      const strmasterTbl = dataObj.strTableName;
      const strDetailTbl = dataObj.strDetailTbl;
      const strHmi = dataObj.strHmi;
      const strProtocolData = dataObj.ProtocolData;
      const strDecPoint = dataObj.ProtocolDecPoint;
      const seqNoOfWt = dataObj.seqNoOfWt;
      let decimal;
      let strIdsNo = dataObj.uniqueSerialNumber;
      let selectedIdsNo;

      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;

      let repSerNo = await this.lastInsertedRecords(
        hmiDetailsInPMenu.Sys_ProductName,
        hmiDetailsInPMenu.Sys_BFGCode,
        hmiDetailsInPMenu.Sys_PVersion,
        hmiDetailsInPMenu.Sys_Version,
        hmiDetailsInPMenu.Sys_Batch,
        strmasterTbl
      );

      /**
       * get decimal
       */
      let tbName = strDetailTbl.concat("_incomplete");
      const selectRepSrNoObj = await models[tbName].findAll({
        where: {
          RepSerNo: repSerNo,
        },
      });
      let arrResult_RepNo = [selectRepSrNoObj];
      if (arrResult_RepNo[0].length == 0) {
        decimal = strDecPoint;
      } else {
        decimal = arrResult_RepNo[0][0].DecimalPoint;
      }

      var tableName = strDetailTbl.concat("_incomplete");
      const insertDetail = await models[tableName].create({
        RepSerNo: repSerNo,
        MstSerNo: 0,
        RecSeqNo: seqNoOfWt,
        DataValue: strProtocolData,
        DecimalPoint: decimal,
        UserId: dataObj.objProductDetails.userid,
        UserName: dataObj.objProductDetails.userName,
        PrDate: date.format(now, "YYYY-MM-DD"),
        PrTime: date.format(now, "HH:mm:ss"),
        PrEndDate: date.format(new Date(), "YYYY-MM-DD"),
        PrEndTime: date.format(new Date(), "HH:mm:ss"),
      });

      let arrResult = [insertDetail];
      return decimal;
    } catch (error) {
      throw new Error(error);
    }
  }

  async getMaxBRepSerNo(
    productName,
    strBatch,
    strTableName,
    reportType,
    incomplete,
    Sys_CubType
  ) {
    try {
      const tblDetails = await models[strTableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],

        where: {
          // PVersion: selectedCub.Sys_PVersion,
          // Version: selectedCub.Sys_Version,
          BatchNo: strBatch,
          // BFGCode: dataObj.objProductDetails.ProductId,
          ProductName: productName,
          ReportType: reportType,
          CubicleType: Sys_CubType,
        },
      });

      if (incomplete == undefined) {
        incomplete = strTableName.concat("_incomplete");
      }

      const tblDetails1 = await models[incomplete].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {

          BatchNo: strBatch,

          ProductName: productName,
          ReportType: reportType,
          CubicleType: Sys_CubType,
        },
      });
      let incomBRepSerNo = 0;
      let BRepSerNo = 0;

      if (tblDetails.length != 0) {
        let maxColumn = tblDetails.length >= 1 ? tblDetails.pop() : tblDetails;
        BRepSerNo = maxColumn.BRepSerNo + 1;
      }
      if (tblDetails1.length != 0) {
        let maxColumninc =
          tblDetails1.length >= 1 ? tblDetails1.pop() : tblDetails1;
        incomBRepSerNo = maxColumninc.BRepSerNo + 1;
      }
      let result = Math.max(BRepSerNo, incomBRepSerNo);
      if (result == 0) {
        return 1;
      } else {
        return isNaN(result) ? 1 : result;
      }
    } catch (error) {
      throw new Error();
    }
  }

  async saveDiffCompleteData(dataObj, strTypeValue) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let typeValue = strTypeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;

      let selectedIdsNo;


      let objProductDetail = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == strHmi
      );
      let objProductType = objProductDetail.productType;

      if (objProductType.ProductType == 1) {
        masterTable = "tbl_tab_master" + typeValue;
        detailTable = "tbl_tab_detail" + typeValue;
      } else if (
        objProductType.ProductType == 2 ||
        objProductType.ProductType == 4
      ) {
        if (typeValue == "D") {
          masterTable = "tbl_cap_master3";
          detailTable = "tbl_cap_detail3";
        } else {
          masterTable = "tbl_cap_master" + typeValue;
          detailTable = "tbl_cap_detail" + typeValue;
        }
      } else if (objProductType.ProductType == 5) {
        masterTable = "tbl_tab_master19";
        detailTable = "tbl_tab_detail19";
      }


      let result = await objIncompleteReport.getDiffIncomepleteData(
        dataObj,
        masterTable,
        detailTable,
        strHmi
      );
      let reportStatus = await this.removeLimitForRemark(
        result,
        typeValue,
        strHmi,
        objProductType
      );
      if (typeValue == "D") {
        await objBatchSummary.saveBatchDataDiff(
          "D",
          result,
          strHmi,
          reportStatus
        );
      } else {
        await objBatchSummary.saveBatchData(
          typeValue,
          result,
          strHmi,
          strIdsNo
        );
      }

      let saveResponse = await objWeighmentDataTransfer.saveDiffDataToComplete(
        result,
        typeValue,
        strHmi
      );

      await this.deleteIncompleteRemarkEntry(strHmi, strIdsNo);

      mqttSender.sendData(strHmi, `${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayResult}:${reportStatus}`);
      return { reportStatus: reportStatus, RepSerNo: saveResponse.RepSerNo };
    } catch (error) {
      throw new Error(error);
    }
  }

  async getDoubleLastSide(data) {
    try {
      var { strHmi, strBatch, productName, Sys_CubType, reportType, strTableName, side } = data;

      const sideResp = await models[strTableName].findAll({
        // attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {

          BatchNo: strBatch,
          // BFGCode: dataObj.objProductDetails.ProductId,
          ProductName: productName,
          ReportType: reportType,
          // side:side,
          CubicleType: Sys_CubType,
          Idsno: strHmi
        }
      })

      const specificIds = sideResp.filter(k => k.Idsno == strHmi);
      let sideObj = specificIds.pop();
      return sideObj.Side
      // return sideResp.Side


    } catch (error) {
      console.log(error)
    }
  }

  async saveCompleteBatchData(data) {
    try {

      // if (data.cubicObj.Sys_RptType == 1) {
      //   return;
      // }

      // let batchExist = await models.tbl_batchsummary_master.findAll({
      //   where: {
      //     BatchNo: data.cubicObj.Sys_Batch
      //   }
      // })
      let userInfo = globalData.arrUsers.filter(e => e.DsNo == data.dsNo && e.TabIp == data.tabIp)[0]
      // let batchRepSerNo;
      // let batchNo;
      // let instrumentIds;
      // let ExistingBatchInstrument;
      // if (batchExist.length > 0) {
      // batchNo = batchExist[0].BatchNo
      // batchRepSerNo = batchExist[0].RepSerNo
      // ExistingBatchInstrument = batchExist[0].InstrumentID
      // } else {

      let productData = await models.tbl_product_master.findOne({
        where: {
          MPN_Code: data.cubicObj.Sys_MPNCode
        }
      })
      // let productType = productData?.ProductType ?? 1;
      //   let batchMasterEntry = await models.tbl_batchsummary_master.create({
      //     ProductId: data.cubicObj.Sys_MPNCode,
      //     RecNo: 1,
      //     ProductName: data.cubicObj.Sys_ProductName,
      //     BatchNo: data.cubicObj.Sys_Batch,
      //     Area: data.cubicObj.Sys_Area,
      //     MPN_Code: data.cubicObj.Sys_MPNCode,
      //     // StartTime: moment().format('YYYY-MM-DD HH:mm:ss'),
      //     // EndTime:  moment().format('YYYY-MM-DD HH:mm:ss'),
      //     EquipmentId: data.cubicObj.Sys_MachineCode,
      //     UserName: userInfo.UserName,
      //     Rotary: data.cubicObj.Sys_RotaryType,
      //     NoOfStations: data.cubicObj.Sys_Repetition,
      //     ReportOption: data.cubicObj.Sys_RptType,
      //     PrdType: productType,
      //     CubicleType: data.cubicObj.Sys_CubType,
      //     Side: "NA",
      //     StartDate: moment().format('YYYY-MM-DD'),

      //   })

      //   batchRepSerNo = batchMasterEntry._previousDataValues.RepSerNo
      //   batchNo = data.cubicObj.Sys_Batch

      // }


      let mesData = globalData.MESArray.filter(e => e.dsNo == data.dsNo && e.portNo == data.portNo && e.batchId == batchNo)
      let repSerNo = data.newRepSrno;


      let menuSequenceTable = data.menuSequenceTable

      let initialmaster = productData?.ProductType == 1 ? 'tbl_tab_initialmaster' : 'tbl_cap_initialmaster'
      let masterEntry = await models[initialmaster].findAll(
        {
          where: {
            BatchNo: data.cubicObj.Sys_Batch,
            RepSerNo: repSerNo,
            CubicleName: data.cubicObj.Sys_CubicName,
            MPN_Code: data.cubicObj.Sys_MPNCode
          }
        }
      )
      let mahcineDetails = await models.tbl_machine.findAll({
        where: {
          Machine_ID: data.cubicObj.Sys_MachineCode
        }
      })


      let paramArray = []
      if (masterEntry.length > 0) {

        for (let keys in menuSequenceTable) {
          if (menuSequenceTable[keys] == 1 || menuSequenceTable[keys] == '1') {
            let menuName = objCommonWeightment.getMenuNmFromMenuSeq(keys);
            let getTableName = objCommonWeightment.getTableName(data.cubicObj, menuName, data.dsNo, data.tabIp)
            if (menuName == GLOBAL_NOMENCLATURE.HardnessMenu) {
              const { Param7_T2PosTol, Param7_T2NegTol, Param7_AvgNet, Param7_MaxWeight, Param7_MinWeight, Param7_PrDate, Param7_PrEndDate, Param7_PrTime, Param7_PrEndTime, Param7_Nom,
                Param3_T2PosTol, Param3_T2NegTol, Param3_AvgNet, Param3_MaxWeight, Param3_MinWeight, Param3_PrDate, Param3_PrEndDate, Param3_PrTime, Param3_PrEndTime, Param3_Nom
              } = masterEntry[0]

              let endTime7 = moment(Param7_PrEndDate).format("DD.MM.YYYY") + ' ' + moment(Param7_PrEndTime).format("HH:mm:ss")
              let startTime7 = moment(Param7_PrDate).format("DD.MM.YYYY") + ' ' + moment(Param7_PrTime).format("HH:mm:ss")

              let endTime3 = moment(Param3_PrEndDate).format("DD.MM.YYYY") + ' ' + moment(Param3_PrEndTime).format("HH:mm:ss")
              let startTime3 = moment(Param3_PrDate).format("DD.MM.YYYY") + ' ' + moment(Param3_PrTime).format("HH:mm:ss")
              let typeValue = 7


              let instrumentType = await models.tbl_otherequipment.findOne({
                where: {
                  Eqp_ID: masterEntry[0].HardnessID
                }
              })
              getTableName.batchSummaryMasterTable = 'tbl_batchsummary_master7'
              let masterRepSerNo = await this.checkMasterEntryOfPerticularBatch(data.cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, masterEntry[0].HardnessID, userInfo, getTableName)
              let recSequenceNo = await this.findRecSequenceNumber(masterRepSerNo, typeValue, masterEntry, menuName)

              await models.tbl_batchsummary_detail7.create({
                Min: Param7_MinWeight,
                Max: Param7_MaxWeight,
                LSL: Param7_T2NegTol,
                USL: Param7_T2PosTol,
                Avg: Param7_AvgNet,
                Target: Param7_Nom,
                LHSContainerNo: masterEntry[0].LHSContainerNo,
                RHSContainerNo: masterEntry[0].RHSContainerNo,
                RepSerNo: masterRepSerNo,
                StartTime: startTime7,
                EndTime: endTime7,
                // TestResult: masterEntry[0][`Param7_Remark`],
                TestResult: 'PASS',
                UserName: masterEntry[0].UserName,
                InstrumentID: masterEntry[0].HardnessID,
                RecSeqNo: recSequenceNo,
                Date: moment().format('YYYY-MM-DD'),
                Time: moment().format('HH:mm:ss'),
                Side: masterEntry[0].Side,
                Repetition: masterEntry[0].Repetition,
                SFOID: masterEntry[0].SFOID,
              })

              typeValue = 3
              getTableName.batchSummaryMasterTable = 'tbl_batchsummary_master3'
              let masterRepSerNo3 = await this.checkMasterEntryOfPerticularBatch(data.cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, masterEntry[0].HardnessID, userInfo, getTableName)
              recSequenceNo = await this.findRecSequenceNumber(masterRepSerNo3, typeValue, masterEntry, menuName)
              await models.tbl_batchsummary_detail3.create({
                Min: Param3_MinWeight,
                Max: Param3_MaxWeight,
                LSL: Param3_T2NegTol,
                USL: Param3_T2PosTol,
                Avg: Param3_AvgNet,
                Target: Param3_Nom,
                LHSContainerNo: masterEntry[0].LHSContainerNo,
                RHSContainerNo: masterEntry[0].RHSContainerNo,
                RepSerNo: masterRepSerNo3,
                StartTime: startTime7,
                EndTime: endTime7,
                // TestResult: masterEntry[0][`Param3_Remark`],
                TestResult: 'PASS',
                UserName: masterEntry[0].UserName,
                InstrumentID: masterEntry[0].HardnessID,
                RecSeqNo: recSequenceNo,
                Date: moment().format('YYYY-MM-DD'),
                Time: moment().format('HH:mm:ss'),
                Side: masterEntry[0].Side,
                Repetition: masterEntry[0].Repetition,
              })


              let batchSummaryHardnessData = await models.tbl_batchsummary_detail7.findAll({
                where: {
                  RepSerNo: masterRepSerNo
                }
              })

              let batchSummarThicknessData = await models.tbl_batchsummary_detail3.findAll({
                where: {
                  RepSerNo: masterRepSerNo3,
                }
              })
              let hrdAvgOfAvg, thickAvgOfAvg, hrdMax, hrdMin, thickMax, thickMin;
              if (batchSummaryHardnessData.length > 0) {

                let dataValueMax = [];
                let dataValueMin = [];


                let avg = batchSummaryHardnessData.map((e) => {
                  dataValueMax.push(e.Max)
                  dataValueMin.push(e.Min)
                  return e.Avg
                }
                );
                hrdAvgOfAvg = objcalc.avgCalc(avg, 3)
                hrdMin = maths.min(...dataValueMin);
                hrdMax = maths.max(...dataValueMax);


              }

              if (batchSummarThicknessData.length > 0) {
                let dataValueMax = [];
                let dataValueMin = [];
                let avg = batchSummarThicknessData.map((e) => {
                  dataValueMax.push(e.Max)
                  dataValueMin.push(e.Min)
                  return e.Avg
                }
                );
                thickAvgOfAvg = objcalc.avgCalc(avg, 3)
                thickMin = maths.min(...dataValueMin);
                thickMax = maths.max(...dataValueMax);

              }

              await models[`tbl_batchsummary_master7`].update({
                AvgValue: hrdAvgOfAvg,
                MinValue: hrdMin,
                MaxValue: hrdMax
              },
                {
                  where: {
                    RepSerNo: masterRepSerNo
                  }
                }
              )

              await models[`tbl_batchsummary_master3`].update({
                AvgValue: thickAvgOfAvg,
                MinValue: thickMin,
                MaxValue: thickMax
              },
                {
                  where: {
                    RepSerNo: masterRepSerNo3
                  }
                }
              )



              if (instrumentType.Eqp_Make == 'Pharmatest' && data.cubicObj.Sys_RptType == 0) {
                getTableName.batchSummaryMasterTable = 'tbl_batchsummary_master1'
                typeValue = 1
                let IndRepSerNo = await this.checkMasterEntryOfPerticularBatch(data.cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, masterEntry[0].HardnessID, userInfo, getTableName)
                let IndrecSequenceNo = await this.findRecSequenceNumber(IndRepSerNo, typeValue, masterEntry, menuName)
                await models.tbl_batchsummary_detail1.create({
                  Min: masterEntry[0].Param1_MinWeight,
                  Max: masterEntry[0].Param1_MaxWeight,
                  LSL: masterEntry[0].Param1_T2NegTol,
                  USL: masterEntry[0].Param1_T2PosTol,
                  Avg: masterEntry[0].Param1_AvgNet,
                  Target: masterEntry[0].Param1_Nom,
                  LHSContainerNo: masterEntry[0].LHSContainerNo,
                  RHSContainerNo: masterEntry[0].RHSContainerNo,
                  RepSerNo: IndRepSerNo,
                  StartTime: startTime7,
                  EndTime: endTime7,
                  // TestResult: masterEntry[0][`Param3_Remark`],
                  TestResult: 'PASS',
                  UserName: userInfo.UserName,
                  UserID: userInfo.UserId,
                  InstrumentID: masterEntry[0].HardnessID,
                  RecSeqNo: IndrecSequenceNo,
                  Date: moment().format('YYYY-MM-DD'),
                  Time: moment().format('hh:mm:ss'),
                  Side: masterEntry[0].Side,
                  Repetition: masterEntry[0].Repetition,
                })

                let batchSummarIndividual = await models.tbl_batchsummary_detail1.findAll({
                  where: {
                    RepSerNo: IndRepSerNo
                  }
                })
                let IndAvg, IndMin, IndMax
                if (batchSummarIndividual.length > 0) {
                  let dataValueMax = [];
                  let dataValueMin = [];
                  let avg = batchSummarIndividual.map((e) => {
                    dataValueMax.push(e.Max)
                    dataValueMin.push(e.Min)
                    return e.Avg
                  }
                  );
                  IndAvg = objcalc.avgCalc(avg, 3)
                  IndMin = maths.min(...dataValueMin);
                  IndMax = maths.max(...dataValueMax);

                }

                await models[`tbl_batchsummary_master1`].update({
                  AvgValue: IndAvg,
                  MinValue: IndMin,
                  MaxValue: IndMax
                },
                  {
                    where: {
                      RepSerNo: IndRepSerNo
                    }
                  }
                )

              }

            } else {
              let typeValue = getTableName.typeValue
              let paramArray = [`Param${typeValue}_T2PosTol`,
              `Param${typeValue}_T2NegTol`,
              `Param${typeValue}_AvgNet`,
              `Param${typeValue}_MaxWeight`,
              `Param${typeValue}_MinWeight`,
              `Param${typeValue}_PrEndDate`,
              `Param${typeValue}_PrEndTime`,
              `Param${typeValue}_PrTime`,
              `Param${typeValue}_PrDate`,
              `Param${typeValue}_Remark`,
              `Param${typeValue}_Nom`,
              ]
              let paramObject = {}
              paramArray.map((item, key) => paramObject[item] = masterEntry[0][item])
              let instrumentId;
              let Target = 'Target'
              let Nom = paramObject[`Param${typeValue}_Nom`]
              let DtMin = null;
              let DtMax = null;
              let DtAvg = null;
              switch (typeValue) {
                case 1:
                case 3:
                case 2:
                case 19:
                  instrumentId = masterEntry[0].BalanceId
                  break;
                case 8:
                  instrumentId = serverConfig.friabilityType == "OF" ? 'NA' : masterEntry[0].BalanceId;
                  break;
                case 5:
                  instrumentId = masterEntry[0].VernierId;
                  break;
                case 13:
                  instrumentId = masterEntry[0].DTID
                  Target = 'TargetDT';
                  let MinTimeDT = `00:${paramObject[`Param${typeValue}_MinWeight`]}`
                  let MaxTimeDT = `00:${paramObject[`Param${typeValue}_MaxWeight`]}`
                  let AvgTimeDT = `00:${paramObject[`Param${typeValue}_AvgNet`]}`
                  //changed
                  let checkLength = paramObject['Param13_Nom'].split(':').length;

                  let timeString = checkLength == 3 ? `${paramObject['Param13_Nom']}` : `00:${paramObject['Param13_Nom']}`;
                  let formattedTime = moment(timeString, 'HH:mm:ss').toDate();
                  let formattedMax = moment(MinTimeDT, 'HH:mm:ss').toDate();
                  let formattedMin = moment(MaxTimeDT, 'HH:mm:ss').toDate();
                  let formattedAvg = moment(AvgTimeDT, 'HH:mm:ss').toDate();
                  Nom = moment(formattedTime).format('HH:mm:ss');
                  DtMin = moment(formattedMin).format('HH:mm:ss');
                  DtMax = moment(formattedMax).format('HH:mm:ss');
                  DtAvg = moment(formattedAvg).format('HH:mm:ss');
                  break;

                default:
                  break;
              }

              let endTime = moment(paramObject[`Param${typeValue}_PrEndDate`]).format('DD.MM.YYYY') + ' ' + moment(paramObject[`Param${typeValue}_PrEndTime`]).format('HH:mm:ss')
              let startTime = moment(paramObject[`Param${typeValue}_PrDate`]).format('DD.MM.YYYY') + ' ' + moment(paramObject[`Param${typeValue}_PrTime`]).format('HH:mm:ss')

              let masterRepSerNo = await this.checkMasterEntryOfPerticularBatch(data.cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, instrumentId, userInfo, getTableName)
              let recSequenceNo = await this.findRecSequenceNumber(masterRepSerNo, typeValue, masterEntry, menuName)

              await models[getTableName.batchSummaryDetailTable].create({
                Min: paramObject[`Param${typeValue}_MinWeight`],
                Max: paramObject[`Param${typeValue}_MaxWeight`],
                Avg: paramObject[`Param${typeValue}_AvgNet`],
                LSL: paramObject[`Param${typeValue}_T2NegTol`],
                USL: paramObject[`Param${typeValue}_T2PosTol`],
                MinTimeDT: DtMin,
                MaxTimeDT: DtMax,
                AvgTimeDT: DtAvg,
                [Target]: Nom,
                LHSContainerNo: masterEntry[0].LHSContainerNo,
                RHSContainerNo: masterEntry[0].RHSContainerNo,
                RepSerNo: masterRepSerNo,
                StartTime: startTime,
                EndTime: endTime,
                // TestResult: paramObject[`Param${getTableName.typeValue}_Remark`],
                TestResult: 'PASS',
                UserName: userInfo.UserName,
                UserID: userInfo.UserId,
                InstrumentID: (typeValue == 8 && serverConfig.friabilityType == "OF") ? masterEntry[0].FriabilityID : instrumentId,
                Repetition: masterEntry[0].Repetition,
                RecSeqNo: recSequenceNo,
                Side: masterEntry[0].Side,
                Date: moment().format('YYYY-MM-DD'),
                // Time: moment().format('HH:mm:ss'),
              })


              let batchsummaryDetailEntries = await models[getTableName.batchSummaryDetailTable].findAll({
                where: {
                  RepSerNo: masterRepSerNo
                }
              })

              let Avg, Min, Max, FinalAvgDT;
              if (batchsummaryDetailEntries.length > 0) {
                let dataValueMax = [];
                let dataValueMin = [];
                let avg = batchsummaryDetailEntries.map(e => {
                  if (typeValue == 13) {
                    let d = new Date(e.AvgTimeDT);
                    return d.toTimeString().split(" ")[0]
                  } 
                  else {
                    dataValueMax.push(e.Max)
                    dataValueMin.push(e.Min)
                    return e.Avg
                  }
                });

                if (typeValue == 13) {
                  var batchdetail = "tbl_batchsummary_detail13";
                  var completeUpdate = await sequelize.query(`SELECT  MAX(MaxTimeDT) AS 'Max',MIN(MinTimeDT) AS 'Min',
                  CONVERT(varchar(12), DATEADD(SECOND, AVG(DATEDIFF(SECOND, '00:00:00', AvgTimeDT)), '00:00:00'), 108) 
                  AS 'Avg'FROM ${batchdetail} WHERE RepSerNo='${masterRepSerNo}'`);

                }

                //  let avgDp = (typeValue == 13 && serverConfigs.plant =="PUI") ? 4 : (typeValue == 13 && serverConfigs.plant == "FT03") ? 2 : 3; 
                let avgDp = typeValue == 13 ? 2 : 3;
                // let tempAvg = objcalc.avgCalc(avg, avgDp)
                let tempAvg = typeValue == 13 ? this.dtSumAndAverageCalculation(avg) : objcalc.avgCalc(avg, avgDp)
                Avg = tempAvg
                // Avg = typeValue == 13 ? tempAvg.toString().replace('.', ':') : tempAvg
                Min = typeValue == 13 ? moment(completeUpdate[0][0]?.Min).format('HH:mm:ss') : maths.min(...dataValueMin);
                Max = typeValue == 13 ? moment(completeUpdate[0][0]?.Max).format('HH:mm:ss') : maths.max(...dataValueMax);
                FinalAvgDT = typeValue == 13 ? completeUpdate[0][0]?.Avg : maths.min(...dataValueMin);

              }

              let instrumentIdVariable = typeValue == 8 ? 'FriabilityID' : 'InstrumentID'
              let id = typeValue == 8 ? masterEntry[0].FriabilityID : instrumentId
              let MinValue = typeValue == 13 ? 'FinalMinDT' : 'MinValue';
              let MaxValue = typeValue == 13 ? 'FinalMaxDT' : 'MaxValue';
              await models[getTableName.batchSummaryMasterTable].update(
                {
                  AvgValue: Avg,
                  [MinValue]: Min,
                  [MaxValue]: Max,
                  FinalAvgDT: FinalAvgDT,
                  [instrumentIdVariable]: id
                },
                {
                  where: {
                    RepSerNo: masterRepSerNo
                  }
                }
              )


            }
          }
        }



        // let result = await models.tbl_batchsummary_master.update({
        //   HardUnit: masterEntry[0].Param7_Unit,
        //   ThickUnit: masterEntry[0].Param3_Unit,
        //   LHSContainerNo: masterEntry[0].LHSContainerNo,
        //   RHSContainerNo: masterEntry[0].RHSContainerNo,
        //   HardAvgOfAvg: hrdAvgOfAvg,
        //   ThickAvgOfAvg: thickAvgOfAvg,
        //   UserName: masterEntry[0].UserName,
        //   StartTime: moment(masterEntry[0].IntervalStartTm).format('YYYY-MM-DD HH:mm:ss'),
        //   // EndTime: moment(masterEntry[0].IntervalStopTm).format('YYYY-MM-DD HH:mm:ss'),
        //   EndTime: moment().format('YYYY-MM-DD HH:mm:ss'),
        //   InstrumentID: masterEntry[0].HardnessID
        // },
        //   {
        //     where: {
        //       RepSerNo: batchRepSerNo
        //     }
        //   }
        // )
        // console.log(result)
      }
    } catch (error) {
      console.log(error)
    }

  }

  async findRecSequenceNumber(masterRepSerNo, typeValue, masterEntry, menuName) {
    try {
      let recSeqNo;
      typeValue = menuName == GLOBAL_NOMENCLATURE.Differential ? 'diff' : typeValue
      let batchDetailEntries = await models[`tbl_batchsummary_detail${typeValue}`].findAll({
        where: {
          RepSerNo: masterRepSerNo,
          Side: masterEntry[0].Side
        }
      })

      if (batchDetailEntries.length > 0) {
        let lastRecord = batchDetailEntries[batchDetailEntries.length - 1].RecSeqNo
        recSeqNo = lastRecord + 1
      } else {
        recSeqNo = 1
      }
      console.log(recSeqNo, `tbl_batchsummary_detail${typeValue}`)
      return recSeqNo
    } catch (error) {
      console.log(error)
    }
  }

  async checkMasterEntryOfPerticularBatch(cubicObj, typeValue, repSerNo, masterEntry, mahcineDetails, InstrumentID, userInfo, getTableName) {
    try {
      let machineRotary = mahcineDetails[0]?.Machine_Rotary == 'Double' ? mahcineDetails[0]?.Machine_Rotary : 'NA';
      // let batchSummaryMasterTable = `tbl_batchsummary_master${typeValue}`
      let batchSummaryMasterTable = getTableName.batchSummaryMasterTable
      let perticularBatchMaster = await models[batchSummaryMasterTable].findAll(
        {
          where: {
            // RepSerNo: data.RepSerNo,
            BatchNo: cubicObj.Sys_Batch,
            Area: cubicObj.Sys_Area,
            Side: machineRotary,
            CubicName: cubicObj.Sys_CubicName,
            PrdType: masterEntry[0].ProductType,
            MPN_Code: masterEntry[0].MPN_Code

          }
        }
      )
      if (perticularBatchMaster.length > 0) {
        return perticularBatchMaster[0].RepSerNo
      } else {
        let batchtime = await models.tbl_batches.findOne({
          where: {
            Batch: cubicObj.Sys_Batch,
            Status: 'S',
            cubicleType: cubicObj.Sys_CubType
          }
        })

        let BTDate = batchtime?.dt ?? masterEntry[0][`Param${typeValue}_PrDate`]
        let BTtime = batchtime?.tm ?? masterEntry[0][`Param${typeValue}_PrTime`]
        const objInsertMasterData = await models[batchSummaryMasterTable].create({
          MPN_Code: masterEntry[0].MPN_Code,
          BFGCode: masterEntry[0].BFGCode,
          ProductName: masterEntry[0].ProductName,
          PVersion: masterEntry[0].PVersion,
          Version: masterEntry[0].Version,
          BatchNo: masterEntry[0].BatchNo,
          CubicleType: masterEntry[0].CubicleType,
          Stage: cubicObj.Sys_Stage,
          CubicName: cubicObj.Sys_CubicName,
          // Dept: masterEntry[0].Dept,
          // Nom: Number(resultData.incompleteData.Nom).toFixed(1),
          // Tol1Neg: Number(minLimitT1).toFixed(1),
          // Tol1Pos: Number(maxLimitT1).toFixed(1),

          // Tol2Neg: masterEntry[0].T2NegTol,
          // Tol2Pos: masterEntry[0].T2PosTol,
          Unit: typeValue != 13 ? typeValue == 8 ? '%' : masterEntry[0][`Param${typeValue}_Unit`] : 'mm:ss',
          Side: machineRotary,
          IsArchived: masterEntry[0].IsArchived,
          LimitOn: masterEntry[0].LimitOn,
          Area: cubicObj.Sys_Area,
          BatchSize: `${cubicObj.Sys_BatchSize} ${cubicObj.Sys_BatchSizeUnit}`,
          // StdLimit1: resultData.incompleteData.StdLimit1,
          // StdLimit2: masterEntry[0].StdLimit2,
          MachineCode: masterEntry[0].MachineCode,
          // StartDate: `${moment(masterEntry[0][`Param${typeValue}_PrDate`]).format("DD.MM.YYYY")} ${moment(masterEntry[0][`Param${typeValue}_PrTime`]).format('HH:mm:ss')}`,
          StartDate: `${moment(BTDate).format("YYYY-MM-DD")} ${moment(BTtime).format('HH:mm:ss')}`,
          // EndDate: moment().format("YYYY-MM-DD"),
          // BatchStartTime: moment(masterEntry[0].PrTime).format("HH:mm:ss"),
          ReportType: masterEntry[0].ReportType,
          PrdType: masterEntry[0].ProductType,
          CubicalNo: cubicObj.Sys_CubicNo,
          // NMT: masterEntry[0].NMT,
          // GraphOn: masterEntry[0].GraphType,
          // LimitOn: masterEntry[0].LimitOn,
          // DP: dp,
          BatchCompleted: 0,
          NoOfStations: mahcineDetails[0]?.Machine_Punches,
          Repetition: masterEntry[0].Repetition,
          SFOID: masterEntry[0].SFOID,
          // LHSContainerNo: "NA",
          // RHSContainerNo: "NA",
          UserName: userInfo.UserName,
          InstrumentID: InstrumentID,
          LotNo: cubicObj.Sys_LotNo
        })
        console.log(objInsertMasterData._previousDataValues.RepSerNo)
        return objInsertMasterData._previousDataValues.RepSerNo
      }
    } catch (error) {
      console.log(error)
    }

  }

  // async upateBatchMasterTable(masterTable){
  //     let result = await models.tbl_batchsummary_master.update({
  //       HardUnit: masterEntry[0].Param7_Unit,
  //       ThickUnit: masterEntry[0].Param3_Unit,
  //       LHSContainerNo: masterEntry[0].LHSContainerNo,
  //       RHSContainerNo: masterEntry[0].RHSContainerNo,
  //       Avg: hrdAvgOfAvg,
  //       // ThickAvgOfAvg: thickAvgOfAvg,
  //       UserName: masterEntry[0].UserName,
  //       // StartTime: moment(masterEntry[0].IntervalStartTm).format('YYYY-MM-DD HH:mm:ss'),
  //       // EndTime: moment(masterEntry[0].IntervalStopTm).format('YYYY-MM-DD HH:mm:ss'),
  //       EndTime: moment().format('YYYY-MM-DD HH:mm:ss'),
  //       // InstrumentID: masterEntry[0].HardnessID
  //     },
  //       {
  //         where: {
  //           RepSerNo: batchRepSerNo
  //         }
  //       }
  //     )
  // }



  async updateDatesInMasterTable(repSerNo, masterData, remarkObj) {

    try {
      // let masterData = await models[masterTableIncomplete].findOne(
      //   {
      //     attributes:['dates_json'],
      //     where:{
      //       RepSerNo: repSerNo
      //     }
      //   }
      // )

      if (masterData != undefined) {
        let obj = JSON.parse(masterData)
        if (obj != null && typeof obj === 'object') {

          return Object.assign(remarkObj, obj)
        }
        return remarkObj
      }

    } catch (error) {
      console.log(error)
    }
  }

  parseJSON(columnValue, obj) {
    try {
      Object.keys(obj).forEach(key => {
        if (!(/^Param\d+_Pr/.test(key))) {
          delete obj[key]
        }
      })
      const parsed = JSON.parse(columnValue)
      if (parsed != null && typeof parsed === 'object') {
        return JSON.stringify(Object.assign(parsed, obj))
      }
      return JSON.stringify(obj)

    } catch (error) {
      return JSON.stringify(obj)
    }
  }

  customDateTimeformatter(value, format, defaultvalue = null) {

    if (!value || value === defaultvalue) {
      return moment().format(format);
    }

    if (format.includes('YYYY')) {
      defaultvalue = '2020-01-01'
      return momentObj(value).format(format) > defaultvalue ? momentObj(value).format(format) : momentObj().format(format)

    } else {
      defaultvalue = '00:00:00'
      let timeValue = value.toTimeString().split(' ')[0]
      console.log(timeValue, " --- ", value)
      return timeValue !== defaultvalue ? momentObj(value).format(format) : momentObj().format(format)
    }


  }


  dtSumAndAverageCalculation(timeParams) {
    let totalSeconds = 0;
    let dividend = timeParams.length

    for (let i = 0; i < timeParams.length; i++) {
      totalSeconds = totalSeconds + secondsCalculation(timeParams[i])
    }

    function secondsCalculation(timeStr) {
      const [hh, mm, ss] = timeStr.split(":").map(Number);
      return ((hh * 3600) + (mm * 60) + ss);
    }

    let averageSecond = this.averageTimeInSeconds(totalSeconds,dividend)
    return this.formatTime(averageSecond)


  }


  averageTimeInSeconds(totalSeconds, dividend){
    return Math.floor(totalSeconds/dividend)
  }

  formatTime(totalSeconds) {
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;

    // Pad with leading zeros (e.g., 01:05:09)
    const hh = String(hours).padStart(2, "0");
    const mm = String(minutes).padStart(2, "0");
    const ss = String(seconds).padStart(2, "0");

    return `${hh}:${mm}:${ss}`;
  }
}

module.exports = InsertOperation;
