const globalData = require('../../global/globalData');
const clsStoreProcedure = require('../Product/clsStoreProcedure');
const Database = require('../../database/clsQueryProcess');
const dbCon = require('../../global/dbCon');
const clsFormulaFun = require('../Product/clsformulaFun.model');
const clsProObj = require('../Product/clsProductDetailModel')
const clsCalculation = require('../clsCalculationOperation');
// const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");

const date = require('date-and-time')
const objStoreProcedure = new clsStoreProcedure();
let now = new Date();
const maths = require('mathjs');
const database = new Database();
const formulaFun = new clsFormulaFun();
const proObj = new clsProObj();
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes, Op, where } = require('sequelize');
const moment = require('moment');
const mathj = require('mathjs')

const FormulaFunModel = require("../Product/clsformulaFun.model");
const { Friability } = require('../../global/Global_Nomenclature');
const objformulaFun = new FormulaFunModel();
const objcalc = new clsCalculation();


class BatchSummary {
  constructor() {
    // var mathj;
    this.math = mathj;
  }

  async saveBatchData1(dataObj, resultData) {
    try {
      let responseObj = {};
      let strInstrumentId = "";
      let sideVal;
      let objSelMenu = dataObj.SelectedMenuDetails;
      let side = objSelMenu.Side;
      const arrCheck = [1, 3, 4, 5];
      let { avgDp, stdDevDp, decPoint, minMaxDp, cubicObj } = dataObj
      let masterSrNo;

      if (arrCheck.includes(dataObj.typeValue)) {
        let masterTable = dataObj.masterTable;
        let detailTable = dataObj.detailTable;
        let batchSummaryMasterTable = dataObj.batchSummaryMasterTable;
        let batchSummaryDetailTable = dataObj.batchSummaryDetailTable;

        let maxVal = resultData.incompleteData.MaxWeight;//Math.max(...arrDetail);
        let minVal = resultData.incompleteData.MinWeight; //Math.min(...arrDetail);
        let avgVal = resultData.incompleteData.AvgWeight;

        if (((cubicObj.Sys_RptType == 0) && (cubicObj.Sys_Validation == 0) && ((cubicObj.Sys_CubType == 'Compression') || (cubicObj.Sys_CubType == 'Coating') ||
          (cubicObj.Sys_CubType == 'Capsule Filling') || (cubicObj.Sys_CubType == 'IPQC') || (cubicObj.Sys_CubType == 'Dosa Dry')))) {
          // let verArr = [3, 5];
          // strInstrumentId = (verArr.includes(dataObj.typeVal)) ? resultData.incompleteData.VernierId : resultData.incompleteData.BalanceId;

          const checkMasterObj = await models[batchSummaryMasterTable].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
            where: {
              MPN_Code: resultData.incompleteData.MPN_Code,
              // Side: side,
              CubicleType: resultData.incompleteData.CubicleType,
              BatchNo: resultData.incompleteData.BatchNo
            }
          })

          const SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.DsNo == dataObj.DsNo);
          let remark = 'Complies';
          if (SampleRemark.OutOfRemark == true) remark = "Not Complies";

          let dp = resultData.incompleteData.DecimalPoint;
          sideVal = (resultData.incompleteData.Side == 'LHS') ? 'LEFT' : resultData.incompleteData.Side;
          let recSeqNo = await this.calculateSeqNo(sideVal, batchSummaryMasterTable, batchSummaryDetailTable, resultData.incompleteData);
          const machinePunches = await models.tbl_machine.findOne({
            attributes: ['Machine_Punches'],
            where: { Machine_ID: resultData.incompleteData.MachineCode }
          })
          if (checkMasterObj[0].RepSerNo == null) {
            const objInsertMasterData = await models[batchSummaryMasterTable].create({
              MPN_Code: resultData.incompleteData.MPN_Code,
              BFGCode: resultData.incompleteData.BFGCode,
              ProductName: resultData.incompleteData.ProductName,
              PVersion: resultData.incompleteData.PVersion,
              Version: resultData.incompleteData.Version,
              BatchNo: resultData.incompleteData.BatchNo,
              CubicleType: resultData.incompleteData.CubicleType,
              Stage: cubicObj.Sys_Stage,
              Dept: resultData.incompleteData.Dept,
              // Nom: Number(resultData.incompleteData.Nom).toFixed(1),
              // Tol1Neg: Number(minLimitT1).toFixed(1),
              // Tol1Pos: Number(maxLimitT1).toFixed(1),

              Tol2Neg: resultData.incompleteData.T2NegTol,
              Tol2Pos: resultData.incompleteData.T2PosTol,
              Unit: resultData.incompleteData.Unit,
              Side: sideVal,
              IsArchived: resultData.incompleteData.IsArchived,
              LimitOn: resultData.incompleteData.LimitOn,
              Area: cubicObj.Sys_Area,
              BatchSize: `${cubicObj.Sys_BatchSize} ${cubicObj.Sys_BatchSizeUnit}`,
              // StdLimit1: resultData.incompleteData.StdLimit1,
              StdLimit2: resultData.incompleteData.StdLimit2,
              MachineCode: resultData.incompleteData.MachineCode,

              StartDate: moment().format("YYYY-MM-DD"),
              EndDate: moment().format("YYYY-MM-DD"),
              BatchStartTime: moment(resultData.incompleteData.PrTime).format("HH:mm:ss"),
              ReportType: resultData.incompleteData.ReportType,
              PrdType: resultData.incompleteData.ProductType,
              CubicalNo: cubicObj.Sys_CubicNo,
              NMT: resultData.incompleteData.NMT,
              GraphOn: resultData.incompleteData.GraphType,
              LimitOn: resultData.incompleteData.LimitOn,
              DP: dp,
              BatchCompleted: 0,
              NoOfStations: machinePunches.Machine_Punches,
              Repetition: resultData.incompleteData.Repetition,
              SFOID: resultData.incompleteData.SFOID,
              LHSContainerNo: "NA",
              RHSContainerNo: "NA"
            })
            var masterResult = objInsertMasterData.dataValues;
            masterSrNo = masterResult.RepSerNo;
          }

          masterSrNo = masterSrNo != undefined ? masterSrNo : checkMasterObj[0].RepSerNo;
          var objInsertDetailData = await models[batchSummaryDetailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultData.incompleteData.PrDate,
            Time: moment(resultData.incompleteData.PrTime).format("HH:mm:ss"),
            InstrumentID: dataObj.instrumentId,
            Side: resultData.incompleteData.Side,
            // MinPer: minPer,
            // MaxPer: maxPer,
            Min: Number(minVal).toFixed(minMaxDp),
            Max: Number(maxVal).toFixed(minMaxDp),
            Avg: Number(avgVal).toFixed(avgDp),
            TestResult: remark,
            UserID: resultData.incompleteData.UserId,
            UserName: resultData.incompleteData.UserName,
            Repetition: resultData.incompleteData.Repetition,
            NoOfSample: resultData.incompleteData.Qty,
            SFOID: resultData.incompleteData.SFOID,
          })

          var Complies_Result = await models[batchSummaryDetailTable].findAll({
            where: {
              RepSerNo: masterSrNo,
              TestResult: 'Complies',
              // InstrumentID: dataObj.InstrumentId
            }
          })

          if (Complies_Result.length > 0) {
            var arr_max = Complies_Result.map(e => e.Max);
            var arr_min = Complies_Result.map(e => e.Min);
            var arr_avg = Complies_Result.map(e => e.Avg);
            var max_value = maths.max(arr_max);
            var min_value = maths.min(arr_min);
            let avg = objcalc.avgCalc(arr_avg, avgDp);

            max_value = isNaN(max_value) ? 'NA' : max_value;
            min_value = isNaN(min_value) ? 'NA' : min_value
            avg = isNaN(avg) ? 'NA' : avg

            let reult = await models[batchSummaryMasterTable].update({
              MaxValue: max_value,
              MinValue: min_value,
              AvgValue: avg,
              BatchEndTime: moment(resultData.incompleteData.PrEndTime).format("HH:mm:ss")
            }, {
              where: {
                RepSerNo: masterSrNo
              }
            })
          }


          Object.assign(responseObj, { status: 'success', remark: remark })
          return responseObj;
        }
      }

    } catch (error) {
      console.log(error);
      throw new Error(error)
    }
  }

  async saveBatchData(typeValue, resultdata, strHmi, strIdsNo,) {
    try {
      let responseObj = {};
      let strInstrumentId = "";
      let masterTable, detailTable, finalSum;
      let typeVal, sideVal, checkSideMasterTable;
      const objProductArray = globalData.arrIdsInfo.find(k => k.Ip == Ip);
      const objWeighment = objProductArray.cubicalData;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.Hmi == strHmi);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let selectedCubical = globalData.arrIdsInfo.find(k => k.Ip == Ip).cubicalData;

      let objProductTypeDetails = globalData.arrProductTypeArray.find(k => k.Ip == Ip);
      const objProdMasterDetails = objProductTypeDetails.productType;
      const objProdDetail = objProductTypeDetails.productDetail[0][0];
      const arrCheck = [1, 3, 4, 5, 6, 8, 'L'];

      if (arrCheck.some(type => type == typeValue)) {
        if (typeValue == 8) {
          masterTable = 'tbl_batchsummary_master9';
          detailTable = 'tbl_batchsummary_detail9';
        }
        else if (typeValue == 'L') {
          masterTable = 'tbl_batchsummary_master11';
          detailTable = 'tbl_batchsummary_detail11';
        }
        else {
          if (objProdMasterDetails.ProductType == 2 || objProdMasterDetails.ProductType == 1) {
            if (typeValue == 4) {
              masterTable = 'tbl_batchsummary_master6';
              detailTable = 'tbl_batchsummary_detail6';
            }
            else {
              masterTable = 'tbl_batchsummary_master' + typeValue;
              detailTable = 'tbl_batchsummary_detail' + typeValue;
            }

          }
          else {
            if (cubicalObj.Sys_Area == 'Dosa Dry Syrup') {
              masterTable = 'tbl_batchsummary_master19';
              detailTable = 'tbl_batchsummary_detail19';
            } else {
              masterTable = 'tbl_batchsummary_master' + typeValue;
              detailTable = 'tbl_batchsummary_detail' + typeValue;
            }
          }

        }

        let sum = resultdata.detailData.reduce((acc, obj) => { return acc + Number(obj.DataValue); }, 0);
        finalSum = sum;


        if (typeValue == 8) {
          typeVal = 9;
        }
        else if (typeValue == 'L') {
          typeVal = 11;
        }
        else if (typeValue == 'P') {
          typeVal = 18;
        }
        else {
          typeVal = typeValue;
        }

        let resOfSP = await objStoreProcedure.fetchDetailForStats(resultdata, typeVal);
        let maxVal = resOfSP.max;//Math.max(...arrDetail);
        let minVal = resOfSP.min; //Math.min(...arrDetail);
        let avgVal = resOfSP.avg;  //(finalSum / count);
        if (((objWeighment.Sys_RptType == 0) &&
          (objWeighment.Sys_Validation == 0) &&
          ((objWeighment.Sys_CubType == 'Compression') || (objWeighment.Sys_CubType == 'Coating') ||
            (objWeighment.Sys_CubType == 'Capsule Filling') || (objWeighment.Sys_CubType == 'IPQC') || (objWeighment.Sys_CubType == 'Dosa Dry')))) {
          let res = objProdDetail;
          let paramNom = `Param${typeVal}_Nom`;
          let limitNo = `Param${typeVal}_LimitOn`;
          let nom = parseFloat(res[paramNom]);
          let limit = res[limitNo];
          let minPer, maxPer;
          if (limit == false)//standard
          {
            minPer = Math.abs(((nom - minVal) / nom) * 100);
            maxPer = Math.abs(((maxVal - nom) / nom) * 100);
          }
          else//average
          {
            minPer = Math.abs(((avgVal - minVal) / avgVal) * 100);
            maxPer = Math.abs(((maxVal - avgVal) / avgVal) * 100);
          }
          if (typeValue == "1" || typeValue == "8" || typeValue == "L"
            || typeValue == "9" || typeValue == "K") {
            strInstrumentId = resultdata.incompleteData.InsturmentID;
          } else if (typeValue == "3" || typeValue == "4" || typeValue == "5" || typeValue == "6") {
            strInstrumentId = resultdata.incompleteData.VernierId;
          }

          if (resultdata.incompleteData.Side == 'LHS') {
            sideVal = "LEFT";
          } else if (resultdata.incompleteData.Side == 'RHS') {
            sideVal = "RIGHT";
          } else {
            sideVal = "NA";
          }
          if (resultdata.incompleteData.Side == 'NA') {
            checkSideMasterTable = resultdata.incompleteData.Side;
          } else {
            checkSideMasterTable = 'LEFT';
          }
          // We only want to check side for NA and left side in master table so again we declare 
          // side variable for this specific perpose
          const checkMasterObj = await models[masterTable].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
            where: {
              BFGCode: resultdata.incompleteData.BFGCode,
              ProductName: resultdata.incompleteData.ProductName,
              PVersion: resultdata.incompleteData.PVersion,
              Version: resultdata.incompleteData.Version,
              Side: checkSideMasterTable,
              CubType: resultdata.incompleteData.CubicleType,
              BatchNo: resultdata.incompleteData.BatchNo
            }
          })

          let resultData = checkMasterObj;
          let masterSrNo;
          // let DP = resultdata.incompleteData.DP;
          const SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
          let remark = 'Complies';
          if (SampleRemark.OutOfRemark == true) {
            remark = "Not Complies";
          } else {
            remark = "Complies";
          }

          let recSeqNo = await this.calculateSeqNo(sideVal, masterTable, detailTable,
            resultdata.incompleteData);


          let objSelMenu = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
          objSelMenu.selectedProductDetail.nominal = objProdDetail.Param1_Nom
          // masterTable = 'tbl_tab_master1';
          // detailTable = 'tbl_tab_detail1';
          // strincomplete =  'tbl_tab_master1_incomplete'
          typeValue = 1;
          var maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
          var maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

          if (resultData[0].SrNo == null) {
            const objInsertMasterData = await models[masterTable].create({
              BFGCode: resultdata.incompleteData.BFGCode,
              ProductName: resultdata.incompleteData.ProductName,
              PVersion: resultdata.incompleteData.PVersion,
              Version: resultdata.incompleteData.Version,
              PrdType: resultdata.incompleteData.ProductType,
              CubType: resultdata.incompleteData.CubicleType,
              BatchNo: resultdata.incompleteData.BatchNo,
              Stage: selectedCubical.Sys_Stage,
              Dept: resultdata.incompleteData.Dept,
              Nom: Number(resultdata.incompleteData.Nom).toFixed(1),
              Tol1Neg: Number(minLimitT1).toFixed(1),
              Tol1Pos: Number(maxLimitT1).toFixed(1),
              Tol2Neg: Number(minLimitT2).toFixed(1),
              Tol2Pos: Number(maxLimitT2).toFixed(1),
              DP: DP,
              //LODLayer: resultdata.incompleteDatad ,
              Unit: resultdata.incompleteData.Unit,
              FinalMinDT: resultdata.incompleteData.PrDate,
              FinalMaxDT: moment(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
              FinalAvgDT: resultdata.incompleteData.PrEndDate,
              Side: sideVal,
              BatchCompleted: resultdata.incompleteData.BatchComplete,
              IsArchived: resultdata.incompleteData.IsArchived,
              LimitOn: resultdata.incompleteData.LimitOn,
              NMTLimit: resultdata.incompleteData.T1NMT,
              Area: selectedCubical.Sys_Area,
              // GenericName: resultdata.incompleteData.GenericName,
              // BMRNo: resultdata.incompleteData.BMRNo,
              BatchSize: `${selectedCubical.Sys_BatchSize} ${selectedCubical.Sys_BatchSizeUnit}`,
              ReportType: resultdata.incompleteData.GraphType,
              StdLimit1: resultdata.incompleteData.StdLimit1,
              StdLimit2: resultdata.incompleteData.StdLimit2

            })
            var masterResult = objInsertMasterData.dataValues;
            masterSrNo = masterResult.RepSerNo;
          }

          // const objInsertDetailData = await models[detailTable].create({
          //     RepSerNo: masterSrNo,
          //     RecSeqNo: recSeqNo,
          //     Date: resultdata.incompleteData.PrDate,
          //     Time: resultdata.incompleteData.PrTime,
          //     InstrumentID: resultdata.incompleteData.InsturmentID,
          //     Side: sideVal,
          //     MinPer: minPer,
          //     MaxPer: maxPer,
          //     Min: Number(minVal).toFixed(1),
          //     Max: Number(maxVal).toFixed(1),
          //     Avg: Number(avgVal).toFixed(1),
          //     TestResult: remark,
          //     UserID: resultdata.incompleteData.UserId,
          //     UserName: resultdata.incompleteData.UserName,


          // })

          // Object.assign(responseObj, { status: 'success' })
          // return responseObj;

          // } else {
          masterSrNo = masterSrNo != undefined ? masterSrNo : resultData[0].SrNo;
          var objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: moment(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
            InstrumentID: resultdata.incompleteData.InsturmentID,
            Side: sideVal,
            // MinPer: minPer,
            // MaxPer: maxPer,
            Min: Number(minVal).toFixed(1),
            Max: Number(maxVal).toFixed(1),
            Avg: Number(avgVal).toFixed(1),
            TestResult: remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,

          })

          // var Complies_Result = await models[detailTable].findAll({
          //     where: {
          //         RepSerNo: resultData[0].SrNo,
          //         TestResult: 'Complies',
          //         InstrumentID: resultdata.incompleteData.InsturmentID
          //     }
          // })
          // var arr = [];
          // var arr_min = [];
          // var arr_avg = [];
          // for (var i = 0; i < Complies_Result.length; i++) {
          //     var Max = Complies_Result[i].Max;
          //     arr.push(Number(Max));
          //     // console.log(arr);
          //     var Min = Complies_Result[i].Min;
          //     arr_min.push(Number(Min));
          //     // console.log(arr_min);
          //     var max_value = maths.max(arr);
          //     var min_value = maths.min(arr_min);
          //     var average = Complies_Result[i].Avg;
          //     arr_avg.push(Number(average));
          //     // console.log(average);
          //     var total = arr_avg.reduce((acc, total) => {
          //         return Number(total) + Number(acc);
          //     }, 0)
          //     var avg = total / arr_avg.length
          //     avg = avg.toFixed(1);
          // }
          // var update_Master = await models[masterTable].update({
          //     MaxValue: Number(max_value).toFixed(1),
          //     MinValue: Number(min_value).toFixed(1),
          //     AvgValue: Number(avg).toFixed(1)

          // }, {
          //     where: {
          //         RepSerNo: masterSrNo
          //     }
          // })
          // let detailResult = (objInsertDetailData);
          // Object.assign(responseObj, { status: 'success', remark: remark })
          // return responseObj;
          // }
          var Complies_Result = await models[detailTable].findAll({
            where: {
              RepSerNo: masterSrNo,
              TestResult: 'Complies',
              InstrumentID: resultdata.incompleteData.InsturmentID
            }
          })
          var arr = [];
          var arr_min = [];
          var arr_avg = [];
          for (var i = 0; i < Complies_Result.length; i++) {
            var Max = Complies_Result[i].Max;
            arr.push(Number(Max));
            // console.log(arr);
            var Min = Complies_Result[i].Min;
            arr_min.push(Number(Min));
            // console.log(arr_min);
            var max_value = maths.max(arr);
            var min_value = maths.min(arr_min);
            var average = Complies_Result[i].Avg;
            arr_avg.push(Number(average));
            // console.log(average);
            var total = arr_avg.reduce((acc, total) => {
              return Number(total) + Number(acc);
            }, 0)
            var avg = total / arr_avg.length
            avg = avg.toFixed(1);
          }
          var update_Master = await models[masterTable].update({
            MaxValue: max_value == 0 ? 'NA' : Number(max_value).toFixed(1),
            MinValue: min_value == 0 ? 'NA' : Number(min_value).toFixed(1),
            AvgValue: avg == 0 ? 'NA' : Number(avg).toFixed(1)

          }, {
            where: {
              RepSerNo: masterSrNo
            }
          })
          let detailResult = (objInsertDetailData);
          Object.assign(responseObj, { status: 'success', remark: remark })
          return responseObj;

        }
      } else {
        return false;
      }

    } catch (error) {
      console.log(error);
      throw new Error(error)
    }
  }

  async calculateSeqNo(side, masterTableName, detailTableName, inCompleteData) {
    try {

      let selectedSide;
      if (side == 'NA') {
        selectedSide = side;
      } else {
        selectedSide = "LEFT";
      }
      let selectDetailData = await models[masterTableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          // BFGCode: inCompleteData.BFGCode,
          // ProductName: inCompleteData.ProductName,
          PVersion: inCompleteData.PVersion,
          Version: inCompleteData.Version,
          BatchNo: inCompleteData.BatchNo,
          Side: selectedSide,
          MPN_Code: inCompleteData.MPN_Code

        }

      })
      //  {
      //     str_tableName: masterTableName,
      //     data: 'MAX(RepSerNo) AS RepSerNo',
      //     condition: [
      //       BFGCode: inCompleteData.BFGCode ,
      //       ProductName: inCompleteData.ProductName ,
      //       PVersion: inCompleteData.PVersion ,
      //       Version: inCompleteData.Version ,
      //       BatchNo: inCompleteData.BatchNo ,
      //       Side: selectedSide 
      //     ]
      // }
      let selectRes = [selectDetailData];
      if (selectRes[0][0].RepSerNo === null) {
        return 1;
      } else {
        let selectDetail = await models[detailTableName].findAll({
          attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
          where: {
            RepSerNo: selectRes[0][0].RepSerNo,
            Side: side
          }
        })
        // {
        //     str_tableName: detailTableName,
        //     data: 'MAX(RecSeqNo) AS RecSeqNo',
        //     condition: [
        //         { str_colName: 'RepSerNo', value: selectRes[0][0].RepSerNo },
        //         { str_colName: 'Side', value: side }
        //     ]
        // }
        let reqSeqRes = [selectDetail];
        if (reqSeqRes[0][0].RepSerNo === null) {
          return 1;
        } else {
          return reqSeqRes[0][0].RepSerNo + 1;
        }
      }
    } catch (error) {
      throw new Error(error)
    }

  }

  async saveBatchSummaryDT(InsertIdLHS = 0, InsertIdRHS = 0, selectedcubicalObj, idsNo) {
    try {
      // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
      let selectedIds = idsNo;
      // if (IPQCObject != undefined) {
      //     selectedIds = IPQCObject.selectedIds;
      // } else {
      //     selectedIds = idsNo;
      // }

      let cubicalObj = selectedcubicalObj
      //if (((cubicalObj.Sys_RptTyp0e == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating') || (cubicalObj.Sys_CubType == 'Capsule Filling'))) {
      if ((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0)
        && (cubicalObj.Sys_CubType != 'IPQA') && (cubicalObj.Sys_CubType != 'IPQC')) {

        /**
         * SELECT MAX(`DT_RunTime`) AS 'Max', MIN(`DT_RunTime`) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(`DT_RunTime`) * 3600 +
         *(MINUTE(`DT_RunTime`) * 60) + SECOND(`DT_RunTime`))),'%H:%i:%s') AS 'Avg' FROM `tbl_tab_detail13` WHERE `RepSerNo`=1
         */
        // let res = await proObj.productData(selectedcubicalObj);

        let res = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIds).productType;
        let res1 = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIds)
        res1 = res1.productDetail[0][0]
        var masterResult;
        var ProductType = res.ProductType
        var tblMstName = ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6'
        var tblDetName = ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6'

        if (selectedcubicalObj.Sys_RotaryType == 'Double') {
          //masterResult = await database.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}' OR RepSerNo = '${InsertIdRHS}'`);
          let str_Query = `SELECT * FROM ${tblMstName} WHERE RepSerNo = ${InsertIdLHS} OR RepSerNo = ${InsertIdRHS}`
          masterResult = await sequelize.query(str_Query, { type: QueryTypes.SELECT });
        } else {
          //masterResult = await dbCon.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}'`);
          let str_Query = `SELECT * FROM ${tblMstName} WHERE RepSerNo = ${InsertIdLHS}`
          masterResult = await sequelize.query(str_Query, { type: QueryTypes.SELECT });
        }

        if (masterResult.length != 0) {

          for (let obj of masterResult) {
            //         let detailResult = await dbCon.execute(`SELECT MAX(DT_RunTime) AS 'Max', MIN(DT_RunTime) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(DT_RunTime) * 3600 +
            // (MINUTE(DT_RunTime) * 60) + SECOND(DT_RunTime))),'%H:%i:%s') AS 'Avg' FROM tbl_tab_detail13 WHERE RepSerNo='${obj.RepSerNo}'`);

            let str_Query = `SELECT MAX(DT_RunTime) AS 'Max', MIN(DT_RunTime) AS 'Min', 
                                TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(DT_RunTime) * 3600 +
                                (MINUTE(DT_RunTime) * 60) + SECOND(DT_RunTime))),'%H:%i:%s') AS 'Avg' 
                                FROM ${tblDetName} WHERE RepSerNo= ${obj.RepSerNo}`

            let detailResult = await sequelize.query(str_Query, { type: QueryTypes.SELECT })

            let side = 'NA';
            if (selectedcubicalObj.Sys_RotaryType == 'Single') {
              side = 'NA';
            } else {
              if (obj.Side == 'NA') {
                side = 'NA';
              } else if (obj.Side == 'LHS') {
                side = 'LEFT';
              } else {
                side = 'RIGHT';
              }
            }

            var result = 'Compiles';
            /**
             * @description Comparing DT std time and max time
             * var startTime = "01:00:00";
                var endTime = "01:00:00";
                var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
                if(parseInt(endTime .replace(regExp, "$1$2$3")) > parseInt(startTime .replace(regExp, "$1$2$3"))){
                console.log('true')
                } else {
                console.log('false')
                }
             */
            var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            var stdTime = ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom;
            var maxTime = detailResult[0].Max;
            if (parseInt(maxTime.replace(regExp, "$1$2$3")) > parseInt(stdTime.replace(regExp, "$1$2$3"))) {
              result = 'Not Complies';
            } else {
              result = 'Complies';
            }

            let checkSideMasterTable;
            if (selectedcubicalObj.Sys_RotaryType != 'Double') {
              checkSideMasterTable = 'NA';
            } else {
              checkSideMasterTable = 'LEFT';
            }

            const resultData = await models.tbl_batchsummary_master13.findAll({
              where: {
                BFGCode: selectedcubicalObj.Sys_BFGCode,
                ProductName: selectedcubicalObj.Sys_ProductName,
                PVersion: selectedcubicalObj.Sys_PVersion,
                Version: selectedcubicalObj.Sys_Version,
                CubType: obj.CubicleType,
                Side: checkSideMasterTable,
                BatchNo: obj.BatchNo,
              }
            })

            let incompleteData = {
              BFGCode: obj.BFGCode,
              ProductName: obj.ProductName,
              PVersion: obj.PVersion,
              Version: obj.Version,
              BatchNo: obj.BatchNo
            }

            let recSeqNo = await this.calculateSeqNo1(side, 'tbl_batchsummary_master13', 'tbl_batchsummary_detail13', incompleteData);

            if (resultData.length == 0) {

              let masterBatchSummary = await models.tbl_batchsummary_master13.create({
                BFGCode: obj.BFGCode,
                ProductName: obj.ProductName,
                PVersion: obj.PVersion,
                Version: obj.Version,
                PrdType: obj.ProductType,
                CubType: obj.CubicleType,
                BatchNo: obj.BatchNo,
                Stage: selectedcubicalObj.Sys_Stage,
                Dept: selectedcubicalObj.Sys_dept,
                Tol1Neg: ProductType == 1 ? res1.Param6_T1Neg : res1.Param6_T1Neg,//; res[1].Param13_T1Neg,
                Tol1Pos: ProductType == 1 ? res1.Param13_T1Pos : res1.Param6_T1Pos,//res[1].Param13_T1Pos,
                DTStdTime: ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom,//res[1].Param13_Nom,
                Side: checkSideMasterTable,
                BatchCompleted: 0,
                Area: selectedcubicalObj.Sys_Area,
                GenericName: cubicalObj.Sys_GenericName,
                BMRNo: cubicalObj.Sys_BMRNo,
                BatchSize: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
                ReportType: 0
              })

              let masterSrNo = masterBatchSummary.dataValues.RepSerNo;

              await models.tbl_batchsummary_detail13.create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: obj.PrDate,
                Time: obj.PrTime,
                //InstrumentID: cubicalObj.Sys_DTID,
                InstrumentID: obj.DTID,
                Side: side,
                MinTimeDT: detailResult[0].Min,
                MaxTimeDT: detailResult[0].Max,
                AvgTimeDT: detailResult[0].Avg,
                TestResult: result,
                UserID: obj.UserId,
                UserName: obj.UserName
              })


            } else {

              let masterSrNo = resultData[0].RepSerNo;

              await models.tbl_batchsummary_detail13.create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: obj.PrDate,
                Time: obj.PrTime,
                InstrumentID: obj.DTID,
                Side: side,
                MinTimeDT: detailResult[0].Min,
                MaxTimeDT: detailResult[0].Max,
                AvgTimeDT: detailResult[0].Avg,
                TestResult: result,
                UserID: obj.UserId,
                UserName: obj.UserName,
              })

            }
          }
        }
      }
    } catch (error) {
      throw new Error(error)
    }

  }

  async saveBatchSummaryFriability(masterData, idsNo) {
    var now = new Date();
    let responseObj = {};
    //var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
    var strHmi = idsNo;
    // if (IPQCObject != undefined) {
    //     selectedIds = IPQCObject.selectedIds;
    // } else {
    //     selectedIds = idsNo;
    // }
    var cubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
    //var tempLimObj = globalData.arr_limits.find(k => k.idsNo == idsNo);
    if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
      let result = "Complies";
      let sideVal = "NA";
      if (masterData.Side == 'Double') {
        sideVal = "LEFT";
      }
      else {
        sideVal = "NA";
      }

      const checkMasterObj = await models.tbl_batchsummary_master8.findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          BFGCode: masterData.BFGCode,
          ProductName: masterData.ProductName,
          PVersion: masterData.PVersion,
          Version: masterData.Version,
          Side: sideVal,
          CubType: cubicalObj.Sys_CubType,
          BatchNo: masterData.BatchNo,
        }
      })

      var masterSrNo;
      let resultData = checkMasterObj;
      let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_master8', 'tbl_batchsummary_detail8', masterData);
      // let ProdRes = await proObj.productData(cubicalObj);
      // let ProdRes = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIds).productType;

      if (resultData[0].RepSerNo == null) {
        let masterDataInsert = await models.tbl_batchsummary_master8.create({
          BFGCode: masterData.BFGCode,
          ProductName: masterData.ProductName,
          PVersion: masterData.PVersion,
          Version: masterData.Version,
          PrdType: 1,
          CubType: masterData.CubType,
          BatchNo: masterData.BatchNo,
          Unit: masterData.Unit,
          Dept: masterData.Dept,
          Nom: masterData.Nom,
          Area: masterData.Area,
          // LwrHard: masterData.NegTolHard },
          // UppHard: masterData.PosTolHard },
          // UnitHard: masterData.Unit },
          // NomThick: masterData.NomThick },
          // LwrThick: masterData.NegTolThick },
          // UppThick: masterData.PosTolThick },
          // NomDLB: masterData.NomDOLOBO },
          // LwrDLB: masterData.NegTolDOLOBO },
          // UppDLB: masterData.PosTolDOLOBO },
          // DLBParamName: masterData.ColHeadDOLOBO },
          Side: sideVal,
          BatchCompleted: 0,
          IsArchived: 0

        })

        let saveBatchSumm = masterDataInsert;
        masterSrNo = saveBatchSumm.dataValues.RepSerNo;
        if (sideVal == 'NA') {
          /**
           * @formula
           * calculation = ((before-After)/Before)*100
           */
          let calculation = (((masterData.nwtBeforeTest - masterData.nwtAfterTest) / masterData.nwtBeforeTest) * 100);
          if (calculation > masterData.Nom) {
            result = "Not Complies";
          } else {
            result = "Complies";
          }
          const objInsertDetailData = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'NA',
            Min: calculation < 0 ? 0 : calculation,
            Max: calculation < 0 ? 0 : calculation,
            Avg: calculation < 0 ? 0 : calculation,
            TestResult: result,
            UserID: masterData.UserId,
            UserName: masterData.UserName
          })

          //console.log(objInsertDetailData);
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        } else {
          let resultLHS; let resultRHS;
          /**
              * @formula
              * calculation = ((before-After)/Before)*100
              */
          let calculationLHS = (((masterData.lwtBeforeTest - masterData.lwtAfterTest) / masterData.lwtBeforeTest) * 100);
          if (calculationLHS > masterData.Nom) {
            resultLHS = "Not Complies";
          } else {
            resultLHS = "Complies";
          }
          const objInsertDetailDataLHS = await models.tbl_batchsummary_detail8.create({

            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'LEFT',
            Min: calculationLHS,
            Max: calculationLHS,
            Avg: calculationLHS,
            TestResult: resultLHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,


          })

          // await database.save(objInsertDetailDataLHS);
          let calculationRHS = (((masterData.rwtBeforeTest - masterData.rwtAfterTest) / masterData.rwtBeforeTest) * 100);
          if (calculationRHS > masterData.Nom) {
            resultRHS = "Not Complies";
          } else {
            resultRHS = "Complies";
          }
          const objInsertDetailDataRHS = await models.tbl_batchsummary_detail8.create({

            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'RIGHT',
            Min: calculationRHS,
            Max: calculationRHS,
            Avg: calculationRHS,
            TestResult: resultRHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,


          })
          //console.log(objInsertDetailData);
          // await database.save(objInsertDetailDataRHS);
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }
      } else {
        masterSrNo = resultData[0].RepSerNo;
        if (sideVal == 'NA') {
          /**
           * @formula
           * calculation = ((before-After)/Before)*100
           */
          let calculation = (((masterData.nwtBeforeTest - masterData.nwtAfterTest) / masterData.nwtBeforeTest) * 100);
          if (calculation > masterData.Nom) {
            result = "Not Complies";
          } else {
            result = "Complies";
          }
          const objInsertDetailData = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'NA',
            Min: calculation,
            Max: calculation,
            Avg: calculation,
            TestResult: result,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
          })

          //console.log(objInsertDetailData);
          // await database.save(objInsertDetailData);
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        } else {
          let resultLHS; let resultRHS;
          /**
              * @formula
              * calculation = ((before-After)/Before)*100
              */
          let calculationLHS = (((masterData.lwtBeforeTest - masterData.lwtAfterTest) / masterData.lwtBeforeTest) * 100);
          if (calculationLHS > masterData.Nom) {
            resultLHS = "Not Complies";
          } else {
            resultLHS = "Complies";
          }
          const objInsertDetailDataLHS = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'LEFT',
            Min: calculationLHS,
            Max: calculationLHS,
            Avg: calculationLHS,
            TestResult: resultLHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
          })

          let calculationRHS = (((masterData.rwtBeforeTest - masterData.rwtAfterTest) / masterData.rwtBeforeTest) * 100);
          if (calculationRHS > masterData.Nom) {
            resultRHS = "Not Complies";
          } else {
            resultRHS = "Complies";
          }
          const objInsertDetailDataRHS = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'RIGHT',
            Min: calculationRHS,
            Max: calculationRHS,
            Avg: calculationRHS,
            TestResult: resultRHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
          })

          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }
      }
    } else {
      return 'success';
    }
  }

  async saveBatchSummaryFriability1(masterData, strDsNo) {
    var now = new Date();
    let responseObj = {};
    let dp = 2;

    var strDsNo = strDsNo;

    var cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;

    if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
      let result = "Complies";
      let sideVal = "NA";
      if (masterData.Side == 'Double') {
        sideVal = "LEFT";
      }
      else {
        sideVal = "NA";
      }

      const checkMasterObj = await models.tbl_batchsummary_master8.findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          MPN_Code: masterData.MPN_Code,
          ProductName: masterData.ProductName,
          PVersion: masterData.PVersion,
          Version: masterData.Version,
          Side: sideVal,
          CubicleType: masterData.CubType,
          BatchNo: masterData.BatchNo,
        }
      })

      var masterSrNo;
      let resultData = checkMasterObj;
      let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_master8', 'tbl_batchsummary_detail8', masterData);


      if (resultData[0].RepSerNo == null) {
        let masterDataInsert = await models.tbl_batchsummary_master8.create({
          BFGCode: masterData.BFGCode,
          ProductName: masterData.ProductName,
          PVersion: masterData.PVersion,
          Version: masterData.Version,
          PrdType: 1,
          CubicleType: masterData.CubType,
          BatchNo: masterData.BatchNo,
          Unit: masterData.Unit,
          Dept: masterData.Dept,
          Nom: masterData.Nom,
          Area: masterData.Area,
          // LwrHard: masterData.NegTolHard },
          // UppHard: masterData.PosTolHard },
          // UnitHard: masterData.Unit },
          // NomThick: masterData.NomThick },
          // LwrThick: masterData.NegTolThick },
          // UppThick: masterData.PosTolThick },
          // NomDLB: masterData.NomDOLOBO },
          // LwrDLB: masterData.NegTolDOLOBO },
          // UppDLB: masterData.PosTolDOLOBO },
          // DLBParamName: masterData.ColHeadDOLOBO },
          Side: sideVal,
          BatchCompleted: 0,
          IsArchived: 0,
          MPN_Code: masterData.MPN_Code

        })

        let saveBatchSumm = masterDataInsert;
        masterSrNo = saveBatchSumm.dataValues.RepSerNo;
        if (sideVal == 'NA') {
          /**
           * @formula
           * calculation = ((before-After)/Before)*100
           */
          let calculation = (((masterData.nwtBeforeTest - masterData.nwtAfterTest) / masterData.nwtBeforeTest) * 100).toFixed(dp);
          if (calculation > masterData.Nom) {
            result = "Not Complies";
          } else {
            result = "Complies";
          }
          const objInsertDetailData = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'NA',
            Friability: calculation,
            TestResult: result,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
            InitialWeight: masterData.lwtBeforeTest,
            FinalWeight: masterData.lwtAfterTest,
          })

          //console.log(objInsertDetailData);

          await this.getMinMaxAvg(masterSrNo, dp)

          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        } else {
          let resultLHS; let resultRHS;
          /**
              * @formula
              * calculation = ((before-After)/Before)*100
              */
          let calculationLHS = (((masterData.lwtBeforeTest - masterData.lwtAfterTest) / masterData.lwtBeforeTest) * 100).toFixed(dp);
          if (calculationLHS > masterData.Nom) {
            resultLHS = "Not Complies";
          } else {
            resultLHS = "Complies";
          }
          const objInsertDetailDataLHS = await models.tbl_batchsummary_detail8.create({

            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'LEFT',
            Friability: calculationLHS,
            TestResult: resultLHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
            InitialWeight: masterData.lwtBeforeTest,
            FinalWeight: masterData.lwtAfterTest,

          })

          // await database.save(objInsertDetailDataLHS);
          let calculationRHS = (((masterData.rwtBeforeTest - masterData.rwtAfterTest) / masterData.rwtBeforeTest) * 100).toFixed(dp);
          if (calculationRHS > masterData.Nom) {
            resultRHS = "Not Complies";
          } else {
            resultRHS = "Complies";
          }
          const objInsertDetailDataRHS = await models.tbl_batchsummary_detail8.create({

            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'RIGHT',
            Friability: calculationRHS,
            TestResult: resultRHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
            InitialWeight: masterData.rwtBeforeTest,
            FinalWeight: masterData.rwtAfterTest,


          })
          //console.log(objInsertDetailData);
          // await database.save(objInsertDetailDataRHS);

          await this.getMinMaxAvg(masterSrNo, dp)
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }
      } else {
        masterSrNo = resultData[0].RepSerNo;
        if (sideVal == 'NA') {
          /**
           * @formula
           * calculation = ((before-After)/Before)*100
           */
          let calculation = (((masterData.nwtBeforeTest - masterData.nwtAfterTest) / masterData.nwtBeforeTest) * 100);
          if (calculation > masterData.Nom) {
            result = "Not Complies";
          } else {
            result = "Complies";
          }
          const objInsertDetailData = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'NA',
            Friability: calculation,
            TestResult: result,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
          })


          await this.getMinMaxAvg(masterSrNo, dp)

          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        } else {
          let resultLHS; let resultRHS;
          /**
              * @formula
              * calculation = ((before-After)/Before)*100
              */
          let calculationLHS = (((masterData.lwtBeforeTest - masterData.lwtAfterTest) / masterData.lwtBeforeTest) * 100).toFixed(dp);
          if (calculationLHS > masterData.Nom) {
            resultLHS = "Not Complies";
          } else {
            resultLHS = "Complies";
          }
          const objInsertDetailDataLHS = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'LEFT',
            Friability: calculationLHS,
            TestResult: resultLHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
            InitialWeight: masterData.lwtBeforeTest,
            FinalWeight: masterData.lwtAfterTest,
          })

          let calculationRHS = (((masterData.rwtBeforeTest - masterData.rwtAfterTest) / masterData.rwtBeforeTest) * 100).toFixed(dp);
          if (calculationRHS > masterData.Nom) {
            resultRHS = "Not Complies";
          } else {
            resultRHS = "Complies";
          }
          const objInsertDetailDataRHS = await models.tbl_batchsummary_detail8.create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: masterData.PrDate,
            Time: masterData.PrTime,
            InstrumentID: masterData.InstrumentID,
            Side: 'RIGHT',
            Friability: calculationRHS,
            TestResult: resultRHS,
            UserID: masterData.UserId,
            UserName: masterData.UserName,
            InitialWeight: masterData.rwtBeforeTest,
            FinalWeight: masterData.rwtAfterTest,
          })

          await this.getMinMaxAvg(masterSrNo, dp)
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }


      }
    } else {
      return 'success';
    }
  }

  async getMinMaxAvg(RepSerNo, dp) {
    let detailData = await models.tbl_batchsummary_detail8.findAll({
      where: {
        RepSerNo: RepSerNo
      }
    })

    let detailarr = [];
    detailData.map(a => detailarr.push(a.Friability))
    let MinValue = mathj.min(detailarr).toFixed(dp)
    let MaxValue = mathj.max(detailarr).toFixed(dp)
    let AvgValue = (mathj.sum(detailarr) / detailarr.length).toFixed(dp)

    await models.tbl_batchsummary_master8.update({
      MinValue: MinValue,
      MaxValue: MaxValue,
      AvgValue: AvgValue,
    }, {
      where: {
        RepSerNo: RepSerNo
      }
    })

    return { status: 'success' }
  }


  /**
   * 
   * @param {*} masterData 
   * @param {*} DetailData 
   * @description `saveBatchDataHardness` Save the batch Summary Data for `Hardness`
   */


  async saveBatchDataHardness8M(masterData, DetailData, strDsNo) {
    var now = new Date();
    let responseObj = {};
    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
    var selectedIds = idsNo;
    // console.log(masterData, DetailData);
    var cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
    var menuDetails = globalData.arr_limits.find(k => k.idsNo == idsNo);
    var tempLimObj = menuDetails.Menus.filter(obj => Object.keys(obj) == "Hardness")[0];
    let resultForHardess = {};
    // masterData.RepSerNo
    Object.assign(resultForHardess,
      { incompleteTableName: 'tbl_tab_master7_incomplete' },
      { incompletedetailTableName: 'tbl_tab_detail7_incomplete' },
    )

    let sideVal = "NA";
    if (masterData.Side == 'LHS') {
      sideVal = "LEFT";
    } else if (masterData.Side == 'RHS') {
      sideVal = "RIGHT";
    } else {
      sideVal = "NA";
    }
    let checkSideMasterTable;
    if (masterData.Side == 'NA') {
      checkSideMasterTable = masterData.Side;
    } else {
      checkSideMasterTable = 'LEFT';
    }
    let sumHT = 0;
    let arrHTDetail = [];
    let outFlagHTD = 0;
    let remark = "";
    let maxHTDLimit = parseFloat(tempLimObj.Hardness.T1Pos);
    let minHTDLimit = parseFloat(tempLimObj.Hardness.T1Neg);
    let count = DetailData.length;
    for (var i = 0; i < DetailData.length; i++) {
      var dataValHard = parseFloat(DetailData[i].DataValue);
      if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
        outFlagHTD = outFlagHTD + 1;
      }
      arrHTDetail.push(dataValHard);
    }
    if (masterData.T1NegTol != 0) {
      if (outFlagHTD != 0) {
        remark = 'Not Complies';
      } else {
        remark = 'Complies';
      }
    }

    var resOfSP = await objStoreProcedure.fetchDetailForStats(resultForHardess, 7, masterData.RepSerNo);
    var MaxHard = resOfSP[1][0]['@maxWeight'];//Math.max(...arrDetail);
    var MinHard = resOfSP[1][0]['@minWeight']; //Math.min(...arrDetail);
    var avgHard = resOfSP[1][0]['@average'];  //(finalSum / count);
    if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
      // let res = await proObj.productData(cubicalObj);
      // var paramNom = `Param7_Nom`;
      // var limitNo = `Param7_LimitOn`;
      // var nom = parseFloat(res[1][paramNom]);
      // var limit = res[1][limitNo].readUIntLE();
      // if(masterData.ColHeadDOLOBO == 'Le')

      const checkMasterObj = {
        str_tableName: 'tbl_batchsummary_master7',
        data: 'MAX(RepSerNo) AS SrNo',
        condition: [
          { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
          { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
          { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
          { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
          { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
          { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
          { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
        ]
      }
      var masterSrNo;
      // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
      let resultData = await database.select(checkMasterObj);
      let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_master7', 'tbl_batchsummary_detail7', masterData);
      if (resultData[0][0].SrNo == null) {
        let masterDataInsert = {
          str_tableName: 'tbl_batchsummary_master7',
          data: [
            { str_colName: 'BFGCode', value: masterData.BFGCode },
            { str_colName: 'ProductName', value: masterData.ProductName },
            { str_colName: 'PVersion', value: masterData.PVersion },
            { str_colName: 'Version', value: masterData.Version },
            { str_colName: 'PrdType', value: 1 },
            { str_colName: 'CubType', value: masterData.CubicleType },
            { str_colName: 'BatchNo', value: masterData.BatchNo },
            // { str_colName: 'Stage', value: masterData.Stage },
            { str_colName: 'Dept', value: cubicalObj.Sys_dept },
            { str_colName: 'Nom', value: masterData.Nom },
            { str_colName: 'Tol1Neg', value: masterData.T1NegTol },
            { str_colName: 'Tol1Pos', value: masterData.T1PosTol },
            // { str_colName: 'Tol2Neg', value: masterData.Unit },
            // { str_colName: 'Tol2Pos', value: masterData.NomThick },
            { str_colName: 'DP', value: 2 },
            { str_colName: 'Unit', value: masterData.Unit },
            { str_colName: 'Side', value: sideVal },
            { str_colName: 'BatchCompleted', value: masterData.BatchComplete[0] },
            { str_colName: 'IsArchived', value: masterData.IsArchived[0] },
            { str_colName: 'LimitOn', value: 0 },
            { str_colName: 'Area', value: cubicalObj.Sys_Area },
            { str_colName: 'GenericName', value: cubicalObj.Sys_GenericName },
            { str_colName: 'BMRNo', value: cubicalObj.Sys_BMRNo },
            { str_colName: 'BatchSize', value: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}` },
            { str_colName: 'ReportType', value: masterData.GraphType },

          ]
        }
        let saveBatchSumm = await database.save(masterDataInsert);
        masterSrNo = saveBatchSumm[0].insertId;
        const objInsertDetailData = {
          str_tableName: 'tbl_batchsummary_detail7',
          data: [
            { str_colName: 'RepSerNo', value: masterSrNo },
            { str_colName: 'RecSeqNo', value: recSeqNo },
            { str_colName: 'Date', value: masterData.PrDate },
            { str_colName: 'Time', value: masterData.PrTime },
            { str_colName: 'InstrumentID', value: masterData.HardnessID },
            { str_colName: 'Side', value: sideVal },
            { str_colName: 'Min', value: MinHard },
            { str_colName: 'Max', value: MaxHard },
            { str_colName: 'Avg', value: avgHard },
            // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            { str_colName: 'TestResult', value: remark },
            { str_colName: 'UserID', value: masterData.UserId },
            { str_colName: 'UserName', value: masterData.UserName },

          ]
        }
        //console.log(objInsertDetailData);
        let detailResult1 = await database.save(objInsertDetailData);
        Object.assign(responseObj, { status: 'success' })
        return remark;

      } else {
        masterSrNo = resultData[0][0].SrNo;
        //     const checkDetailObj = {
        //         str_tableName: detailTable,
        //         data: 'MAX(RecSeqNo) AS SeqNo',
        //         condition: [
        //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
        //         ]
        //     }
        //    let detailres = await database.select(checkDetailObj);
        //         var seqNum = detailres[0][0].SeqNo;
        //         var seqNo = seqNum + 1;
        const objInsertDetailData = {
          str_tableName: 'tbl_batchsummary_detail7',
          data: [
            { str_colName: 'RepSerNo', value: masterSrNo },
            { str_colName: 'RecSeqNo', value: recSeqNo },
            { str_colName: 'Date', value: masterData.PrDate },
            { str_colName: 'Time', value: masterData.PrTime },
            { str_colName: 'InstrumentID', value: masterData.HardnessID },
            { str_colName: 'Side', value: sideVal },
            { str_colName: 'Min', value: MinHard },
            { str_colName: 'Max', value: MaxHard },
            { str_colName: 'Avg', value: avgHard },
            // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            { str_colName: 'TestResult', value: remark },
            { str_colName: 'UserID', value: masterData.UserId },
            { str_colName: 'UserName', value: masterData.UserName },
          ]
        }
        await database.save(objInsertDetailData);
        Object.assign(responseObj, { status: 'success' })
        return remark;
      }
    }
    else {
      return remark;
    }
  }

  async saveBatchDataDiff(typeValue, resultdata, IdsNo, ResultOfReport) {
    try {
      let now = new Date();
      let responseObj = {};
      let arrDetail = [];
      let strIdsNo = IdsNo;
      let strInstrumentId = "";
      let objProductType = globalData.arrProductTypeArray.find(k => k.Hmi == IdsNo)
      let objArr_limits = globalData.arr_limits.find(k => k.Hmi == IdsNo);
      let cubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == IdsNo).cubicalData;
      let masterTable, detailTable, finalSum;
      // const objWeighment = objProductArray.cubicalData;
      let sum = 0;

      masterTable = 'tbl_batchsummary_masterdiff';
      detailTable = 'tbl_batchsummary_detaildiff';

      for (var i = 0; i < resultdata.detailData.length; i++) {
        var dataVal = resultdata.detailData[i].NetWeight;
        arrDetail.push(dataVal);
      }

      for (var j = 0; j < arrDetail.length; j++) {
        sum = sum + parseFloat(arrDetail[j]);
      }

      finalSum = sum;

      var count = arrDetail.length;
      // var maxVal = Math.max(...arrDetail);
      // var minVal = Math.min(...arrDetail);
      // var avgVal = (finalSum / count);
      let remark = 'Complies';
      if (ResultOfReport == 'Within of Limit') {
        remark = 'Complies';
      } else {
        remark = 'Not Complies'
      }

      var resOfSP = await objStoreProcedure.fetchDetailForStats(resultdata, 3);
      var maxVal = resOfSP[1][0]['@maxWeight'];//Math.max(...arrDetail);
      var minVal = resOfSP[1][0]['@minWeight']; //Math.min(...arrDetail);
      var avgVal = resOfSP[1][0]['@average'];  //(finalSum / count);

      if ((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Capsule Filling')) {
        let res = await proObj.productData(cubicalObj);
        var paramNom = `Param0_Nom`;
        var limitNo = `Param0_LimitOn`;
        var nom = parseFloat(res[1][paramNom]);
        var limit = res[1][limitNo].readUIntLE();
        var minPer, maxPer;
        if (limit == 0)//standard
        {
          minPer = Math.abs(((nom - minVal) / nom) * 100);
          maxPer = Math.abs(((maxVal - nom) / nom) * 100);
        }
        else//average
        {
          minPer = Math.abs(((avgVal - minVal) / avgVal) * 100);
          maxPer = Math.abs(((maxVal - avgVal) / avgVal) * 100);
        }
        if (typeValue == "D") {
          strInstrumentId = resultdata.incompleteData.BalanceId;
        }
        let sideVal = "NA";
        if (resultdata.incompleteData.Side == 'LHS') {
          sideVal = "LEFT";
        } else if (resultdata.incompleteData.Side == 'RHS') {
          sideVal = "RIGHT";
        } else {
          sideVal = "NA";
        }
        let checkSideMasterTable;
        if (resultdata.incompleteData.Side == 'NA') {
          checkSideMasterTable = resultdata.incompleteData.Side;
        } else {
          checkSideMasterTable = 'LEFT';
        }
        // We only want to check side for NA and left side in master table so again we declare 
        // side variable for this specific perpose
        const checkMasterObj = await models[masterTable].findAll({
          attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
          where: {
            BFGCode: objProductType.productType.ProductId,
            ProductName: objProductType.productType.ProductName,
            PVersion: objProductType.productType.ProductVersion,
            Version: objProductType.productType.Version,
            Side: checkSideMasterTable,
            CubType: resultdata.incompleteData.CubicleType,
            BatchNo: resultdata.incompleteData.BatchNo,
          }

        })

        let resultData = [checkMasterObj];
        var masterSrNo;
        let DP = resultdata.incompleteData.DecimalPoint;


        let recSeqNo = await this.calculateSeqNo(sideVal, masterTable, detailTable,
          resultdata.incompleteData);

        if (resultData[0][0].SrNo == null) {
          const objInsertMasterData = await models[masterTable].create({
            BFGCode: resultdata.incompleteData.BFGCode,
            ProductName: resultdata.incompleteData.ProductName,
            PVersion: resultdata.incompleteData.PVersion,
            Version: resultdata.incompleteData.Version,
            PrdType: resultdata.incompleteData.ProductType,
            CubType: resultdata.incompleteData.CubicleType,
            BatchNo: resultdata.incompleteData.BatchNo,
            Stage: cubicalObj.Sys_Stage,
            Dept: cubicalObj.Sys_dept,
            Nom: nom,
            Tol1Neg: resultdata.incompleteData.T1NegNet,
            Tol1Pos: resultdata.incompleteData.T1PosNet,
            Tol2Neg: resultdata.incompleteData.T2NegNet,
            Tol2Pos: resultdata.incompleteData.T2PosNet,
            DP: DP,
            Unit: resultdata.incompleteData.Unit,
            Side: sideVal,
            BatchCompleted: resultdata.incompleteData.BatchComplete.readUIntLE(),
            IsArchived: resultdata.incompleteData.IsArchived.readUIntLE(),
            LimitOn: limit,
            NMTLimit: resultdata.incompleteData.T1NMTTab,
            Area: cubicalObj.Sys_Area,
            GenericName: cubicalObj.Sys_GenericName,
            BMRNo: cubicalObj.Sys_BMRNo,
            BatchSize: `${cubicalObj.Sys_BatchSize}${cubicalObj.Sys_BatchSizeUnit}`,
            ReportType: resultdata.incompleteData.ReportType,


          })
          // {
          //     str_tableName: masterTable,
          //     data: [
          //         { str_colName: 'BFGCode', value: resultdata.incompleteData.BFGCode },
          //         { str_colName: 'ProductName', value: resultdata.incompleteData.ProductName },
          //         { str_colName: 'PVersion', value: resultdata.incompleteData.PVersion },
          //         { str_colName: 'Version', value: resultdata.incompleteData.Version },
          //         { str_colName: 'PrdType', value: resultdata.incompleteData.ProductType },
          //         { str_colName: 'CubType', value: resultdata.incompleteData.CubicleType },
          //         { str_colName: 'BatchNo', value: resultdata.incompleteData.BatchNo },
          //         { str_colName: 'Stage', value: cubicalObj.Sys_Stage },
          //         { str_colName: 'Dept', value: cubicalObj.Sys_dept },
          //         { str_colName: 'Nom', value: nom },
          //         { str_colName: 'Tol1Neg', value: resultdata.incompleteData.T1NegNet },
          //         { str_colName: 'Tol1Pos', value: resultdata.incompleteData.T1PosNet },
          //         { str_colName: 'Tol2Neg', value: resultdata.incompleteData.T2NegNet },
          //         { str_colName: 'Tol2Pos', value: resultdata.incompleteData.T2PosNet },
          //         { str_colName: 'DP', value: DP },
          //         { str_colName: 'Unit', value: resultdata.incompleteData.Unit },
          //         { str_colName: 'Side', value: sideVal },
          //         { str_colName: 'BatchCompleted', value: resultdata.incompleteData.BatchComplete.readUIntLE() },
          //         { str_colName: 'IsArchived', value: resultdata.incompleteData.IsArchived.readUIntLE() },
          //         { str_colName: 'LimitOn', value: limit },
          //         { str_colName: 'NMTLimit', value: resultdata.incompleteData.T1NMTTab },
          //         { str_colName: 'Area', value: cubicalObj.Sys_Area },
          //         { str_colName: 'GenericName', value: cubicalObj.Sys_GenericName },
          //         { str_colName: 'BMRNo', value: cubicalObj.Sys_BMRNo },
          //         { str_colName: 'BatchSize', value: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}` },
          //         { str_colName: 'ReportType', value: resultdata.incompleteData.ReportType },
          //     ]
          // }
          // if (serverConfig.ProjectName == 'SunHalolGuj1') {
          //     objInsertMasterData.data.push(
          //         { str_colName: 'Tol3Neg', value: resultdata.incompleteData.T3NegNet },
          //         { str_colName: 'Tol3Pos', value: resultdata.incompleteData.T3PosNet },
          //     )
          // }
          //date.format(now, 'YYYY-MM-DD')
          let masterResult = [objInsertMasterData];
          masterSrNo = masterResult[0].RepSerNo;
          const objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: resultdata.incompleteData.PrTime,
            InstrumentID: strInstrumentId,
            Side: sideVal,
            MinPer: minPer,
            MaxPer: maxPer,
            Min: minVal,
            Max: maxVal,
            Avg: avgVal,
            TestResult: remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,


          })
          //  {
          //     str_tableName: detailTable,
          //     data: [
          //         { str_colName: 'RepSerNo', value: masterSrNo },
          //         { str_colName: 'RecSeqNo', value: recSeqNo },
          //         { str_colName: 'Date', value: resultdata.incompleteData.PrDate },
          //         { str_colName: 'Time', value: resultdata.incompleteData.PrTime },
          //         { str_colName: 'InstrumentID', value: strInstrumentId },
          //         { str_colName: 'Side', value: sideVal },
          //         { str_colName: 'MinPer', value: minPer },
          //         { str_colName: 'MaxPer', value: maxPer },
          //         { str_colName: 'Min', value: minVal },
          //         { str_colName: 'Max', value: maxVal },
          //         { str_colName: 'Avg', value: avgVal },
          //         { str_colName: 'TestResult', value: remark },
          //         { str_colName: 'UserID', value: resultdata.incompleteData.UserId },
          //         { str_colName: 'UserName', value: resultdata.incompleteData.UserName },

          //     ]
          // }
          let detailResult = objInsertDetailData;
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }
        else {
          masterSrNo = resultData[0][0].SrNo;
          const objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: resultdata.incompleteData.PrTime,
            InstrumentID: strInstrumentId,
            Side: sideVal,
            MinPer: minPer,
            MaxPer: maxPer,
            Min: minVal,
            Max: maxVal,
            Avg: avgVal,
            TestResult: remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,
          })
          //  {
          //     str_tableName: detailTable,
          //     data: [
          //         { str_colName: 'RepSerNo', value: masterSrNo },
          //         { str_colName: 'RecSeqNo', value: recSeqNo },
          //         { str_colName: 'Date', value: resultdata.incompleteData.PrDate },
          //         { str_colName: 'Time', value: resultdata.incompleteData.PrTime },
          //         { str_colName: 'InstrumentID', value: strInstrumentId },
          //         { str_colName: 'Side', value: sideVal },
          //         { str_colName: 'MinPer', value: minPer },
          //         { str_colName: 'MaxPer', value: maxPer },
          //         { str_colName: 'Min', value: minVal },
          //         { str_colName: 'Max', value: maxVal },
          //         { str_colName: 'Avg', value: avgVal },
          //         { str_colName: 'TestResult', value: remark },
          //         { str_colName: 'UserID', value: resultdata.incompleteData.UserId },
          //         { str_colName: 'UserName', value: resultdata.incompleteData.UserName },

          //     ]
          // }
          let detailResult = objInsertDetailData;
          Object.assign(responseObj, { status: 'success' })
          return responseObj;
        }

      }

    }
    catch (err) {
      console.log(err);
      return err;
    }
  }


  /**
   * 
   * @param {*} masterData 
   * @param {*} idsNo 
   * @param {*} tempLodData 
   * @param {*} tempUserObject 
   * @description  `saveBatchSummaryLOD` Save the batch Summary Data for `LOD`
   */
  async saveBatchSummaryLOD(masterData, idsNo, tempLodData, tempUserObject) {
    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
    var selectedIds = idsNo;
    // if (IPQCObject != undefined) {
    //     selectedIds = IPQCObject.selectedIds;
    // } else {
    //     selectedIds = idsNo;
    // }
    let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == idsNo);
    var cubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == selectedIds).cubicalData;
    if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
      let sideVal;
      if (cubicalObj.Sys_RotaryType == 'Double') {
        sideVal = "LEFT";
      }
      else {
        sideVal = "NA";
      }
      let checkSideMasterTable;
      if (cubicalObj.Sys_RotaryType != 'Double') {
        checkSideMasterTable = 'NA';
      } else {
        checkSideMasterTable = 'LEFT';
      }
      const checkMasterObj = await models.tbl_batchsummary_master16.findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          Side: checkSideMasterTable,
          CubType: cubicalObj.Sys_CubType,
          BatchNo: cubicalObj.Sys_Batch,

        }
      })

      var masterSrNo;
      let resultData = checkMasterObj;
      let incompleteData = {
        BFGCode: cubicalObj.Sys_BFGCode,
        ProductName: cubicalObj.Sys_ProductName,
        PVersion: cubicalObj.Sys_PVersion,
        Version: cubicalObj.Sys_Version,
        BatchNo: cubicalObj.Sys_Batch
      }
      let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_master16', 'tbl_batchsummary_detail16', incompleteData);
      let ProdRes = await proObj.productData(cubicalObj);
      let minTemp;
      let maxTemp;
      if (cubicalObj.Sys_Area == 'Effervescent Granulation' || cubicalObj.Sys_Area == 'Granulation') {
        minTemp = ProdRes[1]['Param1_Low'];
        maxTemp = ProdRes[1]['Param1_Upp'];
        switch (tempMenuLOD.selectedLOD) {
          case 'GRANULES DRY ':
            minTemp = ProdRes[1]['Param1_Low'];
            maxTemp = ProdRes[1]['Param1_Upp'];
            break;
          case 'GRANULES LUB':
            minTemp = ProdRes[1]['Param2_Low'];
            maxTemp = ProdRes[1]['Param2_Upp'];
            break;
          case 'LAYER1 DRY':
            minTemp = ProdRes[1]['Param3_Low'];
            maxTemp = ProdRes[1]['Param3_Upp'];
            break;
          case 'LAYER1 LUB':
            minTemp = ProdRes[1]['Param4_Low'];
            maxTemp = ProdRes[1]['Param4_Upp'];
            break;
          case 'LAYER2 DRY':
            minTemp = ProdRes[1]['Param5_Low'];
            maxTemp = ProdRes[1]['Param5_Upp'];
            break;
          case 'LAYER2 LUB':
            minTemp = ProdRes[1]['Param6_Low'];
            maxTemp = ProdRes[1]['Param6_Upp'];
            break;
        }
      } else {
        minTemp = ProdRes[1]['Param16_T1Neg'];
        maxTemp = ProdRes[1]['Param16_T1Pos'];
      }
      var now = new Date();
      let average = (((tempLodData.IniWt - tempLodData.finalWt) / tempLodData.IniWt) * 100);
      let result = 'Complies';
      if ((minTemp < average) && (average < maxTemp)) {
        result = 'Complies';
      } else {
        result = 'Not Complies';
      }
      if (resultData[0][0].SrNo == null) {
        let masterDataInsert = await models.tbl_batchsummary_master16.create({

          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          PrdType: 1,
          CubType: cubicalObj.Sys_CubType,
          BatchNo: cubicalObj.Sys_Batch,
          Stage: cubicalObj.Sys_Stage,
          Dept: cubicalObj.Sys_dept,
          LODLayer: 'NA',
          Side: sideVal,
          BatchCompleted: 0,
          IsArchived: 0,
          LimitOn: 0,
          Area: cubicalObj.Sys_Area,
          GenericName: cubicalObj.Sys_GenericName,
          BMRNo: cubicalObj.Sys_BMRNo,
          BatchSize: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
          ReportType: cubicalObj.Sys_RptType,

        })

        let saveBatchSumm = masterDataInsert;
        masterSrNo = saveBatchSumm[0].insertId;

        let detailDataInsert = await models.tbl_batchsummary_detail16.create({
          RepSerNo: masterSrNo,
          RecSeqNo: recSeqNo,
          Date: moment().format('YYYY-MM-DD'),
          Time: moment().format('HH:mm:ss'),
          InstrumentID: cubicalObj.Sys_MoistID,
          Side: 'NA',
          Min: minTemp,
          Max: maxTemp,
          Avg: average,
          TestResult: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          LODStage: cubicalObj.Sys_MAStage
        })

      } else {
        masterSrNo = resultData[0][0].SrNo;
        let detailDataInsert = await models.tbl_batchsummary_detail16.create({
          RepSerNo: masterSrNo,
          RecSeqNo: recSeqNo,
          Date: moment().format('YYYY-MM-DD'),
          Time: moment().format('HH:mm:ss'),
          InstrumentID: cubicalObj.Sys_MoistID,
          Side: 'NA',
          Min: minTemp,
          Max: maxTemp,
          Avg: average,
          TestResult: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          LODStage: cubicalObj.Sys_MAStage
        })

      }
      return 'success';
    } else {
      return 'success';
    }
  }

  async calculate_roundoff_value(actualWt, unit) {
    let ActualWt1 = actualWt
    let Actual_unit = unit
    if (Actual_unit != undefined) {
      if (Actual_unit == 'mg') {
        ActualWt1 = math.round(ActualWt1, 1)
        return ActualWt1
      } if (Actual_unit == 'g' || Actual_unit == 'gm') {
        ActualWt1 = this.math.round(ActualWt1, 4)
        return ActualWt1
      }
    }
  }




  async saveBatchDataHardness(masterData, DetailData, DsNo) {
    try {
      var now = new Date();
      let responseObj = {};
      var selectedIds = DsNo;
      // console.log(masterData, DetailData);
      var cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == DsNo).cubicalData;
      var menuDetail = globalData.arrSelectedMenu.find(k => k.DsNo == DsNo).selectedProductDetail;
      let tempLimObjHardness = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0].Hardness;
      let tempLimObjThickness = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0].Thickness;
      let tempLimObjlength = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Length")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Length")[0].Length;
      let tempLimObjDiameter = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0].Diameter;
      let tempLimObjBreadth = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0].Breadth;
      let sideVal = "NA";
      if (masterData.Side == 'LHS') {
        sideVal = "LHS";
      } else if (masterData.Side == 'RHS') {
        sideVal = "RHS";
      } else {
        sideVal = "NA";
      }
      let checkSideMasterTable;
      if (masterData.Side == 'NA') {
        checkSideMasterTable = masterData.Side;
      } else {
        // checkSideMasterTable = 'LHS';
        checkSideMasterTable = 'LEFT';
      }
      let sumHT = 0;
      let sumT = 0;
      let sumDLB = 0;
      let sumDiam = 0;
      let arrHTDetail = [];
      let arrTDetail = [];
      let arrDLBDetail = [];
      let arrDiamDetail = [];
      let outFlagHTD = 0;
      let outFlagThickness = 0;
      let outFlagDOLOBO = 0;
      let outFlagDiam = 0;
      let remark;
      var dp = 2;
      let avgHrd = 1;
      let hardDp = 0;
      let maxHTDLimit = parseFloat(tempLimObjHardness.T1Pos);
      let minHTDLimit = parseFloat(tempLimObjHardness.T1Neg);
      if (tempLimObjThickness == undefined) {
        var maxTLimit = 0;
        var minTLimit = 0;
      } else {
        var maxTLimit = parseFloat(tempLimObjThickness.T2Pos);
        var minTLimit = parseFloat(tempLimObjThickness.T2Neg);
      }
      // if(masterData.NomDOLOBO != 0) {
      if (masterData.ColHeadDOLOBO == 'NA') {
        var maxDLBLimit = 0;
        var minDLBLimit = 0;
      } else {
        if (tempLimObjlength == undefined && tempLimObjBreadth == undefined && tempLimObjDiameter == undefined) {
          var maxDLBLimit = 0;
          var minDLBLimit = 0;
        } else {
          // tempLimObjlength == undefined ? tempLimObjBreadth == undefined ?  tempLimObjBreadth : tempLimObjDiameter ;
          let a = tempLimObjlength != undefined ? tempLimObjlength : tempLimObjBreadth != undefined ? tempLimObjBreadth : tempLimObjDiameter;
          var maxDLBLimit = parseFloat(formulaFun.upperLimit(a));
          var minDLBLimit = parseFloat(formulaFun.lowerLimit(a));
        }
      }


      let count = DetailData.length;
      for (var i = 0; i < DetailData.length; i++) {
        if (Number(DetailData[i].DataValueHard) != 0) {
          var dataValHard = parseFloat(DetailData[i].DataValueHard);
          if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
            outFlagHTD = outFlagHTD + 1;
          }
          arrHTDetail.push(dataValHard);
        }

        if (DetailData[i].DataValueThick != "NA") {
          var dataValThick = parseFloat(DetailData[i].DataValueThick);
          if (minTLimit != 0 && maxTLimit != 0) {
            if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
              outFlagThickness = outFlagThickness + 1;
            }
          }
          arrTDetail.push(dataValThick);
        }

        if (DetailData[i].DataValueBL != "NA") {
          var dataValDLB = parseFloat(DetailData[i].DataValueBL);
          if (minDLBLimit != 0 && maxDLBLimit != 0) {
            if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
              outFlagDOLOBO = outFlagDOLOBO + 1;
            }
          }
          arrDLBDetail.push(dataValDLB);
        }

        if (DetailData[i].DataValueDiam != "NA") {
          var dataValDiam = parseFloat(DetailData[i].DataValueDiam);
          if (minDLBLimit != 0 && maxDLBLimit != 0) {
            if ((minDLBLimit > dataValDiam) || (dataValDiam > maxDLBLimit)) {
              outFlagDiam = outFlagDiam + 1;
            }
          }
          arrDiamDetail.push(dataValDiam);
        }
      }

      if (masterData.NomDOLOBO != 0) {
        if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0 || outFlagDiam != 0) {
          remark = 'Not Complies';
        } else {
          remark = 'Complies';
        }
      } else {
        if (outFlagHTD != 0 || outFlagThickness != 0) {
          remark = 'Not Complies'
        } else {
          remark = 'Complies';
        }
      }

      for (var j = 0; j < arrHTDetail.length; j++) {
        sumHT = sumHT + parseFloat(arrHTDetail[j]);
      }
      for (var k = 0; k < arrTDetail.length; k++) {
        sumT = sumT + parseFloat(arrTDetail[k]);
      }
      for (var l = 0; l < arrDLBDetail.length; l++) {
        sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
      }
      for (var d = 0; d < arrDiamDetail.length; d++) {
        sumDiam = sumDiam + parseFloat(arrDiamDetail[d]);
      }
      var MaxHard = Math.max(...arrHTDetail);
      var MinHard = Math.min(...arrHTDetail);
      var avgHard = (sumHT / count);
      var MaxThick = (arrTDetail.length > 0) ? Math.max(...arrTDetail) : "NA";
      var MinThick = (arrTDetail.length > 0) ? Math.min(...arrTDetail) : "NA";
      var AvgThick = (arrTDetail.length > 0) ? (sumT / count) : "NA";
      var MaxDLB = (arrDLBDetail.length > 0) ? Math.max(...arrDLBDetail) : "NA";
      var MinDLB = (arrDLBDetail.length > 0) ? Math.min(...arrDLBDetail) : "NA";
      var AvgDLB = (arrDLBDetail.length > 0) ? (sumDLB / count) : "NA";
      var MaxDiam = (arrDiamDetail.length > 0) ? Math.max(...arrDiamDetail) : "NA";
      var MinDiam = (arrDiamDetail.length > 0) ? Math.min(...arrDiamDetail) : "NA";
      var AvgDiam = (arrDiamDetail.length > 0) ? (sumDiam / count) : "NA";

      MaxDiam = MaxDiam != 'NA' && MaxDiam != 0 ? MaxDiam : 'NA'
      MinDiam = MinDiam != 'NA' && MinDiam != 0 ? MinDiam : 'NA'
      AvgDiam = AvgDiam != 'NA' && AvgDiam != 0 ? AvgDiam : 'NA'
      MaxDLB = MaxDLB != 'NA' && MaxDLB != 0 ? MaxDLB : 'NA'
      MinDLB = MinDLB != 'NA' && MinDLB != 0 ? MinDLB : 'NA'
      AvgDLB = AvgDLB != 'NA' && AvgDLB != 0 ? AvgDLB : 'NA'


      if (((cubicalObj.Sys_RptType == 0) &&
        cubicalObj.Sys_BatchReuse == 0 &&
        (cubicalObj.Sys_Validation == 0) &&
        (cubicalObj.Sys_CubType == 'Compression') ||
        (cubicalObj.Sys_CubType == 'Coating' && cubicalObj.Sys_IPQCType != "Compression"))) {
        // let res = await proObj.productData(cubicalObj);
        // var paramNom = `Param7_Nom`;
        // var limitNo = `Param7_LimitOn`;
        // var nom = parseFloat(res[1][paramNom]);
        // var limit = res[1][limitNo].readUIntLE();
        // if(masterData.ColHeadDOLOBO == 'Le')

        // const checkMasterObj = {
        //     str_tableName: 'tbl_batchsummary_master_hdlb',
        //     data: 'MAX(RepSerNo) AS SrNo',
        //     condition: [
        //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
        //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
        //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
        //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
        //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
        //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
        //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
        //     ]
        // }

        // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
        // let resultData = await database.select(checkMasterObj);
        var masterSrNo;
        // const checkMasterObj = await models['tbl_batchsummary_masterhtd'].findAll({
        //   attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
        //   where: {
        //     BFGCode: masterData.BFGCode,
        //     ProductName: masterData.ProductName,
        //     PVersion: masterData.PVersion,
        //     Version: masterData.Version,
        //     Side: checkSideMasterTable,
        //     CubicleType: cubicalObj.Sys_CubType,
        //     BatchNo: masterData.BatchNo,
        //   }
        // })
        // let resultData = checkMasterObj;

        // let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_masterhtd', 'tbl_batchsummary_detailhtd', masterData);
        // if (resultData[0].SrNo == null) {
        //   // let masterDataInsert = {
        //   //     str_tableName: 'tbl_batchsummary_master_hdlb',
        //   //     data: [
        //   //         { str_colName: 'BFGCode', value: masterData.BFGCode },
        //   //         { str_colName: 'ProductName', value: masterData.ProductName },
        //   //         { str_colName: 'PVersion', value: masterData.PVersion },
        //   //         { str_colName: 'Version', value: masterData.Version },
        //   //         { str_colName: 'PrdType', value: 1 },
        //   //         { str_colName: 'CubType', value: masterData.CubicleType },
        //   //         { str_colName: 'BatchNo', value: masterData.BatchNo },
        //   //         { str_colName: 'Stage', value: masterData.Stage },
        //   //         { str_colName: 'Dept', value: cubicalObj.Sys_dept },
        //   //         { str_colName: 'NomHard', value: masterData.NomHard },
        //   //         { str_colName: 'LwrHard', value: masterData.NegTolHard },
        //   //         { str_colName: 'UppHard', value: masterData.PosTolHard },
        //   //         { str_colName: 'UnitHard', value: masterData.Unit },
        //   //         { str_colName: 'NomThick', value: masterData.NomThick },
        //   //         { str_colName: 'LwrThick', value: masterData.NegTolThick },
        //   //         { str_colName: 'UppThick', value: masterData.PosTolThick },
        //   //         { str_colName: 'NomDLB', value: masterData.NomDOLOBO },
        //   //         { str_colName: 'LwrDLB', value: masterData.NegTolDOLOBO },
        //   //         { str_colName: 'UppDLB', value: masterData.PosTolDOLOBO },
        //   //         { str_colName: 'DLBParamName', value: masterData.ColHeadDOLOBO },
        //   //         { str_colName: 'Side', value: sideVal },
        //   //         { str_colName: 'BatchCompleted', value: masterData.BatchComplete[0] },
        //   //         { str_colName: 'IsArchived', value: masterData.IsArchived[0] },
        //   //         { str_colName: 'LimitOn', value: 0 }
        //   //     ]
        //   // }
        //   // let saveBatchSumm = await database.save(masterDataInsert);
        //   // masterSrNo = saveBatchSumm[0].insertId;

        //   // const masterDataInsert = await models['tbl_batchsummary_masterhtd'].create({
        //   //   Area: masterData.Area,
        //   //   ReportType: masterData.ReportType,
        //   //   CubicalNo: masterData.CubicalNo,
        //   //   CubicleType: masterData.CubicleType,
        //   //   BatchSize: masterData.BatchSize,
        //   //   BLName: masterData.BLName,
        //   //   TolNegHard: masterData.T3NegTolHard,
        //   //   TolPosHard: masterData.T3PosTolHard,
        //   //   TolNegThick: masterData.T3NegTolThick,
        //   //   TolPosThick: masterData.T3PosTolThick,
        //   //   TolNegDiam: masterData.T3NegTolDiam,
        //   //   TolPosDiam: masterData.T3PosTolDiam,
        //   //   TolNegBL: masterData.T3NegTolBL,
        //   //   TolPosBL: masterData.T3PosTolBL,
        //   //   TolNegActualHard: masterData.T3NegTolActualHard,
        //   //   TolPosActualHard: masterData.T3PosTolActualHard,
        //   //   TolNegActualThick: masterData.T3NegTolActualThick,
        //   //   TolPosActualThick: masterData.T3PosTolActualThick,
        //   //   TolPosActualDiam: masterData.T3NegTolActualDiam,
        //   //   TolNegActualDiam: masterData.T3PosTolActualDiam,
        //   //   TolNegActualBL: masterData.T3NegTolActualBL,
        //   //   TolPosActualBL: masterData.T3PosTolActualBL,

        //   //   NomHard: masterData.NomHard,
        //   //   NomThick: masterData.NomThick,
        //   //   NomDiam: masterData.NomDiam,
        //   //   NomBL: masterData.NomBL,

        //   //   StartDateHard: moment().format("YYYY-MM-DD"),
        //   //   EndDateHard: moment().format("YYYY-MM-DD"),
        //   //   StartDateThick: moment().format("YYYY-MM-DD"),
        //   //   EndDateThick: moment().format("YYYY-MM-DD"),
        //   //   StartDateDiam: moment().format("YYYY-MM-DD"),
        //   //   EndDateDiam: moment().format("YYYY-MM-DD"),
        //   //   StartDateBL: moment().format("YYYY-MM-DD"),
        //   //   EndDateBL: moment().format("YYYY-MM-DD"),
        //   //   Unit: masterData.Unit,
        //   //   BFGCode: masterData.BFGCode,
        //   //   ProductName: masterData.ProductName,
        //   //   PVersion: masterData.PVersion,
        //   //   Version: masterData.Version,
        //   //   PrdType: 1,
        //   //   CubType: masterData.CubicleType,
        //   //   BatchNo: masterData.BatchNo,
        //   //   Stage: masterData.Stage,
        //   //   Dept: cubicalObj.Sys_dept,
        //   //   NomHard: masterData.NomHard,
        //   //   LwrHard: masterData.NegTolHard,
        //   //   UppHard: masterData.PosTolHard,
        //   //   UnitHard: masterData.Unit,
        //   //   NomThick: masterData.NomThick,
        //   //   LwrThick: masterData.NegTolThick,
        //   //   UppThick: masterData.PosTolThick,
        //   //   NomDLB: masterData.NomDOLOBO,
        //   //   LwrDLB: masterData.NegTolDOLOBO,
        //   //   UppDLB: masterData.PosTolDOLOBO,
        //   //   // DLBParamName: masterData.ColHeadDOLOBO,
        //   //   Remark: remark,
        //   //   Side: sideVal,
        //   //   BatchCompleted: 0,
        //   //   IsArchived: 0,
        //   //   LimitOn: 0
        //   // });

        //   // const objInsertDetailData = await models['tbl_batchsummary_detailhtd'].create({
        //   //     RepSerNo: masterSrNo,
        //   //     RecSeqNo: recSeqNo,
        //   //     Date: masterData.PrDate,
        //   //     Time: masterData.PrTime,
        //   //     InstrumentID: masterData.HardnessID,
        //   //     Side: sideVal,
        //   //     MinHard: MinHard,
        //   //     MaxHard: MaxHard,
        //   //     AvgHard: avgHard,
        //   //     MinThick: MinThick,
        //   //     MaxThick: MaxThick,
        //   //     AvgThick: AvgThick,
        //   //     MinDiam: MinDLB,
        //   //     MaxDiam: MaxDLB,
        //   //     AvgDiam: AvgDLB,
        //   //     MinBL: MinDLB,
        //   //     MaxBL: MaxDLB,
        //   //     AvgBL: AvgDLB,
        //   //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
        //   //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
        //   //     TestResult: remark,
        //   //     UserID: masterData.UserId,
        //   //     UserName: masterData.UserName,
        //   // });

        //   // const objInsertDetailData = {
        //   //     str_tableName: 'tbl_batchsummary_detail_hdlb',
        //   //     data: [
        //   //         { str_colName: 'RepSerNo', value: masterSrNo },
        //   //         { str_colName: 'RecSeqNo', value: recSeqNo },
        //   //         { str_colName: 'Date', value: masterData.PrDate },
        //   //         { str_colName: 'Time', value: masterData.PrTime },
        //   //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
        //   //         { str_colName: 'Side', value: sideVal },
        //   //         { str_colName: 'MinHard', value: MinHard },
        //   //         { str_colName: 'MaxHard', value: MaxHard },
        //   //         { str_colName: 'AvgHard', value: avgHard },
        //   //         { str_colName: 'MinThick', value: MinThick },
        //   //         { str_colName: 'MaxThick', value: MaxThick },
        //   //         { str_colName: 'AvgThick', value: AvgThick },
        //   //         { str_colName: 'MinDLB', value: MinDLB },
        //   //         { str_colName: 'MaxDLB', value: MaxDLB },
        //   //         { str_colName: 'AvgDLB', value: AvgDLB },
        //   //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
        //   //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
        //   //         { str_colName: 'TestResult', value: remark },
        //   //         { str_colName: 'UserID', value: masterData.UserId },
        //   //         { str_colName: 'UserName', value: masterData.UserName },

        //   //     ]
        //   // }
        //   // //console.log(objInsertDetailData);
        //   // let detailResult1 = await database.save(objInsertDetailData);
        //   Object.assign(responseObj, { status: 'success' })
        //   return responseObj;

        // } else {
        //     if (tempLimObjlength == undefined && tempLimObjBreadth == undefined && tempLimObjDiameter == undefined) {
        //         var maxDLBLimit = 0;
        //         var minDLBLimit = 0;
        //     } else {
        //         // tempLimObjlength == undefined ? tempLimObjBreadth == undefined ?  tempLimObjBreadth : tempLimObjDiameter ;
        //         let a = tempLimObjlength != undefined ? tempLimObjlength : tempLimObjBreadth != undefined ? tempLimObjBreadth : tempLimObjDiameter;
        //         var maxDLBLimit = parseFloat(formulaFun.upperLimit(a));
        //         var minDLBLimit = parseFloat(formulaFun.lowerLimit(a));
        //     }
        // }


        // let count = DetailData.length;
        // for (var i = 0; i < DetailData.length; i++) {
        //   if (Number(DetailData[i].DataValueHard) != 0) {
        //     var dataValHard = parseFloat(DetailData[i].DataValueHard);
        //     if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
        //       outFlagHTD = outFlagHTD + 1;
        //     }
        //     arrHTDetail.push(dataValHard);
        //   }

        //   if (Number(DetailData[i].DataValueThick) != 0) {
        //     var dataValThick = parseFloat(DetailData[i].DataValueThick);
        //     if (minTLimit != 0 && maxTLimit != 0) {
        //       if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
        //         outFlagThickness = outFlagThickness + 1;
        //       }
        //     }
        //     arrTDetail.push(dataValThick);
        //   }

        //   if (Number(DetailData[i].DataValueBL) != 0) {
        //     var dataValDLB = parseFloat(DetailData[i].DataValueBL);
        //     if (minDLBLimit != 0 && maxDLBLimit != 0) {
        //       if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
        //         outFlagDOLOBO = outFlagDOLOBO + 1;
        //       }
        //     }
        //     arrDLBDetail.push(dataValDLB);
        //   }

        //   if (Number(DetailData[i].DataValueDiam) != 0) {
        //     var dataValDiam = parseFloat(DetailData[i].DataValueDiam);
        //     if (minDLBLimit != 0 && maxDLBLimit != 0) {
        //       if ((minDLBLimit > dataValDiam) || (dataValDiam > maxDLBLimit)) {
        //         outFlagDOLOBO = outFlagDOLOBO + 1;
        //       }
        //     }
        //     arrDiamDetail.push(dataValDiam);
        //   }
        // }

        // if (masterData.NomDOLOBO != 0) {
        //   if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0) {
        //     remark = 'Not Complies';
        //   } else {
        //     remark = 'Complies';
        //   }
        // } else {
        //   if (outFlagHTD != 0 || outFlagThickness != 0) {
        //     remark = 'Not Complies'
        //   } else {
        //     remark = 'Complies';
        //   }
        // }

        // for (var j = 0; j < arrHTDetail.length; j++) {
        //   sumHT = sumHT + parseFloat(arrHTDetail[j]);
        // }
        // for (var k = 0; k < arrTDetail.length; k++) {
        //   sumT = sumT + parseFloat(arrTDetail[k]);
        // }
        // for (var l = 0; l < arrDLBDetail.length; l++) {
        //   sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
        // }
        // for (var d = 0; d < arrDiamDetail.length; d++) {
        //   sumDiam = sumDiam + parseFloat(arrDiamDetail[d]);
        // }

        // var MaxHard = (arrHTDetail.length > 0) ? Math.max(...arrHTDetail) : 0;
        // var MinHard = (arrHTDetail.length > 0) ? Math.min(...arrHTDetail) : 0;
        // var avgHard = (sumHT / count);
        // var MaxThick = (arrTDetail.length > 0) ? Math.max(...arrTDetail) : 0;
        // var MinThick = (arrTDetail.length > 0) ? Math.min(...arrTDetail) : 0;
        // var AvgThick = (sumT / count);
        // var MaxDLB = (arrDLBDetail.length > 0) ? Math.max(...arrDLBDetail) : 0;
        // var MinDLB = (arrDLBDetail.length > 0) ? Math.min(...arrDLBDetail) : 0;
        // var AvgDLB = (sumDLB / count);
        // var MaxDiam = (arrDiamDetail.length > 0) ? Math.max(...arrDiamDetail) : 0;
        // var MinDiam = (arrDiamDetail.length > 0) ? Math.min(...arrDiamDetail) : 0;
        // var AvgDiam = (sumDiam / count);

        if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_BatchReuse == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating' && cubicalObj.Sys_IPQCType != "Compression"))) {
          // let res = await proObj.productData(cubicalObj);
          // var paramNom = `Param7_Nom`;
          // var limitNo = `Param7_LimitOn`;
          // var nom = parseFloat(res[1][paramNom]);
          // var limit = res[1][limitNo].readUIntLE();
          // if(masterData.ColHeadDOLOBO == 'Le')

          // const checkMasterObj = {
          //     str_tableName: 'tbl_batchsummary_master_hdlb',
          //     data: 'MAX(RepSerNo) AS SrNo',
          //     condition: [
          //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
          //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
          //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
          //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
          //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
          //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
          //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
          //     ]
          // }

          // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
          // let resultData = await database.select(checkMasterObj);
          var masterSrNo;
          const checkMasterObj = await models['tbl_batchsummary_masterhtd'].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
            where: {
              // BFGCode: masterData.BFGCode,
              MPN_Code: masterData.MPN_Code,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          // var masterHard = await models.tbl_batchsummary_master7.findOne({
          //   where: {
          //     BFGCode: masterData.BFGCode,
          //     ProductName: masterData.ProductName,
          //     PVersion: masterData.PVersion,
          //     Version: masterData.Version,
          //     Side: checkSideMasterTable,
          //     CubicleType: cubicalObj.Sys_CubType,
          //     BatchNo: masterData.BatchNo,
          //   }
          // })

          let resultData = checkMasterObj;

          let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_masterhtd', 'tbl_batchsummary_detailhtd', masterData);



          if (resultData[0].SrNo == null) {
            // let masterDataInsert = {
            //     str_tableName: 'tbl_batchsummary_master_hdlb',
            //     data: [
            //         { str_colName: 'BFGCode', value: masterData.BFGCode },
            //         { str_colName: 'ProductName', value: masterData.ProductName },
            //         { str_colName: 'PVersion', value: masterData.PVersion },
            //         { str_colName: 'Version', value: masterData.Version },
            //         { str_colName: 'PrdType', value: 1 },
            //         { str_colName: 'CubType', value: masterData.CubicleType },
            //         { str_colName: 'BatchNo', value: masterData.BatchNo },
            //         { str_colName: 'Stage', value: masterData.Stage },
            //         { str_colName: 'Dept', value: cubicalObj.Sys_dept },
            //         { str_colName: 'NomHard', value: masterData.NomHard },
            //         { str_colName: 'LwrHard', value: masterData.NegTolHard },
            //         { str_colName: 'UppHard', value: masterData.PosTolHard },
            //         { str_colName: 'UnitHard', value: masterData.Unit },
            //         { str_colName: 'NomThick', value: masterData.NomThick },
            //         { str_colName: 'LwrThick', value: masterData.NegTolThick },
            //         { str_colName: 'UppThick', value: masterData.PosTolThick },
            //         { str_colName: 'NomDLB', value: masterData.NomDOLOBO },
            //         { str_colName: 'LwrDLB', value: masterData.NegTolDOLOBO },
            //         { str_colName: 'UppDLB', value: masterData.PosTolDOLOBO },
            //         { str_colName: 'DLBParamName', value: masterData.ColHeadDOLOBO },
            //         { str_colName: 'Side', value: sideVal },
            //         { str_colName: 'BatchCompleted', value: masterData.BatchComplete[0] },
            //         { str_colName: 'IsArchived', value: masterData.IsArchived[0] },
            //         { str_colName: 'LimitOn', value: 0 }
            //     ]
            // }
            // let saveBatchSumm = await database.save(masterDataInsert);
            // masterSrNo = saveBatchSumm[0].insertId;

            const machinePunches = await models['tbl_machine'].findOne(
              {
                attributes: ['Machine_Punches']
              }, {
              where: {
                Machine_ID: masterData.MachineCode
              }
            }
            )

            const masterDataInsert = await models['tbl_batchsummary_masterhtd'].create({
              Area: masterData.Area,
              ReportType: masterData.ReportType,
              CubicalNo: masterData.CubicalNo,
              CubicleType: masterData.CubicleType,
              BatchSize: masterData.BatchSize,
              BLName: masterData.BLName,
              TolNegHard: masterData.T2NegTolHard,
              TolPosHard: masterData.T2PosTolHard,
              TolNegThick: masterData.T2NegTolThick,
              TolPosThick: masterData.T2PosTolThick,
              TolNegDiam: masterData.T2NegTolDiam,
              TolPosDiam: masterData.T2PosTolDiam,
              TolNegBL: masterData.T2NegTolBL,
              TolPosBL: masterData.T2PosTolBL,
              TolNegActualHard: masterData.T1NegTolActualHard,
              TolPosActualHard: masterData.T1PosTolActualHard,
              TolNegActualThick: masterData.T2NegTolActualThick,
              TolPosActualThick: masterData.T2PosTolActualThick,
              TolPosActualDiam: masterData.T2NegTolActualDiam,
              TolNegActualDiam: masterData.T2PosTolActualDiam,
              TolNegActualBL: masterData.T2NegTolActualBL,
              TolPosActualBL: masterData.T2PosTolActualBL,

              NomHard: masterData.NomHard,
              NomThick: masterData.NomThick,
              NomDiam: masterData.NomDiam,
              NomBL: masterData.NomBL,

              MinValueHard: (remark == "Not Complies") ? "NA" : masterData.MinWeightHard,
              MaxValueHard: (remark == "Not Complies") ? "NA" : masterData.MaxWeightHard,
              AvgValueHard: (remark == "Not Complies") ? "NA" : masterData.AvgHard,

              MinValueThick: (remark == "Not Complies") ? "NA" : masterData.MinWeightThick,
              MaxValueThick: (remark == "Not Complies") ? "NA" : masterData.MaxWeightThick,
              AvgValueThick: (remark == "Not Complies") ? "NA" : masterData.AvgThick,

              MinValueDiam: (remark == "Not Complies" || masterData.MinWeightDiam == 0) ? "NA" : masterData.MinWeightDiam,
              MaxValueDiam: (remark == "Not Complies" || masterData.MaxWeightDiam == 0) ? "NA" : masterData.MaxWeightDiam,
              AvgValueDiam: (remark == "Not Complies" || masterData.AvgDiam == 0) ? "NA" : masterData.AvgDiam,

              MinValueBL: (remark == "Not Complies" || masterData.MinWeightBL == 0) ? "NA" : masterData.MinWeightBL,
              MaxValueBL: (remark == "Not Complies" || masterData.MaxWeightBL == 0) ? "NA" : masterData.MaxWeightBL,
              AvgValueBL: (remark == "Not Complies" || masterData.AvgBL == 0) ? "NA" : masterData.AvgBL,

              StartDateHard: moment().format("YYYY-MM-DD"),
              EndDateHard: moment().format("YYYY-MM-DD"),
              StartDateThick: moment().format("YYYY-MM-DD"),
              EndDateThick: moment().format("YYYY-MM-DD"),
              StartDateDiam: moment().format("YYYY-MM-DD"),
              EndDateDiam: moment().format("YYYY-MM-DD"),
              StartDateBL: moment().format("YYYY-MM-DD"),
              EndDateBL: moment().format("YYYY-MM-DD"),
              Unit: masterData.Unit,
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              PrdType: 1,
              CubType: masterData.CubicleType,
              BatchNo: masterData.BatchNo,
              Stage: masterData.Stage,
              Department: cubicalObj.Sys_dept,
              // NomHard: masterData.NomHard,
              // LwrHard: masterData.NegTolHard,
              // UppHard: masterData.PosTolHard,
              // UnitHard: masterData.Unit,
              // LwrThick: masterData.NegTolThick,
              // UppThick: masterData.PosTolThick,
              // NomDLB: masterData.NomDOLOBO,
              // LwrDLB: masterData.NegTolDOLOBO,
              // UppDLB: masterData.PosTolDOLOBO,

              // DLBParamName: masterData.ColHeadDOLOBO,
              Remark: remark,
              Side: checkSideMasterTable,
              BatchCompleted: 0,
              IsArchived: 0,
              LimitOn: 0,
              MPN_Code: masterData.MPN_Code,
              BatchStartTime: date.format(new Date(), "HH:mm:ss"),
              BatchEndTime: date.format(new Date(), "HH:mm:ss"),
              MachineCode: masterData.MachineCode,
              NoOfStations: machinePunches.Machine_Punches
            });

            masterSrNo = masterDataInsert._previousDataValues.RepSerNo;





            // if (masterHard === null) {
            //   masterHard = await models.tbl_batchsummary_master7.create({
            //     Area: masterData.Area,
            //     ReportType: masterData.ReportType,
            //     CubicalNo: masterData.CubicalNo,
            //     CubicleType: masterData.CubicleType,
            //     BatchSize: masterData.BatchSize,
            //     Tol1Neg: masterData.T1NegTol,
            //     Tol1Pos: masterData.T1PosTol,
            //     Tol2Neg: masterData.T1NegTol,
            //     Tol2Pos: masterData.T1PosTol,
            //     StdLimit1: masterData.T1NegTol,
            //     StdLimit2: masterData.T1PosTol,
            //     Tol1NegActual: masterData.T1NegTol,
            //     Tol1PosActual: masterData.T1PosTol,
            //     MinValue: 'NA',
            //     MaxValue: 'NA',
            //     AvgValue: 'NA',
            //     StartDate: moment().format("YYYY-MM-DD"),
            //     EndDate: moment().format("YYYY-MM-DD"),
            //     DP: 3,
            //     NomHard: masterData.NomHard,
            //     NomThick: masterData.NomThick,
            //     NomDiam: masterData.NomDiam,
            //     NomBL: masterData.NomBL,
            //     MinValueHard: masterData.MinWeightHard,
            //     MaxValueHard: masterData.MaxWeightHard,
            //     AvgValueHard: masterData.AvgHard,
            //     MinValueThick: masterData.MinWeightThick,
            //     MaxValueThick: masterData.MaxWeightThick,
            //     AvgValueThick: masterData.AvgThick,
            //     MinValueDiam: masterData.MinWeightDiam,
            //     MaxValueDiam: masterData.MaxWeightDiam,
            //     AvgValueDiam: masterData.AvgDiam,
            //     MinValueBL: masterData.MinWeightBL,
            //     MaxValueBL: masterData.MaxWeightBL,
            //     AvgValueBL: masterData.AvgBL,
            //     StartDateHard: moment().format("YYYY-MM-DD"),
            //     EndDateHard: moment().format("YYYY-MM-DD"),
            //     StartDateThick: moment().format("YYYY-MM-DD"),
            //     EndDateThick: moment().format("YYYY-MM-DD"),
            //     StartDateDiam: moment().format("YYYY-MM-DD"),
            //     EndDateDiam: moment().format("YYYY-MM-DD"),
            //     StartDateBL: moment().format("YYYY-MM-DD"),
            //     EndDateBL: moment().format("YYYY-MM-DD"),
            //     Unit: masterData.Unit,
            //     BFGCode: masterData.BFGCode,
            //     ProductName: masterData.ProductName,
            //     PVersion: masterData.PVersion,
            //     Version: masterData.Version,
            //     PrdType: 1,
            //     CubType: masterData.CubicleType,
            //     BatchNo: masterData.BatchNo,
            //     Stage: masterData.Stage,
            //     Department: cubicalObj.Sys_dept,
            //     Nom: masterData.Nom,
            //     LwrHard: masterData.NegTolHard,
            //     UppHard: masterData.PosTolHard,
            //     UnitHard: masterData.Unit,
            //     NomThick: masterData.NomThick,
            //     LwrThick: masterData.NegTolThick,
            //     UppThick: masterData.PosTolThick,
            //     NomDLB: masterData.NomDOLOBO,
            //     LwrDLB: masterData.NegTolDOLOBO,
            //     UppDLB: masterData.PosTolDOLOBO,
            //     // DLBParamName: masterData.ColHeadDOLOBO,
            //     Remark: remark,
            //     Side: checkSideMasterTable,
            //     BatchCompleted: 0,
            //     IsArchived: 0,
            //     LimitOn: 0
            //   });
            // }
            // if (remark == 'Complies') {
            //   await models.tbl_batchsummary_master7.update({
            //     MinValue: minHardValue,
            //     MaxValue: maxHardValue,
            //     AvgValue: AvgHardValue,
            //     EndDate: moment().format("YYYY-MM-DD"),
            //   }, {
            //     where: {
            //       RepSerNo: masterHard.RepSerNo,
            //     }
            //   });
            // }
            // await models['tbl_batchsummary_detail7'].create({
            //   RepSerNo: masterHard.RepSerNo,
            //   RecSeqNo: recSeqNo,
            //   Date: masterData.PrDate,
            //   Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //   InstrumentID: masterData.HardnessID,
            //   Side: sideVal,
            //   // MinHard: MinHard,
            //   // MaxHard: MaxHard,
            //   // AvgHard: avgHard,
            //   Min: masterData.MinWeight,
            //   Max: masterData.MaxWeight,
            //   Avg: masterData.AvgWeight,
            //   // MinDiam: MinDLB,
            //   // MaxDiam: MaxDLB,
            //   // AvgDiam: AvgDLB,
            //   // MinBL: MinDLB,
            //   // MaxBL: MaxDLB,
            //   // AvgBL: AvgDLB,
            //   //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //   //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //   TestResult: remark,
            //   UserID: masterData.UserId,
            //   UserName: masterData.UserName,
            // });

            await models['tbl_batchsummary_detailhtd'].create({
              RepSerNo: masterSrNo,
              RecSeqNo: recSeqNo,
              Date: masterData.PrDate,
              Time: moment(masterData.PrTime).format("HH:mm:ss"),
              InstrumentID: masterData.HardnessID,
              Side: sideVal,
              MinHard: (Number(masterData.MinWeightHard) == 0) ? "NA" : masterData.MinWeightHard,
              MaxHard: (Number(masterData.MaxWeightHard) == 0) ? "NA" : masterData.MaxWeightHard,
              AvgHard: (Number(masterData.AvgHard) == 0) ? "NA" : masterData.AvgHard,
              MinThick: (MinThick == "NA") ? "NA" : mathj.round(Number(MinThick), dp).toFixed(dp),
              MaxThick: (MaxThick == "NA") ? "NA" : mathj.round(Number(MaxThick), dp).toFixed(dp),
              AvgThick: (AvgThick == "NA") ? "NA" : mathj.round(Number(AvgThick), dp).toFixed(dp),
              MinDiam: (MinDiam == "NA") ? "NA" : mathj.round(Number(MinDiam), dp).toFixed(dp),
              MaxDiam: (MaxDiam == "NA") ? "NA" : mathj.round(Number(MaxDiam), dp).toFixed(dp),
              AvgDiam: (AvgDiam == "NA") ? "NA" : mathj.round(Number(AvgDiam), dp).toFixed(dp),
              MinBL: (MinDLB == "NA") ? "NA" : mathj.round(Number(MinDLB), dp).toFixed(dp),
              MaxBL: (MaxDLB == "NA") ? "NA" : mathj.round(Number(MaxDLB), dp).toFixed(dp),
              AvgBL: (AvgDLB == "NA") ? "NA" : mathj.round(Number(AvgDLB), dp).toFixed(dp),
              // MinTimeDT': resultdata.incompleteData.T1PosTol ,
              // MaxTimeDT': resultdata.incompleteData.T2NegTol ,
              TestResult: remark,
              UserID: masterData.UserId,
              UserName: masterData.UserName,
              NoOfSample: masterData.Qty,
              SFOID: masterData.SFOID,
              Repetition: masterData.Repetition
            });

            // } if (Number(DetailData[0].DataValueThick) !== 0 && masterData.RemarkThick.toLowerCase().includes("within")) {
            //   if (masterThickness === null) {
            //     masterThickness = await models.tbl_batchsummary_master3.create({

            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolThick,
            //       Tol1Pos: masterData.T1PosTolThick,
            //       Tol2Neg: masterData.T2NegTolThick,
            //       Tol2Pos: masterData.T2PosTolThick,
            //       MinValue: masterData.MinWeightThick,
            //       MaxValue: masterData.MaxWeightThick,
            //       AvgValue: masterData.AvgThick,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });
            //   }
            //   await models['tbl_batchsummary_detail3'].create({
            //     RepSerNo: masterThickness.RepSerNo,
            //     RecSeqNo: recSeqNo,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     Min: masterData.MinWeightThick,
            //     Max: masterData.MaxWeightThick,
            //     Avg: masterData.AvgThick,
            //     // MinDiam: MinDLB,
            //     // MaxDiam: MaxDLB,
            //     // AvgDiam: AvgDLB,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });

            // } if (masterData.BLName === "Diameter" && masterData.RemarkBL.toLowerCase().includes("within")) {
            //   if (masterDiameter === null) {
            //     masterDiameter = await models.tbl_batchsummary_master6.create({
            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolBL,
            //       Tol1Pos: masterData.T1PosTolBL,
            //       Tol2Neg: masterData.T2NegTolBL,
            //       Tol2Pos: masterData.T2PosTolBL,
            //       MinValue: masterData.MinWeightBL,
            //       MaxValue: masterData.MaxWeightBL,
            //       AvgValue: masterData.AvgBL,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });
            //   }

            //   await models['tbl_batchsummary_detail6'].create({
            //     RepSerNo: masterDiameter.RepSerNo,
            //     RecSeqNo: recSeqNo,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     // MinThick: MinThick,
            //     // MaxThick: MaxThick,
            //     // AvgThick: AvgThick,
            //     Min: masterData.MinWeightBL,
            //     Max: masterData.MaxWeightBL,
            //     Avg: masterData.AvgBL,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });

            // } if (masterData.BLName === "Length" && masterData.RemarkBL.toLowerCase().includes("within")) {

            //   if (masterLength === null) {
            //     masterLength = await models.tbl_batchsummary_master5.create({
            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolBL,
            //       Tol1Pos: masterData.T1PosTolBL,
            //       Tol2Neg: masterData.T2NegTolBL,
            //       Tol2Pos: masterData.T2PosTolBL,
            //       MinValue: masterData.MinWeightBL,
            //       MaxValue: masterData.MaxWeightBL,
            //       AvgValue: masterData.AvgBL,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });
            //   }

            //   await models['tbl_batchsummary_detail5'].create({
            //     RepSerNo: masterLength.RepSerNo,
            //     RecSeqNo: recSeqNo,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     // MinThick: MinThick,
            //     // MaxThick: MaxThick,
            //     // AvgThick: AvgThick,
            //     Min: masterData.MinWeightBL,
            //     Max: masterData.MaxWeightBL,
            //     Avg: masterData.AvgBL,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });
            // }

            // const objInsertDetailData = await models['tbl_batchsummary_detailhtd'].create({
            //     RepSerNo: masterSrNo,
            //     RecSeqNo: recSeqNo,
            //     Date: masterData.PrDate,
            //     Time: masterData.PrTime,
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     MinHard: MinHard,
            //     MaxHard: MaxHard,
            //     AvgHard: avgHard,
            //     MinThick: MinThick,
            //     MaxThick: MaxThick,
            //     AvgThick: AvgThick,
            //     MinDiam: MinDLB,
            //     MaxDiam: MaxDLB,
            //     AvgDiam: AvgDLB,
            //     MinBL: MinDLB,
            //     MaxBL: MaxDLB,
            //     AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            // });

            // const objInsertDetailData = {
            //     str_tableName: 'tbl_batchsummary_detail_hdlb',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
            //         { str_colName: 'Side', value: sideVal },
            //         { str_colName: 'MinHard', value: MinHard },
            //         { str_colName: 'MaxHard', value: MaxHard },
            //         { str_colName: 'AvgHard', value: avgHard },
            //         { str_colName: 'MinThick', value: MinThick },
            //         { str_colName: 'MaxThick', value: MaxThick },
            //         { str_colName: 'AvgThick', value: AvgThick },
            //         { str_colName: 'MinDLB', value: MinDLB },
            //         { str_colName: 'MaxDLB', value: MaxDLB },
            //         { str_colName: 'AvgDLB', value: AvgDLB },
            //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            //         { str_colName: 'TestResult', value: remark },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },

            //     ]
            // }
            // //console.log(objInsertDetailData);
            // let detailResult1 = await database.save(objInsertDetailData);

            Object.assign(responseObj, { status: 'success' })
            return responseObj;


          } else {
            var repSerNo = resultData[0].SrNo
            masterSrNo = resultData[0].SrNo;
            //     const checkDetailObj = {
            //         str_tableName: detailTable,
            //         data: 'MAX(RecSeqNo) AS SeqNo',
            //         condition: [
            //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
            //         ]
            //     }
            //    let detailres = await database.select(checkDetailObj);
            //         var seqNum = detailres[0][0].SeqNo;
            //         var seqNo = seqNum + 1;
            // const objInsertDetailData = {
            //     str_tableName: 'tbl_batchsummary_detail_hdlb',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
            //         { str_colName: 'Side', value: sideVal },
            //         { str_colName: 'MinHard', value: MinHard },
            //         { str_colName: 'MaxHard', value: MaxHard },
            //         { str_colName: 'AvgHard', value: avgHard },
            //         { str_colName: 'MinThick', value: MinThick },
            //         { str_colName: 'MaxThick', value: MaxThick },
            //         { str_colName: 'AvgThick', value: AvgThick },
            //         { str_colName: 'MinDLB', value: MinDLB },
            //         { str_colName: 'MaxDLB', value: MaxDLB },
            //         { str_colName: 'AvgDLB', value: AvgDLB },
            //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            //         { str_colName: 'TestResult', value: remark },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },
            //     ]
            // }
            // await database.save(objInsertDetailData);

            var minHardValue = checkMasterObj[0].MinValueHard,
              maxHardValue = checkMasterObj[0].MaxValueHard,
              AvgHardValue = checkMasterObj[0].AvgValueHard,
              recSeqNoHard = 0
            var minThickValue = checkMasterObj[0].MinValueThick,
              maxThickValue = checkMasterObj[0].MaxValueThick,
              AvgThickValue = checkMasterObj[0].AvgValueThick,
              recSeqNoThick = 0
            var minDiamValue = checkMasterObj[0].MinValueDiam,
              maxDiamValue = checkMasterObj[0].MaxValueDiam,
              AvgDiamValue = checkMasterObj[0].AvgValueDiam,
              recSeqNoDiam = 0
            var minBLValue = checkMasterObj[0].MinValueBL,
              maxBLValue = checkMasterObj[0].MaxValueBL,
              AvgBLValue = checkMasterObj[0].AvgValueBL,
              recSeqNoBL = 0

            await models['tbl_batchsummary_detailhtd'].create({
              RepSerNo: masterSrNo,
              RecSeqNo: recSeqNo,
              Date: masterData.PrDate,
              Time: moment(masterData.PrTime).format("HH:mm:ss"),
              InstrumentID: masterData.HardnessID,
              Side: sideVal,
              MinHard: masterData.MinWeightHard,
              MaxHard: masterData.MaxWeightHard,
              AvgHard: masterData.AvgHard,
              MinThick: (MinThick == "NA") ? "NA" : mathj.round(Number(MinThick), dp).toFixed(dp),
              MaxThick: (MaxThick == "NA") ? "NA" : mathj.round(Number(MaxThick), dp).toFixed(dp),
              AvgThick: (AvgThick == "NA") ? "NA" : mathj.round(Number(AvgThick), dp).toFixed(dp),
              MinDiam: (MinDiam == "NA") ? "NA" : mathj.round(Number(MinDiam), dp).toFixed(dp),
              MaxDiam: (MaxDiam == "NA") ? "NA" : mathj.round(Number(MaxDiam), dp).toFixed(dp),
              AvgDiam: (AvgDiam == "NA") ? "NA" : mathj.round(Number(AvgDiam), dp).toFixed(dp),
              MinBL: (MinDLB == "NA") ? "NA" : mathj.round(Number(MinDLB), dp).toFixed(dp),
              MaxBL: (MaxDLB == "NA") ? "NA" : mathj.round(Number(MaxDLB), dp).toFixed(dp),
              AvgBL: (AvgDLB == "NA") ? "NA" : mathj.round(Number(AvgDLB), dp).toFixed(dp),
              //MinTimeDT': resultdata.incompleteData.T1PosTol ,
              //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
              TestResult: remark,
              UserID: masterData.UserId,
              UserName: masterData.UserName,
              NoOfSample: masterData.Qty,
              SFOID: masterData.SFOID,
              Repetition: masterData.Repetition
            });

            // } if (Number(DetailData[0].DataValueThick) !== 0 && masterData.RemarkThick.toLowerCase().includes("within")) {
            //   if (masterThickness === null) {
            //     masterThickness = await models.tbl_batchsummary_master3.create({
            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolThick,
            //       Tol1Pos: masterData.T1PosTolThick,
            //       Tol2Neg: masterData.T2NegTolThick,
            //       Tol2Pos: masterData.T2PosTolThick,
            //       MinValue: masterData.MinWeightThick,
            //       MaxValue: masterData.MaxWeightThick,
            //       AvgValue: masterData.AvgThick,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });
            //     minThickValue = masterData.MinWeightThick
            //     maxThickValue = masterData.MaxWeightThick
            //     AvgThickValue = masterData.AvgThick
            //     recSeqNoThick = 1

            //   } else {

            //     var detailData = await models.tbl_batchsummary_detail3.findAll({
            //       where: {
            //         RepSerNo: masterThickness.RepSerNo,
            //       }
            //     })

            //     minThickValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightThick, masterData.MaxWeightThick]), 2).toFixed(2)
            //     maxThickValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightThick, masterData.MaxWeightThick]), 2).toFixed(2)
            //     AvgThickValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgThick]), 3).toFixed(3)
            //     recSeqNoThick = detailData.length + 1

            //     await models.tbl_batchsummary_master3.update({
            //       MinValue: minThickValue,
            //       MaxValue: maxThickValue,
            //       AvgValue: AvgThickValue,
            //       EndDate: moment().format("YYYY-MM-DD"),
            //     }, {
            //       where: {
            //         RepSerNo: masterThickness.RepSerNo,
            //       }
            //     });
            //   }

            //   await models['tbl_batchsummary_detail3'].create({
            //     RepSerNo: masterThickness.RepSerNo,
            //     RecSeqNo: recSeqNoThick,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     Min: masterData.MinWeightThick,
            //     Max: masterData.MaxWeightThick,
            //     Avg: masterData.AvgThick,
            //     // MinDiam: MinDLB,
            //     // MaxDiam: MaxDLB,
            //     // AvgDiam: AvgDLB,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });

            // } if (masterData.BLName === "Diameter" && masterData.RemarkDiam.toLowerCase().includes("within")) {
            //   if (masterDiameter === null) {
            //     masterDiameter = await models.tbl_batchsummary_master6.create({
            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolDiam,
            //       Tol1Pos: masterData.T1PosTolDiam,
            //       Tol2Neg: masterData.T2NegTolDiam,
            //       Tol2Pos: masterData.T2PosTolDiam,
            //       MinValue: masterData.MinWeightDiam,
            //       MaxValue: masterData.MaxWeightDiam,
            //       AvgValue: masterData.AvgDiam,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });

            //     minDiamValue = masterData.MinWeightDiam
            //     maxDiamValue = masterData.MaxWeightDiam
            //     AvgDiamValue = masterData.AvgDiam
            //     recSeqNoDiam = 1

            //   } else {

            //     var detailData = await models.tbl_batchsummary_detail6.findAll({
            //       where: {
            //         RepSerNo: masterDiameter.RepSerNo,
            //       }
            //     })

            //     minDiamValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
            //     maxDiamValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
            //     AvgDiamValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgBL]), 3).toFixed(3)
            //     recSeqNoDiam = detailData.length + 1

            //     await models.tbl_batchsummary_master6.update({
            //       MinValue: minDiamValue,
            //       MaxValue: maxDiamValue,
            //       AvgValue: AvgDiamValue,
            //       EndDate: moment().format("YYYY-MM-DD"),
            //     }, {
            //       where: {
            //         RepSerNo: masterDiameter.RepSerNo,
            //       }
            //     });

            //   }
            //   await models['tbl_batchsummary_detail6'].create({
            //     RepSerNo: masterDiameter.RepSerNo,
            //     RecSeqNo: recSeqNoDiam,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     // MinThick: MinThick,
            //     // MaxThick: MaxThick,
            //     // AvgThick: AvgThick,
            //     Min: masterData.MinWeightBL,
            //     Max: masterData.MaxWeightBL,
            //     Avg: masterData.AvgBL,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });
            // } if (masterData.BLName === "Length" && masterData.RemarkBL.toLowerCase().includes("within")) {

            //   if (masterLength === null) {
            //     masterLength = await models.tbl_batchsummary_master5.create({
            //       Area: masterData.Area,
            //       ReportType: masterData.ReportType,
            //       CubicalNo: masterData.CubicalNo,
            //       CubicleType: masterData.CubicleType,
            //       BatchSize: masterData.BatchSize,
            //       Tol1Neg: masterData.T1NegTolBL,
            //       Tol1Pos: masterData.T1PosTolBL,
            //       Tol2Neg: masterData.T2NegTolBL,
            //       Tol2Pos: masterData.T2PosTolBL,
            //       MinValue: masterData.MinWeightBL,
            //       MaxValue: masterData.MaxWeightBL,
            //       AvgValue: masterData.AvgBL,
            //       StartDate: moment().format("YYYY-MM-DD"),
            //       EndDate: moment().format("YYYY-MM-DD"),
            //       DP: 3,
            //       NomHard: masterData.NomHard,
            //       NomThick: masterData.NomThick,
            //       NomDiam: masterData.NomDiam,
            //       NomBL: masterData.NomBL,
            //       MinValueHard: masterData.MinWeightHard,
            //       MaxValueHard: masterData.MaxWeightHard,
            //       AvgValueHard: masterData.AvgHard,
            //       MinValueThick: masterData.MinWeightThick,
            //       MaxValueThick: masterData.MaxWeightThick,
            //       AvgValueThick: masterData.AvgThick,
            //       MinValueDiam: masterData.MinWeightDiam,
            //       MaxValueDiam: masterData.MaxWeightDiam,
            //       AvgValueDiam: masterData.AvgDiam,
            //       MinValueBL: masterData.MinWeightBL,
            //       MaxValueBL: masterData.MaxWeightBL,
            //       AvgValueBL: masterData.AvgBL,
            //       StartDateHard: moment().format("YYYY-MM-DD"),
            //       EndDateHard: moment().format("YYYY-MM-DD"),
            //       StartDateThick: moment().format("YYYY-MM-DD"),
            //       EndDateThick: moment().format("YYYY-MM-DD"),
            //       StartDateDiam: moment().format("YYYY-MM-DD"),
            //       EndDateDiam: moment().format("YYYY-MM-DD"),
            //       StartDateBL: moment().format("YYYY-MM-DD"),
            //       EndDateBL: moment().format("YYYY-MM-DD"),
            //       Unit: masterData.Unit,
            //       BFGCode: masterData.BFGCode,
            //       ProductName: masterData.ProductName,
            //       PVersion: masterData.PVersion,
            //       Version: masterData.Version,
            //       PrdType: 1,
            //       CubType: masterData.CubicleType,
            //       BatchNo: masterData.BatchNo,
            //       Stage: masterData.Stage,
            //       Dept: cubicalObj.Sys_dept,
            //       NomHard: masterData.NomHard,
            //       LwrHard: masterData.NegTolHard,
            //       UppHard: masterData.PosTolHard,
            //       UnitHard: masterData.Unit,
            //       NomThick: masterData.NomThick,
            //       LwrThick: masterData.NegTolThick,
            //       UppThick: masterData.PosTolThick,
            //       NomDLB: masterData.NomDOLOBO,
            //       LwrDLB: masterData.NegTolDOLOBO,
            //       UppDLB: masterData.PosTolDOLOBO,
            //       // DLBParamName: masterData.ColHeadDOLOBO,
            //       Remark: remark,
            //       Side: sideVal,
            //       BatchCompleted: 0,
            //       IsArchived: 0,
            //       LimitOn: 0
            //     });

            //     minBLValue = masterData.MinWeightBL
            //     maxBLValue = masterData.MaxWeightBL
            //     AvgBLValue = masterData.AvgBL
            //     recSeqNoBL = 1

            //   } else {

            //     var detailData = await models.tbl_batchsummary_detail5.findAll({
            //       where: {
            //         RepSerNo: masterLength.RepSerNo,
            //       }
            //     })

            //     minBLValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
            //     maxBLValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
            //     AvgBLValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgBL]), 3).toFixed(3)
            //     recSeqNoBL = detailData.length + 1

            //     await models.tbl_batchsummary_master5.update({
            //       MinValue: minBLValue,
            //       MaxValue: maxBLValue,
            //       AvgValue: AvgBLValue,
            //       EndDate: moment().format("YYYY-MM-DD"),
            //     }, {
            //       where: {
            //         RepSerNo: masterLength.RepSerNo,
            //       }
            //     });
            //   }
            //   await models['tbl_batchsummary_detail5'].create({
            //     RepSerNo: masterLength.RepSerNo,
            //     RecSeqNo: recSeqNoBL,
            //     Date: masterData.PrDate,
            //     Time: moment(masterData.PrTime).format("HH:mm:ss"),
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     // MinHard: MinHard,
            //     // MaxHard: MaxHard,
            //     // AvgHard: avgHard,
            //     // MinThick: MinThick,
            //     // MaxThick: MaxThick,
            //     // AvgThick: AvgThick,
            //     Min: masterData.MinWeightBL,
            //     Max: masterData.MaxWeightBL,
            //     Avg: masterData.AvgBL,
            //     // MinBL: MinDLB,
            //     // MaxBL: MaxDLB,
            //     // AvgBL: AvgDLB,
            //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            //   });


            // if (masterData.RemarkHard.toLowerCase().includes("within") ||
            //   masterData.RemarkThick.toLowerCase().includes("within") ||
            //   masterData.RemarkDiam.toLowerCase().includes("within") ||
            //   masterData.RemarkBL.toLowerCase().includes("within")
            // ) {
            //   await models.tbl_batchsummary_masterhtd.update({
            //     MinValueHard: minHardValue,
            //     MaxValueHard: maxHardValue,
            //     AvgValueHard: AvgHardValue,
            //     MinValueThick: minThickValue,
            //     MaxValueThick: maxThickValue,
            //     AvgValueThick: AvgThickValue,
            //     MinValueDiam: minDiamValue,
            //     MaxValueDiam: maxDiamValue,
            //     AvgValueDiam: AvgDiamValue,
            //     MinValueBL: minBLValue,
            //     MaxValueBL: maxBLValue,
            //     AvgValueBL: AvgBLValue,
            //   }, {
            //     where: {
            //       RepSerNo: masterSrNo
            //     }
            //   })

            // }

            // const objInsertDetailData = await models['tbl_batchsummary_detailhtd'].create({
            //     RepSerNo: masterSrNo,
            //     RecSeqNo: recSeqNo,
            //     Date: masterData.PrDate,
            //     Time: masterData.PrTime,
            //     InstrumentID: masterData.HardnessID,
            //     Side: sideVal,
            //     MinHard: MinHard,
            //     MaxHard: MaxHard,
            //     AvgHard: avgHard,
            //     MinThick: MinThick,
            //     MaxThick: MaxThick,
            //     AvgThick: AvgThick,
            //     MinDLB: MinDLB,
            //     MaxDLB: MaxDLB,
            //     AvgDLB: AvgDLB,
            //     //MinTimeDT: resultdata.incompleteData.T1PosTol ,
            //     //MaxTimeDT: resultdata.incompleteData.T2NegTol ,
            //     TestResult: remark,
            //     UserID: masterData.UserId,
            //     UserName: masterData.UserName,
            // });
            // let completeUpdate = await sequelize.query(`SELECT 
            //   MAX(CAST(MaxHard AS DECIMAL(10, 0))) AS 'MaxHard',
            //   MIN(CAST(MinHard AS DECIMAL(10, 0))) AS 'MinHard',
            //   AVG(CAST(AvgHard AS DECIMAL(10, 1))) AS 'AvgHard',
            //   MAX(CAST(MaxThick AS DECIMAL(10, 2))) AS 'MaxThick',
            //   MIN(CAST(MinThick AS DECIMAL(10, 2))) AS 'MinThick',
            //   AVG(CAST(AvgThick AS DECIMAL(10, 2))) AS 'AvgThick',
            //   MAX(CAST(MaxDiam AS DECIMAL(10, 2))) AS 'MaxDiam',
            //   MIN(CAST(MinDiam AS DECIMAL(10, 2))) AS 'MinDiam',
            //   AVG(CAST(AvgDiam AS DECIMAL(10, 2))) AS 'AvgDiam',
            //   MAX(CAST(MaxBL AS DECIMAL(10, 2))) AS 'MaxBL',
            //   MIN(CAST(MinBL AS DECIMAL(10, 2))) AS 'MinBL',
            //   AVG(CAST(AvgBL AS DECIMAL(10, 2))) AS 'AvgBL'
            //   FROM
            //    tbl_batchsummary_detailhtd
            //   WHERE
            //   RepSerNo = ${masterSrNo} AND TestResult = 'Complies';`)
            // let completeUpdate = await sequelize.query(`SELECT 
            // Max(CASE When TRY_CAST(MaxHard AS DECIMAL(10, 0)) IS Not NULL Then CAST(MaxHard AS DECIMAL(10, 0)) END) As 'MaxHard',
            // MIN(CASE When TRY_CAST(MinHard AS DECIMAL(10, 0)) IS Not NULL Then CAST(MinHard AS DECIMAL(10, 0)) END) As 'MinHard',
            // AVG(CASE When TRY_CAST(AvgHard AS DECIMAL(10, 1)) IS Not NULL Then CAST(AvgHard AS DECIMAL(10, 1)) END) As 'AvgHard',
            // Max(CASE When TRY_CAST(MaxThick AS DECIMAL(10, 2)) IS Not NULL Then CAST(MaxThick AS DECIMAL(10, 2)) END) As 'MaxThick',
            // MIN(CASE When TRY_CAST(MinThick AS DECIMAL(10, 2)) IS Not NULL Then CAST(MinThick AS DECIMAL(10, 2)) END) As 'MinThick',
            // AVG(CASE When TRY_CAST(AvgThick AS DECIMAL(10, 2)) IS Not NULL Then CAST(AvgThick AS DECIMAL(10, 2)) END) As 'AvgThick',
            // Max(CASE When TRY_CAST(MaxDiam AS DECIMAL(10, 2)) IS Not NULL Then CAST(MaxDiam AS DECIMAL(10, 2)) END) As 'MaxDiam',
            // MIN(CASE When TRY_CAST(MinDiam AS DECIMAL(10, 2)) IS Not NULL Then CAST(MinDiam AS DECIMAL(10, 2)) END) As 'MinDiam',
            // AVG(CASE When TRY_CAST(AvgDiam AS DECIMAL(10, 2)) IS Not NULL Then CAST(AvgDiam AS DECIMAL(10, 2)) END) As 'AvgDiam',
            // Max(CASE When TRY_CAST(MaxBL AS DECIMAL(10, 2)) IS Not NULL Then CAST(MaxBL AS DECIMAL(10, 2)) END) As 'MaxBL',
            // MIN(CASE When TRY_CAST(MinBL AS DECIMAL(10, 2)) IS Not NULL Then CAST(MinBL AS DECIMAL(10, 2)) END) As 'MinBL',
            // AVG(CASE When TRY_CAST(AvgBL AS DECIMAL(10, 2)) IS Not NULL Then CAST(AvgBL AS DECIMAL(10, 2)) END) As 'AvgBL'
            // FROM
            //  tbl_batchsummary_detailhtd
            // WHERE
            // RepSerNo = ${masterSrNo} AND TestResult = 'Complies';`)

            let getAllData = await models.tbl_batchsummary_detailhtd.findAll({
              where: {
                RepSerNo: masterSrNo,
                TestResult: 'Complies'
              }
            })

            let minHard = getAllData.filter(e => e.MinHard != "NA").map(e => e.MinHard);
            let maxHard = getAllData.filter(e => e.MaxHard != "NA").map(e => e.MaxHard);
            let avgHard = getAllData.filter(e => e.AvgHard != "NA").map(e => e.AvgHard);
            let minThick = getAllData.filter(e => e.MinThick != "NA").map(e => e.MinThick);
            let maxThick = getAllData.filter(e => e.MaxThick != "NA").map(e => e.MaxThick);
            let avgThick = getAllData.filter(e => e.AvgThick != "NA").map(e => e.AvgThick);
            let maxDiam = getAllData.filter(e => e.MaxDiam != "NA").map(e => e.MaxDiam);
            let minDiam = getAllData.filter(e => e.MinDiam != "NA").map(e => e.MinDiam);
            let avgDiam = getAllData.filter(e => e.AvgDiam != "NA").map(e => e.AvgDiam);
            let maxBL = getAllData.filter(e => e.MaxBL != "NA").map(e => e.MaxBL);
            let minBL = getAllData.filter(e => e.MinBL != "NA").map(e => e.MinBL);
            let avgBL = getAllData.filter(e => e.AvgBL != "NA").map(e => e.AvgBL);

            let minValueHard = (minHard.length > 0) ? mathj.round(Number(mathj.min(minHard)), hardDp).toFixed(hardDp) : 'NA';
            let maxValueHard = (maxHard.length > 0) ? mathj.round(Number(mathj.max(maxHard)), hardDp).toFixed(hardDp) : 'NA';
            let avgValueHard = (avgHard.length > 0) ? mathj.round(Number(mathj.mean(avgHard)), avgHrd).toFixed(avgHrd) : 'NA';
            let minValueThick = (minThick.length > 0) ? mathj.round(Number(mathj.min(minThick)), dp).toFixed(dp) : 'NA';
            let maxValueThick = (maxThick.length > 0) ? mathj.round(Number(mathj.max(maxThick)), dp).toFixed(dp) : 'NA';
            let avgValueThick = (avgThick.length > 0) ? mathj.round(Number(mathj.mean(avgThick)), dp).toFixed(dp) : 'NA';
            let minValueDiam = (minDiam.length > 0) ? mathj.round(Number(mathj.min(minDiam)), dp).toFixed(dp) : 'NA';
            let maxValueDiam = (maxDiam.length > 0) ? mathj.round(Number(mathj.max(maxDiam)), dp).toFixed(dp) : 'NA';
            let avgValueDiam = (avgDiam.length > 0) ? mathj.round(Number(mathj.mean(avgDiam)), dp).toFixed(dp) : 'NA';
            let minValueBL = (minBL.length > 0) ? mathj.round(Number(mathj.min(minBL)), dp).toFixed(dp) : 'NA';
            let maxValueBL = (maxBL.length > 0) ? mathj.round(Number(mathj.max(maxBL)), dp).toFixed(dp) : 'NA';
            let avgValueBL = (avgBL.length > 0) ? mathj.round(Number(mathj.mean(avgBL)), dp).toFixed(dp) : 'NA';

            await models.tbl_batchsummary_masterhtd.update({
              MinValueHard: minValueHard,
              MaxValueHard: maxValueHard,
              AvgValueHard: avgValueHard,
              MinValueThick: minValueThick,
              MaxValueThick: maxValueThick,
              AvgValueThick: avgValueThick,
              MinValueDiam: minValueDiam,
              MaxValueDiam: maxValueDiam,
              AvgValueDiam: avgValueDiam,
              MinValueBL: minValueBL,
              MaxValueBL: maxValueBL,
              AvgValueBL: avgValueBL,
              EndDate: moment().format("YYYY-MM-DD"),
            }, {
              where: {
                RepSerNo: resultData[0].SrNo,
              }
            });
            // await models.tbl_batchsummary_masterhtd.update({
            //   MinValueHard: Number(completeUpdate[0][0].MinHard).toFixed(hardDp),
            //   MaxValueHard: Number(completeUpdate[0][0].MaxHard).toFixed(hardDp),
            //   AvgValueHard: Number(completeUpdate[0][0].AvgHard).toFixed(avgHrd),
            //   MinValueThick: Number(completeUpdate[0][0].MinThick).toFixed(dp),
            //   MaxValueThick: Number(completeUpdate[0][0].MaxThick).toFixed(dp),
            //   AvgValueThick: Number(completeUpdate[0][0].AvgThick).toFixed(dp),
            //   MinValueDiam: Number(completeUpdate[0][0].MinDiam).toFixed(dp),
            //   MaxValueDiam: Number(completeUpdate[0][0].MaxDiam).toFixed(dp),
            //   AvgValueDiam: Number(completeUpdate[0][0].AvgDiam).toFixed(dp),
            //   MinValueBL: Number(completeUpdate[0][0].MinBL).toFixed(dp),
            //   MaxValueBL: Number(completeUpdate[0][0].MaxBL).toFixed(dp),
            //   AvgValueBL: Number(completeUpdate[0][0].AvgBL).toFixed(dp),
            //   EndDate: moment().format("YYYY-MM-DD"),
            // }, {
            //   where: {
            //     RepSerNo: resultData[0].SrNo,
            //   }
            // });

            Object.assign(responseObj, { status: 'success', remark: remark });
            return responseObj;
          }

        }
      }
    } catch (error) {
      throw new Error(error)
    }
  }



  async saveBatchDataHardnessUGD(masterData, DetailData, DsNo) {
    try {
      var now = new Date();
      let responseObj = {};
      // console.log(masterData, DetailData);

      var cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == DsNo).cubicalData;
      var menuDetail = globalData.arrSelectedMenu.find(k => k.DsNo == DsNo).selectedProductDetail;
      let tempLimObjHardness = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0].Hardness;
      let tempLimObjThickness = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0].Thickness;
      let tempLimObjlength = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Length")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Length")[0].Length;
      let tempLimObjDiameter = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0].Diameter;
      let tempLimObjBreadth = menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0] == undefined ? undefined :
        menuDetail.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0].Breadth;
      let sideVal = "NA";
      if (masterData.Side == 'LHS') {
        sideVal = "LEFT";
      } else if (masterData.Side == 'RHS') {
        sideVal = "RIGHT";
      } else {
        sideVal = "NA";
      }
      let checkSideMasterTable;
      if (masterData.Side == 'NA') {
        checkSideMasterTable = 'NA';
      } else {
        checkSideMasterTable = 'LEFT';
      }
      let sumHT = 0;
      let sumT = 0;
      let sumDLB = 0;
      let arrHTDetail = [];
      let arrTDetail = [];
      let arrDLBDetail = [];
      let outFlagHTD = 0;
      let outFlagThickness = 0;
      let outFlagDOLOBO = 0;
      let remark;
      let maxHTDLimit = parseFloat(tempLimObjHardness.T2Pos);
      let minHTDLimit = parseFloat(tempLimObjHardness.T2Neg);
      if (tempLimObjThickness == undefined) {
        var maxTLimit = 0;
        var minTLimit = 0;
      } else {
        var maxTLimit = parseFloat(tempLimObjThickness.T2Pos);
        var minTLimit = parseFloat(tempLimObjThickness.T2Neg);
      }
      // if(masterData.NomDOLOBO != 0) {
      if (masterData.ColHeadDOLOBO == 'NA') {
        var maxDLBLimit = 0;
        var minDLBLimit = 0;
      } else {
        if (tempLimObjlength == undefined && tempLimObjBreadth == undefined && tempLimObjDiameter == undefined) {
          var maxDLBLimit = 0;
          var minDLBLimit = 0;
        } else {
          // tempLimObjlength == undefined ? tempLimObjBreadth == undefined ?  tempLimObjBreadth : tempLimObjDiameter ;
          let a = tempLimObjlength != undefined ? tempLimObjlength : tempLimObjBreadth != undefined ? tempLimObjBreadth : tempLimObjDiameter;
          var maxDLBLimit = parseFloat(formulaFun.upperLimit(a));
          var minDLBLimit = parseFloat(formulaFun.lowerLimit(a));
        }
      }


      let count = DetailData.length;
      for (var i = 0; i < DetailData.length; i++) {
        var dataValHard = parseFloat(DetailData[i].DataValueHard);
        if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
          outFlagHTD = outFlagHTD + 1;
        }
        arrHTDetail.push(dataValHard);
        var dataValThick = parseFloat(DetailData[i].DataValueThick);
        if (minTLimit != 0 && maxTLimit != 0) {
          if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
            outFlagThickness = outFlagThickness + 1;
          }
        }
        arrTDetail.push(dataValThick);
        var dataValDLB = parseFloat(DetailData[i].DataValueBL);
        if (minDLBLimit != 0 && maxDLBLimit != 0) {
          if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
            outFlagDOLOBO = outFlagDOLOBO + 1;
          }
        }
        arrDLBDetail.push(dataValDLB);
      }

      if (masterData.NomDOLOBO != 0) {
        if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0) {
          remark = 'Not Complies';
        } else {
          remark = 'Complies';
        }
      } else {
        if (outFlagHTD != 0 || outFlagThickness != 0) {
          remark = 'Not Complies'
        } else {
          remark = 'Complies';
        }
      }

      for (var j = 0; j < arrHTDetail.length; j++) {
        sumHT = sumHT + parseFloat(arrHTDetail[j]);
      }
      for (var k = 0; k < arrTDetail.length; k++) {
        sumT = sumT + parseFloat(arrTDetail[k]);
      }
      for (var l = 0; l < arrDLBDetail.length; l++) {
        sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
      }
      var MaxHard = Math.max(...arrHTDetail);
      var MinHard = Math.min(...arrHTDetail);
      var avgHard = (sumHT / count);
      var MaxThick = Math.max(...arrTDetail);
      var MinThick = Math.min(...arrTDetail);
      var AvgThick = (sumT / count);
      var MaxDLB = Math.max(...arrDLBDetail);
      var MinDLB = Math.min(...arrDLBDetail);
      var AvgDLB = (sumDLB / count);

      cubicalObj.Sys_BatchReuse = 0
      if (cubicalObj.Sys_RptType == 0 && cubicalObj.Sys_BatchReuse == 0 && cubicalObj.Sys_Validation == 0 &&
        (cubicalObj.Sys_CubType == 'Compression' || cubicalObj.Sys_CubType == 'Coating')) {
        var masterSrNo;



        let count = DetailData.length;
        for (var i = 0; i < DetailData.length; i++) {
          var dataValHard = parseFloat(DetailData[i].DataValueHard);
          if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
            outFlagHTD = outFlagHTD + 1;
          }
          arrHTDetail.push(dataValHard);
          var dataValThick = parseFloat(DetailData[i].DataValueThick);
          if (minTLimit != 0 && maxTLimit != 0) {
            if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
              outFlagThickness = outFlagThickness + 1;
            }
          }
          arrTDetail.push(dataValThick);
          var dataValDLB = parseFloat(DetailData[i].DataValueBL);
          if (minDLBLimit != 0 && maxDLBLimit != 0) {
            if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
              outFlagDOLOBO = outFlagDOLOBO + 1;
            }
          }
          arrDLBDetail.push(dataValDLB);
        }

        if (masterData.NomDOLOBO != 0) {
          if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0) {
            remark = 'Not Complies';
          } else {
            remark = 'Complies';
          }
        } else {
          if (outFlagHTD != 0 || outFlagThickness != 0) {
            remark = 'Not Complies'
          } else {
            remark = 'Complies';
          }
        }

        for (var j = 0; j < arrHTDetail.length; j++) {
          sumHT = sumHT + parseFloat(arrHTDetail[j]);
        }
        for (var k = 0; k < arrTDetail.length; k++) {
          sumT = sumT + parseFloat(arrTDetail[k]);
        }
        for (var l = 0; l < arrDLBDetail.length; l++) {
          sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
        }
        var MaxHard = Math.max(...arrHTDetail);
        var MinHard = Math.min(...arrHTDetail);
        var avgHard = (sumHT / count);
        var MaxThick = Math.max(...arrTDetail);
        var MinThick = Math.min(...arrTDetail);
        var AvgThick = (sumT / count);
        var MaxDLB = Math.max(...arrDLBDetail);
        var MinDLB = Math.min(...arrDLBDetail);
        var AvgDLB = (sumDLB / count);

        if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
          // let res = await proObj.productData(cubicalObj);
          // var paramNom = `Param7_Nom`;
          // var limitNo = `Param7_LimitOn`;
          // var nom = parseFloat(res[1][paramNom]);
          // var limit = res[1][limitNo].readUIntLE();
          // if(masterData.ColHeadDOLOBO == 'Le')

          // const checkMasterObj = {
          //     str_tableName: 'tbl_batchsummary_master_hdlb',
          //     data: 'MAX(RepSerNo) AS SrNo',
          //     condition: [
          //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
          //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
          //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
          //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
          //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
          //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
          //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
          //     ]
          // }

          // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
          // let resultData = await database.select(checkMasterObj);
          var masterSrNo;
          const checkMasterObj = await models['tbl_batchsummary_masterhtd'].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          var masterHard = await models.tbl_batchsummary_master7.findOne({
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          var masterThickness = await models.tbl_batchsummary_master3.findOne({
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          var masterLength = await models.tbl_batchsummary_master5.findOne({
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          var masterDiameter = await models.tbl_batchsummary_master6.findOne({
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          let resultData = checkMasterObj;

          let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_masterhtd', 'tbl_batchsummary_detailhtd', masterData);

          if (masterData.RemarkHard.toLowerCase().includes("within") &&
            masterData.RemarkThick == 'NA' &&
            (masterData.RemarkBL == 'NA')) {
            if (Number(DetailData[0].DataValueHard) !== 0 &&
              masterData.RemarkHard.toLowerCase().includes("within")) {
              if (resultData[0].SrNo == null) {
                if (masterHard === null) {
                  const masterDataInsert = await models['tbl_batchsummary_masterhtd'].create({
                    Area: masterData.Area,
                    ReportType: masterData.ReportType,
                    CubicalNo: masterData.CubicalNo,
                    CubicleType: masterData.CubicleType,
                    BatchSize: masterData.BatchSize,
                    BLName: masterData.BLName,
                    TolNegHard: masterData.T3NegTolHard,
                    TolPosHard: masterData.T3PosTolHard,
                    TolNegThick: masterData.T3NegTolThick,
                    TolPosThick: masterData.T3PosTolThick,
                    TolNegDiam: masterData.T3NegTolDiam,
                    TolPosDiam: masterData.T3PosTolDiam,
                    TolNegBL: masterData.T3NegTolBL,
                    TolPosBL: masterData.T3PosTolBL,
                    TolNegActualHard: masterData.T3NegTolActualHard,
                    TolPosActualHard: masterData.T3PosTolActualHard,
                    TolNegActualThick: masterData.T3NegTolActualThick,
                    TolPosActualThick: masterData.T3PosTolActualThick,
                    TolPosActualDiam: masterData.T3NegTolActualDiam,
                    TolNegActualDiam: masterData.T3PosTolActualDiam,
                    TolNegActualBL: masterData.T3NegTolActualBL,
                    TolPosActualBL: masterData.T3PosTolActualBL,

                    NomHard: masterData.NomHard,
                    NomThick: masterData.NomThick,
                    NomDiam: masterData.NomDiam,
                    NomBL: masterData.NomBL,

                    MinValueHard: masterData.MinWeightHard,
                    MaxValueHard: masterData.MaxWeightHard,
                    AvgValueHard: masterData.AvgHard,

                    MinValueThick: masterData.MinWeightThick,
                    MaxValueThick: masterData.MaxWeightThick,
                    AvgValueThick: masterData.AvgThick,

                    MinValueDiam: masterData.MinWeightDiam,
                    MaxValueDiam: masterData.MaxWeightDiam,
                    AvgValueDiam: masterData.AvgDiam,

                    MinValueBL: masterData.MinWeightBL,
                    MaxValueBL: masterData.MaxWeightBL,
                    AvgValueBL: masterData.AvgBL,
                    StartDate: moment().format("YYYY-MM-DD"),
                    StartDateHard: moment().format("YYYY-MM-DD"),
                    EndDateHard: moment().format("YYYY-MM-DD"),
                    StartDateThick: moment().format("YYYY-MM-DD"),
                    EndDateThick: moment().format("YYYY-MM-DD"),
                    StartDateDiam: moment().format("YYYY-MM-DD"),
                    EndDateDiam: moment().format("YYYY-MM-DD"),
                    StartDateBL: moment().format("YYYY-MM-DD"),
                    EndDateBL: moment().format("YYYY-MM-DD"),
                    Unit: masterData.Unit,
                    BFGCode: masterData.BFGCode,
                    ProductName: masterData.ProductName,
                    PVersion: masterData.PVersion,
                    Version: masterData.Version,
                    PrdType: 1,
                    CubType: masterData.CubicleType,
                    BatchNo: masterData.BatchNo,
                    Stage: masterData.Stage,
                    Dept: cubicalObj.Sys_dept ? cubicalObj.Sys_dept : 'NA',
                    NomHard: masterData.NomHard,
                    LwrHard: masterData.NegTolHard,
                    UppHard: masterData.PosTolHard,
                    UnitHard: masterData.Unit,
                    NomThick: masterData.NomThick,
                    LwrThick: masterData.NegTolThick,
                    UppThick: masterData.PosTolThick,
                    NomDLB: masterData.NomDOLOBO,
                    LwrDLB: masterData.NegTolDOLOBO,
                    UppDLB: masterData.PosTolDOLOBO,
                    // DLBParamName: masterData.ColHeadDOLOBO,
                    Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    Side: checkSideMasterTable,
                    BatchCompleted: 0,
                    IsArchived: 0,
                    LimitOn: 0
                  });
                  masterHard = await models.tbl_batchsummary_master7.create({
                    Area: masterData.Area,
                    ReportType: masterData.ReportType,
                    CubicalNo: masterData.CubicalNo,
                    CubicleType: masterData.CubicleType,
                    BatchSize: masterData.BatchSize,
                    Tol1Neg: masterData.T1NegTolBL,
                    Tol1Pos: masterData.T1PosTolBL,
                    Tol2Neg: masterData.T2NegTolHard,
                    Tol2Pos: masterData.T2PosTolHard,
                    MinValue: masterData.MinWeightHard,
                    MaxValue: masterData.MaxWeightHard,
                    AvgValue: masterData.AvgHard,
                    StartDate: moment().format("YYYY-MM-DD"),
                    EndDate: moment().format("YYYY-MM-DD"),
                    DP: 3,
                    NomHard: masterData.NomHard,
                    NomThick: masterData.NomThick,
                    NomDiam: masterData.NomDiam,
                    NomBL: masterData.NomBL,
                    MinValueHard: masterData.MinWeightHard,
                    MaxValueHard: masterData.MaxWeightHard,
                    AvgValueHard: masterData.AvgHard,
                    MinValueThick: masterData.MinWeightThick,
                    MaxValueThick: masterData.MaxWeightThick,
                    AvgValueThick: masterData.AvgThick,
                    MinValueDiam: masterData.MinWeightDiam,
                    MaxValueDiam: masterData.MaxWeightDiam,
                    AvgValueDiam: masterData.AvgDiam,
                    MinValueBL: masterData.MinWeightBL,
                    MaxValueBL: masterData.MaxWeightBL,
                    AvgValueBL: masterData.AvgBL,
                    StartDateHard: moment().format("YYYY-MM-DD"),
                    EndDateHard: moment().format("YYYY-MM-DD"),
                    StartDateThick: moment().format("YYYY-MM-DD"),
                    EndDateThick: moment().format("YYYY-MM-DD"),
                    StartDateDiam: moment().format("YYYY-MM-DD"),
                    EndDateDiam: moment().format("YYYY-MM-DD"),
                    StartDateBL: moment().format("YYYY-MM-DD"),
                    EndDateBL: moment().format("YYYY-MM-DD"),
                    Unit: masterData.Unit,
                    BFGCode: masterData.BFGCode,
                    ProductName: masterData.ProductName,
                    PVersion: masterData.PVersion,
                    Version: masterData.Version,
                    PrdType: 1,
                    CubType: masterData.CubicleType,
                    BatchNo: masterData.BatchNo,
                    Stage: masterData.Stage,
                    Department: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                    NomHard: masterData.NomHard,
                    LwrHard: masterData.NegTolHard != null ? masterData.NegTolHard : masterData.T2NegTolHard,
                    UppHard: masterData.PosTolHard != null ? masterData.PosTolHard : masterData.T2PosTolHard,
                    UnitHard: masterData.Unit,
                    NomThick: masterData.NomThick,
                    LwrThick: masterData.NegTolThick,
                    UppThick: masterData.PosTolThick,
                    NomDLB: masterData.NomDOLOBO,
                    LwrDLB: masterData.NegTolDOLOBO,
                    UppDLB: masterData.PosTolDOLOBO,
                    // DLBParamName: masterData.ColHeadDOLOBO,
                    Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    Side: checkSideMasterTable,
                    BatchCompleted: 0,
                    IsArchived: 0,
                    LimitOn: 0
                  });
                }

                await models['tbl_batchsummary_detail7'].create({
                  RepSerNo: masterHard.RepSerNo,
                  RecSeqNo: recSeqNo,
                  Date: masterData.PrDate,
                  Time: moment(masterData.PrTime).format("HH:mm:ss"),
                  InstrumentID: masterData.HardnessID,
                  Side: sideVal,
                  // MinHard: MinHard,
                  // MaxHard: MaxHard,
                  // AvgHard: avgHard,
                  Min: masterData.MinWeightHard,
                  Max: masterData.MaxWeightHard,
                  Avg: masterData.AvgHard,
                  // MinDiam: MinDLB,
                  // MaxDiam: MaxDLB,
                  // AvgDiam: AvgDLB,
                  // MinBL: MinDLB,
                  // MaxBL: MaxDLB,
                  // AvgBL: AvgDLB,
                  //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                  //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                  TestResult: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                  UserID: masterData.UserId,
                  UserName: masterData.UserName,
                  SFOID: masterData.SFOID,
                  Repetition: masterData.Repetition
                });

              } else {
                var repSerNo = resultData[0].SrNo
                masterSrNo = resultData[0].SrNo;
                var minHardValue = checkMasterObj[0].MinValueHard,
                  maxHardValue = checkMasterObj[0].MaxValueHard,
                  AvgHardValue = checkMasterObj[0].AvgValueHard,
                  recSeqNoHard = 0
                var minThickValue = checkMasterObj[0].MinValueThick,
                  maxThickValue = checkMasterObj[0].MaxValueThick,
                  AvgThickValue = checkMasterObj[0].AvgValueThick,
                  recSeqNoThick = 0
                var minDiamValue = checkMasterObj[0].MinValueDiam,
                  maxDiamValue = checkMasterObj[0].MaxValueDiam,
                  AvgDiamValue = checkMasterObj[0].AvgValueDiam,
                  recSeqNoDiam = 0
                var minBLValue = checkMasterObj[0].MinValueBL,
                  maxBLValue = checkMasterObj[0].MaxValueBL,
                  AvgBLValue = checkMasterObj[0].AvgValueBL,
                  recSeqNoBL = 0

                if (Number(DetailData[0].DataValueHard) !== 0 && masterData.RemarkHard.toLowerCase().includes("within")) {

                  if (masterHard === null) {
                    masterHard = await models.tbl_batchsummary_master7.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolHard,
                      Tol2Pos: masterData.T2PosTolHard,
                      MinValue: masterData.MinWeightHard,
                      MaxValue: masterData.MaxWeightHard,
                      AvgValue: masterData.AvgHard,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Department: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard != null ? masterData.NegTolHard : masterData.T2NegTolHard,
                      UppHard: masterData.PosTolHard != null ? masterData.PosTolHard : masterData.T2PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: checkSideMasterTable,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });

                    minHardValue = masterData.MinWeightHard
                    maxHardValue = masterData.MaxWeightHard
                    AvgHardValue = masterData.AvgHard
                    recSeqNoHard = 1

                  }
                  else {

                    var detailData = await models.tbl_batchsummary_detail7.findAll({
                      where: {
                        TestResult: 'Complies',
                        RepSerNo: masterHard.RepSerNo,
                      }
                    })

                    minHardValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightHard, masterData.MaxWeightHard]), 0).toFixed(0)
                    maxHardValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightHard, masterData.MaxWeightHard]), 0).toFixed(0)
                    AvgHardValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgHard]), 1).toFixed(1)
                    recSeqNoHard = detailData.length + 1

                    await models.tbl_batchsummary_master7.update({
                      MinValue: minHardValue,
                      MaxValue: maxHardValue,
                      AvgValue: AvgHardValue,
                      EndDate: moment().format("YYYY-MM-DD"),
                    }, {
                      where: {
                        RepSerNo: masterHard.RepSerNo,
                      }
                    });

                  }

                  await models['tbl_batchsummary_detail7'].create({
                    RepSerNo: masterHard.RepSerNo,
                    RecSeqNo: recSeqNoHard,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightHard,
                    Max: masterData.MaxWeightHard,
                    Avg: masterData.AvgHard,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                    SFOID: masterData.SFOID,
                    Repetition: masterData.Repetition
                  });

                }
                if (masterData.RemarkHard.toLowerCase().includes("within") ||
                  masterData.RemarkThick.toLowerCase().includes("within") ||
                  masterData.RemarkDiam.toLowerCase().includes("within") ||
                  masterData.RemarkBL.toLowerCase().includes("within")
                ) {
                  await models.tbl_batchsummary_masterhtd.update({
                    MinValueHard: minHardValue,
                    MaxValueHard: maxHardValue,
                    AvgValueHard: AvgHardValue,
                    // MinValueThick: minThickValue,
                    // MaxValueThick: maxThickValue,
                    // AvgValueThick: AvgThickValue,
                    // MinValueDiam: minDiamValue,
                    // MaxValueDiam: maxDiamValue,
                    // AvgValueDiam: AvgDiamValue,
                    // MinValueBL: minBLValue,
                    // MaxValueBL: maxBLValue,
                    // AvgValueBL: AvgBLValue,
                  }, {
                    where: {
                      RepSerNo: masterSrNo
                    }
                  })

                }
                Object.assign(responseObj, { status: 'success', remark: remark });
                return responseObj;
              }
            }
          } else {



            if (masterData.RemarkHard.toLowerCase().includes("within") &&
              masterData.RemarkThick.toLowerCase().includes("within") &&
              (masterData.RemarkBL.toLowerCase().includes("within") || masterData.RemarkBL.toLowerCase().includes('na'))
            ) {

              if (resultData[0].SrNo == null) {
                // let masterDataInsert = {
                //     str_tableName: 'tbl_batchsummary_master_hdlb',
                //     data: [
                //         { str_colName: 'BFGCode', value: masterData.BFGCode },
                //         { str_colName: 'ProductName', value: masterData.ProductName },
                //         { str_colName: 'PVersion', value: masterData.PVersion },
                //         { str_colName: 'Version', value: masterData.Version },
                //         { str_colName: 'PrdType', value: 1 },
                //         { str_colName: 'CubType', value: masterData.CubicleType },
                //         { str_colName: 'BatchNo', value: masterData.BatchNo },
                //         { str_colName: 'Stage', value: masterData.Stage },
                //         { str_colName: 'Dept', value: cubicalObj.Sys_dept },
                //         { str_colName: 'NomHard', value: masterData.NomHard },
                //         { str_colName: 'LwrHard', value: masterData.NegTolHard },
                //         { str_colName: 'UppHard', value: masterData.PosTolHard },
                //         { str_colName: 'UnitHard', value: masterData.Unit },
                //         { str_colName: 'NomThick', value: masterData.NomThick },
                //         { str_colName: 'LwrThick', value: masterData.NegTolThick },
                //         { str_colName: 'UppThick', value: masterData.PosTolThick },
                //         { str_colName: 'NomDLB', value: masterData.NomDOLOBO },
                //         { str_colName: 'LwrDLB', value: masterData.NegTolDOLOBO },
                //         { str_colName: 'UppDLB', value: masterData.PosTolDOLOBO },
                //         { str_colName: 'DLBParamName', value: masterData.ColHeadDOLOBO },
                //         { str_colName: 'Side', value: sideVal },
                //         { str_colName: 'BatchCompleted', value: masterData.BatchComplete[0] },
                //         { str_colName: 'IsArchived', value: masterData.IsArchived[0] },
                //         { str_colName: 'LimitOn', value: 0 }
                //     ]
                // }
                // let saveBatchSumm = await database.save(masterDataInsert);
                // masterSrNo = saveBatchSumm[0].insertId;

                if (masterData.RemarkHard.toLowerCase().includes("within") ||
                  masterData.RemarkThick.toLowerCase().includes("within") ||
                  masterData.RemarkDiam.toLowerCase().includes("within") ||
                  masterData.RemarkBL.toLowerCase().includes("within")
                ) {

                  const masterDataInsert = await models['tbl_batchsummary_masterhtd'].create({
                    Area: masterData.Area,
                    ReportType: masterData.ReportType,
                    CubicalNo: masterData.CubicalNo,
                    CubicleType: masterData.CubicleType,
                    BatchSize: masterData.BatchSize,
                    BLName: masterData.BLName,
                    TolNegHard: masterData.T2NegTolHard,
                    TolPosHard: masterData.T2PosTolHard,
                    TolNegThick: masterData.T2NegTolThick,
                    TolPosThick: masterData.T2PosTolThick,
                    TolNegDiam: masterData.T2NegTolDiam,
                    TolPosDiam: masterData.T2PosTolDiam,
                    TolNegBL: masterData.T2NegTolBL,
                    TolPosBL: masterData.T2PosTolBL,
                    TolNegActualHard: masterData.T3NegTolActualHard,
                    TolPosActualHard: masterData.T3PosTolActualHard,
                    TolNegActualThick: masterData.T3NegTolActualThick,
                    TolPosActualThick: masterData.T3PosTolActualThick,
                    TolPosActualDiam: masterData.T3NegTolActualDiam,
                    TolNegActualDiam: masterData.T3PosTolActualDiam,
                    TolNegActualBL: masterData.T3NegTolActualBL,
                    TolPosActualBL: masterData.T3PosTolActualBL,

                    NomHard: masterData.NomHard,
                    NomThick: masterData.NomThick,
                    NomDiam: masterData.NomDiam,
                    NomBL: masterData.NomBL,

                    MinValueHard: masterData.MinWeightHard,
                    MaxValueHard: masterData.MaxWeightHard,
                    AvgValueHard: masterData.AvgHard,

                    MinValueThick: masterData.MinWeightThick,
                    MaxValueThick: masterData.MaxWeightThick,
                    AvgValueThick: masterData.AvgThick,

                    MinValueDiam: masterData.MinWeightDiam,
                    MaxValueDiam: masterData.MaxWeightDiam,
                    AvgValueDiam: masterData.AvgDiam,

                    MinValueBL: masterData.MinWeightBL,
                    MaxValueBL: masterData.MaxWeightBL,
                    AvgValueBL: masterData.AvgBL,
                    StartDate: moment().format("YYYY-MM-DD"),
                    StartDateHard: moment().format("YYYY-MM-DD"),
                    EndDateHard: moment().format("YYYY-MM-DD"),
                    StartDateThick: moment().format("YYYY-MM-DD"),
                    EndDateThick: moment().format("YYYY-MM-DD"),
                    StartDateDiam: moment().format("YYYY-MM-DD"),
                    EndDateDiam: moment().format("YYYY-MM-DD"),
                    StartDateBL: moment().format("YYYY-MM-DD"),
                    EndDateBL: moment().format("YYYY-MM-DD"),
                    Unit: masterData.Unit,
                    BFGCode: masterData.BFGCode,
                    ProductName: masterData.ProductName,
                    PVersion: masterData.PVersion,
                    Version: masterData.Version,
                    PrdType: 1,
                    CubType: masterData.CubicleType,
                    BatchNo: masterData.BatchNo,
                    Stage: masterData.Stage,
                    Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                    NomHard: masterData.NomHard,
                    LwrHard: masterData.NegTolHard,
                    UppHard: masterData.PosTolHard,
                    UnitHard: masterData.Unit,
                    NomThick: masterData.NomThick,
                    LwrThick: masterData.NegTolThick,
                    UppThick: masterData.PosTolThick,
                    NomDLB: masterData.NomDOLOBO,
                    LwrDLB: masterData.NegTolDOLOBO,
                    UppDLB: masterData.PosTolDOLOBO,
                    // DLBParamName: masterData.ColHeadDOLOBO,
                    Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    Side: checkSideMasterTable,
                    BatchCompleted: 0,
                    IsArchived: 0,
                    LimitOn: 0
                  });

                  masterSrNo = masterDataInsert._previousDataValues.RepSerNo;

                }


                if (Number(DetailData[0].DataValueHard) !== 0 &&
                  masterData.RemarkHard.toLowerCase().includes("within")) {

                  if (masterHard === null) {
                    masterHard = await models.tbl_batchsummary_master7.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolHard,
                      Tol2Pos: masterData.T2PosTolHard,
                      MinValue: masterData.MinWeightHard,
                      MaxValue: masterData.MaxWeightHard,
                      AvgValue: masterData.AvgHard,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Department: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: checkSideMasterTable,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });
                  }

                  await models['tbl_batchsummary_detail7'].create({
                    RepSerNo: masterHard.RepSerNo,
                    RecSeqNo: recSeqNo,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    Min: masterData.MinWeightHard,
                    Max: masterData.MaxWeightHard,
                    Avg: masterData.AvgHard,
                    // MinDiam: MinDLB,
                    // MaxDiam: MaxDLB,
                    // AvgDiam: AvgDLB,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                    NoOfSample: masterData.Qty,
                    SFOID: masterData.SFOID,
                    Repetition: masterData.Repetition
                  });

                  await models['tbl_batchsummary_detailhtd'].create({
                    RepSerNo: masterSrNo,
                    RecSeqNo: recSeqNo,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    MinHard: masterData.MinWeightHard,
                    MaxHard: masterData.MaxWeightHard,
                    AvgHard: masterData.AvgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    // MinDiam: MinDLB,
                    // MaxDiam: MaxDLB,
                    // AvgDiam: AvgDLB,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: remark,
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                    NoOfSample: masterData.Qty
                  });

                }
                if (Number(DetailData[0].DataValueThick) !== 0 && masterData.RemarkThick.toLowerCase().includes("within")) {
                  if (masterThickness === null) {
                    masterThickness = await models.tbl_batchsummary_master3.create({

                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolThick,
                      Tol1Pos: masterData.T1PosTolThick,
                      Tol2Neg: masterData.T2NegTolThick,
                      Tol2Pos: masterData.T2PosTolThick,
                      MinValue: masterData.MinWeightThick,
                      MaxValue: masterData.MaxWeightThick,
                      AvgValue: masterData.AvgThick,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkThick.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });
                  }
                  await models['tbl_batchsummary_detail3'].create({
                    RepSerNo: masterThickness.RepSerNo,
                    RecSeqNo: recSeqNo,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    Min: masterData.MinWeightThick,
                    Max: masterData.MaxWeightThick,
                    Avg: masterData.AvgThick,
                    // MinDiam: MinDLB,
                    // MaxDiam: MaxDLB,
                    // AvgDiam: AvgDLB,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkThick.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });

                }
                if (masterData.BLName === "Diameter" && masterData.RemarkBL.toLowerCase().includes("within")) {
                  if (masterDiameter === null) {
                    masterDiameter = await models.tbl_batchsummary_master6.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolBL,
                      Tol2Pos: masterData.T2PosTolBL,
                      MinValue: masterData.MinWeightBL,
                      MaxValue: masterData.MaxWeightBL,
                      AvgValue: masterData.AvgBL,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });
                  }

                  await models['tbl_batchsummary_detail6'].create({
                    RepSerNo: masterDiameter.RepSerNo,
                    RecSeqNo: recSeqNo,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightBL,
                    Max: masterData.MaxWeightBL,
                    Avg: masterData.AvgBL,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });

                }
                if (masterData.BLName === "Length" && masterData.RemarkBL.toLowerCase().includes("within")) {

                  if (masterLength === null) {
                    masterLength = await models.tbl_batchsummary_master5.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolBL,
                      Tol2Pos: masterData.T2PosTolBL,
                      MinValue: masterData.MinWeightBL,
                      MaxValue: masterData.MaxWeightBL,
                      AvgValue: masterData.AvgBL,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });
                  }

                  await models['tbl_batchsummary_detail5'].create({
                    RepSerNo: masterLength.RepSerNo,
                    RecSeqNo: recSeqNo,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightBL,
                    Max: masterData.MaxWeightBL,
                    Avg: masterData.AvgBL,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });
                }

                // const objInsertDetailData = await models['tbl_batchsummary_detailhtd'].create({
                //     RepSerNo: masterSrNo,
                //     RecSeqNo: recSeqNo,
                //     Date: masterData.PrDate,
                //     Time: masterData.PrTime,
                //     InstrumentID: masterData.HardnessID,
                //     Side: sideVal,
                //     MinHard: MinHard,
                //     MaxHard: MaxHard,
                //     AvgHard: avgHard,
                //     MinThick: MinThick,
                //     MaxThick: MaxThick,
                //     AvgThick: AvgThick,
                //     MinDiam: MinDLB,
                //     MaxDiam: MaxDLB,
                //     AvgDiam: AvgDLB,
                //     MinBL: MinDLB,
                //     MaxBL: MaxDLB,
                //     AvgBL: AvgDLB,
                //     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                //     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                //     TestResult: remark,
                //     UserID: masterData.UserId,
                //     UserName: masterData.UserName,
                // });

                // const objInsertDetailData = {
                //     str_tableName: 'tbl_batchsummary_detail_hdlb',
                //     data: [
                //         { str_colName: 'RepSerNo', value: masterSrNo },
                //         { str_colName: 'RecSeqNo', value: recSeqNo },
                //         { str_colName: 'Date', value: masterData.PrDate },
                //         { str_colName: 'Time', value: masterData.PrTime },
                //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
                //         { str_colName: 'Side', value: sideVal },
                //         { str_colName: 'MinHard', value: MinHard },
                //         { str_colName: 'MaxHard', value: MaxHard },
                //         { str_colName: 'AvgHard', value: avgHard },
                //         { str_colName: 'MinThick', value: MinThick },
                //         { str_colName: 'MaxThick', value: MaxThick },
                //         { str_colName: 'AvgThick', value: AvgThick },
                //         { str_colName: 'MinDLB', value: MinDLB },
                //         { str_colName: 'MaxDLB', value: MaxDLB },
                //         { str_colName: 'AvgDLB', value: AvgDLB },
                //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
                //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
                //         { str_colName: 'TestResult', value: remark },
                //         { str_colName: 'UserID', value: masterData.UserId },
                //         { str_colName: 'UserName', value: masterData.UserName },

                //     ]
                // }
                // //console.log(objInsertDetailData);
                // let detailResult1 = await database.save(objInsertDetailData);

                Object.assign(responseObj, { status: 'success' })
                return responseObj;

              } else {
                var repSerNo = resultData[0].SrNo
                masterSrNo = resultData[0].SrNo;
                //     const checkDetailObj = {
                //         str_tableName: detailTable,
                //         data: 'MAX(RecSeqNo) AS SeqNo',
                //         condition: [
                //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
                //         ]
                //     }
                //    let detailres = await database.select(checkDetailObj);
                //         var seqNum = detailres[0][0].SeqNo;
                //         var seqNo = seqNum + 1;
                // const objInsertDetailData = {
                //     str_tableName: 'tbl_batchsummary_detail_hdlb',
                //     data: [
                //         { str_colName: 'RepSerNo', value: masterSrNo },
                //         { str_colName: 'RecSeqNo', value: recSeqNo },
                //         { str_colName: 'Date', value: masterData.PrDate },
                //         { str_colName: 'Time', value: masterData.PrTime },
                //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
                //         { str_colName: 'Side', value: sideVal },
                //         { str_colName: 'MinHard', value: MinHard },
                //         { str_colName: 'MaxHard', value: MaxHard },
                //         { str_colName: 'AvgHard', value: avgHard },
                //         { str_colName: 'MinThick', value: MinThick },
                //         { str_colName: 'MaxThick', value: MaxThick },
                //         { str_colName: 'AvgThick', value: AvgThick },
                //         { str_colName: 'MinDLB', value: MinDLB },
                //         { str_colName: 'MaxDLB', value: MaxDLB },
                //         { str_colName: 'AvgDLB', value: AvgDLB },
                //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
                //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
                //         { str_colName: 'TestResult', value: remark },
                //         { str_colName: 'UserID', value: masterData.UserId },
                //         { str_colName: 'UserName', value: masterData.UserName },
                //     ]
                // }
                // await database.save(objInsertDetailData);

                var minHardValue = checkMasterObj[0].MinValueHard,
                  maxHardValue = checkMasterObj[0].MaxValueHard,
                  AvgHardValue = checkMasterObj[0].AvgValueHard,
                  recSeqNoHard = 0
                var minThickValue = checkMasterObj[0].MinValueThick,
                  maxThickValue = checkMasterObj[0].MaxValueThick,
                  AvgThickValue = checkMasterObj[0].AvgValueThick,
                  recSeqNoThick = 0
                var minDiamValue = checkMasterObj[0].MinValueDiam,
                  maxDiamValue = checkMasterObj[0].MaxValueDiam,
                  AvgDiamValue = checkMasterObj[0].AvgValueDiam,
                  recSeqNoDiam = 0
                var minBLValue = checkMasterObj[0].MinValueBL,
                  maxBLValue = checkMasterObj[0].MaxValueBL,
                  AvgBLValue = checkMasterObj[0].AvgValueBL,
                  recSeqNoBL = 0

                if (Number(DetailData[0].DataValueHard) !== 0 && masterData.RemarkHard.toLowerCase().includes("within")) {

                  if (masterHard === null) {
                    masterHard = await models.tbl_batchsummary_master7.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolHard,
                      Tol2Pos: masterData.T2PosTolHard,
                      MinValue: masterData.MinWeightHard,
                      MaxValue: masterData.MaxWeightHard,
                      AvgValue: masterData.AvgHard,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Department: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: checkSideMasterTable,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0,

                    });

                    minHardValue = masterData.MinWeightHard
                    maxHardValue = masterData.MaxWeightHard
                    AvgHardValue = masterData.AvgHard
                    recSeqNoHard = 1

                  }
                  else {

                    var detailData = await models.tbl_batchsummary_detail7.findAll({
                      where: {
                        TestResult: 'Complies',
                        RepSerNo: masterHard.RepSerNo,
                      }
                    })

                    minHardValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightHard, masterData.MaxWeightHard]), 0).toFixed(0)
                    maxHardValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightHard, masterData.MaxWeightHard]), 0).toFixed(0)
                    AvgHardValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgHard]), 1).toFixed(1)
                    recSeqNoHard = detailData.length + 1

                    await models.tbl_batchsummary_master7.update({
                      MinValue: minHardValue,
                      MaxValue: maxHardValue,
                      AvgValue: AvgHardValue,
                      EndDate: moment().format("YYYY-MM-DD"),
                    }, {
                      where: {
                        RepSerNo: masterHard.RepSerNo,
                      }
                    });

                  }

                  await models['tbl_batchsummary_detail7'].create({
                    RepSerNo: masterHard.RepSerNo,
                    RecSeqNo: recSeqNoHard,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightHard,
                    Max: masterData.MaxWeightHard,
                    Avg: masterData.AvgHard,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkHard.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                    NoOfSample: masterData.Qty,
                    SFOID: masterData.SFOID,
                    Repetition: masterData.Repetition
                  });

                  // await models['tbl_batchsummary_detailhtd'].create({
                  //         RepSerNo: masterSrNo,
                  //         RecSeqNo: recSeqNo,
                  //         Date: masterData.PrDate,
                  //         Time: moment(masterData.PrTime).format("HH:mm:ss"),
                  //         InstrumentID: masterData.HardnessID,
                  //         Side: sideVal,
                  //         MinHard: masterData.MinWeightHard,
                  //         MaxHard: masterData.MaxWeightHard,
                  //         AvgHard: masterData.AvgHard,
                  //         // MinThick: MinThick,
                  //         // MaxThick: MaxThick,
                  //         // AvgThick: AvgThick,
                  //         // MinDiam: MinDLB,
                  //         // MaxDiam: MaxDLB,
                  //         // AvgDiam: AvgDLB,
                  //         // MinBL: MinDLB,
                  //         // MaxBL: MaxDLB,
                  //         // AvgBL: AvgDLB,
                  //         //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                  //         //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                  //         TestResult: remark,
                  //         UserID: masterData.UserId,
                  //         UserName: masterData.UserName,
                  // });

                } if (Number(DetailData[0].DataValueThick) !== 0 && masterData.RemarkThick.toLowerCase().includes("within")) {
                  if (masterThickness === null) {
                    masterThickness = await models.tbl_batchsummary_master3.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolThick,
                      Tol1Pos: masterData.T1PosTolThick,
                      Tol2Neg: masterData.T2NegTolThick,
                      Tol2Pos: masterData.T2PosTolThick,
                      MinValue: masterData.MinWeightThick,
                      MaxValue: masterData.MaxWeightThick,
                      AvgValue: masterData.AvgThick,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkThick.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });
                    minThickValue = masterData.MinWeightThick
                    maxThickValue = masterData.MaxWeightThick
                    AvgThickValue = masterData.AvgThick
                    recSeqNoThick = 1

                  } else {

                    var detailData = await models.tbl_batchsummary_detail3.findAll({
                      where: {
                        TestResult: 'Complies',
                        RepSerNo: masterThickness.RepSerNo,
                      }
                    })

                    minThickValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightThick, masterData.MaxWeightThick]), 2).toFixed(2)
                    maxThickValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightThick, masterData.MaxWeightThick]), 2).toFixed(2)
                    AvgThickValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgThick]), 3).toFixed(3)
                    recSeqNoThick = detailData.length + 1

                    await models.tbl_batchsummary_master3.update({
                      MinValue: minThickValue,
                      MaxValue: maxThickValue,
                      AvgValue: AvgThickValue,
                      EndDate: moment().format("YYYY-MM-DD"),
                    }, {
                      where: {
                        RepSerNo: masterThickness.RepSerNo,
                      }
                    });
                  }

                  await models['tbl_batchsummary_detail3'].create({
                    RepSerNo: masterThickness.RepSerNo,
                    RecSeqNo: recSeqNoThick,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    Min: masterData.MinWeightThick,
                    Max: masterData.MaxWeightThick,
                    Avg: masterData.AvgThick,
                    // MinDiam: MinDLB,
                    // MaxDiam: MaxDLB,
                    // AvgDiam: AvgDLB,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkThick.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });

                } if (masterData.BLName === "Diameter" && masterData.RemarkBL.toLowerCase().includes("within")) {
                  if (masterDiameter === null) {
                    masterDiameter = await models.tbl_batchsummary_master6.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolDiam,
                      Tol1Pos: masterData.T1PosTolDiam,
                      Tol2Neg: masterData.T2NegTolDiam,
                      Tol2Pos: masterData.T2PosTolDiam,
                      MinValue: masterData.MinWeightDiam,
                      MaxValue: masterData.MaxWeightDiam,
                      AvgValue: masterData.AvgDiam,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });

                    minDiamValue = masterData.MinWeightDiam
                    maxDiamValue = masterData.MaxWeightDiam
                    AvgDiamValue = masterData.AvgDiam
                    recSeqNoDiam = 1

                  } else {

                    var detailData = await models.tbl_batchsummary_detail6.findAll({
                      where: {
                        TestResult: 'Complies',
                        RepSerNo: masterDiameter.RepSerNo,
                      }
                    })

                    minDiamValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
                    maxDiamValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
                    AvgDiamValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgBL]), 3).toFixed(3)
                    recSeqNoDiam = detailData.length + 1

                    await models.tbl_batchsummary_master6.update({
                      MinValue: minDiamValue,
                      MaxValue: maxDiamValue,
                      AvgValue: AvgDiamValue,
                      EndDate: moment().format("YYYY-MM-DD"),
                    }, {
                      where: {
                        RepSerNo: masterDiameter.RepSerNo,
                      }
                    });

                  }
                  await models['tbl_batchsummary_detail6'].create({
                    RepSerNo: masterDiameter.RepSerNo,
                    RecSeqNo: recSeqNoDiam,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightBL,
                    Max: masterData.MaxWeightBL,
                    Avg: masterData.AvgBL,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });
                } if (masterData.BLName === "Length" && masterData.RemarkBL.toLowerCase().includes("within")) {

                  if (masterLength === null) {
                    masterLength = await models.tbl_batchsummary_master5.create({
                      Area: masterData.Area,
                      ReportType: masterData.ReportType,
                      CubicalNo: masterData.CubicalNo,
                      CubicleType: masterData.CubicleType,
                      BatchSize: masterData.BatchSize,
                      Tol1Neg: masterData.T1NegTolBL,
                      Tol1Pos: masterData.T1PosTolBL,
                      Tol2Neg: masterData.T2NegTolBL,
                      Tol2Pos: masterData.T2PosTolBL,
                      MinValue: masterData.MinWeightBL,
                      MaxValue: masterData.MaxWeightBL,
                      AvgValue: masterData.AvgBL,
                      StartDate: moment().format("YYYY-MM-DD"),
                      EndDate: moment().format("YYYY-MM-DD"),
                      DP: 3,
                      NomHard: masterData.NomHard,
                      NomThick: masterData.NomThick,
                      NomDiam: masterData.NomDiam,
                      NomBL: masterData.NomBL,
                      MinValueHard: masterData.MinWeightHard,
                      MaxValueHard: masterData.MaxWeightHard,
                      AvgValueHard: masterData.AvgHard,
                      MinValueThick: masterData.MinWeightThick,
                      MaxValueThick: masterData.MaxWeightThick,
                      AvgValueThick: masterData.AvgThick,
                      MinValueDiam: masterData.MinWeightDiam,
                      MaxValueDiam: masterData.MaxWeightDiam,
                      AvgValueDiam: masterData.AvgDiam,
                      MinValueBL: masterData.MinWeightBL,
                      MaxValueBL: masterData.MaxWeightBL,
                      AvgValueBL: masterData.AvgBL,
                      StartDateHard: moment().format("YYYY-MM-DD"),
                      EndDateHard: moment().format("YYYY-MM-DD"),
                      StartDateThick: moment().format("YYYY-MM-DD"),
                      EndDateThick: moment().format("YYYY-MM-DD"),
                      StartDateDiam: moment().format("YYYY-MM-DD"),
                      EndDateDiam: moment().format("YYYY-MM-DD"),
                      StartDateBL: moment().format("YYYY-MM-DD"),
                      EndDateBL: moment().format("YYYY-MM-DD"),
                      Unit: masterData.Unit,
                      BFGCode: masterData.BFGCode,
                      ProductName: masterData.ProductName,
                      PVersion: masterData.PVersion,
                      Version: masterData.Version,
                      PrdType: 1,
                      CubType: masterData.CubicleType,
                      BatchNo: masterData.BatchNo,
                      Stage: masterData.Stage,
                      Dept: cubicalObj.Sys_dept != null ? cubicalObj.Sys_dept : 'NA',
                      NomHard: masterData.NomHard,
                      LwrHard: masterData.NegTolHard,
                      UppHard: masterData.PosTolHard,
                      UnitHard: masterData.Unit,
                      NomThick: masterData.NomThick,
                      LwrThick: masterData.NegTolThick,
                      UppThick: masterData.PosTolThick,
                      NomDLB: masterData.NomDOLOBO,
                      LwrDLB: masterData.NegTolDOLOBO,
                      UppDLB: masterData.PosTolDOLOBO,
                      // DLBParamName: masterData.ColHeadDOLOBO,
                      Remark: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                      Side: sideVal,
                      BatchCompleted: 0,
                      IsArchived: 0,
                      LimitOn: 0
                    });

                    minBLValue = masterData.MinWeightBL
                    maxBLValue = masterData.MaxWeightBL
                    AvgBLValue = masterData.AvgBL
                    recSeqNoBL = 1

                  } else {

                    var detailData = await models.tbl_batchsummary_detail5.findAll({
                      where: {
                        TestResult: 'Complies',
                        RepSerNo: masterLength.RepSerNo,
                      }
                    })

                    minBLValue = mathj.round(mathj.min([...detailData.map(k => k.Min), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
                    maxBLValue = mathj.round(mathj.max([...detailData.map(k => k.Max), masterData.MinWeightBL, masterData.MaxWeightBL]), 2).toFixed(2)
                    AvgBLValue = mathj.round(mathj.mean([...detailData.map(k => k.Avg), masterData.AvgBL]), 3).toFixed(3)
                    recSeqNoBL = detailData.length + 1

                    await models.tbl_batchsummary_master5.update({
                      MinValue: minBLValue,
                      MaxValue: maxBLValue,
                      AvgValue: AvgBLValue,
                      EndDate: moment().format("YYYY-MM-DD"),
                    }, {
                      where: {
                        RepSerNo: masterLength.RepSerNo,
                      }
                    });
                  }
                  await models['tbl_batchsummary_detail5'].create({
                    RepSerNo: masterLength.RepSerNo,
                    RecSeqNo: recSeqNoBL,
                    Date: masterData.PrDate,
                    Time: moment(masterData.PrTime).format("HH:mm:ss"),
                    InstrumentID: masterData.HardnessID,
                    Side: sideVal,
                    // MinHard: MinHard,
                    // MaxHard: MaxHard,
                    // AvgHard: avgHard,
                    // MinThick: MinThick,
                    // MaxThick: MaxThick,
                    // AvgThick: AvgThick,
                    Min: masterData.MinWeightBL,
                    Max: masterData.MaxWeightBL,
                    Avg: masterData.AvgBL,
                    // MinBL: MinDLB,
                    // MaxBL: MaxDLB,
                    // AvgBL: AvgDLB,
                    //MinTimeDT': resultdata.incompleteData.T1PosTol ,
                    //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
                    TestResult: masterData.RemarkBL.toLowerCase().includes("within") == true ? 'Complies' : 'Not Complies',
                    UserID: masterData.UserId,
                    UserName: masterData.UserName,
                  });
                }

                if (masterData.RemarkHard.toLowerCase().includes("within") ||
                  masterData.RemarkThick.toLowerCase().includes("within") ||
                  masterData.RemarkDiam.toLowerCase().includes("within") ||
                  masterData.RemarkBL.toLowerCase().includes("within")
                ) {
                  await models.tbl_batchsummary_masterhtd.update({
                    MinValueHard: minHardValue,
                    MaxValueHard: maxHardValue,
                    AvgValueHard: AvgHardValue,
                    MinValueThick: minThickValue,
                    MaxValueThick: maxThickValue,
                    AvgValueThick: AvgThickValue,
                    MinValueDiam: minDiamValue,
                    MaxValueDiam: maxDiamValue,
                    AvgValueDiam: AvgDiamValue,
                    MinValueBL: minBLValue,
                    MaxValueBL: maxBLValue,
                    AvgValueBL: AvgBLValue,
                  }, {
                    where: {
                      RepSerNo: masterSrNo
                    }
                  })

                }

                // const objInsertDetailData = await models['tbl_batchsummary_detailhtd'].create({
                //     RepSerNo: masterSrNo,
                //     RecSeqNo: recSeqNo,
                //     Date: masterData.PrDate,
                //     Time: masterData.PrTime,
                //     InstrumentID: masterData.HardnessID,
                //     Side: sideVal,
                //     MinHard: MinHard,
                //     MaxHard: MaxHard,
                //     AvgHard: avgHard,
                //     MinThick: MinThick,
                //     MaxThick: MaxThick,
                //     AvgThick: AvgThick,
                //     MinDLB: MinDLB,
                //     MaxDLB: MaxDLB,
                //     AvgDLB: AvgDLB,
                //     //MinTimeDT: resultdata.incompleteData.T1PosTol ,
                //     //MaxTimeDT: resultdata.incompleteData.T2NegTol ,
                //     TestResult: remark,
                //     UserID: masterData.UserId,
                //     UserName: masterData.UserName,
                // });
                Object.assign(responseObj, { status: 'success', remark: remark });
                return responseObj;
              }
            }
          }
        }
      }
    } catch (error) {
      throw new Error(error)
    }
  }



}
module.exports = BatchSummary