const date = require('date-and-time')
const objMoment = require('moment');
const requestIp = require('request-ip');
const mysql = require('mysql2');
const sha1 = require('sha1');

const serverConfig = require('../../../../IncrencyV4DRLTSHConfig.json')
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE')
const Database = require('../../database/clsQueryProcess');
const timeZone = require('../../middleware/setTimeZone');
const clsQueryBuilder = require('../../database/clsQueryTransactProcess');
const globalData = require('../../global/globalData')
const clearArrModel = require('../clearGlobalArrays.model');
const clsActivityLog = require('../clsActivityLog.model');
const dbCon = require('../../../INTERFACE/global/dbCon');
const dbConfig = require('../../global/serverConfig');
const clsCommonOperation = require('../Product/clsCommonInsertOperation.model');
const clsCommonWeightment = require('../Product/clsCommonWeightment');
const clsHmi = require('../hmiDetail.model');
const { models } = require('../../../config/dbConnection');
const powerbckup = require('../../Utills/powerBackUp/powerbackup');
const ClearGlobalArrayModel = require('../clearGlobalArrays.model');
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();
const axios = require("axios");
const moment = require('moment');
const momentObj = require('moment');
const { Op } = require("sequelize");
const maths = require('mathjs')
const FormulaFunModel = require("../../model/Product/clsformulaFun.model");
const objformulaFun = new FormulaFunModel();
const ldapModule = require('../../model/ldapConnect.model');
const objldapModule = new ldapModule();
const clsCalculation = require('../clsCalculationOperation');
const ClassweighmentData = require('../clsProcessWeighment.model');
const clsWeighmentDataTransfer = require("../Product/clsWeighmentDataTransfer");
const Hmi = require('../hmiDetail.model');
const tbl_otherequipment = require('../../../../IncrencyV4_DRL_Model/models/Master/Instrument/Other/tbl_otherequipment');
const tbl_tab_initialdetailhtd_incomplete = require('../../../../IncrencyV4_DRL_Model/models/Report/Tablet/tbl_tab_initialdetailhtd_incomplete');
const { default: Null } = require('tedious/lib/data-types/null');
const { Console } = require('winston/lib/winston/transports');

const objPowerBackup = new powerbckup();
const database = new Database();
const ObjQueryBuilder = new clsQueryBuilder();
const objActivityLog = new clsActivityLog();
const objClearArr = new clearArrModel();
const objCommonOperation = new clsCommonOperation();
const objCommonWeightment = new clsCommonWeightment();
const objHmi = new clsHmi();
const objClearArray = new ClearGlobalArrayModel();
const objcalc = new clsCalculation();
const objWeighmentData = new ClassweighmentData();
const objWeighmentDataTransfer = new clsWeighmentDataTransfer();

// const connection = mysql.createConnection({
//     host: dbConfig.dbHost,
//     database: dbConfig.dbDatabase,
//     user: dbConfig.dbUserId,
//     password: dbConfig.dbPwd,
//     multipleStatements: true
// });

class LoginModal {
    async getDSInfo(req) {
        try {
            const DsNo = req.body.dsNo;
            const tabIp = req.body.tabIp;
            var data = await models.tbl_rpi.findAll({ where: { DS_NUMBER: DsNo } })
            var dataCubical = await models.tbl_cubical.findAll({
                where: {
                    Sys_DSNumber: DsNo,
                    [Op.or]: [
                        { Sys_Port1: { [Op.ne]: 'None' } },
                        { Sys_Port2: { [Op.ne]: 'None' } },
                        { Sys_Port3: { [Op.ne]: 'None' } },
                        { Sys_Port4: { [Op.ne]: 'None' } }
                    ],
                }
            })

            if (data.length == 0 || dataCubical.length == 0) return { status: 'fail', message: 'DS Not Configured' };

            if (data.length > 0) {
                let rpiData = data[data.length - 1];

                // ******** tbl_ds_binding **********

                // Update UserId in login, PortNo in menuStart
                // Destroy DS in unbindDS

                const [dsBind, created] = await models.tbl_ds_binding.findOrCreate({
                    where: { DS_NUMBER: rpiData.DS_NUMBER },
                    defaults: {
                        DS_NUMBER: rpiData.DS_NUMBER,
                        // TAB_IP: tabIp
                    }
                })

                let isUserPresent = objCommonOperation.isNullOrStringNull(dsBind.UserID);
                if (!created && !isUserPresent) { return { status: 'fail', message: 'DS No Already in use' } }

                if (created) {
                    data = dsBind.dataValues
                } else {
                    data = dsBind;
                }
                data.Sys_Area = dataCubical[0].Sys_Area
            }

            return { status: 'success', result: data };

        } catch (error) {
            console.log(error)
        }
    }

    // async getIDS(req) {
    //     try {
    //         var FullIp = requestIp.getClientIp(req);
    //         var rpiId = req.body.rpiId
    //         var data = await models.tbl_rpi.findAll({
    //             where: {
    //                 RPIID: rpiId
    //             }
    //         })

    //         var balId = await models.tbl_cubical.findAll({
    //             where:{
    //                 Sys_rpi: rpiId
    //             }
    //         })

    //         var balid = balId[0].Sys_BalID
    //         var moistid = balId[0].Sys_MoistID

    //         if(balid == undefined || moistid == undefined)
    //             return { status: 'fail', message: 'Instrument Not Configured', ip: FullIp };

    //         // if (data.length == 0 || data == undefined)
    //         //     return { status: 'fail', message: 'TSH Not Configured', ip: FullIp };

    //         // var dataCubical = await models.tbl_cubical.findAll({
    //         //     where: {
    //         //         Sys_rpi: data[0].RPIID
    //         //     }
    //         // })

    //         if (data.length == 0 || data == undefined)
    //             return { status: 'fail', message: 'TSH Not Configured', ip: FullIp };

    //         var strHmi = data[0].IDSNo;
    //         let arrusers = globalData.arrUsers.find(k => k.Hmi == strHmi);

    //         if (arrusers != undefined) {
    //             var userId = arrusers.UserId;
    //             var userName = arrusers.UserName;
    //             var Hmi = strHmi
    //             console.log("65-login.model.js -> blank source and active 0 -> userId", userId);
    //             let lastLoginDate = await timeZone.convertDateTime(new Date())

    //             await models.tbl_users.update({
    //                 active: 0,
    //                 source: '',
    //                 lstActvtyTime: lastLoginDate,
    //                 HostName: strHmi
    //             }, {
    //                 where: {
    //                     UserID: userId
    //                 }
    //             })

    //             await models.tbl_activity_log.create({
    //                 'dt': momentObj().format('YYYY-MM-DD'),
    //                 'tm': momentObj().format('HH:mm:ss'),
    //                 'userid': userId,
    //                 'username': userName,
    //                 'activity': `Power On/Off on TSH ${Hmi}`
    //             });

    //             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)
    //             if (!CurrentCubicalObj == undefined) {
    //                 await this.UnlockedWeighingStatus(CurrentCubicalObj.cubicalData.Sys_CubicNo)
    //             }
    //         }
    //         return { status: 'success', result: data, ip: FullIp, BalID: balId};
    //     } catch (error) {
    //         console.log(error)
    //     }
    // }

    async getIDS(req) {
        try {
            var FullIp = requestIp.getClientIp(req);
            var instruId = req.body.rpiId

            var cubicData = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: {
                        [Op.ne]: "NA"
                    },
                    Sys_rpi: {
                        [Op.ne]: "NULL"
                    },
                    Sys_ProductName: {
                        [Op.ne]: "NULL"
                    },
                    Sys_Version: {
                        [Op.ne]: "NA"
                    },
                    Sys_PVersion: {
                        [Op.ne]: "NA"
                    },
                    Sys_BFGCode: {
                        [Op.ne]: "NULL"
                    },
                    Sys_Batch: {
                        [Op.ne]: "NULL"
                    },
                    [Op.or]: [{ Sys_BalID: instruId }, { Sys_MoistID: instruId }]
                }
            })

            if (cubicData.length == 0 || cubicData == undefined)
                return { status: 'fail', message: 'Instrument Not Configured', ip: FullIp };

            var data = await models.tbl_rpi.findAll({
                where: {
                    RPIID: cubicData[0].Sys_rpi
                }
            })

            // if (data.length == 0 || data == undefined)
            //     return { status: 'fail', message: 'TSH Not Configured', ip: FullIp };

            // var dataCubical = await models.tbl_cubical.findAll({
            //     where: {
            //         Sys_rpi: data[0].RPIID
            //     }
            // })

            // if (data.length == 0 || data == undefined)
            //     return { status: 'fail', message: 'TSH Not Configured', ip: FullIp };

            var strHmi = data[0].IDSNo;

            let arrusers = globalData.arrUsers.find(k => k.Hmi == strHmi);

            if (arrusers != undefined) {

                var userId = arrusers.UserId;

                var userName = arrusers.UserName;

                var Hmi = strHmi
                console.log("65-login.model.js -> blank source and active 0 -> userId", userId);
                let lastLoginDate = await timeZone.convertDateTime(new Date())

                await models.tbl_users.update({
                    active: 0,
                    source: '',
                    lstActvtyTime: lastLoginDate,
                    HostName: ''
                }, {
                    where: {
                        UserID: userId
                    }
                })

                await models.tbl_activity_log.create({
                    'dt': momentObj().format('YYYY-MM-DD'),
                    'tm': momentObj().format('HH:mm:ss'),
                    'userid': userId,
                    'username': userName,
                    'activity': `Power On/Off on TSH ${Hmi}`
                });

                // await models.tbl_batch_log.create({
                //     dt: moment().format('YYYY-MM-DD'),
                //     tm: moment().format('HH:mm:ss'),
                //     userid: userId,
                //     username: userName,
                //     BatchNo: cubicObj.Sys_Batch,
                //     activity: `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_Eccent.Eccent_UserID}`
                // })

                let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)
                if (!CurrentCubicalObj == undefined) {
                    await this.UnlockedWeighingStatus(CurrentCubicalObj.cubicalData.Sys_CubicNo)
                }

            }

            return { status: 'success', result: data, ip: FullIp };

        } catch (error) {
            console.log(error)
        }
    }

    async communicationOff(val) {
        try {
            var dsNo = val.dsNo;
            var userId = val.userId
            var userName = val.userName
            var newDate = val.newDate
            var newTime = val.newTime

            await models.tbl_activity_log.create({
                'dt': newDate,
                'tm': newTime,
                'userid': userId,
                'username': userName,
                'activity': `Communication Off on DS ${dsNo}`
            });

            // await models.tbl_batch_log.create({
            //     dt: moment().format('YYYY-MM-DD'),
            //     tm: moment().format('HH:mm:ss'),
            //     userid: userId,
            //     username: userName,
            //     BatchNo: cubicObj.Sys_Batch,
            //     activity: `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_Eccent.Eccent_UserID}`
            // })

            return { status: 'success', result: "Validated" };

        } catch (error) {
            console.log(error)
        }
    }

    async loginApi(value) {
        var userId = value.userId;
        var userName = value.userName;
        var userPass = value.userPass;
        var tabIp = value.tabIp;
        var dsNo = value.dsNo;
        let responseObj = {};
        var source = 'Hardware';

        let isDsNoPresent = await models.tbl_ds_binding.findOne({ where: { DS_NUMBER: dsNo } })
        let isUserNull = true;
        if (isDsNoPresent) {
            isUserNull = objCommonOperation.isNullOrStringNull(isDsNoPresent.UserID);
        }
        if (!isDsNoPresent) {
            Object.assign(responseObj, { status: 'Fail' }, { result: 'DS is not configured' });
            return responseObj;
        }
        if (!isUserNull) {
            Object.assign(responseObj, { status: 'Fail' }, { result: 'DS is already in use' });
            return responseObj;
        }

        //To check if user have put correct user id 
        var user = await models.tbl_users.findAll({
            where: { userID: userId, }
        })
        var getParameter = await this.getParameterData();
        globalData.arrsAllParameters.push(getParameter);
        var now = new Date();

        // var ClientIp = value.Ip;
        // var ClientIp = Ip;
        // if (ClientIp === undefined) {
        //     ClientIp = '127.0.0.1';
        // } else {
        //     ClientIp = ClientIp;
        // }
        // var ip = ClientIp;
        if (serverConfig.isLDAP == true) {
            // var strReturnProtocol = await this.validateUserLDAP(userId, userPass, dsNo, ip);

            var strReturnProtocol = await this.validateUserLDAP(userId, userPass, source, tabIp, dsNo)
            if (!strReturnProtocol) {
                return { status: "Fail", result: "Something went wrong" }
            }
            if (strReturnProtocol.status == "success" && strReturnProtocol.result.match(/user added/gi) == null) {

                let tmpUserobj = globalData.arrUsers.find(k => k.TabIp == tabIp);

                console.log('User logged in ==>', tmpUserobj)

                await objMonit.monit({ case: 'Login', Hmi: dsNo, data: tmpUserobj });

            }
            return strReturnProtocol;
        }
        if (user.length == 0) {

            return { status: "Fail", result: "Incorrect User ID or Password" }
        }
        // var userActive = await models.tbl_users.update({ active: 1 }, { where: { userID: userId } })
        if (user[0] != undefined) {
            var data = user[0];
            // var userName = user[0].UserInitials;
            var userName = user[0].UserName;
            if (data.active == 1) { //active user msg 
                if (data.source == "Hardware") {
                    Object.assign(responseObj, { status: 'Fail' }, { result: `User is Already Active On TSH` });
                    return responseObj;
                } else {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User is Already Active On Software' }, { userName: userName });
                    return responseObj;
                }
            } else if ((data.locked == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
                return responseObj;
            } else if (data.realPassword !== userPass) {
                const auditUnauthorizedUser = await models.tbl_audit_unauthorized_user.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: userId,
                    username: user[0].UserName,
                    Host: tabIp
                });
                var addLoginAttampt = await this.addLoginAttamptValue(userId, "Hardware", userPass, tabIp); //Store Procedure 
                if (addLoginAttampt == 'success') {
                    addLoginAttampt = "Unauthorized user "
                }
                Object.assign(responseObj, { status: 'Fail' }, { result: addLoginAttampt }, { userName: userName })
                return responseObj;
            } else if ((data.Status == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'User Temporary Disabled, Contact Admin' }, { userName: userName })
                return responseObj;
            } else if ((data.Status == 2) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'User Permanent Disabled, Contact Admin' }, { userName: userName })
                return responseObj;
            } else if ((data.Status == 4) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'User Auto Disabled, Change Password' }, { userName: userName })
                return responseObj;
            } else if ((data.PwdExpStauts != 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
                return responseObj;
            } else if ((data.PwdExpStauts == 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'Suspicious Activity Found, Contact Admin' }, { userName: userName })
                return responseObj;
            } else if ((data.PwdChg == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'Please Change Your Password' }, { userName: userName })
                return responseObj;
            } else if ((data.PwdExpStauts == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                Object.assign(responseObj, { status: 'Fail' }, { result: 'Password Expired, Please Change Your Password' }, { userName: userName })
                return responseObj;
            } else if ((data.Role != "SuperAdmin") && (data.userType != 1)) {
                var getParameter = await this.getParameterData();
            } else {
                var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, dsNo, userName, tabIp);
                let objActivity = {};
                var tempUserObject = globalData.arrUsers.find(k => k.Hmi == dsNo);
                var objUpdateLoginData = await models.tbl_users.update({
                    active: 1,
                    HostName: `TSH-${dsNo}`,
                    source: 'HARDWARE',
                    LastLoginDt: moment().format('YYYY-MM-DD'),
                    lstActvtyTime: moment().format('YYYY-MM-DD HH:mm:ss')
                }, { where: { userID: userId } })

                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: 'Logged in on DS:' + " " + dsNo }
                );
                await objActivityLog.ActivityLogEntry(objActivity);
                getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;


            }
            var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, dsNo, userName, tabIp);
            if (Object.keys(getUserDetailData).length != 0) {
                let objActivity = {};
                var tempUserObject = globalData.arrUsers.find(k => k.TabIp == tabIp);

                var objUpdateLoginData = await models.tbl_users.update({
                    active: 1,
                    HostName: `TSH-${dsNo}`,
                    source: 'HARDWARE',
                    LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                    lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')

                },
                    { where: { UserID: userId } });

                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: 'Logged in on DS:' + " " + dsNo }
                );
                await objActivityLog.ActivityLogEntry(objActivity);
            }
            let timeout = await models.tbl_setallparameter.findAll();
            timeout = timeout[0].tbl_config_TimeoutPeriod;
            getUserDetailData.result.timeOut = timeout;
            return getUserDetailData;
            // }
        } else {
            console.log("User not Valid");
            return { status: "Fail", result: "Validate User on Software And Try Again" }
        }
    }

    async userManagement(userId, userPass, source, tabIp, time, dates) {
        try {
            let storedProcedureQuery = `CALL userManagement('${userId}','${userPass}','${source}','${tabIp}',@message,@userName);SELECT @message,@userName;`;
            var result = await sequelize.query(storedProcedureQuery, { type: QueryTypes.SELECT });
            Object.assign(result, { time: time, date: dates })
            return result;
        } catch (error) {
            console.log("Error : ", error);
        }
    }

    async addLoginAttamptValue(userId, source, userPass, tabIp) {
        try {
            var userManagementData = await this.userManagement(userId, source, userPass, tabIp);
            var message = userManagementData[1][0]['@message'];
            return message;
        } catch (error) {
            return error;
        }
    }

    async checkIfUserDataExist(userId, userPass, dsNo, userName, Ip) {
        try {
            var responseObj = {};
            const selectUserObj = await models.tbl_users.findAll({
                where: { UserID: userId, realPassword: userPass }
            })

            var result = selectUserObj;
            if (result[0] != undefined) {
                let data = [];
                data = result[0];
                const roleName = data.Role;
                var userName = data.UserName;
                // var userName = data.UserInitials;
                let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                var roleRights = await this.roleRight(roleName);
                var splRights = await this.splRight(userId);
                var removeRights = await this.removeRight(userId);
                for (let i = 0; i < roleRights.length; i++) {
                    allRoleRights.push(roleRights[i].role_rights)
                }
                for (let i = 0; i < splRights.length; i++) {
                    allSplRights.push(splRights[i].spl_right)
                }
                for (let i = 0; i < removeRights.length; i++) {
                    allRemoveRights.push(removeRights[i].removed_right)
                }

                var tmpUserobj = globalData.arrUsers.find(k => k.TabIp == tabIp);
                if (tmpUserobj == undefined) {
                    globalData.arrUsers.push({
                        DsNo: dsNo,
                        UserId: userId,
                        UserName: userName,
                        UserPass: userPass,
                        TabIp: tabIp,
                        Time: momentObj().format('HH:mm:ss')
                    });
                } else {
                    tmpUserobj.UserId = userId;
                    tmpUserobj.UserName = userName;
                    tmpUserobj.UserPass = userPass;
                    tmpUserobj.TabIp = tabIp;
                    tmpUserobj.Time = momentObj().format('HH:mm:ss')
                }
                await this.checkForRights(dsNo, userId, tabIp);

                const userCridentialDetail = {
                    DsNo: dsNo,
                    UserID: data.UserID,
                    UserName: data.UserName,
                    realPassword: data.realPassword,
                    TabIp: tabIp
                }

                Object.assign(responseObj, { status: 'success' }, { result: userCridentialDetail })

                return responseObj;
            } else {
                return false;
            }

        } catch (error) {
            return error;
        }
    }

    async roleRight(roleName) {
        var role = await models.tbl_role.findAll({
            where: { role_name: roleName }
        })
        return role;

    }

    async splRight(userId) {
        var right = await models.tbl_rights_special.findAll({ where: { userid: userId } })
        return right;

    }

    async removeRight(userId) {
        var remove_right = await models.tbl_rights_removed.findAll({ where: { userid: userId } })
        return remove_right;

    }

    async getParameterData() {
        try {
            const parameterObj = await models.tbl_setallparameter.findAll({
                where: {
                    config_id: 1
                }
            })
            if (parameterObj.length > 0) {
                var data = parameterObj[0];
                return data;
            } else {
                return false;
            }
        } catch (error) {
            return error;
        }
    }

    async checkForRights(strHmi, strUserId, Ip) {
        try {
            var arr_rights = [];
            let selectRole = await models.tbl_users.findAll({
                where: {
                    UserID: strUserId
                }
            })
            let roleResult = selectRole;
            let roleName = roleResult[0].Role;
            // For role Rights
            let selectRights = await models.tbl_role.findAll({
                where: {
                    role_name: roleName,
                    locked: 0
                }
            })

            let roleRights = selectRights;

            arr_rights = arr_rights.concat(roleRights).map(k => k.role_rights);
            // For special rights
            let selectSpecialRights = await models.tbl_rights_special.findAll({
                where: {
                    userid: strUserId,

                }
            })

            let specialRights = selectSpecialRights;
            let tempSplArr = specialRights.map(k => k.spl_right)
            arr_rights = arr_rights.concat(tempSplArr);
            // For remove rights
            let selectRemoveRights = await models.tbl_rights_removed.findAll({
                where: {
                    userid: strUserId,

                }
            })
            let removeRights = selectRemoveRights;
            let tempRmvArr = removeRights.map(k => k.removed_right);

            let tempRightObj = globalData.arrUserRights.find(t => t.Ip == Ip);
            if (tempRightObj == undefined) {
                globalData.arrUserRights.push({
                    Hmi: strHmi,
                    DsNo: strHmi,
                    rights: arr_rights,
                    splRights: specialRights,
                    removeRights: tempRmvArr,
                    Ip: Ip,
                    TabIp: Ip,
                    UserID: strUserId
                });
            } else {
                tempRightObj.rights = arr_rights;
                tempRightObj.splRight = specialRights;
                tempRightObj.removeRight = tempRmvArr;
                tempRightObj.Ip = Ip
                tempRightObj.TabIp = Ip
                tempRightObj.UserID = strUserId

            }
            return 1;
        } catch (error) {
            throw new Error(error)
        }
    }

    async logout(value) {
        try {
            var dsNo = value.dsNo;
            var userName = value.userName;
            var userId = value.userId;
            var autoLogout = value.autoLogout;
            var tabIp = value.tabIp

            await models.tbl_cubical.update({
                Sys_WeighmentInProcess: 0,
                Sys_CalibInProcess: 0
            }, { where: { Sys_DSNumber: dsNo } })
            var objUpdateLoginData = await models.tbl_users.update({
                active: 0,
                HostName: '',
                source: '',
                lstActvtyTime: momentObj().format('YYYY-MM-DD HH:mm:ss')
            }, {
                where: {
                    UserId: userId
                }
            })
            let objUpdateDsBind = await models.tbl_ds_binding.update({ UserID: null, PortNo: null, MenuName: null, TAB_IP: null }, { where: { DS_NUMBER: dsNo } })

            var msg = '';
            (autoLogout) ? msg = `Auto Logout from DS ${dsNo}` : msg = `Logged out on DS: ${dsNo}`

            await models.tbl_activity_log.create({
                dt: momentObj().format('YYYY-MM-DD'),
                tm: momentObj().format('HH:mm:ss'),
                userid: userId,
                username: userName,
                activity: msg
            })

            // await models.tbl_batch_log.create({
            //     dt: moment().format('YYYY-MM-DD'),
            //     tm: moment().format('HH:mm:ss'),
            //     userid: userId,
            //     username: userName,
            //     BatchNo: cubicObj.Sys_Batch,
            //     activity: `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_Eccent.Eccent_UserID}`
            // })

            await models.tbl_users.update(
                { active: 0 }, {
                where: {
                    UserID: userId
                }
            })
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.TabIp == tabIp && k.DsNo == dsNo)
            if (CurrentCubicalObj != undefined) {
                await this.UnlockedWeighingStatus(CurrentCubicalObj.cubicalData.Sys_Batch);
            }

            let mesData = await models.tbl_mes_data.findAll({ where: { DS_NUMBER: dsNo, isSetInCubical: 1, isTestCompleted: 1 } })
            if (mesData.length > 0) {
                globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == dsNo), 1)
                await models.tbl_mes_data.destroy({ where: { DS_Number: dsNo, isSetInCubical: 1, isTestCompleted: 1 } })
                console.log(globalData.MESArray)
            }

            globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.Ip == tabIp) == -1
                ? globalData.dataMoist
                : globalData.dataMoist.splice(
                    globalData.dataMoist.findIndex((k) => k.DsNo == dsNo && k.Ip == tabIp),
                    1
                );

            globalData.arrSelectedBalWithHmi = globalData.arrSelectedBalWithHmi.filter((k) => k.DsNo != dsNo && k.TabIp != tabIp)

            var result = { status: "success", message: 'User logout Successfully.' }
            await objClearArray.clearDetails(dsNo, true);
            await objMonit.monit({ case: 'Logout', Hmi: dsNo });
            console.log(`${userName} logout Successfully from DS ${dsNo}`)
            return result;
        }
        catch (error) {
            console.log(error)
            throw new Error(error);
        }
    }

    async loginMain(userId, userPass, source, Ip, strHmi) {
        try {

            var now = new Date();
            const response = await axios.post(
                `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/loginMain`,
                {
                    userId: userId,
                    userPass: userPass,
                    source: source,
                    hmi: `${strHmi}`,
                }
            );

            strHmi = strHmi.split('-')[1]
            if (response != undefined) {
                if (response.data != undefined) {
                    if (response.data.data != undefined) {
                        var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                        if (tmpUserobj == undefined) {
                            globalData.arrUsers.push({
                                Hmi: strHmi,
                                UserName: response.data.userName,
                                UserId: response.data.data.UserID,
                                UserPass: response.data.data.realPassword
                            });
                        } else {
                            var index = globalData.arrUsers.findIndex(k => k.Hmi == strHmi);
                            globalData.arrUsers[index].userName = response.data.userName,
                                globalData.arrUsers[index].userId = response.data.data.UserID,
                                globalData.arrUsers[index].userPass = response.data.data.realPassword;
                        }
                    }
                }
            }

            return response.data
        } catch (error) {
            console.log(error)
            return "Api connection close"
        }
    }

    // async ApiLogin(data) {

    async getLDAPUserData(strUserName, strHmi) {
        try {
            let arrRes = await models.tbl_users.findAll({
                where: {
                    UserName: strUserName
                }
            })
            let configSetting = await this.getParameterData()
            const timeOut = configSetting.tbl_config_TimeoutPeriod
            arrRes[0].timeOut = timeOut;
            await this.checkForRights(strHmi, arrRes[0].UserID)
            return arrRes[0];
        } catch (error) {
            throw new Error(error)
        }
    }

    async getHmi(hmi) {
        try {
            let arrRes = await models.tbl_rpi.findAll({
                where: {
                    RPIID: hmi,
                }
            });
            if (arrRes[0] == undefined) {
                return arrRes[0];
            } else {
                return arrRes[0].IDSNo;
            }
        } catch (error) {
            throw new Error(error)
        }
    }

    async powerbackup(data) {
        try {
            var responseObj = {}
            await objClearArray.clearDetails(data.dsNo, false);
            var user = await models.tbl_users.findAll({ where: { userID: data.userId } })
            var tmpUserobj = globalData.arrUsers.find(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
            if (tmpUserobj == undefined) {
                globalData.arrUsers.push({
                    DsNo: data.dsNo,
                    UserName: user[0].UserInitials,
                    UserId: user[0].UserID,
                    UserPass: user[0].realPassword,
                    TabIp: data.tabIp

                });
            } else {
                var index = globalData.arrUsers.findIndex(k => k.DsNo == data.dsNo);
                globalData.arrUsers[index].TabIp = data.tabIp;
                globalData.arrUsers[index].userName = user[0].UserInitials,
                    globalData.arrUsers[index].userId = data.userId;
                globalData.arrUsers[index].userPass = user[0].realPassword

            }

            var tmpUserRightobj = globalData.arrUserRights.find(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
            if (tmpUserRightobj == undefined) {

                await this.checkForRights(data.dsNo, user[0].UserID, data.tabIp)
            } else {
                tmpUserRightobj.rights = tmpUserRightobj.rights;
                tmpUserRightobj.splRight = tmpUserRightobj.splRights;
                tmpUserRightobj.removeRights = tmpUserRightobj.removeRights;

            }
            tmpUserobj = globalData.arrUsers.find(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
            var userRights = globalData.arrUserRights.find(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp)

            let flag = 0;
            if (userRights) {
                for (let i = 0; i < userRights.rights.length; i++) {
                    if (userRights.rights[i].includes('Test')) {
                        flag = 1
                        break;
                    }
                }
            }


            if (!flag) return { status: 'Success', message: 'Test Right Not Assigned' }

            //monit
            await objMonit.monit({ case: 'Login', Hmi: data.Hmi, data: tmpUserobj });

            let arr = []
            var powerbcup = await objPowerBackup.chkPowerBackupPresent1(data);
            if (typeof (powerbcup) == 'object') {
                for (let obj in powerbcup) {
                    if (powerbcup[obj] != null) {
                        if (arr.length == 0) {
                            arr.push({ [`${obj}`]: powerbcup[obj] })
                            // await models.tbl_activity_log.create({
                            //     dt: momentObj().format('YYYY-MM-DD'),
                            //     tm: momentObj().format('HH:mm:ss'),
                            //     userid: data.userId,
                            //     username: user[0].UserInitials,
                            //     activity: "Powered On TSH" + ' ' + data.Hmi
                            // })
                        } else {
                            arr[0][obj] = powerbcup[obj]
                        }
                    }
                }

                powerbcup = arr[0]
            } else {
                powerbcup = powerbcup
            }

            Object.assign(responseObj, { status: 'success' }, { result: powerbcup })

            return responseObj;
        } catch (error) {

        }
    }

    async UnlockedWeighingStatus(Batch) {
        try {
            await models.tbl_system_weighingstatus.update({
                Status: 0,
                BatchNo: "NULL",
                CubType: "NULL"
            }, {
                where: {
                    BatchNo: Batch,
                }
            })
        } catch (error) {
            console.log(error)
        }
    }

    async discardPowerBackup(values) {
        try {
            let { dsNo, userId, userName, menuName, tabIp } = values;
            let activityMsg;
            let side;

            menuName = decodeURI(menuName)

            let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
            let pbMenu = (menuName == GLOBAL_NOMENCLATURE.Friability) ? GLOBAL_NOMENCLATURE.FriabilatorMenu : menuName

            const powerbackupEntry = await models.tbl_powerbackup.findAll({ where: { DsNo: dsNo, TabIp: tabIp, WeighmentName: pbMenu } })

            // Calibration Discard
            if (powerbackupEntry.length > 0) {
                if (powerbackupEntry[0].WeighmentType != 'NULL') {
                    if (powerbackupEntry[0].WeighmentType == "Calib") {
                        let objActivity = {};
                        Object.assign(
                            objActivity,
                            { strUserId: userId },
                            { strUserName: userName },
                            { activity: `${menuName} Calibration Discarded on TSH ${dsNo}` }
                        );

                        await objActivityLog.ActivityLogEntry(objActivity);
                        console.log("Calibration Discarded")
                    }
                }


                if ((cubicObj.Sys_RptType == 1 || cubicObj.Sys_RptType == 0)) {
                    var menuSequenceTable = await models.tbl_menu_sequence.findOne({
                        attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'TabIp'] },
                        where: {
                            DS_Number: dsNo,
                            TabIp: tabIp
                        }
                    })
                    if (menuSequenceTable != null) {
                        let menuSeqMenuName = objCommonWeightment.getDbMenuSeqFromMenu(menuName);
                        let handleExceptionData = await this.handleExceptionData(cubicObj, menuName, dsNo, tabIp, menuSequenceTable.RepSerNo);
                        // let menuArr = [GLOBAL_NOMENCLATURE.Hardness,
                        //     GLOBAL_NOMENCLATURE.IndividualMenu,
                        //     GLOBAL_NOMENCLATURE.LockedLength,
                        //     GLOBAL_NOMENCLATURE.Differential,
                        //     GLOBAL_NOMENCLATURE.FriabilatorMenu,
                        //     GLOBAL_NOMENCLATURE.Friability
                        // ]
                        // if (menuArr.includes(menuName)) {
                        //     let eqpdetail = await models.tbl_otherequipment.findOne({
                        //         where: {
                        //             Eqp_ID: cubicObj.Sys_HardID
                        //         }
                        //     })

                        //     if ((!(menuName == GLOBAL_NOMENCLATURE.Hardness && globalData.FTPHardnessModel.includes(eqpdetail?.model))) && menuArr.includes(menuName)) {

                        //         let detailTable
                        //         if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu) {
                        //             detailTable = 'tbl_tab_initialdetail1_incomplete'
                        //         } else if (menuName == GLOBAL_NOMENCLATURE.LockedLength) {
                        //             detailTable = 'tbl_tab_initialdetail5_incomplete'
                        //         } else if (menuName == GLOBAL_NOMENCLATURE.Differential) {
                        //             detailTable = 'tbl_tab_initialdetail3_incomplete'
                        //         } else if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                        //             detailTable = 'tbl_tab_initialdetailhtd_incomplete'
                        //         }else if(menuName == GLOBAL_NOMENCLATURE.Friability){
                        //             detailTable = 'tbl_tab_initialdetail8_incomplete'
                        //         }
                        //         let key = menuName == GLOBAL_NOMENCLATURE.Hardness ? 'isTerminated' : 'isCompleted'
                        //         detailTable = powerbackupEntry[0]?.ProductType == 2 ? detailTable.replace("tab", "cap") : detailTable
                        //         await models[detailTable].update({
                        //             [key]: 1
                        //         }, {
                        //             where: {
                        //                 RepSerNo: menuSequenceTable.RepSerNo
                        //             }
                        //         })


                        //     }
                        // }
                        // objPowerBackup.updateTerminatedFlag(menuName, powerbackupEntry[0], cubicObj)
                        await models.tbl_menu_sequence.update({ [menuSeqMenuName]: 0 }, { where: { DS_Number: dsNo, TabIp: tabIp } })
                    }
                    // if (menuSequenceTable != null) {
                    //     for (let keys in menuSequenceTable) {
                    //         if (keys == 'RepSerNo') continue;
                    //         if (menuSequenceTable[keys] == 1) {
                    //             let menuName = objCommonWeightment.getMenuNmFromMenuSeq(keys);
                    //             let handleExceptionData = await this.handleExceptionData(cubicObj, menuName, dsNo, tabIp, menuSequenceTable.RepSerNo);
                    //         }
                    //     }
                    // let handleExceptionData = await this.handleExceptionData(cubicObj, menuName, dsNo, tabIp, menuSequenceTable.RepSerNo);
                    // await models.tbl_menu_sequence.destroy({ where: { DS_Number: dsNo, TabIp: tabIp } })
                    // }
                } else {
                    if (powerbackupEntry.length > 0) {
                        let pbRepSerNo = powerbackupEntry[0].Incomp_RepSerNo;
                        let handleExceptionData = await this.handleExceptionData(cubicObj, menuName, dsNo, tabIp, pbRepSerNo);
                        if (powerbackupEntry[0].WeighmentType != 'NULL') {
                            let mastertTbl = 'tbl_tab_initialmaster_incomplete'
                            mastertTbl = powerbackupEntry[0].ProductType == 2 ? mastertTbl.replace("tab", "cap") : mastertTbl

                            let masterIncompleteData = await models.tbl_tab_initialmaster_incomplete.findOne({
                                where: {
                                    RepSerNo: pbRepSerNo
                                }
                            })
                            activityMsg = (menuName == GLOBAL_NOMENCLATURE.Hardness) ? `Thickness & ${menuName}` : menuName;
                            side = (masterIncompleteData.Side != 'NA') ? masterIncompleteData.Side : '';
                            activityMsg += `Test Terminated on DS ${dsNo} for side ${side}`
                            await models.tbl_activity_log.create({
                                'dt': momentObj().format('YYYY-MM-DD'),
                                'tm': momentObj().format('HH:mm:ss'),
                                'userid': userId,
                                'username': userName,
                                'activity': activityMsg
                            });

                            await models.tbl_batch_log.create({
                                dt: moment().format('YYYY-MM-DD'),
                                tm: moment().format('HH:mm:ss'),
                                userid: userId,
                                username: userName,
                                BatchNo: cubicObj.Sys_Batch,
                                activity: activityMsg
                            })
                        }
                    }
                }
            }
            await models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp } })

            //clear arrays related to counter and test
            globalData.arrWeighmentCounter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrWeighmentCounter :
                globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            (globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
                globalData.arrCurrentOperationStatus :
                globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

            (globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
                globalData.arrWeighmentCounterAfter :
                globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

            (globalData.arrProtocolData.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
                globalData.arrProtocolData :
                globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

            (globalData.arrOutFlagForTest.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
                globalData.arrOutFlagForTest :
                globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

            globalData.arrSelectedMenu.findIndex(k => k.DsNo == dsNo) == -1 ?
                globalData.arrSelectedMenu :
                globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            (globalData.HardnessMasterEntry.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
                globalData.HardnessMasterEntry :
                globalData.HardnessMasterEntry.splice(globalData.HardnessMasterEntry.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

            (globalData.DoubSide.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
                globalData.DoubSide :
                globalData.DoubSide.splice(globalData.DoubSide.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

            (globalData.arrside.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
                globalData.arrside :
                globalData.arrside.splice(globalData.arrside.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

            globalData.arrPushValuesOfHardness.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrPushValuesOfHardness :
                globalData.arrPushValuesOfHardness.splice(globalData.arrPushValuesOfHardness.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            globalData.arrsampleno.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrsampleno :
                globalData.arrsampleno.splice(globalData.arrsampleno.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            globalData.arrHardnessMT50.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrHardnessMT50 :
                globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            globalData.formatching.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.formatching :
                globalData.formatching.splice(globalData.formatching.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrWeighmentCounterForFriab :
                globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
                globalData.arrWeighmentCounterAfter :
                globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

            return {
                status: 'success',
                result: "Successfully Discarded Previous Test"
            }

        } catch (error) {
            console.log(error);
        }
    }

    async handleExceptionData(cubicObj, menuName, dsNo, tabIp, menuSeqRepSerNo) {
        try {
            let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp)
            let getLimitsObj = objCommonWeightment.getLimitsObj(getTableName.typeValue, cubicObj.Sys_RptType)
            let masterTableIncomplete = getTableName.masterTableIncomplete;
            let detailTableIncomplete = getTableName.detailTableIncomplete;
            let detailTableFailed = getTableName.detailTableFailed
            let masterTableFailed = getTableName.masterTableFailed


            var masterIncompleteData = await models[masterTableIncomplete].findAll({ where: { RepSerNo: menuSeqRepSerNo } })
            for (const key in getLimitsObj) {
                getLimitsObj[key] = getLimitsObj[key].replace('htd', '7')
            }
            await models[masterTableIncomplete].update(
                {
                    Inprocess: 0,
                    // IntervalStopTm: momentObj().format('YYYY-MM-DD HH:mm:ss'),
                    // PrEndDate: momentObj().format("YYYY-MM-DD"),
                    // PrEndTime: momentObj().format("HH:mm:ss"),
                    // [getLimitsObj.PrEndDate]: momentObj().format("YYYY-MM-DD"),
                    // [getLimitsObj.PrEndTime]: momentObj().format("HH:mm:ss"),
                    [getLimitsObj.FailRemark]: "Terminated test",
                    isTerminated: 1
                }, {
                where: {
                    RepSerNo: menuSeqRepSerNo,
                }
            });


            let  incompleteMasterDataObject = this.convertDateTimeIntoString(masterIncompleteData[0],getLimitsObj,1)

            // let instrumentIdArr = ['HardnessID', 'BalanceId', 'FriabilityID', 'DTID', 'VernierId']
            // for (let key in masterIncompleteData[0]) {
            //     if (key.includes('Time')) {
            //         masterIncompleteData[0][key] = momentObj(masterIncompleteData[0][key]).format('HH:mm:ss')

            //     } else if (key.includes('Date')) {
            //         masterIncompleteData[0][key] = momentObj(masterIncompleteData[0][key]).format("YYYY-MM-DD")
            //     } else if (instrumentIdArr.includes(key)) {
            //         if (key != getLimitsObj.instrumentId) {
            //             masterIncompleteData[0][key] = null

            //         }
            //     }

            // }
            incompleteMasterDataObject.IntervalStopTm = momentObj().format('YYYY-MM-DD HH:mm:ss'),
                incompleteMasterDataObject.PrEndDate = momentObj().format("YYYY-MM-DD"),
                incompleteMasterDataObject.PrEndTime = momentObj().format("HH:mm:ss"),
                incompleteMasterDataObject[getLimitsObj.PrEndDate] = momentObj().format("YYYY-MM-DD"),
                incompleteMasterDataObject[getLimitsObj.PrEndTime] = momentObj().format("HH:mm:ss")
                delete incompleteMasterDataObject.RepSerNo;

                let deleteParamsRegex = /^Param\d+_Pr(?:EndDate|Time|Date)$/
                let paramTypeValue = (getTableName.typeValue).toString()
                paramTypeValue = paramTypeValue.replaceAll('htd','7')
                for (const key in incompleteMasterDataObject) {
                    if (deleteParamsRegex.test(key) && !key.includes(paramTypeValue) ){
                        delete incompleteMasterDataObject[key]
                    }else if(['AvgNet','MaxWeight','MinWeight'].includes(key)){
                        delete incompleteMasterDataObject[key]
                    }

                    
                }
                
                
               
               
                

                let detailWhereCondition = {
                RepSerNo: menuSeqRepSerNo,
                BatchNo: incompleteMasterDataObject.BatchNo,
                Repetition: incompleteMasterDataObject.Repetition,
                SFOID: incompleteMasterDataObject.SFOID
            }

            if (menuName == GLOBAL_NOMENCLATURE.Friability) {
                detailWhereCondition.isException = 0
            }
            let getIncompleteData = await models[detailTableIncomplete].findAll({
                where: detailWhereCondition
            })

            let failedException = getIncompleteData.filter(item => item.isException == 1)


            if (menuName == GLOBAL_NOMENCLATURE.GroupMenu && cubicObj.Sys_Area != 'Coating') {
                // let exceptionResult = await objWeighmentDataTransfer.moveToExceptionTable(menuSeqRepSerNo, menuName, masterIncompleteData[0], failedException, cubicObj.Sys_RptType, 1)
                // if (exceptionResult == "success") {
                //     await models[detailTableIncomplete].destroy({ where: { RepSerNo: menuSeqRepSerNo, isException: 1 } })
                // }
            } else if (getIncompleteData.length > 0 && menuName != GLOBAL_NOMENCLATURE.DTTest && menuName != GLOBAL_NOMENCLATURE.DTMenu) {

                

                let failedmasterData = await models[masterTableFailed].create(incompleteMasterDataObject)

                getIncompleteData.map(async (item) => {
                    if (item.isException == 0) {
                        item.RepSerNo = failedmasterData._previousDataValues.RepSerNo
                        if (menuName == GLOBAL_NOMENCLATURE.Friability) {
                            item.AfterValue = 'NA'
                            item.NetValue = 'NA'
                        }
                        Object.keys(item).map(key => {
                            if (key.includes('Time')) {
                                item[key] = momentObj(item[key]).format('HH:mm:ss')
                            } else if (key.includes('Date')) {
                                item[key] = momentObj(item[key]).format("YYYY-MM-DD")
                            }
                        })

                        await models[detailTableFailed].create(item)


                    }
                })




                if (failedException.length > 0) {
                    let exceptionResult = await objWeighmentDataTransfer.moveToTerminatedExceptionTable(failedmasterData._previousDataValues.RepSerNo, menuName, incompleteMasterDataObject, failedException, cubicObj.Sys_RptType, 1)
                }

                await models[detailTableIncomplete].destroy({ where: detailWhereCondition })
            }

            return

        } catch (err) {
            console.log(err);
        }
    }


    // Discarded Powerbackup
    // async discardPowerBackup(values) {
    //     try {
    //         let { dsNo, userId, userName, menuName, tabIp } = values;
    //         menuName = decodeURI(menuName)
    //         let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
    //         if (menuName == GLOBAL_NOMENCLATURE.Friability) menuName = GLOBAL_NOMENCLATURE.FriabilatorMenu
    //         const Entry = await models.tbl_powerbackup.findAll({ where: { DsNo: dsNo, TabIp: tabIp, WeighmentName: menuName } })

    //         console.log(menuName, "discared")
    //         if (Entry.length > 0) {
    //             if (Entry[0].WeighmentType != 'NULL')
    //                 if (Entry[0].WeighmentType == "Calib") {
    //                     let objActivity = {};
    //                     Object.assign(
    //                         objActivity,
    //                         { strUserId: userId },
    //                         { strUserName: userName },
    //                         { activity: `${menuName} Calibration Discarded on TSH ${dsNo}` }
    //                     );

    //                     await objActivityLog.ActivityLogEntry(objActivity);
    //                     console.log("Calibration Discarded")
    //                     models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp } })
    //                     // await objPowerBackup.moveCalibrationIncompleteToFail(Hmi)
    //                 }
    //         }

    //         if (Entry.length > 0) {
    //             console.log("Discarded")
    //             await models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp, WeighmentName: menuName } })
    //             let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp)
    //             var masterTable = getTableName.masterTable;
    //             var detailTable = getTableName.detailTable;
    //             var detailTableIncomplete = getTableName.detailTableIncomplete;
    //             var masterTableIncomplete = getTableName.masterTableIncomplete;

    //             if (Entry[0].ReportType == 1) {
    //                 let getLimitsObj = objCommonWeightment.getLimitsObj(getTableName.typeValue, Entry[0].ReportType)
    //                 await models[masterTableIncomplete].update(
    //                     {
    //                         Inprocess: 0,
    //                         [getLimitsObj.PrEndDate]: momentObj().format("YYYY-MM-DD"),
    //                         [getLimitsObj.PrEndTime]: momentObj().format("HH:mm:ss"),
    //                         [getLimitsObj.FailRemark]: "Terminated test"
    //                         // PrEndDate: momentObj().format("YYYY-MM-DD"),
    //                         // PrEndTime: momentObj().format("HH:mm:ss"),
    //                         // FailedRemark: "Terminated test"
    //                     }, {
    //                     where: {
    //                         RepSerNo: Entry[0].Incomp_RepSerNo,
    //                     }
    //                 });

    //                 await models.tbl_menu_sequence.destroy({ where: { DS_Number: dsNo, TabIp: tabIp } })
    //                 var act = `${menuName} Terminated on DS ${dsNo}`
    //                 // if (dsNoDetails.Side != 'NA') {
    //                 //     var act = `${menuName} Test Discarded on DS ${dsNo} for side ${dsNoDetails.Side}`
    //                 // }
    //                 await models.tbl_activity_log.create({
    //                     'dt': momentObj().format('YYYY-MM-DD'),
    //                     'tm': momentObj().format('HH:mm:ss'),
    //                     'userid': userId,
    //                     'username': userName,
    //                     'activity': act
    //                 });

    //                 await models.tbl_batch_log.create({
    //                     dt: moment().format('YYYY-MM-DD'),
    //                     tm: moment().format('HH:mm:ss'),
    //                     userid: userId,
    //                     username: userName,
    //                     BatchNo: cubicObj.Sys_Batch,
    //                     activity: act
    //                 })

    //                 await models.tbl_powerbackup.destroy({ where: { DsNo: dsNo, TabIp: tabIp } })
    //             } else {
    //                 if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.ThicknessMenu || menuName == GLOBAL_NOMENCLATURE.LengthMenu) {
    //                     // let objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
    //                     // if (objSelMenu.selectedProductDetail.isonstd == true) {
    //                     //     let unitObj = objWeighmentData.getUnitObj(menuName);
    //                     //     await objcalc.calculation_operation_new(Entry[0].Incomp_RepSerNo, masterTableIncomplete, detailTableIncomplete, null, unitObj);

    //                     // var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })
    //                     // var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })

    //                     // objSelMenu.selectedProductDetail.nominal = get_Datavalue1[0].AvgValue;

    //                     // var Nominal = objSelMenu.selectedProductDetail.nominal;
    //                     // Nominal = Number(Nominal).toFixed(2);

    //                     // var typeValue = 1;
    //                     // var maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
    //                     // var maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T2');
    //                     // var minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
    //                     // var minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

    //                     // var DataValue_arr = [];

    //                     // get_Datavalue1[0].NoOfBelowT1 = 0;
    //                     // get_Datavalue1[0].NoOfAboveT1 = 0;
    //                     // get_Datavalue1[0].NoOfBelowT2 = 0;
    //                     // get_Datavalue1[0].NoOfAboveT2 = 0;

    //                     // DataValue_arr.push(get_Datavalue);
    //                     // var arr = [];
    //                     // for (var i = 0; i < get_Datavalue.length; i++) {
    //                     //     var a = get_Datavalue[i].DataValue;

    //                     //     if (Number(a) < Number(minLimitT2)) {
    //                     //         get_Datavalue1[0].NoOfBelowT2 = Number(get_Datavalue1[0].NoOfBelowT2) + 1;
    //                     //     } else if (Number(a) > Number(maxLimitT2)) {
    //                     //         get_Datavalue1[0].NoOfAboveT2 = Number(get_Datavalue1[0].NoOfAboveT2) + 1;
    //                     //     }
    //                     //     if (maxLimitT1 != 0 && minLimitT1 != 0) {
    //                     //         if (Number(a) < Number(minLimitT1) && Number(a) >= Number(minLimitT2)) {
    //                     //             get_Datavalue1[0].NoOfBelowT1 = Number(get_Datavalue1[0].NoOfBelowT1) + 1;
    //                     //         } else if (Number(a) > Number(maxLimitT1) && Number(a) <= Number(maxLimitT2)) {
    //                     //             get_Datavalue1[0].NoOfAboveT1 = Number(get_Datavalue1[0].NoOfAboveT1) + 1;
    //                     //         }
    //                     //     }

    //                     //     arr.push(Number(a));
    //                     //     console.log(arr);
    //                     //     var max_value = maths.max(arr);
    //                     //     max_value = max_value.toFixed(1);
    //                     //     var min_value = maths.min(arr);
    //                     //     min_value = min_value.toFixed(1);
    //                     //     var std_value = maths.std(arr);
    //                     //     std_value = std_value.toFixed(2);
    //                     //     var total = arr.reduce((acc, total) => {
    //                     //         return Number(total) + Number(acc);
    //                     //     }, 0)
    //                     //     var avg = total / arr.length
    //                     //     avg = maths.abs(avg).toFixed(1);
    //                     //     var minPer_value = ((Nominal - min_value) / Nominal) * 100;
    //                     //     minPer_value = maths.abs(minPer_value).toFixed(2)
    //                     //     var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
    //                     //     maxPer_value = maths.abs(maxPer_value).toFixed(2)

    //                     //     // console.log();
    //                     //     console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
    //                     //     // return arr;

    //                     //     var get_Datavalue11 = await models[master_tableName].update({
    //                     //         AvgValue: avg,
    //                     //         MinValue: min_value,
    //                     //         MaxValue: max_value,
    //                     //         // StdDev: std_value,
    //                     //         MinPer: minPer_value,
    //                     //         MaxPer: maxPer_value,
    //                     //         NoOfAboveT1: get_Datavalue1[0].NoOfAboveT1,
    //                     //         NoOfAboveT2: get_Datavalue1[0].NoOfAboveT2,
    //                     //         NoOfBelowT1: get_Datavalue1[0].NoOfBelowT1,
    //                     //         NoOfBelowT2: get_Datavalue1[0].NoOfBelowT2,
    //                     //         T1NegTol: Number(minLimitT1).toFixed(1),
    //                     //         T1PosTol: Number(maxLimitT1).toFixed(1),
    //                     //         T2NegTol: Number(minLimitT2).toFixed(1),
    //                     //         T2PosTol: Number(maxLimitT2).toFixed(1),
    //                     //     }, { where: { RepSerNo: Entry[0].Incomp_RepSerNo } });
    //                     // }
    //                     // }
    //                     await models[masterTableIncomplete].update(
    //                         {
    //                             IsProcess: 0,
    //                             PrEndDate: momentObj().format("YYYY-MM-DD"),
    //                             PrEndTime: momentObj().format("HH:mm:ss"),
    //                             FailedRemark: "Terminated test"
    //                         }, {
    //                         where: {
    //                             RepSerNo: Entry[0].Incomp_RepSerNo,
    //                         }
    //                     }
    //                     );
    //                     var dsNoDetails = await models[masterTableIncomplete].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })
    //                     var detailTable = await models[detailTableIncomplete].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo, isException: 1 } })
    //                     if (detailTable.length > 0) {
    //                         let result = await objWeighmentDataTransfer.moveToExceptionTable(Entry[0].Incomp_RepSerNo, menuName, dsNoDetails[0], detailTable, cubicObj.Sys_RptType)
    //                         if (result == "success") {
    //                             await models[detailTableIncomplete].destroy({ where: { RepSerNo: Entry[0].Incomp_RepSerNo, isException: 1 } })
    //                         }
    //                     }
    //                 } else if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
    //                     await models.tbl_tab_masterhtd_incomplete.update(
    //                         {
    //                             IsProcess: 0,
    //                             PrEndDate: momentObj().format("YYYY-MM-DD"),
    //                             PrEndTime: momentObj().format("HH:mm:ss"),
    //                             FailedRemark: "Terminated test"
    //                         }, {
    //                         where: {
    //                             RepSerNo: Entry[0].Incomp_RepSerNo,
    //                         }
    //                     }
    //                     );
    //                     var dsNoDetails = await models.tbl_tab_masterhtd_incomplete.findAll({
    //                         where: {
    //                             RepSerNo: Entry[0].Incomp_RepSerNo,
    //                         }
    //                     })
    //                 } else if (menuName == GLOBAL_NOMENCLATURE.Friability || menuName == 'FRIAB') {
    //                     var dsNoDetails = await models.tbl_tab_master8.findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })
    //                 }
    //                 dsNoDetails = dsNoDetails[0]
    //                 //for calibration
    //                 if (Entry[0].WeighmentType != 'NULL') {
    //                     //for weighment
    //                     if (menuName != GLOBAL_NOMENCLATURE.Hardness) {
    //                         var act = `${menuName} Test Terminated on DS ${dsNo}`
    //                         if (dsNoDetails.Side != 'NA') {
    //                             var act = `${menuName} Test Terminated on DS ${dsNo} for side ${dsNoDetails.Side}`
    //                         }
    //                         await models.tbl_activity_log.create({
    //                             'dt': momentObj().format('YYYY-MM-DD'),
    //                             'tm': momentObj().format('HH:mm:ss'),
    //                             'userid': userId,
    //                             'username': userName,
    //                             'activity': act
    //                         });

    //                         // await models.tbl_batch_log.create({
    //                         //     dt: moment().format('YYYY-MM-DD'),
    //                         //     tm: moment().format('HH:mm:ss'),
    //                         //     userid: userId,
    //                         //     username: userName,
    //                         //     BatchNo: cubicObj.Sys_Batch,
    //                         //     activity: `Periodic Calibration Terminated on TSH ${Hmi} of user ${check_Eccent.Eccent_UserID}`
    //                         // })

    //                         await models.tbl_batch_log.create({
    //                             dt: moment().format('YYYY-MM-DD'),
    //                             tm: moment().format('HH:mm:ss'),
    //                             userid: userId,
    //                             username: userName,
    //                             BatchNo: cubicObj.Sys_Batch,
    //                             activity: act
    //                         })

    //                     } else {
    //                         var act = `Thickness & ${menuName} Test Terminated on DS ${dsNo}`
    //                         if (dsNoDetails.Side != 'NA') {
    //                             var act = `Thickness & ${menuName} Test Terminated on DS ${dsNo} for side ${dsNoDetails.Side}`
    //                         }
    //                         await models.tbl_activity_log.create({
    //                             'dt': momentObj().format('YYYY-MM-DD'),
    //                             'tm': momentObj().format('HH:mm:ss'),
    //                             'userid': userId,
    //                             'username': userName,
    //                             'activity': act
    //                         });

    //                         await models.tbl_batch_log.create({
    //                             dt: moment().format('YYYY-MM-DD'),
    //                             tm: moment().format('HH:mm:ss'),
    //                             userid: userId,
    //                             username: userName,
    //                             BatchNo: cubicObj.Sys_Batch,
    //                             activity: act
    //                         })
    //                     }
    //                 }
    //             }
    //         } else {

    //             var act = `${menuName} Terminated on DS ${dsNo}`
    //             // if (dsNoDetails.Side != 'NA') {
    //             //     var act = `${menuName} Test Discarded on DS ${dsNo} for side ${dsNoDetails.Side}`
    //             // }
    //             await models.tbl_activity_log.create({
    //                 'dt': momentObj().format('YYYY-MM-DD'),
    //                 'tm': momentObj().format('HH:mm:ss'),
    //                 'userid': userId,
    //                 'username': userName,
    //                 'activity': act
    //             });

    //             await models.tbl_batch_log.create({
    //                 dt: moment().format('YYYY-MM-DD'),
    //                 tm: moment().format('HH:mm:ss'),
    //                 userid: userId,
    //                 username: userName,
    //                 BatchNo: cubicObj.Sys_Batch,
    //                 activity: act
    //             })
    //         }

    //         //clear arrays related to counter and test

    //         globalData.arrWeighmentCounter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
    //             globalData.arrWeighmentCounter :
    //             globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         (globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
    //             globalData.arrCurrentOperationStatus :
    //             globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

    //         (globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
    //             globalData.arrWeighmentCounterAfter :
    //             globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

    //         (globalData.arrProtocolData.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp)) == -1 ?
    //             globalData.arrProtocolData :
    //             globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((k) => k.DsNo === dsNo && k.TabIp == tabIp), 1);

    //         (globalData.arrOutFlagForTest.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
    //             globalData.arrOutFlagForTest :
    //             globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

    //         globalData.arrSelectedMenu.findIndex(k => k.DsNo == dsNo) == -1 ?
    //             globalData.arrSelectedMenu :
    //             globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         (globalData.HardnessMasterEntry.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
    //             globalData.HardnessMasterEntry :
    //             globalData.HardnessMasterEntry.splice(globalData.HardnessMasterEntry.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

    //         (globalData.DoubSide.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
    //             globalData.DoubSide :
    //             globalData.DoubSide.splice(globalData.DoubSide.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

    //         (globalData.arrside.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp)) == -1 ?
    //             globalData.arrside :
    //             globalData.arrside.splice(globalData.arrside.findIndex((element) => element.DsNo === dsNo && element.TabIp == tabIp), 1);

    //         globalData.arrPushValuesOfHardness.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
    //             globalData.arrPushValuesOfHardness :
    //             globalData.arrPushValuesOfHardness.splice(globalData.arrPushValuesOfHardness.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         globalData.arrsampleno.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
    //             globalData.arrsampleno :
    //             globalData.arrsampleno.splice(globalData.arrsampleno.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         globalData.arrHardnessMT50.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
    //             globalData.arrHardnessMT50 :
    //             globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         globalData.formatching.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp) == -1 ?
    //             globalData.formatching :
    //             globalData.formatching.splice(globalData.formatching.findIndex(k => k.DsNo == dsNo && k.TabIp == tabIp), 1);

    //         return {
    //             status: 'success',
    //             result: "Successfully Discarded Previous Test"
    //         }

    //     } catch (error) {
    //         console.log(error);
    //     }
    // }

    //LDAP LOGIN
    async validateUserLDAP(userId, userPass, source, tabIp, dsNo) {
        try {
            let dt = new Date();
            let now = new Date();
            let user = await models.tbl_users.findAll({
                where: {
                    UserID: userId,
                },
            });

            // if (user[0] == undefined) {
            //     console.log("User not Valid");
            //     let obj = {
            //         status: "fail",
            //         result: "Incorrect User ID Or Password",
            //     };
            //     return obj;
            // }
            // if (user[0].realPassword == "VALIDATED") {
            //     let username = user[0].UserName;
            //     var UserInitial = user[0].UserInitials
            //     let obj = { username, userPass };
            //     const responses = await axios.post(
            //         `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/ldap/validate`,
            //         {
            //             strUserName: username,
            //             strPassword: userPass,
            //             // source: source,
            //             // ip : `IDS-${dsNo}`
            //         }
            //     );
            //     // if (responses.data.response == "Authenticated") {
            //     //     const response = await axios.post(
            //     //         `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/loginMain`,
            //     //         {
            //     //             user: userId,
            //     //             userId: userId,
            //     //             userPass: "VALIDATED",
            //     //             //  username:userName,
            //     //             source: "Hardware",
            //     //             // ip: `${dsNo}`,
            //     //         }
            //     //     );

            //     //     // }
            //     //     if (response.data.result == 'User Already Active On Software') {
            //     //         let obj = {
            //     //             status: "Fail",
            //     //             result: 'User Already Active On Software',
            //     //         };
            //     //         return obj;
            //     //     }
            //     //     if (response.data.result == "Please Change Your Password") {
            //     //         response.data.result = response.data.data;
            //     //         response.data.data.active = 1;
            //     //         let user = await models.tbl_users.update(
            //     //             {
            //     //                 active: 1,
            //     //             },
            //     //             {
            //     //                 where: {
            //     //                     UserID: userId,
            //     //                 },
            //     //             }
            //     //         );
            //     //         await models.tbl_activity_log.create({
            //     //             dt: date.format(now, "YYYY-MM-DD"),
            //     //             tm: date.format(now, "HH:mm:ss"),
            //     //             userid: userId,
            //     //             username: UserInitial,
            //     //             activity: 'Logged in on TSH:' + " " + dsNo
            //     //         });
            //     //     }
            //     //     if (response.data.result == "User Temporary Disabled, Contact Admin" || response.data.result == "User Locked, Please contact Admin") {
            //     //         response.data.result = "User Disabled Contact Authorized Person";
            //     //     }
            //     //     if (response.data.result == "Password Expired, Please Change Your Password") {
            //     //         response.data.result = response.data.data;
            //     //         response.data.result.active = 1;
            //     //         let user = await models.tbl_users.update(
            //     //             {
            //     //                 active: 1,
            //     //             },
            //     //             {
            //     //                 where: {
            //     //                     UserID: userId,
            //     //                 },
            //     //             }
            //     //         );
            //     //         await models.tbl_activity_log.create({
            //     //             dt: date.format(now, "YYYY-MM-DD"),
            //     //             tm: date.format(now, "HH:mm:ss"),
            //     //             userid: userId,
            //     //             username: UserInitial,
            //     //             activity: 'Logged in on TSH:' + " " + dsNo
            //     //         });
            //     //     }

            //     //     if (response != undefined) {
            //     //         if (
            //     //             response.data.result.active != undefined ||
            //     //             response.data.active == 1
            //     //         ) {
            //     //             if (response.data.result.active == 1) {
            //     //                 var tmpUserobj = globalData.arrUsers.find(
            //     //                     (k) => k.Hmi == dsNo
            //     //                 );
            //     //                 if (tmpUserobj == undefined) {
            //     //                     globalData.arrUsers.push({
            //     //                         Hmi: dsNo,
            //     //                         UserId: userId,
            //     //                         UserName: response.data.result.UserInitials,
            //     //                         UserPass: userPass,
            //     //                     });
            //     //                 } else {
            //     //                     tmpUserobj.UserId = userId;
            //     //                     (tmpUserobj.UserName = response.data.result.UserInitials),
            //     //                         (tmpUserobj.UserPass = userPass);
            //     //                 }

            //     //                 var tmpUserRightobj = globalData.arrUserRights.find(
            //     //                     (k) => k.Hmi == dsNo
            //     //                 );
            //     //                 if (tmpUserRightobj == undefined) {
            //     //                     globalData.arrUserRights.push({
            //     //                         Hmi: dsNo,
            //     //                         rights: response.data.result.rights.concat(
            //     //                             response.data.result.splRights
            //     //                         ),
            //     //                         splRights: response.data.result.splRights,
            //     //                         removeRights: response.data.result.removeRights,
            //     //                     });
            //     //                 } else {
            //     //                     tmpUserRightobj.rights = response.data.result.rights.concat(
            //     //                         response.data.result.splRights
            //     //                     );
            //     //                     (tmpUserRightobj.splRight = response.data.result.splRights),
            //     //                         (tmpUserRightobj.removeRight =
            //     //                             response.data.result.removeRights);
            //     //                 }
            //     //             }
            //     //         }
            //     //     }
            //     //     if (response.data.result.active != undefined || response.data.active == 1) {
            //     //     }
            //     //     let timeout = await models.tbl_setallparameter.findAll();
            //     //     timeout = timeout[0].tbl_config_TimeoutPeriod;
            //     //     response.data.timeOut = timeout;
            //     //     console.log(response);
            //     //     let obj = {
            //     //         status: "success",
            //     //         timeOut: response.data.timeOut,
            //     //         userName: response.data.result.UserInitials,
            //     //         result: response.data.result,
            //     //     };
            //     //     return obj;
            //     // }
            //     if (responses.data.response == "Authenticated failed") {
            //         let obj = {
            //             status: "fail",
            //             result: "Incorrect User ID Or Password",
            //         };
            //         return obj;
            //     }
            //     var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == dsNo);
            //     //monit
            //     // await objMonit.monit({ case: 'Login', Hmi: dsNo, data: tmpUserobj });
            // } else {
            //     console.log("User not Valid");
            //     let obj = {
            //         status: "fail",
            //         result: "Validate User on Software And Try Again",
            //     };
            //     return obj;
            // }

            //login03/06/23 start
            if (user[0]?.realPassword == 'VALIDATED' || user.length == 0) {
                //If user pass is validated then check for ldap validation
                const responses = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/ldap/validate`, {
                    strUserName: userId,
                    strPassword: userPass,
                    req: dsNo,
                    source: 'HARDWARE'
                })
                //If user is authenticated then login
                if (responses.data.response == 'Authenticated') {
                    const checkuser = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/chkUserActive`, {
                        userId: userId
                    });
                    //active validation
                    if (checkuser.data.result.active == 1) {
                        var msg = 'User Already Active on Software';
                        return { status: "fail", result: msg }
                    } else {
                        var response = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/validateUser`, {
                            userId: userId,
                            user: userId,
                            strUserName: user[0].UserInitials,
                            // userPass: 'VALIDATED',
                            source: 'HARDWARE',
                            hmi: `${dsNo}`,
                            ip: `TSH-${dsNo}`,

                        });
                        if (response.data.result == "User Validated Successfully") {
                            var right = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/checkuserstatusLds`, {
                                user: userId,
                            });
                            var checkuseractive = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/chkUserActive`, {
                                userId: userId
                            });
                            //user array and rights array push here
                            if (checkuseractive.data.result.active == 1) {
                                var tmpUserobj = globalData.arrUsers.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
                                if (tmpUserobj == undefined) {
                                    globalData.arrUsers.push({
                                        DsNo: dsNo,
                                        UserId: userId,
                                        UserName: checkuseractive.data.result.UserInitials,
                                        UserPass: userPass,
                                        TabIp: tabIp
                                    });
                                } else {
                                    tmpUserobj.DsNo = dsNo;
                                    tmpUserobj.UserId = userId;
                                    tmpUserobj.UserName = checkuseractive.data.result.UserInitials,
                                        tmpUserobj.UserPass = userPass;
                                    tmpUserobj.TabIp = tabIp
                                }

                                var tmpUserRightobj = globalData.arrUserRights.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
                                if (tmpUserRightobj == undefined) {
                                    globalData.arrUserRights.push({
                                        DsNo: dsNo,
                                        TabIp: tabIp,
                                        rights: right.data.result[1].rights.concat(right.data.result[2].splRights),
                                        splRights: right.data.result[2].splRights,
                                        removeRights: right.data.result[3].removeRights
                                    });
                                } else {
                                    tmpUserRightobj.DsNo = dsNo,
                                        tmpUserRightobj.rights = right.data.result[1].rights.concat(right.data.result[2].splRights);
                                    tmpUserRightobj.splRight = right.data.result[2].splRights,
                                        tmpUserRightobj.removeRight = right.data.result[3].removeRights
                                }
                                // let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);

                                // if (CurrentCubicalObj == undefined) {
                                //     CurrentCubicalObj = await models.tbl_cubical.findAll({
                                //         where: {
                                //             Sys_IDSNo: strHmi
                                //         }
                                //     })
                                //     globalData.arrIdsInfo.push({
                                //         Hmi: strHmi,
                                //         respbi: CurrentCubicalObj[0].Sys_rpi,
                                //         cubicalData: CurrentCubicalObj[0]
                                //     })
                                // } else {
                                //     CurrentCubicalObj = CurrentCubicalObj.cubicalData;
                                // }

                                let user = await models.tbl_users.update({
                                    source: "HARDWARE",
                                    HostName: `TSH-${dsNo}`
                                }, {
                                    where: {
                                        UserID: userId,
                                    },
                                });

                                let updateDsBind = await models.tbl_ds_binding.update({ UserID: userId, TAB_IP: tabIp }, { where: { DS_NUMBER: dsNo } })
                                tmpUserobj = globalData.arrUsers.find(k => k.DsNo == dsNo);
                                await objMonit.monit({ case: 'Login', Hmi: dsNo, data: tmpUserobj });
                            }

                        } else {
                            var msg = 'User Already Active on Software';
                            return { status: "fail", result: msg }
                        }
                    }
                    // console.log(checkuser);
                    // if (checkuser.data.result[0].active == 0) {
                    //If user is locked or temporary disabled
                    // if (response.data.result == 'User Temporary Disabled, Contact Admin' || response.data.result == 'User Locked, Please contact Admin') {
                    //     response.data.result = 'User Disabled. Contact Authorized Person'
                    // }
                    //
                    // if (response != undefined) {
                    //     if (response.data.result.active != undefined || response.data.active == 1) {
                    //         if (response.data.result.active == 1) {
                    //             var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                    //             if (tmpUserobj == undefined) {
                    //                 globalData.arrUsers.push({
                    //                     Hmi: strHmi,
                    //                     userId: userId,
                    //                     userName: response.data.result.UserInitials,
                    //                     userPass: userPass,
                    //                 });
                    //             } else {
                    //                 tmpUserobj.userId = userId;
                    //                 tmpUserobj.userName = response.data.result.UserInitials,
                    //                     tmpUserobj.userPass = userPass;
                    //             }

                    //             var tmpUserRightobj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
                    //             if (tmpUserRightobj == undefined) {
                    //                 globalData.arrUserRights.push({
                    //                     Hmi: strHmi,
                    //                     rights: response.data.result.rights.concat(response.data.result.splRights),
                    //                     splRights: response.data.result.splRights,
                    //                     removeRights: response.data.result.removeRights
                    //                 });
                    //             } else {
                    //                 tmpUserRightobj.rights = response.data.result.rights.concat(response.data.result.splRights);
                    //                 tmpUserRightobj.splRight = response.data.result.splRights,
                    //                     tmpUserRightobj.removeRight = response.data.result.removeRights;
                    //             }
                    //             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);

                    //             if (CurrentCubicalObj == undefined) {
                    //                 CurrentCubicalObj = await models.tbl_cubical.findAll({
                    //                     where: {
                    //                         Sys_IDSNo: strHmi
                    //                     }
                    //                 })
                    //                 globalData.arrIdsInfo.push({
                    //                     Hmi: strHmi,
                    //                     respbi: CurrentCubicalObj[0].Sys_rpi,
                    //                     cubicalData: CurrentCubicalObj[0]
                    //                 })
                    //             } else {
                    //                 CurrentCubicalObj = CurrentCubicalObj.cubicalData;
                    //             }
                    //             tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                    //             await objMonit.monit({ case: 'Login', Hmi: strHmi, data: tmpUserobj });

                    //         }
                    //     }
                    // }

                    let timeout = await models.tbl_setallparameter.findAll()
                    timeout = timeout[0].tbl_config_TimeoutPeriod
                    response.data.timeOut = timeout
                    console.log(response);
                    console.log(response.data);
                    let obj = {
                        status: "success",
                        timeOut: response.data.timeOut,
                        userName: checkuseractive.data.result.UserInitials,
                        userId: userId,
                        result: response.data.result,
                    }
                    return obj
                } else if (responses.data.response == 'Authenticated failed') {
                    const auditUnauthorizedUser = await models.tbl_audit_unauthorized_user.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: userId,
                        username: user[0]?.UserName ?? '',
                        Host: tabIp
                    });
                    return { status: "fail", result: "Incorrect User ID or Password" }
                } else {
                    return { status: responses.data.status, result: responses.data.response }
                }
                //If user is not authenticated then 
                if (responses.data.response == 'Authenticated failed') {
                    return { status: "fail", result: "Incorrect User ID or Password" }
                }
                // }
            } else {
                console.log("User not Valid");
                return { status: "fail", result: "Validate User on Software and Try Again" }
            }
            //End 03/06/23

            // Check for LDAP from Angular side
            const responses = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/ldap/validate`, {
                strUserName: user[0].UserName,
                strPassword: userPass,
                req: strHmi
            })

            if (responses.data.response == 'VALIDATED') {

            } else {
                return { status: "fail", result: responses.data.response }
            }

        } catch (error) {
            console.error(error);
        }
    }

    // Get DS List
    async getDSList(req) {
        try {
            var FullIp = requestIp.getClientIp(req);
            let rpi = await models.tbl_rpi.findAll({ where: { DS_IP: { [Op.ne]: null }, RPIID: { [Op.ne]: null }, DS_NUMBER: { [Op.ne]: null } } });

            var obj = {
                status: "Success", Data: rpi, ClientIp: FullIp
            }
            return obj;
        } catch (err) {
            throw new Error(err);
        }

    }

    async unbindDS(req) {
        try {
            const { dsNo, tabIp } = req.body
            let findDSNo = await models.tbl_ds_binding.findOne({ where: { DS_NUMBER: dsNo } })
            let isUserNull = false;
            if (findDSNo) {
                isUserNull = objCommonOperation.isNullOrStringNull(findDSNo.UserID);
                if (isUserNull) {
                    let destroy = await models.tbl_ds_binding.destroy({ where: { DS_NUMBER: dsNo } })
                }
            }

            return { status: 'success', message: "DS disconnected" };

        } catch (err) {
            console.log(`unbindDS Error : ${err}`)
            throw new err
        }
    }
    async getResponsefromids(Data) {
        var { userId, dsNo } = Data.body
        await models.tbl_users.update({ loginCounter: 0 },
            {
                where: { UserID: userId }
            });
        console.log(`IDS Connect to ${dsNo},${userId}`)
        return `IDS Connect to ${dsNo},${userId}`

    }


    convertDateTimeIntoString(masterData,getLimitsObj, removeInstrument) {
        let instrumentIdArr = ['HardnessID', 'BalanceId', 'FriabilityID', 'DTID', 'VernierId']
        for (let key in masterData) {
            if (key.includes('Time')) {
                masterData[key] = momentObj(masterData[key]).format('HH:mm:ss')

            } else if (key.includes('Date')) {
                masterData[key] = momentObj(masterData[key]).format("YYYY-MM-DD")
            } else if (instrumentIdArr.includes(key) && removeInstrument) {
                if (key != getLimitsObj.instrumentId) {
                    masterData[key] = null

                }
            }

        }

        return masterData;
    }



}
module.exports = LoginModal