const ClassweighmentData = require('../clsProcessWeighment.model');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const objWeighmentData = new ClassweighmentData();
const mqttSender = new clsMqttSender();

class VernierParsing {

    async parsingVernierData(dataObj) {
        try {
            let { Str_Protocol, ProtocolPortNo, SelectedMenuDetails, currentOpStatus, tempCailibType } = dataObj;
            //here also different balance have different parsing logic
            let data = Str_Protocol.split(":")[2].trim();

            let invalidWeightFlag = false;
            let invalidUnitFlag = false;
            let isExceptionValue = 0;
            let ProtocolDecPoint = 2;
            if (data.includes('+') || data.includes('+01A')) {
                data = (data.includes('+01A')) ? data.split('+01A')[1] : data
                data = (data.includes('+')) ? data.split('+')[1] : data
            }
            if (!data.includes('.')) {
                invalidWeightFlag = true
                // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`)
            }
            if (!isNaN(Number(data.split('.')[0]))) {
                let afterDecimalDigit = data.split('.')[1];
                if (afterDecimalDigit.includes(" ")) afterDecimalDigit = afterDecimalDigit.split(" ")[0]
                if (((data.split('.')[0]).toString().length != 3) || ((afterDecimalDigit).toString().length != ProtocolDecPoint)) {
                    console.log('garbage data')
                    invalidWeightFlag = true
                    // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`)
                }
            } else {
                invalidWeightFlag = true
                console.log('Invalid Weight Received');
                // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`)
            }
            let arrWtDetail = (!invalidWeightFlag) ? data.substr(data.search(/\d/)) : data;
            let ProtocolDataAndUnit = arrWtDetail.split(" ");
            let arrRemoveBlankSpace = ProtocolDataAndUnit.filter(item => item);
            let actualWt = arrRemoveBlankSpace[0];
            let unitObj = objWeighmentData.getUnitObj(SelectedMenuDetails.menuName);

            // actualWt = Number(mathj.round(actualWt, ProtocolDecPoint)).toFixed(ProtocolDecPoint);
            let negativeWeightCheck = data.substr(data.search(/-/));
            let ProtocolUnit = arrRemoveBlankSpace[1];
            ProtocolUnit = ProtocolUnit == undefined || ProtocolUnit == 'NULL' ? 'mm' : ProtocolUnit;
            // let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.DsNo == SelectedMenuDetails.DsNo);
            // let tempCailibType = globalData.arrcalibType.find(k => k.DsNo == SelectedMenuDetails.DsNo);
            let arrPortDetailForStart1 = globalData.arrSelectedMenu.find(k => k.DsNo == SelectedMenuDetails.DsNo);//await objHmi.idsPortSetting(strHmi);
            //Instrument Type,ID,PortNo
            let intPortNo1 = arrPortDetailForStart1.portNo;
            let strInstrumentType = arrPortDetailForStart1.InstrumentType;
            let strInstrumentId = arrPortDetailForStart1.instrumentId;
            const __parameterWeighmentObj = {
                DsNo: SelectedMenuDetails.DsNo,
                TabIp: SelectedMenuDetails.TabIp,
                DsIp: SelectedMenuDetails.DsIp,
                actualWt: actualWt,
                decPoint: ProtocolDecPoint,
                minMaxPerDp: unitObj.minMaxPerDp,
                avgDp: unitObj.avgDp,
                stdDevDp: unitObj.stdDevDp,
                minMaxDp: unitObj.minMaxDp,
                unit: ProtocolUnit,
                instrumentId: strInstrumentId,
                ProtocolPortNo: intPortNo1,
                isExceptionValue: isExceptionValue,
                SelectedMenuDetails: SelectedMenuDetails,
                menuName: SelectedMenuDetails.menuName,
                invalidWeightFlag: invalidWeightFlag,
                invalidUnitFlag: invalidUnitFlag
            }

            if (actualWt.endsWith('mm' || 'g' || 'kg' || 'gm')) {
                //log protocol in file
                __parameterWeighmentObj.invalidWeightFlag = true;
                // loggers.MqttProtocolLogger.info(`protocol : ${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`)
            }

            if (actualWt == (undefined || "NaN" || 0 || NaN) || negativeWeightCheck.charAt(0) == "-" ||
                ProtocolPortNo == (undefined || "") || data.startsWith('I4') || data == "") {
                __parameterWeighmentObj.invalidWeightFlag = true;
                //log protocol in file
                // loggers.MqttProtocolLogger.info(`protocol : ${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`)
            }


            if (data !== "") {
                if (ProtocolDataAndUnit.length < 1 || ProtocolDataAndUnit[1] == "") {
                    //log protocol in file
                    __parameterWeighmentObj.invalidWeightFlag = true;
                    // loggers.MqttProtocolLogger.info(`protocol : ${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                    // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Weight Recieved`);
                }

                if (ProtocolUnit === "A") {
                    return;
                } else {

                    if (strInstrumentType == GLOBAL_NOMENCLATURE.Vernier) {
                        if (ProtocolUnit == undefined) {
                            ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                        } else {
                            if ((ProtocolUnit != "mm")) {
                                __parameterWeighmentObj.invalidUnitFlag = true;
                                //log protocol in file
                                // loggers.MqttProtocolLogger.info(`protocol : ${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                                // return mqttSender.sendData(SelectedMenuDetails.DsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Invalid Data String`);
                            } else {
                                // if (ProtocolUnit == "mg") {
                                //     actualWt = actualWt / 1000;
                                // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                                //     actualWt = actualWt * 1000;
                                // }
                                // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                            }

                        }

                    } else {
                        //log protocol in file
                        loggers.MqttProtocolLogger.info(`unknown instrument`)
                        console.log('unknown instrument');
                    }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {
                            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            await objWeighmentData.ParsingTestData(strInstrumentType, __parameterWeighmentObj);
                        }
                    } else {
                        var result;
                        var calibType = tempCailibType.calibType;
                        switch (calibType.toLowerCase()) {
                            case 'daily':
                                result = dailyCalibrationModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'periodic':
                                result = periodiccalibrationModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'verCalb':
                                break;
                            case 'uncertainty':
                                result = uncertinityCalibModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'repeatability':
                                result = repetabilityCalibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'eccentricity':
                                result = eccentricityCaibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'crmhei':
                                result = objCrimpHeight.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'crmdia':
                                result = objCrimpDiameter.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'linearity':
                                result = linearityCalibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'positional':
                                break;
                            default:
                                loggers.MqttProtocolLogger.info(`Cal Decider not set : ${calibType}`)
                                console.log('Cal Decider not set');
                                break;
                        }
                        return result;
                    }
                }
            }

        } catch (error) {
            throw new Error(error)
        }
    }
}

module.exports = VernierParsing;