const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const ClassweighmentData = require('../clsProcessWeighment.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const { models } = require('../../../config/dbConnection');
const DailyCalibrationModel = require('../Calibration/clsdailyCalibration.model');
const ClassPeriodicCalibration = require('../Calibration/clsPeriodicCalibration.model');
const ClassEccenCalibration = require('../Calibration/clsEccentricity.model');
const RepeatabilityCalibrationModel = require('../Calibration/clsRepeatability.model');
const uncertinityCalibrationModel = require('../Calibration/clsUncertainty.model');
const linearityCalibrationModel = require('../Calibration/clslinearity.model');
const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new ClassPeriodicCalibration();
const eccentricityCaibration = new ClassEccenCalibration();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new uncertinityCalibrationModel();
const linearityCalibration = new linearityCalibrationModel();

const objWeighmentData = new ClassweighmentData();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const clsWeighmentModel = require("../../model/clsProcessWeighment.model");
const objWeighmentMOdel = new clsWeighmentModel();
const moment = require('moment');

class DTParsing {
precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1, p = 0;
    while (Math.round(a * e) / e !== a) { e *= 10; p++; }
    return p;
}

async parsingDTData(dataObj) {
 try {
    let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
    let data_array = Str_Protocol.trim().split("\n");
    Ip = dataObj.TabIp
    strResberryPi = dataObj.currentOpStatus.DsNo
    const FinalObj = {};
    let Res = [];
    let res;
   
    let main = globalData.dataDT.find(k => k.Ip == Ip)
    
                if (main == undefined) {
                    let obj = globalData.dataDT.push({
                        hmi: strHmi,
                        Ip: Ip
                    })
                }

                let cubicaldata = await models.tbl_cubical.findOne({
                    where: {
                        Sys_DSNumber: dataObj.currentOpStatus.DsNo
                    }
                })

                var cubicObj = {}
                cubicObj.cubicalData = cubicaldata

                for(let  i = 0 ; i < data_array.length ; i++){
                    let rm = data_array[i].trim();

                    // console.log(  i + "-->" + rm);   // needs to comment out
                
                    if(data_array[i].includes("TEST ON DUR.")){
                       Res.push(data_array[i]);
                       res = Res[0].split("|").map((i) => i).filter((t) => t !== "");
                       let index = globalData.dataDT.findIndex(k => k.Ip == Ip)
                       globalData.dataDT[index].Duration = res;                   
                    }
                } 
     

                FinalObj["LHS"] = res[1].trim();
                FinalObj["RHS"] = res[2].trim();

               let LHS = moment(FinalObj.LHS , "HH:mm:ss" , true).isValid();
               let RHS = moment(FinalObj.RHS , "HH:mm:ss", true).isValid();

              
                let data = await models.tbl_mes_data.findAll({
                    where: {
                        DS_Number: cubicaldata.Sys_DSNumber,
                        BatchID: cubicaldata.Sys_Batch,
                        isSetInCubical: 1
                    }
                })

                let dtSideValue;
                // let dtSideValue = data.Side == "RHS" ? FinalObj.RHS : FinalObj.LHS;
                
                if(data[0].Side == "RHS" && RHS){
                    dtSideValue = FinalObj.RHS
                }
                else if(data[0].Side == "LHS" && LHS){
                    dtSideValue = FinalObj.LHS
                }
                else if((data[0].Side == "NA" || data[0].Side == "NULL") && LHS){
                    dtSideValue = FinalObj.LHS
                }
                else {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid Time Received`); 
                    return 
                }

                let intPortNo1 = dataObj.ProtocolPortNo;
                let strInstrumentId = dataObj.InstrumentId;
                var __parameterWeighmentObj = {
                    DsNo: SelectedMenuDetails.DsNo,
                    TabIp: SelectedMenuDetails.TabIp,
                    DsIp: SelectedMenuDetails.DsIp,
                    instrumentId: strInstrumentId,
                    ProtocolPortNo: intPortNo1,
                    SelectedMenuDetails: SelectedMenuDetails,
                    menuName: SelectedMenuDetails.menuName,
                    idsNo: strResberryPi,
                    Hmi: strHmi,
                    Ip: Ip,
                    cubicObjData: cubicObj,
                    side:data.side,
                    dtValue:dtSideValue,
                    dsNo: SelectedMenuDetails.DsNo,
                    tabIp: SelectedMenuDetails.TabIp,
                }
    
                if(Res == ""){
                 mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                 return
                } else {
                      await objWeighmentData.ParsingTestData(mqttProtocol.DTMenu, __parameterWeighmentObj);
                }


 }
 catch(e){
  throw new Error(e);
 }

 }

}

module.exports = DTParsing;