const ClassweighmentData = require('../clsProcessWeighment.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const { models } = require('../../../config/dbConnection');
const DailyCalibrationModel = require('../Calibration/clsdailyCalibration.model');
const ClassPeriodicCalibration = require('../Calibration/clsPeriodicCalibration.model');
const ClassEccenCalibration = require('../Calibration/clsEccentricity.model');
const RepeatabilityCalibrationModel = require('../Calibration/clsRepeatability.model');
const uncertinityCalibrationModel = require('../Calibration/clsUncertainty.model');
const linearityCalibrationModel = require('../Calibration/clslinearity.model');
const serverConfig = require('../../../../IncrencyV4DRLTSHConfig.json');
const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new ClassPeriodicCalibration();
const eccentricityCaibration = new ClassEccenCalibration();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new uncertinityCalibrationModel();
const linearityCalibration = new linearityCalibrationModel();

const objWeighmentData = new ClassweighmentData();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();

class BalanceParsing {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async parsingBalanceData(dataObj) {
        try {
            let { Str_Protocol, ProtocolPortNo, InstrumentId, InstrumentType, SelectedMenuDetails, currentOpStatus, tempCailibType, TabIp } = dataObj;
            //here also different balance have different parsing logic
            console.log(tempCailibType);
            let invalidWeightFlag = false;
            let invalidUnitFlag = false;
            // Calibration parsing
            // if (tempCailibType) {
            //     let checkdata_ = await this.removeExtraData(Str_Protocol)
            //     Str_Protocol = checkdata_.result
            //     // Str_Protocol = await this.removeExtraData(Str_Protocol)
            // }
            // let data = Str_Protocol.split(":")[2];
            // let isDigitPresent = data.search(/\d/)
            // let DsNo = tempCailibType?.DsNo ?? SelectedMenuDetails?.DsNo
            // if (isDigitPresent == -1) {
            //     console.log("Weight not present")
            //     return
            // }

            let DsNo = tempCailibType?.DsNo ?? SelectedMenuDetails?.DsNo

            let cubicaldata = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: DsNo
                }
            })


            let Instrument = await models.tbl_balance.findOne({
                where: {
                    Bal_ID: cubicaldata.Sys_BalID
                }
            })

            let mesData = await models.tbl_mes_data.findOne({
                where:{
                    BatchId: cubicaldata.Sys_Batch
                }
            })

             // Calibration parsing
             if (tempCailibType) {
                if ((Instrument.Bal_Model == 'MS304TS/A00' || Instrument.Bal_Model == 'MS304TS') && Instrument.Bal_Make == 'METTLER TOLEDO') {
                // let idx1 = -1;
                // let idx2 = -1;
                // idx1 = Str_Protocol.indexOf("(");
                // idx2 = Str_Protocol.indexOf(")");
                
                // if(idx1 == -1 && idx2 == -1){
                //    return mqttSender.sendData(DsNo,`${mqttProtocols.DisplayMessage}Invalid Format Recieved`);
                // }else{
                    let regdata = /^(ComRead:\d+:)\s*(\d+(\.\d+))\((\d+)\)\s*g$/;
                    console.log(regdata);
                    
                    let Answer = Str_Protocol.replace(regdata, function(match, prefix, beforePattern, decimal, insidePatter) {
                        console.log(beforePattern)
                        console.log(insidePatter)
                        let ComnineData = beforePattern + insidePatter;
                        return `${prefix} ${ComnineData} g`;
                    });
                     
                    console.log(Answer);

                    Str_Protocol = Answer;
                //   }
                }
                else {
                let checkdata_ = await this.removeExtraData(Str_Protocol)
                Str_Protocol = checkdata_.result
                }
                // Str_Protocol = await this.removeExtraData(Str_Protocol)
            }
            let data = Str_Protocol.split(":")[2];
            let isDigitPresent = data.search(/\d/)
            // let DsNo = tempCailibType?.DsNo ?? SelectedMenuDetails?.DsNo
            if (isDigitPresent == -1) {
                console.log("Weight not present")
                return
            }

            let validUnit = ["g", "gm" , "G" , "GM"];
            let ProtocolUnit;
            let actualWt;

            let ProtocolDataAndUnit = data.split(" ").filter(item => item);
            if (ProtocolDataAndUnit.length == 3) {
                ProtocolDataAndUnit.splice(0, 1);
                data = data.split(" ").filter(item => item);
                data.splice(0, 1);
            }
            if(serverConfig.plant != "FT03"){
                ProtocolDataAndUnit[0] = ProtocolDataAndUnit[0].replace(/\(\d+\)/, (_, num) => num); // add the bracket number to the string itself. or (/\((\d+\))/ , '$1') --> put(\d+\) inside ().
            }else {
            ProtocolDataAndUnit[0] = ProtocolDataAndUnit[0].replace(/\(\d+\)/, '');
            }
            if ((Instrument.Bal_Model == 'MS304TS' || Instrument.Bal_Model == 'MS304TS/A00') && Instrument.Bal_Make == 'METTLER TOLEDO') {
                if(!tempCailibType){
                let d = data.slice(data.indexOf('N') + 1).trim();
                let c = d.match(/\(.*?\)/)?.[0] || '';
                if(serverConfig.plant != "FT03"){
                    d = d.replace(/\((\d+)\)/, (_ , num) => num).trim(); // /\((\d+)\)/  -> \( (\d+) \) Wrapped inside the Group.
                } else {
                d = d.replace(c, '').trim();
                }
              
                ProtocolDataAndUnit = d.split(" ").filter(item => item);
                }
            }

            if (Instrument.Bal_Model == 'BSA423' && Instrument.Bal_Make == 'Sartorious') {

                if (!tempCailibType) {

                    if (Array.isArray(data)) {

                        console.log('This may be serial no from the balance'); 

                        return mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Data Recieved`)

                    }

                    let d = data.trim().split(" ").filter(ele => ele != "");

                    d = (ProtocolDataAndUnit.length > 2 && serverConfig.plant == "FT03") ? d.splice(2, 3) : d;

                    ProtocolDataAndUnit = d;

                }

            }

            console.log(ProtocolDataAndUnit);
            //Weighment Parsing
            if (!tempCailibType) {
                if (ProtocolDataAndUnit.length > 0) {
                    actualWt = ProtocolDataAndUnit[0]
                    if (isNaN(actualWt)) {
                        invalidWeightFlag = true
                    }
                    if (ProtocolDataAndUnit.length > 1) {
                        ProtocolUnit = ProtocolDataAndUnit[1]
                        ProtocolUnit = ProtocolUnit.replaceAll('\n', '');
                        if (!validUnit.includes(ProtocolUnit)) {
                            invalidUnitFlag = true
                        }
                    }
                }
            }

            // Calibration Parsing
            if (tempCailibType) {

                for (let i = 0; i < ProtocolDataAndUnit.length; i++) {

                    if (!isNaN(ProtocolDataAndUnit[i])) {
                        actualWt = ProtocolDataAndUnit[i].toLowerCase();
                        // if(!actualWt.includes('.')) invalidWeightFlag = true
                        if (validUnit.includes(ProtocolDataAndUnit[i + 1])) {
                            ProtocolUnit = ProtocolDataAndUnit[i + 1]
                        } else {
                            console.log("Unit not send through Balance")
                            invalidUnitFlag = true
                        }
                        break;
                    }

                }

            }

            if (!actualWt) {
                console.log("Weight not present")
                return
            }

            console.log(actualWt, ProtocolUnit);
            // let matchOnlySpace = data.match(/(\s){1,}(\S*\d\S*)(\s){1,}/g);
            // if(matchOnlySpace) {
            //     console.log(`Match Only Space ${matchOnlySpace[0].trim()}`);
            // }

            // let matchesOnlyDigitWithSpace = data.match(/(\s){1,}\d+(\.\d+)?(\s){1,}/g);
            // if (matchesOnlyDigitWithSpace) {
            //     actualWt = matchesOnlyDigitWithSpace[0].trim();
            // } else {
            //     matchesOnlyDigitWithSpace = data.match(/(\s){1,}(\S*\d\S*)(\s){1,}/g);
            //     if (matchesOnlyDigitWithSpace) actualWt = matchesOnlyDigitWithSpace[0].trim()
            //     invalidWeightFlag = true
            // }

            // if(matchesOnlyDigitWithSpace) matchesOnlyDigitWithSpace = data;

            // if (actualWt) {
            //     let getAterDigitData = data.substr(data.search(actualWt)).trim();
            //     ProtocolUnit = getAterDigitData.split(/\s+/)[1];
            //     if (ProtocolUnit) {
            //         ProtocolUnit = ProtocolUnit.toLowerCase();
            //         if (!validUnit.includes(ProtocolUnit)) {
            //             invalidUnitFlag = true
            //             console.log("Invalid Unit Received")
            //         }
            //     } else {
            //         console.log("Unit not send through Balance")
            //         invalidUnitFlag = true
            //     }
            //     console.log(`Unit : ${ProtocolUnit}`);
            // }

            // let actualWt;
            // let matchesOnlyDigitWithSpace = data.match(/(\s){1,}\d+(\.\d+)?(\s){1,}/g);
            // if (matchesOnlyDigitWithSpace) {
            //     actualWt = matchesOnlyDigitWithSpace[0].trim();
            //     let getAterDigitData = data.substr(data.search(actualWt)).trim();
            //     ProtocolUnit = getAterDigitData.split(/\s+/)[1];
            //     if (ProtocolUnit) {
            //         ProtocolUnit = ProtocolUnit.toLowerCase();
            //         if (!validUnit.includes(ProtocolUnit)) {
            //             invalidUnitFlag = true
            //             console.log("Invalid Unit Received")
            //         }
            //     } else {
            //         console.log("Unit not send through Balance")
            //         invalidUnitFlag = true
            //     }
            //     console.log(`Unit : ${ProtocolUnit}`);
            // } else {
            //     matchesOnlyDigitWithSpace = data.match(/(\s){1,}(\S*\d\S*)(\s){1,}/g);
            //     if(matchesOnlyDigitWithSpace) actualWt = matchesOnlyDigitWithSpace[0].trim()
            //     invalidWeightFlag = true
            // }
            // let getWeight = data.substr(isDigitPresent)
            // console.log(getWeight);

            // let arrWtDetail = data.substr(data.search(/\s\d/));
            // let ProtocolDataAndUnit = arrWtDetail.split(" ");
            // let arrRemoveBlankSpace = ProtocolDataAndUnit.filter(item => item);
            // let actualWt = matchesOnlyDigitWithSpace[0].trim();
            let isExceptionValue = 0;
            // if (actualWt.match(/[a-zA-z]/g) != null && (!actualWt.includes(' '))) {
            //     // isExceptionValue = 1;
            //     invalidWeightFlag = true;
            //     // mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Data Recieved`, actualWt);
            //     // console.log("Invalid Weight Received", actualWt);
            //     // return
            // }
            if (tempCailibType == undefined) {
                let unitObj = objWeighmentData.getUnitObj(SelectedMenuDetails.menuName);

                // let minMaxPerDp = 2;
                // let avgDp = 4;
                // let stdDevDp = 4;
                // let minMaxDp = 2;
                 let BalData = await models.tbl_balance.findOne({
                    where:{
                      Bal_ID: mesData.AWBID
                    }
                 }) 

                let ProtocolDecPoint = 0;
               
                if(serverConfig.plant != "FT03"){
                    ProtocolDecPoint = BalData.Bal_DP;
                } else {
                    if(actualWt.includes('.')){
                    let parseDP = actualWt.split('.')[1].trim();
                    ProtocolDecPoint = (parseDP == undefined) ? 0 : parseDP.length;
                    }
                }

                if (SelectedMenuDetails.selectedProductDetail.Unit != ProtocolUnit && !invalidUnitFlag) {
                    // __parameterWeighmentObj.invalidUnitFlag = true
                    if (ProtocolUnit?.toLowerCase().startsWith('g')) {
                        ProtocolUnit = ProtocolUnit.toLowerCase() == "g"  ? "g" : "gm"
                    } else {
                        invalidUnitFlag = true
                    }
                    // else {
                    //     // mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Unit Received`)
                    //     // if (autoTare)  mqttSender.sendData( strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    //     // return;
                    // }
                }

                // let negativeWeightCheck = data.substr(data.search(/-/));
                // let ProtocolUnit = arrRemoveBlankSpace[1];
                // ProtocolUnit = ProtocolUnit == undefined ? 'g' : ProtocolUnit;
                if(invalidUnitFlag || invalidWeightFlag){
                    isExceptionValue = 1;
                }
                var __parameterWeighmentObj = {

                    DsNo: SelectedMenuDetails.DsNo,
                    TabIp: SelectedMenuDetails.TabIp,
                    DsIp: SelectedMenuDetails.DsIp,
                    actualWt: actualWt,
                    decPoint: ProtocolDecPoint,
                    minMaxPerDp: unitObj.minMaxPerDp,
                    avgDp: unitObj.avgDp,
                    stdDevDp: unitObj.stdDevDp,
                    minMaxDp: unitObj.minMaxDp,
                    unit: ProtocolUnit,
                    instrumentId: InstrumentId,
                    ProtocolPortNo: ProtocolPortNo,
                    isExceptionValue: isExceptionValue,
                    SelectedMenuDetails: SelectedMenuDetails,
                    menuName: SelectedMenuDetails.menuName,
                    invalidWeightFlag: invalidWeightFlag,
                    invalidUnitFlag: invalidUnitFlag
                }

            }
            //make function for it and return boolean 
            // if (actualWt.endsWith('mg' || 'g' || 'kg' || 'gm')) {
            //     //log protocol in file
            //     // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Received sended to device ${strHmi}`)
            //     __parameterWeighmentObj.invalidWeightFlag = true;
            //     // mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Data Recieved`)
            //     // if (autoTare)  mqttSender.sendData(strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`);
            //     // return;
            // }

            // if (actualWt == (undefined || "NaN" || 0 || NaN) || negativeWeightCheck.charAt(0) == "-" ||
            //     ProtocolPortNo == (undefined || "") || data.startsWith('I4') || data == "") {
            //     __parameterWeighmentObj.invalidWeightFlag = true;
            //     //log protocol in file
            //     // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Received sended to device ${strHmi}`)
            //     // mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Data Recieved`)
            //     // if (autoTare)  mqttSender.sendData(strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`)
            //     // return
            // }

            if (actualWt >= 500 && (ProtocolUnit != 'mg')) { 

                console.log('This may be serial no from the balance'); 

                return mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Data Recieved`);
            }
            if (data !== "") {
                // if (ProtocolDataAndUnit.length < 1 || ProtocolDataAndUnit[1] == "") {
                //     //log protocol in file
                //     // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Received sended to device ${strHmi}`)
                //     __parameterWeighmentObj.invalidWeightFlag = true;
                //     // mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Weight Received`);
                //     // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Received sended to device ${strHmi}`)
                //     // mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Received`);
                //     // if (autoTare)  mqttSender.sendData( strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                //     // return;
                // }

                if (ProtocolUnit === "A") {
                    return;
                } else {
                    if (InstrumentType != GLOBAL_NOMENCLATURE.Balance) console.log("Unknown Instrument")
                    // if (InstrumentType == GLOBAL_NOMENCLATURE.Balance) {
                    //     // if (ProtocolUnit == undefined) {
                    //     //     ProtocolUnit = ProtocolUnit == undefined ? "g" : "gm" ? "gm" : ProtocolUnit;
                    //     // } else {
                    //     //     if ((ProtocolUnit != "g") && (ProtocolUnit != "gm") && (ProtocolUnit != 'Kg') && (ProtocolUnit != "mg") && (ProtocolUnit != 'gm')) {
                    //     //         __parameterWeighmentObj.invalidWeightFlag = true;
                    //     //         //log protocol in file
                    //     //         // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                    //     //         // mqttSender.sendData(SelectedMenuDetails.DsNo, `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid Data String`)
                    //     //         // if (autoTare)  mqttSender.sendData(strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    //     //         // return;
                    //     //     } else {
                    //     //         // if (ProtocolUnit == "mg") {
                    //     //         //     actualWt = actualWt / 1000;
                    //     //         // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                    //     //         //     actualWt = actualWt * 1000;
                    //     //         // }
                    //     //         // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                    //     //     }
                    //     // }

                    // } else {
                    //     //log protocol in file
                    //     // loggers.MqttProtocolLogger.info(`unknown instrument`)
                    //     console.log('unknown instrument');
                    // }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {                         
                            // loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            await objWeighmentData.ParsingTestData(InstrumentType, __parameterWeighmentObj);
                        }
                    } else {
                        var result;
                        var calibType = tempCailibType.calibType;
                        var strResberryPi = tempCailibType.DsNo
                        var ProtocolDecPoint = 3
                        // var check_da = Str_Protocol.split(/\s+/)
                        // if (check_da.length > 3) {
                        //     if(!Str_Protocol.includes('N')){
                        //     Str_Protocol.splice(1, 1);
                        //     Str_Protocol[1] = Str_Protocol[1].replace(/\(\d+\)/, '');
                        //     Str_Protocol = Str_Protocol.join(' ');
                        // }
                        // }
                        // if(check_da.length > 3){
                        //     if(Str_Protocol.includes('N')){
                        //     if (Instrument.Bal_Model.includes('MS304TS') && Instrument.Bal_Make == 'METTLER TOLEDO') {
                        //         let d = data.slice(data.indexOf('N') + 1).trim();
                        //         let c = d.match(/\(.*?\)/)?.[0] || '';
                        //         d = d.replace(c, '').trim();
                        //         ProtocolDataAndUnit = d.split(" ").filter(item => item);
                        //     }
                        // }
                        // }
                        switch (calibType.toLowerCase()) {
                            case 'daily':
                                result = dailyCalibrationModel.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, TabIp)
                                break;
                            case 'periodic':
                                result = periodiccalibrationodel.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, TabIp)
                                break;
                            case 'verCalb':
                                break;
                            case 'uncertainty':
                                result = uncertinityCalibModel.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, TabIp)
                                break;
                            case 'repeatability':
                                result = repetabilityCalibration.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, TabIp)
                                break;
                            case 'eccentricity':
                                result = eccentricityCaibration.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, TabIp)
                                break;
                            case 'crmhei':
                                result = objCrimpHeight.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'crmdia':
                                result = objCrimpDiameter.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'linearity':
                                result = linearityCalibration.verifyWeights(Str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'positional':
                                break;
                            default:
                                // loggers.MqttProtocolLogger.info(`Cal Decider not set : ${calibType}`)
                                console.log('Cal Decider not set');
                                break;
                        }
                        return result;
                    }
                }
            }
        } catch (error) {
            throw new Error(error)
        }
    }



    async removeExtraData(str) {
        const desiredFormatRegex = /^ComRead:1:\s*\d+(\.\d+)?\s*g$/;
        if (desiredFormatRegex.test(str)) {
            return { result: str, checks: {} };
        }

        let secondColonIndex = str.indexOf(":", str.indexOf(":") + 1);
        if (secondColonIndex === -1) return { result: str, checks: {} };

        let nIndex = str.indexOf('N', secondColonIndex);
        if (nIndex !== -1) {
            str = str.slice(0, nIndex) + str.slice(nIndex + 1);
        }
        str = str.slice(0, secondColonIndex + 1) + str.slice(secondColonIndex + 1).replace(/^\s*\d+(\.\d+)?/g, '').trim();

        str = str.replace(/\(.*?\)/g, '').trim();

        return { result: str, checks: {} };
    }


}

module.exports = BalanceParsing;