const Database = require('../../database/clsQueryProcess');
const objDatabase = new Database();
const date = require('date-and-time');
let now = new Date();
const GlobalProtocol = require('../../global/CalibrationProtocol')
const globaldata = require('../../global/globalData');
const moment = require('moment');
const PeriodicModel = require('./checkForPendingCalib');
const clsCalibModeule = require('./clsdailyCalibration.model');
const objActualCheckOfCalibrationPen = new clsCalibModeule();
const globalData = require('../../global/globalData');
const GlobalNomenclature = require('../../global/GLOBAL_NOMENCLATURE');
const clsHmi = require('../hmiDetail.model');
const objHmi = new clsHmi();
const sequelize = require('../../../config/dbConnection').sequelize
const { tbl_precalibration_daily,
    tbl_precalibration_periodic,
    tbl_precalibration_eccentricity,
    tbl_precalibration_repeatability,
    tbl_precalibration_uncertainty,
    tbl_precalibration_linearity,
    tbl_calibration_daily_master,
    tbl_balance_weights,
    tbl_calibrationbox,
    tbl_calibration_status,
    tbl_calibration_periodic_master
} = require('../../../config/dbConnection').models

const { models } = require('../../../config/dbConnection')



class PreCalibrationWeigth {

    async validatePreWeighmentActivites(strHmi, strBalId, balType,TabIp) {

        var PrecalibrationStatus = await this.verifyPreCalibration(strBalId, strHmi, balType,TabIp); ///
        return PrecalibrationStatus;

    }


    async verifyPreCalibration(tempBalace, strHmi, balType,TabIp) {
        try {
            var arrResbPiNo = await objHmi.getResbPiNoFromHmi(strHmi);
            var strIdsNo = strHmi

            var objCubicData = globaldata.arrIdsInfo.find(k => k.DsNo == strIdsNo&& k.TabIp == TabIp).cubicalData;
            let strBalId = tempBalace;


            // // var objOwner = globalData.arrPreWeighCalibOwner.find(k => k.idsNo == strIdsNo);
            // if (balType == 'analytical') {
            //     strBalId = objCubicData.Sys_BalID;
            // } else {
            //     strBalId = objCubicData.Sys_BinBalID; // Bin Bal

            // }

            const objDailyPreCalibWeights = await this.getPreCalibrationDataDaily(strBalId, balType);
            const objPeriodicPreCalibWeights = await this.getPreCalibrationDataPeriodic(strBalId, balType);
            const objEccentricityPreCalibWeights = await this.getEccentricityCalibrationDataPeriodic(strBalId, balType);
            const objRepeatabilityPreCalibWeights = await this.getRepeatabilityCalibrationDataPeriodic(strBalId, balType);
            const objUncertaintyPreCalibWeights = await this.getUncertaintyCalibrationDataPeriodic(strBalId, balType);
            // const objLinearityPreCalibWeights = await this.getLinearityCalibrationDataPeriodic(strBalId, balType);
            const objCalibCheck = await this.checkBalCalibPending(strBalId, strHmi, balType,TabIp);
            var BalanceRecalibStatusObject
            if (balType == 'IPC Balance') {
                BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
            }
            else {
                BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);

            }
            if (objCalibCheck != undefined) {
                if (balType != 'IPC Balance') {
                    if (objCalibCheck.Daily == 'No calibration pending') {
                        // ||  objCalibCheck.Periodic.isPeriodic !=  true
                        // if ((objCalibCheck.Periodic.askPeriodic != true)) {
                            // if (BalanceRecalibStatusObject.DailyBalRecalib != 1 || BalanceRecalibStatusObject.PeriodicBalRecalib != 1) {
                            if (BalanceRecalibStatusObject.DailyBalRecalib != 1) {
                                let check_balance = await models.tbl_balance.findOne({
                                    attributes: ["Bal_ChangeWt", "IsNewBalance"],
                                    where: {
                                        Bal_ID: strBalId
                                    }
                                })
                                if (check_balance.Bal_ChangeWt == 1 && check_balance.IsNewBalance != 1) {
                                    var obj = { Change_cubical: true }
                                    return obj
                                }

                            }
                        // }
                    }
                }
            }
            if (balType == 'IPC Balance' && (objCalibCheck.Periodic.askPeriodic != true || objCalibCheck.Periodic.isPeriodic != true)) {
                if (BalanceRecalibStatusObject.PeriodicBalRecalib != 1) {
                    let check_balance = await models.tbl_balance.findOne({
                        attributes: ["Bal_ChangeWt", "IsNewBalance"],
                        where: {
                            Bal_ID: strBalId
                        }
                    })
                    if (check_balance.Bal_ChangeWt == 1 && check_balance.IsNewBalance != 1) {
                        var obj = { Change_cubical: true }
                        return obj
                    }

                }
            }
            //Validation 26/09/23
            let check1 = await objActualCheckOfCalibrationPen.checkAllWeighAssing(objDailyPreCalibWeights, objPeriodicPreCalibWeights, objEccentricityPreCalibWeights, objRepeatabilityPreCalibWeights)
            if (check1 == 'false') {
                for (let ind = 0; ind < objPeriodicPreCalibWeights.length; ind++) {
                    var calibDateP = objPeriodicPreCalibWeights[ind].CalibrationBox_Validity_Date > moment().format('YYYY-MM-DD')
                    // console.log(calibDateP);
                    if (!calibDateP) {
                        return `${objPeriodicPreCalibWeights[ind].CalibrationBox_ID} Weight Box Certification Expired`;
                    }
                    // var calibDateE = objEccentricityPreCalibWeights[0].CalibrationBox_Validity_Date > moment().format('YYYY-MM-DD')
                    // // console.log(calibDateE);
                    // if (!calibDateE) {
                    //     return `${objEccentricityPreCalibWeights[0].CalibrationBox_ID} Weight Box Certification Expired`;
                    // }
                    // var calibDateR = objEccentricityPreCalibWeights[0].CalibrationBox_Validity_Date > moment().format('YYYY-MM-DD')
                    // // console.log(calibDateR);
                    // if (!calibDateR) {
                    //     return `${objRepeatabilityPreCalibWeights[0].CalibrationBox_ID} Weight Box Certification Expired`;
                    // }
                }
            } else {
                return ` Invalid Weight Assignment`;
            }

            //change request



            // if(objCalibCheck.Periodic.includes('Due')){
            // var due = objCalibCheck.Periodic.Due
            // }
            // var objCalibWeightsPeriodic = await this.getCalibrationWeights(2, strBalId); // 9 balwt
            var arr_sortedSequence = sortObject(globalData.arrCalibrationSequnce[0]);
            var calibarray = await checkIfCalibrationPresent(strBalId);
            var newArr = [];
            for (let i = 0; i < arr_sortedSequence.length; i++) {
                for (let j = 0; j < calibarray.length; j++) {
                    if (arr_sortedSequence[i].key == calibarray[j] && arr_sortedSequence[i].value != 0) {
                        newArr.push(arr_sortedSequence[i])
                    }
                }
            }
            const objCalibWeightsDaily = await this.getCalibrationWeights(1, strBalId); //3

            var DailyMatched = true;
            var PeriodicMatched = true;
            var isCertificateValid = true;
            var ExpiredWtBox = "";
            if (objCalibCheck != 'not present') {
                // if (objCalibCheck.Daily == GlobalProtocol.Daily) {
                var check = await objActualCheckOfCalibrationPen.checkAllWeighAssing(objDailyPreCalibWeights, objPeriodicPreCalibWeights, objEccentricityPreCalibWeights, objRepeatabilityPreCalibWeights)
                if (check == 'true') {
                    DailyMatched = false;
                }
                if (DailyMatched != false) {
                    if (objDailyPreCalibWeights.length > 0) {
                        // if (objDailyPreCalibWeights[0] != undefined) {

                        DailyMatched = await this.blnPreCalibDone(objDailyPreCalibWeights, objCalibWeightsDaily[0]); //pre_daily , bl_weight

                        if (DailyMatched != false) {
                            for (const weight of objDailyPreCalibWeights) {
                                var calibWtBox = weight.CalibrationBox_ID.split(',');
                                var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                                var weights = weight.CalibrationBox_Selected_Elements.split(',');

                                for (let i = 0; i < arrCertValidity.length; i++) {
                                    var todayDate = moment().format('YYYY-MM-DD');
                                    var validity = arrCertValidity[i];
                                    var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                                    if (todayDate > validityDate) {
                                        isCertificateValid = false;
                                        ExpiredWtBox = calibWtBox[i];
                                    }
                                }
                                for (let index = 0; index < calibWtBox.length; index++) {

                                    var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                                    if (CalibCheckWt == "Not Matched") {
                                        DailyMatched = false;
                                        break;
                                    }
                                }

                                if (DailyMatched == false) {
                                    break;
                                }
                            }
                        }

                    } else {
                        DailyMatched = false
                    }
                }
                // }
                // else {
                //check for perioodic
                // if (objCalibCheck.Periodic.askPeriodic !== false) {
                check = await objActualCheckOfCalibrationPen.checkAllWeighAssing(objDailyPreCalibWeights, objPeriodicPreCalibWeights, objEccentricityPreCalibWeights, objRepeatabilityPreCalibWeights)
                let CalibType = await objActualCheckOfCalibrationPen.checkDailyCalibrationPending(strBalId, strHmi, balType, true,TabIp)
                console.log(CalibType)
                var strCalibType = CalibType.split(' ')[0];
                // if (objCalibCheck.Periodic.askPeriodic == true) {
                // switch (strCalibType) {
                // case GlobalNomenclature.Periodic:
                if (check == 'true') {
                    PeriodicMatched = false;
                    // break;
                }
                for (let i = 0; i < newArr.length; i++) {


                    const objCalibWeightsPeriodic = await this.getCalibrationWeights(2, strBalId, GlobalNomenclature.Periodic); // 9 balwt
                    PeriodicMatched = await this.blnPreCalibDone(objPeriodicPreCalibWeights, objCalibWeightsPeriodic[0]);
                    if (objPeriodicPreCalibWeights.length > 0) {
                        // if (objPeriodicPreCalibWeights[0] != undefined) {
                        if (PeriodicMatched != false) {
                            for (const weight of objPeriodicPreCalibWeights) {
                                var calibWtBox = weight.CalibrationBox_ID.split(',');
                                var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                                var weights = weight.CalibrationBox_Selected_Elements.split(',');
                                for (let i = 0; i < arrCertValidity.length; i++) {
                                    var todayDate = moment().format('YYYY-MM-DD');
                                    var validity = arrCertValidity[i];
                                    var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                                    if (todayDate > validityDate) {
                                        isCertificateValid = false;
                                        ExpiredWtBox = calibWtBox[i];
                                    }
                                }
                                for (let index = 0; index < calibWtBox.length; index++) {

                                    var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                                    if (CalibCheckWt == "Not Matched") {
                                        PeriodicMatched = false;
                                        break;
                                    }
                                }

                                if (PeriodicMatched == false) {
                                    break;
                                }

                            }
                        }

                    }
                    else {
                        PeriodicMatched = false;
                    }
                    // break;

                    if (newArr[i].key == 'U') {
                        const objCalibWeightsUncertinity = await this.getCalibrationWeights(2, strBalId, GlobalNomenclature.Uncertainty);
                        PeriodicMatched = await this.blnPreCalibDone(objUncertaintyPreCalibWeights, objCalibWeightsUncertinity[0]);
                        if (objUncertaintyPreCalibWeights.length > 0) {
                            // if (objUncertaintyPreCalibWeights[0] != undefined) {

                            if (PeriodicMatched != false) {
                                for (const weight of objUncertaintyPreCalibWeights) {
                                    var calibWtBox = weight.CalibrationBox_ID.split(',');
                                    var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                                    var weights = weight.CalibrationBox_Selected_Elements.split(',');
                                    for (let i = 0; i < arrCertValidity.length; i++) {
                                        var todayDate = moment().format('YYYY-MM-DD');
                                        var validity = arrCertValidity[i];
                                        var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                                        if (todayDate > validityDate) {
                                            isCertificateValid = false;
                                            ExpiredWtBox = calibWtBox[i];
                                        }
                                    }
                                    for (let index = 0; index < calibWtBox.length; index++) {

                                        var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                                        if (CalibCheckWt == "Not Matched") {
                                            PeriodicMatched = false;
                                            break;
                                        }
                                    }

                                    if (PeriodicMatched == false) {
                                        break;
                                    }

                                }
                            }

                        }
                        else {
                            PeriodicMatched = false;
                            break;
                        }
                    }

                    // break;
                    // case GlobalNomenclature.Uncertainty:


                    // break;
                    // case GlobalNomenclature.Repetability:


                    if (newArr[i].key == 'R') {
                        const objCalibWeightsRepetability = await this.getCalibrationWeights(2, strBalId, GlobalNomenclature.Repetability);
                        PeriodicMatched = await this.blnPreCalibDone(objRepeatabilityPreCalibWeights, objCalibWeightsRepetability[0]);
                        if (objRepeatabilityPreCalibWeights.length > 0) {
                            if (check == 'true') {
                                PeriodicMatched = false;
                                // break;
                            }
                            // if (objRepeatabilityPreCalibWeights[0] != undefined) {
                            if (PeriodicMatched != false) {
                                for (const weight of objRepeatabilityPreCalibWeights) {
                                    var calibWtBox = weight.CalibrationBox_ID.split(',');
                                    var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                                    var weights = weight.CalibrationBox_Selected_Elements.split(',');
                                    for (let i = 0; i < arrCertValidity.length; i++) {
                                        var todayDate = moment().format('YYYY-MM-DD');
                                        var validity = arrCertValidity[i];
                                        var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                                        if (todayDate > validityDate) {
                                            isCertificateValid = false;
                                            ExpiredWtBox = calibWtBox[i];
                                        }
                                    }
                                    for (let index = 0; index < calibWtBox.length; index++) {

                                        var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                                        if (CalibCheckWt == "Not Matched") {
                                            PeriodicMatched = false;
                                            break;
                                        }
                                    }

                                    if (PeriodicMatched == false) {
                                        break;
                                    }

                                }
                            }

                        }
                        else {
                            PeriodicMatched = false;
                            break;
                        }
                    }
                    // break;
                    // case GlobalNomenclature.Eccentricity:
                    if (newArr[i].key == 'E') {
                        const objCalibWeightsEccentricity = await this.getCalibrationWeights(2, strBalId, GlobalNomenclature.Eccentricity);
                        PeriodicMatched = await this.blnPreCalibDone(objEccentricityPreCalibWeights, objCalibWeightsEccentricity[0]);
                        if (objEccentricityPreCalibWeights.length > 0) {
                            // if (objEccentricityPreCalibWeights[0] != undefined) {
                            if (PeriodicMatched != false) {
                                for (const weight of objEccentricityPreCalibWeights) {
                                    var calibWtBox = weight.CalibrationBox_ID.split(',');
                                    var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                                    var weights = weight.CalibrationBox_Selected_Elements.split(',');
                                    for (let i = 0; i < arrCertValidity.length; i++) {
                                        var todayDate = moment().format('YYYY-MM-DD');
                                        var validity = arrCertValidity[i];
                                        var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                                        if (todayDate > validityDate) {
                                            isCertificateValid = false;
                                            ExpiredWtBox = calibWtBox[i];
                                        }
                                    }
                                    for (let index = 0; index < calibWtBox.length; index++) {

                                        var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                                        if (CalibCheckWt == "Not Matched") {
                                            PeriodicMatched = false;
                                            break;
                                        }
                                    }

                                    if (PeriodicMatched == false) {
                                        break;
                                    }

                                }
                            }

                        }
                        else {
                            PeriodicMatched = false;
                            break;
                        }
                    }
                    // break;

                    // case GlobalNomenclature.Linearity:
                    // if(newArr[i].key == 'L'){
                    //     const objCalibWeightsLinearity = await this.getCalibrationWeights(2, strBalId, GlobalNomenclature.Linearity);
                    //     PeriodicMatched = await this.blnPreCalibDone(objLinearityPreCalibWeights, objCalibWeightsLinearity[0]);
                    //     if (objLinearityPreCalibWeights.length > 0) {
                    //         // if (objEccentricityPreCalibWeights[0] != undefined) {
                    //         if (PeriodicMatched != false) {
                    //             for (const weight of objLinearityPreCalibWeights) {
                    //                 var calibWtBox = weight.CalibrationBox_ID.split(',');
                    //                 var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                    //                 var weights = weight.CalibrationBox_Selected_Elements.split(',');
                    //                 for (let i = 0; i < arrCertValidity.length; i++) {
                    //                     var todayDate = moment().format('YYYY-MM-DD');
                    //                     var validity = arrCertValidity[i];
                    //                     var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                    //                     if (todayDate > validityDate) {
                    //                         isCertificateValid = false;
                    //                         ExpiredWtBox = calibWtBox[i];
                    //                     }
                    //                 }
                    //                 for (let index = 0; index < calibWtBox.length; index++) {

                    //                     var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                    //                     if (CalibCheckWt == "Not Matched") {
                    //                         PeriodicMatched = false;
                    //                         break;
                    //                     }
                    //                 }

                    //                 if (PeriodicMatched == false) {
                    //                     break;
                    //                 }

                    //             }
                    //         }

                    //     }
                    //     else {
                    //         PeriodicMatched = false;
                    //     }
                    // }


                }
                // break;
                // case "Daily":
                const Daily = await this.getCalibrationWeights(1, strBalId, GlobalNomenclature.Daily);
                DailyMatched = await this.blnPreCalibDone(objDailyPreCalibWeights, objCalibWeightsDaily[0]); //pre_daily , bl_weight
                if (check == 'true') {
                    PeriodicMatched = false;
                    // break;
                }
                if (DailyMatched != false) {
                    for (const weight of objDailyPreCalibWeights) {
                        var calibWtBox = weight.CalibrationBox_ID.split(',');
                        var arrCertValidity = weight.CalibrationBox_Validity_Date.split(',');
                        var weights = weight.CalibrationBox_Selected_Elements.split(',');

                        for (let i = 0; i < arrCertValidity.length; i++) {
                            var todayDate = moment().format('YYYY-MM-DD');
                            var validity = arrCertValidity[i];
                            var validityDate = moment(validity).format(validity, 'YYYY-MM-DD');
                            if (todayDate > validityDate) {
                                isCertificateValid = false;
                                ExpiredWtBox = calibWtBox[i];
                            }
                        }
                        for (let index = 0; index < calibWtBox.length; index++) {

                            var CalibCheckWt = await this.getWeighBoxDetails(calibWtBox[index], weights[index]);

                            if (CalibCheckWt == "Not Matched") {
                                DailyMatched = false;
                                break;
                            }
                        }

                        if (DailyMatched == false) {
                            break;
                        }
                    }


                } else {
                    DailyMatched = false
                }

                // break;
                // }

                // }
                // }
                // else {
                //     let resObj = {}
                //     let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
                //     if (TempCalibType != undefined) {
                //         // console.log(TempCalibType);
                //         (globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi), 1));

                //     }

                //     return "No calibration pending";
                // }

                // }

                if (DailyMatched == false) {
                    console.log(`Daily Calibration Invalid Weight,Assignments`);
                    return `Invalid Weight Assignment`;

                }
                else if (PeriodicMatched == false) {
                    console.log(`${strCalibType}Invalid Weight,Assignments`);
                    return ` Invalid Weight Assignment`;

                }
                else if (!isCertificateValid) {
                    return `${ExpiredWtBox} Weight Box Certification Expired`;
                } else {
                    return "Valid PreCalibration";
                }
            } else {
                return "SET BALANCE, AGAIN AND TRY AGAIN";
            }


        } catch (err) {
            console.log(err)
        }
    }

    async getPreCalibrationDataDaily(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }
        let resObjWeight = await tbl_precalibration_daily.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }


    async getPreCalibrationDataPeriodic(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }


        let resObjWeight = await tbl_precalibration_periodic.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }

    async getEccentricityCalibrationDataPeriodic(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }

        let resObjWeight = await tbl_precalibration_eccentricity.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }

    async getRepeatabilityCalibrationDataPeriodic(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }

        let resObjWeight = await tbl_precalibration_repeatability.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }

    async getUncertaintyCalibrationDataPeriodic(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }

        let resObjWeight = await tbl_precalibration_uncertainty.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }
    async getLinearityCalibrationDataPeriodic(strBalanceID, BalType = '') {
        if (BalType == '') {
            BalType = 'analytical';
        }

        let resObjWeight = await tbl_precalibration_linearity.findAll({
            where: {
                'Equipment_ID': strBalanceID,
                'Equipment_Type': BalType == 'analytical' ? 'Balance' : 'IPC Balance'
            }
        })
        return resObjWeight;
    }


    async checkBalCalibPending(strBalanceID, strHmi, balType,TabIp) {
        // var objCalibModel = new clsCalibModel();
        var dailyCalibResult = await this.checkDailyCalibrationPending(strBalanceID, balType);
        var periodicCalibResult = await PeriodicModel.checkIfTodayIsPeriodicCalib(strBalanceID, strHmi,TabIp);
        var objForRecalibration;
        if (balType == "analytical") {
            objForRecalibration = globaldata.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalanceID);
        } else {
            objForRecalibration = globaldata.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalanceID);
        }
        if (periodicCalibResult.isNewBal == true) {
            // dailyCalibResult = GlobalProtocol.No
        }
        if (periodicCalibResult.askPeriodic == true || periodicCalibResult.isPeriodic == true) {
            // dailyCalibResult = GlobalProtocol.No
            // }
            let check_periodic_entry = await models.tbl_calibration_periodic_master.findAll({
                where: {
                    Periodic_CalbDate: moment().format('YYYY-MM-DD'),
                    'Periodic_BalID': strBalanceID
                }
            });

            if (check_periodic_entry.length == 0) {
                // dailyCalibResult = GlobalProtocol.No
            }
        }

        if (objForRecalibration != undefined) {

            // if (periodicCalibResult.askPeriodic == true && objForRecalibration.DailyBalRecalib == 1)

            if (dailyCalibResult == GlobalProtocol.No && objForRecalibration.DailyBalRecalib == 1) {
                dailyCalibResult = GlobalProtocol.Daily
            }
            if (periodicCalibResult.askPeriodic == false && objForRecalibration.PeriodicBalRecalib == 1) {
                periodicCalibResult.askPeriodic = true
            }


            return { Daily: dailyCalibResult, Periodic: periodicCalibResult }
        } else {
            return 'not present'; // If balance is not present in recalibration status
        }

    }

    async checkDailyCalibrationPending(strBalId, balType) {
        try {


            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            // var strBalId = tempCubicInfo.Sys_BalID;
            ///----Periodic pending mid night---///

            if (balType == 'analytical') {
                var calibTable = 'tbl_calibration_status';
            } else {
                var calibTable = 'tbl_calibration_status_bin';
            }

            let result = await models[calibTable].findOne({
                where: {
                    'BalID': strBalId
                }
            });
            var result_1 = result.P[0]

            if (result_1 == 1) {
                return GlobalProtocol.No;
            }
            let resdailyObj = await tbl_calibration_daily_master.findAll({
                where: {
                    'Daily_BalID': strBalId,
                    'Daily_CalbDate': moment().format('YYYY-MM-DD'),
                }
            })
            resdailyObj = [resdailyObj]
            let resperiodicObj = await tbl_calibration_periodic_master.findAll({
                where: {
                    'Periodic_BalID': strBalId,
                    'Periodic_CalbDate': moment().format('YYYY-MM-DD'),
                }
            })
            resperiodicObj = [resperiodicObj]
            if (resperiodicObj[0].length != 0) {
                return GlobalProtocol.No;
            }
            if (resdailyObj[0].length !== 0) {
                return GlobalProtocol.No;
            } else {
                return GlobalProtocol.Daily
            }
        } catch (error) {
            console.log(error)

        }



    }
    async getCalibrationWeights(CalibType, strBalanceId, strCalibPendingType) {


        var selectCalibWeights = {
            str_tableName: 'tbl_balance_weights',
            data: '*',
            condition: [
                { str_colName: 'Bal_ID', value: strBalanceId, comp: 'eq' },

            ]
        }

        let strColumn;

        if (CalibType == 1) {
            selectCalibWeights.condition.push(
                { str_colName: 'Bal_Daily', value: 1, comp: 'eq' });
            strColumn = 'Bal_Daily'

        }
        else {
            switch (strCalibPendingType) {
                case GlobalNomenclature.Periodic:
                    selectCalibWeights.condition.push(
                        { str_colName: 'Bal_Periodic', value: 1, comp: 'eq' });
                    strColumn = 'Bal_Periodic'
                    break;
                case GlobalNomenclature.Uncertainty:
                    selectCalibWeights.condition.push(
                        { str_colName: 'Bal_IsUncertinity', value: 1, comp: 'eq' });
                    strColumn = 'Bal_IsUncertinity'
                    break;
                case GlobalNomenclature.Repetability:
                    selectCalibWeights.condition.push(
                        { str_colName: 'Bal_IsRepetability', value: 1, comp: 'eq' });
                    strColumn = 'Bal_IsRepetability'
                    break;
                case GlobalNomenclature.Eccentricity:
                    selectCalibWeights.condition.push(
                        { str_colName: 'Bal_IsEccentricity', value: 1, comp: 'eq' });
                    strColumn = 'Bal_IsEccentricity'
                    break;
                case "Linearity":
                    selectCalibWeights.condition.push(
                        { str_colName: 'Bal_Linearity', value: 1, comp: 'eq' });
                    strColumn = 'Bal_Linearity'
                    break;
            }

        }

        // let resSelectCalibWeights = await objDatabase.select(selectCalibWeights)
        let resSelectCalibWeights = await tbl_balance_weights.findAll({
            where: {
                'Bal_ID': strBalanceId,
                [`${strColumn}`]: 1

            }
        })
        return [resSelectCalibWeights];
    }


    async blnPreCalibDone(objPreCalibWeights, objCalibWeights) {

        var WtFound = [];
        if (objPreCalibWeights.length == objCalibWeights.length) {
            // Check the only calibration weights are set in precalibration
            for (let dailyWt = 0; dailyWt < objCalibWeights.length; dailyWt++) {

                WtFound.push({ "Wt": objCalibWeights[dailyWt].Bal_StdWt, "FoundFlg": false, UID: objCalibWeights[dailyWt].Id });

                for (let dailyPreWt = 0; dailyPreWt < objPreCalibWeights.length; dailyPreWt++) {

                    if (objCalibWeights[dailyWt].Bal_StdWt ==
                        objPreCalibWeights[dailyPreWt].Standard_Weight_Block) {
                        var objCalibWts = WtFound.find(k => k.UID == objCalibWeights[dailyWt].Id);
                        objCalibWts.FoundFlg = true;
                        break;
                    }

                }
            }

            var blnResult = WtFound.some(ele => ele.FoundFlg == false);
            if (blnResult) {
                return false;
            }
            else {
                return true;
            }

        }
        else {
            return false;
        }

    }

    async getWeighBoxDetails(WtBoxID, Wt) {


        let resCalibrationBox = await tbl_calibrationbox.findAll({
            attributes: [[sequelize.fn('max', sequelize.col('id')), 'id']],
            where: {
                'CB_Type': 'Weight Box',
                'CB_ID': WtBoxID,
                'CB_Wt': Wt,
            },
        })

        resCalibrationBox = [[resCalibrationBox[0]]]

        if (resCalibrationBox[0][0].id != null) {
            return "Matched";
        }
        else {
            return "Not Matched";
        }


    }


}
async function checkIfCalibrationPresent(strBalId) {

    let selectResult = await tbl_balance_weights.findAll({
        where: {
            "Bal_ID": strBalId
        }
    })

    selectResult = [selectResult]
    let array = [];
    for (let i = 0; i < selectResult[0].length; i++) {
        if (selectResult[0][i].Bal_Periodic == 1) {
            array.push('P');
        }
        if (selectResult[0][i].Bal_IsRepetability == 1) {
            array.push('R');
        }

        if (selectResult[0][i].Bal_IsEccentricity == 1) {
            array.push('E');
        }
        if (selectResult[0][i].Bal_IsUncertinity == 1) {
            array.push('U');
        }
        if (selectResult[0][i].Bal_Linearity == 1) {
            array.push('L');
        }

    }
    array = array.filter(function (item, pos, self) {
        return self.indexOf(item) == pos;
    })
    return array;


}
function sortObject(obj) {
    var arr = [];
    for (var prop in obj) {
        if (obj.hasOwnProperty(prop)) {
            arr.push({
                'key': prop,
                'value': obj[prop]
            });
        }
    }
    arr.sort(function (a, b) { return a.value - b.value; });
    //arr.sort(function(a, b) { a.value.toLowerCase().localeCompare(b.value.toLowerCase()); }); //use this to sort as strings
    return arr; // returns array
}

module.exports = PreCalibrationWeigth;