var checkForPenCal = require('./checkForPendingCalib');
var sort = require('./checkForPendingCalib');
var Comman = require('./clsCalibCommonFunction.model');
var comman = new Comman();
const FetchDetail = require('./../clsFetchDetails.model');
const fetchDetails = new FetchDetail()
const Database = require('./../../database/clsQueryProcess');
const database = new Database();
const FormulaFunction = require('./../Product/clsformulaFun.model');
const objFormulaFunction = new FormulaFunction();
const globalData = require('./../../global/globalData');
const obj_getRepSrNo = require('../Calibration/repSrNo');
const date = require('date-and-time');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const clsHmiModel = require('../hmiDetail.model')
const objHmiModel = new clsHmiModel();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const { Op } = require('sequelize')
const clsCommomInsertOperation = require('../Product/clsCommonInsertOperation.model')
const objClsInsertOp = new clsCommomInsertOperation();
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();

class CalibrationModel {
    // ****************************************************************************************************//
    // Below function takes argument as str_Protocol, IdSSrNo and stores all balance information related to
    // that IDS  
    //**************************************************************************************************** */
    async getCalibWeights(strBalID, strHmi, rasbpi) {
        try {
            // calculating balance Id assigned to that IDS
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            console.log('api hit')
            var strBalId = strBalID;
            let resObj = {};
            let srNo = 0;
            let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);

            if (TempCalibType != undefined) {
                TempCalibType.calibType = mqttProtocol.Periodic.toLowerCase();
                await fetchDetails.getBalanceCalibDetails(strBalId, strHmi)

            } else {
                globalData.arrcalibType.push({ DsNo: strHmi, calibType: mqttProtocol.Periodic.toLowerCase() })
                await fetchDetails.getBalanceCalibDetails(strBalId, strHmi) /**globalData.arrBalCaibDet.push({
                    strBalId: strBalId,
                    isPeriodicDone: true,
                }) */
            }

            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList.find(i => i.BalanceId == strBalId).PortNo;

            //monit
            await objMonit.monit({ case: 'Calibration', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });

            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "Hmi": strHmi,
                    "rasbpi": rasbpi,
                    "selectedBal": strBalId,
                    "portNo": strPortNo,
                    "InstrumentType": "Balance",
                })
            } else {
                hmiDetails.rasbpi = rasbpi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.portNo = strPortNo;
                hmiDetails.InstrumentType = "Balance";
            }
            var result = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': strBalId
                }
            })

            result = [result]

            let arrBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            if (arrBal == undefined) {
                globalData.arrBalance.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    balance_info: result[0]
                });
            } else {
                arrBal.balId = strBalId,
                    arrBal.balance_info = result[0]
            }

            // var tempIM = globalData.arrHexInfo.find(k => k.idsNo == IDSSrNo);
            var tempBalace = globalData.arrBalance.find(k => k.Hmi == strHmi)

            result = await models.tbl_balance_weights.findAll({

                where: {
                    'Bal_ID': strBalId,
                    'Bal_Periodic': 1
                },
                order: [['Bal_StdWt', 'ASC']]
            })
            result = [result];


            //compare gm and send g 
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (strUnitOfBal.balance_info[0].Bal_Unit.toLowerCase() == "gm") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = strUnitOfBal.balance_info[0].Bal_Unit;
            }



            // If Array of weights is Already present in globalData then we have to update this so we first remove 
            // and push new one OR Else if not present then we add new one
            var found = globalData.arrBalCalibWeights.some(function (el) {
                return el.Hmi == strHmi;
            });
            if (found) {
                const tempObj = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi);
                // removing Current obj
                var index = globalData.arrBalCalibWeights.indexOf(tempObj);
                if (index !== -1) globalData.arrBalCalibWeights.splice(index, 1);
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            } else {
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            }
            // Instrument Usage log for balance start

            // if (serverConfig.ProjectName == "RBH") { // Set in serverconfig file

            //     await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Linearity Calibration', 'started');
            //     return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Linearity Calib,${TareCmd}`;
            // }
            // else {
            // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
            // return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Periodic Calib,${TareCmd}`;
            // { 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo }
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
            if (tempCounter == undefined) {

                // var bln_isPresent = await comman.checkIfRecordInIncomplete('P', strBalId)
                // if (bln_isPresent == true) {

                //     let result = await models.tbl_calibration_periodic_master_incomplete.findAll({
                //         where: {
                //             "Periodic_BalID": strBalId
                //         }
                //     })



                //     let int_periodic_RepNo = result[0].Periodic_RepNo;
                //     let a = comman.caibrationFails('P', int_periodic_RepNo, strBalId ,'Monthly')

                // }

                globalData.arrCalibCounterApi.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counterApi': srNo })
            }
            if (tempCounter == undefined) {
                let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                // await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
                let data = {
                    Srno: 0,
                    Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(await this.precision(Number(result[0][0].Bal_StdWt))) + " " + strUnitAccordingDb, // objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP)
                    Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(await this.precision(Number(result[0][0].Bal_NegTol))) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(await this.precision(Number(result[0][0].Bal_PosTol))) + " " + strUnitAccordingDb,
                }
                let intsend = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                if (intsend == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                }
                else {
                    intsend.strBalId = strBalId;
                    intsend.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                }
                //globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                return Object.assign(resObj, {//{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo   objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP}
                    status: 'success',
                    result: data
                });
            }
            else {
                if (tempCounter.counterApi == result[0].length) {

                    await objMonit.monit({ case: 'CalibDone', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });
                    (globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrSelectedBalWithHmi : globalData.arrSelectedBalWithHmi.splice(globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1));

                        (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1); //counter clear
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);

                    //globalData.arrCalibCounterApi.splice( globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1)
                    console.log('done')
                    return Object.assign(resObj, {
                        status: 'success',
                        message: 'Calibration Successful'
                    });
                } else {
                    let intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                    if (intsendWt == undefined) {
                        globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                    }
                    else {
                        intsendWt.strBalId = strBalId;
                        intsendWt.sendWt = objFormulaFunction.FormatNumberString(result[0][tempCounter.counterApi].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                    }
                    let data = {
                        Srno: tempCounter.counterApi,
                        Bal_StdWt: parseFloat(result[0][tempCounter.counterApi].Bal_StdWt).toFixed(await this.precision(Number(result[0][tempCounter.counterApi].Bal_StdWt))) + " " + strUnitAccordingDb,
                        Bal_NegTol: parseFloat(result[0][tempCounter.counterApi].Bal_NegTol).toFixed(await this.precision(Number(result[0][tempCounter.counterApi].Bal_NegTol))) + " " + strUnitAccordingDb,
                        Bal_PosTol: parseFloat(result[0][tempCounter.counterApi].Bal_PosTol).toFixed(await this.precision(Number(result[0][tempCounter.counterApi].Bal_PosTol))) + " " + strUnitAccordingDb,
                    }
                    return Object.assign(resObj, {
                        status: 'success',
                        result: data
                    });
                }


            }






            // }
            // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
            // return 'CB01' + result[0][0].Bal_StdWt + 'g, 0.000,Periodic Calib,';

            // }


        }
        catch (err) {
            console.log("Error from getCalibWeights of Periodic", err)
            return `Error from getCalibWeights of Periodic ${err}`;
        }

    }


    //**************************************************************************************************************** */
    // Below function verifies recived weights is in range of tolerences and stores in database as in given situation
    // Also send next weights for calibrations
    //**************************************************************************************************************** */
    async verifyWeights(str_Protocol, strResPiNo, ProtocolData, ProtocolDecPoint) {
        try {
            let tempstrResPiNo = strResPiNo;
            let strHmi = await objHmiModel.getHmiNoFromResbPi(strResPiNo);
            strResPiNo = await objHmiModel.getAliasOfRPI(strResPiNo)
            let removeBalOfThatHmi = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let strBalId = removeBalOfThatHmi.selectedBal
            let now = new Date();
            var str_ProtocolData = str_Protocol;
            str_ProtocolData.split(':');
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            let resObj = {};
            let data = str_ProtocolData.split(":");
            var new_string = data[2].substr(data[2].search(/\d/));
            new_string = new_string.trim();
            let ProtocolDataAndUnit = new_string.split(" ");
            ProtocolDataAndUnit = ProtocolDataAndUnit.filter(k => k)
            let recieveWt = ProtocolData;

            let arrRemoveUnit = ProtocolDataAndUnit.filter(item => item);
            let unit = arrRemoveUnit[1];
            var srNo = 0;

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)

            //wadadadas///

            // calculating Balance Id related to that Ids
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            // var strBalId = tempCubicInfo.Sys_BalID;
            // calculating below parameted from string 
            // var srNo = str_Protocol.split(',')[0].substring(2, 4); // Weight Sr Number
            // var sendWt = str_Protocol.split(',')[0].substring(4).slice(0, -1); // Weight send for calibration
            // var recieveWt = str_Protocol.split(',')[1].split(' ')[0]; // recived weight after calibration
            // fetching calibration weights for that balance from global array with reference to Ids
            var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 
            //pushing while getting first wt globalData.arrBalCalibWeights
            // globalData.arrBalCalibWeights.push({
            //     Hmi: strHmi,
            //     balId : strBalId,
            //     calibWt: result[0] // array
            // })

            //current send wt
            let tempSendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
            const objSentWt = objBalRelWt.calibWt.find(j => j.Bal_StdWt == parseFloat(tempSendWt.sendWt));
            // console.log(objSentWt)

            //doubt
            // var objFailedFlag = globalData.arrFlagForFailCalib.find(k => k.idsNo == IDSSrNo);
            // if (objFailedFlag == undefined) {
            //     globalData.arrFlagForFailCalib.push({
            //         idsNo: IDSSrNo,
            //         failFlagDaily: false,
            //         failFlagPeriodic: false
            //     });
            //     objFailedFlag = globalData.arrFlagForFailCalib.find(k => k.idsNo == IDSSrNo);
            // }
            var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
            const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi);

            var strUnitAccordingDb;
            if (tempBalObject.balance_info[0].Bal_Unit.toLowerCase() == "gm") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = tempBalObject.balance_info[0].Bal_Unit;
            }

            var perferUnit;
            if (unit == undefined) {
                perferUnit = "g";
            } else {
                perferUnit = unit.toLowerCase();
            }


            if (strUnitAccordingDb.toLowerCase() !== perferUnit) {
                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Please Check the Balance Setting`);
                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                return
            } else {
                if (tempObj === undefined) {
                    globalData.arrCalibCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counter': srNo });
                }
                else {
                    tempObj.BalId = strBalId
                    tempObj.counter = tempObj.counter + 1;
                }
            }




            if (parseInt(srNo) <= objBalRelWt.calibWt.length) {
                //"CB0"


                var int_RepSrNo;


                // getting only balanceInfo
                const balanceInfo = tempBalObject.balance_info[0];
                // getting userIfo logged in for that cubicle


                var ResponseFrmPC = ""
                // getting reCaibration status from `tbl_recalibration_balance_status` on start up
                let BalanceRecalibStatusObject;
                if (removeBalType[0].type == "analytical") {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                } else {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                }

                const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);

                var resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                if (resArrOfDecimal == undefined) {

                    globalData.glbArrOfDecimal.push({
                        Hmi: strHmi,
                        decimalPoint: ProtocolDecPoint
                    })
                }
                else {
                    var resArrOfDecimal1 = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                    if (resArrOfDecimal1.decimalPoint >= ProtocolDecPoint) {
                        resArrOfDecimal1.decimalPoint = resArrOfDecimal1.decimalPoint;
                    } else {
                        resArrOfDecimal1.decimalPoint = ProtocolDecPoint;
                    }
                }
                resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);

                if (parseInt(tempCounter.counter) == 0) {
                    /** code for storing all the wgt in column of std wgt ,neg tol and pos tol */
                    var combineStdWt = "";
                    var combineLowerLimit = "";
                    var combineUpperLimit = "";
                    for (let i of objBalRelWt.calibWt) {
                        combineStdWt = combineStdWt + i.Bal_StdWt + ",";
                        combineLowerLimit = combineLowerLimit + i.Bal_NegTol + ",";
                        combineUpperLimit = combineUpperLimit + i.Bal_PosTol + ",";
                    }
                    combineLowerLimit = combineLowerLimit.slice(0, -1)
                    combineStdWt = combineStdWt.slice(0, -1)
                    combineUpperLimit = combineUpperLimit.slice(0, -1)
                    // Inserting entries in master table for daily/Periodic calibration
                    // Object for inserting data for Incommplete master


                    // removing cubicle according to resberryPi


                    var resulCubicleNo = await objClsInsertOp.getCubicalData(strResPiNo);


                    var RepNo = await obj_getRepSrNo.getReportSerialNumber('P', strBalId, strHmi, removeBalType[0].type);
                    var result = await models.tbl_precalibration_periodic.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    const periodic_precalib_weights = result[0];


                    await models.tbl_calibration_periodic_master_incomplete.create({
                        'Periodic_RepNo': RepNo,
                        'Periodic_CalbDate': date.format(new Date(), 'YYYY-MM-DD'),
                        'Periodic_CalbTime': date.format(new Date(), 'HH:mm:ss'),
                        'Periodic_BalID': balanceInfo.Bal_ID,
                        'Periodic_BalSrNo': balanceInfo.Bal_SrNo,
                        'Periodic_Make': balanceInfo.Bal_Make,
                        'Periodic_Model': balanceInfo.Bal_Model,
                        'Periodic_Unit': balanceInfo.Bal_Unit,
                        'Periodic_Dept': balanceInfo.Bal_Dept,
                        'Periodic_LeastCnt': balanceInfo.Bal_LeastCnt,
                        'Periodic_MaxCap': balanceInfo.Bal_MaxCap,
                        'Periodic_MinCap': balanceInfo.Bal_MinCap,
                        'Periodic_ZeroError': 0,
                        'Periodic_SpritLevel': 0,
                        'Periodic_GerneralCare': 0,
                        'Periodic_UserID': tempUserObject.UserId,
                        'Periodic_UserName': tempUserObject.UserName,
                        'Periodic_PrintNo': 0,
                        'Periodic_IsRecalib': BalanceRecalibStatusObject.PeriodicBalRecalib,
                        'Periodic_Location': resulCubicleNo[0].Sys_Location,
                        'Periodic_CubicalNo': resulCubicleNo[0].Sys_CubicNo,
                        'Periodic_Bal_MaxoptRange': balanceInfo.Bal_MaxoptRange,
                        'Periodic_Bal_MinoptRange': balanceInfo.Bal_MinoptRange,
                        'Periodic_RoomNo': resulCubicleNo[0].Sys_RoomNo,
                        'Periodic_DueDate': balanceInfo.Bal_CalbDueDt,
                        // "Decimal_Point": resArrOfDecimal.decimalPoint,
                        "Decimal_Point": balanceInfo.Bal_DP,
                        'Periodic_StdWeight': combineStdWt,
                        'Periodic_NegTol': combineLowerLimit,
                        'Periodic_PosTol': combineUpperLimit,
                        'Periodic_AllWeightboxID': periodic_precalib_weights.CalibrationBox_ID,
                        'Periodic_AllWeightboxCert': periodic_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'Periodic_AllWeightboxValidUpto': periodic_precalib_weights.CalibrationBox_Validity_Date,
                    })




                    await models.tbl_calibration_periodic_detail_incomplete.create({
                        'Periodic_RepNo': RepNo,
                        'Periodic_RecNo': 1,
                        'Periodic_BalStdWt': objSentWt.Bal_StdWt,
                        'Periodic_BalNegTol': objSentWt.Bal_NegTol,
                        'Periodic_BalPosTol': objSentWt.Bal_PosTol,
                        'Periodic_ActualWt': recieveWt,
                        'Periodic_StdWtBoxID': periodic_precalib_weights.CalibrationBox_ID,
                        'Periodic_StdWt': periodic_precalib_weights.CalibrationBox_Selected_Elements,
                        'Periodic_WtIdentification': '',
                        'Periodic_WeightBox_certfctNo': periodic_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': 0,
                        'Decimal_Point': 0,
                        'Periodic_ValDate': periodic_precalib_weights.CalibrationBox_Validity_Date,
                    })


                    // let objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    var objSentWtBal_StdWt = parseFloat(objSentWt.Bal_StdWt).toFixed(await this.precision(Number(objSentWt.Bal_StdWt)));
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                    // activity Entry for Perioic Calibration start

                    var objActivity = {}
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },

                        { activity: `${mqttProtocol.Periodic} Calibration Started On IDS ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', 'Accuracy Calibration', 'started');

                } else {
                    var int_periodic_RecNo1;
                    // Selecting data from tbl_calibration_periodic_master_incomplete based on 'strBalId'

                    let result = await models.tbl_calibration_periodic_master_incomplete.findAll({

                        attributes: [[sequelize.fn('max', sequelize.col('Periodic_RepNo')), "Periodic_RepNo"]],
                        where: {
                            "Periodic_BalID": strBalId
                        }
                    })


                    let int_periodic_RepNo = result[0].Periodic_RepNo;
                    // Selecting Periodic_RecNo from tbl_calibration_periodic_detail_incomplete based on 'int_periodic_RepNo'

                    result = await models.tbl_calibration_periodic_detail_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Periodic_RecNo')), "Periodic_RecNo"],

                        ],
                        where: {
                            "Periodic_RepNo": int_periodic_RepNo
                        },
                        raw: true
                    })

                    const Periodic_RecNo = result[0].Periodic_RecNo;
                    int_periodic_RecNo1 = Periodic_RecNo + 1;

                    // Selecting selectpreCalibWtObj from tbl_precalibration_periodic based on 'strBalId' and
                    // First weight was sent
                    result = await models.tbl_precalibration_periodic.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })


                    const periodic_precalib_weights = result[0];
                    // Inserting data in tbl_calibration_periodic_detail_incomplete

                    await models.tbl_calibration_periodic_detail_incomplete.create({
                        'Periodic_RepNo': int_periodic_RepNo,
                        'Periodic_RecNo': int_periodic_RecNo1,
                        'Periodic_BalStdWt': objSentWt.Bal_StdWt,
                        'Periodic_BalNegTol': objSentWt.Bal_NegTol,
                        'Periodic_BalPosTol': objSentWt.Bal_PosTol,
                        'Periodic_ActualWt': recieveWt,
                        'Periodic_StdWtBoxID': periodic_precalib_weights.CalibrationBox_ID,
                        'Periodic_StdWt': periodic_precalib_weights.CalibrationBox_Selected_Elements,
                        'Periodic_WtIdentification': '',
                        'Periodic_WeightBox_certfctNo': periodic_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': 0,
                        // 'Periodic_CertDate': periodic_precalib_weights.CalibrationBox_Calibration_Date,
                        'Decimal_Point': 0,
                        'Periodic_ValDate': periodic_precalib_weights.CalibrationBox_Validity_Date,
                    })

                    // await models.tbl_calibration_periodic_master_incomplete.update({
                    //     "Decimal_Point": resArrOfDecimal.decimalPoint,
                    //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                    // }, {
                    //     where: {
                    //         "Periodic_RepNo": int_periodic_RepNo
                    //     }
                    // });
                    // let objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    var objSentWtBal_StdWt = parseFloat(objSentWt.Bal_StdWt).toFixed(await this.precision(Number(objSentWt.Bal_StdWt)));
                    //  mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');

                }

                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command


                if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {

                    if (parseInt(tempCounter.counter) != objBalRelWt.calibWt.length - 1) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);
                    }

                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }

                    await objMonit.monit({ case: 'CalibWeight', Hmi: strHmi, data: { Weight: recieveWt } });


                    if (parseInt(tempCounter.counter) == objBalRelWt.calibWt.length - 1) {
                        console.log('done');
                        let tempCount = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCount.counterApi = tempCount.counterApi + 1;
                        // let balCalDetPeri = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);
                        // balCalDetPeri.isPeriodicDone = true;
                        // Updating Periodic status from 0 -> 1 in calibration_status table as well as our global array
                        // which holding calibration status
                        // If this calibration is last calibration then we have to move all caibration records
                        // to complete tables
                        // objFailedFlag.failFlagPeriodic = false;
                        var arr_sortedCalibArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId,removeBalType[0].type);
                        let lastCalibration = arr_sortedCalibArray[arr_sortedCalibArray.length - 1];
                        //find globalData.calibrationStatus according to hmi.

                        //remove max decimal from globalData.glbArrOfDecimal
                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;


                        //update max decimal point in master table


                        result = await models.tbl_calibration_periodic_master_incomplete.findAll({
                            attributes: [
                                [sequelize.fn('max', sequelize.col('Periodic_RepNo')), "Periodic_RepNo"]

                            ],
                            where: {
                                "Periodic_BalID": strBalId
                            },
                            raw: true
                        })

                        // let intPeriodic_RepNo = result[0]["max(`Periodic_RepNo`)"];
                        let intPeriodic_RepNo = result[0].Periodic_RepNo;


                        result = await models.tbl_calibration_periodic_master_incomplete.update({
                            // "Decimal_Point": decimalNumber,
                            "Periodic_EndTime": date.format(new Date(), 'HH:mm:ss')
                        }, {
                            where: {
                                "Periodic_RepNo": intPeriodic_RepNo
                            }
                        })

                        // const UpdateObj = {
                        //     str_tableName: "tbl_calibration_periodic_master_incomplete",
                        //     data: [
                        //         { str_colName: 'Decimal_Point', value: decimalNumber },
                        //     ],
                        //     condition: [
                        //         { str_colName: 'Periodic_RepNo', value: intPeriodic_RepNo, comp: 'eq' },
                        //     ]
                        // }
                        // await database.update(UpdateObj);

                        globalData.glbArrOfDecimal.splice(globalData.glbArrOfDecimal.findIndex((element) => element.Hmi === strHmi), 1)

                        var calibType = 'P';
                        for (var i in globalData.calibrationStatus) {
                            if (globalData.calibrationStatus[i].BalId == strBalId) {
                                globalData.calibrationStatus[i].status[calibType] = 1;
                                break; //Stop this loop, we found it!
                            }
                        }

                        /**
                         * Update According To IPC Balance or Analytical Balance
                         */
                        await comman.updateCalibStatus('P', strBalId, removeBalType[0].type)
                        await comman.incompleteToComplete('P', strBalId, removeBalType[0].type);
                        if (lastCalibration == 'P') {
                            await comman.UpdateRecalibFLagPeriodic(strBalId, removeBalType[0].type, "monthly");
                            BalanceRecalibStatusObject.PeriodicBalRecalib = 0;
                        }
                        let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                        //await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', '', 'completed');
                        // objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // result = await checkForPenCal.checkForPendingCalib(strBalId, IDSSrNo);
                        // activity Entry for Perioic Calibration Completion
                        // const tempUserObject = globalData.arrUsers.find(k => k.IdsNo == IDSSrNo);
                        var objActivity = {}

                        //  globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((e) => e.Hmi == strHmi) , 1);
                        // //  globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((e) => e.Hmi == strHmi) , 1);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${mqttProtocol.Periodic} Calibration Completed On IDS ${strHmi}` });

                        await objActivityLog.ActivityLogEntry(objActivity);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                        return Object.assign(resObj,
                            { strUserId: "tempUserObject.UserId" },
                            { strUserName: "tempUserObject.UserName" },
                            { status: 'Perioic Calibration Completed' });







                        // return result;

                    } else {
                        // console.log('else');
                        var tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCounter.counterApi = tempCounter.counterApi + 1; //{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counterApi': srNo }

                    }

                } else {
                    // We have to move records to failed tables

                    await objMonit.monit({ case: 'CalibFail', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });

                    let result = await models.tbl_calibration_periodic_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Periodic_RepNo')), 'Periodic_RepNo']],
                        where: {
                            "Periodic_BalID": strBalId
                        }
                    })


                    let int_periodic_RepNo;
                    if (result.length == 0) {
                        int_periodic_RepNo = 1;
                    } else {
                        int_periodic_RepNo = result[0].Periodic_RepNo;

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;

                        // await models.tbl_calibration_periodic_master_incomplete.update({
                        //     "Decimal_Point": decimalNumber,
                        //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Periodic_RepNo": int_periodic_RepNo
                        //     }
                        // });

                        await comman.caibrationFails('P', int_periodic_RepNo, strBalId, 'Monthly', true);
                    }

                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1);

                    globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi), 1)
                    globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1)


                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Periodic} Calibration Failed On IDS ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    mqttSender.sendData(strHmi, `DisplayResult:${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}:Calibration Failed`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                    //mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}false:Calibration Failed`);
                    console.log('Calibration Failed');
                    return 'CF';

                }

            }
        }
        catch (err) {
            console.log("Error from verifyWeights of Periodic", err)
            return `Error from verifyWeights of Periodic  ${err}`;
        }

    }

    async RaspberryDetailsWithHmi(strRasPi) {
        try {
            const obj = {
                str_tableName: 'tbl_idsport_details',
                data: '*',
                condition: [
                    { str_colName: 'Sys_IDSNo', value: strRasPi }
                ]
            }

            let arrRes = await database.select(obj);
            return arrRes[0][0].HMI
        } catch (error) {
            throw new Error(error)
        }
    }

    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }
}
module.exports = CalibrationModel