const dbCon = require('../../Utills/db');
var checkForPenCal = require('./checkForPendingCalib');
var sort = require('./checkForPendingCalib');
var Comman = require('./clsCalibCommonFunction.model');
var comman = new Comman();
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const objPowerBackup = new PowerBackup();
const FetchDetail = require('./../clsFetchDetails.model');
const fetchDetails = new FetchDetail()
const Database = require('./../../database/clsQueryProcess');
const database = new Database();
const FormulaFunction = require('./../Product/clsformulaFun.model'); //make this function
const objFormulaFunction = new FormulaFunction();
const globalData = require('./../../global/globalData');
const obj_getRepSrNo = require('../Calibration/repSrNo');
const date = require('date-and-time');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const { Op } = require('sequelize')
const clsHmiModel = require('../hmiDetail.model')
const objHmiModel = new clsHmiModel();
const loggers = require('../winstonLogger');
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();

class CalibrationModel {
    // ****************************************************************************************************//
    // Below function takes argument as str_Protocol, IdSSrNo and stores all balance information related to
    // that IDS
    //**************************************************************************************************** */
    async getCalibWeights(strBalID, strHmi, rasbpi) {
        try {
            // calculating balance Id assigned to that IDS
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            var strBalId = strBalID;
            let resObj = {};
            let srNo = 0;
            // Check if there is entries in incomplete tables so we need to move it into failed tables
            let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            // var bln_isPresent = await comman.checkIfRecordInIncomplete('E', strBalId)
            let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)


            if (TempCalibType != undefined) {
                TempCalibType.calibType = 'eccentricity';
            } else {
                globalData.arrcalibType.push({ DsNo: strHmi, calibType: mqttProtocol.Eccentricity.toLowerCase() })
            }

            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList.find(i => i.BalanceId == strBalId).PortNo;

            //monit
            await objMonit.monit({ case: 'Calibration', Hmi: strHmi, data: { calibType: mqttProtocol.Eccentricity } });

            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "Hmi": strHmi,
                    "rasbpi": rasbpi,
                    "selectedBal": strBalId,
                    "portNo": strPortNo,
                    "InstrumentType": "Balance",
                })
            } else {
                hmiDetails.rasbpi = rasbpi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.portNo = strPortNo;
                hmiDetails.InstrumentType = "Balance";
            }

            // Storing all the balance details for 'tbl_balance' in global array
            var result = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': strBalId
                }
            })

            result = [result]

            let arrBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            if (arrBal == undefined) {
                globalData.arrBalance.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    balance_info: result[0]
                });
            } else {
                arrBal.balId = strBalId,
                    arrBal.balance_info = result[0]
            }
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (strUnitOfBal.balance_info[0].Bal_Unit.toLowerCase() == "gm") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = strUnitOfBal.balance_info[0].Bal_Unit;
            }
            // var tempIM = globalData.arrHexInfo.find(k => k.idsNo == IDSSrNo);
            var tempBalace = globalData.arrBalance.find(k => k.Hmi == strHmi)

            result = await models.tbl_balance_weights.findAll({

                where: {
                    'Bal_ID': strBalId,
                    'Bal_IsEccentricity': 1
                },
                order: [['Bal_StdWt', 'ASC']]
            })
            result = [result];


            // If Array of weights is Already present in globalData then we have to update this so we first remove 
            // and push new one OR Else if not present then we add new one
            var found = globalData.arrBalCalibWeights.some(function (el) {
                return el.Hmi == strHmi;
            });
            if (found) {
                const tempObj = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi);
                // removing Current obj
                var index = globalData.arrBalCalibWeights.indexOf(tempObj);
                if (index !== -1) globalData.arrBalCalibWeights.splice(index, 1);
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            } else {
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            }

            // var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
            if (tempCounter == undefined) {

                // var bln_isPresent = await comman.checkIfRecordInIncomplete('E', strBalId)
                // if (bln_isPresent == true) {

                //     let result = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                //         where: {
                //             "Eccent_BalID": strBalId
                //         }
                //     })


                //     let int_Eccent_RepNo = result[0].Eccent_RepNo;
                //     let a = comman.caibrationFails('E', int_Eccent_RepNo, strBalId ,'Yearly')

                // }

                globalData.arrCalibCounterApi.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counterApi': srNo })
            }
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let _calib_count = tempCounter == undefined ? 0 : tempCounter.counterApi
            // }
            //29-05-2022 _calibration powerbakup implement --Ash.....:>
            var _powerbackupCalib = {
                strTableName: 'tbl_calibration_eccentricity_master_incomplete',
                strDetailTbl: 'tbl_calibration_eccentricity_detail_incomplete',
                cubicaNo: 'NUll',
                cubicType: 'NUll',
                cubicSysBFGcode: 'NUll',
                cubicBatch: 'NUll',
                menuName: 'Eccentricity',
                productType: 'NUll',
                Userid: tempUserObject.UserId,
                idsNo: rasbpi,
                Hmi: strHmi,
                RecSampleNo: _calib_count,
                ReportType: 'NUll',
                _bal_id: strBalId,

            }
            let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
            if (_check_combination !== undefined) {
                if (tempCounter == undefined) {
                    tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                }
                tempCounter.counterApi = _check_combination.RecSampleNo + 1;
                _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                tempCounter.counterApi = tempCounter.counterApi
            }
            else {
                if (tempCounter != undefined) {
                    tempCounter.counterApi += 1;
                    _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                    tempCounter.counterApi = tempCounter.counterApi
                }
            }

            if (tempCounter == undefined) {
                let strResbPi = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                // await objInstrumentUsage.InstrumentUsage('Balance', strResbPi, 'tbl_instrumentlog_balance', 'Eccentricity Calibration', 'started');
                let data = {
                    Srno: 0,
                    Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(3) + " " + strUnitAccordingDb,
                    Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(3) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(3) + " " + strUnitAccordingDb,
                    // Bal_StdWt: objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP), // objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP)
                    // Bal_NegTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_NegTol, tempBalace.balance_info[0].Bal_DP),
                    // Bal_PosTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_PosTol, tempBalace.balance_info[0].Bal_DP),
                }
                let intsend = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                if (intsend == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                }
                else {
                    intsend.strBalId = strBalId;
                    intsend.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                }
                //globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId' :  strBalId , 'sendWt':    objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)});
                return Object.assign(resObj, {//{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo   objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP}
                    status: 'success',
                    result: data
                });
            }
            else {
                let result1 = await models.tbl_precalibration_eccentricity.findAll({
                    where: {
                        "Equipment_ID": strBalId,
                        "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                    }
                })

                var repeat_precalib_weights = result1[0];
                var counterRepeat = repeat_precalib_weights.Repeat_Count;

                if (tempCounter.counterApi == counterRepeat) {

                    await objMonit.monit({ case: 'CalibDone', Hmi: strHmi, data: { calibType: mqttProtocol.Eccentricity } });
                    (globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrSelectedBalWithHmi : globalData.arrSelectedBalWithHmi.splice(globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1));

                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1); //counter clear
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrsendWt : globalData.arrsendWt.splice(globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi), 1);
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'Eccentricity',
                            Idsno: strHmi
                        }
                    })
                    //globalData.arrCalibCounterApi.splice( globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1)
                    return Object.assign(resObj, {
                        status: 'success',
                        message: 'Calibration Successful'
                    });


                } else {


                    let intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                    if (intsendWt == undefined) {
                        globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                    }
                    else {
                        intsendWt.strBalId = strBalId;
                        intsendWt.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                    }
                    let data = {
                        Srno: tempCounter.counterApi,
                        Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(3) + " " + strUnitAccordingDb,
                        Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(3) + " " + strUnitAccordingDb,
                        Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(3) + " " + strUnitAccordingDb,
                        // Bal_StdWt: objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP),
                        // Bal_NegTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_NegTol, tempBalace.balance_info[0].Bal_DP),
                        // Bal_PosTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_PosTol, tempBalace.balance_info[0].Bal_DP),
                    }
                    return Object.assign(resObj, {
                        status: 'success',
                        result: data
                    });

                }

            }


        }
        catch (err) {
            console.log("Error from getCalibWeights of Eccentricity", err)
            loggers.CalibrationErrorLogger.error(`${err} recieved in getCalibWeights (eccentrcity) function from device : ${strHmi}`)
            throw new Error(err, "Error from getCalibWeights of Eccentricity")
            // return `Error from getCalibWeights of Periodic ${err}`;
        }

    }


    //**************************************************************************************************************** */
    // Below function verifies recived weights is in range of tolerences and stores in database as in given situation
    // Also send next weights for calibrations
    //**************************************************************************************************************** */
    async verifyWeights(str_Protocol, strResPiNo, ProtocolData, ProtocolDecPoint) {
        try {
            let tempstrResPiNo = strResPiNo;
            let strHmi = await objHmiModel.getHmiNoFromResbPi(strResPiNo);
            strResPiNo = await objHmiModel.getAliasOfRPI(strResPiNo)
            let removeBalOfThatHmi = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let strBalId = removeBalOfThatHmi.selectedBal
            let now = new Date();
            var str_ProtocolData = str_Protocol;
            str_ProtocolData.split(':');
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            let resObj = {};
            let data = str_ProtocolData.split(":");
            var new_string = data[2].substr(data[2].search(/\d/));
            new_string = new_string.trim();
            let ProtocolDataAndUnit = new_string.split(" ");
            ProtocolDataAndUnit = ProtocolDataAndUnit.filter(k => k)
            let recieveWt = ProtocolData;
            let unit = ProtocolDataAndUnit[1];
            var srNo = 0;

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)

            //wadadadas///

            // calculating Balance Id related to that Ids
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            // var strBalId = tempCubicInfo.Sys_BalID;
            // calculating below parameted from string 
            // var srNo = str_Protocol.split(',')[0].substring(2, 4); // Weight Sr Number
            // var sendWt = str_Protocol.split(',')[0].substring(4).slice(0, -1); // Weight send for calibration
            // var recieveWt = str_Protocol.split(',')[1].split(' ')[0]; // recived weight after calibration
            // fetching calibration weights for that balance from global array with reference to Ids
            var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 
            //pushing while getting first wt globalData.arrBalCalibWeights
            // globalData.arrBalCalibWeights.push({
            //     Hmi: strHmi,
            //     balId : strBalId,
            //     calibWt: result[0] // array
            // })

            //current send wt
            let tempSendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
            const objSentWt = objBalRelWt.calibWt.find(j => j.Bal_StdWt == parseFloat(tempSendWt.sendWt));

            var objOwner = globalData.arrPreWeighCalibOwner.find(k => k.idsNo == strResPiNo);


            let result = await models.tbl_precalibration_eccentricity.findAll({
                where: {
                    "Equipment_ID": strBalId,
                    "Standard_Weight_Block": objSentWt.Bal_StdWt,
                    "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                }
            })


            var eccentricity_precalib_weights = result[0];
            var counterEcc = eccentricity_precalib_weights.Repeat_Count;

            // var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
            // if (tempObj === undefined) {
            //     globalData.arrCalibCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counter': srNo });
            // }
            // else {
            //     tempObj.BalId = strBalId
            //     tempObj.counter = tempObj.counter + 1;
            // }

            const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi);

            var strUnitAccordingDb;
            if (tempBalObject.balance_info[0].Bal_Unit.startsWith('g')) {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = tempBalObject.balance_info[0].Bal_Unit;
            }

            var perferUnit;
            if (unit == undefined) {
                perferUnit = "g";
            } else {
                if (unit.toLowerCase() === "gm" || unit.toLowerCase() === "g")
                    perferUnit = "g";
                else
                    perferUnit = unit.toLowerCase();
            }

            var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);

            if (strUnitAccordingDb.toLowerCase() !== perferUnit) {
                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Please Check the Balance Setting`);
                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                return
            } else {
                if (tempObj === undefined) {
                    globalData.arrCalibCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counter': srNo });
                }
                else {
                    tempObj.BalId = strBalId
                    tempObj.counter = tempObj.counter + 1;
                }
            }


            if (parseInt(srNo) <= counterEcc) {
                //"CB0"


                var int_RepSrNo;

                const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi);
                // getting only balanceInfo
                const balanceInfo = tempBalObject.balance_info[0];
                // getting userIfo logged in for that cubicle
                recieveWt = Number(recieveWt).toFixed(3)
                var ResponseFrmPC = ""
                // getting reCaibration status from `tbl_recalibration_balance_status` on start

                let BalanceRecalibStatusObject;
                if (removeBalType[0].type == "analytical") {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                } else {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                }
                const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                var _powerbackupCalib = {
                    strTableName: 'tbl_calibration_eccentricity_master_incomplete',
                    strDetailTbl: 'tbl_calibration_eccentricity_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Eccentricity',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }
                let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
                if (_check_combination !== undefined) {
                    // let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                    // if(tempCounter == undefined){
                    //     tempCounter  = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                    // }
                    tempCounter.counter = _check_combination.RecSampleNo + 1;
                    // if(tempDetailCounterObjInsert.insertingDetailCounter == 1){
                    // tempDetailCounterObjInsert.insertingDetailCounter = tempCounter.counter + 1
                    // }
                    // _powerbackupCalib.RecSampleNo = tempCounter.counter 
                    tempCounter.counter = tempCounter.counter
                }
                _powerbackupCalib = {
                    strTableName: 'tbl_calibration_eccentricity_master_incomplete',
                    strDetailTbl: 'tbl_calibration_eccentricity_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Eccentricity',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }

                await objPowerBackup.get_Calib_Status_oF_Test_ForPowerBackup(_powerbackupCalib);
                // const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);

                var resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                if (resArrOfDecimal == undefined) {

                    globalData.glbArrOfDecimal.push({
                        Hmi: strHmi,
                        decimalPoint: ProtocolDecPoint
                    })
                }
                else {
                    var resArrOfDecimal1 = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                    if (resArrOfDecimal1.decimalPoint >= ProtocolDecPoint) {
                        resArrOfDecimal1.decimalPoint = resArrOfDecimal1.decimalPoint;
                    } else {
                        resArrOfDecimal1.decimalPoint = ProtocolDecPoint;
                    }
                }
                resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);



                var result_remark = "Not Ok"
                if (parseInt(tempCounter.counter) == 0) {
                    /** code for storing all the wgt in column of std wgt ,neg tol and pos tol */
                    var combineStdWt = "";
                    var combineLowerLimit = "";
                    var combineUpperLimit = "";
                    for (let i of objBalRelWt.calibWt) {
                        combineStdWt = combineStdWt + i.Bal_StdWt + ",";
                        combineLowerLimit = combineLowerLimit + i.Bal_NegTol + ",";
                        combineUpperLimit = combineUpperLimit + i.Bal_PosTol + ",";
                    }
                    combineLowerLimit = combineLowerLimit.slice(0, -1)
                    combineStdWt = combineStdWt.slice(0, -1)
                    combineUpperLimit = combineUpperLimit.slice(0, -1)

                    // removing cubicle according to resberryPi
                    var resulCubicleNo = await models.tbl_cubical.findAll({
                        where: {
                            "Sys_IDSNo": strResPiNo
                        }
                    });
                    // Inserting entries in master table for daily/Periodic calibration
                    // Object for inserting data for Incommplete master
                    var RepNo = await obj_getRepSrNo.getReportSerialNumber('E', strBalId, strHmi, removeBalType[0].type);
                    result = await models.tbl_precalibration_eccentricity.findAll({
                        where: {
                            "Equipment_ID": strBalId,
                            "Standard_Weight_Block": objSentWt.Bal_StdWt,
                            "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    var ecenn_precalib_weights = result[0];
                    await models.tbl_calibration_eccentricity_master_incomplete.create({
                        'Eccent_RepNo': RepNo,
                        'Eccent_CalbDate': date.format(now, 'YYYY-MM-DD'),
                        'Eccent_CalbTime': date.format(now, 'HH:mm:ss'),
                        'Eccent_BalID': balanceInfo.Bal_ID,
                        'Eccent_BalSrNo': balanceInfo.Bal_SrNo,
                        'Eccent_Make': balanceInfo.Bal_Make,
                        'Eccent_Model': balanceInfo.Bal_Model,
                        'Eccent_Unit': balanceInfo.Bal_Unit,
                        'Eccent_Dept': balanceInfo.Bal_Dept,
                        'Eccent_LeastCnt': balanceInfo.Bal_LeastCnt,
                        'Eccent_MaxCap': balanceInfo.Bal_MaxCap,
                        'Eccent_MinCap': balanceInfo.Bal_MinCap,
                        'Eccent_ZeroError': 0,
                        'Eccent_SpritLevel': 0,
                        'Eccent_GerneralCare': 0,
                        'Eccent_UserID': tempUserObject.UserId,
                        'Eccent_UserName': tempUserObject.UserName,
                        'Eccent_StdWeight': Number(ecenn_precalib_weights.Standard_Weight_Block).toFixed(3),
                        'Eccent_NegTol': ecenn_precalib_weights.Negative_Tolerance,
                        'Eccent_PosTol': ecenn_precalib_weights.Positive_Tolerance,
                        'Eccent_DueDate': balanceInfo.Bal_CalbDueDtU,
                        'Eccent_Location': resulCubicleNo[0].Sys_Location,
                        'Eccent_RoomNo': resulCubicleNo[0].Sys_RoomNo,
                        'Eccent_AllWeightboxID': ecenn_precalib_weights.CalibrationBox_ID,
                        'Eccent_AllWeightboxCert': ecenn_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'Eccent_AllWeightboxValidUpto': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                        // 'Decimal_Point': resArrOfDecimal.decimalPoint,
                        "Eccent_Remark": "NA",
                        'Decimal_Point': balanceInfo.Bal_DP,
                    })
                    // Selecting Preclalibration weight from tbl_calibration_periodic_detail_incomplete
                    result = await models.tbl_precalibration_eccentricity.findAll({
                        where: {
                            "Equipment_ID": strBalId,
                            "Standard_Weight_Block": objSentWt.Bal_StdWt,
                            "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    var ecenn_precalib_weights = result[0];
                    await models.tbl_calibration_eccentricity_detail_incomplete.create({
                        'Eccent_RecNo': 1,
                        'Eccent_RepNo': RepNo,
                        'Eccent_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(3),
                        'Eccent_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(3),
                        'Eccent_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(3),
                        'Eccent_ActualWt': recieveWt,
                        'Eccent_StdWtID': ecenn_precalib_weights.CalibrationBox_ID,
                        'Eccent_StdWt': ecenn_precalib_weights.CalibrationBox_Selected_Elements,
                        'Eccent_WtIdentification': '',
                        'Eccent_WeightBox_certfctNo': ecenn_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': ecenn_precalib_weights.Percent_of_Capacity,
                        'Eccent_ValDate': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                        "Eccent_Remark":result_remark
                        // 'Eccent_DateOfWeighBox': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                        // 'Eccent_DueDateOfWeighBox': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                    })
                    await models.tbl_powerbackup.update({
                        Incomp_RepSerNo: RepNo
                    }, {
                        where: {
                            Idsno: strHmi
                        }
                    });
                    var objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)

                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt}:${recieveWt}`);

                    // activity Entry for Perioic Calibration start

                    var objActivity = {}
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Eccentricity} Calibration Started On TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);

                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', 'Eccentricity Calibration', 'started');


                } else {
                    var int_Eccent_RecNo1;
                    // Selecting data from tbl_calibration_periodic_master_incomplete based on 'strBalId'

                    let result = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Eccent_RepNo')), "Eccent_RepNo"]],
                        where: {
                            "Eccent_BalID": strBalId
                        }
                    })


                    var int_Eccentricity_RepNo = result[0].Eccent_RepNo;
                    // Selecting Periodic_RecNo from tbl_calibration_periodic_detail_incomplete based on 'int_periodic_RepNo'

                    result = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Eccent_RecNo')), "Eccent_RecNo"],
                            [sequelize.fn('max', sequelize.col('Eccent_ActualWt')), "Eccent_ActualWt"]

                        ],
                        where: {
                            "Eccent_RepNo": int_Eccentricity_RepNo
                        },
                        raw: true
                    })
                    const Eccentricity_RecNo = result[0].Eccent_RecNo;
                    int_Eccent_RecNo1 = Eccentricity_RecNo + 1;

                    // Selecting selectpreCalibWtObj from tbl_precalibration_periodic based on 'strBalId' and
                    // First weight was sent
                    result = await models.tbl_precalibration_eccentricity.findAll({
                        where: {
                            "Equipment_ID": strBalId,
                            "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    var ecenn_precalib_weights = result[0];

                    // Inserting data in tbl_calibration_periodic_detail_incomplete

                    await models.tbl_calibration_eccentricity_detail_incomplete.create({
                        'Eccent_RecNo': int_Eccent_RecNo1,
                        'Eccent_RepNo': int_Eccentricity_RepNo,
                        'Eccent_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(3),
                        'Eccent_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(3),
                        'Eccent_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(3),
                        'Eccent_ActualWt': recieveWt,
                        'Eccent_StdWtID': ecenn_precalib_weights.CalibrationBox_ID,
                        'Eccent_StdWt': ecenn_precalib_weights.CalibrationBox_Selected_Elements,
                        'Eccent_WtIdentification': '',
                        'Eccent_WeightBox_certfctNo': ecenn_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': ecenn_precalib_weights.Percent_of_Capacity,
                        'Eccent_ValDate': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                        'Eccent_Remark':result_remark

                        // 'Eccent_DateOfWeighBox': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                        // 'Eccent_DueDateOfWeighBox': ecenn_precalib_weights.CalibrationBox_Validity_Date,
                    })
                    var resultdev = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                        where: {
                            "Eccent_RepNo": int_Eccentricity_RepNo,
                            "Eccent_RecNo": 1
                        },
                        raw: true
                    })
                    var eccentdev = recieveWt - resultdev[0].Eccent_ActualWt

                    eccentdev = eccentdev.toFixed(3)
                    // eccentdev = eccentdev.toLocaleString()
                    // if (eccentdev <= 0.05) {
                    //     result_remark = "Ok"
                    // }
                    result = await models.tbl_calibration_eccentricity_detail_incomplete.update({
                        Eccent_Deviation: eccentdev
                    }, {
                        where: {
                            "Eccent_RepNo": int_Eccentricity_RepNo,
                            "Eccent_RecNo": int_Eccent_RecNo1
                        }
                    })


                    var objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt}:${recieveWt}`);

                    // await models.tbl_calibration_eccentricity_master_incomplete.update({
                    //     "Decimal_Point": resArrOfDecimal.decimalPoint,
                    //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                    // }, {
                    //     where: {
                    //         "Eccent_RepNo": int_Eccentricity_RepNo
                    //     }
                    // });


                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');


                }
                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command

               



                if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {
                    if (parseInt(tempCounter.counter) != counterEcc - 1) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(3) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(3) + " " + perferUnit}`);
                    }
                    if(int_Eccentricity_RepNo == undefined){
                        int_Eccentricity_RepNo  = RepNo,
                        int_Eccent_RecNo1 = 1
                    }else{
                        int_Eccentricity_RepNo = int_Eccentricity_RepNo,
                        int_Eccent_RecNo1 = int_Eccent_RecNo1
                    }
                    
                     resultdev = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                        where: {
                            "Eccent_RepNo": int_Eccentricity_RepNo,
                            "Eccent_RecNo": 1
                        },
                        raw: true
                    })
                    
                    var eccentdev = recieveWt - resultdev[0].Eccent_ActualWt

                    eccentdev = eccentdev.toFixed(3)
                    // eccentdev = eccentdev.toLocaleString()
                    if (eccentdev <= 0.05) {
                        result_remark = "Ok"
                    }
                    result = await models.tbl_calibration_eccentricity_detail_incomplete.update({
                        Eccent_Deviation: eccentdev
                    }, {
                        where: {
                            "Eccent_RepNo": int_Eccentricity_RepNo,
                            "Eccent_RecNo": int_Eccent_RecNo1
                        }
                    })
                    if (parseInt(tempCounter.counter) == 0) {
                        result_remark = await models.tbl_calibration_eccentricity_detail_incomplete.update({
                            Eccent_Remark: "Ok"
                        }, {
                            where: {
                                "Eccent_RepNo": RepNo,
                                "Eccent_RecNo": 1
                            }
                        });
                    } else {
                        result_remark = await models.tbl_calibration_eccentricity_detail_incomplete.update({
                            Eccent_Remark: result_remark
                        }, {
                            where: {
                                "Eccent_RepNo": int_Eccentricity_RepNo,
                                "Eccent_RecNo": int_Eccent_RecNo1
                            }
                        });
                    }
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }

                    await objMonit.monit({ case: 'CalibWeight', Hmi: strHmi, data: { Weight: recieveWt } });
                    // var updateremark = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                    //     where:{
                    //         'Eccent_RecNo': int_Eccent_RecNo1,
                    //     }
                    // })
                    // updateremark = updateremark

                    //    var updateremark = await models.tbl_calibration_eccentricity_detail_incomplete.update({
                    //     [`Eccent_Remark${tempCounter.counter}`]:'OK',
                    //     [`Eccent_Deviation${tempCounter.counter}`]:''},{
                    //         where:{
                    //             'Eccent_RecNo': int_Eccent_RecNo1,
                    //         }
                    //    });
                    // var result_remark


                    if (parseInt(tempCounter.counter) == counterEcc - 1) {


                        // var tempCounter1 = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        // var setSrnoToZero = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                        // setSrnoToZero.counter = 0 ;
                        // tempCounter1.counterApi = tempCounter1.counterApi + 1;
                        let tempCount = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCount.counterApi = tempCount.counterApi + 1;
                        console.log('done');

                        //need to be done
                        // let balCalDetPeri = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);
                        // balCalDetPeri.isPeriodicDone = true;


                        // Updating Periodic status from 0 -> 1 in calibration_status table as well as our global array
                        // which holding calibration status
                        // If this calibration is last calibration then we have to move all caibration records
                        // to complete tables
                        // objFailedFlag.failFlagPeriodic = false;

                        //var objAccepancelimit=await this.checkEccentricityAccepancelimit(strBalId,balanceInfo.Bal_DP)

                        // if (objAccepancelimit=='Not Complies'){
                        //     console.log('Fail')
                        // }

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;


                        //update max decimal point in master table
                        let result = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                            attributes: [
                                [sequelize.fn('max', sequelize.col('Eccent_RepNo')), "Eccent_RepNo"]

                            ],
                            where: {
                                "Eccent_BalID": strBalId
                            },
                        })
                        let intEccentRepNo = result[0].Eccent_RepNo;
                        let remarkAll = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                            where: {
                                "Eccent_RepNo": intEccentRepNo
                            },
                        })
                        let intEccentRepNo1 = remarkAll;
                        var remark_report = "Within limit"
                        if (intEccentRepNo1 != undefined) {
                            for (var i in intEccentRepNo1) {
                                if (intEccentRepNo1[i].Eccent_Deviation != null) {
                                    if (Number(intEccentRepNo1[i].Eccent_Deviation) >= 0.05 || Number(intEccentRepNo1[i].Eccent_Deviation) <= -0.05) {
                                        remark_report = "Out of limit"
                                        //Stop this loop, we found it!
                                    }
                                }
                            }
                        }

                        await models.tbl_calibration_eccentricity_master_incomplete.update({
                            Eccent_Remark: remark_report
                        }, {
                            where: {
                                "Eccent_RepNo": intEccentRepNo
                            }
                        });


                        // result = await models.tbl_calibration_eccentricity_master_incomplete.update({
                        //     // "Decimal_Point": decimalNumber,
                        //     "Eccent_EndTime": date.format(new Date(), 'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Eccent_RepNo": intEccentRepNo
                        //     }
                        // })


                        var arr_sortedCalibArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, removeBalType[0].type);
                        let lastCalibration = arr_sortedCalibArray[arr_sortedCalibArray.length - 1];
                        // //find globalData.calibrationStatus according to hmi.
                        var calibType = 'E';
                        for (var i in globalData.calibrationStatus) {
                            if (globalData.calibrationStatus[i].BalId == strBalId) {
                                globalData.calibrationStatus[i].status[calibType] = 1;
                                break; //Stop this loop, we found it!
                            }
                        }
                        await comman.updateCalibStatus('E', strBalId, removeBalType[0].type)
                        await comman.incompleteToComplete('E', strBalId, removeBalType[0].type, true);
                        if (lastCalibration == 'E') {
                            await comman.UpdateRecalibFLagPeriodic(strBalId, removeBalType[0].type, 'Monthly');
                            BalanceRecalibStatusObject.YearBalRecalib = 0;
                        }
                        let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                        await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // result = await checkForPenCal.checkForPendingCalib(strBalId, IDSSrNo);
                        // activity Entry for Perioic Calibration Completion
                        // const tempUserObject = globalData.arrUsers.find(k => k.IdsNo == IDSSrNo);
                        var objActivity = {}

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${mqttProtocol.Eccentricity} Calibration Completed On TSH ${strHmi}` });

                        await objActivityLog.ActivityLogEntry(objActivity);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(3) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(3) + " " + perferUnit}`);

                        mqttSender.sendData(strHmi, `${mqttProtocol.Eccentricity} Calibration Completed`);

                        return Object.assign(resObj,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { status: 'Eccentricity Calibration Completed' });


                        // return result;

                    } else {
                        // console.log('else');
                        var tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCounter.counterApi = tempCounter.counterApi + 1;
                        //{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counterApi': srNo }

                    }

                } else {
                    // We have to move records to failed tables

                    await objMonit.monit({ case: 'CalibFail', Hmi: strHmi, data: { calibType: mqttProtocol.Eccentricity } });

                    let result = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Eccent_RepNo')), 'Eccent_RepNo']],
                        where: {
                            "Eccent_BalID": strBalId
                        }
                    })

                    let int_Eccent_RepNo
                    if (result[0].length == 0) {
                        int_Eccent_RepNo = 1;
                    } else {
                        int_Eccent_RepNo = result[0].Eccent_RepNo;

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;

                        // await models.tbl_calibration_eccentricity_master_incomplete.update({
                        //     "Decimal_Point": decimalNumber,
                        //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Eccent_RepNo": int_Eccent_RepNo
                        //     }
                        // });

                        await comman.caibrationFails('E', int_Eccent_RepNo, strBalId, 'Monthly', true, removeBalType[0].type);
                    }

                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1);

                    globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi), 1)
                    globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1)
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'Eccentricity',
                            Idsno: strHmi
                        }
                    })
                    // objFailedFlag.failFlagPeriodic = true;
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Eccentricity} Calibration Failed on TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    mqttSender.sendData(strHmi, `DisplayResult:${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(3) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(3) + " " + perferUnit}:Calibration Failed`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                    // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}false:Calibration Failed`);
                    return 'CF';

                }

            }
        }
        catch (err) {
            console.log("Error from verifyWeights of Eccentricity", err)
            throw new Error(err, "Error from getCalibWeights of Periodic")
        }

    }

    async RaspberryDetailsWithHmi(strRasPi) {
        try {
            const obj = {
                str_tableName: 'tbl_idsport_details',
                data: '*',
                condition: [
                    { str_colName: 'Sys_IDSNo', value: strRasPi }
                ]
            }

            let arrRes = await database.select(obj);
            return arrRes[0][0].HMI
        } catch (error) {
            throw new Error(error)
        }
    }


    async checkEccentricityAccepancelimit(strBalId, Bal_DP) {
        try {


            var masterTableName = 'tbl_calibration_eccentricity_master_incomplete';
            var detailTableName = 'tbl_calibration_eccentricity_detail_incomplete';

            var dp = Bal_DP

            // const selectRepSrNoObj = {
            //     str_tableName: detailTableName,
            //     data: 'MAX(repet_repno) as Eccent_RepNo',
            //     condition: [
            //         { str_colName: 'Eccent_RepNo', value: strBalId, comp: 'eq' },
            //     ]
            // }


            var SqlQuery = `SELECT * FROM ${detailTableName} WHERE Eccent_RepNo=`
            SqlQuery = SqlQuery + `(SELECT MAX(Eccent_RepNo) AS Eccent_RepNo FROM ${masterTableName} WHERE Eccent_BalID ='${strBalId}')`

            var objselectRepSrNoObj = await dbCon.query(SqlQuery)

            if (objselectRepSrNoObj[0].length > 0) {
                var detailData = objselectRepSrNoObj[0];
                var repSrNo = objselectRepSrNoObj[0][0].Eccent_RepNo;
                var count = 0, finalVal;
                for (var i = 0; i < detailData.length; i++) {
                    /**
                     * formula used
                     * (C1-C) X100/C1,
                     * (C2-C) X100/C2,
                     * (C3-C) X100/C3
                     * (C4-C) X100/C4
                     */
                    var recNo = i + 1;
                    const data = await dbCon.execute(`SELECT ROUND(ABS((ROUND(Eccent_ActualWt,${dp}) - 
                    (SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = 1))*100/(SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo})) ,${dp})AS Deviation,
                    CASE WHEN (SELECT (ROUND(ABS((ROUND(Eccent_ActualWt,${dp}) - (SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = 1))*100/(SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo})) ,${dp})) > 0.05) THEN 'Not Ok' ELSE 'Ok' END AS remark  
                    FROM
                   ${detailTableName}
                    WHERE
                    Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo}`);


                    const remarkData = data[0][0];
                    if (remarkData.remark == "Not Ok") {
                        count = count + 1;
                    }
                }
                if (count > 0) { finalVal = 'Not Complies'; } else { finalVal = 'Complies'; };
                return finalVal;
            }
            else {
                return "Data not Found"
            }
        }
        catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }
    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

}
module.exports = CalibrationModel