const date1 = require('date-and-time');
const moment = require('moment');
let now = new Date();
const GlobalProtocol = require('../../global/CalibrationProtocol')
const normaDate = require('../../middleware/setTimeZone');

const configFile = require('../../../../IncrencyV4DRLTSHConfig.json');
const globalData = require('../../global/globalData');
const dbCon = require('../../global/dbCon');
const FetchDetail = require('../clsFetchDetails.model');
const Database = require('../../database/clsQueryProcess');
const GlobalNomenclature = require('../../global/GLOBAL_NOMENCLATURE');
const clsHmi = require('../hmiDetail.model');
const clsCommCalib = require('../Calibration/clsCalibCommonFunction.model');
const models = require("../../../config/dbConnection").models;
var Comman = require('./clsCalibCommonFunction.model');
var comman = new Comman();


const objCommonCalib = new clsCommCalib();
const database = new Database();
const fetchDetails = new FetchDetail();
const objHmi = new clsHmi();
const { tbl_balance, tbl_calibration_periodic_master, tbl_balance_weights, tbl_calibration_periodic_master_incomplete, tbl_calibration_status,tbl_calibration_repetability_master_incomplete } = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize


exports.sortedSeqArray = async (arr, strBalId, balType) => {
    var present = await checkIfCalibrationPresent(strBalId);
    var newArry = [];

    //here manipulate accordig to monthly or yearly
    let calibTypeInGlbArr = globalData.arrCommonUsage.find(k => k.BalId == strBalId);
    let calibType = calibTypeInGlbArr.calibType;
    let isNewBal = calibTypeInGlbArr.isNewBal;
    let isPeriodic = calibTypeInGlbArr.isPeriodic;
    // const BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
    var BalanceRecalibStatusObject
    if (balType == "IPC Balance") {
        BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
    } else {
        BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
    }

    if (isNewBal) {
        const monthly = configFile.CalibSequence.monthly;
        const yearly = configFile.CalibSequence.yearly;
        const overallCalibSequence = monthly.concat(yearly);

        for (let obj of arr) {
            if (obj.key == "P") {
                arr.filter(k => k.key == "P")[0].value = 1;
            } else if (obj.key == "E") {
                arr.filter(k => k.key == "E")[0].value = 4;
            } else if (obj.key == "R") {
                arr.filter(k => k.key == "R")[0].value = 3;
            } else if (obj.key == "U") {
                arr.filter(k => k.key == "U")[0].value = 2;
            } else if (obj.key == "L") {
                arr.filter(k => k.key == "L")[0].value = 5;
            }
        }
        // arr = arr.filter(k => overallCalibSequence.some(el => el.includes(k.key)))
        // arr = arr.sort((k, j) => k.value - j.value)
        arr = overallCalibSequence
    } else if (BalanceRecalibStatusObject.PeriodicBalRecalib == 1) {
        let monthlyseqArr = configFile.CalibSequence.monthly
        arr = monthlyseqArr
    } else if (BalanceRecalibStatusObject.YearBalRecalib == 1 && !isPeriodic) {
        let yearlyseqArr = configFile.CalibSequence.yearly;
        arr = yearlyseqArr
    } else if (calibType == "monthly") {
        let monthlyseqArr = configFile.CalibSequence.monthly
        arr = monthlyseqArr
    } else if (calibType == "yearly" && !isPeriodic) {
        let yearlyseqArr = configFile.CalibSequence.yearly;
        arr = yearlyseqArr
    } else {
        if (isPeriodic) {
            let monthlyseqArr = configFile.CalibSequence.monthly
            arr = monthlyseqArr
        }
        console.log("no condition met in sequence")
    }

    // if(calibType == "monthly"){
    //     let monthlyseqArr = configFile.CalibSequence.monthly
    //     arr = monthlyseqArr

    // } else{
    //     let yearlyseqArr = configFile.CalibSequence.yearly;
    //     arr = yearlyseqArr
    // }
    for (let i = 0; i < arr.length; i++) {
        for (let j = 0; j < present.length; j++) {
            if (arr[i] == present[j]) {
                newArry.push(arr[i])
            }
        }
    }
    return newArry;
}


exports.checkIfLatestEntryResBal = async (BalId) => {
    // `SELECT * FROM `tbl_calibration_periodic_master` WHERE Periodic_RepNo = (SELECT MAX(Periodic_RepNo) AS Periodic_RepNo WHERE Periodic_BalID = 'TantraTest');`
    try {
        // console.log(`SELECT * FROM 'tbl_calibration_periodic_master' WHERE Periodic_RepNo = (SELECT MAX(Periodic_RepNo) AS Periodic_RepNo WHERE Periodic_BalID = '${BalId})'`)
        let res = await sequelize.query(`SELECT * 
        FROM tbl_calibration_periodic_master 
        WHERE Periodic_RepNo = (
            SELECT MAX(Periodic_RepNo) 
            FROM tbl_calibration_periodic_master 
            WHERE Periodic_BalID = '${BalId}'
        )`);
        
        if (res[0].length != 0) {
            return res[0][0].Periodic_CalbDate;
        } else {
            return 'no data';
        }

    } catch (err) {
        return err;
    }
}
/**
 * 
 * @param {*} IDSSrNo 
 * @description Function check if today is periodic calibration or not
 * True : Calibration Pending , False: Calibration Not Pending
 */
exports.checkIfTodayIsPeriodicCalib = async (strBalID, strHmi,TabIp) => {

    console.log(globalData.arrCommonUsage)
    console.log(await globalData.arrCommonUsage[0].reminder()(strBalID))
    let strMessage = await globalData.arrCommonUsage[0].reminder()(strBalID);
    let calibTypeInGlbArr = globalData.arrCommonUsage.find(k => k.BalId == strBalID);
    let res = await tbl_balance.findAll({
        where: {
            'Bal_ID': strBalID
        }
    });

    res = [[res[0]]]
    let hmiDetails = globalData.arr_Perform_Reminder_CalibDueDt.find(k => k.Hmi == strHmi&& k.TabIp == TabIp);

    await fetchDetails.getBalanceCalibDetails(strBalID, strHmi,TabIp)
    let tempCalib = globalData.arrBalCaibDet.find(k => k.strBalId == strBalID);
    var todayDate = moment().format('YYYY-MM-DD');
    let FindDate = todayDate.split('-')[2]
    var Reminder = res[0][0].Bal_CalbReminder
    var Duration = res[0][0].Bal_CalbDuration
    var PeriodicDate = res[0][0].Bal_CalbDueDt
    var monthPeriodic = PeriodicDate.split('-')[1]
    var ActualPeriodDate = PeriodicDate.split('-')[2]
    var RemainderDate = PeriodicDate.split('-')[2] - Reminder
    var ActualMonth = todayDate.split('-')[1];
    var PeriodMonth = PeriodicDate.split('-')[1]
    var CAlFindDate = ActualPeriodDate - FindDate
    PeriodMonth = Number(PeriodMonth) + Duration
    // var Isbetween = moment().isBetween(PeriodicDate, todayDate, 'days', false)
    // if (Number(ActualMonth) == PeriodMonth){\
    var CheckMinusValue = CAlFindDate.toString().includes("-")
    if (CheckMinusValue == undefined) {
        CheckMinusValue = false
    }


    // }
    if (res[0].length > 0) {
        const bln_storeType = res[0][0].Bal_CalbStoreType;
        var today = new Date();
        var month = today.getMonth();
        var year = today.getFullYear();
        var dateInUTC;

        // if (bln_storeType == 1) {
        //         // As in reminder calibration add month in date with due date only
        //         var date = new Date(res[0][0].Bal_CalbDueDt);
        //     } else {
        //         //current Date for other projects
        //         var date = new Date();
        //     }
        //     if(Duration != undefined){
        //         dateInUTC = new Date(date.setMonth(date.getMonth() + Duration));
        //     }
        //     else {
        //         //cheacking for cipla and mlveer for cipla date is start from current calibration 
        //         //date and mlver date is start from calibdue date 
        //         while (date <= today) {
        //             dateInUTC = new Date(date.setDate(date.getDate() + Duration));
        //         }
        //     }
        //     normalDate = await normaDate.convertDate(dateInUTC);

        if (bln_storeType == 1) // set days
        {
            // var todayDate = moment().format('YYYY-MM-DD');
            let calibDate = res[0][0].Bal_CalbDueDt;
            let yearlyCalibDate = res[0][0].Bal_CalbDueDtYear;
            const bln_isNewBal = res[0][0].IsNewBalance;

            if (bln_isNewBal == 1) {
                return { askPeriodic: true, calibMessage: "", calibType: '', isNewBal: true, isPeriodic: true, Due: false }
                //everytime return true if new balance
            }
            //calibDate = date1.format(calibDate, 'YYYY-MM-DD')
            // here we have to check if calibration is pending or done for this date
            let checkres = await checkPeriodicEntry(calibDate, strBalID);


            if (calibDate == todayDate) {
                calibTypeInGlbArr.isPeriodic = true
                return { askPeriodic: true, calibMessage: strMessage.msg, calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }
                // return true;
                // } if (calibDate <= todayDate && checkres.length == 0 && strMessage != "") {
            }
            if (calibDate <= todayDate && checkres.length == 0 && !tempCalib.isPeriodicDone) {
                // && strMessage.calibType == '' || strMessage.calibType == "monthly") 
                //30-12-21 <= 30-11-21 TRUE
                //1-12-22 <= 30-11-22
                if (calibDate <= todayDate) {

                    calibTypeInGlbArr.isPeriodic = true
                    return { askPeriodic: true, calibMessage: strMessage.msg, calibType: "", isNewBal: false, isPeriodic: true, Loss: true }
                } else {
                    calibTypeInGlbArr.isPeriodic = false
                    return { askPeriodic: true, calibMessage: strMessage.msg, calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }
                }

                // return true;
            } else if (strMessage.msg != "") {
                //reminder logic here if pending thn tell pending else tell ki ent to do or skip
                //
                // calibTypeInGlbArr.isPeriodic = false
                if (strMessage.calibType == "yearly") {
                    calibTypeInGlbArr.isPeriodic = false
                }
                return { askPeriodic: true, calibMessage: strMessage.msg, calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }
                //logic
                // return false;
            } else {
                if (yearlyCalibDate <= todayDate) {
                    calibTypeInGlbArr.calibType = "yearly"
                    calibTypeInGlbArr.isPeriodic = false
                    return { askPeriodic: true, calibMessage: "", calibType: "yearly", isNewBal: false, isPeriodic: false }
                } else {
                    calibTypeInGlbArr.isPeriodic = false
                    return { askPeriodic: false, calibMessage: "", calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }
                }

                // return false
            }
        } else {
            var DateReminder = Reminder
            var strBalId = strBalID
            var arr = res[0][0].Bal_CalbDates.split(',');
            var today = new Date();
            var todayDate = moment().format('YYYY-MM-DD');
            var month = today.getMonth() + 1;
            month = ("0" + month).slice(-2);
            var year = today.getFullYear();
            var arr_calibdates = []
            var count = 0;
            if (res[0][0].IsNewBalance == 1) {
                return { askPeriodic: true, calibMessage: "", calibType: '', isNewBal: true, isPeriodic: true, Due: false }
                //everytime return true if new balance
            }
            for (let d of arr) {
                count = count + 1;
                var day = ("0" + d).slice(-2)
                var date = '';
                date = year + '-' + month + '-' + day;
                let checkres = await checkPeriodicEntry(date, strBalId);
                // var remainderdate = date.split('-')[2] - DateReminder
                // var dateInUTC = moment()
                // var calibdate = moment(date)
                //     var  newdateInUTC = dateInUTC.set({'year':year,'date':remainderdate})
                //     var calculateddate = moment(newdateInUTC).format('YYYY-MM-DD');
                //     var diffdata = dateInUTC.diff(calibdate, 'days')
                //     if(diffdata == remainderdate){
                //     if(date <= todayDate || date <= calculateddate  ){

                //     }

                //     }

                if ((todayDate == date) && (checkres.length == 0)) {
                    // console.log('today match', date)
                    return { askPeriodic: true, calibMessage: "", calibType: "", isNewBal: false, isPeriodic: true, Loss: true }
                } else if (date <= todayDate && checkres.length == 0) {
                    let lastCalibDate = await this.checkIfLatestEntryResBal(strBalId);
                    lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD');
                    // console.log('yesterday', date)
                    if (lastCalibDate != 'no data') {
                        if (date > lastCalibDate) {
                            return { askPeriodic: true, calibMessage: "", calibType: "", isNewBal: false, isPeriodic: true, Loss: true }

                        } else {
                            continue;
                        }
                    } else {
                        continue;
                    }

                } else if (date <= todayDate && checkres.length < 1) {
                    if (date == todayDate && count == arr.length - 1) {
                        return { askPeriodic: false, calibMessage: "", calibType: "", isNewBal: false, isPeriodic: false, Loss: true }
                    }
                    else {
                        continue;
                    }
                }
                // else if (hmiDetails != undefined) {
                //     return { askPeriodic: true, calibMessage: strMessage.msg, calibType: "", isNewBal: false, isPeriodic: false, Loss: true }

                // }
                else {
                    // console.log('false codition', date);
                    continue;
                }
            }
            if (count == arr.length) {
                return { askPeriodic: false, calibMessage: "", calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }

            }
            return { askPeriodic: false, calibMessage: "", calibType: strMessage.calibType, isNewBal: false, isPeriodic: false }

        }
    } else {
        return `Bal ${sBalID} not found in tbl_balalnce`;;
    }


}

/************************** */
async function checkPeriodicEntry(calibDate, strBalId) {
    try {
        let res = await tbl_calibration_periodic_master.findAll({
            where: {
                'Periodic_BalID': strBalId,
                'Periodic_CalbDate': calibDate
            }
        });
        if (res.length >= 0) {
            return res
        }
        res = [[res[0]]]
        return res[0];
    } catch (error) {
        console.log(error)
    }


}

/****************************************************************************** */

exports.checkForPendingCalib = async (strBalId, strHmi, calibMessage, calibType, isNewBal, isPeriodic, Due, balType,TabIp) => {
    // below variable holds unsorted array
    var arr_sortedSequence = sortObject(globalData.arrCalibrationSequnce[0]);
    var arrResbPiNo = await objHmi.getResbPiNoFromHmi(strHmi);
    var strIdsNo = arrResbPiNo[0].DS_IP;

    var tempCubicInfo = globalData.arrIdsInfo.find(ids => ids.DsNo == strHmi && TabIp == TabIp);

    var objOwner = globalData.arrPreWeighCalibOwner.find(k => k.Hmi == strHmi&& TabIp == TabIp);

    var calibTable = 'tbl_calibration_status';
    var globalArray
    if (balType == 'analytical') {
        var calibTable = 'tbl_calibration_status';
        globalArray = "arrBalanceRecalibStatus"
    } else {
        var calibTable = 'tbl_calibration_status_bin';
        globalArray = "arrBalanceRecalibStatusIPC"
    }

    var calibarray = await checkIfCalibrationPresent(strBalId);
    var newArr = [];
    for (let i = 0; i < arr_sortedSequence.length; i++) {
        for (let j = 0; j < calibarray.length; j++) {
            if (arr_sortedSequence[i].key == calibarray[j] && arr_sortedSequence[i].value != 0) {
                newArr.push(arr_sortedSequence[i])
            }
        }
    }
    arr_sortedSequence = newArr; //P/E
    var tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);  //tbl_calibration_status
    // If calibration due today then get calibration status for required balance in calibrationStatus 
    // or it blank so
    // no for loop execution and it sends CR0
    const BalanceRecalibStatusObject = globalData[globalArray].find(k => k.Bal_ID == strBalId);
    var userd_data = globalData.arrUsers.find(k => k.Hmi == strHmi)
    var status_change = false
    // = await Check_change_Userfor_calib(arr_sortedSequence, tempCaibStatus, userd_data, strBalId)
    if (status_change) {
        tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);
    }
    let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi && TabIp == TabIp);

    /*
    here i have to manipulate tht seq from config file according to due dt..if periodic pending or yearly pending
    if periodic thn make p = 1; R = 2
    else if yearly thn P & R exclude
    th
    */

    //if isNeWBal then ask all set
    if (isNewBal) {
        const monthly = configFile.CalibSequence.monthly;
        const yearly = configFile.CalibSequence.yearly;
        const overallCalibSequence = monthly


        for (let obj of arr_sortedSequence) {
            if (obj.key == "P") {
                arr_sortedSequence.filter(k => k.key == "P")[0].value = 1;
            } else if (obj.key == "E") {
                arr_sortedSequence.filter(k => k.key == "E")[0].value = 4;
            } else if (obj.key == "R") {
                arr_sortedSequence.filter(k => k.key == "R")[0].value = 3;
            } else if (obj.key == "U") {
                arr_sortedSequence.filter(k => k.key == "U")[0].value = 2;
                // } else if (obj.key == "L") {
                //     arr_sortedSequence.filter(k => k.key == "L")[0].value = 5;
                // }
            }
        }
        arr_sortedSequence = arr_sortedSequence.filter(k => overallCalibSequence.some(el => el.includes(k.key)))
        arr_sortedSequence = arr_sortedSequence.sort((k, j) => k.value - j.value)
    } else if (BalanceRecalibStatusObject.PeriodicBalRecalib == 1) {
        const monthly = configFile.CalibSequence.monthly;
        arr_sortedSequence = arr_sortedSequence.filter(k => monthly.some(el => el.includes(k.key)))
        arr_sortedSequence = arr_sortedSequence
    } else if (calibType == "monthly") {
        const monthly = configFile.CalibSequence.monthly;
        arr_sortedSequence = arr_sortedSequence.filter(k => monthly.some(el => el.includes(k.key)))
        arr_sortedSequence = arr_sortedSequence
    } else {
        if (isPeriodic) {
            const monthly = configFile.CalibSequence.monthly;
            arr_sortedSequence = arr_sortedSequence.filter(k => monthly.some(el => el.includes(k.key)))
            arr_sortedSequence = arr_sortedSequence
        }
        console.log("no condition met in sequence")
    }

    //call tht function to reset calib
    var calib_predate = moment().subtract(1, 'day')
    calib_predate = moment(calib_predate).format('YYYY-MM-DD')
    var date = await tbl_calibration_periodic_master_incomplete.findAll({
        attributes: [[sequelize.fn('max', sequelize.col('Periodic_RepNo')), 'Periodic_RepNo']],
        where: {
            Periodic_BalID: strBalId,
            Periodic_CalbDate: calib_predate

        }
    })
    // if (status_change != true) {
    //     await objCommonCalib.resetCalib(strBalId)
    //   }

    for (i = 0; i < arr_sortedSequence.length; i++) {
        /**
         arr_sortedSequence[i].value == 0 means calibration is disabled(not required) for
         specific company hence check calibration for arr_sortedSequence[i].value != 0.
        */
        // console.log(arr_sortedSequence[i])
        if (arr_sortedSequence[i].value != 0) {
            // check for only those are pending // next will return control to calling procedure
            console.log("tempCaibStatusCheck", tempCaibStatus.status[arr_sortedSequence[i].key])
            if (tempCaibStatus.status[arr_sortedSequence[i].key] == 0) {
                switch (arr_sortedSequence[i].key) {
                    case 'P':

                        // Here we check if Calibration is done already for today or not  
                        await fetchDetails.getBalanceCalibDetails(strBalId, strHmi)
                        let tempCalib = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);

                        if (tempCalib.isPeriodicDone == true && BalanceRecalibStatusObject.PeriodicBalRecalib == 0) {
                            return GlobalProtocol.No;
                            //next();
                        } else {

                            var systemDate = new Date();
                            var systemHours = systemDate.getHours();
                            if (!isNewBal) {
                                let res = await tbl_calibration_periodic_master.findAll({
                                    where: {
                                        'Periodic_BalID': strBalId,
                                        'Periodic_CalbDate': moment(systemDate).format('YYYY-MM-DD')
                                    }
                                });
                                if (res.length == 0 && BalanceRecalibStatusObject.PeriodicBalRecalib == 0) {
                                    if (Due == true) {
                                        let res = await tbl_balance.findAll({
                                            where: {
                                                'Bal_ID': strBalId
                                            }
                                        });
                                        var date = res[0].Bal_CalbDueDt
                                        date = moment(date).format('DD-MM-YYYY')
                                        return `${GlobalNomenclature.Periodic} Calibration Pending Enter To Con Esc to Skip `;

                                    }
                                }
                            }
                            else {
                                if (isNewBal) {
                                    return `${GlobalNomenclature.Periodic} Calibration Pending`;
                                }
                            }


                            if (((calibMessage != "" && BalanceRecalibStatusObject.PeriodicBalRecalib != 1)) && (calibMessage.includes("Accuracy"))) {
                                return `${GlobalNomenclature.Periodic} Calibration Pending`;

                            }

                            return `${GlobalNomenclature.Periodic} Calibration Pending `;

                        }

                    case 'U':
                        if ((calibMessage != "" && BalanceRecalibStatusObject.PeriodicBalRecalib != 1) || (calibMessage.includes("Sensitivity"))) {
                            return `${calibMessage}`;

                        }
                        return `${GlobalNomenclature.Uncertainty} Calibration Pending`;
                    case 'R':

                        if ((calibMessage != "" && BalanceRecalibStatusObject.PeriodicBalRecalib != 1) && (calibMessage.includes("Linearity"))) {
                            return `${GlobalNomenclature.Repetability} Calibration Pending`;

                        }

                        return `${GlobalNomenclature.Repetability} Calibration Pending`;

                    case 'E':


                        if ((calibMessage != "" && BalanceRecalibStatusObject.PeriodicBalRecalib != 1) && (calibMessage.includes("Linearity"))) {
                            return `${GlobalNomenclature.Eccentricity} Calibration Pending , ENT to Continue, ESC to Skip`;

                        }
                        return `${GlobalNomenclature.Eccentricity} Calibration Pending `;
                    case 'L':
                        if (TempCalibType != undefined) {
                            TempCalibType.calibType = 'linearity';
                        } else {
                            globalData.arrcalibType.push({ DsNo: strHmi, TabIp:TabIp,calibType: 'linearity' })
                        }

                        if ((calibMessage != "" && BalanceRecalibStatusObject.PeriodicBalRecalib != 1) && (calibMessage.includes("Sensitivity"))) {
                            return `Linearity Pending , ENT to Continue, ESC to Skip`;

                        }
                        return `Linearity Pending `;
                    case 'V':
                        if (TempCalibType != undefined) {
                            TempCalibType.calibType = 'positional';
                        } else {
                            globalData.arrcalibType.push({ DsNo: strHmi, TabIp:TabIp,calibType: 'positional' })
                        }
                        return `CR0`;

                }
            }

        }
    }
    // If For loop fails means no calibraion pending control will shifted to here
    return GlobalProtocol.No;

}


function sortObject(obj) {
    var arr = [];
    for (var prop in obj) {
        if (obj.hasOwnProperty(prop)) {
            arr.push({
                'key': prop,
                'value': obj[prop]
            });
        }
    }
    arr.sort(function (a, b) { return a.value - b.value; });
    //arr.sort(function(a, b) { a.value.toLowerCase().localeCompare(b.value.toLowerCase()); }); //use this to sort as strings
    return arr; // returns array
}

/*********************************************************************** */
async function checkIfCalibrationPresent(strBalId) {

    let selectResult = await tbl_balance_weights.findAll({
        where: {
            "Bal_ID": strBalId
        }
    })

    selectResult = [selectResult]
    let array = [];
    for (let i = 0; i < selectResult[0].length; i++) {
        if (selectResult[0][i].Bal_Periodic == 1) {
            array.push('P');
        }
        if (selectResult[0][i].Bal_IsRepetability == 1) {
            array.push('E');
        }

        if (selectResult[0][i].Bal_IsEccentricity == 1) {
            array.push('R');
        }
        if (selectResult[0][i].Bal_IsUncertinity == 1) {
            array.push('U');
        }
        if (selectResult[0][i].Bal_Linearity == 1) {
            array.push('0');
        }

    }
    array = array.filter(function (item, pos, self) {
        return self.indexOf(item) == pos;
    })
    return array;


}
async function Check_change_Userfor_calib(arr_sortedSequence, tempCaibStatus, userd_data, strBalId) {
    var status = arr_sortedSequence
    var User_id = userd_data.UserId
    var User_Name = userd_data.UserName
    var Hmi = userd_data.Hmi
    var date = moment().format('YYYY-MM-DD');
    var calib_predate = moment().subtract(1, 'day')
    calib_predate = moment(calib_predate).format('YYYY-MM-DD')


    for (i = 0; i < status.length; i++) {
        if (tempCaibStatus.status[arr_sortedSequence[i].key] == 1) {
            switch (arr_sortedSequence[i].key) {
                case 'P':

                    let check_periodic = await tbl_calibration_periodic_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Periodic_UserID')), 'Periodic_UserID']],
                        where: {
                            Periodic_BalID: strBalId,
                            Periodic_CalbDate: date

                        }
                    })
                    check_periodic = check_periodic[0]
                    if (check_periodic.Periodic_UserID == null) {
                        let check_periodic_1 = await tbl_calibration_periodic_master_incomplete.findAll({
                            attributes: [[sequelize.fn('max', sequelize.col('Periodic_UserID')), 'Periodic_UserID']],
                            where: {
                                Periodic_BalID: strBalId,
                                Periodic_CalbDate: calib_predate

                            }
                        })
                        check_periodic = check_periodic_1[0]
                    }

                    if (check_periodic.Periodic_UserID != null) {
                        if (check_periodic.Periodic_UserID != User_id) {
                            await moveCalibrationIncompleteToFail(Hmi)
                            result = await tbl_calibration_status.update({
                                P: 0
                            }, {
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            result = await tbl_calibration_status.findOne({
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            const tempObj = {
                                P: result.P,
                                E: result.E,
                                R: result.R,
                                U: result.U,
                                L: result.L,
                                V: result.V
                            }
                            tempObj.P = result.P;
                            tempObj.E = result.E;
                            tempObj.R = result.R;
                            tempObj.U = result.U;
                            tempObj.L = result.L;
                            tempObj.V = result.V;

                            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
                            if (objFound == undefined) {
                                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
                            } else {
                                objFound.BalId = strBalId;
                                objFound.status = tempObj;
                                //hmi or  resbppi
                            }
                            let activity = ""
                            await models.tbl_activity_log.create({
                                'dt': moment().format('YYYY-MM-DD'),
                                'tm': moment().format('HH:mm:ss'),
                                'userid': User_id,
                                'username': User_Name,
                                'activity': `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_periodic.Periodic_UserID}`
                            })
                            return true;
                            // break;
                        }
                    }
                    return false

                case 'E':

                    let check_Eccent = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Eccent_UserID')), 'Eccent_UserID']],
                        where: {
                            Eccent_BalID: strBalId,
                            Eccent_CalbDate: date

                        }
                    })
                    check_Eccent = check_Eccent[0]
                    if (check_Eccent.Eccent_UserID == null) {
                        let check_Eccent_1 = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
                            attributes: [[sequelize.fn('max', sequelize.col('Eccent_UserID')), 'Eccent_UserID']],
                            where: {
                                Eccent_BalID: strBalId,
                                Eccent_CalbDate: calib_predate

                            }
                        })
                        check_Eccent = check_Eccent_1[0]
                    }
                    if (check_Eccent.Eccent_UserID != null) {
                        if (check_Eccent.Eccent_UserID != User_id) {
                            await moveCalibrationIncompleteToFail(Hmi)
                            result = await tbl_calibration_status.update({
                                E: 0
                            }, {
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            result = await tbl_calibration_status.findOne({
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            const tempObj = {
                                P: result.P,
                                E: result.E,
                                R: result.R,
                                U: result.U,
                                L: result.L,
                                V: result.V
                            }
                            tempObj.P = result.P;
                            tempObj.E = result.E;
                            tempObj.R = result.R;
                            tempObj.U = result.U;
                            tempObj.L = result.L;
                            tempObj.V = result.V;

                            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
                            if (objFound == undefined) {
                                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
                            } else {
                                objFound.BalId = strBalId;
                                objFound.status = tempObj;
                                //hmi or  resbppi
                            }
                            let activity = ""
                            await models.tbl_activity_log.create({
                                'dt': moment().format('YYYY-MM-DD'),
                                'tm': moment().format('HH:mm:ss'),
                                'userid': User_id,
                                'username': User_Name,
                                'activity': `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_Eccent.Eccent_UserID}`
                            })
                        }

                        return true;
                    }
                    return false
                case 'U':

                    let check_uncer = await models.tbl_calibration_uncertinity_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Uncertinity_UserID')), 'Uncertinity_UserID']],
                        where: {
                            Uncertinity_BalID: strBalId,
                            Uncertinity_CalbDate: date

                        }
                    })
                    check_uncer = check_uncer[0]
                    if (check_uncer.Uncertinity_UserID == null) {
                        let check_uncer_1 = await models.tbl_calibration_uncertinity_master_incomplete.findAll({
                            attributes: [[sequelize.fn('max', sequelize.col('Uncertinity_UserID')), 'Uncertinity_UserID']],
                            where: {
                                Uncertinity_BalID: strBalId,
                                Uncertinity_CalbDate: calib_predate

                            }
                        })
                        check_uncer_1 = check_uncer_1[0]
                    }
                    if (check_uncer.Uncertinity_UserID != null) {
                        if (check_uncer.Uncertinity_UserID != User_id) {
                            await moveCalibrationIncompleteToFail(Hmi)
                            result = await tbl_calibration_status.update({
                                E: 0
                            }, {
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            result = await tbl_calibration_status.findOne({
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            const tempObj = {
                                P: result.P,
                                E: result.E,
                                R: result.R,
                                U: result.U,
                                L: result.L,
                                V: result.V
                            }
                            tempObj.P = result.P;
                            tempObj.E = result.E;
                            tempObj.R = result.R;
                            tempObj.U = result.U;
                            tempObj.L = result.L;
                            tempObj.V = result.V;

                            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
                            if (objFound == undefined) {
                                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
                            } else {
                                objFound.BalId = strBalId;
                                objFound.status = tempObj;
                                //hmi or  resbppi
                            }
                            let activity = ""
                            await models.tbl_activity_log.create({
                                'dt': moment().format('YYYY-MM-DD'),
                                'tm': moment().format('HH:mm:ss'),
                                'userid': User_id,
                                'username': User_Name,
                                'activity': `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_uncer_1.Uncertinity_UserID}`
                            })
                        }

                        return true;
                    }
                    return false
                case 'R':

                    let check_Repeat = await tbl_calibration_repetability_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Repet_UserID')), 'Repet_UserID']],
                        where: {
                            Repet_BalID: strBalId,
                            Repet_CalbDate: date

                        }
                    })
                    check_Repeat = check_Repeat[0]
                    if (check_Repeat.Repet_UserID == null) {
                        let check_Repeat = await tbl_calibration_repetability_master_incomplete.findAll({
                            attributes: [[sequelize.fn('max', sequelize.col('Repet_UserID')), 'Repet_UserID']],
                            where: {
                                Repet_BalID: strBalId,
                                Repet_CalbDate: calib_predate

                            }
                        })
                        check_Repeat = check_Repeat[0]
                    }

                    if (check_Repeat.Repet_UserID != null) {
                        if (check_Repeat.Repet_UserID != User_id) {
                            await moveCalibrationIncompleteToFail(Hmi)
                            result = await tbl_calibration_status.update({
                                R: 0
                            }, {
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            result = await tbl_calibration_status.findOne({
                                where: {
                                    'BalID': strBalId
                                }
                            });
                            const tempObj = {
                                P: result.P,
                                E: result.E,
                                R: result.R,
                                U: result.U,
                                L: result.L,
                                V: result.V
                            }
                            tempObj.P = result.P;
                            tempObj.E = result.E;
                            tempObj.R = result.R;
                            tempObj.U = result.U;
                            tempObj.L = result.L;
                            tempObj.V = result.V;

                            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
                            if (objFound == undefined) {
                                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
                            } else {
                                objFound.BalId = strBalId;
                                objFound.status = tempObj;
                                //hmi or  resbppi
                            }
                            let activity = ""
                            await models.tbl_activity_log.create({
                                'dt': moment().format('YYYY-MM-DD'),
                                'tm': moment().format('HH:mm:ss'),
                                'userid': User_id,
                                'username': User_Name,
                                'activity': `Periodic Calibration Discarded on TSH ${Hmi} of user ${check_periodic.Periodic_UserID}`
                            })
                            return true;
                            // break;
                        }
                    }
                    return false

            }
        }
        // return false;
    }



}
async function moveCalibrationIncompleteToFail(strHmi) {
    try {

        //check bal connected..//take balid//fetch status
        //reset calib


        let strTableName, repNo, strColName, calibAlphabet, calibType;
        let strBalId, pendingMessage;
        const pendingCalib = globalData.glbArrListOfBalWithCalibPending.find(k => k.Hmi == strHmi);

        if (pendingCalib == undefined) {
            return
        }

        strBalId = pendingCalib.PendingCalibStatus[0].BalId
        pendingMessage = pendingCalib.PendingCalibStatus[0].Message;
        pendingMessage = pendingMessage.split(" ")[0];
        if (pendingMessage.includes("No")) {
            return
        }


        // const calibTypeArr = globalData.arrcalibType.find(k => k.Hmi == strHmi);
        // const selectedBal = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);

        // if (selectedBal != undefined) {
        //     var strBalId = selectedBal.selectedBal;
        // }

        // if (selectedBal == undefined) {

        //     console.log("return from moveCalibrationIncompleteToFail");
        //     return
        // }
        //get repNo from status table;
        let statusResp = await models.tbl_calibration_status.findOne({
            where: {
                BalID: strBalId
            }

        });

        let calibrepNo = statusResp.RepNo;


        let calibCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi)

        // if (calibCounter != undefined) {
        //     if (calibTypeArr != undefined) {
        // switch (calibTypeArr.calibType) {
        switch (pendingMessage.toLowerCase()) {
            case GlobalNomenclature.Periodic.toLowerCase():
                calibAlphabet = "P";
                // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
                strTableName = "tbl_calibration_periodic_master_incomplete"
                repNo = "Periodic_RepNo"
                strColName = "Periodic_BalID"
                calibType = "Monthly"
                break;
            case GlobalNomenclature.Eccentricity.toLowerCase():
                calibAlphabet = "E"
                // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
                strTableName = "tbl_calibration_eccentricity_master_incomplete"
                repNo = "Eccent_RepNo"
                strColName = "Eccent_BalID"
                calibType = "Monthly"
                break;
            case GlobalNomenclature.Uncertainty.toLowerCase():
                calibAlphabet = "U"
                // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
                strTableName = "tbl_calibration_uncertinity_master_incomplete"
                repNo = "Uncertinity_RepNo"
                strColName = "Uncertinity_BalID"
                calibType = "Yearly"
                break;
            case GlobalNomenclature.Repetability.toLowerCase():
                calibAlphabet = "R"
                // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
                strTableName = "tbl_calibration_repetability_master_incomplete"
                repNo = "Repet_RepNo"
                strColName = "Repet_BalID"
                calibType = "Monthly"
                break;
            case "Linearity".toLowerCase():
                calibAlphabet = "L"
                // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
                strTableName = "tbl_calibration_linearity_master_incomplete"
                repNo = "linear_RepNo"
                strColName = "linear_BalID"
                calibType = "Yearly"
                break;
            default:
                return
        }
        // if (calibCounter.counterApi != 0) {
        await comman.caibrationFails_differ(calibAlphabet, calibrepNo, strBalId, calibType, true)
        // }

        //     }
        // }



    } catch (error) {
        console.log(error)
        throw new Error(error)
    }
}


